/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.compare;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.compare.IContentChangeListener;
import org.eclipse.compare.IContentChangeNotifier;
import org.eclipse.compare.IStreamContentAccessor;
import org.eclipse.compare.internal.ContentChangeNotifier;
import org.eclipse.core.runtime.CoreException;

public abstract class BufferedContent
implements IContentChangeNotifier,
IStreamContentAccessor {
    byte[] fContent;
    private ContentChangeNotifier fChangeNotifier;

    protected BufferedContent() {
    }

    @Override
    public InputStream getContents() throws CoreException {
        if (this.fContent != null) {
            return new ByteArrayInputStream(this.fContent);
        }
        return this.createStream();
    }

    protected abstract InputStream createStream() throws CoreException;

    public void setContent(byte[] contents) {
        this.fContent = contents;
        this.fireContentChanged();
    }

    public byte[] getContent() {
        if (this.fContent == null) {
            try {
                Throwable throwable = null;
                Object var2_4 = null;
                try (InputStream is = this.createStream();){
                    this.fContent = is.readAllBytes();
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException | CoreException ex) {
                return null;
            }
        }
        return this.fContent;
    }

    public void discardBuffer() {
        this.fContent = null;
    }

    @Override
    public void addContentChangeListener(IContentChangeListener listener) {
        if (this.fChangeNotifier == null) {
            this.fChangeNotifier = new ContentChangeNotifier(this);
        }
        this.fChangeNotifier.addContentChangeListener(listener);
    }

    @Override
    public void removeContentChangeListener(IContentChangeListener listener) {
        if (this.fChangeNotifier != null) {
            this.fChangeNotifier.removeContentChangeListener(listener);
            if (this.fChangeNotifier.isEmpty()) {
                this.fChangeNotifier = null;
            }
        }
    }

    protected void fireContentChanged() {
        if (this.fChangeNotifier == null || this.fChangeNotifier.isEmpty()) {
            return;
        }
        this.fChangeNotifier.fireContentChanged();
    }
}

