/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.packet;

import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.MessageOrPresenceBuilder;
import org.jivesoftware.smack.packet.MessageView;
import org.jivesoftware.smack.packet.Stanza;
import org.jivesoftware.smack.packet.id.StanzaIdSource;
import org.jivesoftware.smack.util.StringUtils;
import org.jivesoftware.smack.util.ToStringUtil;

public final class MessageBuilder
extends MessageOrPresenceBuilder<Message, MessageBuilder>
implements MessageView {
    static final MessageBuilder EMPTY = new MessageBuilder(() -> null);
    Message.Type type;

    MessageBuilder(Message message, String stanzaId) {
        super((Stanza)message, stanzaId);
        this.copyFromMessage(message);
    }

    MessageBuilder(Message message, StanzaIdSource stanzaIdSource) {
        super((Stanza)message, stanzaIdSource);
        this.copyFromMessage(message);
    }

    MessageBuilder(StanzaIdSource stanzaIdSource) {
        super(stanzaIdSource);
    }

    MessageBuilder(String stanzaId) {
        super(stanzaId);
    }

    private void copyFromMessage(Message message) {
        this.type = message.getType();
    }

    @Override
    protected void addStanzaSpecificAttributes(ToStringUtil.Builder builder) {
        builder.addValue("type", (Object)this.type);
    }

    public MessageBuilder ofType(Message.Type type) {
        this.type = type;
        return this.getThis();
    }

    public MessageBuilder setThread(String thread) {
        return this.setThread(thread, null);
    }

    public MessageBuilder setThread(String thread, String parent) {
        this.addExtension(new Message.Thread(thread, parent));
        return this.getThis();
    }

    public MessageBuilder setSubject(String subject) {
        return this.addSubject(null, subject);
    }

    public MessageBuilder addSubject(String language2, String subject) {
        language2 = StringUtils.requireNullOrNotEmpty(language2, "language must be null or not empty");
        for (Message.Subject currentSubject : this.getExtensions(Message.Subject.class)) {
            if (!StringUtils.nullSafeCharSequenceEquals(language2, currentSubject.getLanguage())) continue;
            throw new IllegalArgumentException("Subject with the language " + language2 + " already exists");
        }
        Message.Subject messageSubject = new Message.Subject(language2, subject);
        this.addExtension(messageSubject);
        return this;
    }

    public MessageBuilder setBody(CharSequence body) {
        return this.setBody(body.toString());
    }

    public MessageBuilder setBody(String body) {
        return this.addBody(null, body);
    }

    public MessageBuilder addBody(String language2, String body) {
        language2 = StringUtils.requireNullOrNotEmpty(language2, "language must be null or not empty");
        for (Message.Body currentBody : this.getExtensions(Message.Body.class)) {
            if (!StringUtils.nullSafeCharSequenceEquals(language2, currentBody.getLanguage())) continue;
            throw new IllegalArgumentException("Bodyt with the language " + language2 + " already exists");
        }
        Message.Body messageBody = new Message.Body(language2, body);
        this.addExtension(messageBody);
        return this;
    }

    @Override
    public MessageBuilder getThis() {
        return this;
    }

    @Override
    public Message build() {
        return new Message(this);
    }

    @Override
    public Message.Type getType() {
        return this.type;
    }
}

