/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.packet.id;

import org.jivesoftware.smack.packet.id.StanzaIdSource;
import org.jivesoftware.smack.packet.id.StanzaIdSourceFactory;
import org.jivesoftware.smack.util.StringUtils;

public final class RandomStringStanzaIdSource {

    public static class Factory
    implements StanzaIdSourceFactory {
        private static final int REQUIRED_MIN_LENGTH = 10;
        private final int length;
        private final boolean verySecure;
        public static final Factory VERY_SECURE = new Factory(10, true);
        public static final Factory MEDIUM_SECURE = new Factory(10, false);

        public Factory(int length, boolean verySecure) {
            if (length < 10) {
                throw new IllegalArgumentException("Insufficient length " + length + ", must be at least 10");
            }
            this.length = length;
            this.verySecure = verySecure;
        }

        @Override
        public StanzaIdSource constructStanzaIdSource() {
            StanzaIdSource stanzaIdSource = this.verySecure ? () -> StringUtils.randomString(this.length) : () -> StringUtils.insecureRandomString(this.length);
            return stanzaIdSource;
        }
    }
}

