/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.formtypes;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.jivesoftware.smack.util.FileUtils;
import org.jivesoftware.smack.util.Objects;
import org.jivesoftware.smack.util.StringUtils;
import org.jivesoftware.smack.util.XmlUtil;
import org.jivesoftware.smack.xml.SmackXmlParser;
import org.jivesoftware.smack.xml.XmlPullParser;
import org.jivesoftware.smack.xml.XmlPullParserException;
import org.jivesoftware.smackx.xdata.FormField;
import org.jivesoftware.smackx.xdata.TextSingleFormField;
import org.jivesoftware.smackx.xdata.packet.DataForm;

public class FormFieldRegistry {
    private static final Logger LOGGER = Logger.getLogger(FormFieldRegistry.class.getName());
    private static final Map<String, Map<String, FormField.Type>> REGISTRY = new HashMap<String, Map<String, FormField.Type>>();
    private static final Map<String, FormField.Type> CLARK_NOTATION_FIELD_REGISTRY = new ConcurrentHashMap<String, FormField.Type>();
    private static final Map<String, FormField.Type> LOOKASIDE_FIELD_REGISTRY = new ConcurrentHashMap<String, FormField.Type>();
    private static int loadedFieldEntries;

    static int getLoadedFieldEntires() {
        return loadedFieldEntries;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static void loadFormFieldRegistryEntry(InputStream inputStream, String source) throws XmlPullParserException, IOException {
        XmlPullParser parser = SmackXmlParser.newXmlParser(inputStream);
        if (parser.nextTag() != XmlPullParser.TagEvent.START_ELEMENT) {
            throw new IllegalStateException();
        }
        String elementName = parser.getName();
        if (!elementName.equals("form_type")) {
            throw new IllegalStateException(source + " does not start with 'form_type' element but with " + elementName);
        }
        String formType = null;
        while (true) {
            XmlPullParser.Event eventType = parser.next();
            block0 : switch (eventType) {
                case START_ELEMENT: {
                    String name;
                    switch (name = parser.getName()) {
                        case "name": {
                            formType = parser.nextText();
                            if (formType.isEmpty()) {
                                throw new IllegalStateException();
                            }
                            break block0;
                        }
                        case "field": {
                            String fieldName = parser.getAttributeValue("var");
                            String typeString = parser.getAttributeValue("type");
                            FormField.Type type = FormField.Type.fromString(typeString);
                            if (formType == null) {
                                throw new IllegalStateException();
                            }
                            FormFieldRegistry.register(formType, fieldName, type);
                            ++loadedFieldEntries;
                            LOGGER.finer("Registered " + fieldName + " for form " + formType + " with type " + String.valueOf((Object)type) + " [" + source + "]");
                            break;
                        }
                    }
                    break;
                }
                case END_DOCUMENT: {
                    return;
                }
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private static void parseRegistryPath(XmlPullParser parser) throws IOException, XmlPullParserException {
        path = parser.getAttributeValue("path");
        if (path == null) {
            throw new IllegalStateException();
        }
        depth = parser.getDepth();
        block17: while (true) {
            eventType = parser.next();
            switch (1.$SwitchMap$org$jivesoftware$smack$xml$XmlPullParser$Event[eventType.ordinal()]) {
                case 1: {
                    var5_5 = name = parser.getName();
                    var6_6 = -1;
                    switch (var5_5.hashCode()) {
                        case 1711506700: {
                            if (!var5_5.equals("registry-file")) break;
                            var6_6 = 0;
                        }
                    }
                    switch (var6_6) {
                        case 0: {
                            filename = parser.getAttributeValue("name");
                            if (filename == null) {
                                throw new IllegalStateException();
                            }
                            filepath = path + "/" + filename;
                            try {
                                inputStream = FileUtils.getStreamForClasspathFile(filepath);
                                try {
                                    FormFieldRegistry.loadFormFieldRegistryEntry(inputStream, filepath);
                                    ** GOTO lbl38
                                }
                                finally {
                                    if (inputStream != null) {
                                        inputStream.close();
                                    }
                                }
                            }
                            catch (IOException e) {
                                FormFieldRegistry.LOGGER.log(Level.SEVERE, "Could not load " + filepath, e);
                                break;
                            }
                        }
                        default: {
                            throw new IllegalStateException("Unexpected element: " + name);
                        }
                    }
                    ** GOTO lbl38
                }
                case 3: {
                    if (parser.getDepth() == depth) break block17;
                }
lbl38:
                // 4 sources

                default: {
                    continue block17;
                }
            }
            break;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void loadFormFieldRegistryEntries() throws IOException, IllegalStateException, XmlPullParserException, URISyntaxException {
        URI formRegistryUrl = URI.create("classpath:org.igniterealtime.smack/xdata/form-registry/form-registry.xml");
        try (InputStream inputStream = FileUtils.getStreamForUri(formRegistryUrl, FormFieldRegistry.class.getClassLoader());){
            XmlPullParser parser = SmackXmlParser.newXmlParser(inputStream);
            if (parser.nextTag() != XmlPullParser.TagEvent.START_ELEMENT) {
                throw new IllegalStateException();
            }
            if (!parser.getQName().equals(new QName("https://igniterealtime.org/projects/smack", "form-registry"))) {
                throw new IllegalStateException();
            }
            while (true) {
                XmlPullParser.Event eventType = parser.next();
                block2 : switch (eventType) {
                    case START_ELEMENT: {
                        String name;
                        switch (name = parser.getName()) {
                            case "registry-path": {
                                FormFieldRegistry.parseRegistryPath(parser);
                                break block2;
                            }
                        }
                        throw new IllegalStateException("Unexpected element: " + name);
                    }
                    case END_DOCUMENT: {
                        return;
                    }
                }
            }
        }
    }

    public static void register(DataForm dataForm) {
        if (dataForm.getType() != DataForm.Type.form) {
            throw new IllegalArgumentException();
        }
        String formType = null;
        TextSingleFormField hiddenFormTypeField = dataForm.getHiddenFormTypeField();
        if (hiddenFormTypeField != null) {
            formType = hiddenFormTypeField.getValue();
        }
        for (FormField formField : dataForm.getFields()) {
            FormField.Type type;
            if (formField == hiddenFormTypeField || (type = formField.getType()) == FormField.Type.fixed) continue;
            String fieldName = formField.getFieldName();
            FormFieldRegistry.register(formType, fieldName, type);
        }
    }

    public static void register(String formType, FormField.Type fieldType, String ... fieldNames) {
        for (String fieldName : fieldNames) {
            FormFieldRegistry.register(formType, fieldName, fieldType);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void register(String formType, String fieldName, FormField.Type fieldType) {
        FormField.Type previousType;
        StringUtils.requireNotNullNorEmpty(fieldName, "fieldName must be provided");
        Objects.requireNonNull(fieldType);
        if (formType == null) {
            if (XmlUtil.isClarkNotation(fieldName)) {
                CLARK_NOTATION_FIELD_REGISTRY.put(fieldName, fieldType);
            }
            return;
        }
        Map<String, Map<String, FormField.Type>> map = REGISTRY;
        synchronized (map) {
            Map<String, FormField.Type> fieldNameToType = REGISTRY.get(formType);
            if (fieldNameToType == null) {
                fieldNameToType = new HashMap<String, FormField.Type>();
                REGISTRY.put(formType, fieldNameToType);
            } else {
                previousType = fieldNameToType.get(fieldName);
                if (previousType != null && previousType != fieldType) {
                    String message = "The field '" + fieldName + "' from form type '" + formType + "' was already registered with field type '" + String.valueOf((Object)previousType) + "' while it is now seen with type '" + String.valueOf((Object)fieldType) + "'. Form field types have to be unambigiously. XMPP uses a registry for form field tpes, scoped by the form type. You may find the correct value at https://xmpp.org/registrar/formtypes.html";
                    throw new IllegalArgumentException(message);
                }
            }
            previousType = fieldNameToType.put(fieldName, fieldType);
        }
        if (previousType != null && fieldType != previousType) {
            LOGGER.warning("Form field registry inconsitency detected: Registered field '" + fieldName + "' of type " + String.valueOf((Object)fieldType) + " but previous type was " + String.valueOf((Object)previousType));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FormField.Type lookup(String formType, String fieldName) {
        if (formType == null) {
            if (XmlUtil.isClarkNotation(fieldName)) {
                return CLARK_NOTATION_FIELD_REGISTRY.get(fieldName);
            }
            return LOOKASIDE_FIELD_REGISTRY.get(fieldName);
        }
        Map<String, Map<String, FormField.Type>> map = REGISTRY;
        synchronized (map) {
            FormField.Type type;
            Map<String, FormField.Type> fieldNameToTypeMap = REGISTRY.get(formType);
            if (fieldNameToTypeMap != null && (type = fieldNameToTypeMap.get(fieldName)) != null) {
                return type;
            }
        }
        return null;
    }

    public static synchronized FormField.Type lookup(String fieldName) {
        return FormFieldRegistry.lookup(null, fieldName);
    }

    public static void addLookasideFieldRegistryEntry(String fieldName, FormField.Type formFieldType) {
        LOOKASIDE_FIELD_REGISTRY.put(fieldName, formFieldType);
    }

    static {
        try {
            FormFieldRegistry.loadFormFieldRegistryEntries();
        }
        catch (IOException | IllegalStateException | URISyntaxException | XmlPullParserException e) {
            LOGGER.log(Level.SEVERE, "Failed to load form field registry entries", e);
        }
    }
}

