/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.workgroup.agent;

import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Set;
import org.jivesoftware.smackx.workgroup.QueueUser;
import org.jxmpp.jid.parts.Resourcepart;

public class WorkgroupQueue {
    private Resourcepart name;
    private Status status = Status.CLOSED;
    private int averageWaitTime = -1;
    private Date oldestEntry = null;
    private Set<QueueUser> users = Collections.emptySet();
    private int maxChats = 0;
    private int currentChats = 0;

    WorkgroupQueue(Resourcepart name) {
        this.name = name;
    }

    public Resourcepart getName() {
        return this.name;
    }

    public Status getStatus() {
        return this.status;
    }

    void setStatus(Status status) {
        this.status = status;
    }

    public int getUserCount() {
        if (this.users == null) {
            return 0;
        }
        return this.users.size();
    }

    public Iterator<QueueUser> getUsers() {
        if (this.users == null) {
            return new HashSet().iterator();
        }
        return Collections.unmodifiableSet(this.users).iterator();
    }

    void setUsers(Set<QueueUser> users) {
        this.users = users;
    }

    public int getAverageWaitTime() {
        return this.averageWaitTime;
    }

    void setAverageWaitTime(int averageTime) {
        this.averageWaitTime = averageTime;
    }

    public Date getOldestEntry() {
        return this.oldestEntry;
    }

    void setOldestEntry(Date oldestEntry) {
        this.oldestEntry = oldestEntry;
    }

    public int getMaxChats() {
        return this.maxChats;
    }

    void setMaxChats(int maxChats) {
        this.maxChats = maxChats;
    }

    public int getCurrentChats() {
        return this.currentChats;
    }

    void setCurrentChats(int currentChats) {
        this.currentChats = currentChats;
    }

    public static final class Status {
        public static final Status OPEN = new Status("open");
        public static final Status ACTIVE = new Status("active");
        public static final Status CLOSED = new Status("closed");
        private String value;

        public static Status fromString(String type) {
            if (type == null) {
                return null;
            }
            type = type.toLowerCase(Locale.US);
            if (OPEN.toString().equals(type)) {
                return OPEN;
            }
            if (ACTIVE.toString().equals(type)) {
                return ACTIVE;
            }
            if (CLOSED.toString().equals(type)) {
                return CLOSED;
            }
            return null;
        }

        private Status(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }
}

