/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.io.websocket.audio.internal;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.security.SecureRandom;
import org.eclipse.jdt.annotation.NonNullByDefault;

@NonNullByDefault
public final class PCMWebSocketStreamIdUtil {
    public static final int PACKET_HEADER_BYTE_LENGTH = 8;

    private PCMWebSocketStreamIdUtil() {
    }

    public static AudioPacketData parseAudioPacket(byte[] bytes) throws IOException {
        if (bytes.length < 8) {
            throw new IOException("Audio packet byte length is too small, invalid data.");
        }
        ByteBuffer byteBuffer = ByteBuffer.wrap(bytes).order(ByteOrder.LITTLE_ENDIAN);
        byte[] idBytes = new byte[]{byteBuffer.get(), byteBuffer.get()};
        int sampleRate = byteBuffer.getInt();
        byte bitDepth = byteBuffer.get();
        byte channels = byteBuffer.get();
        byte[] audioBytes = new byte[byteBuffer.remaining()];
        byteBuffer.get(audioBytes);
        return new AudioPacketData(idBytes, sampleRate, bitDepth, channels, audioBytes);
    }

    public static ByteBuffer generateAudioPacketHeader(int sampleRate, byte bitDepth, byte channels) {
        ByteBuffer byteBuffer = ByteBuffer.allocate(8).order(ByteOrder.LITTLE_ENDIAN);
        SecureRandom sr = new SecureRandom();
        byte[] rndBytes = new byte[2];
        sr.nextBytes(rndBytes);
        byteBuffer.put(rndBytes[0]);
        byteBuffer.put(rndBytes[1]);
        byteBuffer.putInt(sampleRate);
        byteBuffer.put(bitDepth);
        byteBuffer.put(channels);
        return byteBuffer;
    }

    public record AudioPacketData(byte[] id, int sampleRate, byte bitDepth, byte channels, byte[] audioData) {
    }
}

