/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.internal.library.unit;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.Set;
import java.util.function.Function;
import javax.measure.Unit;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.i18n.LocaleProvider;
import org.openhab.core.library.dimension.Currency;
import org.openhab.core.library.unit.CurrencyProvider;
import org.openhab.core.library.unit.CurrencyUnit;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={CurrencyProvider.class}, property={"service.pid=org.openhab.localebasedcurrency"})
@NonNullByDefault
public class LocaleBasedCurrencyProvider
implements CurrencyProvider {
    private final LocaleProvider localeProvider;

    @Activate
    public LocaleBasedCurrencyProvider(@Reference LocaleProvider localeProvider) {
        this.localeProvider = localeProvider;
    }

    @Override
    public Unit<Currency> getBaseCurrency() {
        String currencyCode = java.util.Currency.getInstance(this.localeProvider.getLocale()).getCurrencyCode();
        if (currencyCode != null) {
            String symbol = java.util.Currency.getInstance(currencyCode).getSymbol();
            return new CurrencyUnit(currencyCode, symbol);
        }
        return new CurrencyUnit("DEF", null);
    }

    @Override
    public Collection<Unit<Currency>> getAdditionalCurrencies() {
        return Set.of();
    }

    @Override
    public Function<Unit<Currency>, @Nullable BigDecimal> getExchangeRateFunction() {
        return unit -> null;
    }
}

