/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: k8s.io/metrics/pkg/apis/custom_metrics/v1beta1/generated.proto

package v1beta1

import (
	fmt "fmt"

	io "io"

	proto "github.com/gogo/protobuf/proto"
	v11 "k8s.io/apimachinery/pkg/apis/meta/v1"

	math "math"
	math_bits "math/bits"
	reflect "reflect"
	strings "strings"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.GoGoProtoPackageIsVersion3 // please upgrade the proto package

func (m *MetricListOptions) Reset()      { *m = MetricListOptions{} }
func (*MetricListOptions) ProtoMessage() {}
func (*MetricListOptions) Descriptor() ([]byte, []int) {
	return fileDescriptor_98fc7cab6d0de146, []int{0}
}
func (m *MetricListOptions) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *MetricListOptions) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalToSizedBuffer(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (m *MetricListOptions) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MetricListOptions.Merge(m, src)
}
func (m *MetricListOptions) XXX_Size() int {
	return m.Size()
}
func (m *MetricListOptions) XXX_DiscardUnknown() {
	xxx_messageInfo_MetricListOptions.DiscardUnknown(m)
}

var xxx_messageInfo_MetricListOptions proto.InternalMessageInfo

func (m *MetricValue) Reset()      { *m = MetricValue{} }
func (*MetricValue) ProtoMessage() {}
func (*MetricValue) Descriptor() ([]byte, []int) {
	return fileDescriptor_98fc7cab6d0de146, []int{1}
}
func (m *MetricValue) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *MetricValue) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalToSizedBuffer(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (m *MetricValue) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MetricValue.Merge(m, src)
}
func (m *MetricValue) XXX_Size() int {
	return m.Size()
}
func (m *MetricValue) XXX_DiscardUnknown() {
	xxx_messageInfo_MetricValue.DiscardUnknown(m)
}

var xxx_messageInfo_MetricValue proto.InternalMessageInfo

func (m *MetricValueList) Reset()      { *m = MetricValueList{} }
func (*MetricValueList) ProtoMessage() {}
func (*MetricValueList) Descriptor() ([]byte, []int) {
	return fileDescriptor_98fc7cab6d0de146, []int{2}
}
func (m *MetricValueList) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *MetricValueList) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalToSizedBuffer(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (m *MetricValueList) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MetricValueList.Merge(m, src)
}
func (m *MetricValueList) XXX_Size() int {
	return m.Size()
}
func (m *MetricValueList) XXX_DiscardUnknown() {
	xxx_messageInfo_MetricValueList.DiscardUnknown(m)
}

var xxx_messageInfo_MetricValueList proto.InternalMessageInfo

func init() {
	proto.RegisterType((*MetricListOptions)(nil), "k8s.io.metrics.pkg.apis.custom_metrics.v1beta1.MetricListOptions")
	proto.RegisterType((*MetricValue)(nil), "k8s.io.metrics.pkg.apis.custom_metrics.v1beta1.MetricValue")
	proto.RegisterType((*MetricValueList)(nil), "k8s.io.metrics.pkg.apis.custom_metrics.v1beta1.MetricValueList")
}

func init() {
	proto.RegisterFile("k8s.io/metrics/pkg/apis/custom_metrics/v1beta1/generated.proto", fileDescriptor_98fc7cab6d0de146)
}

var fileDescriptor_98fc7cab6d0de146 = []byte{
	// 605 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x94, 0x94, 0x4f, 0x4f, 0xd4, 0x4e,
	0x1c, 0xc6, 0xb7, 0xec, 0x6f, 0xc9, 0x32, 0xfc, 0x08, 0x32, 0xc4, 0xd8, 0x60, 0x52, 0xc8, 0x7a,
	0x41, 0x13, 0xa7, 0x01, 0x8d, 0x31, 0x21, 0xf1, 0xd0, 0x78, 0x31, 0x61, 0x25, 0x16, 0xa2, 0x89,
	0x7f, 0xa2, 0xd3, 0xe9, 0x97, 0x32, 0xb2, 0xed, 0x34, 0x9d, 0xe9, 0x12, 0x6e, 0xbe, 0x04, 0xdf,
	0x81, 0x6f, 0x87, 0x23, 0xde, 0x38, 0x11, 0xb7, 0xc6, 0xf7, 0x61, 0x3a, 0x9d, 0xee, 0x1f, 0x16,
	0x95, 0xbd, 0xb5, 0xd3, 0xe7, 0xf9, 0xcc, 0x33, 0xdf, 0x67, 0x52, 0xf4, 0xec, 0xf8, 0xa9, 0x24,
	0x5c, 0xb8, 0x31, 0xa8, 0x8c, 0x33, 0xe9, 0xa6, 0xc7, 0x91, 0x4b, 0x53, 0x2e, 0x5d, 0x96, 0x4b,
	0x25, 0xe2, 0x8f, 0xf5, 0x7a, 0x7f, 0x2b, 0x00, 0x45, 0xb7, 0xdc, 0x08, 0x12, 0xc8, 0xa8, 0x82,
	0x90, 0xa4, 0x99, 0x50, 0x02, 0x93, 0xca, 0x4f, 0x8c, 0x8e, 0xa4, 0xc7, 0x11, 0x29, 0xfd, 0x64,
	0xd2, 0x4f, 0x8c, 0x7f, 0xed, 0x61, 0xc4, 0xd5, 0x51, 0x1e, 0x10, 0x26, 0x62, 0x37, 0x12, 0x91,
	0x70, 0x35, 0x26, 0xc8, 0x0f, 0xf5, 0x9b, 0x7e, 0xd1, 0x4f, 0x15, 0x7e, 0xad, 0x63, 0xe2, 0xd1,
	0x94, 0xbb, 0x4c, 0x64, 0xe0, 0xf6, 0xa7, 0x22, 0xac, 0x3d, 0x1e, 0x69, 0x62, 0xca, 0x8e, 0x78,
	0x02, 0xd9, 0x69, 0x7d, 0x0e, 0x37, 0x03, 0x29, 0xf2, 0x8c, 0xc1, 0x4c, 0x2e, 0x59, 0x8e, 0x83,
	0x5e, 0xb7, 0x97, 0xfb, 0x27, 0x57, 0x96, 0x27, 0x8a, 0xc7, 0xd3, 0xdb, 0x3c, 0xf9, 0x97, 0x41,
	0xb2, 0x23, 0x88, 0xe9, 0x55, 0x5f, 0xe7, 0x9b, 0x85, 0x56, 0xba, 0x7a, 0x76, 0xbb, 0x5c, 0xaa,
	0xbd, 0x54, 0x71, 0x91, 0x48, 0xbc, 0x83, 0x96, 0x7a, 0x34, 0x80, 0xde, 0x3e, 0xf4, 0x80, 0x29,
	0x91, 0xd9, 0xd6, 0x86, 0xb5, 0xb9, 0xe0, 0xdd, 0x3e, 0xbb, 0x5c, 0x6f, 0x14, 0x97, 0xeb, 0x4b,
	0xbb, 0xe3, 0x1f, 0xfd, 0x49, 0x2d, 0xee, 0xa2, 0xd5, 0xaa, 0x8d, 0x09, 0x95, 0x3d, 0xa7, 0x11,
	0x77, 0x0d, 0x62, 0xb5, 0x3b, 0x2d, 0xf1, 0xaf, 0xf3, 0x75, 0x7e, 0x35, 0xd1, 0x62, 0x25, 0x7e,
	0x4d, 0x7b, 0x39, 0xe0, 0x43, 0xb4, 0x1c, 0x82, 0x64, 0x19, 0x0f, 0x20, 0xdc, 0x0b, 0x3e, 0x03,
	0x53, 0x3a, 0xdd, 0xe2, 0xf6, 0xbd, 0xfa, 0x8e, 0xd0, 0x94, 0x93, 0xb2, 0x44, 0xd2, 0xdf, 0x22,
	0x95, 0xc2, 0x87, 0x43, 0xc8, 0x20, 0x61, 0xe0, 0xdd, 0x31, 0xfb, 0x2f, 0x3f, 0x9f, 0x64, 0xf8,
	0x57, 0xa1, 0x78, 0x1b, 0xa1, 0x2a, 0xce, 0x4b, 0x1a, 0x83, 0x49, 0x8f, 0x8d, 0x1b, 0x75, 0x87,
	0x5f, 0xfc, 0x31, 0x15, 0x7e, 0x87, 0x16, 0xca, 0x61, 0x4b, 0x45, 0xe3, 0xd4, 0x6e, 0xea, 0x54,
	0x0f, 0xc6, 0x52, 0x0d, 0x9b, 0x19, 0x5d, 0xdf, 0xf2, 0x02, 0x94, 0x39, 0x0f, 0x78, 0x0c, 0xde,
	0x8a, 0xc1, 0x2f, 0x1c, 0xd4, 0x10, 0x7f, 0xc4, 0xc3, 0xf7, 0xd1, 0xfc, 0x09, 0x4f, 0x42, 0x71,
	0x62, 0xff, 0xb7, 0x61, 0x6d, 0x36, 0xbd, 0x95, 0xb2, 0x89, 0x37, 0x7a, 0x65, 0x1f, 0x98, 0x48,
	0x42, 0xe9, 0x1b, 0x01, 0xde, 0x47, 0xad, 0x7e, 0x39, 0x2c, 0xbb, 0xa5, 0x33, 0x90, 0xbf, 0x65,
	0x20, 0xf5, 0xd5, 0x25, 0xaf, 0x72, 0x9a, 0x28, 0xae, 0x4e, 0xbd, 0x25, 0x93, 0xa3, 0xa5, 0x27,
	0xee, 0x57, 0x2c, 0xfc, 0x01, 0xb5, 0x65, 0x5d, 0xe6, 0xbc, 0xe6, 0x3e, 0xba, 0xd9, 0xd9, 0x26,
	0xfa, 0xf4, 0xfe, 0x2f, 0x2e, 0xd7, 0xdb, 0xc3, 0xca, 0x87, 0xc8, 0xce, 0x77, 0x0b, 0x2d, 0x8f,
	0xf5, 0x5c, 0x5e, 0x47, 0xfc, 0x1e, 0xb5, 0x4b, 0x48, 0x48, 0x15, 0x35, 0x25, 0x93, 0x1b, 0x6e,
	0xc9, 0xa5, 0xea, 0x82, 0xa2, 0xde, 0x2d, 0x73, 0x94, 0x76, 0xbd, 0xe2, 0x0f, 0x89, 0xf8, 0x13,
	0x6a, 0x71, 0x05, 0xb1, 0xb4, 0xe7, 0x36, 0x9a, 0x9b, 0x8b, 0xdb, 0x3b, 0x33, 0xfe, 0x63, 0xc8,
	0x58, 0xda, 0xd1, 0xc8, 0x5e, 0x94, 0x44, 0xbf, 0x02, 0x7b, 0x07, 0x67, 0x03, 0xa7, 0x71, 0x3e,
	0x70, 0x1a, 0x17, 0x03, 0xa7, 0xf1, 0xa5, 0x70, 0xac, 0xb3, 0xc2, 0xb1, 0xce, 0x0b, 0xc7, 0xba,
	0x28, 0x1c, 0xeb, 0x47, 0xe1, 0x58, 0x5f, 0x7f, 0x3a, 0x8d, 0xb7, 0x64, 0xb6, 0x7f, 0xe3, 0xef,
	0x00, 0x00, 0x00, 0xff, 0xff, 0xca, 0x29, 0x1e, 0x18, 0x4c, 0x05, 0x00, 0x00,
}

func (m *MetricListOptions) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *MetricListOptions) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *MetricListOptions) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	i -= len(m.MetricLabelSelector)
	copy(dAtA[i:], m.MetricLabelSelector)
	i = encodeVarintGenerated(dAtA, i, uint64(len(m.MetricLabelSelector)))
	i--
	dAtA[i] = 0x12
	i -= len(m.LabelSelector)
	copy(dAtA[i:], m.LabelSelector)
	i = encodeVarintGenerated(dAtA, i, uint64(len(m.LabelSelector)))
	i--
	dAtA[i] = 0xa
	return len(dAtA) - i, nil
}

func (m *MetricValue) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *MetricValue) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *MetricValue) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.Selector != nil {
		{
			size, err := m.Selector.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintGenerated(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x32
	}
	{
		size, err := m.Value.MarshalToSizedBuffer(dAtA[:i])
		if err != nil {
			return 0, err
		}
		i -= size
		i = encodeVarintGenerated(dAtA, i, uint64(size))
	}
	i--
	dAtA[i] = 0x2a
	if m.WindowSeconds != nil {
		i = encodeVarintGenerated(dAtA, i, uint64(*m.WindowSeconds))
		i--
		dAtA[i] = 0x20
	}
	{
		size, err := m.Timestamp.MarshalToSizedBuffer(dAtA[:i])
		if err != nil {
			return 0, err
		}
		i -= size
		i = encodeVarintGenerated(dAtA, i, uint64(size))
	}
	i--
	dAtA[i] = 0x1a
	i -= len(m.MetricName)
	copy(dAtA[i:], m.MetricName)
	i = encodeVarintGenerated(dAtA, i, uint64(len(m.MetricName)))
	i--
	dAtA[i] = 0x12
	{
		size, err := m.DescribedObject.MarshalToSizedBuffer(dAtA[:i])
		if err != nil {
			return 0, err
		}
		i -= size
		i = encodeVarintGenerated(dAtA, i, uint64(size))
	}
	i--
	dAtA[i] = 0xa
	return len(dAtA) - i, nil
}

func (m *MetricValueList) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *MetricValueList) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *MetricValueList) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Items) > 0 {
		for iNdEx := len(m.Items) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Items[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintGenerated(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x12
		}
	}
	{
		size, err := m.ListMeta.MarshalToSizedBuffer(dAtA[:i])
		if err != nil {
			return 0, err
		}
		i -= size
		i = encodeVarintGenerated(dAtA, i, uint64(size))
	}
	i--
	dAtA[i] = 0xa
	return len(dAtA) - i, nil
}

func encodeVarintGenerated(dAtA []byte, offset int, v uint64) int {
	offset -= sovGenerated(v)
	base := offset
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return base
}
func (m *MetricListOptions) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.LabelSelector)
	n += 1 + l + sovGenerated(uint64(l))
	l = len(m.MetricLabelSelector)
	n += 1 + l + sovGenerated(uint64(l))
	return n
}

func (m *MetricValue) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = m.DescribedObject.Size()
	n += 1 + l + sovGenerated(uint64(l))
	l = len(m.MetricName)
	n += 1 + l + sovGenerated(uint64(l))
	l = m.Timestamp.Size()
	n += 1 + l + sovGenerated(uint64(l))
	if m.WindowSeconds != nil {
		n += 1 + sovGenerated(uint64(*m.WindowSeconds))
	}
	l = m.Value.Size()
	n += 1 + l + sovGenerated(uint64(l))
	if m.Selector != nil {
		l = m.Selector.Size()
		n += 1 + l + sovGenerated(uint64(l))
	}
	return n
}

func (m *MetricValueList) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = m.ListMeta.Size()
	n += 1 + l + sovGenerated(uint64(l))
	if len(m.Items) > 0 {
		for _, e := range m.Items {
			l = e.Size()
			n += 1 + l + sovGenerated(uint64(l))
		}
	}
	return n
}

func sovGenerated(x uint64) (n int) {
	return (math_bits.Len64(x|1) + 6) / 7
}
func sozGenerated(x uint64) (n int) {
	return sovGenerated(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (this *MetricListOptions) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&MetricListOptions{`,
		`LabelSelector:` + fmt.Sprintf("%v", this.LabelSelector) + `,`,
		`MetricLabelSelector:` + fmt.Sprintf("%v", this.MetricLabelSelector) + `,`,
		`}`,
	}, "")
	return s
}
func (this *MetricValue) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&MetricValue{`,
		`DescribedObject:` + strings.Replace(strings.Replace(fmt.Sprintf("%v", this.DescribedObject), "ObjectReference", "v1.ObjectReference", 1), `&`, ``, 1) + `,`,
		`MetricName:` + fmt.Sprintf("%v", this.MetricName) + `,`,
		`Timestamp:` + strings.Replace(strings.Replace(fmt.Sprintf("%v", this.Timestamp), "Time", "v11.Time", 1), `&`, ``, 1) + `,`,
		`WindowSeconds:` + valueToStringGenerated(this.WindowSeconds) + `,`,
		`Value:` + strings.Replace(strings.Replace(fmt.Sprintf("%v", this.Value), "Quantity", "resource.Quantity", 1), `&`, ``, 1) + `,`,
		`Selector:` + strings.Replace(fmt.Sprintf("%v", this.Selector), "LabelSelector", "v11.LabelSelector", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *MetricValueList) String() string {
	if this == nil {
		return "nil"
	}
	repeatedStringForItems := "[]MetricValue{"
	for _, f := range this.Items {
		repeatedStringForItems += strings.Replace(strings.Replace(f.String(), "MetricValue", "MetricValue", 1), `&`, ``, 1) + ","
	}
	repeatedStringForItems += "}"
	s := strings.Join([]string{`&MetricValueList{`,
		`ListMeta:` + strings.Replace(strings.Replace(fmt.Sprintf("%v", this.ListMeta), "ListMeta", "v11.ListMeta", 1), `&`, ``, 1) + `,`,
		`Items:` + repeatedStringForItems + `,`,
		`}`,
	}, "")
	return s
}
func valueToStringGenerated(v interface{}) string {
	rv := reflect.ValueOf(v)
	if rv.IsNil() {
		return "nil"
	}
	pv := reflect.Indirect(rv).Interface()
	return fmt.Sprintf("*%v", pv)
}
func (m *MetricListOptions) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowGenerated
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: MetricListOptions: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: MetricListOptions: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field LabelSelector", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthGenerated
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.LabelSelector = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field MetricLabelSelector", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthGenerated
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.MetricLabelSelector = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipGenerated(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthGenerated
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *MetricValue) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowGenerated
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: MetricValue: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: MetricValue: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DescribedObject", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthGenerated
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.DescribedObject.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field MetricName", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthGenerated
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.MetricName = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Timestamp", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthGenerated
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Timestamp.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field WindowSeconds", wireType)
			}
			var v int64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.WindowSeconds = &v
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Value", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthGenerated
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Value.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Selector", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthGenerated
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Selector == nil {
				m.Selector = &v11.LabelSelector{}
			}
			if err := m.Selector.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipGenerated(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthGenerated
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *MetricValueList) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowGenerated
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: MetricValueList: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: MetricValueList: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ListMeta", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthGenerated
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.ListMeta.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Items", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthGenerated
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Items = append(m.Items, MetricValue{})
			if err := m.Items[len(m.Items)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipGenerated(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthGenerated
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipGenerated(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	depth := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowGenerated
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
		case 1:
			iNdEx += 8
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if length < 0 {
				return 0, ErrInvalidLengthGenerated
			}
			iNdEx += length
		case 3:
			depth++
		case 4:
			if depth == 0 {
				return 0, ErrUnexpectedEndOfGroupGenerated
			}
			depth--
		case 5:
			iNdEx += 4
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
		if iNdEx < 0 {
			return 0, ErrInvalidLengthGenerated
		}
		if depth == 0 {
			return iNdEx, nil
		}
	}
	return 0, io.ErrUnexpectedEOF
}

var (
	ErrInvalidLengthGenerated        = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowGenerated          = fmt.Errorf("proto: integer overflow")
	ErrUnexpectedEndOfGroupGenerated = fmt.Errorf("proto: unexpected end of group")
)
