// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.

/// <p>Describes an Amazon S3 location that will receive the results of the restore request.</p>
#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::fmt::Debug)]
pub struct S3Location {
    /// <p>The name of the bucket where the restore results will be placed.</p>
    pub bucket_name: ::std::string::String,
    /// <p>The prefix that is prepended to the restore results for this request.</p>
    pub prefix: ::std::string::String,
    /// <p>Contains the type of server-side encryption used.</p>
    pub encryption: ::std::option::Option<crate::types::Encryption>,
    /// <p>The canned ACL to apply to the restore results.</p>
    pub canned_acl: ::std::option::Option<crate::types::ObjectCannedAcl>,
    /// <p>A list of grants that control access to the staged results.</p>
    pub access_control_list: ::std::option::Option<::std::vec::Vec<crate::types::Grant>>,
    /// <p>The tag-set that is applied to the restore results.</p>
    pub tagging: ::std::option::Option<crate::types::Tagging>,
    /// <p>A list of metadata to store with the restore results in S3.</p>
    pub user_metadata: ::std::option::Option<::std::vec::Vec<crate::types::MetadataEntry>>,
    /// <p>The class of storage used to store the restore results.</p>
    pub storage_class: ::std::option::Option<crate::types::StorageClass>,
}
impl S3Location {
    /// <p>The name of the bucket where the restore results will be placed.</p>
    pub fn bucket_name(&self) -> &str {
        use std::ops::Deref;
        self.bucket_name.deref()
    }
    /// <p>The prefix that is prepended to the restore results for this request.</p>
    pub fn prefix(&self) -> &str {
        use std::ops::Deref;
        self.prefix.deref()
    }
    /// <p>Contains the type of server-side encryption used.</p>
    pub fn encryption(&self) -> ::std::option::Option<&crate::types::Encryption> {
        self.encryption.as_ref()
    }
    /// <p>The canned ACL to apply to the restore results.</p>
    pub fn canned_acl(&self) -> ::std::option::Option<&crate::types::ObjectCannedAcl> {
        self.canned_acl.as_ref()
    }
    /// <p>A list of grants that control access to the staged results.</p>
    ///
    /// If no value was sent for this field, a default will be set. If you want to determine if no value was sent, use `.access_control_list.is_none()`.
    pub fn access_control_list(&self) -> &[crate::types::Grant] {
        self.access_control_list.as_deref().unwrap_or_default()
    }
    /// <p>The tag-set that is applied to the restore results.</p>
    pub fn tagging(&self) -> ::std::option::Option<&crate::types::Tagging> {
        self.tagging.as_ref()
    }
    /// <p>A list of metadata to store with the restore results in S3.</p>
    ///
    /// If no value was sent for this field, a default will be set. If you want to determine if no value was sent, use `.user_metadata.is_none()`.
    pub fn user_metadata(&self) -> &[crate::types::MetadataEntry] {
        self.user_metadata.as_deref().unwrap_or_default()
    }
    /// <p>The class of storage used to store the restore results.</p>
    pub fn storage_class(&self) -> ::std::option::Option<&crate::types::StorageClass> {
        self.storage_class.as_ref()
    }
}
impl S3Location {
    /// Creates a new builder-style object to manufacture [`S3Location`](crate::types::S3Location).
    pub fn builder() -> crate::types::builders::S3LocationBuilder {
        crate::types::builders::S3LocationBuilder::default()
    }
}

/// A builder for [`S3Location`](crate::types::S3Location).
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::default::Default, ::std::fmt::Debug)]
#[non_exhaustive]
pub struct S3LocationBuilder {
    pub(crate) bucket_name: ::std::option::Option<::std::string::String>,
    pub(crate) prefix: ::std::option::Option<::std::string::String>,
    pub(crate) encryption: ::std::option::Option<crate::types::Encryption>,
    pub(crate) canned_acl: ::std::option::Option<crate::types::ObjectCannedAcl>,
    pub(crate) access_control_list: ::std::option::Option<::std::vec::Vec<crate::types::Grant>>,
    pub(crate) tagging: ::std::option::Option<crate::types::Tagging>,
    pub(crate) user_metadata: ::std::option::Option<::std::vec::Vec<crate::types::MetadataEntry>>,
    pub(crate) storage_class: ::std::option::Option<crate::types::StorageClass>,
}
impl S3LocationBuilder {
    /// <p>The name of the bucket where the restore results will be placed.</p>
    /// This field is required.
    pub fn bucket_name(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.bucket_name = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>The name of the bucket where the restore results will be placed.</p>
    pub fn set_bucket_name(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.bucket_name = input;
        self
    }
    /// <p>The name of the bucket where the restore results will be placed.</p>
    pub fn get_bucket_name(&self) -> &::std::option::Option<::std::string::String> {
        &self.bucket_name
    }
    /// <p>The prefix that is prepended to the restore results for this request.</p>
    /// This field is required.
    pub fn prefix(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.prefix = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>The prefix that is prepended to the restore results for this request.</p>
    pub fn set_prefix(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.prefix = input;
        self
    }
    /// <p>The prefix that is prepended to the restore results for this request.</p>
    pub fn get_prefix(&self) -> &::std::option::Option<::std::string::String> {
        &self.prefix
    }
    /// <p>Contains the type of server-side encryption used.</p>
    pub fn encryption(mut self, input: crate::types::Encryption) -> Self {
        self.encryption = ::std::option::Option::Some(input);
        self
    }
    /// <p>Contains the type of server-side encryption used.</p>
    pub fn set_encryption(mut self, input: ::std::option::Option<crate::types::Encryption>) -> Self {
        self.encryption = input;
        self
    }
    /// <p>Contains the type of server-side encryption used.</p>
    pub fn get_encryption(&self) -> &::std::option::Option<crate::types::Encryption> {
        &self.encryption
    }
    /// <p>The canned ACL to apply to the restore results.</p>
    pub fn canned_acl(mut self, input: crate::types::ObjectCannedAcl) -> Self {
        self.canned_acl = ::std::option::Option::Some(input);
        self
    }
    /// <p>The canned ACL to apply to the restore results.</p>
    pub fn set_canned_acl(mut self, input: ::std::option::Option<crate::types::ObjectCannedAcl>) -> Self {
        self.canned_acl = input;
        self
    }
    /// <p>The canned ACL to apply to the restore results.</p>
    pub fn get_canned_acl(&self) -> &::std::option::Option<crate::types::ObjectCannedAcl> {
        &self.canned_acl
    }
    /// Appends an item to `access_control_list`.
    ///
    /// To override the contents of this collection use [`set_access_control_list`](Self::set_access_control_list).
    ///
    /// <p>A list of grants that control access to the staged results.</p>
    pub fn access_control_list(mut self, input: crate::types::Grant) -> Self {
        let mut v = self.access_control_list.unwrap_or_default();
        v.push(input);
        self.access_control_list = ::std::option::Option::Some(v);
        self
    }
    /// <p>A list of grants that control access to the staged results.</p>
    pub fn set_access_control_list(mut self, input: ::std::option::Option<::std::vec::Vec<crate::types::Grant>>) -> Self {
        self.access_control_list = input;
        self
    }
    /// <p>A list of grants that control access to the staged results.</p>
    pub fn get_access_control_list(&self) -> &::std::option::Option<::std::vec::Vec<crate::types::Grant>> {
        &self.access_control_list
    }
    /// <p>The tag-set that is applied to the restore results.</p>
    pub fn tagging(mut self, input: crate::types::Tagging) -> Self {
        self.tagging = ::std::option::Option::Some(input);
        self
    }
    /// <p>The tag-set that is applied to the restore results.</p>
    pub fn set_tagging(mut self, input: ::std::option::Option<crate::types::Tagging>) -> Self {
        self.tagging = input;
        self
    }
    /// <p>The tag-set that is applied to the restore results.</p>
    pub fn get_tagging(&self) -> &::std::option::Option<crate::types::Tagging> {
        &self.tagging
    }
    /// Appends an item to `user_metadata`.
    ///
    /// To override the contents of this collection use [`set_user_metadata`](Self::set_user_metadata).
    ///
    /// <p>A list of metadata to store with the restore results in S3.</p>
    pub fn user_metadata(mut self, input: crate::types::MetadataEntry) -> Self {
        let mut v = self.user_metadata.unwrap_or_default();
        v.push(input);
        self.user_metadata = ::std::option::Option::Some(v);
        self
    }
    /// <p>A list of metadata to store with the restore results in S3.</p>
    pub fn set_user_metadata(mut self, input: ::std::option::Option<::std::vec::Vec<crate::types::MetadataEntry>>) -> Self {
        self.user_metadata = input;
        self
    }
    /// <p>A list of metadata to store with the restore results in S3.</p>
    pub fn get_user_metadata(&self) -> &::std::option::Option<::std::vec::Vec<crate::types::MetadataEntry>> {
        &self.user_metadata
    }
    /// <p>The class of storage used to store the restore results.</p>
    pub fn storage_class(mut self, input: crate::types::StorageClass) -> Self {
        self.storage_class = ::std::option::Option::Some(input);
        self
    }
    /// <p>The class of storage used to store the restore results.</p>
    pub fn set_storage_class(mut self, input: ::std::option::Option<crate::types::StorageClass>) -> Self {
        self.storage_class = input;
        self
    }
    /// <p>The class of storage used to store the restore results.</p>
    pub fn get_storage_class(&self) -> &::std::option::Option<crate::types::StorageClass> {
        &self.storage_class
    }
    /// Consumes the builder and constructs a [`S3Location`](crate::types::S3Location).
    /// This method will fail if any of the following fields are not set:
    /// - [`bucket_name`](crate::types::builders::S3LocationBuilder::bucket_name)
    /// - [`prefix`](crate::types::builders::S3LocationBuilder::prefix)
    pub fn build(self) -> ::std::result::Result<crate::types::S3Location, ::aws_smithy_types::error::operation::BuildError> {
        ::std::result::Result::Ok(crate::types::S3Location {
            bucket_name: self.bucket_name.ok_or_else(|| {
                ::aws_smithy_types::error::operation::BuildError::missing_field(
                    "bucket_name",
                    "bucket_name was not specified but it is required when building S3Location",
                )
            })?,
            prefix: self.prefix.ok_or_else(|| {
                ::aws_smithy_types::error::operation::BuildError::missing_field(
                    "prefix",
                    "prefix was not specified but it is required when building S3Location",
                )
            })?,
            encryption: self.encryption,
            canned_acl: self.canned_acl,
            access_control_list: self.access_control_list,
            tagging: self.tagging,
            user_metadata: self.user_metadata,
            storage_class: self.storage_class,
        })
    }
}
