package adb

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeDBClusterNetInfo invokes the adb.DescribeDBClusterNetInfo API synchronously
func (client *Client) DescribeDBClusterNetInfo(request *DescribeDBClusterNetInfoRequest) (response *DescribeDBClusterNetInfoResponse, err error) {
	response = CreateDescribeDBClusterNetInfoResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeDBClusterNetInfoWithChan invokes the adb.DescribeDBClusterNetInfo API asynchronously
func (client *Client) DescribeDBClusterNetInfoWithChan(request *DescribeDBClusterNetInfoRequest) (<-chan *DescribeDBClusterNetInfoResponse, <-chan error) {
	responseChan := make(chan *DescribeDBClusterNetInfoResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeDBClusterNetInfo(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeDBClusterNetInfoWithCallback invokes the adb.DescribeDBClusterNetInfo API asynchronously
func (client *Client) DescribeDBClusterNetInfoWithCallback(request *DescribeDBClusterNetInfoRequest, callback func(response *DescribeDBClusterNetInfoResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeDBClusterNetInfoResponse
		var err error
		defer close(result)
		response, err = client.DescribeDBClusterNetInfo(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeDBClusterNetInfoRequest is the request struct for api DescribeDBClusterNetInfo
type DescribeDBClusterNetInfoRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	DBClusterId          string           `position:"Query" name:"DBClusterId"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
}

// DescribeDBClusterNetInfoResponse is the response struct for api DescribeDBClusterNetInfo
type DescribeDBClusterNetInfoResponse struct {
	*responses.BaseResponse
	RequestId          string                          `json:"RequestId" xml:"RequestId"`
	ClusterNetworkType string                          `json:"ClusterNetworkType" xml:"ClusterNetworkType"`
	Items              ItemsInDescribeDBClusterNetInfo `json:"Items" xml:"Items"`
}

// CreateDescribeDBClusterNetInfoRequest creates a request to invoke DescribeDBClusterNetInfo API
func CreateDescribeDBClusterNetInfoRequest() (request *DescribeDBClusterNetInfoRequest) {
	request = &DescribeDBClusterNetInfoRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("adb", "2019-03-15", "DescribeDBClusterNetInfo", "ads", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeDBClusterNetInfoResponse creates a response to parse from DescribeDBClusterNetInfo response
func CreateDescribeDBClusterNetInfoResponse() (response *DescribeDBClusterNetInfoResponse) {
	response = &DescribeDBClusterNetInfoResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
