package companyreg

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// StartBackToBackCall invokes the companyreg.StartBackToBackCall API synchronously
func (client *Client) StartBackToBackCall(request *StartBackToBackCallRequest) (response *StartBackToBackCallResponse, err error) {
	response = CreateStartBackToBackCallResponse()
	err = client.DoAction(request, response)
	return
}

// StartBackToBackCallWithChan invokes the companyreg.StartBackToBackCall API asynchronously
func (client *Client) StartBackToBackCallWithChan(request *StartBackToBackCallRequest) (<-chan *StartBackToBackCallResponse, <-chan error) {
	responseChan := make(chan *StartBackToBackCallResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.StartBackToBackCall(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// StartBackToBackCallWithCallback invokes the companyreg.StartBackToBackCall API asynchronously
func (client *Client) StartBackToBackCallWithCallback(request *StartBackToBackCallRequest, callback func(response *StartBackToBackCallResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *StartBackToBackCallResponse
		var err error
		defer close(result)
		response, err = client.StartBackToBackCall(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// StartBackToBackCallRequest is the request struct for api StartBackToBackCall
type StartBackToBackCallRequest struct {
	*requests.RpcRequest
	BizType          string           `position:"Query" name:"BizType"`
	Caller           string           `position:"Query" name:"Caller"`
	CallCenterNumber string           `position:"Query" name:"CallCenterNumber"`
	SkillType        requests.Integer `position:"Query" name:"SkillType"`
	BizId            string           `position:"Query" name:"BizId"`
}

// StartBackToBackCallResponse is the response struct for api StartBackToBackCall
type StartBackToBackCallResponse struct {
	*responses.BaseResponse
	ErrorMsg  string `json:"ErrorMsg" xml:"ErrorMsg"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	ErrorCode string `json:"ErrorCode" xml:"ErrorCode"`
	Success   bool   `json:"Success" xml:"Success"`
	Data      bool   `json:"Data" xml:"Data"`
}

// CreateStartBackToBackCallRequest creates a request to invoke StartBackToBackCall API
func CreateStartBackToBackCallRequest() (request *StartBackToBackCallRequest) {
	request = &StartBackToBackCallRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("companyreg", "2020-03-06", "StartBackToBackCall", "", "")
	request.Method = requests.POST
	return
}

// CreateStartBackToBackCallResponse creates a response to parse from StartBackToBackCall response
func CreateStartBackToBackCallResponse() (response *StartBackToBackCallResponse) {
	response = &StartBackToBackCallResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
