package ddospro

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyDomainProxy invokes the ddospro.ModifyDomainProxy API synchronously
// api document: https://help.aliyun.com/api/ddospro/modifydomainproxy.html
func (client *Client) ModifyDomainProxy(request *ModifyDomainProxyRequest) (response *ModifyDomainProxyResponse, err error) {
	response = CreateModifyDomainProxyResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyDomainProxyWithChan invokes the ddospro.ModifyDomainProxy API asynchronously
// api document: https://help.aliyun.com/api/ddospro/modifydomainproxy.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ModifyDomainProxyWithChan(request *ModifyDomainProxyRequest) (<-chan *ModifyDomainProxyResponse, <-chan error) {
	responseChan := make(chan *ModifyDomainProxyResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyDomainProxy(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyDomainProxyWithCallback invokes the ddospro.ModifyDomainProxy API asynchronously
// api document: https://help.aliyun.com/api/ddospro/modifydomainproxy.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ModifyDomainProxyWithCallback(request *ModifyDomainProxyRequest, callback func(response *ModifyDomainProxyResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyDomainProxyResponse
		var err error
		defer close(result)
		response, err = client.ModifyDomainProxy(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyDomainProxyRequest is the request struct for api ModifyDomainProxy
type ModifyDomainProxyRequest struct {
	*requests.RpcRequest
	ResourceOwnerId requests.Integer `position:"Query" name:"ResourceOwnerId"`
	Domain          string           `position:"Query" name:"Domain"`
	ProxyType       *[]string        `position:"Query" name:"ProxyType"  type:"Repeated"`
}

// ModifyDomainProxyResponse is the response struct for api ModifyDomainProxy
type ModifyDomainProxyResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateModifyDomainProxyRequest creates a request to invoke ModifyDomainProxy API
func CreateModifyDomainProxyRequest() (request *ModifyDomainProxyRequest) {
	request = &ModifyDomainProxyRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("DDoSPro", "2017-07-25", "ModifyDomainProxy", "", "")
	return
}

// CreateModifyDomainProxyResponse creates a response to parse from ModifyDomainProxy response
func CreateModifyDomainProxyResponse() (response *ModifyDomainProxyResponse) {
	response = &ModifyDomainProxyResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
