package eas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListServiceInstances invokes the eas.ListServiceInstances API synchronously
func (client *Client) ListServiceInstances(request *ListServiceInstancesRequest) (response *ListServiceInstancesResponse, err error) {
	response = CreateListServiceInstancesResponse()
	err = client.DoAction(request, response)
	return
}

// ListServiceInstancesWithChan invokes the eas.ListServiceInstances API asynchronously
func (client *Client) ListServiceInstancesWithChan(request *ListServiceInstancesRequest) (<-chan *ListServiceInstancesResponse, <-chan error) {
	responseChan := make(chan *ListServiceInstancesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListServiceInstances(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListServiceInstancesWithCallback invokes the eas.ListServiceInstances API asynchronously
func (client *Client) ListServiceInstancesWithCallback(request *ListServiceInstancesRequest, callback func(response *ListServiceInstancesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListServiceInstancesResponse
		var err error
		defer close(result)
		response, err = client.ListServiceInstances(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListServiceInstancesRequest is the request struct for api ListServiceInstances
type ListServiceInstancesRequest struct {
	*requests.RoaRequest
	PageSize    requests.Integer `position:"Query" name:"PageSize"`
	ServiceName string           `position:"Path" name:"ServiceName"`
	ClusterId   string           `position:"Path" name:"ClusterId"`
	PageNumber  requests.Integer `position:"Query" name:"PageNumber"`
}

// ListServiceInstancesResponse is the response struct for api ListServiceInstances
type ListServiceInstancesResponse struct {
	*responses.BaseResponse
}

// CreateListServiceInstancesRequest creates a request to invoke ListServiceInstances API
func CreateListServiceInstancesRequest() (request *ListServiceInstancesRequest) {
	request = &ListServiceInstancesRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("eas", "2021-07-01", "ListServiceInstances", "/api/v2/services/[ClusterId]/[ServiceName]/instances", "eas", "openAPI")
	request.Method = requests.GET
	return
}

// CreateListServiceInstancesResponse creates a response to parse from ListServiceInstances response
func CreateListServiceInstancesResponse() (response *ListServiceInstancesResponse) {
	response = &ListServiceInstancesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
