package retailcloud

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteSlbAP invokes the retailcloud.DeleteSlbAP API synchronously
func (client *Client) DeleteSlbAP(request *DeleteSlbAPRequest) (response *DeleteSlbAPResponse, err error) {
	response = CreateDeleteSlbAPResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteSlbAPWithChan invokes the retailcloud.DeleteSlbAP API asynchronously
func (client *Client) DeleteSlbAPWithChan(request *DeleteSlbAPRequest) (<-chan *DeleteSlbAPResponse, <-chan error) {
	responseChan := make(chan *DeleteSlbAPResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteSlbAP(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteSlbAPWithCallback invokes the retailcloud.DeleteSlbAP API asynchronously
func (client *Client) DeleteSlbAPWithCallback(request *DeleteSlbAPRequest, callback func(response *DeleteSlbAPResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteSlbAPResponse
		var err error
		defer close(result)
		response, err = client.DeleteSlbAP(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteSlbAPRequest is the request struct for api DeleteSlbAP
type DeleteSlbAPRequest struct {
	*requests.RpcRequest
	SlbAPId requests.Integer `position:"Query" name:"SlbAPId"`
}

// DeleteSlbAPResponse is the response struct for api DeleteSlbAP
type DeleteSlbAPResponse struct {
	*responses.BaseResponse
	Code      int    `json:"Code" xml:"Code"`
	ErrMsg    string `json:"ErrMsg" xml:"ErrMsg"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
}

// CreateDeleteSlbAPRequest creates a request to invoke DeleteSlbAP API
func CreateDeleteSlbAPRequest() (request *DeleteSlbAPRequest) {
	request = &DeleteSlbAPRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("retailcloud", "2018-03-13", "DeleteSlbAP", "", "")
	request.Method = requests.POST
	return
}

// CreateDeleteSlbAPResponse creates a response to parse from DeleteSlbAP response
func CreateDeleteSlbAPResponse() (response *DeleteSlbAPResponse) {
	response = &DeleteSlbAPResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
