package vcs

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateDevice invokes the vcs.UpdateDevice API synchronously
func (client *Client) UpdateDevice(request *UpdateDeviceRequest) (response *UpdateDeviceResponse, err error) {
	response = CreateUpdateDeviceResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateDeviceWithChan invokes the vcs.UpdateDevice API asynchronously
func (client *Client) UpdateDeviceWithChan(request *UpdateDeviceRequest) (<-chan *UpdateDeviceResponse, <-chan error) {
	responseChan := make(chan *UpdateDeviceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateDevice(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateDeviceWithCallback invokes the vcs.UpdateDevice API asynchronously
func (client *Client) UpdateDeviceWithCallback(request *UpdateDeviceRequest, callback func(response *UpdateDeviceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateDeviceResponse
		var err error
		defer close(result)
		response, err = client.UpdateDevice(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateDeviceRequest is the request struct for api UpdateDevice
type UpdateDeviceRequest struct {
	*requests.RpcRequest
	DeviceSite       string `position:"Body" name:"DeviceSite"`
	CorpId           string `position:"Body" name:"CorpId"`
	GbId             string `position:"Body" name:"GbId"`
	BitRate          string `position:"Body" name:"BitRate"`
	DeviceDirection  string `position:"Body" name:"DeviceDirection"`
	DeviceAddress    string `position:"Body" name:"DeviceAddress"`
	DeviceType       string `position:"Body" name:"DeviceType"`
	DeviceResolution string `position:"Body" name:"DeviceResolution"`
	Vendor           string `position:"Body" name:"Vendor"`
	DeviceName       string `position:"Body" name:"DeviceName"`
}

// UpdateDeviceResponse is the response struct for api UpdateDevice
type UpdateDeviceResponse struct {
	*responses.BaseResponse
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      string `json:"Data" xml:"Data"`
}

// CreateUpdateDeviceRequest creates a request to invoke UpdateDevice API
func CreateUpdateDeviceRequest() (request *UpdateDeviceRequest) {
	request = &UpdateDeviceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Vcs", "2020-05-15", "UpdateDevice", "", "")
	request.Method = requests.POST
	return
}

// CreateUpdateDeviceResponse creates a response to parse from UpdateDevice response
func CreateUpdateDeviceResponse() (response *UpdateDeviceResponse) {
	response = &UpdateDeviceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
