/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql.model;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.postgresql.PostgreUtils;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDataSource;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreSchema;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTableBase;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPQualifiedObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.edit.DBEPersistAction;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.impl.struct.RelationalObjectType;
import org.jkiss.dbeaver.model.meta.IPropertyCacheValidator;
import org.jkiss.dbeaver.model.meta.IPropertyValueValidator;
import org.jkiss.dbeaver.model.meta.LazyProperty;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.meta.PropertyGroup;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.dbeaver.model.struct.DBSEntityType;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectType;
import org.jkiss.dbeaver.model.struct.rdb.DBSSequence;
import org.jkiss.dbeaver.model.struct.rdb.DBSTableIndex;
import org.jkiss.utils.CommonUtils;

public class PostgreSequence
extends PostgreTableBase
implements DBSSequence,
DBPQualifiedObject {
    private static final Log log = Log.getLog(PostgreSequence.class);
    private final AdditionalInfo additionalInfo = new AdditionalInfo();

    public PostgreSequence(PostgreSchema schema, JDBCResultSet dbResult) {
        super(schema, (ResultSet)dbResult);
    }

    public PostgreSequence(PostgreSchema catalog) {
        super(catalog);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PropertyGroup
    @LazyProperty(cacheValidator=AdditionalInfoValidator.class)
    public AdditionalInfo getAdditionalInfo(DBRProgressMonitor monitor) throws DBCException {
        AdditionalInfo additionalInfo = this.additionalInfo;
        synchronized (additionalInfo) {
            if (!this.additionalInfo.loaded) {
                this.loadAdditionalInfo(monitor);
            }
            return this.additionalInfo;
        }
    }

    protected AdditionalInfo getAdditionalInfo() {
        return this.additionalInfo;
    }

    public void loadAdditionalInfo(DBRProgressMonitor monitor) {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (JDBCSession session = (JDBCSession)DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBSObject)this, (String)"Load sequence additional info");){
                block50: {
                    if (((PostgreDataSource)this.getDataSource()).isServerVersionAtLeast(10, 0)) {
                        Throwable throwable2 = null;
                        Object var6_12 = null;
                        try (JDBCPreparedStatement dbSeqStat = session.prepareStatement("SELECT * from pg_catalog.pg_sequences WHERE schemaname=? AND sequencename=?");){
                            dbSeqStat.setString(1, this.getSchema().getName());
                            dbSeqStat.setString(2, this.getName());
                            Throwable throwable3 = null;
                            Object var9_22 = null;
                            try (JDBCResultSet seqResults = dbSeqStat.executeQuery();){
                                if (seqResults.next()) {
                                    this.additionalInfo.startValue = JDBCUtils.safeGetLong((ResultSet)seqResults, (String)"start_value");
                                    this.additionalInfo.lastValue = JDBCUtils.safeGetLongNullable((ResultSet)seqResults, (String)"last_value");
                                    this.additionalInfo.minValue = JDBCUtils.safeGetLong((ResultSet)seqResults, (String)"min_value");
                                    this.additionalInfo.maxValue = JDBCUtils.safeGetLong((ResultSet)seqResults, (String)"max_value");
                                    this.additionalInfo.incrementBy = JDBCUtils.safeGetLong((ResultSet)seqResults, (String)"increment_by");
                                    this.additionalInfo.cacheValue = JDBCUtils.safeGetLong((ResultSet)seqResults, (String)"cache_size");
                                    this.additionalInfo.isCycled = JDBCUtils.safeGetBoolean((ResultSet)seqResults, (String)"cycle");
                                }
                                break block50;
                            }
                            catch (Throwable throwable4) {
                                if (throwable3 == null) {
                                    throwable3 = throwable4;
                                } else if (throwable3 != throwable4) {
                                    throwable3.addSuppressed(throwable4);
                                }
                                throw throwable3;
                            }
                        }
                        catch (Throwable throwable5) {
                            if (throwable2 == null) {
                                throwable2 = throwable5;
                            } else if (throwable2 != throwable5) {
                                throwable2.addSuppressed(throwable5);
                            }
                            throw throwable2;
                        }
                    }
                    Throwable throwable6 = null;
                    Object var6_14 = null;
                    try (JDBCPreparedStatement dbSeqStat = session.prepareStatement("SELECT * from " + this.getFullyQualifiedName(DBPEvaluationContext.DML));){
                        Throwable throwable7 = null;
                        Object var9_24 = null;
                        try (JDBCResultSet seqResults = dbSeqStat.executeQuery();){
                            if (seqResults.next()) {
                                this.additionalInfo.startValue = JDBCUtils.safeGetLong((ResultSet)seqResults, (String)"start_value");
                                this.additionalInfo.lastValue = JDBCUtils.safeGetLongNullable((ResultSet)seqResults, (String)"last_value");
                                this.additionalInfo.minValue = JDBCUtils.safeGetLong((ResultSet)seqResults, (String)"min_value");
                                this.additionalInfo.maxValue = JDBCUtils.safeGetLong((ResultSet)seqResults, (String)"max_value");
                                this.additionalInfo.incrementBy = JDBCUtils.safeGetLong((ResultSet)seqResults, (String)"increment_by");
                                this.additionalInfo.cacheValue = JDBCUtils.safeGetLong((ResultSet)seqResults, (String)"cache_size");
                                this.additionalInfo.isCycled = JDBCUtils.safeGetBoolean((ResultSet)seqResults, (String)"is_cycled");
                            }
                        }
                        catch (Throwable throwable8) {
                            if (throwable7 == null) {
                                throwable7 = throwable8;
                            } else if (throwable7 != throwable8) {
                                throwable7.addSuppressed(throwable8);
                            }
                            throw throwable7;
                        }
                    }
                    catch (Throwable throwable9) {
                        if (throwable6 == null) {
                            throwable6 = throwable9;
                        } else if (throwable6 != throwable9) {
                            throwable6.addSuppressed(throwable9);
                        }
                        throw throwable6;
                    }
                }
                this.additionalInfo.loaded = true;
            }
            catch (Throwable throwable10) {
                if (throwable == null) {
                    throwable = throwable10;
                } else if (throwable != throwable10) {
                    throwable.addSuppressed(throwable10);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            log.warn((Object)"Error reading sequence values", (Throwable)e);
        }
    }

    public Number getLastValue() {
        return this.additionalInfo.lastValue;
    }

    public Number getMinValue() {
        return this.additionalInfo.minValue;
    }

    public Number getMaxValue() {
        return this.additionalInfo.maxValue;
    }

    public Number getIncrementBy() {
        return this.additionalInfo.incrementBy;
    }

    @Override
    public String getTableTypeName() {
        return "SEQUENCE";
    }

    public boolean supportsCacheAndCycle() {
        return true;
    }

    @NotNull
    public DBSEntityType getEntityType() {
        return DBSEntityType.SEQUENCE;
    }

    public boolean isView() {
        return false;
    }

    public Collection<? extends DBSTableIndex> getIndexes(@NotNull DBRProgressMonitor monitor) throws DBException {
        return null;
    }

    @Override
    public void setObjectDefinitionText(String sourceText) throws DBException {
    }

    @Override
    @Nullable
    public String[] getRelOptions() {
        return null;
    }

    @NotNull
    public String getObjectDefinitionText(@NotNull DBRProgressMonitor monitor, @NotNull Map<String, Object> options) throws DBException {
        StringBuilder sql = new StringBuilder().append("-- DROP SEQUENCE ").append(DBUtils.getEntityScriptName((DBSObject)this, options)).append(";\n\n").append("CREATE SEQUENCE ").append(DBUtils.getEntityScriptName((DBSObject)this, options));
        this.getSequenceBody(monitor, sql, true);
        sql.append(';');
        if (!CommonUtils.isEmpty((String)this.getDescription())) {
            sql.append("\nCOMMENT ON SEQUENCE ").append(DBUtils.getEntityScriptName((DBSObject)this, options)).append(" IS ").append(SQLUtils.quoteString((DBSObject)this, (String)this.getDescription())).append(";");
        }
        ArrayList<DBEPersistAction> actions = new ArrayList<DBEPersistAction>();
        PostgreUtils.getObjectGrantPermissionActions(monitor, this, actions, options);
        if (!actions.isEmpty()) {
            sql.append("\n\n");
            sql.append(SQLUtils.generateScript((DBPDataSource)this.getDataSource(), (DBEPersistAction[])actions.toArray(new DBEPersistAction[actions.size()]), (boolean)false));
        }
        return sql.toString();
    }

    public void getSequenceBody(@NotNull DBRProgressMonitor monitor, @NotNull StringBuilder sql, boolean hasIndentation) throws DBCException {
        AdditionalInfo info = this.getAdditionalInfo(monitor);
        if (info.getIncrementBy() > 0L) {
            this.addIndentation(sql, hasIndentation);
            sql.append("INCREMENT BY ").append(info.getIncrementBy());
        }
        if (info.getMinValue() >= 0L) {
            this.addIndentation(sql, hasIndentation);
            sql.append("MINVALUE ").append(info.getMinValue());
        } else {
            this.addIndentation(sql, hasIndentation);
            sql.append("NO MINVALUE");
        }
        if (info.getMaxValue() > 0L) {
            this.addIndentation(sql, hasIndentation);
            sql.append("MAXVALUE ").append(info.getMaxValue());
        } else {
            this.addIndentation(sql, hasIndentation);
            sql.append("NO MAXVALUE");
        }
        if (info.getStartValue() >= 0L) {
            this.addIndentation(sql, hasIndentation);
            sql.append("START ").append(info.getStartValue());
        }
        if (info.getCacheValue() > 0L) {
            this.addIndentation(sql, hasIndentation);
            sql.append("CACHE ").append(info.getCacheValue());
        }
        this.addIndentation(sql, hasIndentation);
        sql.append(info.isCycled() ? "" : "NO ").append("CYCLE");
    }

    private void addIndentation(@NotNull StringBuilder sql, boolean hasIndentation) {
        if (hasIndentation) {
            sql.append("\n\t");
        } else {
            sql.append(" ");
        }
    }

    @Override
    public String generateChangeOwnerQuery(@NotNull String owner, @NotNull Map<String, Object> options) {
        return "ALTER SEQUENCE " + DBUtils.getEntityScriptName((DBSObject)this, options) + " OWNER TO " + owner;
    }

    @Override
    public boolean supportsObjectDefinitionOption(@NotNull String option) {
        return "ddl.includePermissions".equals(option) || "ddl.includeComments".equals(option);
    }

    @Override
    public DBSObject refreshObject(@NotNull DBRProgressMonitor monitor) throws DBException {
        this.additionalInfo.loaded = false;
        return super.refreshObject(monitor);
    }

    @NotNull
    public DBSObjectType getObjectType() {
        return RelationalObjectType.TYPE_SEQUENCE;
    }

    public static class AdditionalInfo {
        private volatile boolean loaded = false;
        private long startValue;
        private Long lastValue;
        private long minValue;
        private long maxValue;
        private long incrementBy;
        private long cacheValue;
        private boolean isCycled;

        @Property(viewable=true, editable=true, updatable=true, order=10)
        public Long getLastValue() {
            return this.lastValue;
        }

        public void setLastValue(long lastValue) {
            this.lastValue = lastValue;
        }

        @Property(viewable=true, editable=true, updatable=true, order=20)
        public long getStartValue() {
            return this.startValue;
        }

        public void setStartValue(long startValue) {
            this.startValue = startValue;
        }

        @Property(viewable=true, editable=true, updatable=true, order=21)
        public long getMinValue() {
            return this.minValue;
        }

        public void setMinValue(long minValue) {
            this.minValue = minValue;
        }

        @Property(viewable=true, editable=true, updatable=true, order=22)
        public long getMaxValue() {
            return this.maxValue;
        }

        public void setMaxValue(long maxValue) {
            this.maxValue = maxValue;
        }

        @Property(viewable=true, editable=true, updatable=true, order=23)
        public long getIncrementBy() {
            return this.incrementBy;
        }

        public void setIncrementBy(long incrementBy) {
            this.incrementBy = incrementBy;
        }

        @Property(viewable=true, editable=true, updatable=true, order=24, visibleIf=CacheAndCycleValidator.class)
        public long getCacheValue() {
            return this.cacheValue;
        }

        public void setCacheValue(long cacheValue) {
            this.cacheValue = cacheValue;
        }

        @Property(viewable=true, editable=true, updatable=true, order=25, visibleIf=CacheAndCycleValidator.class)
        public boolean isCycled() {
            return this.isCycled;
        }

        public void setCycled(boolean cycled) {
            this.isCycled = cycled;
        }

        public void setLoaded(boolean loaded) {
            this.loaded = loaded;
        }
    }

    public static class AdditionalInfoValidator
    implements IPropertyCacheValidator<PostgreSequence> {
        public boolean isPropertyCached(PostgreSequence object, Object propertyId) {
            return object.additionalInfo.loaded;
        }
    }

    public static class CacheAndCycleValidator
    implements IPropertyValueValidator<PostgreSequence, Object> {
        public boolean isValidValue(PostgreSequence object, Object value) throws IllegalArgumentException {
            return object.supportsCacheAndCycle();
        }
    }
}

