/**
 * Go SDK for OpenFGA
 *
 * API version: 1.x
 * Website: https://openfga.dev
 * Documentation: https://openfga.dev/docs
 * Support: https://openfga.dev/community
 * License: [Apache-2.0](https://github.com/openfga/go-sdk/blob/main/LICENSE)
 *
 * NOTE: This file was auto generated by OpenAPI Generator (https://openapi-generator.tech). DO NOT EDIT.
 */

package openfga

import (
	"encoding/json"
	"fmt"
)

// AuthErrorCode the model 'AuthErrorCode'
type AuthErrorCode string

// List of AuthErrorCode
const (
	AUTHERRORCODE_NO_AUTH_ERROR                    AuthErrorCode = "no_auth_error"
	AUTHERRORCODE_AUTH_FAILED_INVALID_SUBJECT      AuthErrorCode = "auth_failed_invalid_subject"
	AUTHERRORCODE_AUTH_FAILED_INVALID_AUDIENCE     AuthErrorCode = "auth_failed_invalid_audience"
	AUTHERRORCODE_AUTH_FAILED_INVALID_ISSUER       AuthErrorCode = "auth_failed_invalid_issuer"
	AUTHERRORCODE_INVALID_CLAIMS                   AuthErrorCode = "invalid_claims"
	AUTHERRORCODE_AUTH_FAILED_INVALID_BEARER_TOKEN AuthErrorCode = "auth_failed_invalid_bearer_token"
	AUTHERRORCODE_BEARER_TOKEN_MISSING             AuthErrorCode = "bearer_token_missing"
	AUTHERRORCODE_UNAUTHENTICATED                  AuthErrorCode = "unauthenticated"
	AUTHERRORCODE_FORBIDDEN                        AuthErrorCode = "forbidden"
)

var allowedAuthErrorCodeEnumValues = []AuthErrorCode{
	"no_auth_error",
	"auth_failed_invalid_subject",
	"auth_failed_invalid_audience",
	"auth_failed_invalid_issuer",
	"invalid_claims",
	"auth_failed_invalid_bearer_token",
	"bearer_token_missing",
	"unauthenticated",
	"forbidden",
}

func (v *AuthErrorCode) UnmarshalJSON(src []byte) error {
	var value string
	err := json.Unmarshal(src, &value)
	if err != nil {
		return err
	}
	enumTypeValue := AuthErrorCode(value)
	for _, existing := range allowedAuthErrorCodeEnumValues {
		if existing == enumTypeValue {
			*v = enumTypeValue
			return nil
		}
	}

	return fmt.Errorf("%+v is not a valid AuthErrorCode", value)
}

// NewAuthErrorCodeFromValue returns a pointer to a valid AuthErrorCode
// for the value passed as argument, or an error if the value passed is not allowed by the enum
func NewAuthErrorCodeFromValue(v string) (*AuthErrorCode, error) {
	ev := AuthErrorCode(v)
	if ev.IsValid() {
		return &ev, nil
	} else {
		return nil, fmt.Errorf("invalid value '%v' for AuthErrorCode: valid values are %v", v, allowedAuthErrorCodeEnumValues)
	}
}

// IsValid return true if the value is valid for the enum, false otherwise
func (v AuthErrorCode) IsValid() bool {
	for _, existing := range allowedAuthErrorCodeEnumValues {
		if existing == v {
			return true
		}
	}
	return false
}

// Ptr returns reference to AuthErrorCode value
func (v AuthErrorCode) Ptr() *AuthErrorCode {
	return &v
}

type NullableAuthErrorCode struct {
	value *AuthErrorCode
	isSet bool
}

func (v NullableAuthErrorCode) Get() *AuthErrorCode {
	return v.value
}

func (v *NullableAuthErrorCode) Set(val *AuthErrorCode) {
	v.value = val
	v.isSet = true
}

func (v NullableAuthErrorCode) IsSet() bool {
	return v.isSet
}

func (v *NullableAuthErrorCode) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableAuthErrorCode(val *AuthErrorCode) *NullableAuthErrorCode {
	return &NullableAuthErrorCode{value: val, isSet: true}
}

func (v NullableAuthErrorCode) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableAuthErrorCode) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}
