\page Examples_HepMC Category "eventgenerator/HepMC"

This directory contains examples for using HepMC as an interface with 
various Monte Carlo event generators, such as PYTHIA.
It also include an example for demonstrating MC truth handling with HepMC.

## Requirements for external software packages

### HepMC
  - Tested version : 2.06.09
  - http://lcgapp.cern.ch/project/simu/HepMC/

  Note: examples were tested only on Linux with gcc.

### PYTHIA
  - Tested version 6.4.26
  - URL: http://www.thep.lu.se/~torbjorn/Pythia.html


## Examples HepMCEx01 and HepMCEx02

### class HepMCG4Interface
  This class is derived from G4VPrimaryGenerator, and is a base class 
  for primary generation via HepMC object.

  protected members:

  - virtual HepMC::GenEvent* GenerateHepMCEvent() \n
      Implement this method in his/her own concrete class.
      An empty event will be created in default.

  - void HepMC2G4(const HepMC::GenEvent* hepmcevt, G4Event* g4event) \n
    service method for conversion from HepMC::GenEvent to G4Event

  - virtual G4bool CheckVertexInsideWorld(const G4ThreeVector& pos) const \n
    We have to take care for the position of primaries because
    primary vertices outside the world volume give rise to G4Exception.
    If the default implementation is not adequate, an alternative 
    can be implemented in your own class.

  public members:
  - virtual void GeneratePrimaryVertex(G4Event* anEvent) \n
    The default behavior is that a single HepMC event generated by
    GenerateHepMCEvent() will be converted to G4Event through HepMC2G4().

### class HepMCG4AsciiReader / HepMCG4AsciiReaderMessenger (derived from HepMCG4Interface)
  This derived class is for reading primary information from 
  an Ascii file generated by HepMC.

### class HepMCG4PythiaInterface / HepMCG4AsciiReaderMessenger (derived from HepMCG4Interface)
  This derived class is for directly calling PYTHIA functions. 
  Users can set parameters, initialize, generate, and terminate
  by command line operation.

### Macros in examples

  - hepmc_pygen.in \n
    process PYTHIA events(H->4mu) generated at every event.

  - hepmc_ascii.in \n
    read pregenerated events from HepMC Ascii file (data/example_MyPythia.dat).

### Installation

- 1. Download and install HepMC from: \n
   http://lcgapp.cern.ch/project/simu/HepMC/ \n
   and define the environment variable:
```
HEPMC_DIR         the path to HepMC installation.
```
 
- 2. Download the PYTHIA6 source file from the PYTHIA6 download site:\n
   http://www.hepforge.org/downloads/pythia6
   
- 2A. With CMake: Build pythia6 library
 
  For a convenience a CMake file for building Pythia6 library from 
  the source is provided in
  examples/extended/eventgenerator/CMakeLists.txt.pythia6.
  Build the pythia6 library following the instructions in this file
  and then define the environment variables:
```
PYTHIA6          the path where pythia6 library is installed
PYTHIA6_VERSION  the pythia version 
```

- 2B. With GNUmake: Define the environment variables: \n
```
PYTHIA6           the path to pythia-versionX.f source code
PYTHIA6_VERSION   the pythia version 
```
    
  e.g. If you download pythia-6.4.26.f.gz and unzip it in $HOME,
       then you have to set:
  export PYTHIA6=$HOME
  export PYTHIA6_VERSION="6.4.26"
  
  pythia6 will be then compiled together with example code.
   
- 3. Compilation:\n
  Then the examples are compiled in a standard way, see \ref README_HowToRun.

### Examples

  See more details in \ref ExampleHepMCEx01 and \ref ExampleHepMCEx02. 

### Notes

  We attached a sample HepMC Ascii data file, "data/example_MyPythia.dat",
  which contains 10 PYTHIA events created by "data/example_MyPythia.cxx".

## Example MCTruth

Application \ref ExampleMCTruth demonstrating handling of Monte-Carlo truth information through the HepMC package.
