Creating a release
==================

This document is documentation intended for maintainers of InputLeap.
It documents the release process of InputLeap.

Step 1: Setup environment variables
-----------------------------------

Setup the following environment variable that will be used throughout the rest of the steps.

    export VERSION=X.Y.Z

Step 2: Release notes PR
------------------------

Open a new branch (e.g. `release`) and run the following:

    towncrier build --version ${VERSION} --date `date -u  +%F`

This collects the release notes using the `towncrier` tool. Please commit the collected release
notes afterwards.

Certain file names are not properly supported by the `towncrier` tool and it ignores them.
Check `newsfragments` directory for any forgotten release notes

Step 3: Merge the release notes PR
----------------------------------

Step 4: Bump the version number
-------------------------------

Pull the merge commit created on the `master` branch during the step 2.

Edit the following files and update the version numbers:

 - `cmake/Version.cmake`
 - `doc/input-leapc.1`
 - `doc/input-leaps.1`
 - `.github/ISSUE_TEMPLATE/bug_report.yml`
 - `dist/debian/changelog`

Commit to the release branch with the following message `InputLeap x.y.z`.

Create a tag:

    git tag -s v${VERSION} -m v${VERSION}

Push the commit:

    git push origin master v${VERSION}

Step 5: Draft a new release on Github
-------------------------------------

Go to https://github.com/input-leap/input-leap/releases and draft a new release.

Use git tag as the title of the release: `vX.Y.Z`.

Use the release notes generated by the `towncrier` tool as the description of the releases.

Upload the artifacts created by Github Actions as the binaries of the release.
See dist/scripts/download_release.py for details.
