/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.ui;

import com.intellij.database.datagrid.CoreGrid;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.GridColumn;
import com.intellij.database.datagrid.GridRow;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.run.ui.grid.editors.GridCellEditorFactory;
import com.intellij.database.run.ui.grid.editors.GridCellEditorFactoryProvider;
import com.intellij.openapi.editor.Document;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\"\u0010\u0014\u001a\u00020\u00122\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0007J\u0006\u0010\u0015\u001a\u00020\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR \u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\n\"\u0004\b\u0010\u0010\fR\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/intellij/database/run/ui/ValueParserCache;", "", "grid", "Lcom/intellij/database/datagrid/DataGrid;", "<init>", "(Lcom/intellij/database/datagrid/DataGrid;)V", "row", "Lcom/intellij/database/datagrid/ModelIndex;", "Lcom/intellij/database/datagrid/GridRow;", "getRow", "()Lcom/intellij/database/datagrid/ModelIndex;", "setRow", "(Lcom/intellij/database/datagrid/ModelIndex;)V", "column", "Lcom/intellij/database/datagrid/GridColumn;", "getColumn", "setColumn", "defaultParser", "Lcom/intellij/database/run/ui/grid/editors/GridCellEditorFactory$ValueParser;", "currentParser", "getValueParser", "clearCache", "", "intellij.grid.impl"})
public final class ValueParserCache {
    @NotNull
    private final DataGrid grid;
    @NotNull
    private ModelIndex<GridRow> row;
    @NotNull
    private ModelIndex<GridColumn> column;
    @NotNull
    private final GridCellEditorFactory.ValueParser defaultParser;
    @NotNull
    private GridCellEditorFactory.ValueParser currentParser;

    public ValueParserCache(@NotNull DataGrid grid) {
        Intrinsics.checkNotNullParameter((Object)grid, (String)"grid");
        this.grid = grid;
        ModelIndex modelIndex = ModelIndex.forRow((CoreGrid)this.grid, (int)-1);
        Intrinsics.checkNotNullExpressionValue((Object)modelIndex, (String)"forRow(...)");
        this.row = modelIndex;
        ModelIndex modelIndex2 = ModelIndex.forColumn((CoreGrid)this.grid, (int)-1);
        Intrinsics.checkNotNullExpressionValue((Object)modelIndex2, (String)"forColumn(...)");
        this.column = modelIndex2;
        this.currentParser = this.defaultParser = ValueParserCache::defaultParser$lambda$0;
    }

    @NotNull
    public final ModelIndex<GridRow> getRow() {
        return this.row;
    }

    public final void setRow(@NotNull ModelIndex<GridRow> modelIndex) {
        Intrinsics.checkNotNullParameter(modelIndex, (String)"<set-?>");
        this.row = modelIndex;
    }

    @NotNull
    public final ModelIndex<GridColumn> getColumn() {
        return this.column;
    }

    public final void setColumn(@NotNull ModelIndex<GridColumn> modelIndex) {
        Intrinsics.checkNotNullParameter(modelIndex, (String)"<set-?>");
        this.column = modelIndex;
    }

    @NotNull
    public final GridCellEditorFactory.ValueParser getValueParser(@NotNull ModelIndex<GridRow> row, @NotNull ModelIndex<GridColumn> column) {
        Intrinsics.checkNotNullParameter(row, (String)"row");
        Intrinsics.checkNotNullParameter(column, (String)"column");
        if (!Intrinsics.areEqual(this.row, row) || !Intrinsics.areEqual(this.column, column)) {
            this.row = row;
            this.column = column;
            GridCellEditorFactoryProvider gridCellEditorFactoryProvider = GridCellEditorFactoryProvider.get(this.grid);
            GridCellEditorFactory factory = gridCellEditorFactoryProvider != null ? gridCellEditorFactoryProvider.getEditorFactory(this.grid, row, column) : null;
            Object object = factory;
            if (object == null || (object = object.getValueParser(this.grid, row, column)) == null) {
                object = this.defaultParser;
            }
            this.currentParser = object;
        }
        return this.currentParser;
    }

    public final void clearCache() {
        this.row = ModelIndex.forRow((CoreGrid)this.grid, (int)-1);
        this.column = ModelIndex.forColumn((CoreGrid)this.grid, (int)-1);
    }

    private static final Object defaultParser$lambda$0(String text, Document document) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        return text;
    }
}

