/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.search;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.DelegatingGlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.impl.VirtualFileEnumeration;
import com.intellij.psi.search.impl.VirtualFileEnumerationAware;
import com.intellij.util.ArrayUtil;
import java.util.ArrayList;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class FileTypeRestrictionScope
extends DelegatingGlobalSearchScope
implements VirtualFileEnumerationAware {
    private final FileType[] myFileTypes;

    FileTypeRestrictionScope(@NotNull GlobalSearchScope scope, FileType @NotNull [] fileTypes) {
        if (scope == null) {
            FileTypeRestrictionScope.$$$reportNull$$$0(0);
        }
        if (fileTypes == null) {
            FileTypeRestrictionScope.$$$reportNull$$$0(1);
        }
        super(scope);
        this.myFileTypes = fileTypes;
    }

    @Override
    public boolean contains(@NotNull VirtualFile file) {
        if (file == null) {
            FileTypeRestrictionScope.$$$reportNull$$$0(2);
        }
        if (!super.contains(file)) {
            return false;
        }
        for (FileType otherFileType : this.myFileTypes) {
            if (!FileTypeRegistry.getInstance().isFileOfType(file, otherFileType)) continue;
            return true;
        }
        return false;
    }

    @Override
    @NotNull
    public GlobalSearchScope intersectWith(@NotNull GlobalSearchScope scope) {
        if (scope == null) {
            FileTypeRestrictionScope.$$$reportNull$$$0(3);
        }
        if (scope instanceof FileTypeRestrictionScope) {
            FileTypeRestrictionScope restrict = (FileTypeRestrictionScope)scope;
            if (restrict.myBaseScope == this.myBaseScope) {
                ArrayList<FileType> intersection = new ArrayList<FileType>(Arrays.asList(restrict.myFileTypes));
                intersection.retainAll(Arrays.asList(this.myFileTypes));
                return new FileTypeRestrictionScope(this.myBaseScope, intersection.toArray(FileType.EMPTY_ARRAY));
            }
        }
        GlobalSearchScope globalSearchScope = super.intersectWith(scope);
        if (globalSearchScope == null) {
            FileTypeRestrictionScope.$$$reportNull$$$0(4);
        }
        return globalSearchScope;
    }

    @Override
    @NotNull
    public GlobalSearchScope uniteWith(@NotNull GlobalSearchScope scope) {
        if (scope == null) {
            FileTypeRestrictionScope.$$$reportNull$$$0(5);
        }
        if (scope instanceof FileTypeRestrictionScope) {
            FileTypeRestrictionScope restrict = (FileTypeRestrictionScope)scope;
            if (restrict.myBaseScope == this.myBaseScope) {
                return new FileTypeRestrictionScope(this.myBaseScope, ArrayUtil.mergeArrays(this.myFileTypes, restrict.myFileTypes));
            }
        }
        GlobalSearchScope globalSearchScope = super.uniteWith(scope);
        if (globalSearchScope == null) {
            FileTypeRestrictionScope.$$$reportNull$$$0(6);
        }
        return globalSearchScope;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FileTypeRestrictionScope)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        FileTypeRestrictionScope that = (FileTypeRestrictionScope)o;
        return Arrays.equals(this.myFileTypes, that.myFileTypes);
    }

    @Override
    public int calcHashCode() {
        int result2 = super.calcHashCode();
        result2 = 31 * result2 + Arrays.hashCode(this.myFileTypes);
        return result2;
    }

    @Override
    public String toString() {
        return "Restricted by file types: " + Arrays.asList(this.myFileTypes) + " in (" + this.myBaseScope + ")";
    }

    @Override
    @Nullable
    public VirtualFileEnumeration extractFileEnumeration() {
        return VirtualFileEnumeration.extract(this.myBaseScope);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileTypes";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/search/FileTypeRestrictionScope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/search/FileTypeRestrictionScope";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "intersectWith";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "uniteWith";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "contains";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "intersectWith";
                break;
            }
            case 4: 
            case 6: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "uniteWith";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

