/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.qodana.staticAnalysis.stat;

import com.intellij.codeInspection.ex.InspectListener;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.inspectionProfile.InspectionCategoryGroupProviderKt;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BiFunction;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.ArrayDeque;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmInline;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlinx.coroutines.InterruptibleKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.qodana.staticAnalysis.Static_analysis_dispatchersKt;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010$\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0007\b\u0007\u0018\u0000 22\u00020\u0001:\u000523456B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J8\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u001a2\u000e\u0010\u001b\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010\u000eJ\u000e\u0010 \u001a\u00020\u0017H\u0086@\u00a2\u0006\u0002\u0010!J\u000e\u0010\"\u001a\u00020\u0017H\u0086@\u00a2\u0006\u0002\u0010!J\u0014\u0010#\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0$H\u0002J\u0012\u0010%\u001a\b\u0012\u0004\u0012\u00020\u000e0&*\u00020\u000eH\u0002J\u0010\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020\u0013H\u0002J\u0010\u0010*\u001a\u00020\u00132\u0006\u0010)\u001a\u00020\u0013H\u0002J\u0015\u0010+\u001a\u00020,*\u00020\u000e2\u0006\u0010-\u001a\u00020\u000eH\u0082\u0002J\u001d\u0010.\u001a\u00020\n\"\u0004\b\u0000\u0010/*\b\u0012\u0004\u0012\u0002H/00H\u0002\u00a2\u0006\u0002\u00101J\u0018\u0010.\u001a\u00020\n\"\u0004\b\u0000\u0010/*\b\u0012\u0004\u0012\u0002H/0&H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001e\u0010\b\u001a\u0012\u0012\b\u0012\u00060\nj\u0002`\u000b\u0012\u0004\u0012\u00020\f0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00067"}, d2={"Lorg/jetbrains/qodana/staticAnalysis/stat/InspectionInfoQodanaReporterService;", "", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "inspectionsSummaryInfo", "Ljava/util/concurrent/ConcurrentHashMap;", "", "Lorg/jetbrains/qodana/staticAnalysis/stat/InspectionKey;", "Lorg/jetbrains/qodana/staticAnalysis/stat/InspectionInfoQodanaReporterService$InspectionInfo;", "directoriesInspectionGroupsInfos", "Lcom/intellij/openapi/vfs/VirtualFile;", "Lorg/jetbrains/qodana/staticAnalysis/stat/InspectionInfoQodanaReporterService$InspectionGroupsInfosCollection;", "timeFirstInspectionStarted", "Ljava/util/concurrent/atomic/AtomicLong;", "timeLastInspectionFinished", "", "sumOfAllInspectionDurations", "projectRoot", "addInspectionFinishedEvent", "", "duration", "problemsCount", "", "tool", "Lcom/intellij/codeInspection/ex/InspectionToolWrapper;", "kind", "Lcom/intellij/codeInspection/ex/InspectListener$InspectionKind;", "file", "logInspectionsSummaryInfo", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "logDirectoriesInspectionsInfo", "inspectionGroupsInfosAllProjectDirectories", "", "directoriesToProjectRoot", "", "inspectionTimeProportionFromTotal", "", "inspectionsDuration", "inspectionAbsoluteTime", "contains", "", "other", "toCSVLine", "T", "", "([Ljava/lang/Object;)Ljava/lang/String;", "Companion", "InspectionGroup", "FinishedInspectionDescriptor", "InspectionInfo", "InspectionGroupsInfosCollection", "intellij.qodana"})
@SourceDebugExtension(value={"SMAP\nInspectionInfoQodanaReporterService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InspectionInfoQodanaReporterService.kt\norg/jetbrains/qodana/staticAnalysis/stat/InspectionInfoQodanaReporterService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,334:1\n1863#2:335\n1863#2,2:336\n1864#2:338\n1062#2:339\n1863#2,2:340\n1557#2:342\n1628#2,3:343\n1863#2,2:346\n1863#2,2:348\n1053#2:353\n1557#2:355\n1628#2,3:356\n3829#3:350\n4344#3,2:351\n1#4:354\n*S KotlinDebug\n*F\n+ 1 InspectionInfoQodanaReporterService.kt\norg/jetbrains/qodana/staticAnalysis/stat/InspectionInfoQodanaReporterService\n*L\n293#1:335\n294#1:336,2\n293#1:338\n207#1:339\n208#1:340,2\n242#1:342\n242#1:343,3\n243#1:346,2\n231#1:348,2\n269#1:353\n60#1:355\n60#1:356,3\n268#1:350\n268#1:351,2\n*E\n"})
public final class InspectionInfoQodanaReporterService {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final Project project;
    @NotNull
    private final ConcurrentHashMap<String, InspectionInfo> inspectionsSummaryInfo;
    @NotNull
    private final ConcurrentHashMap<VirtualFile, InspectionGroupsInfosCollection> directoriesInspectionGroupsInfos;
    @NotNull
    private final AtomicLong timeFirstInspectionStarted;
    private long timeLastInspectionFinished;
    @NotNull
    private final AtomicLong sumOfAllInspectionDurations;
    @Nullable
    private final VirtualFile projectRoot;
    @NotNull
    private static final List<InspectionGroup> _inspectionGroups;
    @NotNull
    private static final List<InspectionGroup> inspectionGroups;
    @NotNull
    private static Map<String, Integer> mapInspectionGroupNameToIdx;

    public InspectionInfoQodanaReporterService(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.inspectionsSummaryInfo = new ConcurrentHashMap();
        this.directoriesInspectionGroupsInfos = new ConcurrentHashMap();
        this.timeFirstInspectionStarted = new AtomicLong(-1L);
        this.sumOfAllInspectionDurations = new AtomicLong(0L);
        this.projectRoot = ProjectUtil.guessProjectDir((Project)this.project);
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    public final void addInspectionFinishedEvent(long duration, int problemsCount, @NotNull InspectionToolWrapper<?, ?> tool, @NotNull InspectListener.InspectionKind kind, @Nullable VirtualFile file) {
        block2: {
            VirtualFile inspectedDirectory;
            Intrinsics.checkNotNullParameter(tool, (String)"tool");
            Intrinsics.checkNotNullParameter((Object)kind, (String)"kind");
            long curTime = System.currentTimeMillis();
            this.timeFirstInspectionStarted.compareAndSet(-1L, curTime - duration);
            this.timeLastInspectionFinished = curTime;
            this.sumOfAllInspectionDurations.addAndGet(duration);
            FinishedInspectionDescriptor finishedInspection = new FinishedInspectionDescriptor(duration, problemsCount, kind, tool);
            Function2 function2 = (arg_0, arg_1) -> InspectionInfoQodanaReporterService.addInspectionFinishedEvent$lambda$0(finishedInspection, arg_0, arg_1);
            this.inspectionsSummaryInfo.compute(finishedInspection.getInspectionKey(), new BiFunction(function2){
                private final /* synthetic */ Function2 function;
                {
                    Intrinsics.checkNotNullParameter((Object)function, (String)"function");
                    this.function = function;
                }

                public final /* synthetic */ Object apply(Object p0, Object p1) {
                    return this.function.invoke(p0, p1);
                }
            });
            VirtualFile virtualFile = file;
            if (virtualFile == null || (virtualFile = virtualFile.getParent()) == null) {
                virtualFile = this.projectRoot;
            }
            VirtualFile virtualFile2 = inspectedDirectory = virtualFile;
            if (virtualFile2 == null) break block2;
            VirtualFile it = virtualFile2;
            boolean bl = false;
            Function2 function22 = (Function2)new Function2<VirtualFile, InspectionGroupsInfosCollection, InspectionGroupsInfosCollection>(finishedInspection){
                final /* synthetic */ FinishedInspectionDescriptor $finishedInspection;
                {
                    this.$finishedInspection = $finishedInspection;
                }

                public final InspectionGroupsInfosCollection.InspectionGroupInfo[] invoke-CgQYNPs(VirtualFile virtualFile, InspectionGroupsInfosCollection.InspectionGroupInfo[] v) {
                    Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"<unused var>");
                    InspectionGroupsInfosCollection.InspectionGroupInfo[] inspectionGroupInfoArray = v;
                    if (v == null) {
                        inspectionGroupInfoArray = InspectionGroupsInfosCollection.constructor-impl$default(null, 1, null);
                    }
                    InspectionGroupsInfosCollection.InspectionGroupInfo[] inspectionGroupsInfos = inspectionGroupInfoArray;
                    InspectionGroupsInfosCollection.addFinishedInspection-impl(inspectionGroupsInfos, this.$finishedInspection);
                    return inspectionGroupsInfos;
                }
            };
            InspectionGroupsInfosCollection inspectionGroupsInfosCollection = this.directoriesInspectionGroupsInfos.compute(it, new /* invalid duplicate definition of identical inner class */);
            Object object = inspectionGroupsInfosCollection != null ? inspectionGroupsInfosCollection.unbox-impl() : null;
            InspectionGroupsInfosCollection inspectionGroupsInfosCollection2 = object != null ? InspectionGroupsInfosCollection.box-impl(object) : null;
            if (inspectionGroupsInfosCollection2 != null) {
                inspectionGroupsInfosCollection2.unbox-impl();
            }
        }
    }

    @Nullable
    public final Object logInspectionsSummaryInfo(@NotNull Continuation<? super Unit> $completion) {
        Object object = InterruptibleKt.runInterruptible((CoroutineContext)Static_analysis_dispatchersKt.getStaticAnalysisDispatchers().getIO(), () -> InspectionInfoQodanaReporterService.logInspectionsSummaryInfo$lambda$5(this), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    @Nullable
    public final Object logDirectoriesInspectionsInfo(@NotNull Continuation<? super Unit> $completion) {
        Object object = InterruptibleKt.runInterruptible((CoroutineContext)Static_analysis_dispatchersKt.getStaticAnalysisDispatchers().getIO(), () -> InspectionInfoQodanaReporterService.logDirectoriesInspectionsInfo$lambda$13(this), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    private final Map<VirtualFile, InspectionGroupsInfosCollection> inspectionGroupsInfosAllProjectDirectories() {
        Map infosAllDirectories = new LinkedHashMap();
        Set<Map.Entry<VirtualFile, InspectionGroupsInfosCollection>> set = this.directoriesInspectionGroupsInfos.entrySet();
        Intrinsics.checkNotNullExpressionValue(set, (String)"<get-entries>(...)");
        Iterable $this$forEach$iv = set;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Map.Entry entry = (Map.Entry)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)entry);
            Object k = entry.getKey();
            Intrinsics.checkNotNullExpressionValue(k, (String)"component1(...)");
            VirtualFile directory = (VirtualFile)k;
            Object v = entry.getValue();
            Intrinsics.checkNotNullExpressionValue(v, (String)"component2(...)");
            InspectionGroupsInfosCollection.InspectionGroupInfo[] inspectionGroupsInfos = ((InspectionGroupsInfosCollection)v).unbox-impl();
            Iterable $this$forEach$iv2 = this.directoriesToProjectRoot(directory);
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                VirtualFile it = (VirtualFile)element$iv2;
                boolean bl2 = false;
                Function2 function2 = (Function2)new Function2<VirtualFile, InspectionGroupsInfosCollection, InspectionGroupsInfosCollection>(inspectionGroupsInfos){
                    final /* synthetic */ InspectionGroupsInfosCollection.InspectionGroupInfo[] $inspectionGroupsInfos;
                    {
                        this.$inspectionGroupsInfos = $inspectionGroupsInfos;
                    }

                    public final InspectionGroupsInfosCollection.InspectionGroupInfo[] invoke-CgQYNPs(VirtualFile virtualFile, InspectionGroupsInfosCollection.InspectionGroupInfo[] v) {
                        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"<unused var>");
                        InspectionGroupsInfosCollection.InspectionGroupInfo[] inspectionGroupInfoArray = v;
                        if (v == null) {
                            inspectionGroupInfoArray = InspectionGroupsInfosCollection.constructor-impl$default(null, 1, null);
                        }
                        InspectionGroupsInfosCollection.InspectionGroupInfo[] groupInfos = inspectionGroupInfoArray;
                        InspectionGroupsInfosCollection.add-x7W0VSw(groupInfos, this.$inspectionGroupsInfos);
                        return groupInfos;
                    }
                };
                infosAllDirectories.compute(it, new /* invalid duplicate definition of identical inner class */);
            }
        }
        return infosAllDirectories;
    }

    private final List<VirtualFile> directoriesToProjectRoot(VirtualFile $this$directoriesToProjectRoot) {
        List directories = new ArrayList();
        if (this.projectRoot == null) {
            return directories;
        }
        for (VirtualFile directory = $this$directoriesToProjectRoot; directory != null && this.contains(this.projectRoot, directory); directory = directory.getParent()) {
            directories.add(directory);
        }
        directories.add(this.projectRoot);
        return directories;
    }

    private final double inspectionTimeProportionFromTotal(long inspectionsDuration) {
        return (double)inspectionsDuration / (double)this.sumOfAllInspectionDurations.get();
    }

    private final long inspectionAbsoluteTime(long inspectionsDuration) {
        return (long)(this.inspectionTimeProportionFromTotal(inspectionsDuration) * (double)(this.timeLastInspectionFinished - this.timeFirstInspectionStarted.get()));
    }

    private final boolean contains(VirtualFile $this$contains, VirtualFile other) {
        Intrinsics.checkNotNullParameter((Object)$this$contains, (String)"<this>");
        return VfsUtil.isAncestor((VirtualFile)$this$contains, (VirtualFile)other, (boolean)true);
    }

    private final <T> String toCSVLine(T[] $this$toCSVLine) {
        return ArraysKt.joinToString$default((Object[])$this$toCSVLine, (CharSequence)";", null, null, (int)0, null, null, (int)62, null);
    }

    private final <T> String toCSVLine(List<? extends T> $this$toCSVLine) {
        return CollectionsKt.joinToString$default((Iterable)$this$toCSVLine, (CharSequence)";", null, null, (int)0, null, null, (int)62, null);
    }

    private static final InspectionInfo addInspectionFinishedEvent$lambda$0(FinishedInspectionDescriptor $finishedInspection, String string, InspectionInfo v) {
        InspectionInfo inspectionInfo;
        Intrinsics.checkNotNullParameter((Object)string, (String)"<unused var>");
        if (v == null) {
            inspectionInfo = new InspectionInfo($finishedInspection);
        } else {
            v.addFinishedInspection($finishedInspection);
            inspectionInfo = v;
        }
        return inspectionInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private static final Unit logInspectionsSummaryInfo$lambda$5(InspectionInfoQodanaReporterService this$0) {
        String[] stringArray = new String[]{"Inspection ID", "Inspection Group", "Inspection Name", "Inspection Language", "Inspection Type", "Absolute Time spent on Inspection, s", "Percent of Time spent on Inspection", "Problems Count", "Times Inspection was Performed"};
        String headerCSV = this$0.toCSVLine(stringArray);
        Object object = new String[]{"qodana_inspections_summary.csv"};
        File logFile2 = Paths.get(PathManager.getLogPath(), object).toFile();
        if (logFile2.isFile()) {
            logFile2.delete();
        }
        Intrinsics.checkNotNull((Object)logFile2);
        object = logFile2;
        Object object2 = Charsets.UTF_8;
        int n = 8192;
        Object object3 = object;
        object3 = new OutputStreamWriter((OutputStream)new FileOutputStream((File)object3), (Charset)object2);
        object = object3 instanceof BufferedWriter ? (BufferedWriter)object3 : new BufferedWriter((Writer)object3, n);
        object2 = null;
        try {
            void $this$forEach$iv;
            Iterable $this$sortedByDescending$iv;
            BufferedWriter bw = (BufferedWriter)object;
            boolean bl = false;
            bw.write(headerCSV);
            Collection<InspectionInfo> collection = this$0.inspectionsSummaryInfo.values();
            Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
            Iterable iterable = collection;
            boolean $i$f$sortedByDescending = false;
            $this$sortedByDescending$iv = CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    InspectionInfo it = (InspectionInfo)b;
                    boolean bl = false;
                    Comparable comparable = Long.valueOf(it.getDuration());
                    it = (InspectionInfo)a;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Long.valueOf(it.getDuration()));
                }
            });
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                InspectionInfo inspectionInfo = (InspectionInfo)element$iv;
                boolean bl2 = false;
                bw.newLine();
                Object[] objectArray = new Object[9];
                objectArray[0] = inspectionInfo.getId();
                objectArray[1] = inspectionInfo.getGroupPath();
                objectArray[2] = inspectionInfo.getDisplayName();
                objectArray[3] = inspectionInfo.getLanguage();
                objectArray[4] = inspectionInfo.getKind();
                String string = "%.2f";
                Object[] objectArray2 = new Object[]{(double)this$0.inspectionAbsoluteTime(inspectionInfo.getDuration()) / 1000.0};
                Intrinsics.checkNotNullExpressionValue((Object)String.format(string, Arrays.copyOf(objectArray2, objectArray2.length)), (String)"format(...)");
                string = "%.2f%%";
                objectArray2 = new Object[]{this$0.inspectionTimeProportionFromTotal(inspectionInfo.getDuration()) * (double)100};
                Intrinsics.checkNotNullExpressionValue((Object)String.format(string, Arrays.copyOf(objectArray2, objectArray2.length)), (String)"format(...)");
                objectArray[7] = inspectionInfo.getProblemsCount();
                objectArray[8] = inspectionInfo.getPerformedTimesCount();
                bw.write(this$0.toCSVLine(objectArray));
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable) {
            object2 = throwable;
            throw throwable;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)object2);
        }
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final String logDirectoriesInspectionsInfo$lambda$13$inspectionGroupsInfosToCSVLine(List<Object> valuesToPrintBuffer, InspectionInfoQodanaReporterService this$0, InspectionGroupsInfosCollection.InspectionGroupInfo[] inspectionGroupsInfos) {
        Object[] objectArray;
        void $this$mapTo$iv$iv;
        valuesToPrintBuffer.clear();
        Iterable $this$map$iv = inspectionGroups;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            objectArray = (Object[])item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(InspectionGroupsInfosCollection.get-impl(inspectionGroupsInfos, it.getGroupName()));
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            InspectionGroupsInfosCollection.InspectionGroupInfo inspectionGroupInfo = (InspectionGroupsInfosCollection.InspectionGroupInfo)element$iv;
            boolean bl = false;
            String string = "%.2f";
            objectArray = new Object[]{(double)this$0.inspectionAbsoluteTime(inspectionGroupInfo.getInspectionsDuration()) / 1000.0};
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
            valuesToPrintBuffer.add(string2);
            string = "%.2f%%";
            objectArray = new Object[]{this$0.inspectionTimeProportionFromTotal(inspectionGroupInfo.getInspectionsDuration()) * (double)100};
            String string3 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(...)");
            valuesToPrintBuffer.add(string3);
            valuesToPrintBuffer.add(inspectionGroupInfo.getProblemsCount());
            valuesToPrintBuffer.add(inspectionGroupInfo.getPerformedTimesCount());
        }
        return this$0.toCSVLine(valuesToPrintBuffer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private static final Unit logDirectoriesInspectionsInfo$lambda$13(InspectionInfoQodanaReporterService this$0) {
        if (this$0.projectRoot == null) {
            return Unit.INSTANCE;
        }
        List valuesToPrintBuffer = new ArrayList();
        Iterable $this$forEach$iv = inspectionGroups;
        boolean $i$f$forEach22 = false;
        for (Object element$iv : $this$forEach$iv) {
            InspectionGroup it = (InspectionGroup)element$iv;
            boolean bl = false;
            valuesToPrintBuffer.add("Absolute Time spent on Inspection Group '" + it.getGroupName() + "', s");
            valuesToPrintBuffer.add("Percent of Time spent on Inspection Group '" + it.getGroupName() + "'");
            valuesToPrintBuffer.add("Inspections Problem Count in Group '" + it.getGroupName() + "'");
            valuesToPrintBuffer.add("Times Inspection from Group '" + it.getGroupName() + "' was Performed");
        }
        String[] $i$f$forEach22 = new String[]{"Directory", this$0.toCSVLine(valuesToPrintBuffer)};
        String headerCSV = this$0.toCSVLine($i$f$forEach22);
        Object object = new String[]{"qodana_directories_inspection_groups.csv"};
        File logFile2 = Paths.get(PathManager.getLogPath(), object).toFile();
        if (logFile2.isFile()) {
            logFile2.delete();
        }
        Intrinsics.checkNotNull((Object)logFile2);
        object = logFile2;
        Object object2 = Charsets.UTF_8;
        int it = 8192;
        Object bl = object;
        bl = new OutputStreamWriter((OutputStream)new FileOutputStream((File)bl), (Charset)object2);
        object = bl instanceof BufferedWriter ? (BufferedWriter)bl : new BufferedWriter((Writer)bl, it);
        object2 = null;
        try {
            BufferedWriter bw = (BufferedWriter)object;
            boolean bl2 = false;
            bw.write(headerCSV);
            Map<VirtualFile, InspectionGroupsInfosCollection> infosAllInspectedDirectories = this$0.inspectionGroupsInfosAllProjectDirectories();
            ArrayDeque directoriesStackDFS = new ArrayDeque();
            directoriesStackDFS.add((Object)this$0.projectRoot);
            while (!directoriesStackDFS.isEmpty()) {
                List inspectedSubDirectories;
                block14: {
                    Object object3;
                    String[] stringArray;
                    InspectionInfoQodanaReporterService inspectionInfoQodanaReporterService;
                    BufferedWriter bufferedWriter;
                    VirtualFile curDirectory;
                    block16: {
                        block15: {
                            void it2;
                            void $this$sortedBy$iv;
                            void $this$filterTo$iv$iv;
                            Iterable $this$filter$iv;
                            curDirectory = (VirtualFile)directoriesStackDFS.removeLast();
                            VirtualFile[] virtualFileArray = curDirectory.getChildren();
                            Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"getChildren(...)");
                            Object[] objectArray = virtualFileArray;
                            boolean $i$f$filter = false;
                            void var13_22 = $this$filter$iv;
                            Collection destination$iv$iv = new ArrayList();
                            boolean $i$f$filterTo = false;
                            for (void element$iv$iv : $this$filterTo$iv$iv) {
                                VirtualFile it3 = (VirtualFile)element$iv$iv;
                                boolean bl3 = false;
                                if (!infosAllInspectedDirectories.containsKey(it3)) continue;
                                destination$iv$iv.add(element$iv$iv);
                            }
                            $this$filter$iv = (List)destination$iv$iv;
                            boolean $i$f$sortedBy = false;
                            inspectedSubDirectories = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(infosAllInspectedDirectories){
                                final /* synthetic */ Map $infosAllInspectedDirectories$inlined;
                                {
                                    this.$infosAllInspectedDirectories$inlined = map2;
                                }

                                public final int compare(T a, T b) {
                                    VirtualFile it = (VirtualFile)a;
                                    boolean bl = false;
                                    V v = this.$infosAllInspectedDirectories$inlined.get(it);
                                    Intrinsics.checkNotNull(v);
                                    it = (VirtualFile)b;
                                    Comparable comparable = Long.valueOf(InspectionGroupsInfosCollection.get-impl(((InspectionGroupsInfosCollection)v).unbox-impl(), "all").getInspectionsDuration());
                                    bl = false;
                                    V v2 = this.$infosAllInspectedDirectories$inlined.get(it);
                                    Intrinsics.checkNotNull(v2);
                                    return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)Long.valueOf(InspectionGroupsInfosCollection.get-impl(((InspectionGroupsInfosCollection)v2).unbox-impl(), "all").getInspectionsDuration()));
                                }
                            });
                            boolean directoryContainsInspectedFiles = this$0.directoriesInspectionGroupsInfos.containsKey(curDirectory);
                            if (inspectedSubDirectories.size() <= 1 && !directoryContainsInspectedFiles) break block14;
                            bw.newLine();
                            bufferedWriter = bw;
                            inspectionInfoQodanaReporterService = this$0;
                            String[] stringArray2 = stringArray = new String[2];
                            int n = 0;
                            object3 = this$0.projectRoot.getParent();
                            if (object3 == null) break block15;
                            VirtualFile virtualFile = object3;
                            int n2 = n;
                            String[] stringArray3 = stringArray2;
                            InspectionInfoQodanaReporterService inspectionInfoQodanaReporterService2 = inspectionInfoQodanaReporterService;
                            BufferedWriter bufferedWriter2 = bufferedWriter;
                            boolean bl4 = false;
                            String string = VfsUtil.getRelativePath((VirtualFile)it2, (VirtualFile)curDirectory);
                            bufferedWriter = bufferedWriter2;
                            inspectionInfoQodanaReporterService = inspectionInfoQodanaReporterService2;
                            stringArray2 = stringArray3;
                            n = n2;
                            String string2 = string;
                            object3 = string2;
                            if (string2 != null) break block16;
                        }
                        String string = curDirectory.getPath();
                        object3 = string;
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
                    }
                    stringArray2[n] = object3;
                    InspectionGroupsInfosCollection inspectionGroupsInfosCollection = infosAllInspectedDirectories.get(curDirectory);
                    Intrinsics.checkNotNull((Object)inspectionGroupsInfosCollection);
                    stringArray[1] = InspectionInfoQodanaReporterService.logDirectoriesInspectionsInfo$lambda$13$inspectionGroupsInfosToCSVLine(valuesToPrintBuffer, this$0, inspectionGroupsInfosCollection.unbox-impl());
                    bufferedWriter.write(inspectionInfoQodanaReporterService.toCSVLine(stringArray));
                }
                directoriesStackDFS.addAll((Collection)inspectedSubDirectories);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable) {
            object2 = throwable;
            throw throwable;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)object2);
        }
        return Unit.INSTANCE;
    }

    private static final boolean _inspectionGroups$lambda$16(FinishedInspectionDescriptor it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return true;
    }

    /*
     * WARNING - void declaration
     */
    static {
        void var3_3;
        void $this$mapTo$iv$iv;
        Companion = new Companion(null);
        Object[] objectArray = new InspectionGroup[]{new InspectionGroup("all", (Function1<? super FinishedInspectionDescriptor, Boolean>)((Function1)InspectionInfoQodanaReporterService::_inspectionGroups$lambda$16))};
        _inspectionGroups = CollectionsKt.mutableListOf((Object[])objectArray);
        List<InspectionGroup> list2 = _inspectionGroups;
        Intrinsics.checkNotNull(list2, (String)"null cannot be cast to non-null type kotlin.collections.List<org.jetbrains.qodana.staticAnalysis.stat.InspectionInfoQodanaReporterService.InspectionGroup>");
        inspectionGroups = list2;
        Iterable $this$map$iv = inspectionGroups;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            InspectionGroup inspectionGroup = (InspectionGroup)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getGroupName());
        }
        mapInspectionGroupNameToIdx = MapsKt.toMap((Iterable)CollectionsKt.zip((Iterable)((List)var3_3), (Iterable)((Iterable)CollectionsKt.getIndices((Collection)inspectionGroups))));
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0006J\u000e\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u0014J\b\u0010\u0018\u001a\u00020\u0010H\u0002R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001a\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00170\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/qodana/staticAnalysis/stat/InspectionInfoQodanaReporterService$Companion;", "", "<init>", "()V", "_inspectionGroups", "", "Lorg/jetbrains/qodana/staticAnalysis/stat/InspectionInfoQodanaReporterService$InspectionGroup;", "inspectionGroups", "", "getInspectionGroups", "()Ljava/util/List;", "getInstance", "Lorg/jetbrains/qodana/staticAnalysis/stat/InspectionInfoQodanaReporterService;", "project", "Lcom/intellij/openapi/project/Project;", "addInspectionGroup", "", "inspectionGroup", "removeInspectionGroupByName", "groupName", "", "mapInspectionGroupNameToIdx", "", "", "updateMapInspectionGroupNameToIdx", "intellij.qodana"})
    @SourceDebugExtension(value={"SMAP\nInspectionInfoQodanaReporterService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InspectionInfoQodanaReporterService.kt\norg/jetbrains/qodana/staticAnalysis/stat/InspectionInfoQodanaReporterService$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,334:1\n31#2,2:335\n1557#3:337\n1628#3,3:338\n*S KotlinDebug\n*F\n+ 1 InspectionInfoQodanaReporterService.kt\norg/jetbrains/qodana/staticAnalysis/stat/InspectionInfoQodanaReporterService$Companion\n*L\n41#1:335,2\n63#1:337\n63#1:338,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final List<InspectionGroup> getInspectionGroups() {
            return inspectionGroups;
        }

        @NotNull
        public final InspectionInfoQodanaReporterService getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<InspectionInfoQodanaReporterService> serviceClass$iv = InspectionInfoQodanaReporterService.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (InspectionInfoQodanaReporterService)object;
        }

        public final void addInspectionGroup(@NotNull InspectionGroup inspectionGroup) {
            boolean bl;
            Intrinsics.checkNotNullParameter((Object)inspectionGroup, (String)"inspectionGroup");
            boolean bl2 = bl = !Intrinsics.areEqual((Object)inspectionGroup.getGroupName(), (Object)"all");
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw new AssertionError((Object)string);
            }
            CollectionsKt.removeAll((List)_inspectionGroups, arg_0 -> Companion.addInspectionGroup$lambda$0(inspectionGroup, arg_0));
            _inspectionGroups.add(inspectionGroup);
            this.updateMapInspectionGroupNameToIdx();
        }

        public final void removeInspectionGroupByName(@NotNull String groupName) {
            boolean bl;
            Intrinsics.checkNotNullParameter((Object)groupName, (String)"groupName");
            boolean bl2 = bl = !Intrinsics.areEqual((Object)groupName, (Object)"all");
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw new AssertionError((Object)string);
            }
            CollectionsKt.removeAll((List)_inspectionGroups, arg_0 -> Companion.removeInspectionGroupByName$lambda$1(groupName, arg_0));
            this.updateMapInspectionGroupNameToIdx();
        }

        /*
         * WARNING - void declaration
         */
        private final void updateMapInspectionGroupNameToIdx() {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = this.getInspectionGroups();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                InspectionGroup inspectionGroup = (InspectionGroup)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getGroupName());
            }
            mapInspectionGroupNameToIdx = MapsKt.toMap((Iterable)CollectionsKt.zip((Iterable)((List)destination$iv$iv), (Iterable)((Iterable)CollectionsKt.getIndices((Collection)this.getInspectionGroups()))));
        }

        private static final boolean addInspectionGroup$lambda$0(InspectionGroup $inspectionGroup, InspectionGroup it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return Intrinsics.areEqual((Object)it.getGroupName(), (Object)$inspectionGroup.getGroupName());
        }

        private static final boolean removeInspectionGroupByName$lambda$1(String $groupName, InspectionGroup it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return Intrinsics.areEqual((Object)it.getGroupName(), (Object)$groupName);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u000e\u0010\b\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\t\u00a2\u0006\u0004\b\n\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0019\u0010\b\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0015\u0010\u0014\u001a\u00060\u0015j\u0002`\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/qodana/staticAnalysis/stat/InspectionInfoQodanaReporterService$FinishedInspectionDescriptor;", "", "duration", "", "problemsCount", "", "kind", "Lcom/intellij/codeInspection/ex/InspectListener$InspectionKind;", "tool", "Lcom/intellij/codeInspection/ex/InspectionToolWrapper;", "<init>", "(JILcom/intellij/codeInspection/ex/InspectListener$InspectionKind;Lcom/intellij/codeInspection/ex/InspectionToolWrapper;)V", "getDuration", "()J", "getProblemsCount", "()I", "getKind", "()Lcom/intellij/codeInspection/ex/InspectListener$InspectionKind;", "getTool", "()Lcom/intellij/codeInspection/ex/InspectionToolWrapper;", "inspectionKey", "", "Lorg/jetbrains/qodana/staticAnalysis/stat/InspectionKey;", "getInspectionKey", "()Ljava/lang/String;", "intellij.qodana"})
    public static final class FinishedInspectionDescriptor {
        private final long duration;
        private final int problemsCount;
        @NotNull
        private final InspectListener.InspectionKind kind;
        @NotNull
        private final InspectionToolWrapper<?, ?> tool;
        @NotNull
        private final String inspectionKey;

        public FinishedInspectionDescriptor(long duration, int problemsCount, @NotNull InspectListener.InspectionKind kind, @NotNull InspectionToolWrapper<?, ?> tool) {
            Intrinsics.checkNotNullParameter((Object)kind, (String)"kind");
            Intrinsics.checkNotNullParameter(tool, (String)"tool");
            this.duration = duration;
            this.problemsCount = problemsCount;
            this.kind = kind;
            this.tool = tool;
            String string = this.tool.getID();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getID(...)");
            this.inspectionKey = string;
        }

        public final long getDuration() {
            return this.duration;
        }

        public final int getProblemsCount() {
            return this.problemsCount;
        }

        @NotNull
        public final InspectListener.InspectionKind getKind() {
            return this.kind;
        }

        @NotNull
        public final InspectionToolWrapper<?, ?> getTool() {
            return this.tool;
        }

        @NotNull
        public final String getInspectionKey() {
            return this.inspectionKey;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\t\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\u0004\b\b\u0010\tJ\u0011\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0006H\u0086\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001d\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/qodana/staticAnalysis/stat/InspectionInfoQodanaReporterService$InspectionGroup;", "", "groupName", "", "containsInspection", "Lkotlin/Function1;", "Lorg/jetbrains/qodana/staticAnalysis/stat/InspectionInfoQodanaReporterService$FinishedInspectionDescriptor;", "", "<init>", "(Ljava/lang/String;Lkotlin/jvm/functions/Function1;)V", "getGroupName", "()Ljava/lang/String;", "getContainsInspection", "()Lkotlin/jvm/functions/Function1;", "contains", "finishedInspectionDescriptor", "intellij.qodana"})
    public static final class InspectionGroup {
        @NotNull
        private final String groupName;
        @NotNull
        private final Function1<FinishedInspectionDescriptor, Boolean> containsInspection;

        public InspectionGroup(@NotNull String groupName, @NotNull Function1<? super FinishedInspectionDescriptor, Boolean> containsInspection) {
            Intrinsics.checkNotNullParameter((Object)groupName, (String)"groupName");
            Intrinsics.checkNotNullParameter(containsInspection, (String)"containsInspection");
            this.groupName = groupName;
            this.containsInspection = containsInspection;
        }

        @NotNull
        public final String getGroupName() {
            return this.groupName;
        }

        @NotNull
        public final Function1<FinishedInspectionDescriptor, Boolean> getContainsInspection() {
            return this.containsInspection;
        }

        public final boolean contains(@NotNull FinishedInspectionDescriptor finishedInspectionDescriptor) {
            Intrinsics.checkNotNullParameter((Object)finishedInspectionDescriptor, (String)"finishedInspectionDescriptor");
            return (Boolean)this.containsInspection.invoke((Object)finishedInspectionDescriptor);
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @JvmInline
    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0007\b\u0083@\u0018\u00002\u00020\u0001:\u0001\"B\u0017\u0012\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0015\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\u0015\u0010\u000e\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u0000\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0018\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u0014H\u0086\u0002\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u001a\u0010\u0017\u001a\u00020\u00182\b\u0010\u000f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u0010\u0010\u001b\u001a\u00020\u001cH\u00d6\u0001\u00a2\u0006\u0004\b\u001d\u0010\u001eJ\u0010\u0010\u001f\u001a\u00020\u0014H\u00d6\u0001\u00a2\u0006\u0004\b \u0010!R\u0016\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007\u0088\u0001\u0002\u0092\u0001\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a8\u0006#"}, d2={"Lorg/jetbrains/qodana/staticAnalysis/stat/InspectionInfoQodanaReporterService$InspectionGroupsInfosCollection;", "", "arrInspectionGroupsInfos", "", "Lorg/jetbrains/qodana/staticAnalysis/stat/InspectionInfoQodanaReporterService$InspectionGroupsInfosCollection$InspectionGroupInfo;", "constructor-impl", "([Lorg/jetbrains/qodana/staticAnalysis/stat/InspectionInfoQodanaReporterService$InspectionGroupsInfosCollection$InspectionGroupInfo;)[Lorg/jetbrains/qodana/staticAnalysis/stat/InspectionInfoQodanaReporterService$InspectionGroupsInfosCollection$InspectionGroupInfo;", "[Lorg/jetbrains/qodana/staticAnalysis/stat/InspectionInfoQodanaReporterService$InspectionGroupsInfosCollection$InspectionGroupInfo;", "addFinishedInspection", "", "finishedInspection", "Lorg/jetbrains/qodana/staticAnalysis/stat/InspectionInfoQodanaReporterService$FinishedInspectionDescriptor;", "addFinishedInspection-impl", "([Lorg/jetbrains/qodana/staticAnalysis/stat/InspectionInfoQodanaReporterService$InspectionGroupsInfosCollection$InspectionGroupInfo;Lorg/jetbrains/qodana/staticAnalysis/stat/InspectionInfoQodanaReporterService$FinishedInspectionDescriptor;)V", "add", "other", "add-x7W0VSw", "([Lorg/jetbrains/qodana/staticAnalysis/stat/InspectionInfoQodanaReporterService$InspectionGroupsInfosCollection$InspectionGroupInfo;[Lorg/jetbrains/qodana/staticAnalysis/stat/InspectionInfoQodanaReporterService$InspectionGroupsInfosCollection$InspectionGroupInfo;)V", "get", "groupName", "", "get-impl", "([Lorg/jetbrains/qodana/staticAnalysis/stat/InspectionInfoQodanaReporterService$InspectionGroupsInfosCollection$InspectionGroupInfo;Ljava/lang/String;)Lorg/jetbrains/qodana/staticAnalysis/stat/InspectionInfoQodanaReporterService$InspectionGroupsInfosCollection$InspectionGroupInfo;", "equals", "", "equals-impl", "([Lorg/jetbrains/qodana/staticAnalysis/stat/InspectionInfoQodanaReporterService$InspectionGroupsInfosCollection$InspectionGroupInfo;Ljava/lang/Object;)Z", "hashCode", "", "hashCode-impl", "([Lorg/jetbrains/qodana/staticAnalysis/stat/InspectionInfoQodanaReporterService$InspectionGroupsInfosCollection$InspectionGroupInfo;)I", "toString", "toString-impl", "([Lorg/jetbrains/qodana/staticAnalysis/stat/InspectionInfoQodanaReporterService$InspectionGroupsInfosCollection$InspectionGroupInfo;)Ljava/lang/String;", "InspectionGroupInfo", "intellij.qodana"})
    @SourceDebugExtension(value={"SMAP\nInspectionInfoQodanaReporterService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InspectionInfoQodanaReporterService.kt\norg/jetbrains/qodana/staticAnalysis/stat/InspectionInfoQodanaReporterService$InspectionGroupsInfosCollection\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,334:1\n3829#2:335\n4344#2,2:336\n1863#3,2:338\n1863#3,2:340\n*S KotlinDebug\n*F\n+ 1 InspectionInfoQodanaReporterService.kt\norg/jetbrains/qodana/staticAnalysis/stat/InspectionInfoQodanaReporterService$InspectionGroupsInfosCollection\n*L\n133#1:335\n133#1:336,2\n134#1:338,2\n141#1:340,2\n*E\n"})
    private static final class InspectionGroupsInfosCollection {
        @NotNull
        private final InspectionGroupInfo[] arrInspectionGroupsInfos;

        /*
         * WARNING - void declaration
         */
        public static final void addFinishedInspection-impl(InspectionGroupInfo[] arg0, @NotNull FinishedInspectionDescriptor finishedInspection) {
            void $this$filterTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)finishedInspection, (String)"finishedInspection");
            InspectionGroupInfo[] $this$filter$iv = arg0;
            boolean $i$f$filter = false;
            InspectionGroupInfo[] inspectionGroupInfoArray = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            int n = ((void)$this$filterTo$iv$iv).length;
            for (int i = 0; i < n; ++i) {
                void element$iv$iv;
                void it = element$iv$iv = $this$filterTo$iv$iv[i];
                boolean bl = false;
                if (!it.getInspectionGroup().contains(finishedInspection)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $this$forEach$iv = (List)destination$iv$iv;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                InspectionGroupInfo it = (InspectionGroupInfo)element$iv;
                boolean bl = false;
                it.setInspectionsDuration(it.getInspectionsDuration() + finishedInspection.getDuration());
                it.setProblemsCount(it.getProblemsCount() + finishedInspection.getProblemsCount());
                it.setPerformedTimesCount(it.getPerformedTimesCount() + 1);
            }
        }

        public static final void add-x7W0VSw(InspectionGroupInfo[] arg0, @NotNull InspectionGroupInfo[] other) {
            Intrinsics.checkNotNullParameter((Object)other, (String)"other");
            Iterable $this$forEach$iv = ArraysKt.zip((Object[])arg0, (Object[])other);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Pair pair = (Pair)element$iv;
                boolean bl = false;
                InspectionGroupInfo thisInfo = (InspectionGroupInfo)pair.component1();
                InspectionGroupInfo otherInfo = (InspectionGroupInfo)pair.component2();
                thisInfo.setInspectionsDuration(thisInfo.getInspectionsDuration() + otherInfo.getInspectionsDuration());
                thisInfo.setProblemsCount(thisInfo.getProblemsCount() + otherInfo.getProblemsCount());
                thisInfo.setPerformedTimesCount(thisInfo.getPerformedTimesCount() + otherInfo.getPerformedTimesCount());
            }
        }

        @NotNull
        public static final InspectionGroupInfo get-impl(InspectionGroupInfo[] arg0, @NotNull String groupName) {
            Intrinsics.checkNotNullParameter((Object)groupName, (String)"groupName");
            boolean bl = mapInspectionGroupNameToIdx.containsKey(groupName);
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw new AssertionError((Object)string);
            }
            Object v = mapInspectionGroupNameToIdx.get(groupName);
            Intrinsics.checkNotNull(v);
            return arg0[((Number)v).intValue()];
        }

        public static String toString-impl(InspectionGroupInfo[] arg0) {
            return "InspectionGroupsInfosCollection(arrInspectionGroupsInfos=" + Arrays.toString(arg0) + ")";
        }

        public String toString() {
            return InspectionGroupsInfosCollection.toString-impl(this.arrInspectionGroupsInfos);
        }

        public static int hashCode-impl(InspectionGroupInfo[] arg0) {
            return Arrays.hashCode(arg0);
        }

        public int hashCode() {
            return InspectionGroupsInfosCollection.hashCode-impl(this.arrInspectionGroupsInfos);
        }

        public static boolean equals-impl(InspectionGroupInfo[] arg0, Object other) {
            if (!(other instanceof InspectionGroupsInfosCollection)) {
                return false;
            }
            return Intrinsics.areEqual((Object)arg0, (Object)((InspectionGroupsInfosCollection)other).unbox-impl());
        }

        public boolean equals(Object other) {
            return InspectionGroupsInfosCollection.equals-impl(this.arrInspectionGroupsInfos, other);
        }

        private /* synthetic */ InspectionGroupsInfosCollection(InspectionGroupInfo[] arrInspectionGroupsInfos) {
            this.arrInspectionGroupsInfos = arrInspectionGroupsInfos;
        }

        @NotNull
        public static InspectionGroupInfo[] constructor-impl(@NotNull InspectionGroupInfo[] arrInspectionGroupsInfos) {
            Intrinsics.checkNotNullParameter((Object)arrInspectionGroupsInfos, (String)"arrInspectionGroupsInfos");
            return arrInspectionGroupsInfos;
        }

        public static /* synthetic */ InspectionGroupInfo[] constructor-impl$default(InspectionGroupInfo[] inspectionGroupInfoArray, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                int n2 = 0;
                int n3 = Companion.getInspectionGroups().size();
                InspectionGroupInfo[] inspectionGroupInfoArray2 = new InspectionGroupInfo[n3];
                while (n2 < n3) {
                    int n4 = n2++;
                    inspectionGroupInfoArray2[n4] = new InspectionGroupInfo(Companion.getInspectionGroups().get(n4), 0L, 0, 0, 14, null);
                }
                inspectionGroupInfoArray = inspectionGroupInfoArray2;
            }
            return InspectionGroupsInfosCollection.constructor-impl(inspectionGroupInfoArray);
        }

        public static final /* synthetic */ InspectionGroupsInfosCollection box-impl(InspectionGroupInfo[] v) {
            return new InspectionGroupsInfosCollection(v);
        }

        public final /* synthetic */ InspectionGroupInfo[] unbox-impl() {
            return this.arrInspectionGroupsInfos;
        }

        public static final boolean equals-impl0(InspectionGroupInfo[] p1, InspectionGroupInfo[] p2) {
            return Intrinsics.areEqual((Object)p1, (Object)p2);
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0002\b\u0010\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u001a\u0010\b\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0012\"\u0004\b\u0016\u0010\u0014\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/qodana/staticAnalysis/stat/InspectionInfoQodanaReporterService$InspectionGroupsInfosCollection$InspectionGroupInfo;", "", "inspectionGroup", "Lorg/jetbrains/qodana/staticAnalysis/stat/InspectionInfoQodanaReporterService$InspectionGroup;", "inspectionsDuration", "", "problemsCount", "", "performedTimesCount", "<init>", "(Lorg/jetbrains/qodana/staticAnalysis/stat/InspectionInfoQodanaReporterService$InspectionGroup;JII)V", "getInspectionGroup", "()Lorg/jetbrains/qodana/staticAnalysis/stat/InspectionInfoQodanaReporterService$InspectionGroup;", "getInspectionsDuration", "()J", "setInspectionsDuration", "(J)V", "getProblemsCount", "()I", "setProblemsCount", "(I)V", "getPerformedTimesCount", "setPerformedTimesCount", "intellij.qodana"})
        public static final class InspectionGroupInfo {
            @NotNull
            private final InspectionGroup inspectionGroup;
            private long inspectionsDuration;
            private int problemsCount;
            private int performedTimesCount;

            public InspectionGroupInfo(@NotNull InspectionGroup inspectionGroup, long inspectionsDuration, int problemsCount, int performedTimesCount) {
                Intrinsics.checkNotNullParameter((Object)inspectionGroup, (String)"inspectionGroup");
                this.inspectionGroup = inspectionGroup;
                this.inspectionsDuration = inspectionsDuration;
                this.problemsCount = problemsCount;
                this.performedTimesCount = performedTimesCount;
            }

            public /* synthetic */ InspectionGroupInfo(InspectionGroup inspectionGroup, long l, int n, int n2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
                if ((n3 & 2) != 0) {
                    l = 0L;
                }
                if ((n3 & 4) != 0) {
                    n = 0;
                }
                if ((n3 & 8) != 0) {
                    n2 = 0;
                }
                this(inspectionGroup, l, n, n2);
            }

            @NotNull
            public final InspectionGroup getInspectionGroup() {
                return this.inspectionGroup;
            }

            public final long getInspectionsDuration() {
                return this.inspectionsDuration;
            }

            public final void setInspectionsDuration(long l) {
                this.inspectionsDuration = l;
            }

            public final int getProblemsCount() {
                return this.problemsCount;
            }

            public final void setProblemsCount(int n) {
                this.problemsCount = n;
            }

            public final int getPerformedTimesCount() {
                return this.performedTimesCount;
            }

            public final void setPerformedTimesCount(int n) {
                this.performedTimesCount = n;
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0013\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001BG\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0006\u0010\n\u001a\u00020\b\u0012\u0006\u0010\u000b\u001a\u00020\b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0004\b\u000e\u0010\u000fB\u0011\b\u0016\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\u0004\b\u000e\u0010\u0012J\u000e\u0010$\u001a\u00020%2\u0006\u0010\u0010\u001a\u00020\u0011R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u001a\u0010\u0006\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u0018\"\u0004\b\u001c\u0010\u001aR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0011\u0010\t\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u001eR\u0011\u0010\n\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u001eR\u0011\u0010\u000b\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\u001eR\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#\u00a8\u0006&"}, d2={"Lorg/jetbrains/qodana/staticAnalysis/stat/InspectionInfoQodanaReporterService$InspectionInfo;", "", "duration", "", "problemsCount", "", "performedTimesCount", "id", "", "displayName", "groupPath", "language", "kind", "Lcom/intellij/codeInspection/ex/InspectListener$InspectionKind;", "<init>", "(JIILjava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lcom/intellij/codeInspection/ex/InspectListener$InspectionKind;)V", "descriptor", "Lorg/jetbrains/qodana/staticAnalysis/stat/InspectionInfoQodanaReporterService$FinishedInspectionDescriptor;", "(Lorg/jetbrains/qodana/staticAnalysis/stat/InspectionInfoQodanaReporterService$FinishedInspectionDescriptor;)V", "getDuration", "()J", "setDuration", "(J)V", "getProblemsCount", "()I", "setProblemsCount", "(I)V", "getPerformedTimesCount", "setPerformedTimesCount", "getId", "()Ljava/lang/String;", "getDisplayName", "getGroupPath", "getLanguage", "getKind", "()Lcom/intellij/codeInspection/ex/InspectListener$InspectionKind;", "addFinishedInspection", "", "intellij.qodana"})
    private static final class InspectionInfo {
        private long duration;
        private int problemsCount;
        private int performedTimesCount;
        @NotNull
        private final String id;
        @NotNull
        private final String displayName;
        @NotNull
        private final String groupPath;
        @NotNull
        private final String language;
        @NotNull
        private final InspectListener.InspectionKind kind;

        public InspectionInfo(long duration, int problemsCount, int performedTimesCount, @NotNull String id, @NotNull String displayName, @NotNull String groupPath, @NotNull String language, @NotNull InspectListener.InspectionKind kind) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            Intrinsics.checkNotNullParameter((Object)displayName, (String)"displayName");
            Intrinsics.checkNotNullParameter((Object)groupPath, (String)"groupPath");
            Intrinsics.checkNotNullParameter((Object)language, (String)"language");
            Intrinsics.checkNotNullParameter((Object)kind, (String)"kind");
            this.duration = duration;
            this.problemsCount = problemsCount;
            this.performedTimesCount = performedTimesCount;
            this.id = id;
            this.displayName = displayName;
            this.groupPath = groupPath;
            this.language = language;
            this.kind = kind;
        }

        public final long getDuration() {
            return this.duration;
        }

        public final void setDuration(long l) {
            this.duration = l;
        }

        public final int getProblemsCount() {
            return this.problemsCount;
        }

        public final void setProblemsCount(int n) {
            this.problemsCount = n;
        }

        public final int getPerformedTimesCount() {
            return this.performedTimesCount;
        }

        public final void setPerformedTimesCount(int n) {
            this.performedTimesCount = n;
        }

        @NotNull
        public final String getId() {
            return this.id;
        }

        @NotNull
        public final String getDisplayName() {
            return this.displayName;
        }

        @NotNull
        public final String getGroupPath() {
            return this.groupPath;
        }

        @NotNull
        public final String getLanguage() {
            return this.language;
        }

        @NotNull
        public final InspectListener.InspectionKind getKind() {
            return this.kind;
        }

        public InspectionInfo(@NotNull FinishedInspectionDescriptor descriptor) {
            Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
            long l = descriptor.getDuration();
            int n = descriptor.getProblemsCount();
            String string = descriptor.getTool().getID();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getID(...)");
            String string2 = descriptor.getTool().getDisplayName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getDisplayName(...)");
            String[] stringArray = descriptor.getTool().getGroupPath();
            Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"getGroupPath(...)");
            String string3 = InspectionCategoryGroupProviderKt.makeCategoryId((String[])stringArray);
            String string4 = descriptor.getTool().getLanguage();
            if (string4 == null) {
                string4 = "none";
            }
            this(l, n, 1, string, string2, string3, string4, descriptor.getKind());
        }

        public final void addFinishedInspection(@NotNull FinishedInspectionDescriptor descriptor) {
            Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
            boolean bl = Intrinsics.areEqual((Object)this.id, (Object)descriptor.getTool().getID());
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw new AssertionError((Object)string);
            }
            this.duration += descriptor.getDuration();
            this.problemsCount += descriptor.getProblemsCount();
            ++this.performedTimesCount;
        }
    }
}

