/*  Part of XPCE --- The SWI-Prolog GUI toolkit

    Author:        Jan Wielemaker
    E-mail:        jan@swi-prolog.org
    WWW:           https://www.swi-prolog.org
    Copyright (c)  2025, SWI-Prolog Solutions b.v.
    All rights reserved.

    Redistribution and use in source and binary forms, with or without
    modification, are permitted provided that the following conditions
    are met:

    1. Redistributions of source code must retain the above copyright
       notice, this list of conditions and the following disclaimer.

    2. Redistributions in binary form must reproduce the above copyright
       notice, this list of conditions and the following disclaimer in
       the documentation and/or other materials provided with the
       distribution.

    THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
    "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
    LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
    FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
    COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
    INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
    BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
    LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
    CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
    LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN
    ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
    POSSIBILITY OF SUCH DAMAGE.
*/

#ifndef RAYMENU_H
#define RAYMENU_H

status ws_draw_scrollbar_arrow(ScrollBar s, int x, int y, int w, int h, Name which, int up);
int ws_arrow_height_scrollbar(ScrollBar s);
status ws_draw_sb_thumb(int x, int y, int w, int h);
Colour ws_3d_grey(void);
status ws_draw_button_face(DialogItem di, int x, int y, int w, int h, int up, int defb, int focus);
int ws_combo_box_width(Graphical gr);
int ws_stepper_width(Graphical gr);
int ws_entry_field_margin(void);
status ws_entry_field(Graphical gr, int x, int y, int w, int h, int flags);
status ws_draw_checkbox(int x, int y, int w, int h, int b, int flags);
status ws_checkbox_size(int flags, int *w, int *h);
int ws_message_box(Any client, CharArray title, CharArray msg, int flags);

#endif /* RAYMENU_H */
