﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/chatbot/model/UpdateCustomActionRequest.h>
#include <aws/core/utils/json/JsonSerializer.h>

#include <utility>

using namespace Aws::chatbot::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;

Aws::String UpdateCustomActionRequest::SerializePayload() const {
  JsonValue payload;

  if (m_customActionArnHasBeenSet) {
    payload.WithString("CustomActionArn", m_customActionArn);
  }

  if (m_definitionHasBeenSet) {
    payload.WithObject("Definition", m_definition.Jsonize());
  }

  if (m_aliasNameHasBeenSet) {
    payload.WithString("AliasName", m_aliasName);
  }

  if (m_attachmentsHasBeenSet) {
    Aws::Utils::Array<JsonValue> attachmentsJsonList(m_attachments.size());
    for (unsigned attachmentsIndex = 0; attachmentsIndex < attachmentsJsonList.GetLength(); ++attachmentsIndex) {
      attachmentsJsonList[attachmentsIndex].AsObject(m_attachments[attachmentsIndex].Jsonize());
    }
    payload.WithArray("Attachments", std::move(attachmentsJsonList));
  }

  return payload.View().WriteReadable();
}
