---
title: watchman-replicate-subscription
category: Invocation
sidebar_position: 4
---

_Since 5.0_

`watchman-replicate-subscription` can replicate an existing watchman
subscription. It queries watchman for a list of subscriptions, identifies the
source subscription (the subscription to replicate) and subscribes to watchman
using the same query.

Integrators can use this client to validate the watchman notifications their
client is receiving to localize anomalous behavior.

The source subscription is identified using any combination of the 'name',
'pid', and 'client' arguments. The provided combination must uniquely identify a
subscription. Source subscription details for a watched root can be retrieved by
running the command 'watchman-replicate-subscription --list PATH'.

By default, the replicated subscription will take the source subscription name
and prepend the substring 'replicate: ' to it. The 'qname' option can be used to
specify the replicated subscription name.

The subscription can stop after a configurable number of events are observed.
The default is a single event. You may also remove the limit and allow it to
execute continuously.

watchman-replicate-subscription will print one event per line. The event
information is determined by the fields in the identified subscription, with
each field separated by a space (or your choice of --separator).

Subscription state-enter and state-leave PDUs will be interleaved with other
events. Known subscription PDUs (currently only those generated by the mercurial
fsmonitor extension) will be enclosed in square brackets. All others will be
output in JSON format.

Events are consolidated and settled by the watchman server before they are
dispatched to watchman-replicate-subscription.

`watchman-replicate-subscription` requires pywatchman (and thus requires python)
as well as watchman.

### Source subscription

```bash
$ watchman-replicate-subscription PATH -n NAME
```

The source subscription must be an existing subscription for the provided path.
Any combination of the 'name', 'pid', and 'client' arguments can be used
provided they uniquely identify a subscription. Source subscription details for
a watched root can be retrieved as follows:

```bash
$ watchman-replicate-subscriptions PATH --list
```

The subscription name, pid and client can then used to replicate the
subscription.

```bash
$ watchman-replicate-subscription PATH -n NAME -c CLIENT -p PID
```

### Controlling lifetime

There are two primary controls for how long `watchman-replicate-subscription`
will run:

- `-t` or `--timeout` places a time limit on execution
- `-m` or `--max-events` places a limit on the number of events to process

`watchman-replicate-subscription` will terminate when either the timeout is hit
or the max events limit is hit.

By default there is no time limit, but there is a default limit of a single
event.

You may specify `--max-events 0` to disable the event limit.

### Controlling output

`watchman-replicate-subscription` will output one line per event. The following
options influence the output:

- `--separator STRING` - if you specified multiple fields, the separator string
  will be used when printing them. The default is `--separator " "` which will
  print the fields with spaces between them.

### Exit Status

The following exit status codes can be used to determine what caused
`watchman-replicate-subscription` to exit:

- `0` is returned after successfully waiting for event(s) or listing matching
  subscriptions
- `1` in case of a runtime error of some kind
- `2` the `-t`/`--timeout` option was used and that amount of time passed before
  an event was received
- `3` if execution was interrupted (Ctrl-C)
