// Code generated by tools/cmd/genjwa/main.go. DO NOT EDIT

package jwa_test

import (
	"encoding/json"
	"strconv"
	"testing"

	"github.com/lestrrat-go/jwx/v3/jwa"
	"github.com/stretchr/testify/require"
)

func TestContentEncryptionAlgorithm(t *testing.T) {
	t.Parallel()
	t.Run(`Lookup the object`, func(t *testing.T) {
		t.Parallel()
		v, ok := jwa.LookupContentEncryptionAlgorithm("A128CBC-HS256")
		require.True(t, ok, `Lookup should succeed`)
		require.Equal(t, jwa.A128CBC_HS256(), v, `Lookup value should be equal to constant`)
	})
	t.Run(`Unmarshal the string A128CBC-HS256`, func(t *testing.T) {
		t.Parallel()
		var dst jwa.ContentEncryptionAlgorithm
		require.NoError(t, json.Unmarshal([]byte(strconv.Quote("A128CBC-HS256")), &dst), `UnmarshalJSON is successful`)
		require.Equal(t, jwa.A128CBC_HS256(), dst, `unmarshaled value should be equal to constant`)
	})
	t.Run(`stringification for A128CBC-HS256`, func(t *testing.T) {
		t.Parallel()
		require.Equal(t, "A128CBC-HS256", jwa.A128CBC_HS256().String(), `stringified value matches`)
	})
	t.Run(`Lookup the object`, func(t *testing.T) {
		t.Parallel()
		v, ok := jwa.LookupContentEncryptionAlgorithm("A128GCM")
		require.True(t, ok, `Lookup should succeed`)
		require.Equal(t, jwa.A128GCM(), v, `Lookup value should be equal to constant`)
	})
	t.Run(`Unmarshal the string A128GCM`, func(t *testing.T) {
		t.Parallel()
		var dst jwa.ContentEncryptionAlgorithm
		require.NoError(t, json.Unmarshal([]byte(strconv.Quote("A128GCM")), &dst), `UnmarshalJSON is successful`)
		require.Equal(t, jwa.A128GCM(), dst, `unmarshaled value should be equal to constant`)
	})
	t.Run(`stringification for A128GCM`, func(t *testing.T) {
		t.Parallel()
		require.Equal(t, "A128GCM", jwa.A128GCM().String(), `stringified value matches`)
	})
	t.Run(`Lookup the object`, func(t *testing.T) {
		t.Parallel()
		v, ok := jwa.LookupContentEncryptionAlgorithm("A192CBC-HS384")
		require.True(t, ok, `Lookup should succeed`)
		require.Equal(t, jwa.A192CBC_HS384(), v, `Lookup value should be equal to constant`)
	})
	t.Run(`Unmarshal the string A192CBC-HS384`, func(t *testing.T) {
		t.Parallel()
		var dst jwa.ContentEncryptionAlgorithm
		require.NoError(t, json.Unmarshal([]byte(strconv.Quote("A192CBC-HS384")), &dst), `UnmarshalJSON is successful`)
		require.Equal(t, jwa.A192CBC_HS384(), dst, `unmarshaled value should be equal to constant`)
	})
	t.Run(`stringification for A192CBC-HS384`, func(t *testing.T) {
		t.Parallel()
		require.Equal(t, "A192CBC-HS384", jwa.A192CBC_HS384().String(), `stringified value matches`)
	})
	t.Run(`Lookup the object`, func(t *testing.T) {
		t.Parallel()
		v, ok := jwa.LookupContentEncryptionAlgorithm("A192GCM")
		require.True(t, ok, `Lookup should succeed`)
		require.Equal(t, jwa.A192GCM(), v, `Lookup value should be equal to constant`)
	})
	t.Run(`Unmarshal the string A192GCM`, func(t *testing.T) {
		t.Parallel()
		var dst jwa.ContentEncryptionAlgorithm
		require.NoError(t, json.Unmarshal([]byte(strconv.Quote("A192GCM")), &dst), `UnmarshalJSON is successful`)
		require.Equal(t, jwa.A192GCM(), dst, `unmarshaled value should be equal to constant`)
	})
	t.Run(`stringification for A192GCM`, func(t *testing.T) {
		t.Parallel()
		require.Equal(t, "A192GCM", jwa.A192GCM().String(), `stringified value matches`)
	})
	t.Run(`Lookup the object`, func(t *testing.T) {
		t.Parallel()
		v, ok := jwa.LookupContentEncryptionAlgorithm("A256CBC-HS512")
		require.True(t, ok, `Lookup should succeed`)
		require.Equal(t, jwa.A256CBC_HS512(), v, `Lookup value should be equal to constant`)
	})
	t.Run(`Unmarshal the string A256CBC-HS512`, func(t *testing.T) {
		t.Parallel()
		var dst jwa.ContentEncryptionAlgorithm
		require.NoError(t, json.Unmarshal([]byte(strconv.Quote("A256CBC-HS512")), &dst), `UnmarshalJSON is successful`)
		require.Equal(t, jwa.A256CBC_HS512(), dst, `unmarshaled value should be equal to constant`)
	})
	t.Run(`stringification for A256CBC-HS512`, func(t *testing.T) {
		t.Parallel()
		require.Equal(t, "A256CBC-HS512", jwa.A256CBC_HS512().String(), `stringified value matches`)
	})
	t.Run(`Lookup the object`, func(t *testing.T) {
		t.Parallel()
		v, ok := jwa.LookupContentEncryptionAlgorithm("A256GCM")
		require.True(t, ok, `Lookup should succeed`)
		require.Equal(t, jwa.A256GCM(), v, `Lookup value should be equal to constant`)
	})
	t.Run(`Unmarshal the string A256GCM`, func(t *testing.T) {
		t.Parallel()
		var dst jwa.ContentEncryptionAlgorithm
		require.NoError(t, json.Unmarshal([]byte(strconv.Quote("A256GCM")), &dst), `UnmarshalJSON is successful`)
		require.Equal(t, jwa.A256GCM(), dst, `unmarshaled value should be equal to constant`)
	})
	t.Run(`stringification for A256GCM`, func(t *testing.T) {
		t.Parallel()
		require.Equal(t, "A256GCM", jwa.A256GCM().String(), `stringified value matches`)
	})
	t.Run(`Unmarshal should fail for invalid value (totally made up) string value`, func(t *testing.T) {
		t.Parallel()
		var dst jwa.ContentEncryptionAlgorithm
		require.Error(t, json.Unmarshal([]byte(`totallyInvalidValue`), &dst), `Unmarshal should fail`)
	})
	t.Run(`check list of elements`, func(t *testing.T) {
		t.Parallel()
		var expected = map[jwa.ContentEncryptionAlgorithm]struct{}{
			jwa.A128CBC_HS256(): {},
			jwa.A128GCM():       {},
			jwa.A192CBC_HS384(): {},
			jwa.A192GCM():       {},
			jwa.A256CBC_HS512(): {},
			jwa.A256GCM():       {},
		}
		for _, v := range jwa.ContentEncryptionAlgorithms() {
			_, ok := expected[v]
			require.True(t, ok, `%q should be in the list for ContentEncryptionAlgorithm`, v)
			delete(expected, v)
		}
		require.Len(t, expected, 0)
	})
}

// Note: this test can NOT be run in parallel as it uses options with global effect.
func TestContentEncryptionAlgorithmCustomAlgorithm(t *testing.T) {
	// These subtests can NOT be run in parallel as options with global effect change.
	const customAlgorithmValue = `custom-algorithm`
	customAlgorithm := jwa.NewContentEncryptionAlgorithm(customAlgorithmValue)
	// Unregister the custom algorithm, in case tests fail.
	t.Cleanup(func() {
		jwa.UnregisterContentEncryptionAlgorithm(customAlgorithm)
	})
	t.Run(`with custom algorithm registered`, func(t *testing.T) {
		jwa.RegisterContentEncryptionAlgorithm(customAlgorithm)
		t.Run(`Lookup the object`, func(t *testing.T) {
			t.Parallel()
			v, ok := jwa.LookupContentEncryptionAlgorithm(customAlgorithmValue)
			require.True(t, ok, `Lookup should succeed`)
			require.Equal(t, customAlgorithm, v, `Lookup value should be equal to constant`)
		})
		t.Run(`Unmarshal custom algorithm`, func(t *testing.T) {
			t.Parallel()
			var dst jwa.ContentEncryptionAlgorithm
			require.NoError(t, json.Unmarshal([]byte(strconv.Quote(customAlgorithmValue)), &dst), `Unmarshal is successful`)
			require.Equal(t, customAlgorithm, dst, `accepted value should be equal to variable`)
		})
	})
	t.Run(`with custom algorithm deregistered`, func(t *testing.T) {
		jwa.UnregisterContentEncryptionAlgorithm(customAlgorithm)
		t.Run(`Lookup the object`, func(t *testing.T) {
			t.Parallel()
			_, ok := jwa.LookupContentEncryptionAlgorithm(customAlgorithmValue)
			require.False(t, ok, `Lookup should fail`)
		})
		t.Run(`Unmarshal custom algorithm`, func(t *testing.T) {
			t.Parallel()
			var dst jwa.ContentEncryptionAlgorithm
			require.Error(t, json.Unmarshal([]byte(customAlgorithmValue), &dst), `Unmarshal should fail`)
		})
	})
}
