/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.interpreter;

import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.UnsignedType;
import org.jetbrains.kotlin.ir.IrBuiltIns;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.IrElementBase;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrEnumEntry;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrParameterKind;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrTypeParameter;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.declarations.IrVariable;
import org.jetbrains.kotlin.ir.expressions.IrBlock;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrBranch;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrClassReference;
import org.jetbrains.kotlin.ir.expressions.IrConst;
import org.jetbrains.kotlin.ir.expressions.IrConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrDeclarationReference;
import org.jetbrains.kotlin.ir.expressions.IrDelegatingConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrDoWhileLoop;
import org.jetbrains.kotlin.ir.expressions.IrEnumConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionReference;
import org.jetbrains.kotlin.ir.expressions.IrGetClass;
import org.jetbrains.kotlin.ir.expressions.IrGetEnumValue;
import org.jetbrains.kotlin.ir.expressions.IrGetField;
import org.jetbrains.kotlin.ir.expressions.IrGetObjectValue;
import org.jetbrains.kotlin.ir.expressions.IrInstanceInitializerCall;
import org.jetbrains.kotlin.ir.expressions.IrPropertyReference;
import org.jetbrains.kotlin.ir.expressions.IrReturn;
import org.jetbrains.kotlin.ir.expressions.IrRichFunctionReference;
import org.jetbrains.kotlin.ir.expressions.IrRichPropertyReference;
import org.jetbrains.kotlin.ir.expressions.IrSetField;
import org.jetbrains.kotlin.ir.expressions.IrSetValue;
import org.jetbrains.kotlin.ir.expressions.IrStringConcatenation;
import org.jetbrains.kotlin.ir.expressions.IrThrow;
import org.jetbrains.kotlin.ir.expressions.IrTry;
import org.jetbrains.kotlin.ir.expressions.IrTypeOperator;
import org.jetbrains.kotlin.ir.expressions.IrTypeOperatorCall;
import org.jetbrains.kotlin.ir.expressions.IrVararg;
import org.jetbrains.kotlin.ir.expressions.IrVarargElement;
import org.jetbrains.kotlin.ir.expressions.IrWhen;
import org.jetbrains.kotlin.ir.expressions.IrWhileLoop;
import org.jetbrains.kotlin.ir.expressions.impl.BuildersKt;
import org.jetbrains.kotlin.ir.expressions.impl.IrConstructorCallImpl;
import org.jetbrains.kotlin.ir.interpreter.CallInterceptor;
import org.jetbrains.kotlin.ir.interpreter.CompoundInstruction;
import org.jetbrains.kotlin.ir.interpreter.CustomInstruction;
import org.jetbrains.kotlin.ir.interpreter.DefaultCallInterceptor;
import org.jetbrains.kotlin.ir.interpreter.Instruction;
import org.jetbrains.kotlin.ir.interpreter.InstructionKt;
import org.jetbrains.kotlin.ir.interpreter.InstructionsUnfolderKt;
import org.jetbrains.kotlin.ir.interpreter.IrInterpreterEnvironment;
import org.jetbrains.kotlin.ir.interpreter.SimpleInstruction;
import org.jetbrains.kotlin.ir.interpreter.UtilsKt;
import org.jetbrains.kotlin.ir.interpreter.exceptions.ExceptionUtilsKt;
import org.jetbrains.kotlin.ir.interpreter.exceptions.InterpreterAssertionError;
import org.jetbrains.kotlin.ir.interpreter.exceptions.InterpreterError;
import org.jetbrains.kotlin.ir.interpreter.exceptions.InterpreterTimeOutError;
import org.jetbrains.kotlin.ir.interpreter.proxy.CommonProxy;
import org.jetbrains.kotlin.ir.interpreter.proxy.Proxy;
import org.jetbrains.kotlin.ir.interpreter.stack.CallStack;
import org.jetbrains.kotlin.ir.interpreter.stack.Variable;
import org.jetbrains.kotlin.ir.interpreter.state.Common;
import org.jetbrains.kotlin.ir.interpreter.state.Complex;
import org.jetbrains.kotlin.ir.interpreter.state.ExceptionState;
import org.jetbrains.kotlin.ir.interpreter.state.Primitive;
import org.jetbrains.kotlin.ir.interpreter.state.State;
import org.jetbrains.kotlin.ir.interpreter.state.StateKt;
import org.jetbrains.kotlin.ir.interpreter.state.StateWithClosure;
import org.jetbrains.kotlin.ir.interpreter.state.Wrapper;
import org.jetbrains.kotlin.ir.interpreter.state.reflection.KClassState;
import org.jetbrains.kotlin.ir.interpreter.state.reflection.KFunctionState;
import org.jetbrains.kotlin.ir.interpreter.state.reflection.KPropertyState;
import org.jetbrains.kotlin.ir.interpreter.state.reflection.KTypeState;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrConstructorSymbol;
import org.jetbrains.kotlin.ir.symbols.IrFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrPropertySymbol;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.symbols.IrTypeParameterSymbol;
import org.jetbrains.kotlin.ir.symbols.IrValueParameterSymbol;
import org.jetbrains.kotlin.ir.symbols.IrValueSymbol;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypePredicatesKt;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.AdditionalIrUtilsKt;
import org.jetbrains.kotlin.ir.util.DeepCopyIrTreeWithSymbols;
import org.jetbrains.kotlin.ir.util.DeepCopySymbolRemapper;
import org.jetbrains.kotlin.ir.util.DeepCopyTypeRemapper;
import org.jetbrains.kotlin.ir.util.IdSignature;
import org.jetbrains.kotlin.ir.util.IrTypeUtilsKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.util.PatchDeclarationParentsKt;
import org.jetbrains.kotlin.ir.util.RenderIrElementKt;
import org.jetbrains.kotlin.ir.visitors.IrVisitorsKt;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.util.OperatorNameConventions;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00de\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0014\b\u0002\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\u0004\b\b\u0010\tB'\b\u0016\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0014\b\u0002\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\u0004\b\b\u0010\fJ\b\u0010\u001b\u001a\u00020\u001cH\u0002J\b\u0010\u001d\u001a\u00020\u001eH\u0002J\f\u0010\u001f\u001a\u00020\u001c*\u00020 H\u0002J\u001a\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\"2\n\b\u0002\u0010$\u001a\u0004\u0018\u00010%J0\u0010&\u001a\u00020\u001e2\u0006\u0010'\u001a\u00020(2\u0019\u0010)\u001a\u0015\u0012\u0004\u0012\u00020\u0000\u0012\u0006\u0012\u0004\u0018\u00010\u00010*\u00a2\u0006\u0002\b+H\u0000\u00a2\u0006\u0002\b,J\b\u0010-\u001a\u00020\u001eH\u0002J\u0010\u0010!\u001a\u00020\u001c2\u0006\u0010.\u001a\u00020/H\u0002J\f\u00100\u001a\u00020\u001c*\u000201H\u0002J\u0010\u00102\u001a\u00020\u001c2\u0006\u00103\u001a\u000204H\u0002J\u0010\u00105\u001a\u00020\u001c2\u0006\u00106\u001a\u000207H\u0002J\u0010\u00108\u001a\u00020\u001c2\u0006\u0010'\u001a\u00020(H\u0002J\u0010\u00109\u001a\u00020\u001c2\u0006\u0010:\u001a\u00020;H\u0002J\u0010\u0010<\u001a\u00020\u001c2\u0006\u0010=\u001a\u00020\u0007H\u0002J\u0010\u0010>\u001a\u00020\u001c2\u0006\u0010?\u001a\u00020@H\u0002J\u0010\u0010A\u001a\u00020\u001c2\u0006\u0010B\u001a\u00020CH\u0002J\u0010\u0010D\u001a\u00020\u001c2\u0006\u0010E\u001a\u00020FH\u0002J\u0010\u0010G\u001a\u00020\u001c2\u0006\u0010E\u001a\u00020HH\u0002J\u0010\u0010I\u001a\u00020\u001c2\u0006\u0010E\u001a\u00020JH\u0002J\u0010\u0010K\u001a\u00020\u001c2\u0006\u0010#\u001a\u00020LH\u0002J\u0010\u0010M\u001a\u00020\u001c2\u0006\u0010N\u001a\u00020OH\u0002J\u0010\u0010P\u001a\u00020\u001c2\u0006\u0010#\u001a\u00020QH\u0002J\u0010\u0010R\u001a\u00020\u001c2\u0006\u0010#\u001a\u00020SH\u0002J\u0010\u0010T\u001a\u00020\u001c2\u0006\u0010U\u001a\u00020VH\u0002J\u0010\u0010W\u001a\u00020\u001c2\u0006\u0010U\u001a\u00020XH\u0002J\u0010\u0010Y\u001a\u00020\u001c2\u0006\u0010Z\u001a\u00020[H\u0002J\u0010\u0010\\\u001a\u00020\u001c2\u0006\u0010]\u001a\u00020^H\u0002J\u0010\u0010_\u001a\u00020\u001c2\u0006\u0010#\u001a\u00020`H\u0002J\u0010\u0010a\u001a\u00020\u001c2\u0006\u0010#\u001a\u00020bH\u0002J\u0010\u0010c\u001a\u00020\u001c2\u0006\u0010#\u001a\u00020dH\u0002J\u0010\u0010e\u001a\u00020\u001c2\u0006\u0010#\u001a\u00020fH\u0002J\u0010\u0010g\u001a\u00020\u001c2\u0006\u0010h\u001a\u00020iH\u0002J\u0010\u0010j\u001a\u00020\u001c2\u0006\u0010#\u001a\u00020kH\u0002J\u0010\u0010l\u001a\u00020\u001c2\u0006\u0010#\u001a\u00020mH\u0002J\u0010\u0010n\u001a\u00020\u001c2\u0006\u0010.\u001a\u00020oH\u0002J\u0010\u0010p\u001a\u00020\u001c2\u0006\u0010#\u001a\u00020qH\u0002J\u0010\u0010r\u001a\u00020\u001c2\u0006\u0010#\u001a\u00020sH\u0002J\u0010\u0010t\u001a\u00020\u001c2\u0006\u0010#\u001a\u00020uH\u0002J\u0010\u0010v\u001a\u00020\u001c2\u0006\u0010w\u001a\u00020xH\u0002J\u0010\u0010y\u001a\u00020\u001c2\u0006\u0010z\u001a\u00020{H\u0002J\u0010\u0010|\u001a\u00020\u001c2\u0006\u0010}\u001a\u00020~H\u0002J\u0011\u0010\u007f\u001a\u00020\u001c2\u0007\u0010#\u001a\u00030\u0080\u0001H\u0002J\u0012\u0010\u0081\u0001\u001a\u00020\u001c2\u0007\u0010w\u001a\u00030\u0082\u0001H\u0002J\u0012\u0010\u0083\u0001\u001a\u00020\u001c2\u0007\u0010w\u001a\u00030\u0084\u0001H\u0002R\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR \u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\n\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\u00020\u00148BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0085\u0001"}, d2={"Lorg/jetbrains/kotlin/ir/interpreter/IrInterpreter;", "", "environment", "Lorg/jetbrains/kotlin/ir/interpreter/IrInterpreterEnvironment;", "bodyMap", "", "Lorg/jetbrains/kotlin/ir/util/IdSignature;", "Lorg/jetbrains/kotlin/ir/expressions/IrBody;", "<init>", "(Lorg/jetbrains/kotlin/ir/interpreter/IrInterpreterEnvironment;Ljava/util/Map;)V", "irBuiltIns", "Lorg/jetbrains/kotlin/ir/IrBuiltIns;", "(Lorg/jetbrains/kotlin/ir/IrBuiltIns;Ljava/util/Map;)V", "getEnvironment$ir_interpreter", "()Lorg/jetbrains/kotlin/ir/interpreter/IrInterpreterEnvironment;", "getBodyMap$ir_interpreter", "()Ljava/util/Map;", "getIrBuiltIns", "()Lorg/jetbrains/kotlin/ir/IrBuiltIns;", "callStack", "Lorg/jetbrains/kotlin/ir/interpreter/stack/CallStack;", "getCallStack", "()Lorg/jetbrains/kotlin/ir/interpreter/stack/CallStack;", "callInterceptor", "Lorg/jetbrains/kotlin/ir/interpreter/CallInterceptor;", "commandCount", "", "incrementAndCheckCommands", "", "getUnitState", "Lorg/jetbrains/kotlin/ir/interpreter/state/State;", "handle", "Lorg/jetbrains/kotlin/ir/interpreter/Instruction;", "interpret", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "expression", "file", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "withNewCallStack", "call", "Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "init", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "withNewCallStack$ir_interpreter", "extractResultAndAssertThatStackIsEmpty", "element", "Lorg/jetbrains/kotlin/ir/IrElement;", "tryResetFunctionBody", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "interpretFunction", "function", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "interpretValueParameter", "valueParameter", "Lorg/jetbrains/kotlin/ir/declarations/IrValueParameter;", "interpretCall", "interpretField", "field", "Lorg/jetbrains/kotlin/ir/declarations/IrField;", "interpretBody", "body", "interpretBlock", "block", "Lorg/jetbrains/kotlin/ir/expressions/IrBlock;", "interpretConstructor", "constructor", "Lorg/jetbrains/kotlin/ir/declarations/IrConstructor;", "interpretConstructorCall", "constructorCall", "Lorg/jetbrains/kotlin/ir/expressions/IrFunctionAccessExpression;", "interpretDelegatingConstructorCall", "Lorg/jetbrains/kotlin/ir/expressions/IrDelegatingConstructorCall;", "interpretEnumConstructorCall", "Lorg/jetbrains/kotlin/ir/expressions/IrEnumConstructorCall;", "interpretConst", "Lorg/jetbrains/kotlin/ir/expressions/IrConst;", "interpretVariable", "variable", "Lorg/jetbrains/kotlin/ir/declarations/IrVariable;", "interpretSetValue", "Lorg/jetbrains/kotlin/ir/expressions/IrSetValue;", "interpretReturn", "Lorg/jetbrains/kotlin/ir/expressions/IrReturn;", "interpretWhile", "loop", "Lorg/jetbrains/kotlin/ir/expressions/IrWhileLoop;", "interpretDoWhile", "Lorg/jetbrains/kotlin/ir/expressions/IrDoWhileLoop;", "interpretWhen", "whenExpression", "Lorg/jetbrains/kotlin/ir/expressions/IrWhen;", "interpretBranch", "branch", "Lorg/jetbrains/kotlin/ir/expressions/IrBranch;", "interpretSetField", "Lorg/jetbrains/kotlin/ir/expressions/IrSetField;", "interpretGetField", "Lorg/jetbrains/kotlin/ir/expressions/IrGetField;", "interpretGetObjectValue", "Lorg/jetbrains/kotlin/ir/expressions/IrGetObjectValue;", "interpretGetEnumValue", "Lorg/jetbrains/kotlin/ir/expressions/IrGetEnumValue;", "interpretEnumEntry", "enumEntry", "Lorg/jetbrains/kotlin/ir/declarations/IrEnumEntry;", "interpretTypeOperatorCall", "Lorg/jetbrains/kotlin/ir/expressions/IrTypeOperatorCall;", "interpretVararg", "Lorg/jetbrains/kotlin/ir/expressions/IrVararg;", "interpretTry", "Lorg/jetbrains/kotlin/ir/expressions/IrTry;", "interpretThrow", "Lorg/jetbrains/kotlin/ir/expressions/IrThrow;", "interpretStringConcatenation", "Lorg/jetbrains/kotlin/ir/expressions/IrStringConcatenation;", "interpretFunctionExpression", "Lorg/jetbrains/kotlin/ir/expressions/IrFunctionExpression;", "interpretFunctionReference", "reference", "Lorg/jetbrains/kotlin/ir/expressions/IrFunctionReference;", "interpretPropertyReference", "propertyReference", "Lorg/jetbrains/kotlin/ir/expressions/IrPropertyReference;", "interpretClassReference", "classReference", "Lorg/jetbrains/kotlin/ir/expressions/IrClassReference;", "interpretGetClass", "Lorg/jetbrains/kotlin/ir/expressions/IrGetClass;", "interpretRichFunctionReference", "Lorg/jetbrains/kotlin/ir/expressions/IrRichFunctionReference;", "interpretRichPropertyReference", "Lorg/jetbrains/kotlin/ir/expressions/IrRichPropertyReference;", "ir.interpreter"})
@SourceDebugExtension(value={"SMAP\nIrInterpreter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IrInterpreter.kt\norg/jetbrains/kotlin/ir/interpreter/IrInterpreter\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 5 ExceptionUtils.kt\norg/jetbrains/kotlin/ir/interpreter/exceptions/ExceptionUtilsKt\n+ 6 DeepCopyIrTreeWithSymbols.kt\norg/jetbrains/kotlin/ir/util/DeepCopyIrTreeWithSymbolsKt\n+ 7 DeepCopyIrTreeWithSymbols.kt\norg/jetbrains/kotlin/ir/util/DeepCopyIrTreeWithSymbolsKt$deepCopyWithSymbols$1\n*L\n1#1,660:1\n1#2:661\n1563#3:662\n1634#3,3:663\n1878#3,3:666\n1563#3:671\n1634#3,3:672\n1878#3,3:675\n808#3,11:680\n230#3,2:691\n1374#3:711\n1460#3,5:712\n808#3,11:717\n230#3,2:728\n1563#3:730\n1634#3,3:731\n1563#3:734\n1634#3,3:735\n1563#3:738\n1634#3,3:739\n1563#3:742\n1634#3,3:743\n1563#3:746\n1634#3,3:747\n808#3,11:750\n1869#3,2:761\n216#4,2:669\n20#5,2:678\n17#6,16:693\n33#6:710\n19#7:709\n*S KotlinDebug\n*F\n+ 1 IrInterpreter.kt\norg/jetbrains/kotlin/ir/interpreter/IrInterpreter\n*L\n167#1:662\n167#1:663,3\n186#1:666,3\n224#1:671\n224#1:672,3\n247#1:675,3\n489#1:680,11\n490#1:691,2\n524#1:711\n524#1:712,5\n542#1:717,11\n542#1:728,2\n543#1:730\n543#1:731,3\n597#1:734\n597#1:735,3\n608#1:738\n608#1:739,3\n644#1:742\n644#1:743,3\n655#1:746\n655#1:747,3\n428#1:750,11\n612#1:761,2\n191#1:669,2\n388#1:678,2\n493#1:693,16\n493#1:710\n493#1:709\n*E\n"})
public final class IrInterpreter {
    @NotNull
    private final IrInterpreterEnvironment environment;
    @NotNull
    private final Map<IdSignature, IrBody> bodyMap;
    @NotNull
    private final CallInterceptor callInterceptor;
    private int commandCount;

    public IrInterpreter(@NotNull IrInterpreterEnvironment environment, @NotNull Map<IdSignature, ? extends IrBody> bodyMap) {
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        Intrinsics.checkNotNullParameter(bodyMap, (String)"bodyMap");
        this.environment = environment;
        this.bodyMap = bodyMap;
        this.callInterceptor = new DefaultCallInterceptor(this);
    }

    public /* synthetic */ IrInterpreter(IrInterpreterEnvironment irInterpreterEnvironment, Map map, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            map = MapsKt.emptyMap();
        }
        this(irInterpreterEnvironment, (Map<IdSignature, ? extends IrBody>)map);
    }

    @NotNull
    public final IrInterpreterEnvironment getEnvironment$ir_interpreter() {
        return this.environment;
    }

    @NotNull
    public final Map<IdSignature, IrBody> getBodyMap$ir_interpreter() {
        return this.bodyMap;
    }

    @NotNull
    public final IrBuiltIns getIrBuiltIns() {
        return this.environment.getIrBuiltIns();
    }

    private final CallStack getCallStack() {
        return this.environment.getCallStack$ir_interpreter();
    }

    public IrInterpreter(@NotNull IrBuiltIns irBuiltIns, @NotNull Map<IdSignature, ? extends IrBody> bodyMap) {
        Intrinsics.checkNotNullParameter((Object)irBuiltIns, (String)"irBuiltIns");
        Intrinsics.checkNotNullParameter(bodyMap, (String)"bodyMap");
        this(new IrInterpreterEnvironment(irBuiltIns, null, 2, null), bodyMap);
    }

    public /* synthetic */ IrInterpreter(IrBuiltIns irBuiltIns, Map map, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            map = MapsKt.emptyMap();
        }
        this(irBuiltIns, (Map<IdSignature, ? extends IrBody>)map);
    }

    private final void incrementAndCheckCommands() {
        int n2 = this.commandCount;
        this.commandCount = n2 + 1;
        if (this.commandCount >= this.environment.getConfiguration().getMaxCommands()) {
            ExceptionUtilsKt.handleUserException(new InterpreterTimeOutError(), this.environment);
        }
    }

    private final State getUnitState() {
        Complex complex = this.environment.getMapOfObjects$ir_interpreter().get(this.getIrBuiltIns().getUnitClass());
        Intrinsics.checkNotNull((Object)complex);
        return complex;
    }

    private final void handle(Instruction $this$handle) {
        Instruction instruction = $this$handle;
        if (instruction instanceof CompoundInstruction) {
            InstructionsUnfolderKt.unfoldInstruction(((CompoundInstruction)$this$handle).getElement(), this.environment);
        } else if (instruction instanceof SimpleInstruction) {
            Unit unit;
            this.interpret(((SimpleInstruction)$this$handle).getElement());
            Unit it = unit = Unit.INSTANCE;
            boolean bl = false;
            this.incrementAndCheckCommands();
        } else if (instruction instanceof CustomInstruction) {
            ((CustomInstruction)$this$handle).getEvaluate().invoke();
        }
    }

    @NotNull
    public final IrExpression interpret(@NotNull IrExpression expression2, @Nullable IrFile file) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        this.commandCount = 0;
        this.getCallStack().newFrame(expression2, file);
        InstructionKt.pushCompoundInstruction(this.getCallStack(), expression2);
        while (!this.getCallStack().hasNoInstructions()) {
            this.handle(this.getCallStack().popInstruction());
        }
        return this.environment.stateToIrExpression$ir_interpreter(this.extractResultAndAssertThatStackIsEmpty(), expression2);
    }

    public static /* synthetic */ IrExpression interpret$default(IrInterpreter irInterpreter, IrExpression irExpression, IrFile irFile, int n2, Object object) {
        if ((n2 & 2) != 0) {
            irFile = null;
        }
        return irInterpreter.interpret(irExpression, irFile);
    }

    @NotNull
    public final State withNewCallStack$ir_interpreter(@NotNull IrCall call2, @NotNull Function1<? super IrInterpreter, ? extends Object> init) {
        Intrinsics.checkNotNullParameter((Object)call2, (String)"call");
        Intrinsics.checkNotNullParameter(init, (String)"init");
        IrInterpreter $this$withNewCallStack_u24lambda_u241 = new IrInterpreter(this.environment.copyWithNewCallStack(), this.bodyMap);
        boolean bl = false;
        $this$withNewCallStack_u24lambda_u241.getCallStack().newFrame((IrFunction)call2.getSymbol().getOwner());
        init.invoke((Object)$this$withNewCallStack_u24lambda_u241);
        while (!$this$withNewCallStack_u24lambda_u241.getCallStack().hasNoInstructions()) {
            $this$withNewCallStack_u24lambda_u241.handle($this$withNewCallStack_u24lambda_u241.getCallStack().popInstruction());
        }
        return $this$withNewCallStack_u24lambda_u241.extractResultAndAssertThatStackIsEmpty();
    }

    private final State extractResultAndAssertThatStackIsEmpty() {
        boolean bl;
        State result2 = this.getCallStack().popState();
        boolean bl2 = bl = this.getCallStack().peekState() == null;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        this.getCallStack().dropFrame();
        return result2;
    }

    private final void interpret(IrElement element) {
        IrElement irElement = element;
        if (irElement instanceof IrSimpleFunction) {
            this.interpretFunction((IrSimpleFunction)element);
        } else if (irElement instanceof IrConstructor) {
            this.interpretConstructor((IrConstructor)element);
        } else if (irElement instanceof IrCall) {
            this.interpretCall((IrCall)element);
        } else if (irElement instanceof IrConstructorCall) {
            this.interpretConstructorCall((IrFunctionAccessExpression)element);
        } else if (irElement instanceof IrEnumConstructorCall) {
            this.interpretEnumConstructorCall((IrEnumConstructorCall)element);
        } else if (irElement instanceof IrDelegatingConstructorCall) {
            this.interpretDelegatingConstructorCall((IrDelegatingConstructorCall)element);
        } else if (irElement instanceof IrInstanceInitializerCall) {
            this.getCallStack().pushState(this.getUnitState());
        } else if (irElement instanceof IrValueParameter) {
            this.interpretValueParameter((IrValueParameter)element);
        } else if (irElement instanceof IrField) {
            this.interpretField((IrField)element);
        } else if (irElement instanceof IrBody) {
            this.interpretBody((IrBody)element);
        } else if (irElement instanceof IrBlock) {
            this.interpretBlock((IrBlock)element);
        } else if (irElement instanceof IrReturn) {
            this.interpretReturn((IrReturn)element);
        } else if (irElement instanceof IrSetField) {
            this.interpretSetField((IrSetField)element);
        } else if (irElement instanceof IrGetField) {
            this.interpretGetField((IrGetField)element);
        } else if (irElement instanceof IrGetObjectValue) {
            this.interpretGetObjectValue((IrGetObjectValue)element);
        } else if (irElement instanceof IrGetEnumValue) {
            this.interpretGetEnumValue((IrGetEnumValue)element);
        } else if (irElement instanceof IrEnumEntry) {
            this.interpretEnumEntry((IrEnumEntry)element);
        } else if (irElement instanceof IrConst) {
            this.interpretConst((IrConst)element);
        } else if (irElement instanceof IrVariable) {
            this.interpretVariable((IrVariable)element);
        } else if (irElement instanceof IrSetValue) {
            this.interpretSetValue((IrSetValue)element);
        } else if (irElement instanceof IrTypeOperatorCall) {
            this.interpretTypeOperatorCall((IrTypeOperatorCall)element);
        } else if (irElement instanceof IrBranch) {
            this.interpretBranch((IrBranch)element);
        } else if (irElement instanceof IrWhileLoop) {
            this.interpretWhile((IrWhileLoop)element);
        } else if (irElement instanceof IrDoWhileLoop) {
            this.interpretDoWhile((IrDoWhileLoop)element);
        } else if (irElement instanceof IrWhen) {
            this.interpretWhen((IrWhen)element);
        } else if (irElement instanceof IrVararg) {
            this.interpretVararg((IrVararg)element);
        } else if (irElement instanceof IrTry) {
            this.interpretTry((IrTry)element);
        } else if (irElement instanceof IrThrow) {
            this.interpretThrow((IrThrow)element);
        } else if (irElement instanceof IrStringConcatenation) {
            this.interpretStringConcatenation((IrStringConcatenation)element);
        } else if (irElement instanceof IrFunctionExpression) {
            this.interpretFunctionExpression((IrFunctionExpression)element);
        } else if (irElement instanceof IrFunctionReference) {
            this.interpretFunctionReference((IrFunctionReference)element);
        } else if (irElement instanceof IrPropertyReference) {
            this.interpretPropertyReference((IrPropertyReference)element);
        } else if (irElement instanceof IrClassReference) {
            this.interpretClassReference((IrClassReference)element);
        } else if (irElement instanceof IrGetClass) {
            this.interpretGetClass((IrGetClass)element);
        } else if (irElement instanceof IrRichFunctionReference) {
            this.interpretRichFunctionReference((IrRichFunctionReference)element);
        } else if (irElement instanceof IrRichPropertyReference) {
            this.interpretRichPropertyReference((IrRichPropertyReference)element);
        } else {
            String string = element.getClass() + " not supported for interpretation";
            throw new NotImplementedError("An operation is not implemented: " + string);
        }
    }

    private final void tryResetFunctionBody(IrFunction $this$tryResetFunctionBody) {
        IdSignature idSignature = $this$tryResetFunctionBody.getSymbol().getSignature();
        if (idSignature == null) {
            return;
        }
        IdSignature signature = idSignature;
        if (this.bodyMap.get(signature) != null) {
            $this$tryResetFunctionBody.setBody(null);
        }
    }

    private final void interpretFunction(IrSimpleFunction function2) {
        this.tryResetFunctionBody(function2);
        if (UtilsKt.checkCast(function2, this.environment)) {
            this.getCallStack().dropFrameAndCopyResult();
        }
    }

    private final void interpretValueParameter(IrValueParameter valueParameter2) {
        IrDeclarationParent irDeclarationParent = valueParameter2.getParent();
        Intrinsics.checkNotNull((Object)irDeclarationParent, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrFunction");
        IrFunction irFunction = (IrFunction)irDeclarationParent;
        State state = this.getCallStack().popState();
        if (StateKt.checkNullability(state, valueParameter2.getType(), this.environment, (Function0<? extends Throwable>)((Function0)() -> IrInterpreter.interpretValueParameter$lambda$2(valueParameter2, irFunction))) == null) {
            return;
        }
        this.getCallStack().pushState(state);
    }

    /*
     * WARNING - void declaration
     */
    private final void interpretCall(IrCall call2) {
        State dispatchReceiver;
        Object object;
        State state;
        void $this$mapTo$iv$iv;
        IrSimpleFunction owner = (IrSimpleFunction)call2.getSymbol().getOwner();
        Iterable $this$map$iv = IrUtilsKt.getNonDispatchParameters(owner);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            IrValueParameter irValueParameter = (IrValueParameter)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.getCallStack().popState());
        }
        List nonDispatchArguments = CollectionsKt.reversed((Iterable)((List)destination$iv$iv));
        IrValueParameter irValueParameter = owner.getDispatchReceiverParameter();
        if (irValueParameter != null) {
            IrValueParameter it = irValueParameter;
            boolean bl = false;
            state = this.getCallStack().popState();
        } else {
            state = null;
        }
        if ((object = (dispatchReceiver = state)) == null || (object = object.getIrFunctionByIrCall(call2)) == null) {
            object = call2.getSymbol().getOwner();
        }
        Object irFunction = object;
        List args = CollectionsKt.plus((Collection)CollectionsKt.listOfNotNull((Object)IrInterpreter.interpretCall$getThisOrSuperReceiver(dispatchReceiver, (IrFunction)irFunction)), (Iterable)nonDispatchArguments);
        Map<IrTypeParameterSymbol, KTypeState> reifiedTypeArguments = UtilsKt.loadReifiedTypeArguments(this.environment, call2);
        this.getCallStack().newFrame((IrFunction)irFunction);
        InstructionKt.pushSimpleInstruction(this.getCallStack(), (IrElement)irFunction);
        if (dispatchReceiver instanceof StateWithClosure) {
            this.getCallStack().loadUpValues((StateWithClosure)((Object)dispatchReceiver));
        }
        if (AdditionalIrUtilsKt.isLocal((IrDeclaration)irFunction)) {
            this.getCallStack().copyUpValuesFromPreviousFrame();
        }
        IrValueParameter irValueParameter2 = ((IrFunction)irFunction).getDispatchReceiverParameter();
        if (irValueParameter2 != null) {
            IrValueParameter it = irValueParameter2;
            boolean bl = false;
            this.getCallStack().storeState((IrSymbol)it.getSymbol(), dispatchReceiver);
        }
        Iterable $this$forEachIndexed$iv = IrUtilsKt.getNonDispatchParameters((IrFunction)irFunction);
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void param;
            int n2;
            if ((n2 = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            IrValueParameter irValueParameter3 = (IrValueParameter)item$iv;
            int i2 = n2;
            boolean bl = false;
            this.getCallStack().storeState((IrSymbol)param.getSymbol(), (State)nonDispatchArguments.get(i2));
        }
        this.getCallStack().storeState((IrSymbol)((IrFunction)irFunction).getSymbol(), new KTypeState(call2.getType(), (IrClass)this.environment.getKTypeClass$ir_interpreter().getOwner()));
        Map<IrTypeParameterSymbol, KTypeState> $this$forEach$iv = reifiedTypeArguments;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<IrTypeParameterSymbol, KTypeState>> iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry<IrTypeParameterSymbol, KTypeState> element$iv;
            Map.Entry<IrTypeParameterSymbol, KTypeState> it = element$iv = iterator2.next();
            boolean bl = false;
            this.getCallStack().storeState((IrSymbol)it.getKey(), it.getValue());
        }
        if (dispatchReceiver instanceof Complex) {
            IrClass irClass = IrUtilsKt.getParentClassOrNull((IrDeclaration)irFunction);
            boolean bl = irClass != null ? irClass.isInner() : false;
            if (bl) {
                Complex.loadOuterClassesInto$default((Complex)dispatchReceiver, this.getCallStack(), null, 2, null);
            }
        }
        this.callInterceptor.interceptCall(call2, (IrFunction)irFunction, args, (Function0<Unit>)((Function0)() -> IrInterpreter.interpretCall$lambda$8(this, (IrFunction)irFunction)));
    }

    private final void interpretField(IrField field) {
        IrClass irClass = IrUtilsKt.getParentAsClass(field);
        IrValueParameter irValueParameter = irClass.getThisReceiver();
        Intrinsics.checkNotNull((Object)irValueParameter);
        IrValueParameterSymbol receiver = irValueParameter.getSymbol();
        State receiverState = this.getCallStack().loadState(receiver);
        IrPropertySymbol irPropertySymbol = field.getCorrespondingPropertySymbol();
        Intrinsics.checkNotNull((Object)irPropertySymbol);
        receiverState.setField(irPropertySymbol, this.getCallStack().popState());
    }

    private final void interpretBody(IrBody body) {
        if (IrUtilsKt.getStatements(body).isEmpty()) {
            this.getCallStack().pushState(this.getUnitState());
        }
    }

    private final void interpretBlock(IrBlock block) {
        this.getCallStack().dropSubFrame();
        if (block.getStatements().isEmpty()) {
            this.getCallStack().pushState(this.getUnitState());
        }
    }

    private final void interpretConstructor(IrConstructor constructor) {
        CallStack callStack = this.getCallStack();
        CallStack callStack2 = this.getCallStack();
        IrValueParameter irValueParameter = IrUtilsKt.getParentAsClass(constructor).getThisReceiver();
        Intrinsics.checkNotNull((Object)irValueParameter);
        callStack.pushState(callStack2.loadState(irValueParameter.getSymbol()));
        this.getCallStack().dropFrameAndCopyResult();
    }

    /*
     * WARNING - void declaration
     */
    private final void interpretConstructorCall(IrFunctionAccessExpression constructorCall) {
        IrValueSymbol superReceiver;
        IrValueSymbol irValueSymbol;
        IrStatement irStatement;
        State state;
        State objectState;
        State state2;
        IrValueParameterSymbol receiverSymbol;
        void $this$mapTo$iv$iv;
        IrFunction constructor = ((IrFunctionSymbol)constructorCall.getSymbol()).getOwner();
        Iterable $this$map$iv = IrUtilsKt.getNonDispatchParameters(constructor);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            IrValueParameter irValueParameter = (IrValueParameter)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.getCallStack().popState());
        }
        List nonDispatchArguments = CollectionsKt.reversed((Iterable)((List)destination$iv$iv));
        IrClass irClass = IrUtilsKt.getParentAsClass(constructor);
        IrValueParameter irValueParameter = constructor.getDispatchReceiverParameter();
        IrValueParameterSymbol irValueParameterSymbol = receiverSymbol = irValueParameter != null ? irValueParameter.getSymbol() : null;
        if (!(constructorCall instanceof IrConstructorCall)) {
            state2 = this.getCallStack().loadState(UtilsKt.getThisReceiver(constructorCall));
        } else {
            StateWithClosure $this$interpretConstructorCall_u24lambda_u2410 = $i$f$mapTo = UtilsKt.isSubclassOfThrowable(irClass) ? new ExceptionState(irClass, this.environment) : new Common(irClass);
            boolean bl = false;
            if (IrUtilsKt.isObject(irClass)) {
                this.environment.getMapOfObjects$ir_interpreter().put(irClass.getSymbol(), (Complex)((Object)$this$interpretConstructorCall_u24lambda_u2410));
            }
            state2 = objectState = (State)((Object)$i$f$mapTo);
        }
        if (AdditionalIrUtilsKt.isLocal(irClass)) {
            CallStack callStack = this.getCallStack();
            Intrinsics.checkNotNull((Object)objectState, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.interpreter.state.StateWithClosure");
            callStack.storeUpValues((StateWithClosure)((Object)objectState));
        }
        IrValueParameterSymbol irValueParameterSymbol2 = receiverSymbol;
        if (irValueParameterSymbol2 != null) {
            IrValueParameterSymbol it = irValueParameterSymbol2;
            boolean bl = false;
            state = this.getCallStack().popState();
        } else {
            state = null;
        }
        State outerClass = state;
        IrType returnType = UtilsKt.getTypeIfReified(constructorCall.getType(), this.getCallStack());
        this.getCallStack().newFrame(constructor);
        InstructionKt.pushSimpleInstruction(this.getCallStack(), constructor);
        if (AdditionalIrUtilsKt.isLocal(irClass)) {
            CallStack callStack = this.getCallStack();
            Intrinsics.checkNotNull((Object)objectState, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.interpreter.state.StateWithClosure");
            callStack.loadUpValues((StateWithClosure)((Object)objectState));
        }
        this.getCallStack().storeState((IrSymbol)UtilsKt.getThisReceiver(constructorCall), objectState);
        Iterable $this$forEachIndexed$iv = IrUtilsKt.getNonDispatchParameters(constructor);
        boolean $i$f$forEachIndexed = false;
        int index$iv2 = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void param;
            int n2;
            if ((n2 = index$iv2++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            IrValueParameter irValueParameter2 = (IrValueParameter)item$iv;
            int i2 = n2;
            boolean bl = false;
            this.getCallStack().storeState((IrSymbol)param.getSymbol(), (State)nonDispatchArguments.get(i2));
        }
        this.getCallStack().storeState((IrSymbol)constructor.getSymbol(), new KTypeState(returnType, (IrClass)this.environment.getKTypeClass$ir_interpreter().getOwner()));
        Object object = constructor.getBody();
        IrStatement irStatement2 = object != null && (object = IrUtilsKt.getStatements((IrBody)object)) != null ? (IrStatement)CollectionsKt.getOrNull((List)object, (int)0) : (irStatement = null);
        if (irStatement == null) {
            irValueSymbol = null;
        } else if (irStatement instanceof IrTypeOperatorCall) {
            IrExpression irExpression = ((IrTypeOperatorCall)irStatement).getArgument();
            Intrinsics.checkNotNull((Object)irExpression, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression");
            irValueSymbol = UtilsKt.getThisReceiver((IrFunctionAccessExpression)irExpression);
        } else if (irStatement instanceof IrFunctionAccessExpression) {
            irValueSymbol = UtilsKt.getThisReceiver((IrFunctionAccessExpression)irStatement);
        } else if (irStatement instanceof IrBlock) {
            Object object2 = CollectionsKt.last(((IrBlock)irStatement).getStatements());
            Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression");
            irValueSymbol = UtilsKt.getThisReceiver((IrFunctionAccessExpression)object2);
        } else {
            String index$iv2 = irStatement.getClass() + " is not supported as first statement in constructor call";
            throw new NotImplementedError("An operation is not implemented: " + index$iv2);
        }
        IrValueSymbol irValueSymbol2 = superReceiver = irValueSymbol;
        if (irValueSymbol2 != null) {
            IrValueSymbol it = irValueSymbol2;
            boolean bl = false;
            this.getCallStack().storeState((IrSymbol)it, objectState);
        }
        if (outerClass != null) {
            IrValueParameter irValueParameter3 = IrUtilsKt.getParentAsClass(irClass).getThisReceiver();
            Intrinsics.checkNotNull((Object)irValueParameter3);
            Pair outerClassSymbolToState = TuplesKt.to((Object)irValueParameter3.getSymbol(), (Object)outerClass);
            Intrinsics.checkNotNull((Object)objectState, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.interpreter.state.Complex");
            ((Complex)objectState).setOuterClass((Pair<? extends IrSymbol, ? extends State>)outerClassSymbolToState);
            Object object3 = superReceiver;
            if (!Intrinsics.areEqual((Object)(object3 != null && (object3 = object3.getOwner()) != null ? object3.getType() : null), (Object)((IrValueParameter)receiverSymbol.getOwner()).getType())) {
                this.getCallStack().storeState((IrSymbol)receiverSymbol, outerClass);
                ((Complex)objectState).loadOuterClassesInto(this.getCallStack(), UtilsKt.getThisReceiver(constructorCall));
            }
        }
        this.callInterceptor.interceptConstructor(constructorCall, nonDispatchArguments, (Function0<Unit>)((Function0)() -> IrInterpreter.interpretConstructorCall$lambda$14(this, constructor)));
        this.getCallStack().pushState(this.getUnitState());
    }

    private final void interpretDelegatingConstructorCall(IrDelegatingConstructorCall constructorCall) {
        if (Intrinsics.areEqual((Object)((IrConstructor)constructorCall.getSymbol().getOwner()).getParent(), this.getIrBuiltIns().getAnyClass().getOwner())) {
            return;
        }
        this.interpretConstructorCall(constructorCall);
    }

    private final void interpretEnumConstructorCall(IrEnumConstructorCall constructorCall) {
        this.interpretConstructorCall(constructorCall);
    }

    private final void interpretConst(IrConst expression2) {
        IrType signedType = IrInterpreter.interpretConst$getSignedType(this, expression2.getType());
        if (signedType != null) {
            IrClassSymbol irClassSymbol = IrTypesKt.getClassOrNull(expression2.getType());
            Intrinsics.checkNotNull((Object)irClassSymbol);
            IrClassSymbol unsignedClass = irClassSymbol;
            IrConstructor constructor = (IrConstructor)((IrConstructorSymbol)SequencesKt.single(IrUtilsKt.getConstructors(unsignedClass))).getOwner();
            IrConstructorCallImpl constructorCall = BuildersKt.fromSymbolOwner$default(IrConstructorCallImpl.Companion, constructor.getReturnType(), constructor.getSymbol(), null, 4, null);
            constructorCall.getArguments().set(0, IrUtilsKt.toIrConst$default(expression2.getValue(), signedType, 0, 0, 6, null));
            InstructionKt.pushCompoundInstruction(this.getCallStack(), constructorCall);
            return;
        }
        this.getCallStack().pushState(UtilsKt.toPrimitive(expression2));
    }

    private final void interpretVariable(IrVariable variable) {
        this.getCallStack().storeState((IrSymbol)variable.getSymbol(), this.getCallStack().popState());
        this.getCallStack().pushState(this.getUnitState());
    }

    private final void interpretSetValue(IrSetValue expression2) {
        this.getCallStack().rewriteState(expression2.getSymbol(), this.getCallStack().popState());
        this.getCallStack().pushState(this.getUnitState());
    }

    private final void interpretReturn(IrReturn expression2) {
        this.getCallStack().returnFromFrameWithResult(expression2);
    }

    private final void interpretWhile(IrWhileLoop loop) {
        boolean result2 = StateKt.asBoolean(this.getCallStack().popState());
        this.getCallStack().dropSubFrame();
        if (result2) {
            this.getCallStack().newSubFrame(loop);
            InstructionKt.pushSimpleInstruction(this.getCallStack(), loop);
            InstructionKt.pushCompoundInstruction(this.getCallStack(), loop.getCondition());
            InstructionKt.pushCompoundInstruction(this.getCallStack(), loop.getBody());
        }
    }

    private final void interpretDoWhile(IrDoWhileLoop loop) {
        boolean result2 = StateKt.asBoolean(this.getCallStack().popState());
        this.getCallStack().dropSubFrame();
        if (result2) {
            this.getCallStack().newSubFrame(loop);
            InstructionKt.pushSimpleInstruction(this.getCallStack(), loop);
            InstructionKt.pushCompoundInstruction(this.getCallStack(), loop.getCondition());
            InstructionKt.pushCompoundInstruction(this.getCallStack(), loop.getBody());
        }
    }

    private final void interpretWhen(IrWhen whenExpression) {
        this.getCallStack().dropSubFrame();
        this.getCallStack().pushState(this.getUnitState());
    }

    private final void interpretBranch(IrBranch branch) {
        boolean result2 = StateKt.asBoolean(this.getCallStack().popState());
        if (result2) {
            this.getCallStack().dropSubFrame();
            InstructionKt.pushCompoundInstruction(this.getCallStack(), branch.getResult());
        }
    }

    private final void interpretSetField(IrSetField expression2) {
        State state;
        IrExpression irExpression = expression2.getReceiver();
        Intrinsics.checkNotNull((Object)irExpression, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrDeclarationReference");
        IrSymbol receiver = ((IrDeclarationReference)irExpression).getSymbol();
        IrPropertySymbol irPropertySymbol = ((IrField)expression2.getSymbol().getOwner()).getCorrespondingPropertySymbol();
        Intrinsics.checkNotNull((Object)irPropertySymbol);
        IrPropertySymbol propertySymbol = irPropertySymbol;
        State $this$interpretSetField_u24lambda_u2415 = state = this.getCallStack().loadState(receiver);
        boolean bl = false;
        $this$interpretSetField_u24lambda_u2415.setField(propertySymbol, this.getCallStack().popState());
        this.getCallStack().pushState(this.getUnitState());
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private final void interpretGetField(IrGetField expression) {
        block6: {
            block8: {
                block7: {
                    block5: {
                        var4_2 = expression.getReceiver();
                        v0 = var4_2 instanceof IrDeclarationReference != false ? (IrDeclarationReference)var4_2 : null;
                        receiver = v0 != null ? v0.getSymbol() : null;
                        field = (IrField)expression.getSymbol().getOwner();
                        if (!Intrinsics.areEqual((Object)field.getOrigin(), (Object)IrDeclarationOrigin.Companion.getIR_EXTERNAL_JAVA_DECLARATION_STUB()) || !field.isStatic()) break block5;
                        v1 = field.getInitializer();
                        v2 = initializerExpression = v1 != null ? v1.getExpression() : null;
                        if (initializerExpression instanceof IrConst) {
                            InstructionKt.pushSimpleInstruction(this.getCallStack(), initializerExpression);
                        } else {
                            this.callInterceptor.interceptJavaStaticField(expression);
                        }
                        break block6;
                    }
                    if (!Intrinsics.areEqual((Object)field.getOrigin(), (Object)IrDeclarationOrigin.Companion.getPROPERTY_BACKING_FIELD()) || !UtilsKt.isConst(UtilsKt.getProperty(field))) break block7;
                    v3 = field.getInitializer();
                    InstructionKt.pushCompoundInstruction(this.getCallStack(), v3 != null ? v3.getExpression() : null);
                    break block6;
                }
                if (!UtilsKt.accessesTopLevelOrObjectField(expression)) break block8;
                propertyOwner = UtilsKt.getProperty(field);
                if (UtilsKt.isConst(propertyOwner) || ((v4 = propertyOwner) != null && (v4 = v4.getBackingField()) != null && (v4 = v4.getInitializer()) != null ? v4.getExpression() : null) instanceof IrConst) ** GOTO lbl-1000
                v5 /* !! */  = propertyOwner;
                v6 = v5 /* !! */  != null && (v5 /* !! */  = IrUtilsKt.getParentClassOrNull(v5 /* !! */ )) != null ? UtilsKt.hasAnnotation(v5 /* !! */ , UtilsKt.getCompileTimeAnnotation()) : false;
                if (v6) lbl-1000:
                // 2 sources

                {
                    v7 = true;
                } else {
                    v7 = false;
                }
                isConst = v7;
                $i$f$verify = false;
                if (!isConst) {
                    $i$a$-verify-IrInterpreter$interpretGetField$1 = false;
                    var8_8 = "Cannot interpret get method on top level non const properties".toString();
                    throw new InterpreterAssertionError(var8_8);
                }
                v8 = field.getInitializer();
                InstructionKt.pushCompoundInstruction(this.getCallStack(), v8 != null ? v8.getExpression() : null);
                break block6;
            }
            v9 = this.getCallStack();
            v10 = receiver;
            Intrinsics.checkNotNull((Object)v10);
            v11 = v9.loadState(v10);
            v12 = field.getCorrespondingPropertySymbol();
            Intrinsics.checkNotNull((Object)v12);
            result = v11.getField(v12);
            v13 = this.getCallStack();
            v14 = result;
            Intrinsics.checkNotNull((Object)v14);
            v13.pushState(v14);
        }
    }

    private final void interpretGetObjectValue(IrGetObjectValue expression2) {
        this.callInterceptor.interceptGetObjectValue(expression2, (Function0<Unit>)((Function0)() -> IrInterpreter.interpretGetObjectValue$lambda$17(expression2, this)));
    }

    private final void interpretGetEnumValue(IrGetEnumValue expression2) {
        CallStack callStack = this.getCallStack();
        Complex complex = this.environment.getMapOfEnums$ir_interpreter().get(expression2.getSymbol());
        Intrinsics.checkNotNull((Object)complex);
        callStack.pushState(complex);
    }

    private final void interpretEnumEntry(IrEnumEntry enumEntry) {
        this.callInterceptor.interceptEnumEntry(enumEntry, (Function0<Unit>)((Function0)() -> IrInterpreter.interpretEnumEntry$lambda$18(enumEntry, this)));
    }

    /*
     * Unable to fully structure code
     */
    private final void interpretTypeOperatorCall(IrTypeOperatorCall expression) {
        typeClassifier = IrTypesKt.getClassifierOrFail(expression.getTypeOperand());
        var5_3 = typeClassifier.getOwner();
        v0 = var5_3 instanceof IrTypeParameter != false ? (IrTypeParameter)var5_3 : null;
        isReified = v0 != null ? v0.isReified() : false;
        isErased = typeClassifier.getOwner() instanceof IrTypeParameter != false && isReified == false;
        typeOperand = UtilsKt.getTypeIfReified(expression.getTypeOperand(), this.getCallStack());
        state = this.getCallStack().popState();
        switch (WhenMappings.$EnumSwitchMapping$1[expression.getOperator().ordinal()]) {
            case 1: {
                this.getCallStack().pushState(this.getUnitState());
                break;
            }
            case 2: 
            case 3: {
                if (StateKt.isNull(state) && !IrTypeUtilsKt.isNullable(typeOperand)) {
                    ExceptionUtilsKt.handleUserException(new NullPointerException(), this.environment);
                    break;
                }
                if (!isErased && !StateKt.isSubtypeOf(state, typeOperand)) {
                    castedClassName = UtilsKt.getFqName(state.getIrClass());
                    ExceptionUtilsKt.handleUserException(new ClassCastException(castedClassName + " cannot be cast to " + RenderIrElementKt.render$default(typeOperand, null, 1, null)), this.environment);
                    break;
                }
                this.getCallStack().pushState(state);
                break;
            }
            case 4: {
                if (!isErased && !StateKt.isSubtypeOf(state, typeOperand)) {
                    this.getCallStack().pushState(this.environment.convertToState$ir_interpreter(null, this.getIrBuiltIns().getNothingNType()));
                    break;
                }
                this.getCallStack().pushState(state);
                break;
            }
            case 5: {
                isInstance = isErased != false || StateKt.isSubtypeOf(state, typeOperand) != false;
                this.getCallStack().pushState(this.environment.convertToState$ir_interpreter(isInstance, this.getIrBuiltIns().getBooleanType()));
                break;
            }
            case 6: {
                isInstance = isErased != false || StateKt.isSubtypeOf(state, typeOperand) != false;
                this.getCallStack().pushState(this.environment.convertToState$ir_interpreter(isInstance == false, this.getIrBuiltIns().getBooleanType()));
                break;
            }
            case 7: {
                if (StateKt.isNull(state) && !IrTypeUtilsKt.isNullable(typeOperand)) {
                    ExceptionUtilsKt.handleUserException(new NullPointerException(), this.environment);
                    break;
                }
                this.getCallStack().pushState(state);
                break;
            }
            case 8: {
                if (!StateKt.isNull(state)) ** GOTO lbl50
                v1 = state;
                ** GOTO lbl110
lbl50:
                // 1 sources

                if (!(state instanceof KFunctionState)) ** GOTO lbl57
                var8_11 = state;
                $this$interpretTypeOperatorCall_u24lambda_u2419 = (KFunctionState)var8_11;
                $i$a$-apply-IrInterpreter$interpretTypeOperatorCall$newState$1 = false;
                $this$interpretTypeOperatorCall_u24lambda_u2419.setFunInterface(typeOperand);
                v1 = var8_11;
                ** GOTO lbl110
lbl57:
                // 1 sources

                v2 = IrTypesKt.getClassOrNull(typeOperand);
                Intrinsics.checkNotNull((Object)v2);
                samClass = (IrClass)v2.getOwner();
                samFunction = UtilsKt.getSingleAbstractMethod(samClass);
                $this$filterIsInstance$iv = state.getIrClass().getDeclarations();
                $i$f$filterIsInstance = false;
                var13_18 = $this$filterIsInstance$iv;
                destination$iv$iv = new ArrayList<E>();
                $i$f$filterIsInstanceTo = false;
                var16_23 = $this$filterIsInstanceTo$iv$iv.iterator();
                while (var16_23.hasNext()) {
                    element$iv$iv = var16_23.next();
                    if (!(element$iv$iv instanceof IrFunction)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $this$filterIsInstance$iv = (List)destination$iv$iv;
                $i$f$first = false;
                for (T element$iv : $this$first$iv) {
                    it = (IrFunction)element$iv;
                    $i$a$-first-IrInterpreter$interpretTypeOperatorCall$newState$invokeFunction$1 = false;
                    if (!(Intrinsics.areEqual((Object)it.getName(), (Object)OperatorNameConventions.INVOKE) != false && it.getParameters().size() == samFunction.getParameters().size())) continue;
                    ** GOTO lbl82
                }
                throw new NoSuchElementException("Collection contains no element matching the predicate.");
lbl82:
                // 1 sources

                invokeFunction = (IrFunction)element$iv;
                functionClass = IrUtilsKt.getParentAsClass(UtilsKt.getLastOverridden(invokeFunction));
                $this$deepCopyWithSymbols_u24default$iv = invokeFunction;
                $i$f$deepCopyWithSymbols = false;
                $this$deepCopyImpl$iv$iv = $this$deepCopyWithSymbols_u24default$iv;
                $i$f$deepCopyImpl = false;
                symbolRemapper$iv$iv = new DeepCopySymbolRemapper(null, 1, null);
                IrVisitorsKt.acceptVoid($this$deepCopyImpl$iv$iv, symbolRemapper$iv$iv);
                var19_29 = symbolRemapper$iv$iv;
                $i$a$-deepCopyWithSymbols-DeepCopyIrTreeWithSymbolsKt$deepCopyWithSymbols$1 = false;
                p0 = var19_29;
                typeRemapper$iv$iv = new DeepCopyTypeRemapper(p0);
                v3 = $this$deepCopyImpl$iv$iv.transform(new DeepCopyIrTreeWithSymbols(symbolRemapper$iv$iv, typeRemapper$iv$iv), null);
                if (v3 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrFunction");
                }
                newInvoke = (IrFunction)PatchDeclarationParentsKt.patchDeclarationParents((IrElement)((IrFunction)v3), samClass);
                newInvoke.setParameters(IrUtilsKt.getNonDispatchParameters(newInvoke));
                $this$interpretTypeOperatorCall_u24lambda_u2422 = var13_18 = new KFunctionState(newInvoke, functionClass, this.environment, null, 8, null);
                $i$a$-apply-IrInterpreter$interpretTypeOperatorCall$newState$2 = false;
                $this$interpretTypeOperatorCall_u24lambda_u2422.setFunInterface(typeOperand);
                v4 = invokeFunction.getDispatchReceiverParameter();
                if (v4 != null && (v4 = v4.getSymbol()) != null) {
                    it = v4;
                    $i$a$-let-IrInterpreter$interpretTypeOperatorCall$newState$2$1 = false;
                    $this$interpretTypeOperatorCall_u24lambda_u2422.getUpValues().put((IrSymbol)it, new Variable(state));
                }
                v1 = (State)var13_18;
lbl110:
                // 3 sources

                newState = v1;
                this.getCallStack().pushState(newState);
                break;
            }
            default: {
                ExceptionUtilsKt.stop((Function0<? extends Object>)(Function0)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, interpretTypeOperatorCall$lambda$23(org.jetbrains.kotlin.ir.expressions.IrTypeOperatorCall ), ()Ljava/lang/Object;)((IrTypeOperatorCall)expression));
                throw new KotlinNothingValueException();
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void interpretVararg(IrVararg expression2) {
        State state;
        void $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv = expression2.getElements();
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            List<Object> list;
            IrVarargElement it = (IrVarargElement)element$iv$iv;
            boolean bl = false;
            State result2 = this.getCallStack().popState();
            if (result2 instanceof Wrapper) {
                list = CollectionsKt.listOf((Object)((Wrapper)result2).getValue());
            } else if (result2 instanceof Primitive) {
                list = IrTypePredicatesKt.isArray(expression2.getVarargElementType()) || UtilsKt.isPrimitiveArray(expression2.getVarargElementType()) ? CollectionsKt.listOf((Object)result2) : IrInterpreter.interpretVararg$arrayToList(((Primitive)result2).getValue());
            } else if (result2 instanceof Common) {
                if (UtilsKt.isUnsignedArray(IrUtilsKt.getDefaultType(((Common)result2).getIrClass()))) {
                    Object object = CollectionsKt.single((Iterable)((Common)result2).getFields().values());
                    Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.interpreter.state.Primitive");
                    list = IrInterpreter.interpretVararg$arrayToList(((Primitive)object).getValue());
                } else {
                    list = CollectionsKt.listOf((Object)CommonProxy.Companion.asProxy$ir_interpreter$default(CommonProxy.Companion, (Common)result2, this.callInterceptor, null, 2, null));
                }
            } else {
                list = CollectionsKt.listOf((Object)result2);
            }
            Iterable list$iv$iv = list;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List args = CollectionsKt.reversed((Iterable)((List)destination$iv$iv));
        if (UtilsKt.isUnsignedArray(expression2.getType())) {
            void $this$mapTo$iv$iv;
            Object element$iv2;
            Object object;
            IrClass owner;
            block16: {
                void $this$first$iv;
                Iterator $this$filterIsInstanceTo$iv$iv;
                IrClassSymbol irClassSymbol = IrTypesKt.getClassOrNull(expression2.getType());
                Intrinsics.checkNotNull((Object)irClassSymbol);
                owner = (IrClass)irClassSymbol.getOwner();
                Iterable $this$filterIsInstance$iv = owner.getDeclarations();
                boolean $i$f$filterIsInstance = false;
                object = $this$filterIsInstance$iv;
                Collection destination$iv$iv2 = new ArrayList();
                boolean $i$f$filterIsInstanceTo = false;
                Iterator bl = $this$filterIsInstanceTo$iv$iv.iterator();
                while (bl.hasNext()) {
                    Object element$iv$iv = bl.next();
                    if (!(element$iv$iv instanceof IrProperty)) continue;
                    destination$iv$iv2.add(element$iv$iv);
                }
                $this$filterIsInstance$iv = (List)destination$iv$iv2;
                boolean $i$f$first = false;
                for (Object element$iv2 : $this$first$iv) {
                    IrProperty it = (IrProperty)element$iv2;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)it.getName().asString(), (Object)"storage")) continue;
                    break block16;
                }
                throw new NoSuchElementException("Collection contains no element matching the predicate.");
            }
            IrProperty storageProperty = (IrProperty)element$iv2;
            Iterable $this$map$iv = args;
            boolean $i$f$map = false;
            element$iv2 = $this$map$iv;
            Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            Iterator iterator2 = $this$mapTo$iv$iv.iterator();
            while (iterator2.hasNext()) {
                Object object2;
                void it;
                Object item$iv$iv;
                Object t2 = item$iv$iv = iterator2.next();
                Collection collection = destination$iv$iv3;
                boolean bl = false;
                if (it instanceof Proxy) {
                    Object object3 = CollectionsKt.single((Iterable)((Proxy)it).getState().getFields().values());
                    Intrinsics.checkNotNull((Object)object3, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.interpreter.state.Primitive");
                    object2 = ((Primitive)object3).getValue();
                } else {
                    object2 = it;
                }
                collection.add(object2);
            }
            List primitiveArray = (List)destination$iv$iv3;
            IrField irField = storageProperty.getBackingField();
            Intrinsics.checkNotNull((Object)irField);
            Primitive unsignedArray = UtilsKt.toPrimitiveStateArray(primitiveArray, irField.getType());
            Object $this$interpretVararg_u24lambda_u2427 = object = new Common(owner);
            boolean bl = false;
            $this$interpretVararg_u24lambda_u2427.setField(storageProperty.getSymbol(), unsignedArray);
            state = (State)object;
        } else {
            state = UtilsKt.toPrimitiveStateArray(args, expression2.getType());
        }
        State array = state;
        this.getCallStack().pushState(array);
    }

    private final void interpretTry(IrTry element) {
        block1: {
            State possibleException = this.getCallStack().peekState();
            this.getCallStack().dropSubFrame();
            if (possibleException instanceof ExceptionState) {
                Function0 checkUnhandledException = () -> IrInterpreter.interpretTry$lambda$28(this, possibleException);
                this.getCallStack().pushInstruction(new CustomInstruction((Function0<Unit>)checkUnhandledException));
            }
            IrExpression irExpression = element.getFinallyExpression();
            if (irExpression == null) break block1;
            InstructionsUnfolderKt.handleAndDropResult(irExpression, this.getCallStack());
        }
    }

    private final void interpretThrow(IrThrow expression2) {
        this.getCallStack().dropFramesUntilTryCatch();
    }

    private final void interpretStringConcatenation(IrStringConcatenation expression2) {
        List result2 = new ArrayList();
        int n2 = expression2.getArguments().size();
        for (int i2 = 0; i2 < n2; ++i2) {
            int it = i2;
            boolean bl = false;
            Collection collection = result2;
            State state = this.getCallStack().popState();
            String string = state instanceof Primitive ? String.valueOf(((Primitive)state).getValue()) : (state instanceof Wrapper ? ((Wrapper)state).getValue().toString() : state.toString());
            collection.add(string);
        }
        this.getCallStack().pushState(this.environment.convertToState$ir_interpreter(CollectionsKt.joinToString$default((Iterable)CollectionsKt.reversed((Iterable)result2), (CharSequence)"", null, null, (int)0, null, null, (int)62, null), expression2.getType()));
    }

    private final void interpretFunctionExpression(IrFunctionExpression expression2) {
        IrFunction irFunction = expression2.getFunction();
        IrClassSymbol irClassSymbol = IrTypesKt.getClassOrNull(expression2.getType());
        Intrinsics.checkNotNull((Object)irClassSymbol);
        KFunctionState function2 = new KFunctionState(irFunction, (IrClass)irClassSymbol.getOwner(), this.environment, null, 8, null);
        if (AdditionalIrUtilsKt.isLocal(expression2.getFunction())) {
            this.getCallStack().storeUpValues(function2);
        }
        this.getCallStack().pushState(function2);
    }

    /*
     * WARNING - void declaration
     */
    private final void interpretFunctionReference(IrFunctionReference reference2) {
        void $this$mapTo$iv$iv;
        IrFunction irFunction = ((IrFunctionSymbol)reference2.getSymbol()).getOwner();
        Iterable $this$map$iv = reference2.getArguments();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            State state;
            void it;
            IrExpression irExpression = (IrExpression)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            if (it != null) {
                boolean bl2 = false;
                state = this.getCallStack().popState();
            } else {
                state = null;
            }
            collection.add(state);
        }
        List boundValues = (List)destination$iv$iv;
        KFunctionState function2 = new KFunctionState(reference2, this.environment, (List<? extends State>)boundValues);
        if (AdditionalIrUtilsKt.isLocal(irFunction)) {
            this.getCallStack().storeUpValues(function2);
        }
        this.getCallStack().pushState(function2);
    }

    /*
     * WARNING - void declaration
     */
    private final void interpretPropertyReference(IrPropertyReference propertyReference) {
        List<IrTypeParameter> list;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = propertyReference.getArguments();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            State state;
            void it;
            IrExpression irExpression = (IrExpression)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            if (it != null) {
                boolean bl2 = false;
                state = this.getCallStack().popState();
            } else {
                state = null;
            }
            collection.add(state);
        }
        List boundValues = (List)destination$iv$iv;
        KPropertyState propertyState = new KPropertyState(this.callInterceptor, propertyReference, (List<? extends State>)boundValues);
        Object object = propertyReference.getGetter();
        if (object != null && (object = (IrSimpleFunction)object.getOwner()) != null && (object = object.getTypeParameters()) != null) {
            IrInterpreter.interpretPropertyReference$addToFields(object, propertyReference, this, propertyState);
        }
        if ((list = propertyReference.getSetter()) != null && (list = (IrSimpleFunction)list.getOwner()) != null && (list = list.getTypeParameters()) != null) {
            IrInterpreter.interpretPropertyReference$addToFields(list, propertyReference, this, propertyState);
        }
        this.getCallStack().pushState(propertyState);
    }

    private final void interpretClassReference(IrClassReference classReference) {
        if (classReference.getSymbol() instanceof IrTypeParameterSymbol) {
            State state = this.getCallStack().loadState(classReference.getSymbol());
            Intrinsics.checkNotNull((Object)state, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.interpreter.state.reflection.KTypeState");
            KTypeState kTypeState = (KTypeState)state;
            CallStack callStack = this.getCallStack();
            IrClassSymbol irClassSymbol = IrTypesKt.getClassOrNull(kTypeState.getIrType());
            Intrinsics.checkNotNull((Object)irClassSymbol);
            IrClass irClass = (IrClass)irClassSymbol.getOwner();
            IrClassSymbol irClassSymbol2 = IrTypesKt.getClassOrNull(classReference.getType());
            Intrinsics.checkNotNull((Object)irClassSymbol2);
            callStack.pushState(new KClassState(irClass, (IrClass)irClassSymbol2.getOwner()));
        } else {
            this.getCallStack().pushState(new KClassState(classReference));
        }
    }

    private final void interpretGetClass(IrGetClass expression2) {
        IrClass irClass = this.getCallStack().popState().getIrClass();
        CallStack callStack = this.getCallStack();
        IrClassSymbol irClassSymbol = IrTypesKt.getClassOrNull(expression2.getType());
        Intrinsics.checkNotNull((Object)irClassSymbol);
        callStack.pushState(new KClassState(irClass, (IrClass)irClassSymbol.getOwner()));
    }

    /*
     * WARNING - void declaration
     */
    private final void interpretRichFunctionReference(IrRichFunctionReference reference2) {
        void $this$mapTo$iv$iv;
        IrSimpleFunction irFunction = reference2.getInvokeFunction();
        Iterable $this$map$iv = reference2.getBoundValues();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            IrExpression irExpression = (IrExpression)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.getCallStack().popState());
        }
        List boundValues = (List)destination$iv$iv;
        KFunctionState function2 = new KFunctionState(reference2, this.environment, (List<? extends State>)boundValues);
        if (AdditionalIrUtilsKt.isLocal(irFunction)) {
            this.getCallStack().storeUpValues(function2);
        }
        this.getCallStack().pushState(function2);
    }

    /*
     * WARNING - void declaration
     */
    private final void interpretRichPropertyReference(IrRichPropertyReference reference2) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = reference2.getBoundValues();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            IrExpression irExpression = (IrExpression)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.getCallStack().popState());
        }
        List boundValues = (List)destination$iv$iv;
        KPropertyState propertyState = new KPropertyState(this.callInterceptor, reference2, (List<? extends State>)boundValues);
        this.getCallStack().pushState(propertyState);
    }

    private static final Throwable interpretValueParameter$lambda$2(IrValueParameter $valueParameter, IrFunction $irFunction) {
        if ($valueParameter.getKind() == IrParameterKind.DispatchReceiver || $valueParameter.getKind() == IrParameterKind.ExtensionReceiver) {
            return new NullPointerException();
        }
        String method = UtilsKt.getCapitalizedFileName($irFunction) + '.' + UtilsKt.getFqName($irFunction);
        Name parameter = $valueParameter.getName();
        return new IllegalArgumentException("Parameter specified as non-null is null: method " + method + ", parameter " + parameter);
    }

    private static final State interpretCall$getThisOrSuperReceiver(State $this$interpretCall_u24getThisOrSuperReceiver, IrFunction irFunction) {
        if (!($this$interpretCall_u24getThisOrSuperReceiver instanceof Common) || ((Common)$this$interpretCall_u24getThisOrSuperReceiver).getSuperWrapperClass() == null || !(irFunction.getParent() instanceof IrClass)) {
            return $this$interpretCall_u24getThisOrSuperReceiver;
        }
        Wrapper wrapper = ((Common)$this$interpretCall_u24getThisOrSuperReceiver).getSuperWrapperClass();
        Intrinsics.checkNotNull((Object)wrapper);
        if (IrUtilsKt.isSubclassOf(wrapper.getIrClass(), IrUtilsKt.getParentAsClass(irFunction))) {
            return ((Common)$this$interpretCall_u24getThisOrSuperReceiver).getSuperWrapperClass();
        }
        return $this$interpretCall_u24getThisOrSuperReceiver;
    }

    private static final Unit interpretCall$lambda$8(IrInterpreter this$0, IrFunction $irFunction) {
        InstructionKt.pushCompoundInstruction(this$0.getCallStack(), $irFunction);
        return Unit.INSTANCE;
    }

    private static final Unit interpretConstructorCall$lambda$14(IrInterpreter this$0, IrFunction $constructor) {
        InstructionKt.pushCompoundInstruction(this$0.getCallStack(), $constructor);
        return Unit.INSTANCE;
    }

    private static final IrType interpretConst$getSignedType(IrInterpreter this$0, IrType unsignedType) {
        IrType irType;
        UnsignedType unsignedType2 = IrTypePredicatesKt.getUnsignedType(unsignedType);
        switch (unsignedType2 == null ? -1 : WhenMappings.$EnumSwitchMapping$0[unsignedType2.ordinal()]) {
            case 1: {
                irType = this$0.getIrBuiltIns().getByteType();
                break;
            }
            case 2: {
                irType = this$0.getIrBuiltIns().getShortType();
                break;
            }
            case 3: {
                irType = this$0.getIrBuiltIns().getIntType();
                break;
            }
            case 4: {
                irType = this$0.getIrBuiltIns().getLongType();
                break;
            }
            default: {
                irType = null;
            }
        }
        return irType;
    }

    private static final Unit interpretGetObjectValue$lambda$17(IrGetObjectValue $expression, IrInterpreter this$0) {
        boolean buildObject;
        IrClass objectClass = (IrClass)$expression.getSymbol().getOwner();
        boolean bl = buildObject = UtilsKt.hasAnnotation(objectClass, UtilsKt.getCompileTimeAnnotation()) || this$0.environment.getConfiguration().getCreateNonCompileTimeObjects();
        if (SequencesKt.none(IrUtilsKt.getConstructors(objectClass)) || !buildObject) {
            Common state = new Common(objectClass);
            this$0.environment.getMapOfObjects$ir_interpreter().put(objectClass.getSymbol(), state);
            this$0.getCallStack().pushState(state);
            return Unit.INSTANCE;
        }
        IrConstructor constructor = (IrConstructor)SequencesKt.first(IrUtilsKt.getConstructors(objectClass));
        IrConstructorCallImpl constructorCall = BuildersKt.fromSymbolOwner$default(IrConstructorCallImpl.Companion, constructor.getReturnType(), constructor.getSymbol(), null, 4, null);
        InstructionKt.pushCompoundInstruction(this$0.getCallStack(), constructorCall);
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit interpretEnumEntry$lambda$18(IrEnumEntry $enumEntry, IrInterpreter this$0) {
        Common enumClassObject = UtilsKt.toState($enumEntry, this$0.getIrBuiltIns());
        this$0.environment.getMapOfEnums$ir_interpreter().put($enumEntry.getSymbol(), enumClassObject);
        IrElementBase irElementBase = $enumEntry.getInitializerExpression();
        if (irElementBase == null || (irElementBase = irElementBase.getExpression()) == null) {
            throw new InterpreterError("Initializer at enum entry " + UtilsKt.getFqName($enumEntry) + " is null");
        }
        IrElementBase enumInitializer = irElementBase;
        IrEnumConstructorCall irEnumConstructorCall = enumInitializer instanceof IrEnumConstructorCall ? (IrEnumConstructorCall)enumInitializer : null;
        if (irEnumConstructorCall == null) {
            void $this$filterIsInstanceTo$iv$iv;
            Iterable $this$filterIsInstance$iv = ((IrBlock)enumInitializer).getStatements();
            boolean $i$f$filterIsInstance = false;
            Iterable iterable = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof IrEnumConstructorCall)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            irEnumConstructorCall = (IrEnumConstructorCall)CollectionsKt.single((List)((List)destination$iv$iv));
        }
        IrEnumConstructorCall enumConstructorCall = irEnumConstructorCall;
        this$0.getCallStack().newSubFrame($enumEntry);
        InstructionKt.pushCompoundInstruction(this$0.getCallStack(), $enumEntry);
        InstructionKt.pushCompoundInstruction(this$0.getCallStack(), enumInitializer);
        this$0.getCallStack().storeState((IrSymbol)UtilsKt.getThisReceiver(enumConstructorCall), enumClassObject);
        return Unit.INSTANCE;
    }

    private static final Object interpretTypeOperatorCall$lambda$23(IrTypeOperatorCall $expression) {
        return "Type operator " + (Object)((Object)$expression.getOperator()) + " is not supported for interpretation";
    }

    private static final List<Object> interpretVararg$arrayToList(Object value2) {
        Object object = value2;
        return CollectionsKt.reversed((Iterable)(object instanceof byte[] ? ArraysKt.toList((byte[])((byte[])value2)) : (object instanceof char[] ? ArraysKt.toList((char[])((char[])value2)) : (object instanceof short[] ? ArraysKt.toList((short[])((short[])value2)) : (object instanceof int[] ? ArraysKt.toList((int[])((int[])value2)) : (object instanceof long[] ? ArraysKt.toList((long[])((long[])value2)) : (object instanceof float[] ? ArraysKt.toList((float[])((float[])value2)) : (object instanceof double[] ? ArraysKt.toList((double[])((double[])value2)) : (object instanceof boolean[] ? ArraysKt.toList((boolean[])((boolean[])value2)) : (object instanceof Object[] ? ArraysKt.toList((Object[])((Object[])value2)) : CollectionsKt.listOf((Object)value2)))))))))));
    }

    private static final Unit interpretTry$lambda$28(IrInterpreter this$0, State possibleException) {
        this$0.getCallStack().pushState(possibleException);
        this$0.getCallStack().dropFramesUntilTryCatch();
        return Unit.INSTANCE;
    }

    private static final void interpretPropertyReference$addToFields(List<? extends IrTypeParameter> $this$interpretPropertyReference_u24addToFields, IrPropertyReference $propertyReference, IrInterpreter this$0, KPropertyState propertyState) {
        Iterable $this$forEach$iv = (Iterable)CollectionsKt.getIndices((Collection)$propertyReference.getTypeArguments());
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv.iterator();
        while (iterator2.hasNext()) {
            IrType typeArgument;
            int element$iv;
            int index = element$iv = ((IntIterator)iterator2).nextInt();
            boolean bl = false;
            if ($propertyReference.getTypeArguments().get(index) == null) continue;
            KTypeState kTypeState = new KTypeState(typeArgument, (IrClass)this$0.environment.getKTypeClass$ir_interpreter().getOwner());
            propertyState.setField($this$interpretPropertyReference_u24addToFields.get(index).getSymbol(), kTypeState);
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[UnsignedType.values().length];
            try {
                nArray[UnsignedType.UBYTE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UnsignedType.USHORT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UnsignedType.UINT.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UnsignedType.ULONG.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[IrTypeOperator.values().length];
            try {
                nArray[IrTypeOperator.IMPLICIT_COERCION_TO_UNIT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IrTypeOperator.CAST.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IrTypeOperator.IMPLICIT_CAST.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IrTypeOperator.SAFE_CAST.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IrTypeOperator.INSTANCEOF.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IrTypeOperator.NOT_INSTANCEOF.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IrTypeOperator.IMPLICIT_NOTNULL.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IrTypeOperator.SAM_CONVERSION.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

