/*
 * Copyright (c) 2012, 2025, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * UNICODE LICENSE V3
 *
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright © 1991-2025 Unicode, Inc.
 *
 * NOTICE TO USER: Carefully read the following legal agreement. BY
 * DOWNLOADING, INSTALLING, COPYING OR OTHERWISE USING DATA FILES, AND/OR
 * SOFTWARE, YOU UNEQUIVOCALLY ACCEPT, AND AGREE TO BE BOUND BY, ALL OF THE
 * TERMS AND CONDITIONS OF THIS AGREEMENT. IF YOU DO NOT AGREE, DO NOT
 * DOWNLOAD, INSTALL, COPY, DISTRIBUTE OR USE THE DATA FILES OR SOFTWARE.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of data files and any associated documentation (the "Data Files") or
 * software and any associated documentation (the "Software") to deal in the
 * Data Files or Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, and/or sell
 * copies of the Data Files or Software, and to permit persons to whom the
 * Data Files or Software are furnished to do so, provided that either (a)
 * this copyright and permission notice appear with all copies of the Data
 * Files or Software, or (b) this copyright and permission notice appear in
 * associated Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF ANY
 * KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT OF
 * THIRD PARTY RIGHTS.
 *
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS NOTICE
 * BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL DAMAGES,
 * OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THE DATA
 * FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder shall
 * not be used in advertising or otherwise to promote the sale, use or other
 * dealings in these Data Files or Software without prior written
 * authorization of the copyright holder.
 *
 * SPDX-License-Identifier: Unicode-3.0
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.TimeZoneNamesBundle;

public class TimeZoneNames_pcm extends TimeZoneNamesBundle {
    @Override
    protected final Object[][] getContents() {
        final String[] GMT = new String[] {
               "Grínwích Mín Taim",
               "GMT",
               "",
               "GMT",
               "",
               "GMT",
            };
        final String[] Apia = new String[] {
               "Ápia Fíksd Taim",
               "",
               "Ápia Délaít Taim",
               "",
               "Ápia Taim",
               "",
            };
        final String[] Cook = new String[] {
               "Kúk Aílands Fíksd Taim",
               "",
               "Kúk Aílands Haf Họ́t Sízin Taim",
               "",
               "Kúk Aílands Taim",
               "",
            };
        final String[] Cuba = new String[] {
               "Kúba Fíksd Taim",
               "CST",
               "Kúba Délaít Taim",
               "CDT",
               "Kúba Taim",
               "CT",
            };
        final String[] Fiji = new String[] {
               "Fíji Fíksd Taim",
               "",
               "Fíji Họ́t Sízín Taim",
               "",
               "Fíji Taim",
               "",
            };
        final String[] Gulf = new String[] {
               "Gọ́lf Fíksd Taim",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hovd = new String[] {
               "Hovd Fíksd Taim",
               "",
               "Hovd Họ́t Sízin Taim",
               "",
               "Hovd Taim",
               "",
            };
        final String[] Iran = new String[] {
               "Iran Fíksd Taim",
               "",
               "Iran Délaít Taim",
               "",
               "Iran Taim",
               "",
            };
        final String[] Niue = new String[] {
               "Niúẹ Taim",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Omsk = new String[] {
               "Ọmsk Fíksd Taim",
               "",
               "Ọmsk Họ́t Sízin Taim",
               "",
               "Ọmsk Taim",
               "",
            };
        final String[] Peru = new String[] {
               "Pẹru Fíksd Taim",
               "",
               "Pẹru Họ́t Sízín Taim",
               "",
               "Pẹru Taim",
               "",
            };
        final String[] Truk = new String[] {
               "Chuk Taim",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wake = new String[] {
               "Wék Aíland Taim",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chile = new String[] {
               "Chílẹ Fíksd Taim",
               "",
               "Chílẹ Họ́t Sízín Taim",
               "",
               "Chílẹ Taim",
               "",
            };
        final String[] China = new String[] {
               "Chaína Fíksd Taim",
               "CST",
               "Chaína Délaít Taim",
               "CDT",
               "Chaína Taim",
               "CT",
            };
        final String[] Cocos = new String[] {
               "Kókós Aílands Taim",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Davis = new String[] {
               "Dévis Taim",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] India = new String[] {
               "Índia Fíksd Taim",
               "IST",
               "",
               "IST",
               "",
               "IST",
            };
        final String[] Japan = new String[] {
               "Japan Fíksd Taim",
               "JST",
               "Japan Délaít Taim",
               "JDT",
               "Japan Taim",
               "JT",
            };
        final String[] Korea = new String[] {
               "Koria Fíksd Taim",
               "KST",
               "Koria Délaít Taim",
               "KST",
               "Koria Taim",
               "KST",
            };
        final String[] Nauru = new String[] {
               "Naúru Taim",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Nepal = new String[] {
               "Nẹpọl Taim",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Palau = new String[] {
               "Paláu Taim",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Samoa = new String[] {
               "Sámoá Fíksd Taim",
               "SST",
               "Sámoá Délaít Taim",
               "SST",
               "Sámoá Taim",
               "SST",
            };
        final String[] Syowa = new String[] {
               "Siówa Taim",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tonga = new String[] {
               "Tọ́nga Fíksd Taim",
               "",
               "Tọ́nga Họ́t Sízin Taim",
               "",
               "Tọ́nga Taim",
               "",
            };
        final String[] Yukon = new String[] {
               "Yukón Taim",
               "MST",
               "",
               "MST",
               "",
               "MST",
            };
        final String[] Alaska = new String[] {
               "Aláská Fíksd Taim",
               "AKST",
               "Aláská Délaít Taim",
               "AKDT",
               "Aláská Taim",
               "AKT",
            };
        final String[] Amazon = new String[] {
               "Ámázọn Fíksd Taim",
               "",
               "Ámázọn Họ́t Sízín Taim",
               "",
               "Ámázọn Taim",
               "",
            };
        final String[] Azores = new String[] {
               "Azọz Fíksd Taim",
               "",
               "Azọz Họ́t Sízin Taim",
               "",
               "Azọz Taim",
               "",
            };
        final String[] Bhutan = new String[] {
               "Butan Taim",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Brunei = new String[] {
               "Brunẹi Darúsalam Taim",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Easter = new String[] {
               "Ísta Fíksd Taim",
               "",
               "Ísta Họ́t Sízín Taim",
               "",
               "Ísta Taim",
               "",
            };
        final String[] Guyana = new String[] {
               "Gayána Taim",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hawaii = new String[] {
               "Hawaií-Elúshián Fíksd Taim",
               "HST",
               "",
               "HST",
               "",
               "HST",
            };
        final String[] Israel = new String[] {
               "Ízrẹl Fíksd Taim",
               "IST",
               "Ízrẹl Délaít Taim",
               "IDT",
               "Ízrẹl Taim",
               "IT",
            };
        final String[] Kosrae = new String[] {
               "Kọ́sraẹ Taim",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mawson = new String[] {
               "Mọ́sọn Taim",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Moscow = new String[] {
               "Mọ́sko Fíksd Taim",
               "MSK",
               "Mọ́sko Họ́t Sízin Taim",
               "MSK",
               "Mọ́sko Taim",
               "MSK",
            };
        final String[] Ponape = new String[] {
               "Pónápẹ Taim",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tahiti = new String[] {
               "Tahíti Taim",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Taipei = new String[] {
               "Taipẹi Fíksd Taim",
               "CST",
               "Taipẹi Délaít Taim",
               "CDT",
               "Taipẹi Taim",
               "CT",
            };
        final String[] Tuvalu = new String[] {
               "Tuválu Taim",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Vostok = new String[] {
               "Vọ́stọk Taim",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wallis = new String[] {
               "Wális an Fútúna Taim",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Arabian = new String[] {
               "Arébiá Fíksd Taim",
               "",
               "Arébiá Délaít Taim",
               "",
               "Arébiá Taim",
               "",
            };
        final String[] Armenia = new String[] {
               "Armẹ́nia Fíksd Taim",
               "",
               "Armẹ́nia Họ́t Sízin Taim",
               "",
               "Armẹ́nia Taim",
               "",
            };
        final String[] Bolivia = new String[] {
               "Bolívia Fíksd Taim",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chatham = new String[] {
               "Chátam Fíksd Taim",
               "",
               "Chátam Délaít Taim",
               "",
               "Chátam Taim",
               "",
            };
        final String[] ETC_UTC = new String[] {
               "Arénjmẹnt ọf Di Hól Wọld Taim",
               "UTC",
               "",
               "",
               "",
               "",
            };
        final String[] Ecuador = new String[] {
               "Ẹ́kwuádọ Taim",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Gambier = new String[] {
               "Gámbiẹr Taim",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Georgia = new String[] {
               "Jọ́jia Fíksd Taim",
               "",
               "Jọ́jia Họ́t Sízin Taim",
               "",
               "Jọ́jia Taim",
               "",
            };
        final String[] Irkutsk = new String[] {
               "Irkútsk Fíksd Taim",
               "",
               "Irkútsk Họ́t Sízin Taim",
               "",
               "Irkútsk Taim",
               "",
            };
        final String[] Magadan = new String[] {
               "Mágádan Fíksd Taim",
               "",
               "Mágádan Họ́t Sízin Taim",
               "",
               "Mágádan Taim",
               "",
            };
        final String[] Myanmar = new String[] {
               "Miánma Taim",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Norfolk = new String[] {
               "Nọ́rfọ́lk Aíland Fíksd Taim",
               "",
               "Nọ́rfọ́lk Aíland Délaít Taim",
               "",
               "Nọ́rfọ́lk Aíland Taim",
               "",
            };
        final String[] Noronha = new String[] {
               "Fẹrnándó di Nọrónia Fíksd Taim",
               "",
               "Fẹrnándó di Nọrónia Họ́t Sízín Taim",
               "",
               "Fẹrnándó di Nọrónia Taim",
               "",
            };
        final String[] Reunion = new String[] {
               "Riyúniọn Taim",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Rothera = new String[] {
               "Rotẹ́ra Taim",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Solomon = new String[] {
               "Sólómọ́n Aílands Taim",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tokelau = new String[] {
               "Tokẹláu Taim",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uruguay = new String[] {
               "Yúrugwue Fíksd Taim",
               "",
               "Yúrugwue Họ́t Sízín Taim",
               "",
               "Yúrugwue Taim",
               "",
            };
        final String[] Vanuatu = new String[] {
               "Vanuátu Fíksd Taim",
               "",
               "Vanuátu Sízin Taim",
               "",
               "Vanuátu Taim",
               "",
            };
        final String[] Yakutsk = new String[] {
               "Yékútsk Fíksd Taim",
               "",
               "Yékútsk Họ́t Sízin Taim",
               "",
               "Yékútsk Taim",
               "",
            };
        final String[] Atlantic = new String[] {
               "Atlántík Fíksd Taim",
               "AST",
               "Atlántík Délaít Taim",
               "AST",
               "Atlántík Taim",
               "AST",
            };
        final String[] Brasilia = new String[] {
               "Brasília Fíksd Taim",
               "",
               "Brasília Họ́t Sízín Taim",
               "",
               "Brasília Taim",
               "",
            };
        final String[] Chamorro = new String[] {
               "Chamóro Fíksd Taim",
               "ChST",
               "",
               "ChST",
               "",
               "ChST",
            };
        final String[] Colombia = new String[] {
               "Kolómbia Fíksd Taim",
               "",
               "Kolómbia Họ́t Sízín Taim",
               "",
               "Kolómbia Taim",
               "",
            };
        final String[] Falkland = new String[] {
               "Fọ́lkland Fíksd Taim",
               "",
               "Fọ́lkland Họ́t Sízín Taim",
               "",
               "Fọ́lkland Taim",
               "",
            };
        final String[] Malaysia = new String[] {
               "Maléshia Taim",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Maldives = new String[] {
               "Mọ́divs Taim",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mongolia = new String[] {
               "Mọngólia Fíksd Taim",
               "",
               "Mọngólia Họ́t Sízin Taim",
               "",
               "Mọngólia Taim",
               "",
            };
        final String[] Pakistan = new String[] {
               "Pákístan Fíksd Taim",
               "PKT",
               "Pákístan Họ́t Sízin Taim",
               "PKST",
               "Pákístan Taim",
               "PKT",
            };
        final String[] Paraguay = new String[] {
               "Párágwue Fíksd Taim",
               "",
               "Párágwue Họ́t Sízín Taim",
               "",
               "Párágwue Taim",
               "",
            };
        final String[] Pitcairn = new String[] {
               "Pítkan Taim",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Suriname = new String[] {
               "Súrínam Taim",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Argentina = new String[] {
               "Ajẹntína Fíksd Taim",
               "",
               "Ajẹntína Họ́t Sízín Taim",
               "",
               "Ajẹntína Taim",
               "",
            };
        final String[] Christmas = new String[] {
               "Krísmás Aíland Taim",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Galapagos = new String[] {
               "Galápágọs Taim",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hong_Kong = new String[] {
               "Họng Kọng Fíksd Taim",
               "HKT",
               "Họng Kọng Họ́t Sízin Taim",
               "HKST",
               "Họng Kọng Taim",
               "HKT",
            };
        final String[] Indochina = new String[] {
               "Indochaína Taim",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kyrgystan = new String[] {
               "Kẹgistan Taim",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Lord_Howe = new String[] {
               "Lọd Haú Fíksd Taim",
               "",
               "Lọd Haú Délaít Taim",
               "",
               "Lọd Haú Taim",
               "",
            };
        final String[] Marquesas = new String[] {
               "Makwẹ́sas Taim",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mauritius = new String[] {
               "Mọríshọs Fíksd Taim",
               "",
               "Mọríshọs Họ́t Sízin Taim",
               "",
               "Mọríshọs Taim",
               "",
            };
        final String[] Singapore = new String[] {
               "Singapọ Taim",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Venezuela = new String[] {
               "Vẹnẹzuẹ́la Taim",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Azerbaijan = new String[] {
               "Azẹrbaijan Fíksd Taim",
               "",
               "Azẹrbaijan Họ́t Sízin Taim",
               "",
               "Azẹrbaijan Taim",
               "",
            };
        final String[] Bangladesh = new String[] {
               "Bangladẹsh Fíksd Taim",
               "",
               "Bangladẹsh Délaít Taim",
               "",
               "Bangladẹsh Taim",
               "",
            };
        final String[] Cape_Verde = new String[] {
               "Kep Vẹ́d Fíksd Taim",
               "",
               "Kep Vẹ́d Họ́t Sízin Taim",
               "",
               "Kep Vẹ́d Taim",
               "",
            };
        final String[] East_Timor = new String[] {
               "Íst Tímọ Taim",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kazakhstan = new String[] {
               "Kazékstan Taim",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Seychelles = new String[] {
               "Sẹ́chẹls Taim",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tajikistan = new String[] {
               "Tajíkistan Taim",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uzbekistan = new String[] {
               "Uzbẹkistan Fíksd Taim",
               "",
               "Uzbẹkistan Họ́t Sízin Taim",
               "",
               "Uzbẹkistan Taim",
               "",
            };
        final String[] Afghanistan = new String[] {
               "Afgánístan Taim",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Krasnoyarsk = new String[] {
               "Krasnoyask Fíksd Taim",
               "",
               "Krasnoyask Họ́t Sízin Taim",
               "",
               "Krasnoyask Taim",
               "",
            };
        final String[] New_Zealand = new String[] {
               "Niú Ziland Fíksd Taim",
               "NZST",
               "Niú Ziland Délaít Taim",
               "NZDT",
               "Niú Ziland Taim",
               "NZT",
            };
        final String[] Philippines = new String[] {
               "Fílípin Fíksd Taim",
               "PST",
               "Fílípin Họt Sízin Taim",
               "PDT",
               "Fílípin Taim",
               "PT",
            };
        final String[] Vladivostok = new String[] {
               "Vladivọstọk Fíksd Taim",
               "",
               "Vladivostok Họ́t Sízin Taim",
               "",
               "Vladivọstọk Taim",
               "",
            };
        final String[] Indian_Ocean = new String[] {
               "Índián Óshẹ́n Taim",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Line_Islands = new String[] {
               "Laín Aílands Taim",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Newfoundland = new String[] {
               "Niúfaúndlánd Fíksd Taim",
               "NST",
               "Niúfaúndlánd Délaít Taim",
               "NDT",
               "Niúfaúndlánd Taim",
               "NT",
            };
        final String[] Turkmenistan = new String[] {
               "Tọkmẹnistan Fíksd Taim",
               "",
               "Tọkmẹnistan Họ́t Sízin Taim",
               "",
               "Tọkmẹnistan Taim",
               "",
            };
        final String[] French_Guiana = new String[] {
               "Frẹ́nch Giána Taim",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] New_Caledonia = new String[] {
               "Niú Kalẹdónia Fíksd Taim",
               "",
               "Niú Kalẹdónia Họ́t Sízin Taim",
               "",
               "Niú Kalẹdónia Taim",
               "",
            };
        final String[] South_Georgia = new String[] {
               "Saút Jọ́jia Taim",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Yekaterinburg = new String[] {
               "Yẹketẹrínbug Fíksd Taim",
               "",
               "Yẹketẹrínbug Họ́t Sízin Taim",
               "",
               "Yẹketẹrínbug Taim",
               "",
            };
        final String[] Africa_Central = new String[] {
               "Mídúl Áfríká Taim",
               "CAT",
               "",
               "CAT",
               "",
               "CAT",
            };
        final String[] Africa_Eastern = new String[] {
               "Íst Áfríká Taim",
               "EAT",
               "",
               "EAT",
               "",
               "EAT",
            };
        final String[] Africa_Western = new String[] {
               "Wẹ́st Áfríká Taim",
               "WAT",
               "",
               "WAT",
               "",
               "WAT",
            };
        final String[] DumontDUrville = new String[] {
               "Diúmọ́n-d’Uvil Taim",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Europe_Central = new String[] {
               "Mídúl Yúrop Fíksd Taim",
               "CET",
               "Mídúl Yúrop Họ́t Sízin Taim",
               "CEST",
               "Mídúl Yúrop Taim",
               "CET",
            };
        final String[] Europe_Eastern = new String[] {
               "Ístán Yúrop Fíksd Taim",
               "EET",
               "Ístán Yúrop Họ́t Sízin Taim",
               "EEST",
               "Ístán Yúrop Taim",
               "EET",
            };
        final String[] Europe_Western = new String[] {
               "Wẹ́stán Yúrop Fíksd Taim",
               "WET",
               "Wẹ́stán Yúrop Họ́t Sízin Taim",
               "WEST",
               "Wẹ́stán Yúrop Taim",
               "WET",
            };
        final String[] Mexico_Pacific = new String[] {
               "Mẹ́ksíkó Pasífík Fíksd Taim",
               "MST",
               "Mẹ́ksíkó Pasífík Délaít Taim",
               "MDT",
               "Mẹ́ksíkó Pasífík Taim",
               "MT",
            };
        final String[] Africa_Southern = new String[] {
               "Saút Áfríká Fíksd Taim",
               "SAST",
               "",
               "SAST",
               "",
               "SAST",
            };
        final String[] America_Central = new String[] {
               "Nọ́t Amẹ́ríká Mídúl Ériá Fíksd Taim",
               "CST",
               "Nọ́t Amẹ́ríká Mídúl Ériá Délaít Taim",
               "CDT",
               "Nọ́t Amẹ́ríká Mídúl Ériá Taim",
               "CT",
            };
        final String[] America_Eastern = new String[] {
               "Nọ́t Amẹ́ríká Ístán Ériá Fíksd Taim",
               "EST",
               "Nọ́t Amẹ́ríká Ístán Ériá Délaít Taim",
               "EST",
               "Nọ́t Amẹ́ríká Ístán Ériá Taim",
               "EST",
            };
        final String[] America_Pacific = new String[] {
               "Nọ́t Amẹ́ríká Pasífík Ériá Fíksd Taim",
               "PST",
               "Nọ́t Amẹ́ríká Pasífík Ériá Délaít Taim",
               "PDT",
               "Nọ́t Amẹ́ríká Pasífík Ériá Taim",
               "PT",
            };
        final String[] French_Southern = new String[] {
               "Frẹ́nch Saútan an Antátík Taim",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Gilbert_Islands = new String[] {
               "Gílbat Aílands Taim",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hawaii_Aleutian = new String[] {
               "Hawaií-Elúshián Fíksd Taim",
               "HST",
               "Hawaií-Elúshián Délaít Taim",
               "HDT",
               "Hawaií-Elúshián Taim",
               "HT",
            };
        final String[] Phoenix_Islands = new String[] {
               "Fíniks Aílands Taim",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Pierre_Miquelon = new String[] {
               "Sent Piẹr an Míkẹlọn Fíksd Taim",
               "",
               "Sent Piẹr an Míkẹlọn Délaít Taim",
               "",
               "Sent Piẹr & Míkẹlọn Taim",
               "",
            };
        final String[] America_Mountain = new String[] {
               "Nọ́t Amẹ́ríká Maúntin Ériá Fíksd Taim",
               "MST",
               "Nọ́t Amẹ́ríká Maúntin Ériá Délaít Taim",
               "MST",
               "Nọ́t Amẹ́ríká Maúntin Ériá Taim",
               "MST",
            };
        final String[] Marshall_Islands = new String[] {
               "Máshal Aílands Taim",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Papua_New_Guinea = new String[] {
               "Pápuá Niú Gíni Taim",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Australia_Central = new String[] {
               "Ọstrélia Mídúl Fíksd Taim",
               "ACST",
               "Ọstrélia Mídúl Délaít Taim",
               "ACDT",
               "Mídúl Ọstrélia Taim",
               "ACT",
            };
        final String[] Australia_Eastern = new String[] {
               "Ọstrélia Ístán Fíksd Taim",
               "AEST",
               "Ọstrélia Ístán Délaít Taim",
               "AEDT",
               "Ístán Ọstrélia Taim",
               "AET",
            };
        final String[] Australia_Western = new String[] {
               "Ọstrélia Wẹ́stán Fíksd Taim",
               "AWST",
               "Ọstrélia Wẹ́stán Délaít Taim",
               "AWDT",
               "Wẹ́stán Ọstrélia Taim",
               "AWT",
            };
        final String[] Indonesia_Central = new String[] {
               "Mídúl Indonẹ́shia Taim",
               "WITA",
               "",
               "WITA",
               "",
               "WITA",
            };
        final String[] Indonesia_Eastern = new String[] {
               "Ístán Indonẹ́shia Taim",
               "WIT",
               "",
               "WIT",
               "",
               "WIT",
            };
        final String[] Indonesia_Western = new String[] {
               "Wẹ́stán Indonẹ́shia Taim",
               "WIB",
               "",
               "WIB",
               "",
               "WIB",
            };
        final String[] Australia_CentralWestern = new String[] {
               "Ọstrélia Mídúl Wẹ́stán Fíksd Taim",
               "",
               "Ọstrélia Mídúl Wẹ́stán Délaít Taim",
               "",
               "Ọstrélia Mídúl Wẹ́stán Taim",
               "",
            };
        final Object[][] data = new Object[][] {
            { "America/Los_Angeles", America_Pacific },
            { "America/Denver", America_Mountain },
            { "America/Phoenix", America_Mountain },
            { "America/Chicago", America_Central },
            { "America/New_York", America_Eastern },
            { "America/Indianapolis", America_Eastern },
            { "Pacific/Honolulu", Hawaii },
            { "America/Anchorage", Alaska },
            { "America/Halifax", Atlantic },
            { "America/Sitka", Alaska },
            { "America/St_Johns", Newfoundland },
            { "Europe/Paris", Europe_Central },
            { "GMT", GMT },
            { "Asia/Jerusalem", Israel },
            { "Asia/Tokyo", Japan },
            { "Europe/Bucharest", Europe_Eastern },
            { "Asia/Shanghai", China },
            { "UTC", ETC_UTC },
            { "GB",
                new String[] {
                    "Grínwích Mín Taim",
                    "GMT",
                    "Brítísh Họ́t Sízin Taim",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "NZ", New_Zealand },
            { "ACT", Australia_Central },
            { "AET", Australia_Eastern },
            { "AGT", Argentina },
            { "ART", Europe_Eastern },
            { "AST", Alaska },
            { "BET", Brasilia },
            { "BST", Bangladesh },
            { "CAT", Africa_Central },
            { "CET", Europe_Central },
            { "CNT", Newfoundland },
            { "CST", America_Central },
            { "CTT", China },
            { "EAT", Africa_Eastern },
            { "ECT", Europe_Central },
            { "EET", Europe_Eastern },
            { "EST", America_Eastern },
            { "HST", Hawaii },
            { "IET", America_Eastern },
            { "IST", India },
            { "JST", Japan },
            { "MET", Europe_Central },
            { "MIT", Apia },
            { "MST", America_Mountain },
            { "NET", Armenia },
            { "NST", New_Zealand },
            { "PLT", Pakistan },
            { "PNT", America_Mountain },
            { "PRC", China },
            { "PRT", Atlantic },
            { "PST", America_Pacific },
            { "ROK", Korea },
            { "SST", Solomon },
            { "UCT",
                new String[] {
                    "Arénjmẹnt ọf Di Hól Wọld Taim",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "VST", Indochina },
            { "WET", Europe_Western },
            { "Cuba", Cuba },
            { "Eire",
                new String[] {
                    "Grínwích Mín Taim",
                    "GMT",
                    "Aírísh Fíksd Taim",
                    "IST",
                    "",
                    "GMT",
                }
            },
            { "GMT0", GMT },
            { "Iran", Iran },
            { "W-SU", Moscow },
            { "Zulu",
                new String[] {
                    "Arénjmẹnt ọf Di Hól Wọld Taim",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Egypt", Europe_Eastern },
            { "Japan", Japan },
            { "Libya", Europe_Eastern },
            { "Israel", Israel },
            { "Navajo", America_Mountain },
            { "Poland", Europe_Central },
            { "CST6CDT", America_Central },
            { "EST5EDT", America_Eastern },
            { "Etc/GMT", GMT },
            { "Etc/UCT",
                new String[] {
                    "Arénjmẹnt ọf Di Hól Wọld Taim",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Etc/UTC", ETC_UTC },
            { "GB-Eire",
                new String[] {
                    "Grínwích Mín Taim",
                    "GMT",
                    "Brítísh Họ́t Sízin Taim",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Iceland", GMT },
            { "Jamaica", America_Eastern },
            { "MST7MDT", America_Mountain },
            { "NZ-CHAT", Chatham },
            { "PST8PDT", America_Pacific },
            { "Etc/GMT0", GMT },
            { "Etc/Zulu",
                new String[] {
                    "Arénjmẹnt ọf Di Hól Wọld Taim",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Hongkong", Hong_Kong },
            { "Portugal", Europe_Western },
            { "US/Samoa", Samoa },
            { "Asia/Aden", Arabian },
            { "Asia/Baku", Azerbaijan },
            { "Asia/Dili", East_Timor },
            { "Asia/Gaza", Europe_Eastern },
            { "Asia/Hovd", Hovd },
            { "Asia/Omsk", Omsk },
            { "Asia/Oral", Kazakhstan },
            { "Etc/GMT+0", GMT },
            { "Etc/GMT-0", GMT },
            { "Greenwich", GMT },
            { "Kwajalein", Marshall_Islands },
            { "Singapore", Singapore },
            { "US/Alaska", Alaska },
            { "US/Hawaii", Hawaii },
            { "Universal",
                new String[] {
                    "Arénjmẹnt ọf Di Hól Wọld Taim",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Asia/Aqtau", Kazakhstan },
            { "Asia/Chita", Yakutsk },
            { "Asia/Dacca", Bangladesh },
            { "Asia/Dhaka", Bangladesh },
            { "Asia/Dubai", Gulf },
            { "Asia/Kabul", Afghanistan },
            { "Asia/Macao", China },
            { "Asia/Macau", China },
            { "Asia/Qatar", Arabian },
            { "Asia/Seoul", Korea },
            { "Asia/Tomsk", Krasnoyarsk },
            { "US/Arizona", America_Mountain },
            { "US/Central", America_Central },
            { "US/Eastern", America_Eastern },
            { "US/Pacific", America_Pacific },
            { "Africa/Juba", Africa_Central },
            { "Africa/Lome", GMT },
            { "Asia/Almaty", Kazakhstan },
            { "Asia/Aqtobe", Kazakhstan },
            { "Asia/Atyrau", Kazakhstan },
            { "Asia/Beirut", Europe_Eastern },
            { "Asia/Brunei", Brunei },
            { "Asia/Harbin", China },
            { "Asia/Hebron", Europe_Eastern },
            { "Asia/Kuwait", Arabian },
            { "Asia/Manila", Philippines },
            { "Asia/Muscat", Gulf },
            { "Asia/Riyadh", Arabian },
            { "Asia/Saigon", Indochina },
            { "Asia/Taipei", Taipei },
            { "Asia/Tehran", Iran },
            { "Asia/Thimbu", Bhutan },
            { "Asia/Yangon", Cocos },
            { "Brazil/East", Brasilia },
            { "Brazil/West", Amazon },
            { "Europe/Kiev", Europe_Eastern },
            { "Europe/Kyiv", Europe_Eastern },
            { "Europe/Oslo", Europe_Central },
            { "Europe/Riga", Europe_Eastern },
            { "Europe/Rome", Europe_Central },
            { "Indian/Mahe", Seychelles },
            { "Pacific/Yap", Papua_New_Guinea },
            { "US/Aleutian", Hawaii_Aleutian },
            { "US/Michigan", America_Eastern },
            { "US/Mountain", America_Mountain },
            { "Africa/Accra", GMT },
            { "Africa/Cairo", Europe_Eastern },
            { "Africa/Ceuta", Europe_Central },
            { "Africa/Dakar", GMT },
            { "Africa/Lagos", Africa_Western },
            { "Africa/Tunis", Europe_Central },
            { "America/Adak", Hawaii_Aleutian },
            { "America/Atka", Hawaii_Aleutian },
            { "America/Lima", Peru },
            { "America/Nome", Alaska },
            { "Asia/Baghdad", Arabian },
            { "Asia/Bahrain", Arabian },
            { "Asia/Bangkok", Indochina },
            { "Asia/Barnaul", Krasnoyarsk },
            { "Asia/Bishkek", Kyrgystan },
            { "Asia/Colombo", India },
            { "Asia/Irkutsk", Irkutsk },
            { "Asia/Jakarta", Indonesia_Western },
            { "Asia/Karachi", Pakistan },
            { "Asia/Kolkata", India },
            { "Asia/Kuching", Brunei },
            { "Asia/Magadan", Magadan },
            { "Asia/Nicosia", Europe_Eastern },
            { "Asia/Rangoon", Myanmar },
            { "Asia/Tbilisi", Georgia },
            { "Asia/Thimphu", Bhutan },
            { "Asia/Yakutsk", Yakutsk },
            { "Asia/Yerevan", Armenia },
            { "Canada/Yukon", Yukon },
            { "Europe/Kirov", Moscow },
            { "Europe/Malta", Europe_Central },
            { "Europe/Minsk", Moscow },
            { "Europe/Sofia", Europe_Eastern },
            { "Europe/Vaduz", Europe_Central },
            { "Indian/Cocos", Cocos },
            { "Pacific/Apia", Apia },
            { "Pacific/Fiji", Fiji },
            { "Pacific/Guam", Chamorro },
            { "Pacific/Niue", Niue },
            { "Pacific/Truk", Truk },
            { "Pacific/Wake", Wake },
            { "SystemV/AST4", Atlantic },
            { "SystemV/CST6", America_Central },
            { "SystemV/EST5", America_Eastern },
            { "SystemV/MST7", America_Mountain },
            { "SystemV/PST8", Pitcairn },
            { "SystemV/YST9", Gambier },
            { "Africa/Asmara", Africa_Eastern },
            { "Africa/Asmera", Africa_Eastern },
            { "Africa/Bamako", GMT },
            { "Africa/Bangui", Africa_Western },
            { "Africa/Banjul", GMT },
            { "Africa/Bissau", GMT },
            { "Africa/Douala", Africa_Western },
            { "Africa/Harare", Africa_Central },
            { "Africa/Kigali", Africa_Central },
            { "Africa/Luanda", Africa_Western },
            { "Africa/Lusaka", Africa_Central },
            { "Africa/Malabo", Africa_Western },
            { "Africa/Maputo", Africa_Central },
            { "Africa/Maseru", Africa_Southern },
            { "Africa/Niamey", Africa_Western },
            { "America/Aruba", Atlantic },
            { "America/Bahia", Brasilia },
            { "America/Belem", Brasilia },
            { "America/Boise", America_Mountain },
            { "America/Jujuy", Argentina },
            { "America/Thule", Atlantic },
            { "Asia/Ashgabat", Turkmenistan },
            { "Asia/Calcutta", India },
            { "Asia/Dushanbe", Tajikistan },
            { "Asia/Jayapura", Indonesia_Eastern },
            { "Asia/Katmandu", Nepal },
            { "Asia/Khandyga", Yakutsk },
            { "Asia/Makassar", Indonesia_Central },
            { "Asia/Qostanay", Kazakhstan },
            { "Asia/Sakhalin", Magadan },
            { "Asia/Tashkent", Uzbekistan },
            { "Asia/Tel_Aviv", Israel },
            { "Asia/Ust-Nera", Vladivostok },
            { "Australia/ACT", Australia_Eastern },
            { "Australia/LHI", Lord_Howe },
            { "Australia/NSW", Australia_Eastern },
            { "Etc/Greenwich", GMT },
            { "Etc/Universal",
                new String[] {
                    "Arénjmẹnt ọf Di Hól Wọld Taim",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Europe/Athens", Europe_Eastern },
            { "Europe/Berlin", Europe_Central },
            { "Europe/Dublin",
                new String[] {
                    "Grínwích Mín Taim",
                    "GMT",
                    "Aírísh Fíksd Taim",
                    "IST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Jersey",
                new String[] {
                    "Grínwích Mín Taim",
                    "GMT",
                    "Brítísh Họ́t Sízin Taim",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Lisbon", Europe_Western },
            { "Europe/London",
                new String[] {
                    "Grínwích Mín Taim",
                    "GMT",
                    "Brítísh Họ́t Sízin Taim",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Madrid", Europe_Central },
            { "Europe/Monaco", Europe_Central },
            { "Europe/Moscow", Moscow },
            { "Europe/Prague", Europe_Central },
            { "Europe/Skopje", Europe_Central },
            { "Europe/Tirane", Europe_Central },
            { "Europe/Vienna", Europe_Central },
            { "Europe/Warsaw", Europe_Central },
            { "Europe/Zagreb", Europe_Central },
            { "Europe/Zurich", Europe_Central },
            { "Indian/Chagos", Indian_Ocean },
            { "Indian/Comoro", Africa_Eastern },
            { "Pacific/Chuuk", Papua_New_Guinea },
            { "Pacific/Efate", Vanuatu },
            { "Pacific/Nauru", Nauru },
            { "Pacific/Palau", Palau },
            { "Pacific/Samoa", Samoa },
            { "SystemV/HST10", Hawaii },
            { "Africa/Abidjan", GMT },
            { "Africa/Algiers", Europe_Central },
            { "Africa/Conakry", GMT },
            { "Africa/Kampala", Africa_Eastern },
            { "Africa/Mbabane", Africa_Southern },
            { "Africa/Nairobi", Africa_Eastern },
            { "Africa/Tripoli", Europe_Eastern },
            { "America/Belize", America_Central },
            { "America/Bogota", Colombia },
            { "America/Cancun", America_Eastern },
            { "America/Cayman", America_Eastern },
            { "America/Cuiaba", Amazon },
            { "America/Dawson", Yukon },
            { "America/Guyana", Guyana },
            { "America/Havana", Cuba },
            { "America/Inuvik", America_Mountain },
            { "America/Juneau", Alaska },
            { "America/La_Paz", Bolivia },
            { "America/Maceio", Brasilia },
            { "America/Manaus", Amazon },
            { "America/Merida", America_Central },
            { "America/Nassau", America_Eastern },
            { "America/Panama", America_Eastern },
            { "America/Recife", Brasilia },
            { "America/Regina", America_Central },
            { "America/Virgin", Atlantic },
            { "Asia/Ashkhabad", Turkmenistan },
            { "Asia/Chongqing", China },
            { "Asia/Chungking", China },
            { "Asia/Famagusta", Europe_Eastern },
            { "Asia/Hong_Kong", Hong_Kong },
            { "Asia/Kathmandu", Nepal },
            { "Asia/Pontianak", Indonesia_Western },
            { "Asia/Pyongyang", Korea },
            { "Asia/Qyzylorda", Kazakhstan },
            { "Asia/Samarkand", Uzbekistan },
            { "Asia/Singapore", Singapore },
            { "Asia/Vientiane", Indochina },
            { "Atlantic/Faroe", Europe_Western },
            { "Australia/West", Australia_Western },
            { "Canada/Central", America_Central },
            { "Canada/Eastern", America_Eastern },
            { "Canada/Pacific", America_Pacific },
            { "Europe/Andorra", Europe_Central },
            { "Europe/Belfast",
                new String[] {
                    "Grínwích Mín Taim",
                    "GMT",
                    "Brítísh Họ́t Sízin Taim",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Nicosia", Europe_Eastern },
            { "Europe/Tallinn", Europe_Eastern },
            { "Europe/Vatican", Europe_Central },
            { "Europe/Vilnius", Europe_Eastern },
            { "Indian/Mayotte", Africa_Eastern },
            { "Indian/Reunion", Reunion },
            { "Mexico/BajaSur", Mexico_Pacific },
            { "Mexico/General", America_Central },
            { "Pacific/Easter", Easter },
            { "Pacific/Kanton", Phoenix_Islands },
            { "Pacific/Kosrae", Kosrae },
            { "Pacific/Majuro", Marshall_Islands },
            { "Pacific/Midway", Samoa },
            { "Pacific/Noumea", New_Caledonia },
            { "Pacific/Ponape", Solomon },
            { "Pacific/Saipan", Chamorro },
            { "Pacific/Tahiti", Tahiti },
            { "Pacific/Tarawa", Marshall_Islands },
            { "Pacific/Wallis", Gilbert_Islands },
            { "Africa/Blantyre", Africa_Central },
            { "Africa/Djibouti", Africa_Eastern },
            { "Africa/Freetown", GMT },
            { "Africa/Gaborone", Africa_Central },
            { "Africa/Khartoum", Africa_Central },
            { "Africa/Kinshasa", Africa_Western },
            { "Africa/Monrovia", GMT },
            { "Africa/Ndjamena", Africa_Western },
            { "Africa/Sao_Tome", GMT },
            { "Africa/Timbuktu", GMT },
            { "Africa/Windhoek", Africa_Central },
            { "America/Antigua", Atlantic },
            { "America/Caracas", Venezuela },
            { "America/Cayenne", French_Guiana },
            { "America/Cordoba", Argentina },
            { "America/Creston", America_Mountain },
            { "America/Curacao", Atlantic },
            { "America/Detroit", America_Eastern },
            { "America/Grenada", Atlantic },
            { "America/Iqaluit", America_Eastern },
            { "America/Jamaica", America_Eastern },
            { "America/Knox_IN", America_Central },
            { "America/Managua", America_Central },
            { "America/Marigot", Atlantic },
            { "America/Mendoza", Argentina },
            { "America/Moncton", Atlantic },
            { "America/Nipigon", America_Eastern },
            { "America/Noronha", Noronha },
            { "America/Ojinaga", America_Central },
            { "America/Tijuana", America_Pacific },
            { "America/Toronto", America_Eastern },
            { "America/Tortola", Atlantic },
            { "America/Yakutat", Alaska },
            { "Asia/Choibalsan", Mongolia },
            { "Asia/Phnom_Penh", Indochina },
            { "Asia/Ulan_Bator", Mongolia },
            { "Atlantic/Azores", Azores },
            { "Atlantic/Canary", Europe_Western },
            { "Atlantic/Faeroe", Europe_Western },
            { "Australia/Eucla", Australia_CentralWestern },
            { "Australia/North", Australia_Central },
            { "Australia/Perth", Australia_Western },
            { "Australia/South", Australia_Central },
            { "Canada/Atlantic", Atlantic },
            { "Canada/Mountain", America_Mountain },
            { "Europe/Belgrade", Europe_Central },
            { "Europe/Brussels", Europe_Central },
            { "Europe/Budapest", Europe_Central },
            { "Europe/Busingen", Europe_Central },
            { "Europe/Chisinau", Europe_Eastern },
            { "Europe/Guernsey",
                new String[] {
                    "Grínwích Mín Taim",
                    "GMT",
                    "Brítísh Họ́t Sízin Taim",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Helsinki", Europe_Eastern },
            { "Europe/Sarajevo", Europe_Central },
            { "Europe/Tiraspol", Europe_Eastern },
            { "Europe/Uzhgorod", Europe_Eastern },
            { "Indian/Maldives", French_Southern },
            { "Pacific/Chatham", Chatham },
            { "Pacific/Fakaofo", Tokelau },
            { "Pacific/Gambier", Gambier },
            { "Pacific/Norfolk", Norfolk },
            { "Pacific/Pohnpei", Solomon },
            { "SystemV/AST4ADT", Atlantic },
            { "SystemV/CST6CDT", America_Central },
            { "SystemV/EST5EDT", America_Eastern },
            { "SystemV/MST7MDT", America_Mountain },
            { "SystemV/PST8PDT", America_Pacific },
            { "SystemV/YST9YDT", Alaska },
            { "Africa/Bujumbura", Africa_Central },
            { "Africa/Mogadishu", Africa_Eastern },
            { "America/Anguilla", Atlantic },
            { "America/Asuncion", Paraguay },
            { "America/Atikokan", America_Eastern },
            { "America/Barbados", Atlantic },
            { "America/Dominica", Atlantic },
            { "America/Edmonton", America_Mountain },
            { "America/Ensenada", America_Pacific },
            { "America/Mazatlan", Mexico_Pacific },
            { "America/Miquelon", Pierre_Miquelon },
            { "America/Montreal", America_Eastern },
            { "America/Resolute", America_Central },
            { "America/Santarem", Brasilia },
            { "America/Santiago", Chile },
            { "America/Shiprock", America_Mountain },
            { "America/St_Kitts", Atlantic },
            { "America/St_Lucia", Atlantic },
            { "America/Winnipeg", America_Central },
            { "Antarctica/Casey", Australia_Western },
            { "Antarctica/Davis", Davis },
            { "Antarctica/Syowa", Syowa },
            { "Antarctica/Troll", GMT },
            { "Asia/Ho_Chi_Minh", Indochina },
            { "Asia/Krasnoyarsk", Krasnoyarsk },
            { "Asia/Novosibirsk", Krasnoyarsk },
            { "Asia/Ulaanbaatar", Mongolia },
            { "Asia/Vladivostok", Vladivostok },
            { "Atlantic/Bermuda", Atlantic },
            { "Atlantic/Madeira", Europe_Western },
            { "Atlantic/Stanley", Falkland },
            { "Australia/Currie", Australia_Eastern },
            { "Australia/Darwin", Australia_Central },
            { "Australia/Hobart", Australia_Eastern },
            { "Australia/Sydney", Australia_Eastern },
            { "Brazil/DeNoronha", Noronha },
            { "Europe/Amsterdam", Europe_Central },
            { "Europe/Gibraltar", Europe_Central },
            { "Europe/Ljubljana", Europe_Central },
            { "Europe/Mariehamn", Europe_Eastern },
            { "Europe/Podgorica", Europe_Central },
            { "Europe/Stockholm", Europe_Central },
            { "Europe/Volgograd", Moscow },
            { "Indian/Christmas", Christmas },
            { "Indian/Kerguelen", French_Southern },
            { "Indian/Mauritius", Mauritius },
            { "Mexico/BajaNorte", America_Pacific },
            { "Pacific/Auckland", New_Zealand },
            { "Pacific/Funafuti", Tuvalu },
            { "Pacific/Johnston", Hawaii },
            { "Pacific/Pitcairn", Pitcairn },
            { "Africa/Libreville", Africa_Western },
            { "Africa/Lubumbashi", Africa_Central },
            { "Africa/Nouakchott", GMT },
            { "Africa/Porto-Novo", Africa_Western },
            { "America/Araguaina", Brasilia },
            { "America/Boa_Vista", Amazon },
            { "America/Catamarca", Argentina },
            { "America/Chihuahua", America_Central },
            { "America/Fortaleza", Brasilia },
            { "America/Glace_Bay", Atlantic },
            { "America/Goose_Bay", Atlantic },
            { "America/Guatemala", America_Central },
            { "America/Guayaquil", Ecuador },
            { "America/Matamoros", America_Central },
            { "America/Menominee", America_Central },
            { "America/Monterrey", America_Central },
            { "America/Sao_Paulo", Brasilia },
            { "America/St_Thomas", Atlantic },
            { "America/Vancouver", America_Pacific },
            { "Antarctica/Mawson", Mawson },
            { "Antarctica/Vostok", Vostok },
            { "Asia/Kuala_Lumpur", Malaysia },
            { "Asia/Novokuznetsk", Krasnoyarsk },
            { "Chile/Continental", Chile },
            { "Europe/Bratislava", Europe_Central },
            { "Europe/Copenhagen", Europe_Central },
            { "Europe/Luxembourg", Europe_Central },
            { "Europe/San_Marino", Europe_Central },
            { "Europe/Simferopol", Moscow },
            { "Europe/Zaporozhye", Europe_Eastern },
            { "Pacific/Enderbury", Phoenix_Islands },
            { "Pacific/Galapagos", Galapagos },
            { "Pacific/Kwajalein", Marshall_Islands },
            { "Pacific/Marquesas", Marquesas },
            { "Pacific/Pago_Pago", Samoa },
            { "Pacific/Rarotonga", Cook },
            { "Pacific/Tongatapu", Tonga },
            { "US/Indiana-Starke", America_Central },
            { "Africa/Addis_Ababa", Africa_Eastern },
            { "Africa/Brazzaville", Africa_Western },
            { "Africa/Ouagadougou", GMT },
            { "America/Costa_Rica", America_Central },
            { "America/Grand_Turk", America_Eastern },
            { "America/Guadeloupe", Atlantic },
            { "America/Hermosillo", Mexico_Pacific },
            { "America/Kralendijk", Atlantic },
            { "America/Louisville", America_Eastern },
            { "America/Martinique", Atlantic },
            { "America/Metlakatla", Alaska },
            { "America/Montevideo", Uruguay },
            { "America/Montserrat", Atlantic },
            { "America/Paramaribo", Suriname },
            { "America/St_Vincent", Atlantic },
            { "America/Whitehorse", Yukon },
            { "Antarctica/McMurdo", New_Zealand },
            { "Antarctica/Rothera", Rothera },
            { "Asia/Srednekolymsk", Magadan },
            { "Asia/Ujung_Pandang", Indonesia_Central },
            { "Asia/Yekaterinburg", Yekaterinburg },
            { "Atlantic/Jan_Mayen", Europe_Central },
            { "Atlantic/Reykjavik", GMT },
            { "Atlantic/St_Helena", GMT },
            { "Australia/Adelaide", Australia_Central },
            { "Australia/Brisbane", Australia_Eastern },
            { "Australia/Canberra", Australia_Eastern },
            { "Australia/Lindeman", Australia_Eastern },
            { "Australia/Tasmania", Australia_Eastern },
            { "Australia/Victoria", Australia_Eastern },
            { "Chile/EasterIsland", Easter },
            { "Europe/Isle_of_Man",
                new String[] {
                    "Grínwích Mín Taim",
                    "GMT",
                    "Brítísh Họ́t Sízin Taim",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Kaliningrad", Europe_Eastern },
            { "Pacific/Kiritimati", Line_Islands },
            { "Africa/Johannesburg", Africa_Southern },
            { "America/El_Salvador", America_Central },
            { "America/Fort_Nelson", America_Mountain },
            { "America/Mexico_City", America_Central },
            { "America/Pangnirtung", America_Eastern },
            { "America/Porto_Velho", Amazon },
            { "America/Puerto_Rico", Atlantic },
            { "America/Rainy_River", America_Central },
            { "America/Tegucigalpa", America_Central },
            { "America/Thunder_Bay", America_Eastern },
            { "America/Yellowknife", America_Mountain },
            { "Arctic/Longyearbyen", Europe_Central },
            { "Atlantic/Cape_Verde", Cape_Verde },
            { "Australia/Lord_Howe", Lord_Howe },
            { "Australia/Melbourne", Australia_Eastern },
            { "Canada/Newfoundland", Newfoundland },
            { "Canada/Saskatchewan", America_Central },
            { "Indian/Antananarivo", Africa_Eastern },
            { "Pacific/Guadalcanal", Solomon },
            { "Africa/Dar_es_Salaam", Africa_Eastern },
            { "America/Blanc-Sablon", Atlantic },
            { "America/Buenos_Aires", Argentina },
            { "America/Campo_Grande", Amazon },
            { "America/Danmarkshavn", GMT },
            { "America/Dawson_Creek", America_Mountain },
            { "America/Indiana/Knox", America_Central },
            { "America/Rankin_Inlet", America_Central },
            { "America/Santa_Isabel", America_Pacific },
            { "Antarctica/Macquarie", Australia_Eastern },
            { "Australia/Queensland", Australia_Eastern },
            { "Australia/Yancowinna", Australia_Central },
            { "Pacific/Port_Moresby", DumontDUrville },
            { "America/Cambridge_Bay", America_Mountain },
            { "America/Ciudad_Juarez", America_Mountain },
            { "America/Coral_Harbour", America_Eastern },
            { "America/Indiana/Vevay", America_Eastern },
            { "America/Lower_Princes", Atlantic },
            { "America/Port_of_Spain", Atlantic },
            { "America/Santo_Domingo", Atlantic },
            { "America/St_Barthelemy", Atlantic },
            { "America/Swift_Current", America_Central },
            { "Antarctica/South_Pole", New_Zealand },
            { "Australia/Broken_Hill", Australia_Central },
            { "America/Bahia_Banderas", America_Central },
            { "America/Port-au-Prince", America_Eastern },
            { "Atlantic/South_Georgia", South_Georgia },
            { "America/Argentina/Jujuy", Argentina },
            { "America/Argentina/Salta", Argentina },
            { "America/Indiana/Marengo", America_Eastern },
            { "America/Indiana/Winamac", America_Eastern },
            { "America/Argentina/Cordoba", Argentina },
            { "America/Argentina/Mendoza", Argentina },
            { "America/Argentina/Tucuman", Argentina },
            { "America/Argentina/Ushuaia", Argentina },
            { "America/Indiana/Tell_City", America_Central },
            { "America/Indiana/Vincennes", America_Eastern },
            { "Antarctica/DumontDUrville", DumontDUrville },
            { "timezone.excity.Asia/Aden", "Édẹn" },
            { "timezone.excity.Asia/Baku", "Báku" },
            { "timezone.excity.Asia/Dili", "Díli" },
            { "timezone.excity.Asia/Gaza", "Gáza" },
            { "timezone.excity.Asia/Omsk", "Ọmsk" },
            { "timezone.excity.Asia/Oral", "Ọ́ral" },
            { "America/Argentina/La_Rioja", Argentina },
            { "America/Argentina/San_Juan", Argentina },
            { "America/Argentina/San_Luis", Argentina },
            { "America/Indiana/Petersburg", America_Eastern },
            { "timezone.excity.Asia/Amman", "Aman" },
            { "timezone.excity.Asia/Aqtau", "Aktáu" },
            { "timezone.excity.Asia/Chita", "Chítá" },
            { "timezone.excity.Asia/Dhaka", "Dáka" },
            { "timezone.excity.Asia/Macau", "Makáo" },
            { "timezone.excity.Asia/Qatar", "Káta" },
            { "timezone.excity.Asia/Seoul", "Sol" },
            { "timezone.excity.Asia/Tokyo", "Tókyo" },
            { "America/Argentina/Catamarca", Argentina },
            { "America/Kentucky/Louisville", America_Eastern },
            { "America/Kentucky/Monticello", America_Eastern },
            { "America/North_Dakota/Beulah", America_Central },
            { "America/North_Dakota/Center", America_Central },
            { "timezone.excity.Africa/Juba", "Júba" },
            { "timezone.excity.Africa/Lome", "Lómẹ" },
            { "timezone.excity.Asia/Almaty", "Álmáti" },
            { "timezone.excity.Asia/Anadyr", "Ánadiar" },
            { "timezone.excity.Asia/Aqtobe", "Aktóbẹ" },
            { "timezone.excity.Asia/Atyrau", "Átírau" },
            { "timezone.excity.Asia/Beirut", "Bẹrut" },
            { "timezone.excity.Asia/Brunei", "Brunẹi" },
            { "timezone.excity.Asia/Hebron", "Hẹ́brọn" },
            { "timezone.excity.Asia/Kuwait", "Kuwet" },
            { "timezone.excity.Asia/Manila", "Maníla" },
            { "timezone.excity.Asia/Muscat", "Múskat" },
            { "timezone.excity.Asia/Riyadh", "Riyád" },
            { "timezone.excity.Asia/Saigon", "Hó Chi Mín Síti" },
            { "timezone.excity.Asia/Taipei", "Taipẹi" },
            { "timezone.excity.Asia/Tehran", "Tẹran" },
            { "timezone.excity.Asia/Urumqi", "Yurọ́mki" },
            { "timezone.excity.Etc/Unknown", "Taun wé Pẹ́sin Nọ́ No" },
            { "timezone.excity.Europe/Kiev", "Kiẹv" },
            { "timezone.excity.Europe/Oslo", "Ọ́slo" },
            { "timezone.excity.Europe/Riga", "Ríga" },
            { "timezone.excity.Europe/Rome", "Rom" },
            { "timezone.excity.Indian/Mahe", "Mahẹ́" },
            { "America/Indiana/Indianapolis", America_Eastern },
            { "timezone.excity.Africa/Accra", "Akrá" },
            { "timezone.excity.Africa/Cairo", "Kaíro" },
            { "timezone.excity.Africa/Ceuta", "Sẹúta" },
            { "timezone.excity.Africa/Dakar", "Dakár" },
            { "timezone.excity.Africa/Lagos", "Légos" },
            { "timezone.excity.Africa/Tunis", "Túnis" },
            { "timezone.excity.America/Adak", "Ádak" },
            { "timezone.excity.America/Lima", "Líma" },
            { "timezone.excity.America/Nome", "Noom" },
            { "timezone.excity.Asia/Baghdad", "Bágdad" },
            { "timezone.excity.Asia/Bahrain", "Bahrén" },
            { "timezone.excity.Asia/Bangkok", "Bánkọk" },
            { "timezone.excity.Asia/Barnaul", "Bárnául" },
            { "timezone.excity.Asia/Bishkek", "Bishkẹk" },
            { "timezone.excity.Asia/Colombo", "Kolómbo" },
            { "timezone.excity.Asia/Irkutsk", "Irkútsk" },
            { "timezone.excity.Asia/Jakarta", "Jakáta" },
            { "timezone.excity.Asia/Karachi", "Karáchi" },
            { "timezone.excity.Asia/Magadan", "Mágádan" },
            { "timezone.excity.Asia/Nicosia", "Nikosia" },
            { "timezone.excity.Asia/Rangoon", "Yangọn" },
            { "timezone.excity.Asia/Tbilisi", "Tiblísi" },
            { "timezone.excity.Asia/Thimphu", "Tímfu" },
            { "timezone.excity.Asia/Yakutsk", "Yékútsk" },
            { "timezone.excity.Asia/Yerevan", "Yẹrẹ́van" },
            { "timezone.excity.Europe/Kirov", "Kirọv" },
            { "timezone.excity.Europe/Malta", "Mọ́lta" },
            { "timezone.excity.Europe/Paris", "Páris" },
            { "timezone.excity.Europe/Sofia", "Sofía" },
            { "timezone.excity.Indian/Cocos", "Kókos" },
            { "timezone.excity.Pacific/Apia", "Ápia" },
            { "timezone.excity.Pacific/Fiji", "Fíji" },
            { "timezone.excity.Pacific/Niue", "Niú" },
            { "timezone.excity.Pacific/Truk", "Chuk" },
            { "timezone.excity.Pacific/Wake", "Wek" },
            { "timezone.excity.Africa/Asmera", "Asmára" },
            { "timezone.excity.Africa/Bamako", "Bamáko" },
            { "timezone.excity.Africa/Bangui", "Bangúi" },
            { "timezone.excity.Africa/Bissau", "Bisau" },
            { "timezone.excity.Africa/Douala", "Duála" },
            { "timezone.excity.Africa/Harare", "Harárẹ" },
            { "timezone.excity.Africa/Kigali", "Kigáli" },
            { "timezone.excity.Africa/Luanda", "Luánda" },
            { "timezone.excity.Africa/Lusaka", "Lusáka" },
            { "timezone.excity.Africa/Malabo", "Malábo" },
            { "timezone.excity.Africa/Maputo", "Mapúto" },
            { "timezone.excity.Africa/Maseru", "Masẹ́ru" },
            { "timezone.excity.Africa/Niamey", "Niáme" },
            { "timezone.excity.America/Aruba", "Arúba" },
            { "timezone.excity.America/Bahia", "Bahía" },
            { "timezone.excity.America/Belem", "Bẹlẹm" },
            { "timezone.excity.America/Boise", "Bọísi" },
            { "timezone.excity.America/Jujuy", "Huhui" },
            { "timezone.excity.America/Thule", "Túli" },
            { "timezone.excity.Asia/Ashgabat", "Áshgabat" },
            { "timezone.excity.Asia/Calcutta", "Kolkáta" },
            { "timezone.excity.Asia/Damascus", "Damáskọs" },
            { "timezone.excity.Asia/Dushanbe", "Dushánbẹ" },
            { "timezone.excity.Asia/Jayapura", "Jayapúra" },
            { "timezone.excity.Asia/Katmandu", "Katmándu" },
            { "timezone.excity.Asia/Khandyga", "Kandíga" },
            { "timezone.excity.Asia/Makassar", "Makása" },
            { "timezone.excity.Asia/Qostanay", "Kostánai" },
            { "timezone.excity.Asia/Sakhalin", "Sákhalin" },
            { "timezone.excity.Asia/Shanghai", "Shánghai" },
            { "timezone.excity.Asia/Tashkent", "Táshkẹnt" },
            { "timezone.excity.Asia/Ust-Nera", "Ust-Nẹ́ra" },
            { "timezone.excity.Europe/Athens", "Átẹns" },
            { "timezone.excity.Europe/Berlin", "Bẹlin" },
            { "timezone.excity.Europe/Dublin", "Dọ́blin" },
            { "timezone.excity.Europe/Jersey", "Jẹ́si" },
            { "timezone.excity.Europe/Lisbon", "Lísbọn" },
            { "timezone.excity.Europe/London", "Lọ́ndọn" },
            { "timezone.excity.Europe/Monaco", "Mọ́náko" },
            { "timezone.excity.Europe/Moscow", "Mọ́sko" },
            { "timezone.excity.Europe/Prague", "Prag" },
            { "timezone.excity.Europe/Samara", "Samára" },
            { "timezone.excity.Europe/Skopje", "Skọ́pyẹ" },
            { "timezone.excity.Europe/Tirane", "Tiránẹ" },
            { "timezone.excity.Europe/Vienna", "Viẹ́na" },
            { "timezone.excity.Europe/Warsaw", "Wọ́sọ" },
            { "timezone.excity.Europe/Zagreb", "Zágrẹb" },
            { "timezone.excity.Europe/Zurich", "Zúrik" },
            { "timezone.excity.Indian/Chagos", "Chágọs" },
            { "timezone.excity.Indian/Comoro", "Kọ́mọ́ros" },
            { "timezone.excity.Pacific/Efate", "Ẹfátẹ" },
            { "timezone.excity.Pacific/Nauru", "Naúru" },
            { "timezone.excity.Pacific/Palau", "Paláu" },
            { "America/Argentina/Buenos_Aires", Argentina },
            { "America/Argentina/Rio_Gallegos", Argentina },
            { "America/North_Dakota/New_Salem", America_Central },
            { "timezone.excity.Africa/Abidjan", "Ábijan" },
            { "timezone.excity.Africa/Algiers", "Aljíẹz" },
            { "timezone.excity.Africa/Conakry", "Kọnákri" },
            { "timezone.excity.Africa/Kampala", "Kampála" },
            { "timezone.excity.Africa/Mbabane", "Mbabánẹ" },
            { "timezone.excity.Africa/Nairobi", "Naíróbi" },
            { "timezone.excity.Africa/Tripoli", "Trípọ́li" },
            { "timezone.excity.America/Belize", "Bẹliz" },
            { "timezone.excity.America/Cancun", "Kankun" },
            { "timezone.excity.America/Cayman", "Kéman" },
            { "timezone.excity.America/Cuiaba", "Kúyábaa" },
            { "timezone.excity.America/Dawson", "Dọ́sọn" },
            { "timezone.excity.America/Denver", "Dẹ́nva" },
            { "timezone.excity.America/Guyana", "Gayána" },
            { "timezone.excity.America/Havana", "Havána" },
            { "timezone.excity.America/Inuvik", "Inúvik" },
            { "timezone.excity.America/Juneau", "Júno" },
            { "timezone.excity.America/Maceio", "Masẹ́io" },
            { "timezone.excity.America/Manaus", "Manáus" },
            { "timezone.excity.America/Merida", "Mẹ́rída" },
            { "timezone.excity.America/Nassau", "Nássọu" },
            { "timezone.excity.America/Panama", "Pánáma" },
            { "timezone.excity.America/Recife", "Rẹsífẹ" },
            { "timezone.excity.America/Regina", "Rẹjína" },
            { "timezone.excity.Asia/Famagusta", "Fagústa" },
            { "timezone.excity.Asia/Hong_Kong", "Họng Kọng" },
            { "timezone.excity.Asia/Jerusalem", "Jẹrúsálẹm" },
            { "timezone.excity.Asia/Kamchatka", "Kamchátké" },
            { "timezone.excity.Asia/Pontianak", "Pọntiának" },
            { "timezone.excity.Asia/Pyongyang", "Piọngyang" },
            { "timezone.excity.Asia/Qyzylorda", "Kízilọ́da" },
            { "timezone.excity.Asia/Samarkand", "Sámákand" },
            { "timezone.excity.Asia/Singapore", "Singapọ" },
            { "timezone.excity.Asia/Vientiane", "Viẹ́ntiẹn" },
            { "timezone.excity.Europe/Andorra", "Andọ́ra" },
            { "timezone.excity.Europe/Saratov", "Sárátov" },
            { "timezone.excity.Europe/Tallinn", "Tálin" },
            { "timezone.excity.Europe/Vatican", "Vátíkan" },
            { "timezone.excity.Europe/Vilnius", "Vílnius" },
            { "timezone.excity.Indian/Mayotte", "Meyọt" },
            { "timezone.excity.Indian/Reunion", "Riyúniọn" },
            { "timezone.excity.Pacific/Easter", "Ísta" },
            { "timezone.excity.Pacific/Kosrae", "Kọ́sraẹ" },
            { "timezone.excity.Pacific/Majuro", "Majúro" },
            { "timezone.excity.Pacific/Midway", "Mídwè" },
            { "timezone.excity.Pacific/Noumea", "Númẹ́a" },
            { "timezone.excity.Pacific/Ponape", "Pọnpẹ́i" },
            { "timezone.excity.Pacific/Tahiti", "Tahíti" },
            { "timezone.excity.Pacific/Tarawa", "Taráwa" },
            { "timezone.excity.Pacific/Wallis", "Wáli" },
            { "timezone.excity.Africa/Blantyre", "Blantáya" },
            { "timezone.excity.Africa/Djibouti", "Jibúti" },
            { "timezone.excity.Africa/El_Aaiun", "Ẹl Aiun" },
            { "timezone.excity.Africa/Freetown", "Frítaun" },
            { "timezone.excity.Africa/Gaborone", "Háborónẹ" },
            { "timezone.excity.Africa/Khartoum", "Kartum" },
            { "timezone.excity.Africa/Kinshasa", "Kinshásha" },
            { "timezone.excity.Africa/Monrovia", "Monróvia" },
            { "timezone.excity.Africa/Ndjamena", "Njamẹ́na" },
            { "timezone.excity.Africa/Sao_Tome", "Sao Tómẹ" },
            { "timezone.excity.Africa/Windhoek", "Wíndhok" },
            { "timezone.excity.America/Antigua", "Antígwua" },
            { "timezone.excity.America/Caracas", "Karákas" },
            { "timezone.excity.America/Cayenne", "Kayẹn" },
            { "timezone.excity.America/Chicago", "Chikágo" },
            { "timezone.excity.America/Cordoba", "Kórdoba" },
            { "timezone.excity.America/Creston", "Krẹ́stọn" },
            { "timezone.excity.America/Curacao", "Kiurásao" },
            { "timezone.excity.America/Detroit", "Ditrọit" },
            { "timezone.excity.America/Grenada", "Grẹnéda" },
            { "timezone.excity.America/Halifax", "Hálífaks" },
            { "timezone.excity.America/Iqaluit", "Ikáluit" },
            { "timezone.excity.America/Jamaica", "Jamaíka" },
            { "timezone.excity.America/Managua", "Manágua" },
            { "timezone.excity.America/Marigot", "Márígọt" },
            { "timezone.excity.America/Mendoza", "Mẹndóza" },
            { "timezone.excity.America/Moncton", "Mọ́nktọn" },
            { "timezone.excity.America/Noronha", "Nọrónia" },
            { "timezone.excity.America/Ojinaga", "Okhinága" },
            { "timezone.excity.America/Phoenix", "Fíniks" },
            { "timezone.excity.America/Tijuana", "Tikhuána" },
            { "timezone.excity.America/Toronto", "Torónto" },
            { "timezone.excity.America/Tortola", "Tọtóla" },
            { "timezone.excity.America/Yakutat", "Yakútat" },
            { "timezone.excity.Asia/Phnom_Penh", "Fnọ́m Pẹn" },
            { "timezone.excity.Atlantic/Azores", "Azọz" },
            { "timezone.excity.Atlantic/Canary", "Kenerí" },
            { "timezone.excity.Atlantic/Faeroe", "Fáróis" },
            { "timezone.excity.Australia/Eucla", "Yúkla" },
            { "timezone.excity.Australia/Perth", "Pẹrt" },
            { "timezone.excity.Europe/Belgrade", "Bẹ́lgréd" },
            { "timezone.excity.Europe/Brussels", "Brúsuls" },
            { "timezone.excity.Europe/Budapest", "Búdápẹst" },
            { "timezone.excity.Europe/Busingen", "Busíngẹn" },
            { "timezone.excity.Europe/Chisinau", "Chisináu" },
            { "timezone.excity.Europe/Guernsey", "Guẹnzi" },
            { "timezone.excity.Europe/Helsinki", "Hẹlsínki" },
            { "timezone.excity.Europe/Istanbul", "Ístánbul" },
            { "timezone.excity.Europe/Sarajevo", "Sarayẹ́vo" },
            { "timezone.excity.Indian/Maldives", "Mọ́ldivs" },
            { "timezone.excity.Pacific/Chatham", "Chátam" },
            { "timezone.excity.Pacific/Fakaofo", "Fakáófo" },
            { "timezone.excity.Pacific/Gambier", "Gámbiẹr" },
            { "timezone.excity.Pacific/Norfolk", "Nọ́rfọ́lk" },
            { "timezone.excity.Africa/Bujumbura", "Bujumbúra" },
            { "timezone.excity.Africa/Mogadishu", "Mọgádíshu" },
            { "timezone.excity.America/Anguilla", "Angwíla" },
            { "timezone.excity.America/Asuncion", "Asunsiọn" },
            { "timezone.excity.America/Barbados", "Barbédọs" },
            { "timezone.excity.America/Dominica", "Dọmíníka" },
            { "timezone.excity.America/Edmonton", "Ẹ́dmọ́ntọn" },
            { "timezone.excity.America/Eirunepe", "Ẹirunẹpẹ" },
            { "timezone.excity.America/Mazatlan", "Mazátlan" },
            { "timezone.excity.America/Miquelon", "Míkẹlọn" },
            { "timezone.excity.America/New_York", "Niú Yọk" },
            { "timezone.excity.America/Resolute", "Rẹ́zólut" },
            { "timezone.excity.America/Santarem", "Santarẹm" },
            { "timezone.excity.America/Santiago", "Santiágo" },
            { "timezone.excity.America/St_Johns", "Sent Jọn" },
            { "timezone.excity.America/St_Kitts", "Sent Kits" },
            { "timezone.excity.America/St_Lucia", "Sent Lúshia" },
            { "timezone.excity.America/Winnipeg", "Wínípẹg" },
            { "timezone.excity.Antarctica/Casey", "Kési" },
            { "timezone.excity.Antarctica/Davis", "Dévis" },
            { "timezone.excity.Antarctica/Syowa", "Siówa" },
            { "timezone.excity.Antarctica/Troll", "Trol" },
            { "timezone.excity.Asia/Krasnoyarsk", "Krasnoyask" },
            { "timezone.excity.Asia/Novosibirsk", "Novosibisk" },
            { "timezone.excity.Asia/Ulaanbaatar", "Ulanbáta" },
            { "timezone.excity.Asia/Vladivostok", "Vladivọstọk" },
            { "timezone.excity.Atlantic/Bermuda", "Bẹmiúda" },
            { "timezone.excity.Atlantic/Madeira", "Madíra" },
            { "timezone.excity.Atlantic/Stanley", "Stánli" },
            { "timezone.excity.Australia/Darwin", "Dárwin" },
            { "timezone.excity.Australia/Hobart", "Hóbat" },
            { "timezone.excity.Australia/Sydney", "Sídni" },
            { "timezone.excity.Europe/Amsterdam", "Ámstádam" },
            { "timezone.excity.Europe/Astrakhan", "Ástrahán" },
            { "timezone.excity.Europe/Bucharest", "Búkárẹst" },
            { "timezone.excity.Europe/Gibraltar", "Jibrọ́lta" },
            { "timezone.excity.Europe/Ljubljana", "Lubliána" },
            { "timezone.excity.Europe/Mariehamn", "Maríahámn" },
            { "timezone.excity.Europe/Podgorica", "Pọ́jóríka" },
            { "timezone.excity.Europe/Stockholm", "Stọ́khọm" },
            { "timezone.excity.Europe/Ulyanovsk", "Uliánọvsk" },
            { "timezone.excity.Europe/Volgograd", "Volvógrad" },
            { "timezone.excity.Indian/Christmas", "Krísmas" },
            { "timezone.excity.Indian/Kerguelen", "Kẹ́rgúlẹn" },
            { "timezone.excity.Indian/Mauritius", "Mọríshọs" },
            { "timezone.excity.Pacific/Auckland", "Ọ́kland" },
            { "timezone.excity.Pacific/Funafuti", "Funafúti" },
            { "timezone.excity.Pacific/Pitcairn", "Pítkan" },
            { "timezone.excity.Africa/Casablanca", "Kasablánka" },
            { "timezone.excity.Africa/Libreville", "Líbrẹvil" },
            { "timezone.excity.Africa/Lubumbashi", "Lubumbáshi" },
            { "timezone.excity.Africa/Nouakchott", "Nouákshọt" },
            { "timezone.excity.Africa/Porto-Novo", "Pọto-Nóvo" },
            { "timezone.excity.America/Anchorage", "Ánkọ́rej" },
            { "timezone.excity.America/Araguaina", "Aragwuaína" },
            { "timezone.excity.America/Boa_Vista", "Bóa Vísta" },
            { "timezone.excity.America/Catamarca", "Katamáka" },
            { "timezone.excity.America/Chihuahua", "Chiwuáwua" },
            { "timezone.excity.America/Fortaleza", "Fọtalẹ́za" },
            { "timezone.excity.America/Glace_Bay", "Glás Bè" },
            { "timezone.excity.America/Goose_Bay", "Gúz Bè" },
            { "timezone.excity.America/Guatemala", "Guátẹmála" },
            { "timezone.excity.America/Guayaquil", "Guáyakil" },
            { "timezone.excity.America/Matamoros", "Mátamóros" },
            { "timezone.excity.America/Menominee", "Mẹnọ́minii" },
            { "timezone.excity.America/Monterrey", "Mọntẹrẹẹ" },
            { "timezone.excity.America/Sao_Paulo", "Sao Paúlo" },
            { "timezone.excity.America/St_Thomas", "Sent Tọmọs" },
            { "timezone.excity.America/Vancouver", "Vankúva" },
            { "timezone.excity.Antarctica/Mawson", "Mọ́sọn" },
            { "timezone.excity.Antarctica/Palmer", "Páma" },
            { "timezone.excity.Antarctica/Vostok", "Vọ́stọk" },
            { "timezone.excity.Asia/Kuala_Lumpur", "Kuála Lúmpọ" },
            { "timezone.excity.Asia/Novokuznetsk", "Novokuznẹ́sk" },
            { "timezone.excity.Europe/Bratislava", "Bratísláva" },
            { "timezone.excity.Europe/Copenhagen", "Kọpẹnhágẹn" },
            { "timezone.excity.Europe/Luxembourg", "Lọ́ksẹ́mbọg" },
            { "timezone.excity.Europe/San_Marino", "San Maríno" },
            { "timezone.excity.Europe/Simferopol", "Símfẹrópol" },
            { "timezone.excity.Pacific/Galapagos", "Galápágọs" },
            { "timezone.excity.Pacific/Kwajalein", "Kwájalẹn" },
            { "timezone.excity.Pacific/Marquesas", "Makwẹ́sas" },
            { "timezone.excity.Pacific/Pago_Pago", "Págo Págo" },
            { "timezone.excity.Pacific/Rarotonga", "Raratónga" },
            { "timezone.excity.Pacific/Tongatapu", "Tongatápu" },
            { "timezone.excity.Africa/Addis_Ababa", "Adí Abába" },
            { "timezone.excity.Africa/Brazzaville", "Brázavil" },
            { "timezone.excity.Africa/Ouagadougou", "Ouagadúgu" },
            { "timezone.excity.America/Costa_Rica", "Kósta Ríka" },
            { "timezone.excity.America/Grand_Turk", "Gránd Tọk" },
            { "timezone.excity.America/Guadeloupe", "Guadalúpẹ" },
            { "timezone.excity.America/Hermosillo", "Hẹ́mósílo" },
            { "timezone.excity.America/Kralendijk", "Králẹ́ndijk" },
            { "timezone.excity.America/Louisville", "Luívil" },
            { "timezone.excity.America/Martinique", "Matínik" },
            { "timezone.excity.America/Metlakatla", "Mẹtlakátla" },
            { "timezone.excity.America/Montevideo", "Mọntẹvidẹo" },
            { "timezone.excity.America/Montserrat", "Mọntsẹrat" },
            { "timezone.excity.America/Paramaribo", "Párámaribo" },
            { "timezone.excity.America/Rio_Branco", "Rió Bránko" },
            { "timezone.excity.America/St_Vincent", "Sent Vínsẹnt" },
            { "timezone.excity.America/Whitehorse", "Waíthọs" },
            { "timezone.excity.Antarctica/McMurdo", "McMọ́do" },
            { "timezone.excity.Antarctica/Rothera", "Rotẹ́ra" },
            { "timezone.excity.Asia/Srednekolymsk", "Srẹ́dnẹkolimsk" },
            { "timezone.excity.Asia/Yekaterinburg", "Yẹketẹrínbug" },
            { "timezone.excity.Atlantic/Reykjavik", "Rẹ́kjávik" },
            { "timezone.excity.Atlantic/St_Helena", "Sent Hẹlẹ́na" },
            { "timezone.excity.Australia/Adelaide", "Adleid" },
            { "timezone.excity.Australia/Brisbane", "Brísben" },
            { "timezone.excity.Australia/Lindeman", "Líndẹman" },
            { "timezone.excity.Europe/Isle_of_Man", "Aíl ọf Man" },
            { "timezone.excity.Europe/Kaliningrad", "Kalíníngrad" },
            { "timezone.excity.Pacific/Kiritimati", "Kritímáti" },
            { "timezone.excity.Africa/Johannesburg", "Johánísbọg" },
            { "timezone.excity.America/El_Salvador", "El Sálvádọ" },
            { "timezone.excity.America/Fort_Nelson", "Fọt Nẹ́lson" },
            { "timezone.excity.America/Los_Angeles", "Lọs Ánjẹ́lis" },
            { "timezone.excity.America/Mexico_City", "Mẹ́ksíkó Síti" },
            { "timezone.excity.America/Porto_Velho", "Pọto Vẹ́lho" },
            { "timezone.excity.America/Puerto_Rico", "Puẹ́rto Ríkọ" },
            { "timezone.excity.America/Tegucigalpa", "Tẹgúsigálpa" },
            { "timezone.excity.Arctic/Longyearbyen", "Lọngyẹ́abiẹn" },
            { "timezone.excity.Atlantic/Cape_Verde", "Kép Vẹd" },
            { "timezone.excity.Australia/Lord_Howe", "Lọd Haú" },
            { "timezone.excity.Australia/Melbourne", "Mẹ́lbọn" },
            { "timezone.excity.Indian/Antananarivo", "Antánánarívo" },
            { "timezone.excity.Pacific/Guadalcanal", "Guádálkanal" },
            { "timezone.excity.Africa/Dar_es_Salaam", "Dar ẹ́s Salam" },
            { "timezone.excity.America/Blanc-Sablon", "Blank-Sáblọn" },
            { "timezone.excity.America/Buenos_Aires", "Buẹnos Aírẹs" },
            { "timezone.excity.America/Campo_Grande", "Kampó Grándẹ" },
            { "timezone.excity.America/Danmarkshavn", "Danmákshávun" },
            { "timezone.excity.America/Dawson_Creek", "Dọ́sọn Krik" },
            { "timezone.excity.America/Indiana/Knox", "Nọks, Indiána" },
            { "timezone.excity.America/Indianapolis", "Indiánápọ́lis" },
            { "timezone.excity.America/Punta_Arenas", "Púntá Arẹ́nas" },
            { "timezone.excity.America/Rankin_Inlet", "Ránkín Ínlẹt" },
            { "timezone.excity.America/Scoresbysund", "Itókotúrmit" },
            { "timezone.excity.Antarctica/Macquarie", "Makwuéí" },
            { "timezone.excity.Pacific/Bougainville", "Bugenvília" },
            { "timezone.excity.Pacific/Port_Moresby", "Pọt Mọrẹ́sbi" },
            { "timezone.excity.America/Cambridge_Bay", "Kémbríj Bè" },
            { "timezone.excity.America/Coral_Harbour", "Atíkókan" },
            { "timezone.excity.America/Indiana/Vevay", "Vẹ́ve, Indiána" },
            { "timezone.excity.America/Lower_Princes", "Lówá Príns Im Kwọ́ta" },
            { "timezone.excity.America/Port_of_Spain", "Pọ́t ọf Spen" },
            { "timezone.excity.America/Santo_Domingo", "Sántó Domíngo" },
            { "timezone.excity.America/St_Barthelemy", "Sent Batẹlẹ́mi" },
            { "timezone.excity.America/Swift_Current", "Swíft Kọ́rẹnt" },
            { "timezone.excity.Australia/Broken_Hill", "Brókún Hil" },
            { "timezone.excity.America/Bahia_Banderas", "Bahía Bandẹ́ras" },
            { "timezone.excity.America/Port-au-Prince", "Pọt-o-Prins" },
            { "timezone.excity.Atlantic/South_Georgia", "Saút Jọ́jia" },
            { "timezone.excity.America/Argentina/Salta", "Sálta" },
            { "timezone.excity.America/Indiana/Marengo", "Marẹ́ngo, Indiána" },
            { "timezone.excity.America/Indiana/Winamac", "Wínámak, Indiána" },
            { "timezone.excity.America/Argentina/Tucuman", "Túkúman" },
            { "timezone.excity.America/Argentina/Ushuaia", "Usuáya" },
            { "timezone.excity.America/Indiana/Tell_City", "Tẹ́l Síti, Indiána" },
            { "timezone.excity.America/Indiana/Vincennes", "Vínsẹn, Indiána" },
            { "timezone.excity.Antarctica/DumontDUrville", "Diúmọ́n-d’Uvil" },
            { "timezone.excity.America/Argentina/La_Rioja", "La Riókha" },
            { "timezone.excity.America/Argentina/San_Juan", "Sán Hwán" },
            { "timezone.excity.America/Argentina/San_Luis", "Sán Luis" },
            { "timezone.excity.America/Indiana/Petersburg", "Pításbọg, Indiána" },
            { "timezone.excity.America/Kentucky/Monticello", "Mọntẹchẹ́lo, Kẹ́ntọ́ki" },
            { "timezone.excity.America/North_Dakota/Beulah", "Biúla, Nọ́t Dakóta" },
            { "timezone.excity.America/North_Dakota/Center", "Sẹ́nta, Nọ́t Dakóta" },
            { "timezone.excity.America/Argentina/Rio_Gallegos", "Rió Galẹ́gọs" },
            { "timezone.excity.America/North_Dakota/New_Salem", "Niú Sélẹm, Nọ́t Dakóta" },
        };
        return data;
    }
}
