/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.extensions.fileutils;

import com.xmlcalabash.core.XProcConstants;
import com.xmlcalabash.core.XProcException;
import com.xmlcalabash.core.XProcRuntime;
import com.xmlcalabash.io.WritablePipe;
import com.xmlcalabash.library.DefaultStep;
import com.xmlcalabash.model.RuntimeValue;
import com.xmlcalabash.runtime.XAtomicStep;
import com.xmlcalabash.util.TreeWriter;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;

public class Tempfile
extends DefaultStep {
    private static final QName _href = new QName("href");
    private static final QName _prefix = new QName("prefix");
    private static final QName _suffix = new QName("suffix");
    private static final QName _delete_on_exit = new QName("delete-on-exit");
    private WritablePipe result = null;

    public Tempfile(XProcRuntime xProcRuntime, XAtomicStep xAtomicStep) {
        super(xProcRuntime, xAtomicStep);
    }

    @Override
    public void setOutput(String string, WritablePipe writablePipe) {
        this.result = writablePipe;
    }

    @Override
    public void reset() {
        this.result.resetWriter();
    }

    @Override
    public void run() throws SaxonApiException {
        File file;
        super.run();
        if (this.runtime.getSafeMode()) {
            throw XProcException.dynamicError(21);
        }
        String string = "temp";
        String string2 = ".xml";
        boolean bl = false;
        RuntimeValue runtimeValue = this.getOption(_prefix);
        if (runtimeValue != null) {
            string = runtimeValue.getString();
        }
        if ((runtimeValue = this.getOption(_suffix)) != null) {
            string2 = runtimeValue.getString();
        }
        bl = this.getOption(_delete_on_exit, false);
        RuntimeValue runtimeValue2 = this.getOption(_href);
        URI uRI = runtimeValue2.getBaseURI().resolve(runtimeValue2.getString());
        if (!"file".equals(uRI.getScheme())) {
            throw new XProcException(this.step.getNode(), "Only file: scheme URIs are supported by the tempfile step.");
        }
        File file2 = new File(uRI.getPath());
        if (!file2.isDirectory()) {
            throw new XProcException(this.step.getNode(), "The href on tempfile must point to an existing directory.");
        }
        TreeWriter treeWriter = new TreeWriter(this.runtime);
        treeWriter.startDocument(this.step.getNode().getBaseURI());
        treeWriter.addStartElement(XProcConstants.c_result);
        treeWriter.startContent();
        try {
            file = File.createTempFile(string, string2, file2);
        }
        catch (IOException iOException) {
            throw new XProcException(this.step.getNode(), "Failed to create temporary file in " + file2.toURI().toASCIIString());
        }
        if (bl) {
            file.deleteOnExit();
        }
        treeWriter.addText(file.toURI().toASCIIString());
        treeWriter.addEndElement();
        treeWriter.endDocument();
        this.result.write(treeWriter.getResult());
    }
}

