# Copyright 1999-2023 Gentoo Authors
# Distributed under the terms of the GNU General Public License v2

EAPI=8

# ebuild generated by hackport 0.5.9999

CABAL_FEATURES="lib profile haddock hoogle hscolour test-suite"
inherit haskell-cabal

MY_PN="pureMD5"
MY_P="${MY_PN}-${PV}"

DESCRIPTION="A Haskell-only implementation of the MD5 digest (hash) algorithm"
HOMEPAGE="https://hackage.haskell.org/package/pureMD5"
SRC_URI="https://hackage.haskell.org/package/${MY_P}/${MY_P}.tar.gz"

LICENSE="BSD"
SLOT="0/${PV}"
KEYWORDS="~amd64 ~arm64 ~ppc64 ~riscv ~x86"
IUSE="test"
RESTRICT="!test? ( test )"

RDEPEND=">=dev-haskell/binary-0.4.0:=[profile?]
	>=dev-haskell/cereal-0.2:=[profile?]
	dev-haskell/crypto-api:=[profile?]
	dev-haskell/tagged:=[profile?]
	>=dev-lang/ghc-7.4.1:=
"
DEPEND="${RDEPEND}
	>=dev-haskell/cabal-1.10
	test? ( dev-haskell/crypto-api-tests
		dev-haskell/pretty-hex
		dev-haskell/quickcheck
		>=dev-haskell/test-framework-0.8
		dev-haskell/test-framework-quickcheck2 )
"

S="${WORKDIR}/${MY_P}"

src_configure() {
	haskell-cabal_src_configure \
		$(cabal_flag test test)
}
