import { applicationConfig, Meta, StoryObj } from '@storybook/angular'
import { TextFileViewerComponent } from './text-file-viewer.component'
import { toastDecorator } from '../utils-stories'
import { MessageService } from 'primeng/api'

export default {
    title: 'App/TextFileViewer',
    component: TextFileViewerComponent,
    decorators: [
        applicationConfig({
            providers: [MessageService],
        }),
        toastDecorator,
    ],
} as Meta

type Story = StoryObj<TextFileViewerComponent>

export const ViewFileContent: Story = {
    args: {
        contents: [
            'key \"rndc-key\" {',
            '\talgorithm \"hmac-sha256\";',
            '\tsecret \"/UlJY3N2FdJ5cWUT6jQt/OPEnT9ap4b45Pzo1724yYw=\";',
            '};',
            '',
            'key \"trusted-key\" {',
            '\talgorithm \"hmac-sha256\";',
            '\tsecret \"VO6xA4Tc1PWYaqMuPaf6wfkITb+c9/mkzlEaWJavejU=\";',
            '};',
            '',
            'key \"guest-key\" {',
            '\talgorithm \"hmac-sha256\";',
            '\tsecret \"6L8DwXFboA7FDQJQP051hjFV/n9B3IR/SwDLX7y5czE=\";',
            '};',
            '',
            'acl \"trusted\" {',
            '\t! key \"guest-key\";',
            '\tkey \"trusted-key\";',
            '\t\"localhost\";\n};',
            '',
            'acl \"guest\" {',
            '\t! key \"trusted-key\";',
            '\tkey \"guest-key\";',
            '\t\"localhost\";',
            '};',
            '',
            'controls {',
            '\tinet \"127.0.0.1\" allow {',
            '\t\t\"localhost\";',
            '\t} keys {',
            '\t\t\"rndc-key\";',
            '\t};',
            '};',
            '',
            'statistics-channels {',
            '\tinet \"127.0.0.1\" port 8053 allow {',
            '\t\t\"127.0.0.1\";',
            '\t};',
            '',
            '};',
            '',
            'options {',
            '\tallow-query {',
            '\t\tany;',
            '\t};',
            '\tallow-transfer {',
            '\t\t\"any\";',
            '\t};',
            '\tdnssec-validation no;',
            '\trecursion yes;',
            '};',
            '',
            'view \"trusted\" {',
            '\tmatch-clients {',
            '\t\t\"trusted\";',
            '\t};',
            '\tresponse-policy {',
            '\t\tzone \"drop.rpz.example.com\";',
            '\t};',
            '\tzone \"bind9.example.com\" {',
            '\t\ttype master;',
            '\t\tzone-statistics full;',
            '\t\tfile \"/etc/bind/db.bind9.example.com\";',
            '\t};',
            '\tzone \"pdns.example.com\" {',
            '\t\ttype forward;',
            '\t\tforwarders {',
            '\t\t\t172.24.0.55;',
            '\t\t};',
            '\t\tforward only;',
            '\t};',
            '\tzone \"drop.rpz.example.com\" {',
            '\t\ttype primary;',
            '\t\tallow-transfer {',
            '\t\t\tkey \"trusted-key\";',
            '\t\t};',
            '\t\tallow-query {',
            '\t\t\tlocalhost;',
            '\t\t};',
            '\t\tfile \"/etc/bind/db.rpz.example.com\";',
            '\t};',
            '};',
            '',
            'view \"guest\" {',
            '\tmatch-clients {',
            '\t\t\"guest\";',
            '\t};',
            '\tzone \"bind9.example.org\" {',
            '\t\ttype master;',
            '\t\tzone-statistics full;',
            '\t\tfile \"/etc/bind/db.bind9.example.org\";',
            '\t};',
            '};',
            '',
            '//@stork:no-parse:global',
            '',
            'logging {',
            '\tchannel transfers {',
            '\t\tfile \"/var/log/bind/transfers\" versions 3 size 10M;',
            '\t\tprint-time yes;',
            '\t\tseverity info;',
            '\t};',
            '\tchannel notify {',
            '\t\tfile \"/var/log/bind/notify\" versions 3 size 10M;',
            '\t\tprint-time yes;',
            '\t\tseverity info;',
            '\t};',
            '\tchannel dnssec {',
            '\t\tfile \"/var/log/bind/dnssec\" versions 3 size 10M;',
            '\t\tprint-time yes;',
            '\t\tseverity info;',
            '\t};',
            '\tchannel query {',
            '\t\tfile \"/var/log/bind/query\" versions 5 size 10M;',
            '\t\tprint-time yes;',
            '\t\tseverity info;',
            '\t};',
            '\tchannel general {',
            '\t\tfile \"/var/log/bind/general\" versions 3 size 10M;',
            '\t\tprint-time yes;',
            '\t\tseverity info;',
            '\t};',
            '\tchannel slog {',
            '\t\tsyslog security;',
            '\t\tseverity info;',
            '\t};',
            '\tchannel rpzlog {',
            '\t\tfile \"/var/log/bind/rpz\" versions 3 size 10M;',
            '\t\tprint-time yes;',
            '\t\tseverity info;',
            '\t};',
            '\tcategory xfer-out { transfers; slog; };',
            '\tcategory xfer-in { transfers; slog; };',
            '\tcategory notify { notify; };',
            '\tcategory lame-servers { general; };',
            '\tcategory config { general; };',
            '\tcategory default { general; };',
            '\tcategory security { general; slog; };',
            '\tcategory dnssec { dnssec; };',
            '\tcategory rpz { rpzlog; };',
            '\t// category queries { query; };',
            '};',
        ],
    },
}

export const EmptyFile: Story = {
    args: {
        contents: [],
    },
}
