/* SWISSEPH

   ATTENTION: this source file is not to be compiled separately,
   as it is #included by swemplan
 */

/* Copyright (C) 1997 - 2021 Astrodienst AG, Switzerland.  All rights reserved.
  
  License conditions
  ------------------

  This file is part of Swiss Ephemeris.

  Swiss Ephemeris is distributed with NO WARRANTY OF ANY KIND.  No author
  or distributor accepts any responsibility for the consequences of using it,
  or for whether it serves any particular purpose or works at all, unless he
  or she says so in writing.  

  Swiss Ephemeris is made available by its authors under a dual licensing
  system. The software developer, who uses any part of Swiss Ephemeris
  in his or her software, must choose between one of the two license models,
  which are
  a) GNU Affero General Public License (AGPL)
  b) Swiss Ephemeris Professional License

  The choice must be made before the software developer distributes software
  containing parts of Swiss Ephemeris to others, and before any public
  service using the developed software is activated.

  If the developer choses the AGPL software license, he or she must fulfill
  the conditions of that license, which includes the obligation to place his
  or her whole software project under the AGPL or a compatible license.
  See https://www.gnu.org/licenses/agpl-3.0.html

  If the developer choses the Swiss Ephemeris Professional license,
  he must follow the instructions as found in http://www.astro.com/swisseph/ 
  and purchase the Swiss Ephemeris Professional Edition from Astrodienst
  and sign the corresponding license contract.

  The License grants you the right to use, copy, modify and redistribute
  Swiss Ephemeris, but only under certain conditions described in the License.
  Among other things, the License requires that the copyright notices and
  this notice be preserved on all copies.

  Authors of the Swiss Ephemeris: Dieter Koch and Alois Treindl

  The authors of Swiss Ephemeris have no control or influence over any of
  the derived works, i.e. over software or services created by other
  programmers which use Swiss Ephemeris functions.

  The names of the authors or of the copyright holder (Astrodienst) must not
  be used for promoting any software, product or service which uses or contains
  the Swiss Ephemeris. This copyright notice is the ONLY place where the
  names of the authors can legally appear, except in cases where they have
  given special permission in writing.

  The trademarks 'Swiss Ephemeris' and 'Swiss Ephemeris inside' may be used
  for promoting such software, products or services.
*/


/*
First date in file = 1228000.50
Number of records = 397276.0
Days per record = 4.0
      Julian Years      Lon    Lat    Rad
 -1349.9 to  -1000.0:   0.42   0.18   0.16 
 -1000.0 to   -500.0:   0.37   0.19   0.13 
  -500.0 to      0.0:   0.35   0.17   0.12 
     0.0 to    500.0:   0.34   0.15   0.10 
   500.0 to   1000.0:   0.28   0.14   0.09 
  1000.0 to   1500.0:   0.34   0.14   0.09 
  1500.0 to   2000.0:   0.35   0.13   0.09 
  2000.0 to   2500.0:   0.38   0.12   0.12 
  2500.0 to   3000.0:   0.42   0.13   0.16 
  3000.0 to   3000.8:  0.252  0.087  0.115 
*/
static double mertabl[] = {
          35.85255,        -163.26379, 53810162857.56026,      908082.18475,

           0.05214,          -0.07712,

           1.07258,           0.04008,           0.49259,           0.00230,
           0.02324,           0.05869,

           0.24516,           0.22898,          -0.06037,           0.13023,

           0.00331,          -0.03576,

           0.06464,           0.00089,

           0.03103,           0.05078,

          -0.01133,           0.01520,

           0.14654,           0.07538,           0.25112,          -0.24473,
          -0.17928,          -0.53366,

          -0.06367,           0.20458,          -0.42985,           0.14848,
          -0.35317,          -0.61364,

           0.00325,          -0.08617,          -0.23180,           0.08576,
           0.22995,           0.43569,

           1.92114,           2.89319,          -5.55637,           4.70329,
          -4.91411,          -5.45521,

           0.02607,           0.04468,

          -0.05439,           0.13476,          -0.07329,          -0.00985,

          -0.00278,           0.05377,

           0.07474,          -0.09658,           0.29818,           0.20422,
          -0.29074,           0.44962,

          -0.15411,          -0.04287,           0.29907,          -1.02948,
           3.62183,           0.84869,

          -0.08157,           0.02754,

          -0.03610,          -0.12909,           0.09195,          -0.04424,

          -0.08845,           0.09347,

          -0.27140,           0.08185,

           0.24783,           0.19543,          -0.25154,           0.41371,

          -0.00046,           0.01524,

           0.04127,           0.06663,

           0.43023,           0.11790,

           0.04427,           0.05329,

           0.00411,          -0.71074,

          -0.07111,          -0.09824,

           0.01264,          -0.02075,

          -0.00068,          -0.01678,

           0.01186,           0.00181,

           0.00302,          -0.21963,

          -0.06412,          -0.10155,          -0.36856,           0.20240,
           0.32282,           0.65133,

          -0.07178,          -0.01876,           0.13399,          -0.39522,
           1.28413,           0.33790,

           0.05040,          -0.01679,

          -0.00794,           0.01117,

           0.02630,           0.00575,

          -0.07113,          -0.11414,           0.16422,          -0.23060,
           0.35198,           0.05409,

           1.11486,          -0.35833,           0.87313,           1.66304,
          -1.28434,           0.72067,

           0.01400,           0.00971,

           0.21044,          -0.87385,           3.20820,           0.67957,

          -0.01716,           0.00111,

          -0.13776,          -0.02650,

          -0.06778,           0.00908,           0.00616,          -0.04520,

          -0.31625,          -0.61913,

           0.36184,           0.09373,

           0.00984,          -0.03292,

           0.01944,           0.00530,

           0.00243,          -0.00123,

           0.01589,           0.02223,

          -0.02992,          -0.01086,

        4356.04809,       -5859.86328,        2918.27323,       -4796.67315,
         510.24783,       -1220.02233,         127.48927,         250.10654,
        3250.43013,        -904.27614,       -5667.40042,      -22634.00922,
      -82471.79425,       18615.92342,

           0.01941,           0.00372,

           0.01830,          -0.00652,

          -0.02548,          -0.01157,

           0.00635,           0.02343,

          -0.00980,           0.00961,

           0.12137,           0.10068,           0.16676,          -0.07257,

          -0.07267,          -0.13761,           0.25305,          -0.28112,

          -0.07974,           0.07866,

          -0.41726,           0.49991,          -1.55187,          -1.14150,
           1.54754,          -2.35141,

          -0.00862,           0.00808,

           0.00218,          -0.03726,

           0.06914,          -0.08986,

          -0.00501,           2.09577,

          -0.01409,          -0.01842,

           0.04138,           0.05961,

          -0.12276,          -0.04929,

          -0.03963,          -0.06080,

          -0.27697,          -0.09329,

          -0.01011,           0.00295,

          -0.01374,           0.01328,

          -0.00171,           0.25815,

           0.01446,           0.00782,

           0.17909,          -0.04683,

           0.03765,          -0.04990,

           0.00036,           0.00528,

           0.05508,          -0.01369,

          -0.11751,          -0.10624,          -0.14448,           0.10522,

          -0.00884,           0.43006,

           0.01162,           0.01659,

          -0.00076,           0.10143,

           0.55779,           0.05510,           0.12350,          -0.34025,

           0.01320,           0.92985,

          -0.00026,          -0.03426,

           0.01305,           0.00041,

           0.13187,          -0.11903,

           0.00058,           0.09877,

         -33.10230,         -41.96782,        -268.28908,         174.29259,
         731.20089,        1508.07639,        5223.99114,       -3008.08849,
       -3909.34957,       -9646.69156,

           0.02988,           0.03182,

           0.07149,           0.04513,

          -0.02356,          -0.01641,

          -0.03188,          -0.03711,           0.15084,          -0.22436,
           0.61987,           0.25706,

           0.02425,           0.01200,

          -0.05543,          -0.14435,          -0.53398,           0.10997,

           0.00465,          -0.01893,

           0.01260,          -0.01314,

           0.00650,          -0.05499,

          -0.06804,           0.01608,

           0.02134,           0.04160,

           0.00636,           0.01293,

          -0.03470,          -0.02697,

          -0.11323,           0.02409,

          -0.02618,           0.00827,

           0.01879,           0.16838,           0.08978,           0.01934,

          -0.23564,           0.05565,

           0.03686,           0.02644,

          -0.02471,           0.00558,

        -140.22669,        -120.40692,        -501.88143,         434.05868,
        1044.54998,        1162.72084,        1527.78437,        -882.37371,

          -0.00768,           0.02213,

          -0.04090,           0.16718,

          -0.05923,          -0.12595,

           0.01154,          -0.00025,

          -0.00776,          -0.01653,

          -0.01213,          -0.02773,

           0.00344,           0.02180,

          -0.02558,          -0.05682,

          -0.00490,           0.01050,

          38.75496,         -78.17502,        -189.90700,        -136.33371,
        -249.94062,         319.76423,         205.73478,         272.64549,

          -0.01132,          -0.01071,          -0.04607,          -0.00390,

           0.02903,          -0.02070,

           0.01326,          -0.00901,

          35.38435,           7.45358,          31.08987,         -70.52685,
         -92.13879,         -51.58876,         -51.80016,          48.98102,

          -0.00124,          -0.01159,

           0.47335,          13.71886,          23.71637,           5.55804,
          10.06850,         -25.65292,         -11.85300,         -10.20802,

          -4.72861,           1.27151,          -0.47322,           7.46754,
           6.99528,           1.79089,           2.05336,          -2.90866,

          -1.97528,           0.72236,          -0.25084,           1.90269,
           0.72127,           0.41354,

          -0.30286,          -0.53125,          -0.50883,          -0.01200,
          -0.08301,           0.18083,

          -0.04286,          -0.10963,          -0.04544,          -0.01645,

          -0.00013,          -0.00986,

};
static double mertabb[] = {
          68.33369,         422.77623,       -2057.26405,       -2522.29068,

          -0.00030,          -0.00009,

           0.02400,          -0.06471,           0.02074,          -0.00904,
           0.00044,           0.00261,

          -0.00174,          -0.00088,          -0.00027,           0.00003,

           0.00005,          -0.00004,

          -0.00036,           0.00200,

           0.01432,           0.01199,

           0.00006,          -0.00004,

           0.00236,           0.00803,           0.01235,           0.00406,
          -0.03253,           0.00179,

          -0.00243,           0.00132,          -0.00352,           0.00011,
          -0.00146,          -0.01154,

           0.00824,          -0.01195,          -0.01829,          -0.00465,
           0.12540,           0.09997,

           0.00400,           0.00288,          -0.02848,           0.01094,
          -0.02273,          -0.07051,

           0.01305,           0.01078,

          -0.00119,           0.00136,          -0.00107,          -0.00066,

           0.00097,          -0.00315,

           0.00120,           0.00430,          -0.00710,          -0.00157,
           0.06052,          -0.04777,

           0.00192,          -0.00229,          -0.02077,           0.00647,
           0.06907,           0.07644,

          -0.00717,           0.00451,

           0.00052,          -0.00262,           0.00345,           0.00039,

          -0.00674,           0.00346,

          -0.02880,           0.00807,

           0.00054,           0.00206,          -0.01745,           0.00517,

          -0.00044,           0.00049,

           0.01749,           0.01230,

           0.01703,           0.01563,

           0.00934,           0.02372,

           0.01610,          -0.01136,

           0.00186,          -0.00503,

           0.00082,          -0.00673,

           0.00170,          -0.00539,

           0.00042,           0.00037,

           0.00415,          -0.00430,

           0.00258,          -0.00914,          -0.01761,          -0.00251,
           0.15909,           0.13276,

           0.02436,          -0.00791,           0.00491,           0.03890,
          -0.02982,           0.05645,

          -0.00003,           0.00427,

          -0.00363,           0.00221,

           0.00077,           0.00130,

           0.00131,          -0.00071,           0.00796,           0.00453,
           0.01186,           0.01631,

           0.12949,          -0.02546,           0.03613,           0.32854,
          -0.43001,           0.01417,

           0.00034,           0.00095,

          -0.03268,           0.04034,           0.11407,           0.15049,

          -0.00079,          -0.00052,

          -0.04009,           0.00988,

          -0.00259,          -0.00085,           0.00221,          -0.00133,

           0.00003,          -0.01733,

           0.01055,           0.01976,

           0.00222,           0.00085,

           0.00089,           0.00087,

           0.00014,           0.00001,

           0.00145,           0.00802,

           0.00122,           0.00068,

         947.79367,       -1654.39690,         542.00864,       -1281.09901,
          90.02068,        -318.36115,         -87.67090,          92.91960,
         376.98232,        -419.10705,        5094.60412,        2476.97098,
      -18160.57888,       16010.48165,

           0.00621,          -0.00128,

           0.00186,          -0.00153,

          -0.00790,           0.00011,

          -0.00032,           0.00165,

          -0.00277,           0.00539,

           0.00552,           0.00682,           0.01086,          -0.00978,

          -0.02292,          -0.01300,           0.02940,          -0.04427,

          -0.02051,           0.04860,

          -0.05020,           0.29089,          -0.50763,          -0.04900,
           0.11177,          -0.41357,

          -0.00222,           0.00504,

          -0.00006,          -0.00459,

          -0.00175,          -0.02691,

           0.05921,           0.18938,

          -0.00181,          -0.00154,

           0.00322,           0.00586,

          -0.01098,          -0.00520,

          -0.00861,          -0.01342,

          -0.02694,          -0.00706,

          -0.00103,           0.00012,

          -0.00284,           0.00797,

           0.00743,           0.02523,

           0.00872,           0.00096,

           0.03155,          -0.01644,

           0.00414,          -0.00583,

           0.00029,           0.00066,

           0.00935,          -0.00619,

          -0.02498,          -0.01600,          -0.03545,           0.07623,

           0.01649,           0.06498,

           0.00148,           0.00209,

           0.00621,           0.02014,

           0.17407,          -0.05022,          -0.03485,          -0.17012,

           0.06164,           0.20059,

          -0.00804,          -0.01475,

           0.00296,          -0.00068,

           0.01880,          -0.03797,

           0.00608,           0.02270,

           5.89651,          -6.62562,         -37.41057,         -10.51542,
         -47.22373,          95.76862,         494.45951,          -5.37252,
       -3991.04809,       -2886.97750,

           0.01232,           0.00487,

           0.03163,           0.00561,

          -0.01847,          -0.00207,

          -0.10138,           0.01430,          -0.04269,          -0.22338,
           0.24955,          -0.02066,

           0.01119,          -0.00186,

           0.03416,           0.01805,          -0.12498,           0.10385,

          -0.00210,          -0.01011,

           0.00346,          -0.00682,

          -0.00683,          -0.02227,

          -0.01649,           0.01259,

           0.01392,           0.01174,

           0.00440,           0.00351,

          -0.02871,          -0.00375,

          -0.03170,           0.02246,

          -0.00833,           0.00596,

           0.04081,           0.06666,           0.05400,          -0.02387,

          -0.07852,           0.05781,

           0.01881,           0.00324,

          -0.00868,           0.00606,

          -6.52157,         -19.74446,         -72.46009,          43.12366,
         321.78233,         215.45201,         452.61804,       -1025.05619,

           0.00119,           0.01169,

           0.02239,           0.09003,

          -0.05329,          -0.03974,

           0.00688,          -0.00421,

          -0.00676,          -0.00515,

          -0.01171,          -0.00952,

           0.01337,           0.01270,

          -0.02791,          -0.02184,

           0.00058,           0.00679,

           8.42102,         -11.87757,         -49.07247,         -25.34584,
         -43.54829,         161.26509,         261.70993,          56.25777,

           0.00568,           0.00871,          -0.02656,           0.01582,

           0.00875,          -0.02114,

           0.00464,          -0.01075,

           9.08966,           1.37810,           3.44548,         -27.44651,
         -59.62749,          -0.73611,          -0.77613,          65.72607,

          -0.00664,          -0.00723,

           1.04214,           4.78920,          11.67397,          -1.84524,
          -4.16685,         -19.14211,         -16.14483,           3.02496,

          -1.98140,           1.16261,           1.81526,           4.21224,
           5.59020,          -2.55741,          -1.54151,          -3.85817,

          -1.08723,           1.23372,           1.12378,           1.51554,
           0.88937,          -0.57631,

          -0.50549,          -0.25617,          -0.37618,           0.42163,
           0.18902,           0.19575,

          -0.15402,          -0.04062,          -0.04017,           0.05717,

          -0.01665,          -0.00199,

};
static double mertabr[] = {
          -8.30490,         -11.68232,          86.54880,        4361.05018,

           0.00002,          -0.00001,

          -0.01102,           0.00410,           0.00007,          -0.00276,
           0.00117,           0.00082,

           0.00049,           0.00007,           0.00003,          -0.00001,

           0.00012,           0.00005,

          -0.00186,          -0.00534,

          -0.03301,           0.01808,

           0.00008,           0.00005,

          -0.00394,           0.00202,           0.02362,          -0.00359,
           0.00638,          -0.06767,

           0.00422,          -0.00493,           0.00660,           0.00513,
          -0.00417,           0.00708,

           0.05849,          -0.00213,          -0.07647,          -0.16162,
          -0.30551,           0.13856,

          -0.02789,           0.01811,          -0.04155,          -0.06229,
           0.05729,          -0.03694,

          -0.03087,           0.01610,

          -0.00297,          -0.00167,           0.00041,          -0.00157,

          -0.00115,           0.00058,

           0.00796,           0.00436,          -0.01393,           0.02921,
          -0.05902,          -0.02363,

           0.00459,          -0.01512,           0.10038,           0.02964,
          -0.08369,           0.34570,

          -0.00749,          -0.02653,

           0.01361,          -0.00326,           0.00406,           0.00952,

          -0.00594,          -0.00829,

          -0.02763,          -0.09933,

          -0.04143,           0.05152,          -0.08436,          -0.05294,

          -0.00329,          -0.00016,

          -0.04340,           0.02566,

          -0.03027,           0.10904,

           0.03665,          -0.03070,

           0.23525,           0.00182,

           0.03092,          -0.02212,

           0.01255,           0.00777,

          -0.01025,           0.00042,

          -0.00065,           0.00440,

           0.08688,           0.00136,

           0.05700,          -0.03616,          -0.11272,          -0.20838,
          -0.37048,           0.18314,

           0.00717,          -0.02911,           0.15848,           0.05266,
          -0.13451,           0.51639,

           0.00688,           0.02029,

           0.00596,           0.00423,

          -0.00253,           0.01196,

           0.05264,          -0.03301,           0.10669,           0.07558,
          -0.02461,           0.16282,

          -0.18481,          -0.57118,           0.85303,          -0.44876,
           0.37090,           0.65915,

          -0.00458,           0.00660,

           0.41186,           0.09829,          -0.31999,           1.51149,

          -0.00052,          -0.00809,

           0.01384,          -0.07114,

          -0.00435,          -0.03237,           0.02162,           0.00294,

           0.29742,          -0.15430,

          -0.04508,           0.17436,

           0.01577,           0.00485,

          -0.00258,           0.00946,

           0.00061,           0.00119,

           0.01095,          -0.00788,

           0.00530,          -0.01478,

        2885.06380,        2152.76256,        2361.91098,        1442.28586,
         602.45147,         251.18991,        -121.68155,          71.20167,
         404.94753,        1607.37580,       11211.04090,       -2905.37340,
       -9066.27933,      -40747.62807,

          -0.00189,           0.00957,

           0.00332,           0.00907,

           0.00574,          -0.01255,

          -0.01134,           0.00291,

          -0.00666,          -0.00615,

          -0.04947,           0.06182,           0.03965,           0.08091,

           0.06846,          -0.03612,           0.13966,           0.12543,

          -0.05494,          -0.05043,

          -0.24454,          -0.20507,           0.56201,          -0.75997,
           1.15728,           0.76203,

          -0.00559,          -0.00536,

           0.01872,           0.00104,

           0.03044,           0.02504,

          -1.07241,          -0.00288,

           0.00950,          -0.00760,

          -0.03211,           0.02261,

           0.02678,          -0.06868,

           0.03008,          -0.02062,

           0.04997,          -0.15164,

          -0.00176,          -0.00580,

          -0.00730,          -0.00676,

          -0.13906,          -0.00089,

          -0.00362,           0.00817,

           0.02021,           0.07719,

           0.02788,           0.02061,

          -0.00274,           0.00016,

           0.00566,           0.02293,

           0.04691,          -0.05005,          -0.05095,          -0.06225,

          -0.19770,          -0.00456,

          -0.00848,           0.00595,

          -0.04506,          -0.00172,

          -0.01960,           0.22971,           0.14459,           0.04362,

          -0.40199,           0.00386,

           0.01442,          -0.00088,

          -0.00020,           0.00544,

           0.04768,           0.05222,

          -0.04069,          -0.00003,

          15.71084,         -12.28846,         -66.23443,        -109.83758,
        -586.31996,         311.09606,        1070.75040,        2094.34080,
        3839.04103,       -1797.34193,

          -0.01216,           0.01244,

          -0.01666,           0.02627,

           0.00687,          -0.01291,

           0.00939,          -0.01905,           0.09401,           0.05027,
          -0.09398,           0.23942,

          -0.00379,           0.00834,

           0.05632,          -0.01907,          -0.04654,          -0.21243,

           0.00255,           0.00179,

           0.00540,           0.00497,

           0.01427,           0.00243,

          -0.00697,          -0.02792,

          -0.01524,           0.00810,

          -0.00461,           0.00238,

           0.00899,          -0.01515,

          -0.01011,          -0.04390,

          -0.00447,          -0.00992,

          -0.06110,           0.00975,          -0.00261,           0.03415,

          -0.02336,          -0.08776,

          -0.00883,           0.01346,

          -0.00229,          -0.00895,

          42.18049,         -48.21316,        -148.61588,        -171.57236,
        -414.27195,         343.09118,         394.59044,         511.79914,

          -0.00911,          -0.00220,

          -0.06315,          -0.00988,

           0.04357,          -0.02389,

           0.00004,           0.00232,

           0.00581,          -0.00317,

           0.00948,          -0.00497,

          -0.00734,           0.00300,

           0.01883,          -0.01055,

          -0.00365,          -0.00126,

          24.18074,          12.28004,          43.18187,         -58.69806,
        -102.40566,         -79.48349,         -74.81060,          89.71332,

           0.00241,          -0.00135,          -0.00136,          -0.01617,

           0.00818,           0.00873,

           0.00368,           0.00383,

          -2.25893,          10.18542,          20.73104,           9.07389,
          13.73458,         -29.10491,         -20.62071,         -10.63404,

           0.00382,          -0.00143,

          -3.77385,           0.12725,          -1.30842,           6.75795,
           7.94463,           1.79092,           1.24458,          -4.73211,

          -0.36978,          -1.25710,          -2.06373,           0.06194,
          -0.00509,           2.08851,           1.07491,           0.04112,

          -0.28582,          -0.51413,          -0.53312,           0.11936,
           0.04447,           0.23945,

           0.12450,          -0.11821,          -0.06100,          -0.12924,
          -0.05193,           0.02219,

           0.01977,          -0.02933,          -0.00771,          -0.01077,

           0.00109,          -0.00273,

};

static signed char merargs[] = {
  0,  3,
  3,  1,  1,-10,  3, 11,  4,  0,
  2,  2,  5, -5,  6,  2,
  3,  5,  1,-14,  2,  2,  3,  1,
  3,  1,  1, -5,  2,  4,  3,  0,
  1,  1,  6,  0,
  1,  2,  6,  0,
  3,  2,  1, -7,  2,  3,  3,  0,
  1,  1,  5,  2,
  2,  1,  1, -4,  3,  2,
  1,  2,  5,  2,
  2,  2,  1, -5,  2,  2,
  1,  3,  5,  0,
  2,  4,  1,-10,  2,  1,
  2,  3,  1, -8,  2,  0,
  2,  1,  1, -3,  2,  2,
  2,  1,  1, -2,  2,  2,
  1,  1,  3,  0,
  2,  3,  1, -7,  2,  1,
  2,  1,  1, -3,  3,  0,
  1,  1,  2,  0,
  2,  2,  1, -4,  2,  1,
  2,  4,  1, -9,  2,  0,
  1,  2,  3,  0,
  2,  1,  1, -2,  3,  0,
  2,  1,  1, -4,  2,  0,
  2,  1,  1, -1,  2,  0,
  2,  3,  1, -6,  2,  0,
  1,  3,  3,  0,
  2,  2,  1, -7,  2,  0,
  2,  1,  1, -2,  4,  0,
  2,  1,  1, -1,  3,  0,
  1,  2,  2,  2,
  2,  2,  1, -3,  2,  2,
  2,  4,  1, -8,  2,  0,
  2,  3,  1,-10,  2,  0,
  2,  1,  1, -4,  5,  0,
  2,  1,  1, -3,  5,  2,
  2,  1,  1, -5,  2,  2,
  2,  1,  1, -5,  6,  0,
  2,  1,  1, -2,  5,  1,
  3,  1,  1, -4,  5,  5,  6,  0,
  1,  4,  3,  0,
  2,  1,  1, -3,  6,  1,
  2,  1,  1, -1,  5,  0,
  2,  1,  1, -2,  6,  0,
  2,  1,  1, -1,  6,  0,
  2,  1,  1, -2,  7,  0,
  2,  1,  1, -1,  7,  0,
  3,  4,  1,-14,  2,  2,  3,  0,
  3,  1,  1,  2,  5, -5,  6,  0,
  1,  1,  1,  6,
  3,  2,  1,-10,  3, 11,  4,  0,
  3,  1,  1, -2,  5,  5,  6,  0,
  3,  6,  1,-14,  2,  2,  3,  0,
  2,  1,  1,  1,  6,  0,
  2,  1,  1,  2,  6,  0,
  2,  1,  1,  1,  5,  1,
  2,  2,  1, -4,  3,  1,
  2,  1,  1,  2,  5,  0,
  2,  3,  1, -5,  2,  2,
  2,  1,  1,  3,  5,  0,
  2,  5,  1,-10,  2,  0,
  1,  3,  2,  0,
  2,  2,  1, -2,  2,  0,
  2,  1,  1,  1,  3,  0,
  2,  4,  1, -7,  2,  0,
  2,  2,  1, -3,  3,  0,
  2,  1,  1,  1,  2,  0,
  2,  3,  1, -4,  2,  0,
  2,  5,  1, -9,  2,  0,
  2,  1,  1,  2,  3,  0,
  2,  2,  1, -2,  3,  0,
  1,  4,  2,  0,
  2,  2,  1, -1,  2,  0,
  2,  4,  1, -6,  2,  0,
  2,  2,  1, -2,  4,  0,
  2,  2,  1, -1,  3,  0,
  2,  1,  1,  2,  2,  1,
  2,  3,  1, -3,  2,  0,
  2,  5,  1, -8,  2,  0,
  2,  2,  1, -3,  5,  0,
  1,  5,  2,  1,
  2,  2,  1, -2,  5,  0,
  2,  1,  1,  4,  3,  0,
  2,  2,  1, -3,  6,  0,
  2,  2,  1, -1,  5,  0,
  2,  2,  1, -2,  6,  0,
  1,  2,  1,  4,
  2,  2,  1,  1,  5,  0,
  2,  3,  1, -4,  3,  0,
  2,  2,  1,  2,  5,  0,
  2,  4,  1, -5,  2,  2,
  2,  1,  1,  3,  2,  0,
  2,  3,  1, -2,  2,  1,
  2,  3,  1, -3,  3,  0,
  2,  2,  1,  1,  2,  0,
  2,  4,  1, -4,  2,  0,
  2,  3,  1, -2,  3,  0,
  2,  3,  1, -1,  2,  0,
  2,  3,  1, -1,  3,  0,
  2,  2,  1,  2,  2,  0,
  2,  4,  1, -3,  2,  0,
  2,  3,  1, -3,  5,  0,
  2,  1,  1,  5,  2,  1,
  2,  3,  1, -2,  5,  0,
  2,  3,  1, -1,  5,  0,
  2,  3,  1, -2,  6,  0,
  1,  3,  1,  3,
  2,  4,  1, -4,  3,  0,
  2,  5,  1, -5,  2,  0,
  2,  4,  1, -2,  2,  0,
  2,  5,  1, -4,  2,  0,
  2,  4,  1, -2,  3,  0,
  2,  5,  1, -3,  2,  0,
  2,  2,  1,  5,  2,  0,
  2,  4,  1, -2,  5,  0,
  2,  4,  1, -1,  5,  0,
  1,  4,  1,  3,
  2,  6,  1, -5,  2,  1,
  2,  5,  1, -2,  2,  0,
  2,  5,  1, -2,  5,  0,
  1,  5,  1,  3,
  2,  7,  1, -5,  2,  0,
  1,  6,  1,  3,
  1,  7,  1,  3,
  1,  8,  1,  2,
  1,  9,  1,  2,
  1, 10,  1,  1,
  1, 11,  1,  0,
 -1
};
/* Total terms = 130, small = 128 */
static struct plantbl mer404 = {
  { 11, 14, 10, 11,  4,  5,  2,  0,  0,},
 6,
 merargs,
 mertabl,
 mertabb,
 mertabr,
 3.8709830979999998e-01,
};



/*
First date in file = 1228000.50
Number of records = 397276.0
Days per record = 4.0
      Julian Years      Lon    Lat    Rad
 -1349.9 to  -1000.0:   0.23   0.15   0.10 
 -1000.0 to   -500.0:   0.25   0.15   0.10 
  -500.0 to      0.0:   0.20   0.13   0.09 
     0.0 to    500.0:   0.16   0.11   0.08 
   500.0 to   1000.0:   0.19   0.09   0.08 
  1000.0 to   1500.0:   0.16   0.09   0.08 
  1500.0 to   2000.0:   0.21   0.12   0.08 
  2000.0 to   2500.0:   0.28   0.14   0.09 
  2500.0 to   3000.0:   0.30   0.15   0.10 
  3000.0 to   3000.8:  0.116  0.062  0.058 
*/
static double ventabl[] = {
           9.08078,          55.42416, 21066413644.98911,      655127.20186,

           0.00329,           0.10408,

           0.00268,          -0.01908,

           0.00653,           0.00183,

           0.15083,          -0.21997,

           6.08596,           2.34841,           3.70668,          -0.22740,
          -2.29376,          -1.46741,

          -0.03840,           0.01242,

           0.00176,           0.00913,

           0.00121,          -0.01222,

          -1.22624,           0.65264,          -1.15974,          -1.28172,
           1.00656,          -0.66266,

           0.01560,          -0.00654,           0.00896,           0.00069,

           0.21649,          -0.01786,

           0.01239,           0.00255,

           0.00084,          -0.06086,

          -0.00041,           0.00887,

           0.13453,          -0.20013,           0.08234,           0.01575,

           0.00658,          -0.00214,

           0.00254,           0.00857,

          -0.01047,          -0.00519,

           0.63215,          -0.40914,           0.34271,          -1.53258,

           0.00038,          -0.01437,

          -0.02599,          -2.27805,          -0.36873,          -1.01799,
          -0.36798,           1.41356,

          -0.08167,           0.01368,           0.20676,           0.06807,

           0.02282,          -0.04691,

           0.30308,          -0.20218,           0.24785,           0.27522,

           0.00197,          -0.00499,

           1.43909,          -0.46154,           0.93459,           2.99583,
          -3.43274,           0.05672,

          -0.06586,           0.12467,           0.02505,          -0.08433,

           0.00743,           0.00174,

          -0.04013,           0.17715,

          -0.00603,          -0.01024,

           0.01542,          -0.02378,

           0.00676,           0.00002,

          -0.00168,          -4.89487,

           0.02393,          -0.03064,

           0.00090,           0.00977,

           0.01223,           0.00381,

           0.28135,          -0.09158,           0.18550,           0.58372,
          -0.67437,           0.01409,

          -0.25404,          -0.06863,

           0.06763,          -0.02939,

          -0.00009,          -0.04888,

           0.01718,          -0.00978,

          -0.01945,           0.08847,

          -0.00135,         -11.29920,

           0.01689,          -0.04756,

           0.02075,          -0.01667,

           0.01397,           0.00443,

          -0.28437,           0.07600,           0.17996,          -0.44326,

           0.29356,           1.41869,          -1.58617,           0.03206,

           0.00229,          -0.00753,

          -0.03076,          -2.96766,

           0.00245,           0.00697,

           0.01063,          -0.02468,

          -0.00351,          -0.18179,

          -0.01088,           0.00380,

           0.00496,           0.02072,

          -0.12890,           0.16719,          -0.06820,          -0.03234,

         -60.36135,         -11.74485,         -11.03752,          -3.80145,
         -21.33955,        -284.54495,        -763.43839,         248.50823,
        1493.02775,        1288.79621,       -2091.10921,       -1851.15420,

          -0.00922,           0.06233,

           0.00004,           0.00785,

           0.10363,          -0.16770,           0.45497,           0.24051,
          -0.28057,           0.61126,

          -0.02057,           0.00010,

           0.00561,           0.01994,

           0.01416,          -0.00442,

           0.03073,          -0.14961,

          -0.06272,           0.08301,

           0.02040,           7.12824,

          -0.00453,          -0.01815,

           0.00004,          -0.00013,

          -0.03593,          -0.18147,           0.20353,          -0.00683,

           0.00003,           0.06226,

          -0.00443,           0.00257,

           0.03194,           0.03254,

           0.00282,          -0.01401,

           0.00422,           1.03169,

          -0.00169,          -0.00591,

          -0.00307,           0.00540,

           0.05511,           0.00347,

           0.07896,           0.06583,

           0.00783,           0.01926,

           0.03109,           0.15967,

           0.00343,           0.88734,

           0.01047,           0.32054,

           0.00814,           0.00051,

           0.02474,           0.00047,

           0.00052,           0.03763,

         -57.06618,          20.34614,         -45.06541,        -115.20465,
         136.46887,         -84.67046,          92.93308,         160.44644,

          -0.00020,          -0.00082,

           0.02496,           0.00279,

           0.00849,           0.00195,

          -0.05013,          -0.04331,

          -0.00136,           0.14491,

          -0.00183,          -0.00406,

           0.01163,           0.00093,

          -0.00604,          -0.00680,

          -0.00036,           0.06861,

          -0.00450,          -0.00969,

           0.00171,           0.00979,

          -0.00152,           0.03929,

           0.00631,           0.00048,

          -0.00709,          -0.00864,

           1.51002,          -0.24657,           1.27338,           2.64699,
          -2.40990,          -0.57413,

          -0.00023,           0.03528,

           0.00268,           0.00522,

          -0.00010,           0.01933,

          -0.00006,           0.01100,

           0.06313,          -0.09939,           0.08571,           0.03206,

          -0.00004,           0.00645,

};
static double ventabb[] = {
         -23.91858,          31.44154,          25.93273,         -67.68643,

          -0.00171,           0.00123,

           0.00001,          -0.00018,

          -0.00005,           0.00018,

          -0.00001,           0.00019,

           0.00733,           0.00030,          -0.00038,           0.00011,
           0.00181,           0.00120,

           0.00010,           0.00002,

          -0.00012,           0.00002,

           0.00021,           0.00004,

          -0.00403,           0.00101,           0.00342,          -0.00328,
           0.01564,           0.01212,

           0.00011,           0.00010,          -0.00002,          -0.00004,

          -0.00524,           0.00079,

           0.00011,           0.00002,

          -0.00001,           0.00003,

           0.00001,           0.00000,

           0.00108,           0.00035,           0.00003,           0.00064,

          -0.00000,          -0.00002,

          -0.00069,           0.00031,

           0.00020,           0.00003,

           0.00768,           0.03697,          -0.07906,           0.01673,

          -0.00003,          -0.00001,

          -0.00198,          -0.01045,           0.01761,          -0.00803,
          -0.00751,           0.04199,

           0.00280,          -0.00213,          -0.00482,          -0.00209,

          -0.01077,           0.00715,

           0.00048,          -0.00004,           0.00199,           0.00237,

           0.00017,          -0.00032,

          -0.07513,          -0.00658,          -0.04213,           0.16065,
           0.27661,           0.06515,

           0.02156,          -0.08144,          -0.23994,          -0.05674,

           0.00167,           0.00069,

           0.00244,          -0.01247,

          -0.00100,           0.00036,

           0.00240,           0.00012,

           0.00010,           0.00018,

           0.00208,          -0.00098,

          -0.00217,           0.00707,

          -0.00338,           0.01260,

          -0.00127,          -0.00039,

          -0.03516,          -0.00544,          -0.01746,           0.08258,
           0.10633,           0.02523,

           0.00077,          -0.00214,

          -0.02335,           0.00976,

          -0.00019,           0.00003,

           0.00041,           0.00039,

           0.00199,          -0.01098,

           0.00813,          -0.00853,

           0.02230,           0.00349,

          -0.02250,           0.08119,

          -0.00214,          -0.00052,

          -0.00220,           0.15216,           0.17152,           0.08051,

          -0.01561,           0.27727,           0.25837,           0.07021,

          -0.00005,          -0.00000,

          -0.02692,          -0.00047,

          -0.00007,          -0.00016,

           0.01072,           0.01418,

          -0.00076,           0.00379,

          -0.00807,           0.03463,

          -0.05199,           0.06680,

          -0.00622,           0.00787,           0.00672,           0.00453,

         -10.69951,         -67.43445,        -183.55956,         -37.87932,
        -102.30497,        -780.40465,        2572.21990,        -446.97798,
        1665.42632,        5698.61327,      -11889.66501,        2814.93799,

           0.03204,          -0.09479,

           0.00014,          -0.00001,

          -0.04118,          -0.04562,           0.03435,          -0.05878,
           0.01700,           0.02566,

          -0.00121,           0.00170,

           0.02390,           0.00403,

           0.04629,           0.01896,

          -0.00521,           0.03215,

          -0.01051,           0.00696,

          -0.01332,          -0.08937,

          -0.00469,          -0.00751,

           0.00016,          -0.00035,

           0.00492,          -0.03930,          -0.04742,          -0.01013,

           0.00065,           0.00021,

          -0.00006,           0.00017,

           0.06768,          -0.01558,

          -0.00055,           0.00322,

          -0.00287,          -0.01656,

           0.00061,          -0.00041,

           0.00030,           0.00047,

          -0.01436,          -0.00148,

           0.30302,          -0.05511,

          -0.00020,          -0.00005,

           0.00042,          -0.00025,

           0.01270,           0.00458,

          -0.00593,          -0.04480,

           0.00005,          -0.00008,

           0.08457,          -0.01569,

           0.00062,           0.00018,

           9.79942,          -2.48836,           4.17423,           6.72044,
         -63.33456,          34.63597,          39.11878,         -72.89581,

          -0.00066,           0.00036,

          -0.00045,          -0.00062,

          -0.00287,          -0.00118,

          -0.21879,           0.03947,

           0.00086,           0.00671,

          -0.00113,           0.00122,

          -0.00193,          -0.00029,

          -0.03612,           0.00635,

           0.00024,           0.00207,

          -0.00273,           0.00443,

          -0.00055,           0.00030,

          -0.00451,           0.00175,

          -0.00110,          -0.00015,

          -0.02608,           0.00480,

           2.16555,          -0.70419,           1.74648,           0.97514,
          -1.15360,           1.73688,

           0.00004,           0.00105,

           0.00187,          -0.00311,

           0.00005,           0.00055,

           0.00004,           0.00032,

          -0.04629,           0.02292,          -0.00363,          -0.03807,

           0.00002,           0.00020,

};
static double ventabr[] = {
          -0.24459,           3.72698,          -6.67281,           5.24378,

           0.00030,           0.00003,

          -0.00002,          -0.00000,

          -0.00000,           0.00001,

           0.00032,           0.00021,

          -0.00326,           0.01002,           0.00067,           0.00653,
           0.00243,          -0.00417,

          -0.00004,          -0.00010,

          -0.00002,          -0.00001,

           0.00004,          -0.00002,

          -0.00638,          -0.01453,           0.01458,          -0.01235,
           0.00755,           0.01030,

           0.00006,           0.00014,           0.00000,           0.00009,

           0.00063,           0.00176,

           0.00003,          -0.00022,

           0.00112,           0.00001,

          -0.00014,          -0.00001,

           0.00485,           0.00322,          -0.00035,           0.00198,

           0.00004,           0.00013,

          -0.00015,          -0.00003,

           0.00011,          -0.00025,

           0.00634,           0.02207,           0.04620,           0.00160,

           0.00045,           0.00001,

          -0.11563,           0.00643,          -0.05947,           0.02018,
           0.07704,           0.01574,

          -0.00090,          -0.00471,          -0.00322,           0.01104,

           0.00265,          -0.00038,

           0.01395,           0.02165,          -0.01948,           0.01713,

          -0.00057,          -0.00019,

           0.04889,           0.13403,          -0.28327,           0.10597,
          -0.02325,          -0.35829,

           0.01171,          -0.00904,           0.00747,           0.02546,

           0.00029,          -0.00190,

          -0.03408,          -0.00703,

           0.00176,          -0.00109,

           0.00463,           0.00293,

           0.00000,           0.00148,

           1.06691,          -0.00054,

          -0.00935,          -0.00790,

           0.00552,          -0.00084,

          -0.00100,           0.00336,

           0.02874,           0.08604,          -0.17876,           0.05973,
          -0.00720,          -0.21195,

           0.02134,          -0.07980,

           0.01500,           0.01398,

           0.01758,          -0.00004,

           0.00371,           0.00650,

          -0.03375,          -0.00723,

           4.65465,          -0.00040,

           0.02040,           0.00707,

          -0.00727,          -0.01144,

          -0.00196,           0.00620,

          -0.03396,          -0.12904,           0.20160,           0.08092,

          -0.67045,           0.14014,          -0.01571,          -0.75141,

           0.00361,           0.00110,

           1.42165,          -0.01499,

          -0.00334,           0.00117,

           0.01187,           0.00507,

           0.08935,          -0.00174,

          -0.00211,          -0.00525,

           0.01035,          -0.00252,

          -0.08355,          -0.06442,           0.01616,          -0.03409,

           5.55241,         -30.62428,           2.03824,          -6.26978,
         143.07279,         -10.24734,        -125.25411,        -380.85360,
        -644.78411,         745.02852,         926.70000,       -1045.09820,

          -0.03124,          -0.00465,

          -0.00396,           0.00002,

           0.08518,           0.05248,          -0.12178,           0.23023,
          -0.30943,          -0.14208,

          -0.00005,          -0.01054,

          -0.00894,           0.00233,

          -0.00173,          -0.00768,

           0.07881,           0.01633,

          -0.04463,          -0.03347,

          -3.92991,           0.00945,

           0.01524,          -0.00422,

          -0.00011,          -0.00005,

           0.10842,          -0.02126,           0.00349,           0.12097,

          -0.03752,           0.00001,

          -0.00156,          -0.00270,

          -0.01520,           0.01349,

           0.00895,           0.00186,

          -0.67751,           0.00180,

           0.00516,          -0.00151,

          -0.00365,          -0.00210,

          -0.00276,           0.03793,

          -0.02637,           0.03235,

          -0.01343,           0.00541,

          -0.11270,           0.02169,

          -0.63365,           0.00122,

          -0.24329,           0.00428,

          -0.00040,           0.00586,

           0.00581,           0.01112,

          -0.02731,           0.00008,

          -2.69091,           0.42729,           2.78805,           3.43849,
          -0.87998,          -6.62373,           0.56882,           4.69370,

           0.00005,          -0.00008,

          -0.00181,           0.01767,

          -0.00168,           0.00660,

           0.01802,          -0.01836,

          -0.11245,          -0.00061,

           0.00199,          -0.00070,

          -0.00076,           0.00919,

           0.00311,          -0.00165,

          -0.05650,          -0.00018,

           0.00121,          -0.00069,

          -0.00803,           0.00146,

          -0.03260,          -0.00072,

          -0.00042,           0.00524,

           0.00464,          -0.00339,

          -0.06203,          -0.00278,           0.04145,           0.02871,
          -0.01962,          -0.01362,

          -0.03040,          -0.00010,

           0.00085,          -0.00001,

          -0.01712,          -0.00006,

          -0.00996,          -0.00003,

          -0.00029,           0.00026,           0.00016,          -0.00005,

          -0.00594,          -0.00003,

};

static signed char venargs[] = {
  0,  3,
  2,  2,  5, -5,  6,  0,
  3,  2,  2,  1,  3, -8,  4,  0,
  3,  5,  1,-14,  2,  2,  3,  0,
  3,  3,  2, -7,  3,  4,  4,  0,
  2,  8,  2,-13,  3,  2,
  3,  6,  2,-10,  3,  3,  5,  0,
  1,  1,  7,  0,
  2,  1,  5, -2,  6,  0,
  2,  1,  2, -3,  4,  2,
  2,  2,  5, -4,  6,  1,
  1,  1,  6,  0,
  3,  3,  2, -5,  3,  1,  5,  0,
  3,  3,  2, -5,  3,  2,  5,  0,
  2,  1,  5, -1,  6,  0,
  2,  2,  2, -6,  4,  1,
  2,  2,  5, -3,  6,  0,
  1,  2,  6,  0,
  2,  3,  5, -5,  6,  0,
  1,  1,  5,  1,
  2,  2,  5, -2,  6,  0,
  2,  3,  2, -5,  3,  2,
  2,  5,  2, -8,  3,  1,
  1,  2,  5,  0,
  2,  2,  1, -5,  2,  1,
  2,  6,  2,-10,  3,  0,
  2,  2,  2, -3,  3,  2,
  2,  1,  2, -2,  3,  1,
  2,  4,  2, -7,  3,  0,
  2,  4,  2, -6,  3,  0,
  1,  1,  4,  0,
  2,  1,  2, -2,  4,  0,
  2,  2,  2, -5,  4,  0,
  2,  1,  2, -1,  3,  0,
  2,  1,  1, -3,  2,  0,
  2,  2,  2, -4,  3,  0,
  2,  6,  2, -9,  3,  0,
  2,  3,  2, -4,  3,  2,
  2,  1,  1, -2,  2,  0,
  1,  1,  3,  0,
  2,  1,  2, -1,  4,  0,
  2,  2,  2, -4,  4,  0,
  2,  5,  2, -7,  3,  0,
  2,  2,  2, -2,  3,  0,
  2,  1,  2, -3,  5,  0,
  2,  1,  2, -3,  3,  0,
  2,  7,  2,-10,  3,  0,
  2,  1,  2, -2,  5,  1,
  2,  4,  2, -5,  3,  1,
  3,  1,  2,  1,  5, -5,  6,  0,
  2,  1,  2, -1,  5,  0,
  3,  1,  2, -3,  5,  5,  6,  0,
  2,  1,  2, -2,  6,  0,
  2,  1,  2, -1,  6,  0,
  1,  3,  4,  0,
  2,  7,  2,-13,  3,  0,
  3,  1,  2,  2,  5, -5,  6,  1,
  1,  1,  2,  5,
  2,  9,  2,-13,  3,  0,
  3,  1,  2,  1,  5, -2,  6,  0,
  2,  2,  2, -3,  4,  2,
  2,  3,  2, -6,  4,  0,
  2,  1,  2,  1,  5,  0,
  2,  2,  2, -5,  3,  0,
  2,  6,  2, -8,  3,  0,
  2,  2,  1, -4,  2,  0,
  2,  3,  2, -3,  3,  0,
  1,  2,  3,  0,
  2,  3,  2, -7,  3,  0,
  2,  5,  2, -6,  3,  1,
  2,  2,  2, -2,  4,  0,
  2,  3,  2, -5,  4,  0,
  2,  2,  2, -1,  3,  0,
  2,  7,  2, -9,  3,  0,
  2,  4,  2, -4,  3,  0,
  2,  1,  2,  1,  3,  0,
  2,  3,  2, -4,  4,  0,
  2,  6,  2, -7,  3,  0,
  2,  3,  2, -2,  3,  0,
  2,  2,  2, -4,  5,  0,
  2,  2,  2, -3,  5,  0,
  2,  2,  2, -2,  5,  0,
  2,  5,  2, -5,  3,  0,
  2,  2,  2, -3,  6,  0,
  2,  2,  2, -1,  5,  0,
  2,  2,  2, -2,  6,  0,
  1,  2,  2,  3,
  2,  2,  2,  1,  5,  0,
  2,  7,  2, -8,  3,  0,
  2,  2,  1, -3,  2,  0,
  2,  4,  2, -3,  3,  0,
  2,  6,  2, -6,  3,  0,
  2,  3,  2, -1,  3,  0,
  2,  8,  2, -9,  3,  0,
  2,  5,  2, -4,  3,  0,
  2,  7,  2, -7,  3,  0,
  2,  4,  2, -2,  3,  0,
  2,  3,  2, -4,  5,  0,
  2,  3,  2, -3,  5,  0,
  2,  9,  2,-10,  3,  0,
  2,  3,  2, -2,  5,  0,
  1,  3,  2,  2,
  2,  8,  2, -8,  3,  0,
  2,  5,  2, -3,  3,  0,
  2,  9,  2, -9,  3,  0,
  2, 10,  2,-10,  3,  0,
  1,  4,  2,  1,
  2, 11,  2,-11,  3,  0,
 -1
};
/* Total terms = 108, small = 107 */
static struct plantbl ven404 = {
  {  5, 14, 13,  8,  4,  5,  1,  0,  0,},
 5,
 venargs,
 ventabl,
 ventabb,
 ventabr,
 7.2332982000000001e-01,
};

/*
First date in file = 1228000.50
Number of records = 264850.0
Days per record = 6.0
      Julian Years      Lon    Lat    Rad
 -1349.9 to  -1000.0:   0.13   0.06   0.07 
 -1000.0 to   -500.0:   0.12   0.06   0.06 
  -500.0 to      0.0:   0.12   0.06   0.08 
     0.0 to    500.0:   0.12   0.05   0.06 
   500.0 to   1000.0:   0.12   0.05   0.07 
  1000.0 to   1500.0:   0.11   0.05   0.07 
  1500.0 to   2000.0:   0.11   0.05   0.06 
  2000.0 to   2500.0:   0.11   0.05   0.06 
  2500.0 to   3000.0:   0.14   0.06   0.07 
  3000.0 to   3000.8:  0.074  0.048  0.044 
*/

static double eartabl[] = {
         -65.54655,        -232.74963, 12959774227.57587,      361678.59587,

           2.52679,          -4.93511,           2.46852,          -8.88928,
           6.66257,          -1.94502,

           0.66887,          -0.06141,           0.08893,           0.18971,

           0.00068,          -0.00307,

           0.03092,           0.03214,          -0.14321,           0.22548,

           0.00314,          -0.00221,

           8.98017,           7.25747,          -1.06655,           1.19671,
          -2.42276,           0.29621,           1.55635,           0.99167,

          -0.00026,           0.00187,

           0.00189,           0.02742,

           0.00158,           0.01475,

           0.00353,          -0.02048,

          -0.01775,          -0.01023,           0.01927,          -0.03122,

          -1.55440,          -4.97423,           2.14765,          -2.77045,
           1.02707,           0.55507,          -0.08066,           0.18479,

           0.00750,           0.00583,

          -0.16977,           0.35555,           0.32036,           0.01309,

           0.54625,           0.08167,           0.10681,           0.17231,
          -0.02287,           0.01631,

          -0.00866,          -0.00190,

           0.00016,          -0.01514,

          -0.00073,           0.04205,

          -0.00072,           0.01490,

          -0.38831,           0.41043,          -1.11857,          -0.84329,
           1.15123,          -1.34167,

           0.01026,          -0.00432,

          -0.02833,          -0.00705,          -0.00285,           0.01645,

          -0.01234,           0.05609,          -0.01893,          -0.00171,

          -0.30527,           0.45390,           0.56713,           0.70030,
           1.27125,          -0.76481,           0.34857,          -2.60318,

          -0.00160,           0.00643,

           0.28492,          -0.37998,           0.23347,           0.00540,
           0.00342,           0.04406,

           0.00037,          -0.02449,

           0.01469,           1.59358,           0.24956,           0.71066,
           0.25477,          -0.98371,

          -0.69412,           0.19687,          -0.44423,          -0.83331,
           0.49647,          -0.31021,

           0.05696,          -0.00802,          -0.14423,          -0.04719,

           0.16762,          -0.01234,           0.02481,           0.03465,

           0.01091,           0.02123,

           0.08212,          -0.07375,           0.01524,          -0.07388,

           0.06673,          -0.22486,           0.10026,          -0.00559,

           0.14711,          -0.11680,           0.05460,           0.02749,

          -1.04467,           0.34273,          -0.67582,          -2.15117,
           2.47372,          -0.04332,

           0.05016,          -0.03991,           0.01908,           0.00943,

           0.07321,          -0.23637,           0.10564,          -0.00446,

          -0.09523,          -0.30710,           0.17400,          -0.10681,

           0.05104,          -0.14078,           0.01390,           0.07288,

          -0.26308,          -0.20717,           0.20773,          -0.37096,

          -0.00205,          -0.27274,

          -0.00792,          -0.00183,

           0.02985,           0.04895,           0.03785,          -0.14731,

           0.02976,          -0.02495,          -0.02644,          -0.04085,

          -0.00843,           0.00027,

           0.00090,           0.00611,

           0.00040,           4.83425,

           0.01692,          -0.01335,

           0.04482,          -0.03602,           0.01672,           0.00838,

           0.03682,          -0.11206,           0.05163,          -0.00219,

          -0.08381,          -0.20911,           0.16400,          -0.13325,

          -0.05945,           0.02114,          -0.00710,          -0.04695,

          -0.01657,          -0.00513,

          -0.06999,          -0.23054,           0.13128,          -0.07975,

           0.00054,          -0.00699,

          -0.01253,          -0.04007,           0.00658,          -0.00607,

          -0.48696,           0.31859,          -0.84292,          -0.87950,
           1.30507,          -0.94042,

          -0.00234,           0.00339,

          -0.30647,          -0.24605,           0.24948,          -0.43369,

          -0.64033,           0.20754,          -0.43829,          -1.31801,
           1.55412,          -0.02893,

          -0.02323,           0.02181,          -0.00398,          -0.01548,

          -0.08005,          -0.01537,          -0.00362,          -0.02033,

           0.00028,          -0.03732,          -0.14083,          -7.21175,

          -0.07430,           0.01886,          -0.00223,           0.01915,

          -0.02270,          -0.03702,           0.10167,          -0.02917,

           0.00879,          -2.04198,

          -0.00433,          -0.41764,

           0.00671,          -0.00030,

           0.00070,          -0.01066,

           0.01144,          -0.03190,

          -0.29653,           0.38638,          -0.16611,          -0.07661,

           0.22071,           0.14665,           0.02487,           0.13524,

        -275.60942,        -335.52251,        -413.89009,         359.65390,
        1396.49813,        1118.56095,        2559.41622,       -3393.39088,
       -6717.66079,       -1543.17403,

          -1.90405,          -0.22958,          -0.57989,          -0.36584,
          -0.04547,          -0.14164,

           0.00749,          -0.03973,

           0.00033,           0.01842,

          -0.08301,          -0.03523,          -0.00408,          -0.02008,

           0.00008,           0.00778,

          -0.00046,           0.02760,

          -0.03135,           0.07710,           0.06130,           0.04003,

          -0.04703,           0.00671,          -0.00754,          -0.01000,

          -0.01902,          -0.00125,

          -0.00264,          -0.00903,

          -0.02672,           0.12765,

          -0.03872,           0.03532,          -0.01534,          -0.00710,

          -0.01087,           0.01124,

          -0.01664,           0.06304,          -0.02779,           0.00214,

          -0.01279,          -5.51814,

           0.05847,          -0.02093,           0.03950,           0.06696,
          -0.04064,           0.02687,

           0.01478,          -0.02169,           0.05821,           0.03301,
          -0.03861,           0.07535,

           0.00290,          -0.00644,

           0.00631,           0.12905,

           0.02400,           0.13194,          -0.14339,           0.00529,

           0.00343,           0.00819,

           0.02692,          -0.03332,          -0.07284,          -0.02064,

           0.07038,           0.03999,           0.02759,           0.07599,

           0.00033,           0.00641,

           0.00128,           0.02032,          -0.00852,           0.00680,

           0.23019,           0.17100,           0.09861,           0.55013,

          -0.00192,           0.00953,

          -0.00943,           0.01783,

           0.05975,           0.01486,           0.00160,           0.01558,

          -0.01629,          -0.02035,           0.01533,           2.73176,

           0.05858,          -0.01327,           0.00209,          -0.01506,

           0.00755,           0.03300,

          -0.00796,          -0.65270,

           0.02305,           0.00165,

          -0.02512,           0.06560,           0.16108,          -0.02087,

           0.00016,           0.10729,

           0.04175,           0.00559,

           0.01176,           0.00110,

          15.15730,          -0.52460,         -37.16535,         -25.85564,
         -60.94577,           4.29961,          57.11617,          67.96463,
          31.41414,         -64.75731,

           0.00848,           0.02971,          -0.03690,          -0.00010,

          -0.03568,           0.06325,           0.11311,           0.02431,

          -0.00383,           0.00421,

          -0.00140,           0.00680,

           0.00069,          -0.21036,

           0.00386,           0.04210,

          -0.01324,           0.16454,

          -0.01398,          -0.00109,

           0.02548,          -0.03842,          -0.06504,          -0.02204,

           0.01359,           0.00232,

           0.07634,          -1.64648,          -1.73103,           0.89176,
           0.81398,           0.65209,

           0.00021,          -0.08441,

          -0.00012,           0.01262,

          -0.00666,          -0.00050,

          -0.00130,           0.01596,

          -0.00485,          -0.00213,

           0.00009,          -0.03941,

          -0.02266,          -0.04421,          -0.01341,           0.01083,

          -0.00011,           0.00004,           0.00003,          -0.02017,

           0.00003,          -0.01096,

           0.00002,          -0.00623,

};
static double eartabb[] = {
         -41.97860,         -48.43539,          74.72897,           0.00075,

          -0.12774,          -0.10188,          -0.00943,          -0.04574,
           0.00265,          -0.00217,

           0.00254,           0.00168,           0.00008,           0.00026,

          -0.00000,          -0.00000,

           0.00004,          -0.00003,           0.00001,          -0.00003,

          -0.00002,          -0.00006,

           0.03351,          -0.02699,           0.00896,          -0.01315,
          -0.00019,          -0.00054,          -0.00020,          -0.00003,

           0.00002,           0.00001,

          -0.00000,           0.00000,

          -0.00002,          -0.00001,

          -0.00001,           0.00003,

           0.00017,          -0.00008,           0.00000,          -0.00003,

           0.00501,          -0.00083,           0.00414,           0.00202,
           0.00051,           0.00060,           0.00002,           0.00000,

          -0.00002,           0.00002,

          -0.00016,          -0.00443,          -0.00083,          -0.00031,

          -0.00394,           0.00148,          -0.00035,           0.00099,
           0.00005,           0.00009,

           0.00004,          -0.00002,

          -0.00001,          -0.00002,

           0.00012,          -0.00005,

           0.00001,           0.00001,

          -0.00577,          -0.00631,          -0.00017,           0.01993,
          -0.00234,          -0.00218,

          -0.00001,           0.00002,

          -0.00101,          -0.00044,          -0.00036,           0.00041,

           0.00294,          -0.00109,           0.00043,          -0.00006,

           0.09650,           0.15003,           0.01087,           0.04905,
           0.00093,          -0.06986,          -0.01471,          -0.00221,

          -0.00002,          -0.00003,

           0.00440,          -0.00083,           0.00102,          -0.00024,
           0.00005,          -0.00002,

          -0.00004,           0.00001,

           0.00505,           0.00930,          -0.01609,          -0.00183,
          -0.00113,           0.00214,

           0.00439,          -0.00295,          -0.00280,           0.00402,
          -0.00047,          -0.00145,

          -0.00114,          -0.00178,           0.00097,           0.00022,

           0.00019,           0.00002,           0.00009,          -0.00005,

          -0.00002,           0.00006,

          -0.01618,          -0.01033,          -0.00372,           0.00301,

          -0.00199,           0.00003,           0.00012,          -0.00068,

          -0.00027,          -0.00011,           0.00009,          -0.00020,

          -0.00618,           0.00129,           0.00452,           0.00620,
          -0.06411,          -0.01524,

          -0.00207,          -0.00140,           0.00005,          -0.00036,

          -0.00009,           0.00005,           0.00012,          -0.00053,

           0.00050,          -0.00068,          -0.00059,          -0.00132,

           0.00719,          -0.13368,          -0.08789,          -0.02072,

           0.00031,          -0.00360,          -0.00241,          -0.00182,

           0.00284,           0.00196,

           0.00083,           0.00008,

           0.00203,          -0.00097,          -0.00120,           0.00748,

           0.00326,          -0.00145,          -0.00276,           0.00236,

          -0.00048,          -0.00258,

           0.00011,           0.00001,

          -0.00284,           0.00795,

          -0.00156,           0.00106,

          -0.00040,          -0.00069,           0.00026,          -0.00039,

          -0.00102,          -0.00098,           0.00017,          -0.00125,

          -0.00180,          -0.01103,          -0.01854,           0.00742,

          -0.02751,          -0.00773,          -0.00263,           0.01059,

           0.00152,           0.00047,

          -0.00106,          -0.00034,          -0.00126,          -0.00291,

          -0.00014,           0.00006,

           0.00069,           0.00316,          -0.00087,           0.00022,

           0.05381,           0.03791,           0.05011,          -0.15168,
          -0.16315,           0.03037,

           0.00068,          -0.00067,

          -0.00457,          -0.00146,          -0.00643,          -0.00451,

           0.07806,           0.00729,           0.03356,          -0.16465,
          -0.20388,          -0.04854,

          -0.00163,          -0.00178,           0.00185,           0.00405,

          -0.00009,           0.00068,          -0.00003,           0.00005,

          -0.01186,           0.00347,          -0.01776,           0.00258,

           0.00081,          -0.00014,           0.00003,          -0.00021,

          -0.01218,          -0.03048,          -0.03109,           0.01387,

          -0.00740,          -0.00113,

          -0.00155,           0.00679,

          -0.00053,          -0.00007,

          -0.00004,          -0.00002,

           0.00248,           0.00127,

          -0.00386,           0.00394,           0.01213,           0.00748,

          -0.04669,          -0.00319,           0.00315,           0.00010,

          85.02966,         -55.85765,         215.62111,         519.00334,
       -1941.10461,         508.68393,        -419.80123,       -4679.60117,
          -0.00916,           0.00204,

          -0.13900,          -0.08473,          -0.07614,          -0.03445,
           0.00359,          -0.00136,

          -0.00111,           0.01028,

           0.00021,          -0.00002,

           0.00039,           0.00246,          -0.00084,          -0.00007,

          -0.00191,           0.00491,

           0.00474,          -0.00676,

          -0.00549,           0.02234,           0.02087,           0.00575,

          -0.00011,           0.00079,          -0.00060,           0.00029,

          -0.00239,          -0.00257,

           0.00020,           0.00163,

           0.00301,          -0.01723,

           0.00049,           0.00086,          -0.00046,           0.00057,

          -0.00049,           0.00024,

           0.00103,          -0.00072,          -0.00005,           0.00095,

           0.00598,          -0.01127,

          -0.00538,           0.00317,          -0.00178,          -0.00010,
           0.00061,           0.00132,

          -0.00001,           0.00318,          -0.00206,           0.00113,
           0.00153,           0.00097,

           0.00161,          -0.00363,

           0.00142,          -0.00047,

          -0.00281,           0.03085,           0.02895,           0.00688,

           0.00025,          -0.00016,

          -0.00197,          -0.08112,           0.02859,          -0.00683,

           0.00004,           0.00016,           0.00158,          -0.00065,

           0.00004,          -0.00001,

           0.00002,          -0.00008,           0.00019,           0.00039,

          -0.00344,           0.00364,           0.00579,          -0.00144,

           0.00031,          -0.00190,

           0.00066,           0.00025,

           0.00011,          -0.00069,           0.00001,          -0.00011,

          -0.01202,           0.00842,           0.00067,          -0.00297,

          -0.00000,           0.00008,           0.00005,           0.00000,

           0.00086,          -0.00057,

           0.00354,          -0.00548,

           0.00009,          -0.00003,

           0.00179,           0.07922,           0.00490,           0.00065,

          -0.00005,          -0.00059,

           0.00061,          -0.00319,

           0.00007,          -0.00048,

           3.49661,          -1.52414,          -6.26431,          -1.76193,
         -26.45666,           7.62583,          77.77395,          10.67040,
           0.00032,           0.00090,

          -0.00026,           0.00680,           0.00827,           0.00199,

          -0.00271,           0.04278,           0.02257,          -0.00532,

           0.00006,           0.00011,

           0.00006,           0.00010,

          -0.00017,          -0.00081,

           0.00050,           0.00001,

           0.00012,           0.00082,

           0.00326,           0.00040,

          -0.00003,          -0.03209,           0.00042,           0.00008,

           0.01059,          -0.00218,

          -0.87557,          -1.06369,          -0.52928,           1.38498,
           0.00082,          -0.00040,

           0.00009,          -0.00047,

           0.00007,           0.00007,

           0.00155,           0.00019,

           0.00002,           0.00008,

           0.00001,           0.00023,

           0.00010,          -0.00029,

          -0.03336,          -0.00987,           0.00012,          -0.00006,

          -0.00198,           0.00333,          -0.00004,           0.00026,

           0.00042,           0.00006,

           0.00025,           0.00021,

};
static double eartabr[] = {
           0.64577,          -2.90183,         -14.50280,          28.85196,

           0.08672,          -0.05643,           0.02353,          -0.00404,
           0.00019,          -0.00137,

           0.00128,          -0.00310,           0.00143,           0.00050,

           0.00000,           0.00000,

          -0.00023,          -0.00003,          -0.00057,          -0.00032,

          -0.00002,           0.00009,

          -0.09716,           0.04111,          -0.03108,           0.00633,
          -0.00220,          -0.00595,          -0.00279,           0.00491,

          -0.00004,          -0.00003,

          -0.00010,          -0.00004,

          -0.00013,          -0.00010,

           0.00017,          -0.00010,

          -0.00075,           0.00002,          -0.00054,          -0.00025,

           0.12572,           0.00948,           0.05937,           0.04900,
          -0.00785,           0.01815,          -0.00303,          -0.00120,

          -0.00010,           0.00010,

          -0.00317,          -0.00143,           0.00068,           0.00213,

          -0.00043,          -0.00420,           0.00406,          -0.00041,
           0.00048,           0.00062,

          -0.00005,           0.00029,

           0.00043,          -0.00002,

          -0.00126,          -0.00009,

          -0.00040,           0.00000,

           0.03557,           0.02143,          -0.02196,           0.04671,
          -0.05571,          -0.03425,

           0.00016,           0.00031,

           0.00020,          -0.00153,          -0.00142,          -0.00051,

          -0.00214,           0.00001,           0.00002,          -0.00061,

          -0.06824,           0.00030,          -0.05717,           0.04196,
           0.05887,           0.07531,           0.12313,          -0.04113,

           0.00025,           0.00021,

           0.02218,           0.01747,           0.00011,           0.01367,
          -0.00247,           0.00029,

           0.00120,          -0.00003,

           0.13373,          -0.02072,           0.06706,          -0.01009,
          -0.09515,          -0.01901,

           0.01767,           0.06939,          -0.06702,           0.04159,
          -0.02809,          -0.03968,

           0.00257,           0.00553,           0.00411,          -0.01309,

           0.00139,           0.01591,          -0.00322,           0.00245,

          -0.00202,           0.00093,

           0.01845,          -0.00018,          -0.00247,          -0.00771,

          -0.02834,          -0.00691,          -0.00154,          -0.01244,

           0.01512,           0.01884,          -0.00359,           0.00731,

          -0.05395,          -0.18108,           0.36303,          -0.12751,
           0.01877,           0.43653,

          -0.00725,          -0.00692,           0.00115,          -0.00327,

           0.04030,           0.01171,           0.00107,           0.01793,

           0.06335,          -0.02171,           0.02229,           0.03533,

          -0.06038,          -0.00356,           0.01325,          -0.03798,

           0.04963,          -0.06258,           0.08931,           0.04904,

           0.07115,          -0.00073,

          -0.00104,           0.00354,

          -0.01549,           0.00647,           0.04418,           0.01061,

           0.00568,           0.00957,           0.01102,          -0.00819,

          -0.00089,           0.00368,

          -0.00214,           0.00031,

          -1.11935,          -0.00029,

           0.00457,           0.00550,

           0.01409,           0.01664,          -0.00306,           0.00629,

           0.04531,           0.01460,           0.00092,           0.02074,

           0.07900,          -0.03241,           0.05122,           0.06151,

           0.01319,           0.03075,          -0.02814,           0.00329,

           0.00208,          -0.00681,

           0.09887,          -0.02956,           0.03410,           0.05617,

           0.00295,           0.00022,

           0.01727,          -0.00666,           0.00255,           0.00256,

          -0.14161,          -0.20656,           0.36936,          -0.35793,
           0.40122,           0.54675,

          -0.00109,          -0.00135,

           0.11179,          -0.13803,           0.19591,           0.11327,

          -0.08785,          -0.29929,           0.60319,          -0.20484,
           0.01418,           0.71392,

          -0.01039,          -0.01041,           0.00694,          -0.00183,

           0.00707,          -0.03745,           0.00943,          -0.00174,

           0.01781,           0.00069,           3.35806,          -0.06731,

          -0.01015,          -0.03402,          -0.00913,          -0.00094,

           0.01682,          -0.01066,           0.01361,           0.04752,

           0.97349,           0.00504,

           0.20303,          -0.00206,

           0.00012,           0.00327,

           0.00504,           0.00040,

          -0.01599,          -0.00570,

          -0.19375,          -0.14714,           0.03820,          -0.08283,

          -0.07716,           0.10543,          -0.06772,           0.01131,

         163.23023,        -126.90743,        -183.43441,        -201.49515,
        -559.82622,         698.28238,        1696.58461,        1279.45831,
         771.51923,       -3358.57619,

          -0.05911,           0.89279,          -0.15861,           0.28577,
          -0.06958,           0.02406,

           0.01999,           0.00382,

          -0.00934,           0.00014,

           0.01792,          -0.04249,           0.01019,          -0.00210,

          -0.00386,           0.00009,

          -0.01353,           0.00101,

          -0.03828,          -0.01677,          -0.02026,           0.03079,

          -0.00285,          -0.02484,           0.00537,          -0.00397,

          -0.00064,           0.00906,

          -0.00411,           0.00100,

          -0.06940,          -0.01482,

          -0.01966,          -0.02171,           0.00388,          -0.00840,

          -0.00621,          -0.00597,

          -0.03690,          -0.00959,          -0.00115,          -0.01557,

           3.24906,          -0.00580,

           0.00745,           0.03347,          -0.04023,           0.02174,
          -0.01544,          -0.02389,

           0.00935,          -0.00141,          -0.02018,           0.03258,
          -0.04479,          -0.02360,

          -0.00542,          -0.00194,

          -0.07906,           0.00273,

          -0.08439,           0.01534,          -0.00264,          -0.09205,

          -0.00539,           0.00220,

           0.01263,           0.01593,           0.01103,          -0.03324,

          -0.02720,           0.04749,          -0.05099,           0.01807,

          -0.00443,           0.00024,

          -0.01386,           0.00029,          -0.00443,          -0.00591,

          -0.11899,           0.15817,          -0.37728,           0.06552,

          -0.00669,          -0.00140,

          -0.01168,          -0.00690,

          -0.01032,           0.04315,          -0.01082,           0.00123,

           0.01192,          -0.01071,          -1.90746,           0.00700,

           0.00779,           0.04261,           0.01052,           0.00173,

          -0.02138,           0.00307,

           0.50118,          -0.00330,

          -0.00111,           0.01624,

          -0.02601,           0.00305,           0.02348,           0.07058,

          -0.07622,           0.00006,

          -0.00183,           0.01636,

          -0.00037,           0.00564,

           4.72127,           3.53639,          13.37363,          -6.68745,
         -12.29946,         -22.51893,         -27.18616,          22.85033,
          25.89912,          12.56594,

          -0.02566,           0.00307,          -0.00064,          -0.02727,

          -0.02634,          -0.01101,          -0.01029,           0.04755,

          -0.00372,          -0.00292,

          -0.00582,          -0.00053,

           0.17840,           0.00027,

          -0.03400,           0.00357,

          -0.13428,          -0.00611,

           0.00099,          -0.01169,

           0.01909,           0.01338,           0.01302,          -0.03071,

          -0.00051,           0.00577,

           0.61945,          -0.32627,          -0.30811,          -0.60197,
          -0.22597,           0.28183,

           0.07739,           0.00011,

           0.01336,          -0.00010,

           0.00049,          -0.00592,

          -0.01407,          -0.00081,

           0.00146,          -0.00280,

           0.03795,           0.00003,

           0.01173,          -0.00655,          -0.00344,          -0.00403,

           0.00036,          -0.00047,           0.02000,           0.00001,

           0.01105,           0.00002,

           0.00620,          -0.00052,

};

static signed char earargs[] = {
  0,  3,
  3,  4,  3, -8,  4,  3,  5,  2,
  2,  2,  5, -5,  6,  1,
  3,  2,  2,  1,  3, -8,  4,  0,
  3,  3,  2, -7,  3,  4,  4,  1,
  3,  7,  3,-13,  4, -1,  5,  0,
  2,  8,  2,-13,  3,  3,
  3,  1,  2, -8,  3, 12,  4,  0,
  1,  1,  8,  0,
  1,  1,  7,  0,
  2,  1,  5, -2,  6,  0,
  3,  3,  3, -6,  4,  2,  5,  1,
  2,  8,  3,-15,  4,  3,
  2,  2,  5, -4,  6,  0,
  1,  1,  6,  1,
  2,  9,  3,-17,  4,  2,
  3,  3,  2, -5,  3,  1,  5,  0,
  3,  2,  3, -4,  4,  2,  5,  0,
  3,  3,  2, -5,  3,  2,  5,  0,
  2,  1,  5, -1,  6,  0,
  2,  1,  3, -2,  4,  2,
  2,  2,  5, -3,  6,  0,
  1,  2,  6,  1,
  2,  3,  5, -5,  6,  1,
  1,  1,  5,  3,
  2,  1,  5, -5,  6,  0,
  2,  7,  3,-13,  4,  2,
  2,  2,  5, -2,  6,  0,
  2,  3,  2, -5,  3,  2,
  2,  2,  3, -4,  4,  2,
  2,  5,  2, -8,  3,  1,
  2,  6,  3,-11,  4,  1,
  2,  1,  1, -4,  3,  0,
  1,  2,  5,  1,
  2,  3,  3, -6,  4,  1,
  2,  5,  3, -9,  4,  1,
  2,  2,  2, -3,  3,  2,
  2,  4,  3, -8,  4,  1,
  2,  4,  3, -7,  4,  1,
  2,  3,  3, -5,  4,  1,
  2,  1,  2, -2,  3,  1,
  2,  2,  3, -3,  4,  1,
  2,  1,  3, -1,  4,  0,
  2,  4,  2, -7,  3,  0,
  2,  4,  2, -6,  3,  1,
  1,  1,  4,  1,
  2,  1,  3, -3,  4,  0,
  2,  7,  3,-12,  4,  0,
  2,  1,  2, -1,  3,  0,
  2,  1,  3, -4,  5,  0,
  2,  6,  3,-10,  4,  1,
  2,  5,  3, -8,  4,  1,
  2,  1,  3, -3,  5,  1,
  2,  2,  2, -4,  3,  1,
  2,  6,  2, -9,  3,  0,
  2,  4,  3, -6,  4,  1,
  3,  1,  3, -3,  5,  2,  6,  0,
  2,  1,  3, -5,  6,  1,
  2,  1,  3, -2,  5,  2,
  3,  1,  3, -4,  5,  5,  6,  0,
  2,  3,  3, -4,  4,  1,
  2,  3,  2, -4,  3,  2,
  2,  1,  3, -3,  6,  1,
  3,  1,  3,  1,  5, -5,  6,  1,
  2,  1,  3, -1,  5,  1,
  3,  1,  3, -3,  5,  5,  6,  1,
  2,  1,  3, -2,  6,  1,
  2,  2,  3, -2,  4,  0,
  2,  1,  3, -1,  6,  0,
  2,  1,  3, -2,  7,  0,
  2,  1,  3, -1,  7,  0,
  2,  8,  2,-14,  3,  0,
  3,  1,  3,  2,  5, -5,  6,  1,
  3,  5,  3, -8,  4,  3,  5,  1,
  1,  1,  3,  4,
  3,  3,  3, -8,  4,  3,  5,  2,
  2,  8,  2,-12,  3,  0,
  3,  1,  3,  1,  5, -2,  6,  0,
  2,  9,  3,-15,  4,  1,
  2,  1,  3,  1,  6,  0,
  1,  2,  4,  0,
  2,  1,  3,  1,  5,  1,
  2,  8,  3,-13,  4,  1,
  2,  3,  2, -6,  3,  0,
  2,  1,  3, -4,  4,  0,
  2,  5,  2, -7,  3,  0,
  2,  7,  3,-11,  4,  1,
  2,  1,  1, -3,  3,  0,
  2,  6,  3, -9,  4,  1,
  2,  2,  2, -2,  3,  0,
  2,  5,  3, -7,  4,  2,
  2,  4,  3, -5,  4,  2,
  2,  1,  2, -3,  3,  0,
  2,  3,  3, -3,  4,  0,
  2,  4,  2, -5,  3,  1,
  2,  2,  3, -5,  5,  0,
  1,  1,  2,  1,
  2,  2,  3, -4,  5,  1,
  3,  2,  3, -4,  5,  2,  6,  0,
  2,  6,  3, -8,  4,  1,
  2,  2,  3, -3,  5,  1,
  2,  6,  2, -8,  3,  0,
  2,  5,  3, -6,  4,  0,
  2,  2,  3, -5,  6,  1,
  2,  2,  3, -2,  5,  1,
  3,  2,  3, -4,  5,  5,  6,  1,
  2,  4,  3, -4,  4,  0,
  2,  3,  2, -3,  3,  0,
  2,  2,  3, -3,  6,  0,
  2,  2,  3, -1,  5,  1,
  2,  2,  3, -2,  6,  0,
  2,  3,  3, -2,  4,  0,
  2,  2,  3, -1,  6,  0,
  1,  2,  3,  4,
  2,  5,  2, -6,  3,  1,
  2,  2,  2, -1,  3,  1,
  2,  6,  3, -7,  4,  0,
  2,  5,  3, -5,  4,  0,
  2,  4,  2, -4,  3,  0,
  2,  3,  3, -4,  5,  0,
  2,  3,  3, -3,  5,  0,
  2,  6,  2, -7,  3,  0,
  2,  3,  3, -2,  5,  1,
  2,  3,  2, -2,  3,  0,
  1,  3,  3,  2,
  2,  5,  2, -5,  3,  0,
  2,  1,  1, -1,  3,  0,
  2,  7,  2, -8,  3,  0,
  2,  4,  3, -4,  5,  0,
  2,  4,  3, -3,  5,  0,
  2,  6,  2, -6,  3,  0,
  1,  4,  3,  1,
  2,  7,  2, -7,  3,  1,
  2,  8,  2, -8,  3,  0,
  2,  9,  2, -9,  3,  0,
 -1
};
/* Total terms = 135, small = 134 */
static struct plantbl ear404 = {
  {  1,  9, 14, 17,  5,  5,  2,  1,  0,},
 4,
 earargs,
 eartabl,
 eartabb,
 eartabr,
 1.0,
};

/*
First date in file = 1228000.50
Number of records = 397276.0
Days per record = 4.0
      Julian Years      Lon    Lat    Rad
 -1349.9 to  -1000.0:   0.42   0.18   0.25 
 -1000.0 to   -500.0:   0.45   0.14   0.21 
  -500.0 to      0.0:   0.37   0.10   0.20 
     0.0 to    500.0:   0.33   0.09   0.22 
   500.0 to   1000.0:   0.48   0.07   0.22 
  1000.0 to   1500.0:   0.40   0.07   0.19 
  1500.0 to   2000.0:   0.36   0.11   0.19 
  2000.0 to   2500.0:   0.38   0.14   0.20 
  2500.0 to   3000.0:   0.45   0.15   0.24 
  3000.0 to   3000.8:  0.182  0.125  0.087 
*/

static double martabl[] = {
       43471.66140,       21291.11063,        2033.37848,  6890507597.78366,
     1279543.73631,

         317.74183,         730.69258,         -15.26502,         277.56960,
         -62.96711,          20.96285,

           1.01857,          -2.19395,

           3.75708,           3.65854,           0.01049,           1.09183,

          -0.00605,          -0.04769,

           0.41839,           0.10091,           0.03887,           0.11666,

          -0.03301,           0.02664,

           0.38777,          -0.56974,

           0.02974,          -0.15041,           0.02179,          -0.00808,

           0.08594,           0.09773,

          -0.00902,          -0.04597,           0.00762,          -0.03858,

          -0.00139,           0.01562,

           0.02019,           0.01878,

          -0.01244,           0.00795,

           0.00815,           0.03501,

          -0.00335,          -0.02970,

          -0.00518,          -0.01763,

           0.17257,           0.14698,          -0.14417,           0.26028,

           0.00062,          -0.00180,

          13.35262,          39.38771,         -15.49558,          22.00150,
          -7.71321,          -4.20035,           0.62074,          -1.42376,

           0.07043,          -0.06670,           0.16960,          -0.06859,
           0.07787,           0.01845,

          -0.01608,          -0.00914,

           5.60438,          -3.44436,           5.88876,           6.77238,
          -5.29704,           3.48944,

           0.01291,           0.01280,

          -0.53532,           0.86584,           0.79604,           0.31635,

          -3.92977,          -0.94829,          -0.74254,          -1.37947,
           0.17871,          -0.12477,

           0.00171,           0.11537,

           0.02281,          -0.03922,

          -0.00165,           0.02965,

           1.59773,           1.24565,          -0.35802,           1.37272,
          -0.44811,          -0.08611,

           3.04184,          -3.39729,           8.86270,           6.65967,
          -9.10580,          10.66103,

           0.02015,          -0.00902,

          -0.01166,          -0.23957,          -0.12128,          -0.04640,

          -0.07114,           0.14053,          -0.04966,          -0.01665,

           0.28411,          -0.37754,          -1.26265,           1.01377,
           3.70433,          -0.21025,

          -0.00972,           0.00350,

           0.00997,           0.00450,

          -2.15305,           3.18147,          -1.81957,          -0.02321,
          -0.02560,          -0.35188,

           0.00003,          -0.01110,

           0.00244,          -0.05083,

          -0.00216,          -0.02026,

           0.05179,           0.04188,

           5.92031,          -1.61316,           3.72001,           6.98783,
          -4.17690,           2.61250,

           0.04157,           2.76453,          -1.34043,           0.74586,
          -0.20258,          -0.30467,

           0.00733,           0.00376,

           1.72800,           0.76593,           1.26577,          -2.02682,
          -1.14637,          -0.91894,

          -0.00002,           0.00036,

           2.54213,           0.89533,          -0.04166,           2.36838,
          -0.97069,           0.05486,

           0.46927,           0.04500,           0.23388,           0.35005,

           1.61402,           2.30209,          -0.99859,           1.63349,
          -0.51490,          -0.26112,

           0.27848,          -0.26100,          -0.07645,          -0.22001,

           0.92901,           1.12627,          -0.39829,           0.77120,
          -0.23716,          -0.11245,

          -0.02387,           0.03960,

          -0.00802,           0.02179,

           2.86448,           1.00246,          -0.14647,           2.80278,
          -1.14143,           0.05177,

           1.68671,          -1.23451,           3.16285,           0.70070,
           0.25817,           3.17416,

           0.07447,          -0.08116,          -0.03029,          -0.02795,

           0.00816,           0.01023,

           0.00685,          -0.01075,

          -0.34268,           0.03680,          -0.05488,          -0.07430,

          -0.00041,          -0.02968,

           3.13228,          -0.83209,           1.95765,           3.78394,
          -2.26196,           1.38520,

          -0.00401,          -0.01397,

           1.01604,          -0.99485,           0.62465,           0.22431,
          -0.05076,           0.12025,

           4.35229,          -5.04483,          14.87533,           9.00826,
         -10.37595,          19.26596,

           0.40352,           0.19895,           0.09463,          -0.10774,

          -0.17809,          -0.08979,          -0.00796,          -0.04313,

           0.01520,          -0.03538,

           1.53301,          -1.75553,           4.87236,           3.23662,
          -3.62305,           6.42351,

          -0.00439,          -0.01305,

           0.17194,          -0.64003,           0.26609,           0.06600,

           0.01767,          -0.00251,

          -0.08871,          -0.15523,           0.01201,          -0.03408,

          -0.29126,          -0.07093,          -0.00998,          -0.07876,

           1.05932,         -25.38650,

          -0.29354,           0.04179,          -0.01726,           0.07473,

          -0.07607,          -0.08859,           0.00842,          -0.02359,

           0.47858,          -0.39809,           1.25061,           0.87017,
          -0.82453,           1.56864,

          -0.00463,           0.02385,

          -0.29070,           8.56535,

          -0.12495,           0.06580,          -0.03395,          -0.02465,

          -1.06759,           0.47004,          -0.40281,          -0.23957,
           0.03572,          -0.07012,

           0.00571,          -0.00731,

           0.18601,          -1.34068,

           0.03798,          -0.00532,           0.00448,          -0.01147,

           1.41208,          -0.00668,           0.25883,           1.23788,
          -0.57774,           0.09166,

          -2.49664,          -0.25235,          -0.53582,          -0.80126,
           0.10827,          -0.08861,

          -0.03577,           0.06825,

          -0.00143,           0.04633,

           0.01586,          -0.01056,

          -0.02106,           0.03804,

          -0.00088,          -0.03458,

          -0.00033,          -0.01079,

           0.05821,          -0.02445,

           0.00602,           0.00721,

          -0.00315,          -0.01021,

          -0.65454,           1.08478,          -0.44593,          -0.21492,

          -1.35004,           4.47299,          -4.19170,           3.51236,

        1946.04629,       13960.88247,         576.24572,        8023.81797,
        2402.48512,        -753.87007,       -6376.99217,      -10278.88014,
      -25743.89874,       15506.87748,       15609.59853,       35173.63133,

          -3.70370,           6.29538,          -4.84183,          -0.76942,

          -0.02465,          -0.03840,

           0.00565,          -0.06071,

           0.01174,           0.00253,

          -0.00230,           0.05252,

          -0.02813,           0.01359,

           0.23208,           0.03393,           0.01734,           0.04838,

          -0.46340,          -0.18941,           0.25428,          -0.56925,

           0.05213,           0.24704,           0.12922,          -0.01531,

           0.06885,          -0.08510,           0.01853,          -0.00390,

           0.01196,          -0.30530,           0.13117,          -0.03533,

           1.79597,          -0.42743,           0.98545,           2.13503,
          -1.32942,           0.68005,

          -0.01226,           0.00571,

           0.31081,           0.34932,           0.34531,          -0.32947,

          -0.00548,           0.00186,          -0.00157,          -0.00065,

           0.30877,          -0.03864,           0.04921,           0.06693,

           0.01761,          -0.04119,

           1.28318,           0.38546,           0.06462,           1.18337,
          -0.48698,           0.07086,

           0.26031,          -0.22813,           0.10272,           0.04737,

          -0.04506,          -0.38581,          -0.16624,          -0.04588,

           0.00992,           0.00722,

          -0.21041,           0.20560,          -0.09267,          -0.03438,

           0.32264,          -0.07383,

           0.09553,          -0.38730,           0.17109,          -0.01342,

          -0.02336,          -0.01286,

           0.00230,           0.04626,

           0.01176,           0.01868,

          -0.15411,          -0.32799,           0.22083,          -0.14077,

           1.98392,           1.68058,

          -0.02526,          -0.13164,          -0.04447,          -0.00153,

           0.01277,           0.00553,

          -0.26035,          -0.11362,           0.14672,          -0.32242,

           0.16686,          -0.69957,           0.40091,          -0.06721,
           0.00837,           0.09635,

          -0.08545,           0.25178,          -0.22486,          16.03256,

           0.34130,          -0.06313,           0.01469,          -0.09012,

          -0.00744,          -0.02510,

          -0.08492,          -0.13733,

          -0.07620,          -0.15329,           0.13716,          -0.03769,

           2.01176,          -1.35991,          -1.04319,          -2.97226,

          -0.01433,           0.61219,

          -0.55522,           0.38579,           0.31831,           0.81843,

          -0.04583,          -0.14585,

          -0.10218,           0.16039,          -0.06552,          -0.01802,

           0.06480,          -0.06641,           0.01672,          -0.00287,

           0.00308,           0.09982,          -0.05679,          -0.00249,

          -0.36034,           0.52385,          -0.29759,           0.59539,

          -3.59641,          -1.02499,

        -547.53774,         734.11470,         441.86760,        -626.68255,
       -2255.81376,       -1309.01028,       -2025.69590,        2774.69901,
        1711.21478,        1509.99797,

          -0.99274,           0.61858,          -0.47634,          -0.33034,

           0.00261,           0.01183,

          -0.00038,           0.11687,

           0.00994,          -0.01122,

           0.03482,          -0.01942,

          -0.11557,           0.38237,          -0.17826,           0.00830,

           0.01193,          -0.05469,

           0.01557,           0.01747,

           0.02730,          -0.01182,

          -0.11284,           0.12939,          -0.05621,          -0.01615,

           0.04258,           0.01058,

          -0.01723,           0.00963,

           0.20666,           0.11742,

           0.07830,          -0.02922,

          -0.10659,          -0.05407,           0.07254,          -0.13005,

          -0.02365,           0.24583,           0.31915,           1.27060,

           0.00009,          -0.21541,

          -0.55324,          -0.45999,          -1.45885,           0.86530,
           0.85932,           1.92999,

          -0.00755,          -0.00715,

          -0.02004,          -0.00788,

           0.01539,           0.00837,

           0.27652,          -0.50297,          -0.26703,          -0.28159,

           0.03950,           0.07182,

          -0.07177,           0.14140,           0.07693,           0.07564,

          -0.01316,          -0.01259,

           0.01529,           0.07773,

         -90.74225,        -378.15784,        -510.30190,         -52.35396,
         -89.15267,         415.56828,         181.52119,          54.01570,

          -0.01093,          -0.05931,

          -0.01344,          -0.02390,

           0.01432,          -0.02470,

          -0.01509,          -0.01346,

           0.03352,           0.02248,

           0.02588,          -0.00948,

           0.03610,           0.17238,

           0.02909,          -0.04065,

           0.00155,          -0.07025,

          -0.09508,           0.14487,           0.12441,           0.16451,

           0.00001,          -0.00005,

          -0.00982,          -0.01895,

          -0.16968,           0.36565,           0.20234,           0.17789,

          -0.04519,          -0.00588,

           0.01268,           0.00107,

         -56.32137,         -58.22145,         -80.55270,          28.14532,
          11.43301,          52.05752,          17.79480,          -2.61997,

          -0.00005,          -0.02629,

           0.01080,          -0.00390,

           0.00744,           0.03132,

           0.01156,          -0.01621,

           0.02162,           0.02552,

           0.00075,          -0.02497,

           0.02495,           0.00830,

           0.03230,           0.00103,

         -14.84965,          -4.50200,          -9.73043,           9.40426,
           4.08054,           5.38571,           1.53731,          -1.01288,

           0.21076,           1.74227,           0.79760,           0.39583,
           0.09879,          -0.16736,

          -0.00723,          -0.01536,

};
static double martabb[] = {
        -364.49380,         -47.17612,        -554.97858,        -430.63121,
         596.44312,

          -3.94434,          -7.43169,          -0.06665,          -2.23987,
           0.10366,          -0.05567,

          -0.01463,           0.01908,

          -0.02611,          -0.00350,          -0.01057,          -0.00610,

          -0.00015,           0.00002,

           0.00010,           0.00033,           0.00007,          -0.00000,

          -0.00010,          -0.00004,

           0.00012,           0.00002,

          -0.00014,          -0.00048,          -0.00003,          -0.00007,

           0.00008,          -0.00005,

          -0.00043,          -0.00003,          -0.00010,          -0.00004,

           0.00001,           0.00001,

          -0.00003,          -0.00003,

           0.00004,           0.00007,

          -0.00041,           0.00031,

           0.00076,           0.00062,

           0.00001,          -0.00002,

           0.00035,           0.00053,           0.00026,           0.00019,

           0.00020,           0.00010,

           0.02936,           0.09624,          -0.01153,           0.01386,
           0.00551,          -0.00690,           0.00196,           0.00148,

          -0.00408,          -0.00673,          -0.00067,          -0.00152,
          -0.00014,          -0.00005,

           0.00000,           0.00005,

          -0.00116,           0.00276,          -0.00391,           0.00983,
          -0.01327,          -0.01986,

          -0.00003,           0.00001,

           0.01104,           0.00631,          -0.01364,           0.01152,

          -0.00439,           0.01103,          -0.00546,           0.00181,
          -0.00039,          -0.00083,

           0.00007,           0.00002,

          -0.00010,          -0.00008,

           0.00005,           0.00002,

          -0.00584,           0.00512,          -0.00722,          -0.00174,
           0.00101,          -0.00316,

          -0.02229,          -0.02797,          -0.10718,           0.05741,
           0.11403,           0.10033,

           0.00036,          -0.00022,

           0.00787,           0.01191,           0.01756,          -0.02121,

          -0.00169,          -0.00364,           0.00070,          -0.00051,

           0.01850,          -0.06836,           0.21471,           0.00162,
          -0.29165,           0.16799,

          -0.00002,           0.00011,

          -0.00075,          -0.00077,

          -0.00675,          -0.00814,           0.00029,          -0.00599,
           0.00107,           0.00013,

           0.00010,          -0.00002,

           0.00005,           0.00020,

           0.00355,           0.00306,

          -0.00013,          -0.00061,

          -0.02950,          -0.00847,           0.01037,          -0.04783,
           0.04237,           0.11662,

          -0.00331,           0.00207,          -0.00107,          -0.00264,
           0.00072,          -0.00023,

          -0.00151,           0.00146,

          -0.12847,           0.02294,           0.03611,           0.19705,
           0.16855,          -0.28279,

          -0.00000,          -0.00002,

          -0.00525,          -0.03619,           0.05048,          -0.00481,
          -0.00745,           0.04618,

           0.00286,           0.00443,           0.00521,          -0.00351,

           0.00200,           0.00474,          -0.00149,           0.00031,
          -0.00003,           0.00029,

           0.00686,           0.02467,           0.04275,          -0.02223,

           0.02282,          -0.04228,           0.03312,           0.01847,
          -0.01253,           0.01601,

           0.00076,           0.00091,

           0.00045,           0.00035,

           0.00658,           0.01586,          -0.00310,           0.00628,
          -0.00045,           0.00316,

          -0.01602,          -0.00340,          -0.01744,           0.04907,
           0.06426,           0.02275,

          -0.00217,          -0.00377,          -0.00091,           0.00037,

           0.00040,          -0.00003,

          -0.00017,          -0.00027,

           0.00366,           0.02693,          -0.00934,           0.00386,

           0.00616,          -0.00037,

           0.02028,           0.02120,          -0.01768,           0.02421,
           0.00102,           0.00877,

           0.00012,           0.00030,

          -0.00019,          -0.02165,           0.01245,          -0.00742,
           0.00172,           0.00320,

          -0.17117,          -0.12908,          -0.43134,           0.15617,
           0.21216,           0.56432,

           0.01139,          -0.00937,          -0.00058,          -0.00337,

          -0.00999,           0.01862,          -0.00621,          -0.00080,

          -0.00025,          -0.00140,

           0.09250,           0.01173,          -0.03549,           0.14651,
          -0.01784,           0.00945,

           0.00000,          -0.00006,

          -0.00500,           0.00086,           0.01079,          -0.00002,

          -0.00012,          -0.00029,

          -0.02661,           0.00140,          -0.00524,          -0.00460,

          -0.00352,          -0.00563,          -0.00277,          -0.00052,

          -0.10171,          -0.02001,

           0.00045,           0.00265,          -0.00082,           0.00160,

          -0.00302,          -0.00434,          -0.00022,          -0.00134,

           0.03285,           0.02964,          -0.05612,          -0.00668,
          -0.01821,           0.06590,

           0.00039,           0.00061,

          -0.13531,          -0.03831,

           0.02553,           0.02130,          -0.00336,           0.00468,

          -0.04522,          -0.05540,           0.00129,          -0.01767,
           0.00181,           0.00031,

          -0.00011,          -0.00034,

          -0.00146,           0.01101,

          -0.00030,           0.00240,          -0.00039,           0.00072,

          -0.01954,          -0.03822,           0.09682,          -0.04541,
          -0.01567,           0.09617,

          -0.03371,           0.33028,          -0.12102,           0.05874,
          -0.00990,          -0.02236,

           0.00109,           0.00158,

          -0.00482,           0.00019,

          -0.00036,           0.00004,

           0.00024,           0.00201,

           0.00017,           0.00011,

          -0.00012,           0.00002,

          -0.00323,          -0.01062,

          -0.00130,           0.00091,

           0.00056,          -0.00017,

           0.00774,           0.00601,           0.02550,           0.01700,

          -0.84327,           0.77533,          -0.71414,          -0.50643,

        -473.30877,       -1504.79179,        -458.52274,        -865.82237,
        -417.34994,        -681.03976,         765.50697,       -1653.67165,
        4427.33176,         710.53895,       -5016.39367,        4280.60361,

           0.33957,           0.38390,          -0.38631,           0.81193,

           0.00154,          -0.00043,

           0.01103,          -0.00017,

          -0.00046,           0.00221,

           0.00059,           0.00014,

           0.00160,           0.00475,

           0.06191,          -0.13289,           0.02884,          -0.00566,

          -0.01572,           0.23780,          -0.05140,          -0.03228,

          -0.00716,          -0.00978,          -0.01048,           0.01317,

          -0.01267,          -0.01198,           0.00037,          -0.00330,

          -0.02305,           0.00355,          -0.00121,          -0.00496,

          -0.04369,          -0.01343,           0.05347,          -0.12433,
           0.02090,           0.17683,

           0.00028,          -0.00490,

          -0.02778,          -0.05587,          -0.01658,           0.05655,

           0.00204,          -0.00092,           0.00020,           0.00014,

          -0.00603,          -0.03829,           0.00778,          -0.00588,

          -0.00266,           0.00097,

          -0.02158,          -0.07742,           0.09306,          -0.01827,
          -0.01048,           0.07885,

          -0.02485,          -0.02505,           0.00471,          -0.01026,

           0.06663,           0.01110,           0.00469,          -0.05347,

          -0.00016,          -0.00013,

           0.02622,           0.02273,          -0.01009,           0.01391,

          -0.01042,          -0.00444,

          -0.04293,          -0.00767,          -0.00154,          -0.01739,

           0.00353,          -0.00763,

          -0.00060,           0.00010,

          -0.00053,          -0.00146,

          -0.05317,           0.05760,          -0.01801,          -0.02099,

          -0.02611,          -0.01836,

          -0.00256,           0.00812,          -0.00145,           0.00054,

          -0.00008,           0.00015,

          -0.04087,           0.08860,          -0.05385,          -0.02134,

           0.02771,           0.02441,          -0.00234,           0.01571,
          -0.00260,           0.00097,

           0.10151,           0.49378,          -0.28555,           0.11428,

          -0.00286,           0.01224,           0.00160,           0.00069,

           0.00000,          -0.00040,

          -0.13286,           0.00448,

           0.01225,          -0.00568,           0.00341,           0.00224,

          -0.23483,          -0.07859,           0.30733,          -0.21548,

          -0.02608,           0.00756,

           0.09789,           0.02878,          -0.11968,           0.08981,

           0.02046,          -0.00888,

           0.02955,           0.01486,          -0.00981,           0.01542,

          -0.01674,          -0.01540,           0.00019,          -0.00449,

          -0.02140,           0.00638,           0.00112,          -0.00730,

          -0.08571,           0.13811,          -0.16951,          -0.02917,

          -0.03931,          -0.32643,

         -68.64541,         -81.00521,         -47.97737,          15.75290,
         181.76392,         -36.00647,         -48.32098,        -259.02226,
        -265.57466,         554.05904,

           0.09017,           0.18803,          -0.12459,           0.10852,

           0.00211,           0.00002,

           0.00304,          -0.00370,

           0.00174,           0.00279,

           0.00139,           0.00095,

           0.04881,           0.00262,          -0.01020,           0.03762,

           0.00987,           0.00612,

           0.00054,          -0.00036,

           0.00009,          -0.00094,

           0.02279,           0.01785,          -0.00778,           0.01263,

           0.00040,          -0.00112,

          -0.00452,          -0.00662,

           0.00483,          -0.00030,

          -0.00054,          -0.00205,

          -0.00052,          -0.00362,          -0.00215,          -0.00247,

           0.02893,          -0.01965,          -0.00004,           0.04114,

          -0.00284,          -0.00103,

           0.01827,          -0.07822,           0.18010,           0.04805,
          -0.21702,           0.18808,

           0.00095,          -0.00132,

          -0.01488,           0.00746,

           0.00198,           0.00190,

           0.01032,           0.03392,           0.04318,          -0.07332,

          -0.01004,           0.00787,

          -0.00308,          -0.01177,          -0.01431,           0.02659,

           0.00273,          -0.00374,

          -0.02545,           0.00644,

          28.68376,          13.74978,          29.60401,         -47.98255,
         -65.91944,         -18.48404,          -1.73580,          64.67487,

          -0.02492,           0.00104,

          -0.00829,          -0.00134,

           0.00077,           0.00005,

          -0.00513,           0.00403,

           0.00071,          -0.00047,

          -0.00023,          -0.00063,

           0.00120,           0.00370,

          -0.00038,          -0.00037,

           0.00080,          -0.00018,

           0.00866,           0.00156,          -0.01064,           0.02131,

           0.00000,          -0.00001,

           0.00038,          -0.00068,

          -0.00909,          -0.02187,          -0.02599,           0.05507,

          -0.00022,          -0.01468,

           0.00032,           0.00500,

           9.86233,          -2.85314,          -2.25791,         -13.83444,
         -12.38794,           3.79861,           2.76343,           6.63505,

           0.00066,           0.00007,

          -0.00016,          -0.00039,

           0.00014,           0.00059,

          -0.00031,          -0.00024,

          -0.00168,           0.00259,

           0.00007,          -0.00005,

          -0.00052,           0.00558,

           0.00110,           0.01037,

           1.59224,          -2.37284,          -2.00023,          -2.28280,
          -1.49571,           1.48293,           0.60041,           0.56376,

          -0.54386,           0.03568,          -0.10392,           0.31005,
           0.09104,           0.03015,

           0.00826,          -0.00524,

};
static double martabr[] = {
        -816.07287,        -381.41365,         -33.69436,         177.22955,
           0.18630,

          -8.29605,         -11.15519,          -0.57407,          -3.53642,
           0.16663,          -0.06334,

          -0.03056,           0.02767,

          -0.04161,           0.03917,          -0.02425,           0.00204,

          -0.00034,           0.00023,

           0.00058,          -0.00111,           0.00039,          -0.00015,

           0.00006,          -0.00023,

           0.00237,           0.00191,

           0.00154,          -0.00029,           0.00009,           0.00011,

          -0.00041,           0.00037,

          -0.00010,          -0.00064,           0.00015,          -0.00005,

           0.00012,          -0.00003,

          -0.00034,           0.00026,

           0.00011,          -0.00007,

          -0.00158,           0.00087,

           0.00278,           0.00137,

           0.00024,          -0.00020,

           0.00530,          -0.00448,           0.00780,           0.00408,

           0.00062,           0.00035,

          -1.35261,           0.79891,          -0.81597,          -0.43774,
           0.14713,          -0.27415,           0.05298,           0.02230,

          -0.02089,          -0.01070,          -0.00374,           0.00342,
          -0.00142,           0.00270,

          -0.00039,           0.00063,

           0.16024,           0.27088,          -0.32127,           0.27467,
          -0.16615,          -0.24460,

          -0.00073,           0.00032,

          -0.05710,          -0.05265,          -0.06025,           0.05120,

          -0.05295,           0.23477,          -0.08211,           0.04575,
          -0.00769,          -0.01067,

          -0.00570,           0.00015,

          -0.00251,          -0.00140,

          -0.00131,          -0.00018,

          -0.12246,           0.15836,          -0.13065,          -0.03222,
           0.00795,          -0.04232,

          -0.36585,          -0.31154,           0.68504,          -0.96006,
           1.19304,           0.88631,

           0.00132,           0.00046,

           0.13105,           0.04252,           0.05164,          -0.06837,

          -0.01351,          -0.01458,           0.00376,          -0.00557,

           0.28532,          -0.17290,          -0.53946,          -0.79365,
          -0.95246,           0.74984,

           0.00019,           0.00132,

          -0.00163,          -0.00295,

          -0.40106,          -0.26573,          -0.00155,          -0.22655,
           0.04349,          -0.00376,

           0.00149,          -0.00001,

           0.00523,           0.00078,

           0.01203,           0.00558,

          -0.00708,           0.00520,

          -0.36428,          -1.28827,           1.50845,          -0.83063,
           0.58802,           0.89998,

          -0.55256,           0.01255,          -0.15169,          -0.26715,
           0.06061,          -0.04122,

          -0.00397,           0.00534,

          -0.52576,           1.22031,           1.44098,           0.92406,
           0.67214,          -0.85486,

          -0.00010,           0.00001,

           0.28820,          -0.84198,           0.78291,           0.00251,
           0.02398,           0.32093,

          -0.02331,           0.10109,          -0.07555,           0.03557,

          -0.61580,           0.43399,          -0.43779,          -0.26390,
           0.06885,          -0.13803,

           0.17694,           0.19245,           0.15119,          -0.05100,

           0.49469,          -0.45028,           0.33590,           0.15677,
          -0.04702,           0.10265,

          -0.00942,          -0.00580,

          -0.00555,          -0.00252,

          -0.32933,           0.92539,          -0.91004,          -0.04490,
          -0.01812,          -0.37121,

           0.34695,           0.50855,          -0.24721,           0.86063,
          -0.84747,           0.01983,

           0.01948,           0.02039,           0.00748,          -0.00727,

          -0.00271,           0.00220,

           0.00309,           0.00196,

           0.02030,           0.17201,          -0.03716,           0.02801,

           0.01871,           0.00002,

           0.31736,           1.17319,          -1.42245,           0.73416,
          -0.52302,          -0.85056,

           0.00522,          -0.00126,

           0.33571,           0.34594,          -0.07709,           0.21114,
          -0.04066,          -0.01742,

           1.72228,           1.46934,          -3.06437,           5.06723,
          -6.53800,          -3.55839,

          -0.06933,           0.13815,           0.03684,           0.03284,

          -0.04841,           0.09571,          -0.02350,           0.00418,

           0.01302,           0.00579,

           0.73408,           0.64718,          -1.37437,           2.04816,
          -2.70756,          -1.52808,

           0.00523,          -0.00166,

           0.25915,           0.06900,          -0.02758,           0.10707,

           0.00062,           0.00744,

          -0.08117,           0.04840,          -0.01806,          -0.00637,

           0.03034,          -0.12414,           0.03419,          -0.00388,

          10.92603,           0.48169,

          -0.01753,          -0.12853,          -0.03207,          -0.00801,

           0.03904,          -0.03326,           0.01033,           0.00366,

           0.17249,           0.20846,          -0.38157,           0.54639,
          -0.68518,          -0.36121,

          -0.01043,          -0.00186,

          -3.33843,          -0.16353,

           0.03462,           0.06669,          -0.01305,           0.01803,

          -0.22703,          -0.52219,           0.11709,          -0.19628,
           0.03410,           0.01741,

           0.00338,           0.00265,

           0.63213,           0.08944,

           0.00236,           0.01829,           0.00546,           0.00218,

           0.00073,          -0.72570,           0.63698,          -0.13340,
           0.04698,           0.29716,

          -0.13126,           1.27705,          -0.40980,           0.27400,
          -0.04525,          -0.05529,

          -0.03249,          -0.01696,

          -0.02314,          -0.00076,

           0.00510,           0.00764,

          -0.01847,          -0.01021,

           0.01688,          -0.00044,

           0.00531,          -0.00016,

          -0.01219,          -0.02903,

          -0.00361,           0.00299,

           0.00504,          -0.00153,

          -0.53625,          -0.32460,           0.10642,          -0.22070,

          -2.21651,          -0.66036,          -1.74652,          -2.08198,

       -6810.78679,         967.02869,       -3915.97140,         291.65905,
         372.99563,        1196.01966,        5108.01033,       -3172.64698,
       -7685.78246,      -12789.43898,      -17474.50562,        7757.84703,

           3.13224,           1.84743,          -0.38257,           2.40590,

           0.01860,          -0.01217,

           0.03004,           0.00278,

          -0.00125,           0.00579,

          -0.02673,          -0.00112,

           0.00662,           0.01374,

          -0.02729,           0.13109,          -0.02836,           0.00877,

           0.12171,          -0.27475,           0.34765,           0.15882,

          -0.12548,           0.02603,           0.00710,           0.06538,

          -0.04039,          -0.03257,          -0.00186,          -0.00880,

           0.16643,           0.00707,           0.01918,           0.07156,

          -0.20459,          -0.85107,           1.01832,          -0.47158,
           0.32582,           0.63002,

          -0.00282,          -0.00711,

          -0.19695,           0.15053,           0.15676,           0.17847,

           0.00071,           0.00286,          -0.00039,           0.00083,

           0.02009,           0.17859,          -0.03894,           0.02805,

           0.02379,           0.00752,

           0.17529,          -0.57783,           0.53257,          -0.02829,
           0.03211,           0.21777,

           0.13813,           0.16305,          -0.02996,           0.06303,

           0.21058,          -0.02659,           0.02596,          -0.08808,

          -0.00389,           0.00586,

           0.08986,           0.09204,          -0.01480,           0.04031,

           0.06115,           0.18366,

           0.25636,           0.06905,           0.00719,           0.11391,

           0.00636,          -0.01113,

          -0.02808,           0.00150,

          -0.01219,           0.00832,

           0.28626,          -0.09573,           0.10481,           0.16559,

          -0.94578,           1.26394,

           0.08846,          -0.01623,           0.00082,          -0.02640,

          -0.00347,           0.00798,

           0.12873,          -0.21248,           0.27999,           0.14348,

           0.44082,           0.10453,           0.04362,           0.25332,
          -0.06077,           0.00555,

          -0.06947,          -0.05511,         -10.08703,          -0.10614,

           0.04059,           0.21355,           0.05632,           0.00871,

           0.01599,          -0.00531,

           0.36835,          -0.03530,

           0.09519,          -0.04961,           0.02568,           0.08613,

           0.57033,           0.84599,           1.27123,          -0.41266,

          -0.36937,          -0.00655,

          -0.16547,          -0.24000,          -0.35213,           0.13345,

           0.05870,          -0.01524,

           0.06419,           0.04136,          -0.00681,           0.02606,

          -0.02519,          -0.02732,          -0.00105,          -0.00677,

          -0.03891,           0.00106,           0.00087,          -0.02256,

          -0.20834,          -0.14624,          -0.23178,          -0.11786,

           0.32479,          -1.41222,

        -303.74549,        -202.79324,         260.20290,         184.84320,
         536.68016,        -881.56427,       -1125.64824,        -791.09928,
        -596.61162,         659.35664,

           0.24561,           0.39519,          -0.12601,           0.18709,

          -0.00700,           0.00136,

           0.30750,           0.00009,

           0.00443,           0.00384,

           0.01170,           0.02078,

           0.15043,           0.04802,           0.00386,           0.06942,

           0.02107,           0.00495,

          -0.01067,           0.00951,

           0.00937,           0.01996,

           0.04922,           0.04337,          -0.00583,           0.02110,

          -0.00691,           0.02793,

          -0.00364,          -0.00682,

          -0.09143,           0.15369,

           0.02043,           0.05451,

           0.04053,          -0.08179,           0.09645,           0.05330,

          -0.10149,          -0.01594,          -0.96773,           0.13660,

           0.17326,           0.00013,

           0.20990,          -0.23184,          -0.38407,          -0.64733,
          -0.84754,           0.38889,

           0.00310,          -0.00340,

           0.00970,          -0.00788,

          -0.01111,           0.00677,

           0.18147,           0.09968,           0.10170,          -0.09233,

          -0.03165,           0.01790,

          -0.04727,          -0.02364,          -0.02546,           0.02451,

           0.00442,          -0.00426,

          -0.02540,           0.00471,

         130.42585,         -31.30051,          17.99957,        -174.75585,
        -142.96798,         -27.89752,         -19.42122,          59.14872,

          -0.01899,           0.00388,

          -0.01265,           0.00694,

           0.01966,           0.01140,

          -0.00439,           0.00503,

          -0.01867,           0.02826,

           0.00752,           0.02012,

          -0.14734,           0.01909,

           0.03312,           0.02327,

           0.05843,           0.00061,

          -0.06958,          -0.05798,          -0.09174,           0.06242,

           0.00003,           0.00001,

           0.00670,          -0.00305,

          -0.13637,          -0.06058,          -0.06372,           0.07257,

           0.00209,          -0.01369,

          -0.00044,           0.00355,

          17.90079,         -17.48270,          -8.77915,         -24.54483,
         -15.67123,           3.62668,           0.52038,           5.13220,

           0.02574,           0.00003,

           0.00339,           0.00919,

          -0.02778,           0.00464,

           0.01429,           0.01003,

          -0.01661,           0.01327,

           0.02216,           0.00034,

          -0.00389,           0.01076,

          -0.00035,           0.00983,

           1.23731,          -4.18017,          -2.61932,          -2.66346,
          -1.45540,           1.10310,           0.23322,           0.40775,

          -0.43623,           0.06212,          -0.09900,           0.19456,
           0.03639,           0.02566,

           0.00309,          -0.00116,

};

static signed char marargs[] = {
  0,  4,
  3,  4,  3, -8,  4,  3,  5,  2,
  3,  5,  2, -6,  3, -4,  4,  0,
  2,  2,  5, -5,  6,  1,
  3, 12,  3,-24,  4,  9,  5,  0,
  3,  2,  2,  1,  3, -8,  4,  1,
  3, 11,  3,-21,  4,  2,  5,  0,
  3,  3,  2, -7,  3,  4,  4,  0,
  3,  7,  3,-13,  4, -1,  5,  1,
  3,  1,  3, -2,  4,  2,  6,  0,
  3,  1,  2, -8,  3, 12,  4,  1,
  3,  1,  4, -8,  5,  4,  6,  0,
  3,  1,  4, -7,  5,  2,  6,  0,
  3,  1,  4, -9,  5,  7,  6,  0,
  1,  1,  7,  0,
  2,  1,  5, -2,  6,  0,
  3,  1,  3, -2,  4,  1,  5,  0,
  3,  3,  3, -6,  4,  2,  5,  1,
  3, 12,  3,-23,  4,  3,  5,  0,
  2,  8,  3,-15,  4,  3,
  2,  1,  4, -6,  5,  2,
  3,  2,  2, -7,  3,  7,  4,  0,
  2,  1,  2, -3,  4,  2,
  2,  2,  5, -4,  6,  0,
  1,  1,  6,  1,
  2,  9,  3,-17,  4,  2,
  3,  2,  3, -4,  4,  2,  5,  0,
  3,  2,  3, -4,  4,  1,  5,  0,
  2,  1,  5, -1,  6,  0,
  2,  2,  2, -6,  4,  2,
  2,  1,  3, -2,  4,  2,
  2,  2,  5, -3,  6,  0,
  1,  2,  6,  1,
  2,  3,  5, -5,  6,  1,
  1,  1,  5,  2,
  3,  4,  3, -8,  4,  2,  5,  0,
  2,  1,  5, -5,  6,  0,
  2,  7,  3,-13,  4,  2,
  2,  3,  2, -9,  4,  0,
  2,  2,  5, -2,  6,  0,
  1,  3,  6,  0,
  2,  1,  4, -5,  5,  0,
  2,  2,  3, -4,  4,  2,
  2,  6,  3,-11,  4,  2,
  2,  4,  5, -5,  6,  0,
  1,  2,  5,  2,
  3,  1,  4, -3,  5, -3,  6,  0,
  2,  3,  3, -6,  4,  2,
  2,  1,  4, -4,  5,  1,
  2,  5,  3, -9,  4,  2,
  1,  3,  5,  1,
  2,  4,  3, -8,  4,  2,
  3,  1,  4, -4,  5,  2,  6,  0,
  3,  1,  4, -1,  5, -5,  6,  0,
  2,  4,  3, -7,  4,  2,
  2,  1,  4, -3,  5,  2,
  3,  1,  4, -5,  5,  5,  6,  1,
  3,  1,  4, -4,  5,  3,  6,  0,
  3,  1,  4, -3,  5,  1,  6,  0,
  2,  5,  3,-10,  4,  1,
  1,  4,  5,  0,
  2,  3,  3, -5,  4,  2,
  3,  1,  4, -3,  5,  2,  6,  0,
  2,  1,  4, -5,  6,  2,
  2,  1,  4, -2,  5,  2,
  3,  1,  4, -4,  5,  5,  6,  1,
  2,  6,  3,-12,  4,  1,
  2,  1,  4, -4,  6,  0,
  2,  2,  3, -3,  4,  2,
  2, 10,  3,-18,  4,  0,
  2,  1,  4, -3,  6,  1,
  3,  1,  4, -2,  5,  2,  6,  0,
  2,  7,  3,-14,  4,  1,
  3,  1,  4,  1,  5, -5,  6,  1,
  2,  1,  4, -1,  5,  0,
  3,  1,  4, -3,  5,  5,  6,  1,
  3,  1,  4,  2,  5, -7,  6,  1,
  2,  1,  4, -2,  6,  2,
  3,  1,  4, -2,  5,  3,  6,  0,
  2,  1,  3, -1,  4,  0,
  2,  2,  2, -7,  4,  1,
  2,  9,  3,-16,  4,  2,
  2,  1,  4, -3,  7,  0,
  2,  1,  4, -1,  6,  0,
  3,  1,  4, -2,  5,  4,  6,  1,
  2,  1,  2, -4,  4,  2,
  2,  8,  3,-16,  4,  2,
  2,  1,  4, -2,  7,  0,
  3,  3,  3, -5,  4,  2,  5,  0,
  3,  1,  4,  1,  5, -3,  6,  0,
  2,  1,  4, -2,  8,  0,
  2,  1,  4, -1,  7,  0,
  2,  1,  4, -1,  8,  0,
  3,  3,  2, -7,  3,  3,  4,  0,
  3,  2,  2,  1,  3, -7,  4,  0,
  3,  1,  4,  1,  6, -3,  7,  0,
  3,  1,  4,  2,  5, -5,  6,  1,
  3,  4,  3, -7,  4,  3,  5,  1,
  1,  1,  4,  5,
  3,  4,  3, -9,  4,  3,  5,  1,
  3,  1,  4, -2,  5,  5,  6,  0,
  3,  3,  2, -7,  3,  5,  4,  0,
  3,  1,  3, -1,  4,  2,  6,  0,
  3,  1,  4,  1,  5, -2,  6,  0,
  3,  3,  3, -7,  4,  2,  5,  0,
  2,  8,  3,-14,  4,  1,
  2,  1,  2, -2,  4,  1,
  2,  1,  4,  1,  6,  1,
  2,  9,  3,-18,  4,  1,
  2,  2,  2, -5,  4,  1,
  2,  1,  3, -3,  4,  2,
  2,  1,  4,  2,  6,  0,
  2,  1,  4,  1,  5,  1,
  3,  4,  3, -9,  4,  2,  5,  1,
  2,  7,  3,-12,  4,  1,
  2,  2,  4, -5,  5,  0,
  2,  2,  3, -5,  4,  2,
  2,  6,  3,-10,  4,  1,
  2,  1,  4,  2,  5,  1,
  3,  2,  4, -5,  5,  2,  6,  0,
  2,  3,  3, -7,  4,  1,
  2,  2,  4, -4,  5,  0,
  2,  5,  3, -8,  4,  1,
  2,  1,  4,  3,  5,  0,
  3,  2,  4, -4,  5,  2,  6,  0,
  3,  2,  4, -1,  5, -5,  6,  0,
  2,  4,  3, -6,  4,  1,
  2,  2,  4, -3,  5,  0,
  3,  2,  4, -5,  5,  5,  6,  1,
  3,  2,  4, -4,  5,  3,  6,  0,
  2,  3,  3, -4,  4,  1,
  2,  2,  4, -5,  6,  2,
  2,  2,  4, -2,  5,  1,
  3,  2,  4, -4,  5,  5,  6,  1,
  2,  2,  4, -4,  6,  0,
  2,  2,  3, -2,  4,  0,
  2,  2,  4, -3,  6,  1,
  2,  2,  4, -1,  5,  1,
  2,  2,  4, -2,  6,  0,
  1,  1,  3,  1,
  2,  2,  4, -1,  6,  0,
  2,  1,  2, -5,  4,  1,
  2,  8,  3,-17,  4,  1,
  3,  2,  4,  2,  5, -5,  6,  1,
  3,  4,  3, -6,  4,  3,  5,  1,
  3, 10,  3,-17,  4,  3,  6,  0,
  1,  2,  4,  4,
  3,  4,  3,-10,  4,  3,  5,  1,
  2,  8,  3,-13,  4,  0,
  2,  1,  2, -1,  4,  0,
  2,  2,  4,  1,  6,  0,
  2,  2,  2, -4,  4,  0,
  2,  1,  3, -4,  4,  1,
  2,  2,  4,  1,  5,  0,
  2,  7,  3,-11,  4,  0,
  2,  3,  4, -5,  5,  0,
  2,  2,  3, -6,  4,  1,
  2,  6,  3, -9,  4,  0,
  2,  2,  4,  2,  5,  0,
  2,  3,  4, -4,  5,  0,
  2,  5,  3, -7,  4,  0,
  2,  4,  3, -5,  4,  1,
  2,  3,  4, -3,  5,  1,
  2,  3,  3, -3,  4,  0,
  2,  3,  4, -2,  5,  2,
  3,  3,  4, -4,  5,  5,  6,  0,
  2,  2,  3, -1,  4,  0,
  2,  3,  4, -3,  6,  0,
  2,  3,  4, -1,  5,  1,
  2,  3,  4, -2,  6,  0,
  2,  1,  3,  1,  4,  1,
  2,  3,  4, -1,  6,  0,
  3,  4,  3, -5,  4,  3,  5,  0,
  1,  3,  4,  3,
  3,  4,  3,-11,  4,  3,  5,  0,
  1,  1,  2,  0,
  2,  2,  2, -3,  4,  0,
  2,  1,  3, -5,  4,  0,
  2,  4,  4, -5,  5,  0,
  2,  6,  3, -8,  4,  0,
  2,  4,  4, -4,  5,  0,
  2,  5,  3, -6,  4,  0,
  2,  4,  3, -4,  4,  0,
  2,  4,  4, -3,  5,  1,
  3,  6,  3, -8,  4,  2,  5,  0,
  2,  3,  3, -2,  4,  0,
  2,  4,  4, -2,  5,  1,
  2,  4,  4, -1,  5,  0,
  2,  1,  3,  2,  4,  0,
  1,  4,  4,  3,
  2,  2,  2, -2,  4,  0,
  2,  7,  3, -9,  4,  0,
  2,  5,  4, -5,  5,  0,
  2,  6,  3, -7,  4,  0,
  2,  5,  4, -4,  5,  0,
  2,  5,  3, -5,  4,  0,
  2,  5,  4, -3,  5,  0,
  2,  5,  4, -2,  5,  0,
  1,  5,  4,  3,
  1,  6,  4,  2,
  1,  7,  4,  0,
 -1
};
/* Total terms = 201, small = 199 */
static struct plantbl mar404 = {
  {  0,  5, 12, 24,  9,  7,  3,  2,  0,},
 5,
 marargs,
 martabl,
 martabb,
 martabr,
 1.5303348827100001e+00,
};

/*
First date in file = 625296.50
Number of records = 16731.0
Days per record = 131.0
      Julian Years      Lon    Lat    Rad
 -3000.0 to  -2499.7:   0.64   0.09   0.40 
 -2499.7 to  -1999.7:   0.70   0.09   0.45 
 -1999.7 to  -1499.7:   0.44   0.08   0.32 
 -1499.7 to   -999.8:   0.42   0.07   0.32 
  -999.8 to   -499.8:   0.55   0.06   0.34 
  -499.8 to      0.2:   0.43   0.06   0.31 
     0.2 to    500.2:   0.56   0.07   0.32 
   500.2 to   1000.1:   0.49   0.06   0.41 
  1000.1 to   1500.1:   0.48   0.06   0.38 
  1500.1 to   2000.1:   0.56   0.06   0.38 
  2000.1 to   2500.0:   0.63   0.08   0.33 
  2500.0 to   3000.0:   0.70   0.09   0.36 
  3000.0 to   3000.4:  0.526  0.023  0.190 
*/
static double juptabl[] = {
      153429.13855,      130818.16897,       18120.42948,       -8463.12663,
       -5058.91447,  1092566021.02148,      123671.25097,

          -5.43364,          12.06012,

       30428.31077,      -74667.61443,       46848.16236,      -66373.44474,
       24312.54264,      -26045.64766,       18353.92564,       -4022.13679,
        4037.97936,       10059.82468,       -4622.55896,        1383.21617,
        -187.25468,       -1171.66028,

          -0.00062,          -0.21713,

       -1198.83945,        1178.62445,       -1492.07393,         153.07155,
        -245.57966,        -391.94010,          82.26400,         -40.92104,
           3.72520,          10.57242,

          -0.04720,          -0.04448,          -0.04329,          -0.06043,

          -0.03905,           0.15712,

          -0.05644,          -0.00129,

          -0.00342,           0.02473,

           0.00434,          -0.01862,

           0.00431,          -0.03993,

          -0.03159,          -0.15982,

          -0.09928,           0.04430,          -0.00357,           0.31312,

          -0.01346,          -0.00180,

          -0.09107,           0.01215,

           0.02485,           0.01024,

          27.29869,           2.70896,          12.91956,          19.21726,
          -6.91384,           5.12954,          -1.07533,          -1.71691,

          -0.01423,           0.03121,

         -32.48652,         -26.13483,          46.78162,         -62.02701,
          94.96809,          81.73791,         -20.13673,         131.05065,

          -0.00798,           0.01786,

          13.99591,          16.87756,          -8.51726,          21.59490,
         -14.28833,          -9.45530,           7.73954,          -6.53078,

           0.03175,          -0.04295,

           3.06742,          -0.11838,           1.03630,           0.94004,
          -0.14085,           0.14434,

          -0.03363,           0.00993,

          -0.00007,          -0.02748,

          26.01507,          -7.37178,          16.96955,           6.24203,
          -0.40481,           3.72456,          -0.53597,          -0.14938,

          37.82081,          26.15887,          -2.82115,          78.26478,
         -63.39155,          -5.52419,          13.11482,         -43.54977,
          15.64940,           6.67505,

         -10.25616,          -7.39672,         -12.37441,          12.24417,
           8.54922,           9.68451,

          -0.03658,          -0.00963,

           1.65523,           0.43093,           0.32023,           0.71365,
          -0.12226,           0.03759,

           0.10388,           0.47212,          -0.02791,           0.09929,

          -0.04116,          -0.03125,

          -0.10240,          -0.23199,          -0.03524,          -0.13625,

           7.52726,           6.86314,           0.01239,          13.46530,
          -5.22256,           1.56116,          -0.15925,          -1.19571,

           3.26302,           0.06097,          -0.14444,          -0.20301,
           1.93822,         -80.12566,

           0.98665,          -7.52986,           3.86703,          -2.43028,
           0.64180,           0.78351,

           0.00190,          -0.00633,

          -0.00321,          -0.04403,

           0.19018,           0.14335,           0.10315,           0.53154,

          -0.00062,          -0.00464,

          -0.00109,           0.02150,

           1.19993,          47.21638,         -24.56067,          25.06332,
          -7.50751,          -6.36250,           1.39443,          -1.23806,

           0.04951,           0.02176,

           0.02802,          -0.01665,

          -0.10698,          -0.13635,

          73.54797,         -52.34968,          74.98754,          86.56283,
         -69.01463,          44.56866,

           0.04387,          -0.05925,

          -0.03732,          -0.03264,

           0.00967,           0.02143,

          10.59429,          26.48226,          34.03470,           3.96160,
           4.15919,         -20.22616,          -5.25903,          -3.40177,

           0.05111,          -0.06788,

           0.06497,           1.21024,          -0.29607,           0.49991,
          -0.06055,          -0.03464,

           0.02950,           0.16429,

           0.00722,          -0.90806,

          -0.02161,           0.00902,

          -0.00261,           0.00077,

           0.00434,          -0.29231,

           0.00456,           0.04781,

           1.33214,          -2.62015,           0.79761,          -0.81850,
           0.06371,           0.00119,

           0.03049,          -0.03553,           0.02373,          -0.01411,

        -189.06132,        -169.17940,           5.27464,        -227.72664,
          83.72511,         -12.04794,           0.23965,          23.75496,
          -3.43532,          -0.34276,

          -1.35880,           0.45053,          -0.34298,          -0.11441,

          -0.16328,           0.07423,

         481.48150,          79.82461,         453.82764,         941.94205,
        -635.83924,         397.29087,         -81.54066,        -417.22420,
         149.91822,          10.53490,

          -0.13210,           0.36740,

           0.33777,           0.15893,

       -2562.04968,        2442.77844,       -2602.66709,        2838.87348,
         723.50715,       -1284.58208,       -4557.23362,       -4514.61100,
       -8960.81693,        4663.55087,       -4947.61530,       19377.42027,

          -0.16786,          -0.19514,

           0.32100,           0.91502,

           4.96600,          -1.11836,

         307.38057,         175.14618,          16.02093,         444.42376,
        -219.80047,          62.39286,         -18.14266,         -52.23698,

           0.02111,           0.00469,

         -20.97409,         -34.48296,          -2.03906,         -27.07560,
           3.73818,          -3.00599,           0.24112,           0.41430,

          -0.03552,           0.00394,

          -0.00217,           0.02307,

           0.03686,           0.00510,

          34.46537,          10.23293,           9.99520,          28.88781,
         -11.31210,           3.52646,          -0.48062,          -2.93641,

          -0.00987,          -0.05310,

         -38.39539,           0.04568,         -31.73684,          -1.83151,
         -24.97332,          -1.71244,           0.33498,           7.03899,
          -4.15247,         200.43434,

          -0.00800,           0.04462,

          37.83113,         -13.40661,           9.49434,         -35.41588,
         -14.72767,          -3.84674,          -0.31412,           3.97734,

           0.02908,          -0.00353,

           1.89935,         -14.31774,           7.77051,          -7.08945,
           1.90915,           1.78908,          -0.41445,           0.30506,

         -14.43121,           7.30707,         -11.97842,         -17.64121,
          13.38962,          -7.20982,

          -5.23362,           2.11364,          -0.45605,           4.08835,
           1.42683,           0.24838,

          -0.00605,           0.03199,

          -0.17609,          -1.43091,           0.32444,          -0.51371,
           0.06182,           0.03733,

           0.00696,          -0.13438,

           4.67581,           4.42379,          -1.52602,           4.20659,
          -1.31757,          -0.72910,

           1.29012,           0.97780,           2.25895,          -0.85306,
           1.74120,          -5.09507,

           0.28107,          -0.05040,           0.05508,          -0.06349,

          -0.00061,           0.48249,

          -2.37749,           1.78180,          -1.67423,          -0.35618,
           0.05789,          -0.35287,

           0.56252,          -0.66584,           0.61979,           4.84016,
          -4.64462,          17.48002,

           0.40982,          -4.19214,          -1.55252,          -1.87505,
          -0.31070,           0.15554,

          -0.00034,           0.11102,

           0.01116,          -0.04166,

           9.27689,          -4.32090,           6.84888,           1.78741,
          -0.09306,           1.68391,          -0.27482,          -0.04197,

          -7.83068,          37.71086,         -37.53346,           7.18559,
           0.74427,         -24.29751,          10.87837,           1.35503,

           0.00998,          -0.03395,

        -133.52206,        -150.11329,           4.27494,        -173.79469,
         150.87961,        -356.29181,        -330.17873,        -426.29809,
        -607.98186,         126.35464,        -299.69623,         556.41055,

          -0.00342,           0.04411,

          44.65946,          42.07312,          85.71397,           5.95130,
          24.98064,         -41.20026,         -14.05970,         -10.46101,
          -2.24038,           2.89211,

           0.06175,           0.08128,           0.00705,           0.01939,

          -1.08361,          -0.08213,          -0.20868,          -0.36268,

          -4.96489,          -2.05966,          -6.16586,           3.65514,
          -3.12555,          12.20821,

          -1.11236,          -1.73772,          -1.34045,          -0.22774,
          -0.08639,           0.27355,

          -0.07700,           1.06260,          -0.46013,           0.31916,
          -0.04969,          -0.09488,

          -1.54000,           0.04949,          -0.07616,          -0.95933,
           0.93303,           3.43183,

          -0.82917,          -0.82042,          -0.68158,           0.17083,
           0.06942,           0.17491,

          -0.02699,          -0.01051,

           0.00657,           0.03063,

          -0.52595,           0.84035,          -0.88323,          -0.70188,
           0.60928,          -0.48179,

           0.38290,           0.04482,           0.26456,          -0.32369,

          -0.00615,           0.03218,

          -0.32943,           0.14675,          -0.10782,          -0.09036,

          -0.58003,           0.72888,          -0.46654,           1.17977,

           0.00222,           0.01541,

          -0.19226,          -0.07770,          -0.01829,          -0.05070,

          -1.75385,          -1.32969,           0.52361,          -1.36036,
           0.67222,           1.34612,

           6.96841,         -29.24025,         -23.76900,         -39.91647,
         -41.01215,          -2.23638,         -18.81024,          20.77095,

          -0.68592,          -2.26212,          -1.14065,          -0.76493,
          -0.18044,           0.15193,

          -0.20669,          -0.44387,           0.25697,          -0.17880,

          -0.53097,           0.43181,          -0.35187,           0.71934,

          -0.14962,           0.09220,          -0.05031,          -0.03924,

           0.06571,           0.29487,

           0.05170,           0.36847,

           0.02754,          -0.00411,

          -0.08313,          -0.16907,           0.10273,          -0.07315,

          -0.02312,           0.04912,

          -0.01062,          -0.02713,

           0.03806,           0.13401,

          -1.79865,          -2.04540,          -2.69965,          -0.65706,
          -1.17916,           0.79292,

           0.02415,           0.14001,

          -0.01767,           0.04209,

           0.05212,          -0.01795,

           0.01285,           0.04028,

           0.01075,           0.05533,

           0.02323,          -0.00864,

          -0.04691,           0.03128,

           0.00548,           0.02254,

           0.00011,           0.12033,

};
static double juptabb[] = {
         548.59659,         594.29629,         219.97664,          59.71822,
          23.62157,          40.77732,         227.07380,

           0.00293,          -0.00745,

        -307.33226,        -347.92807,        -309.49383,        -428.18929,
         -96.59506,        -191.36254,           2.11014,         -34.44145,
           2.23085,           6.77110,          -5.43468,          -0.28391,
           0.28355,          -1.81690,

           0.00036,           0.00078,

          -1.83259,           1.17464,          -2.66976,          -0.92339,
          -0.23645,          -1.20623,           0.25248,          -0.04958,
           0.00064,           0.03599,

          -0.00079,           0.00004,          -0.00005,          -0.00010,

          -0.00024,           0.00051,

           0.00001,           0.00005,

           0.00015,           0.00010,

           0.00017,          -0.00004,

           0.00113,          -0.00011,

           0.00021,           0.00087,

           0.00120,          -0.00114,          -0.00881,          -0.00020,

          -0.00005,           0.00009,

           0.00005,           0.00007,

           0.00002,          -0.00033,

          -0.00554,          -0.32274,           0.23695,          -0.11184,
           0.04050,           0.09929,          -0.02189,           0.00305,

          -0.00142,          -0.00055,

           0.66623,           0.34590,           0.74913,          -0.23202,
          -1.08316,          -1.40407,           1.72287,          -0.07604,

           0.00024,           0.00004,

           0.03592,           0.91143,          -1.11848,          -0.17473,
           0.91500,          -1.34912,           0.85229,           0.69029,

          -0.00019,           0.00075,

           0.03615,           0.30768,          -0.08733,           0.12016,
          -0.01716,          -0.01138,

           0.00021,           0.00004,

           0.00531,           0.00098,

          -0.14354,          -0.02364,          -0.05559,          -0.07561,
           0.01419,          -0.01141,           0.00014,           0.00218,

          -0.36564,           0.13498,          -0.13283,          -0.11462,
           0.23741,           0.14960,          -0.23173,           0.25148,
           0.00763,          -0.05987,

          -0.00857,           0.20312,          -0.29399,           0.34831,
          -1.33166,          -0.46808,

          -0.00027,           0.00046,

           0.15729,           0.01367,           0.04093,           0.07447,
          -0.01598,           0.00785,

           0.00583,           0.00324,           0.00053,           0.00160,

          -0.00030,           0.00043,

          -0.00208,           0.00334,          -0.00316,           0.00136,

           0.23086,           0.05711,           0.19558,           0.05897,
           0.01070,           0.05021,          -0.00818,          -0.02242,

           0.06301,          -0.26483,           0.66177,           0.02125,
           0.13477,           0.19376,

          -0.36520,           0.83588,          -0.69848,          -0.00877,
           0.01626,          -0.23878,

          -0.00373,           0.00044,

           0.00008,          -0.00004,

          -0.00374,          -0.00283,           0.01104,          -0.00619,

           0.00004,           0.00015,

           0.00026,           0.00013,

           0.04630,          -0.11815,           0.00773,           0.03796,
          -0.05172,           0.00149,           0.00444,          -0.01493,

          -0.00064,          -0.00044,

          -0.00033,           0.00002,

          -0.00012,           0.00284,

          -0.15622,          -0.92158,          -0.82690,          -1.52101,
          -0.55934,           0.69375,

          -0.00171,           0.00031,

           0.00129,          -0.00013,

          -0.00024,          -0.00083,

           0.66101,          -0.21764,          -0.43967,           0.30157,
           0.53389,           1.59141,           1.94286,           0.14146,

          -0.00064,          -0.00006,

           0.21850,          -0.02912,           0.08594,           0.08734,
          -0.01678,           0.01629,

           0.00133,           0.00562,

           0.00128,          -0.00025,

          -0.00005,           0.00027,

           0.00032,           0.00001,

           0.00037,           0.00042,

           0.00070,           0.00003,

           0.00275,          -0.13096,           0.02329,          -0.05582,
           0.00405,          -0.00251,

           0.01316,          -0.01165,           0.00279,          -0.00374,

         -39.62783,          20.91467,         -28.97236,           3.77560,
          -3.30029,           0.11472,          -0.48216,           1.05814,
          -0.21607,          -0.03055,

          -0.64162,          -0.57355,          -0.05861,          -0.18592,

          -0.12207,          -0.06279,

         -38.55325,        -125.74207,         -47.22357,          41.75842,
        -119.38841,          18.88515,         -11.04830,         -50.98851,
          16.64895,           1.76553,

           0.09474,           0.03714,

           0.02593,           0.07967,

       -1187.61854,       -1094.91786,       -1011.21939,       -1102.25998,
        -575.88672,        -107.84860,        -890.58889,        -807.06589,
         971.78461,       -1287.24560,       -4601.44669,        -849.54329,

          -0.00904,           0.06233,

          -0.19456,          -0.05521,

          -0.36915,           1.15363,

          32.64763,         -85.19705,         114.34437,         -13.37747,
          15.92865,          55.84857,         -13.10538,           3.07629,

          -0.00327,           0.00104,

          -7.81035,           6.19960,          -6.36096,           1.00493,
          -0.66971,          -0.84572,           0.09943,          -0.04583,

           0.00200,          -0.00032,

          -0.00265,           0.00047,

          -0.00053,           0.00046,

          -0.24396,           0.20664,          -0.30820,          -0.04917,
           0.06184,          -0.12642,           0.03053,           0.05054,

           0.00035,           0.00012,

           0.42063,          -0.58254,           0.90517,          -0.66276,
           0.64765,           0.39338,          -1.40645,           0.33017,
          -1.43377,          -0.67089,

          -0.00045,          -0.00036,

           0.23690,           0.07185,           0.28386,          -0.04397,
           0.02836,          -0.13082,          -0.00978,           0.00108,

           0.00046,           0.00083,

          -0.01665,           0.32499,          -0.09980,           0.18611,
          -0.02561,           0.00239,          -0.00084,          -0.00110,

           0.46854,          -0.35113,           0.69908,           0.53244,
           0.12875,           0.01115,

           0.13930,           0.02747,          -0.10587,          -0.17759,
          -0.26850,           0.04400,

           0.00010,          -0.00015,

           0.00164,          -0.01308,           0.00488,          -0.01046,
           0.00170,           0.00024,

           0.00084,           0.00014,

          -0.08481,          -0.02547,          -0.02290,          -0.02281,
          -0.03946,          -0.02810,

           0.01298,           0.08658,           0.05575,          -0.01081,
           1.09695,           0.35441,

          -0.03127,           0.07946,           0.01245,           0.02578,

          -0.00524,          -0.00027,

           0.08217,          -0.31742,           0.15273,          -0.07804,
           0.01197,           0.03053,

           0.81596,           0.38640,          -0.89777,           0.59499,
          -0.39581,          -0.87375,

           0.02096,           0.49772,           0.29986,           0.24210,
           0.14038,          -0.03016,

          -0.00208,           0.00045,

           0.01024,           0.00114,

           1.23010,           1.75663,          -0.12741,           1.44996,
          -0.31607,           0.03151,           0.00259,          -0.04741,

         -11.57091,           8.00331,          -9.24028,          -6.36906,
           4.71248,          -2.43695,           0.38630,           1.90625,

           0.01401,           0.00114,

          33.56690,         -55.17784,          33.21425,         -52.57002,
          27.04138,          13.78610,          69.60307,         -81.16312,
          27.53960,        -158.28336,        -205.94418,         -95.08051,

          -0.01407,          -0.00364,

         -18.56128,           6.02270,         -10.11059,          24.69471,
          12.31878,           9.94393,           3.81994,          -4.84109,
          -1.08440,          -0.72136,

           0.03731,          -0.02094,           0.00789,          -0.00176,

           0.09673,          -0.11181,           0.03112,          -0.00065,

          -0.29167,          -0.82083,           0.40866,          -0.77487,
          -2.23349,          -0.46973,

           0.41024,          -0.14274,           0.07755,          -0.24895,
          -0.04965,          -0.01197,

          -0.02264,           0.05917,          -0.02817,           0.01242,
          -0.00250,          -0.00247,

          -0.14414,          -0.03739,           0.14708,          -0.07908,
           0.05843,           0.15173,

          -0.01601,          -0.07844,          -0.05957,          -0.03143,
          -0.01830,           0.01257,

          -0.00109,          -0.00000,

           0.00174,           0.00050,

          -0.02119,           0.06918,          -0.02470,           0.00185,
           0.02372,          -0.02417,

           0.01081,           0.05222,           0.09820,           0.05931,

          -0.00588,          -0.00086,

           0.01688,          -0.00133,          -0.00073,           0.00041,

          -0.02280,          -0.05706,          -0.17694,          -0.12027,

           0.00196,          -0.00060,

           0.00051,          -0.02426,           0.00314,          -0.00302,

           0.17923,          -0.78343,           0.52073,          -0.02398,
          -0.03978,           0.20841,

           6.51325,           3.37139,          12.88844,          -6.72098,
           3.40949,         -14.34313,          -9.68278,          -7.85143,

           1.06886,          -0.21727,           0.36675,          -0.49815,
          -0.07289,          -0.07537,

           0.01107,          -0.00644,           0.01013,          -0.00306,

          -0.00708,          -0.13488,          -0.23041,          -0.10698,

          -0.00049,          -0.00692,          -0.00142,          -0.00211,

          -0.04021,           0.01805,

           0.00479,           0.00620,

           0.00739,           0.00566,

          -0.00101,          -0.00022,           0.00261,          -0.00188,

          -0.01812,          -0.01205,

          -0.00061,          -0.00061,

          -0.02479,           0.01157,

           0.91642,          -0.65781,           0.39969,          -1.13699,
          -0.43337,          -0.57828,

           0.00145,           0.00281,

          -0.01675,          -0.00975,

           0.00119,          -0.00074,

          -0.00343,           0.00139,

           0.00061,           0.00086,

           0.00054,          -0.00046,

          -0.01996,          -0.02689,

           0.00034,           0.00037,

          -0.00006,           0.00001,

};
static double juptabr[] = {
        -734.58857,       -1081.04460,        -551.65750,        -148.79782,
         -25.23171,         164.64781,         248.64813,

          -0.05163,          -0.02413,

       -1306.61004,         560.02437,       -1622.58047,         589.92513,
        -812.39674,         166.85340,        -157.92826,        -107.14755,
          68.98900,         -18.95875,          -0.16183,          36.24345,
          -9.19972,          -2.29315,

          -0.00316,           0.00222,

          10.95234,          21.37177,          -6.29550,          21.83656,
          -7.70755,           1.38228,          -0.21770,          -1.49525,
           0.17951,           0.01043,

           0.00062,           0.00208,          -0.00066,           0.00050,

           0.00313,           0.00187,

           0.00010,           0.00131,

           0.00102,           0.00047,

           0.00102,           0.00012,

           0.00012,          -0.00037,

           0.00808,           0.00027,

          -0.01219,          -0.00961,          -0.04166,          -0.00327,

          -0.00001,          -0.00146,

          -0.00092,          -0.00989,

          -0.00135,           0.00196,

           0.19216,           2.48442,          -1.43599,           1.39651,
          -0.48549,          -0.53272,           0.14066,          -0.10352,

           0.00141,           0.00066,

           2.96838,          -3.09575,           6.27741,           5.24306,
          -8.77080,           9.03247,         -10.98350,          -3.58579,

          -0.00168,          -0.00100,

           0.20234,          -0.75737,           0.36838,          -0.58241,
           0.41430,          -0.35784,           0.47038,          -0.10586,

           0.00539,           0.00490,

          -0.01375,          -0.01950,           0.00145,           0.00723,
          -0.00391,           0.00391,

          -0.00131,          -0.00568,

           0.01317,           0.00319,

           1.31006,           5.89394,          -1.61753,           3.68814,
          -0.80644,          -0.14747,           0.04481,          -0.11361,

          -4.36130,           7.92488,         -16.29047,          -1.52163,
           2.14492,         -14.38028,           9.65573,           3.56881,
          -1.87208,           3.36213,

           1.84499,          -2.41575,          -2.77076,          -3.23915,
          -3.34573,           1.40979,

           0.00217,          -0.00841,

           0.29313,          -0.36246,           0.22043,           0.02328,
          -0.01182,           0.04074,

          -0.15728,           0.02468,          -0.03185,          -0.01099,

           0.01059,          -0.01274,

           0.07362,          -0.02642,           0.04035,          -0.00968,

          -2.14457,           2.53297,          -4.34196,          -0.11421,
          -0.38757,          -1.73872,           0.39784,          -0.01397,

          -0.03311,           0.97723,           0.16060,          -0.07486,
          25.96413,           0.75088,

          -3.04736,           0.30340,          -1.43451,          -1.35136,
           0.26526,          -0.40247,

          -0.00460,          -0.00056,

           0.01633,          -0.00128,

          -0.05197,           0.07002,          -0.19450,           0.03737,

           0.00188,          -0.00037,

          -0.00903,          -0.00059,

         -19.73809,           0.58424,         -10.42034,         -10.14579,
           2.65990,          -3.07889,           0.50884,           0.58508,

          -0.00970,           0.02099,

           0.00716,           0.01161,

           0.05751,          -0.04515,

          22.08042,          30.82415,         -36.27430,          31.40265,
         -18.30150,         -29.16403,

           0.02454,           0.01834,

          -0.01312,           0.01576,

          -0.00928,           0.00330,

         -11.78094,           4.06738,          -2.51590,          15.05277,
           9.12747,           2.88088,           2.32916,          -2.08271,

           0.02872,           0.02194,

           0.60494,          -0.04597,           0.24749,           0.15971,
          -0.02185,           0.03384,

          -0.07075,           0.01287,

           0.40201,           0.00347,

          -0.00410,          -0.00998,

          -0.00005,          -0.00121,

           0.13770,           0.00186,

          -0.02268,           0.00210,

           1.26291,           0.65546,           0.38885,           0.38880,
          -0.00184,           0.03067,

           0.01273,           0.01136,           0.00557,           0.01117,

          94.13171,         -88.37882,         120.53292,           8.32903,
           7.77313,          43.46523,         -11.66698,           0.44639,
           0.15092,          -1.68367,

          -0.30833,          -0.49030,           0.01971,          -0.14144,

          -0.04019,          -0.05110,

         -39.70024,         272.91667,        -468.46263,         256.77696,
        -200.63130,        -307.98554,         206.56301,         -41.76039,
          -4.74242,          74.19909,

           0.18474,           0.05547,

          -0.06732,           0.16515,

       -1156.31285,       -1102.97666,       -1346.99288,       -1121.01090,
         666.84550,         421.92305,        2259.49740,       -2268.69758,
       -2325.87639,       -4476.46256,       -9683.77583,       -2472.92565,

          -0.10400,           0.08075,

          -0.45225,           0.16621,

           0.57789,           2.43804,

          85.21675,        -154.17208,         219.91042,          -9.71116,
          31.13240,         108.60117,         -25.85622,           8.98402,

          -0.00233,           0.01030,

         -17.01324,          10.41588,         -13.34449,           1.08782,
          -1.48199,          -1.81734,           0.20334,          -0.11734,

          -0.00230,          -0.01869,

          -0.01182,          -0.00129,

          -0.00281,           0.02021,

          -5.75973,          19.13309,         -16.13690,           5.53382,
          -1.96585,          -6.29211,           1.63105,          -0.26089,

           0.02935,          -0.00555,

           0.30700,         -19.96182,           0.99825,         -16.32664,
           0.83052,         -13.76201,          -3.15609,           0.17360,
        -111.81423,          -2.05419,

          -0.02455,          -0.00478,

           7.45114,          21.53296,          19.90263,           5.69420,
           2.31253,          -8.15116,          -2.17440,          -0.23014,

           0.00168,           0.01590,

           8.78005,           0.71418,           4.48561,           4.50680,
          -1.05713,           1.17880,          -0.19327,          -0.24877,

          -5.00870,          -8.66354,          10.51902,          -7.71011,
           4.65486,           8.05673,

          -1.39635,          -3.07669,          -2.40347,          -0.11167,
          -0.04064,           0.83512,

          -0.02041,          -0.00351,

           0.97375,          -0.15795,           0.36361,           0.19913,
          -0.02142,           0.04193,

           0.08801,           0.00475,

          -2.81010,           3.11341,          -2.79191,          -0.93313,
           0.44570,          -0.88287,

          -0.51815,           0.54776,           0.29736,           0.99779,
           2.28957,           0.82183,

           0.03386,           0.12855,           0.03124,           0.02454,

          -0.31958,           0.00070,

          -1.48184,          -1.28195,           0.03965,          -1.12026,
           0.23910,           0.01293,

           0.36146,          -0.64483,          -1.88470,           0.21469,
         -11.79819,          -1.87287,

           2.65699,          -0.36287,           0.88148,          -1.26883,
          -0.19657,          -0.14279,

          -0.07536,          -0.00004,

           0.01496,           0.00537,

           2.48352,           3.75581,          -0.34909,           3.26696,
          -0.82105,           0.11287,          -0.00755,          -0.13764,

         -15.34429,          -2.79957,          -3.22976,         -15.46084,
          10.66793,          -0.26054,          -0.12188,           5.06211,

           0.01313,           0.00424,

          84.34332,         -57.05646,          92.68150,          -0.02024,
         149.62698,          59.14407,         174.04569,        -129.26785,
         -55.99789,        -238.01484,        -212.51618,        -115.94914,

          -0.01720,          -0.00158,

         -13.65602,          17.47396,           0.16714,          32.66367,
          16.30095,           9.18345,           3.98555,          -5.39985,
          -1.09958,          -0.86072,

           0.02752,          -0.02474,           0.00671,          -0.00278,

          -0.21030,          -0.73658,           0.20708,          -0.21378,

           0.78462,          -2.14051,          -1.60070,          -2.60915,
          -5.02441,          -1.19246,

           0.67622,          -0.41889,           0.07430,          -0.53204,
          -0.11214,          -0.03417,

          -0.72636,          -0.15535,          -0.16815,          -0.35603,
           0.07530,          -0.02521,

          -0.01261,          -0.94883,           0.39930,          -0.05370,
          -2.77309,           0.38431,

           0.72127,          -0.52030,          -0.01804,          -0.51188,
          -0.11993,           0.02189,

           0.00928,          -0.02129,

          -0.02760,           0.00441,

          -0.56832,          -0.48114,           0.64192,          -0.65656,
           0.37483,           0.51883,

          -0.08474,           0.20324,           0.12783,           0.13041,

          -0.01545,          -0.00282,

          -0.16196,          -0.26980,           0.06584,          -0.09987,

          -0.36305,          -0.27610,          -0.57074,          -0.13607,

          -0.00824,           0.00369,

           0.06094,          -0.12214,           0.03581,          -0.00876,

           0.49346,          -0.74596,           0.47814,           0.18201,
          -1.00640,           0.24465,

          10.09808,           2.30496,          13.63359,          -7.94007,
           0.29792,         -13.55724,          -6.48556,          -5.99581,

           0.69686,          -0.22434,           0.23198,          -0.35579,
          -0.04736,          -0.05683,

           0.36710,          -0.16571,           0.14876,           0.21824,

          -0.18940,          -0.15063,          -0.23692,          -0.09990,

          -0.08923,          -0.12222,           0.02998,          -0.04560,

          -0.16229,           0.04552,

          -0.33051,           0.02585,

          -0.00622,           0.01583,

           0.15436,          -0.07109,           0.06429,           0.09218,

          -0.01277,          -0.00019,

           0.02345,          -0.01057,

          -0.07294,           0.02506,

           0.62063,          -0.52533,           0.16814,          -0.77168,
          -0.20614,          -0.31828,

          -0.12856,           0.01316,

          -0.01522,          -0.00126,

           0.01558,           0.04765,

          -0.02776,           0.01166,

          -0.05185,           0.00674,

           0.00754,           0.02183,

          -0.00645,          -0.01050,

          -0.02155,           0.00375,

           0.12040,          -0.00004,

};

static signed char jupargs[] = {
  0,  6,
  3,  2,  5, -6,  6,  3,  7,  0,
  2,  2,  5, -5,  6,  6,
  3,  1,  5, -2,  6, -3,  8,  0,
  2,  4,  5,-10,  6,  4,
  3,  2,  5, -4,  6, -3,  7,  1,
  3,  3,  5,-10,  6,  7,  7,  0,
  2,  6,  5,-15,  6,  0,
  3,  1,  5, -4,  6,  4,  7,  0,
  3,  3,  5, -8,  6,  2,  7,  0,
  3,  1,  5, -3,  6,  1,  7,  0,
  3,  1,  5, -3,  6,  2,  7,  0,
  1,  1,  7,  1,
  2,  5,  5,-12,  6,  0,
  3,  2,  5, -7,  6,  7,  7,  0,
  3,  1,  5, -1,  6, -3,  7,  0,
  2,  3,  5, -7,  6,  3,
  3,  1,  5, -4,  6,  3,  7,  0,
  2,  1,  5, -2,  6,  3,
  3,  3,  5, -8,  6,  3,  7,  0,
  2,  1,  5, -3,  6,  3,
  3,  1,  5, -3,  6,  3,  7,  0,
  2,  3,  5, -8,  6,  2,
  3,  2,  5, -5,  6,  2,  7,  0,
  1,  2,  7,  0,
  2,  4,  5, -9,  6,  3,
  2,  2,  5, -4,  6,  4,
  1,  1,  6,  2,
  3,  2,  5, -5,  6,  3,  7,  0,
  2,  2,  5, -6,  6,  2,
  2,  5,  5,-11,  6,  1,
  3,  1,  5, -2,  7, -2,  8,  0,
  2,  1,  5, -3,  7,  1,
  2,  3,  5, -6,  6,  3,
  2,  1,  5, -1,  6,  2,
  2,  1,  5, -4,  6,  2,
  2,  3,  5, -9,  6,  0,
  3,  2,  5, -4,  6,  2,  7,  0,
  2,  1,  5, -2,  7,  1,
  2,  6,  5,-13,  6,  0,
  3,  2,  5, -2,  6, -3,  7,  0,
  2,  4,  5, -8,  6,  3,
  2,  3,  6, -3,  7,  0,
  3,  6,  5,-14,  6,  3,  7,  0,
  3,  1,  5, -2,  7,  1,  8,  0,
  2,  2,  5, -3,  6,  2,
  3,  1,  5, -4,  7,  5,  8,  0,
  3,  2,  5, -8,  6,  3,  7,  0,
  3,  4,  5, -9,  6,  3,  7,  0,
  1,  2,  6,  3,
  3,  2,  5, -4,  6,  3,  7,  0,
  2,  2,  5, -7,  6,  2,
  2,  1,  5, -2,  8,  0,
  2,  1,  5, -1,  7,  0,
  3,  3,  5, -6,  6,  2,  7,  0,
  3,  4,  5, -8,  6,  2,  8,  0,
  2,  1,  5, -1,  8,  0,
  3,  2,  5, -3,  6,  1,  7,  0,
  2,  7,  5,-15,  6,  2,
  3,  3,  5, -4,  6, -3,  7,  1,
  2,  5,  5,-10,  6,  4,
  3,  1,  5,  1,  6, -3,  7,  1,
  3,  7,  5,-16,  6,  3,  7,  0,
  2,  3,  5, -5,  6,  4,
  3,  1,  5, -6,  6,  3,  7,  0,
  3,  5,  5,-11,  6,  3,  7,  0,
  1,  1,  5,  5,
  3,  3,  5,-11,  6,  3,  7,  0,
  3,  3,  5, -6,  6,  3,  7,  0,
  2,  2,  5, -7,  7,  0,
  2,  1,  5, -5,  6,  3,
  3,  1,  5, -1,  6,  3,  7,  0,
  2,  3,  5,-10,  6,  3,
  3,  2,  5, -3,  6,  2,  7,  0,
  2,  1,  5,  1,  7,  0,
  3,  2,  5, -1,  6, -3,  7,  0,
  2,  4,  5, -7,  6,  3,
  2,  4,  6, -3,  7,  0,
  2,  2,  5, -2,  6,  4,
  3,  4,  5, -8,  6,  3,  7,  0,
  1,  3,  6,  3,
  3,  2,  5, -3,  6,  3,  7,  0,
  2,  5,  5, -9,  6,  3,
  2,  3,  5, -4,  6,  2,
  2,  1,  5,  1,  6,  2,
  2,  2,  5, -4,  7,  0,
  2,  6,  5,-11,  6,  2,
  2,  2,  5, -3,  7,  0,
  2,  4,  5, -6,  6,  2,
  2,  2,  5, -1,  6,  2,
  1,  4,  6,  1,
  2,  2,  5, -2,  7,  0,
  2,  5,  5, -8,  6,  2,
  2,  3,  5, -3,  6,  2,
  2,  1,  5,  2,  6,  2,
  2,  2,  5, -2,  8,  0,
  2,  2,  5, -1,  7,  0,
  2,  6,  5,-10,  6,  3,
  2,  4,  5, -5,  6,  3,
  2,  6,  6, -3,  7,  0,
  1,  2,  5,  5,
  3,  4,  5, -6,  6,  3,  7,  0,
  1,  5,  6,  4,
  2,  2,  5,-10,  6,  1,
  2,  5,  5, -7,  6,  1,
  2,  3,  5, -2,  6,  2,
  2,  1,  5,  3,  6,  2,
  2,  6,  5, -9,  6,  2,
  2,  4,  5, -4,  6,  2,
  2,  2,  5,  1,  6,  2,
  2,  7,  5,-11,  6,  0,
  2,  3,  5, -3,  7,  0,
  2,  5,  5, -6,  6,  2,
  2,  3,  5, -1,  6,  1,
  2,  3,  5, -2,  7,  0,
  2,  6,  5, -8,  6,  1,
  2,  4,  5, -3,  6,  1,
  2,  2,  5,  2,  6,  0,
  2,  7,  5,-10,  6,  1,
  2,  5,  5, -5,  6,  2,
  1,  3,  5,  3,
  2,  1,  5,  5,  6,  2,
  2,  6,  5, -7,  6,  1,
  2,  4,  5, -2,  6,  1,
  2,  7,  5, -9,  6,  1,
  2,  5,  5, -4,  6,  0,
  2,  6,  5, -6,  6,  0,
  2,  4,  5, -1,  6,  0,
  2,  7,  5, -8,  6,  1,
  2,  5,  5, -3,  6,  0,
  2,  8,  5,-10,  6,  0,
  2,  6,  5, -5,  6,  0,
  1,  4,  5,  2,
  2,  7,  5, -7,  6,  0,
  2,  5,  5, -2,  6,  0,
  2,  8,  5, -9,  6,  0,
  2,  7,  5, -6,  6,  0,
  2,  8,  5, -8,  6,  0,
  2,  9,  5,-10,  6,  0,
  1,  5,  5,  0,
  2,  9,  5, -9,  6,  0,
  2,  1,  3, -1,  5,  0,
 -1
};
/* Total terms = 142, small = 140 */
static struct plantbl jup404 = {
  {  0,  0,  1,  0,  9, 16,  7,  5,  0,},
 6,
 jupargs,
 juptabl,
 juptabb,
 juptabr,
 5.2026032092000003e+00,
};

/*
First date in file = 625296.50
Number of records = 16731.0
Days per record = 131.0
      Julian Years      Lon    Lat    Rad
 -3000.0 to  -2499.7:   0.78   0.26   0.55 
 -2499.7 to  -1999.7:   0.66   0.19   0.57 
 -1999.7 to  -1499.7:   0.62   0.19   0.53 
 -1499.7 to   -999.8:   0.79   0.17   0.61 
  -999.8 to   -499.8:   0.78   0.15   0.42 
  -499.8 to      0.2:   0.75   0.19   0.52 
     0.2 to    500.2:   0.62   0.18   0.41 
   500.2 to   1000.1:   0.56   0.13   0.54 
  1000.1 to   1500.1:   0.53   0.15   0.41 
  1500.1 to   2000.1:   0.51   0.15   0.49 
  2000.1 to   2500.0:   0.52   0.13   0.41 
  2500.0 to   3000.0:   0.63   0.22   0.53 
  3000.0 to   3000.4:  0.047  0.073  0.086 
*/
static double sattabl[] = {
     1788381.26240,     2460423.68044,     1370113.15868,      415406.99187,
       72040.39885,       12669.58806,   439960754.85333,      180256.80433,

          18.71177,         -40.37092,

       66531.01889,     -195702.70142,       57188.02694,     -179110.60982,
      -19803.06520,      -58084.15705,       -9055.13344,      -31146.10779,
       11245.43286,       -3247.59575,         459.48670,        2912.82402,

          -4.06749,         -13.53763,

         -30.55598,          -4.51172,

           1.48832,           0.37139,

         597.35433,        1193.44545,        -297.50957,         976.38608,
        -263.26842,          34.84354,          -6.77785,         -29.92106,

          -0.16325,          -0.18346,

          -0.15364,          -0.08227,

           0.20180,           0.02244,

           0.04672,          -0.29867,

          -0.04143,          -0.00760,

          -0.17046,          -0.00778,

           0.04200,           0.23937,          -0.00098,          -0.05236,

          -0.02749,          -0.01813,

           0.00637,           0.01256,

          -0.04506,           0.04448,

          -0.00105,           0.06224,

           0.01157,           0.17057,          -0.03214,           0.18178,

          -0.22059,          -0.01472,

          -0.24213,           0.04309,           0.03436,           0.44873,

           0.01350,          -0.01931,

          -0.80618,          -0.56864,           0.29223,          -0.03101,

           0.04171,           0.02264,

          -0.01264,          -0.01645,

           0.01774,           0.06374,

          -0.01925,          -0.03552,

           0.10473,          -0.04119,

           0.08045,           0.04635,

          -3.01112,          -9.26158,           8.13745,           1.88838,

          -0.15184,           0.16898,

          -0.22091,           0.29070,          -0.03259,           0.06938,

          -0.08499,          -0.21688,           0.01848,          -0.05594,

           0.50100,          -0.00027,           0.13300,           0.12055,

           0.03039,           0.03854,

          -1.55287,           2.55618,          -0.45497,          -0.29895,
          -0.93268,           0.83518,

          -0.32785,           7.03878,          -1.66649,           2.75564,
          -0.29459,           0.01050,

           0.08293,          -0.03161,

          -0.12750,          -0.04359,

           0.04217,           0.07480,

        -114.43467,          49.47867,         -66.52340,         -26.27841,
          15.48190,         -13.06589,           3.28365,           5.02286,

          -0.17155,          -0.07404,

           0.00924,          -0.07407,

          -0.02922,           0.06184,

         108.04882,          86.09791,        -155.12793,         208.10044,
        -311.72810,        -268.92703,          74.57561,        -420.03057,

          -0.07893,           0.09246,

          -0.66033,          -0.39026,          -0.13816,          -0.08490,

         -36.79241,         -78.88254,          71.88167,         -68.05297,
          51.71616,          65.77970,         -43.59328,          23.51076,

          -0.02029,          -0.32943,

          -8.82754,           1.48646,          -3.12794,           2.12866,
          -0.06926,           0.44979,

           0.00621,          -0.51720,

          -3.82964,          -1.48596,          -0.11277,          -3.21677,
           0.81705,          -0.19487,

          -0.06195,           0.10005,          -0.02208,           0.00108,

           0.00455,          -0.03825,

           0.01217,          -0.00599,

          -0.17479,          -0.47290,           0.85469,           1.12548,
          -0.80648,          -0.44134,

          -0.01559,          -0.07061,

           0.01268,          -0.01773,

           0.01308,          -0.03461,

          -0.71114,           1.97680,          -0.78306,          -0.23052,
           0.94475,          -0.10743,

           0.18252,          -8.03174,

           0.00734,           0.04779,

           0.12334,          -0.03513,

           0.01341,           0.02461,

           0.02047,          -0.03454,

           0.02169,          -0.01921,

          -1.12789,           0.09304,           0.14585,           0.36365,

           0.03702,           0.10661,          -0.00464,          -1.72706,

          -0.00769,          -0.04635,

          -0.01157,           0.00099,

          10.92646,           1.96174,           2.91142,           4.74585,
          -0.29832,           0.75543,

           0.05411,           1.05850,

           0.38846,          -0.16265,

           1.52209,           0.12185,           0.18650,           0.35535,

        -278.33587,         -82.58648,        -160.00093,        -225.55776,
          35.17458,         -77.56672,          10.61975,           3.33907,

           0.06090,           2.17429,

          -4.32981,          -5.84246,          11.43116,          20.61395,

          -0.65772,           1.28796,

        1224.46687,       -3113.15508,        3798.33409,        -137.28735,
        -256.89302,        2227.35649,        -779.78215,        -260.37372,

          11.73617,         -13.25050,          -0.75248,          -2.87527,

          -8.38102,          17.21321,

      -61784.69616,       39475.02257,      -54086.68308,       54550.85490,
      -16403.69351,       29602.70098,       14672.06363,       16234.17489,
       15702.37109,      -22086.30300,      -22889.89844,       -1245.88352,

           1.48864,          19.75000,           0.78646,           3.29343,

       -1058.13125,        4095.02368,       -2793.78506,        1381.93282,
        -409.19381,        -772.54270,         161.67509,         -34.15910,

        -514.27437,          27.34222,        -311.04046,          48.01030,
         -43.36486,          16.19535,          -0.73816,          -0.81422,

         287.32231,        -110.44135,         200.43610,          37.98170,
          17.73719,          34.40023,          -2.46337,           1.48125,

           0.09042,          -0.11788,

           0.37284,           0.51725,           0.00597,           0.14590,

          -0.01536,           0.00980,

           0.00721,           0.02023,

           0.00027,           0.02451,

          -0.72448,          -0.71371,           0.29322,           0.18359,

           0.72719,          -0.37154,           0.14854,          -0.02530,

           0.23052,           0.04258,

           4.82082,           0.01885,           3.11279,          -0.63338,
           0.10559,          -0.02146,

          -0.01672,           0.03412,

           0.00605,           0.06415,

          -0.89085,           1.51929,          -0.36571,           0.39317,

          12.05250,          -3.79392,           3.96557,          -3.51272,
          -0.17953,          12.30669,

          -0.05083,          -0.11442,

           0.02013,          -0.02837,

          -0.02087,          -0.01599,

           0.49190,           0.30360,           0.01316,           0.17649,

           0.21193,          -0.09149,          -0.07173,          -0.05707,

           4.24196,          -1.25155,           1.81336,           0.68887,
          -0.01675,           0.20772,

          -0.04117,          -0.03531,

          -0.02690,          -0.02766,

          37.54264,          10.95327,           8.05610,          30.58210,
         -12.68257,           1.72831,           0.13466,          -3.27007,

           0.01864,          -0.00595,

           0.03676,           0.14857,          -0.07223,           0.06179,

           0.44878,          -1.64901,         -20.06001,           0.63384,
          -4.97849,           4.78627,          29.87370,           7.29899,

           0.00047,          -0.00155,

           0.00314,           0.01425,

          -0.17842,          -0.08461,

          -1.61020,          -8.47710,           6.85048,          -4.38196,
           1.05809,           2.68088,

          -0.01027,          -0.00833,

           0.06834,          -0.04205,

           0.03330,          -0.01271,

           0.01301,          -0.01358,

           0.03537,           0.03612,           0.02962,           0.62471,
          -0.30400,          -0.64857,

           0.01773,           0.01890,

           0.01426,          -0.00226,

          -0.50957,          -0.01955,          -0.09702,           1.09983,

           0.64387,          -0.02755,

           0.26604,           0.30684,           0.06354,           0.05114,

          -0.00058,          -0.04672,

          -0.00828,           0.00712,

          -0.00440,           0.00029,

          -0.01601,           0.03566,

           0.13398,          -0.02666,

          -0.06752,          -0.43044,           0.07172,          -0.01999,

          -0.01761,          -0.05357,

           0.06104,           0.29742,          -0.08785,           0.05241,

          -6.57162,          -4.20103,           0.03199,          -6.46187,
           1.32846,          -0.51137,

           0.06358,           0.37309,

          -1.46946,           2.34981,

          -0.18712,           0.11618,

         240.62965,        -107.21962,         219.81977,          84.04246,
         -62.22931,          68.35902,          -9.48460,         -32.62906,

           5.57483,          -1.82396,           1.00095,          -0.39774,

           7.87054,          11.45449,

        -432.67155,       55064.72398,       12444.62359,       54215.28871,
        8486.03749,       12297.48243,        -333.27968,        1147.93192,
        1403.73797,         990.40885,          -3.84938,        -722.43963,

          16.83276,          96.48787,           7.04834,          38.22208,
           0.63843,           2.61007,

         230.73221,         171.64166,           1.96751,         287.80846,
         -85.21762,          31.33649,          -2.25739,         -11.28441,

           0.04699,           0.06555,

          -0.08887,           1.70919,           0.09477,           0.26291,

          -0.15490,           0.16009,

           1.93274,           1.01953,           0.36380,           1.29582,
          -0.13911,           0.14169,

          -0.00491,          -0.00030,

          -0.08908,          -0.10216,

          -0.03265,          -0.03889,

           0.40413,          -1.12715,          -0.94687,          -0.04514,

           0.02487,          -0.01048,

           0.39729,           2.82305,          -0.61100,           1.11728,
          -0.13083,          -0.04965,

          -0.00602,          -0.02952,

          -6.13507,          13.73998,         -15.70559,          -1.28059,
           2.64422,          -9.33798,           3.26470,           1.56984,

          -0.00572,           0.09992,

          -8.80458,          -8.23890,         -11.51628,           9.47904,
          11.31646,           4.29587,

          -2.41367,          -0.05883,          -0.80022,          -1.02706,
           0.21461,          -0.06864,

           0.01882,           0.01798,

           0.27614,          -0.01007,           0.04362,           0.07560,
           0.05519,           0.23435,

          -0.09389,           0.01613,

           0.01298,           0.04691,

          -0.02665,          -0.03582,

           0.60080,          -4.28673,           1.87316,          -1.05840,
           0.13248,           0.40887,

          -0.67657,           0.67732,           0.05522,           0.07812,
          -0.17707,          -0.07510,

           0.24885,          10.63974,          -7.40226,          -2.33827,
           2.75463,         -32.51518,

           0.05140,           0.01555,

         180.43808,         263.28252,         384.50646,         -76.53434,
         -93.50706,        -220.50123,         -81.91610,         103.92061,
          30.90305,          -2.89292,

          -0.06634,          -0.37717,          -0.01945,          -0.05936,

          29.27877,         -59.73705,          35.86569,         -18.36556,
           3.88812,           4.82090,          -0.70903,           0.06615,

           0.01558,          -0.01854,

           0.16209,           0.12682,           0.02508,           0.02406,

          -0.03078,          -0.01737,          -0.00033,          -0.00020,

           0.01023,           0.05972,

          -0.03373,          -0.07289,

          -2.08162,          -0.14717,          -0.64233,          -0.75397,
           0.11752,          -0.09202,

           4.42981,          -4.19241,           5.02542,           5.03467,
          -4.22983,           2.80794,

           3.03016,          -2.74373,          -1.11490,          -2.72378,
          -0.63131,           0.74864,

          -0.00759,          -0.00675,

           0.03615,          -0.01806,

          -2.71920,          -1.50954,           0.54479,          -1.92088,
           0.66427,           0.32228,

          -2.55188,          -0.65332,          -2.73798,           2.10182,
           1.54407,           3.01357,

          38.76777,          23.54578,          27.29884,         -14.93005,
          -7.50931,          -5.66773,           0.30142,           1.52416,

           0.00634,           0.09697,          -0.00748,           0.01433,

           0.02936,           0.53228,          -0.03603,           0.06345,

           0.30816,          -1.07925,           0.46709,          -0.21568,
           0.01663,           0.10810,

          -0.42511,           0.35872,          -0.19662,          -6.74031,

           1.05776,           1.86205,           1.08919,           0.10483,
          -0.03368,          -0.21535,

           0.07556,          -0.27104,           0.05142,          -0.03812,

           1.20189,          -1.36782,           1.35764,           1.39387,
          -1.19124,           0.77347,

          -0.54760,          -0.26295,          -0.07473,           0.23043,

           2.82621,          -0.23524,           0.47352,          -0.81672,
          -0.08515,           0.04700,

           0.55355,          -0.40138,           0.22255,           0.12236,

          -0.09110,           0.31982,           0.39404,          -0.17898,

          -0.00056,           0.00014,

          -0.02012,           0.03102,

           0.43236,          -0.10037,          -0.00961,           0.07440,
          -0.07076,          -1.97272,

           0.25555,          -0.21832,          -0.00837,          -0.08393,

           0.01531,           0.00627,

           0.33193,           0.70765,          -0.43556,           0.28542,

          -0.23190,          -0.04293,          -0.08062,           0.13427,

           0.23763,          -0.17092,           0.09259,           0.05155,

           0.08065,          -0.11943,

          -0.02174,          -0.68899,

          -0.01875,          -0.01746,

           0.13604,           0.29280,          -0.17871,           0.11799,

           0.02003,           0.04065,

           0.01343,          -0.06060,

          -0.01290,          -0.26068,

          -0.09033,           0.02649,

          -0.00092,          -0.03094,

          -0.00770,          -0.10447,

          -0.04113,           0.01259,

          -0.00469,          -0.04346,

          -0.00010,           0.06547,

};
static double sattabb[] = {
     -567865.62548,     -796277.29029,     -410804.00791,      -91793.12562,
       -6268.13975,         398.64391,        -710.67442,         175.29456,

          -0.87260,           0.18444,

       -1314.88121,       20709.97394,       -1850.41481,       20670.34255,
        -896.96283,        6597.16433,        -179.80702,         613.45468,
          17.37823,         -13.62177,          -0.36348,          12.34740,

           0.47532,           0.48189,

           0.27162,          -0.20655,

          -0.23268,           0.05992,

          46.94511,          15.78836,          21.57439,          23.11342,
          -0.25862,           5.21410,          -0.22612,          -0.05822,

          -0.00439,          -0.01641,

          -0.01108,          -0.00608,

           0.00957,           0.00272,

          -0.00217,           0.00001,

          -0.00534,          -0.00545,

           0.00277,          -0.00843,

           0.00167,          -0.00794,           0.00032,          -0.00242,

          -0.00002,          -0.00041,

          -0.00025,           0.00031,

           0.00062,          -0.00060,

           0.00083,           0.00032,

           0.00527,          -0.00211,           0.00054,           0.00004,

          -0.02769,          -0.01777,

           0.00247,           0.00097,           0.00020,          -0.00232,

           0.00044,          -0.00035,

          -0.00072,           0.01341,           0.00325,          -0.01159,

           0.00079,          -0.00078,

          -0.00009,           0.00066,

           0.00222,           0.00002,

           0.00013,          -0.00161,

           0.01374,          -0.05305,

           0.00478,          -0.00283,

           0.16033,           0.13859,           0.33288,          -0.16932,

          -0.00316,           0.00625,

          -0.00309,           0.01687,           0.00001,           0.00486,

           0.00401,          -0.01805,          -0.00048,          -0.00407,

          -0.01329,           0.01311,          -0.00591,           0.00166,

           0.00830,           0.00665,

          -0.80207,           0.22994,          -0.34687,           0.08460,
          -0.11499,          -0.01449,

          -0.01574,           0.78813,          -0.03063,           0.28872,
          -0.00337,           0.01801,

          -0.01703,          -0.00929,

          -0.00738,           0.03938,

           0.05616,          -0.00516,

          -3.09497,          30.13091,          -3.14968,          17.62201,
          -0.73728,           2.46962,          -0.11233,           0.03450,

          -0.07837,          -0.01573,

          -0.01595,           0.00394,

           0.00174,           0.01470,

           6.83560,          -2.37594,           4.95125,           3.24711,
           2.44781,           5.17159,           1.99820,          -2.38419,

           0.00840,           0.03614,

          -0.00209,          -0.30407,          -0.02681,          -0.06128,

           1.50134,          11.82856,           4.39644,           6.98850,
          -4.17679,           5.73436,          -9.66087,           1.98221,

          -0.29755,           0.08019,

          -0.24766,          -8.54956,          -1.74494,          -3.36794,
          -0.32661,          -0.00722,

           0.14141,           0.01023,

          -1.21541,          -2.58470,           0.38983,          -1.70307,
           0.31209,          -0.10345,

           0.02593,           0.02178,           0.00289,           0.00393,

          -0.00236,          -0.00373,

          -0.00270,          -0.00049,

          -0.06282,          -0.00443,          -0.02439,          -0.02254,
          -0.02220,           0.03532,

          -0.00072,           0.00010,

          -0.00049,          -0.00112,

           0.00086,           0.00112,

           0.10135,          -0.10972,           0.08357,           0.00155,
           0.04363,          -0.00201,

          -0.01996,          -0.01341,

          -0.00039,          -0.00042,

          -0.00294,           0.00070,

           0.00005,          -0.00027,

           0.00070,          -0.00076,

           0.00234,          -0.00239,

          -0.08365,          -0.08531,          -0.03531,           0.15012,

          -0.01995,          -0.01731,          -0.00370,          -0.00745,

          -0.00315,          -0.00079,

          -0.00120,          -0.00145,

          -0.99404,          -1.31859,           0.03584,          -0.83421,
           0.10720,          -0.05768,

           0.06664,          -0.09338,

          -0.01814,          -0.00003,

          -0.05371,          -0.06458,          -0.00100,          -0.01298,

          -7.08710,         -23.13374,           4.18669,         -19.94756,
           4.85584,          -3.37187,           0.58851,           0.31363,

           0.01994,           0.27494,

          -1.37112,           2.61742,           0.52477,          -0.46520,

          -0.13183,           0.26777,

         836.90400,        -484.65861,         815.99098,         236.54649,
         -32.38814,         288.95705,         -68.17178,         -18.87875,

          -1.79782,          -3.68662,          -1.27310,          -0.65697,

          -3.67530,           2.10471,

      -13758.97795,        4807.62301,      -14582.14552,        9019.73021,
       -3202.60105,        4570.16895,        2078.68911,        2892.62326,
       -2399.35382,        3253.16198,       -8182.38152,       -3588.77680,

          -0.16505,           1.08603,           0.53388,           0.87152,

          61.53677,         538.43813,        -407.32927,         322.27446,
        -148.71585,        -179.37765,          54.07268,         -34.12281,

         -14.76569,         -17.95681,         -10.82061,          -6.39954,
          -2.10954,           0.67063,           0.22607,          -0.43648,

          20.90476,         -45.48667,          30.39436,         -14.20077,
           5.17385,           5.12726,          -0.66319,           0.55668,

           0.02269,          -0.00016,

           0.07811,           0.00111,           0.01603,           0.01020,

          -0.00107,           0.00494,

          -0.00077,          -0.00084,

          -0.00196,           0.00081,

          -0.03776,           0.01286,          -0.00652,          -0.01450,

           0.05942,          -0.08612,           0.01093,          -0.01644,

           0.02147,          -0.00592,

           0.36350,          -0.00201,           0.14419,          -0.10070,
          -0.00491,          -0.01771,

          -0.00053,          -0.00033,

           0.00146,           0.00048,

           0.00582,           0.04423,          -0.00549,           0.00983,

           0.27355,          -0.38057,           0.24001,          -0.05441,
          -0.07706,           0.14269,

          -0.00059,          -0.00154,

          -0.00013,          -0.00088,

          -0.00046,           0.00029,

          -0.00276,          -0.00507,           0.00075,          -0.00076,

           0.01806,           0.00862,          -0.00510,          -0.01364,

          -0.00029,          -0.12664,           0.03899,          -0.03562,
           0.00318,           0.00514,

           0.00057,           0.00201,

           0.00028,           0.00014,

          -0.47022,          -0.74561,           0.40155,          -0.16471,
          -0.18445,           0.34425,          -0.07464,          -0.13709,

          -0.01018,          -0.00748,

          -0.01210,          -0.04274,          -0.00579,          -0.00692,

         -11.09188,          -1.67755,          -6.62063,         -13.84023,
          12.75563,          -6.73501,           8.31662,           5.40196,

           0.00052,           0.00034,

           0.00128,           0.00085,

          -0.02202,          -0.00599,

          -0.33458,          -1.65852,           1.47003,          -1.02434,
           0.87885,           1.15334,

          -0.00241,          -0.00721,

           0.03154,           0.00612,

           0.00318,          -0.02521,

           0.00042,           0.00213,

          -0.01094,           0.05417,          -0.03989,          -0.00567,
           0.00123,          -0.00244,

           0.00108,           0.00242,

          -0.00138,          -0.00099,

           0.04967,           0.01643,          -0.00133,           0.02296,

           0.12207,           0.05584,

           0.00437,          -0.04432,          -0.00176,          -0.00922,

          -0.00252,           0.00326,

          -0.00020,          -0.00050,

          -0.00263,          -0.00084,

          -0.01971,           0.00297,

           0.03076,           0.01736,

          -0.01331,           0.01121,          -0.00675,           0.00340,

          -0.00256,           0.00327,

          -0.00946,           0.03377,          -0.00770,           0.00337,

           0.61383,           0.71128,          -0.02018,           0.62097,
          -0.07247,           0.04418,

          -0.02886,          -0.03848,

          -0.44062,           0.03973,

          -0.00999,          -0.04382,

          57.94459,         117.45112,         -71.22893,         126.39415,
         -62.33152,         -31.90754,          12.17738,         -16.46809,

          -1.13298,           0.08962,          -0.20532,           0.16320,

          -1.55110,          -1.44757,

       -3102.08749,       -7452.61957,       -5009.53858,       -7216.29165,
       -2476.87148,       -1880.58197,        -574.49433,         227.45615,
         144.50228,         379.15791,         225.36130,        -443.47371,

          -8.51989,          -3.75208,          -4.25415,          -1.59741,
          -0.43946,          -0.06595,

         150.42986,           6.54937,          87.67736,          92.32332,
         -21.97187,          29.87097,          -4.21636,          -5.72955,

          -0.03879,          -0.01071,

          -0.45985,           0.02679,          -0.02448,           0.02397,

          -0.06551,          -0.01154,

           1.97905,          -0.82292,           1.10140,           0.30924,
           0.03389,           0.14230,

           0.00003,           0.00119,

          -0.01117,           0.00665,

          -0.00132,          -0.00576,

          -0.08356,           0.08556,          -0.26362,          -0.12450,

           0.00509,           0.00165,

           0.02591,           0.16200,          -0.03318,           0.06463,
          -0.00899,          -0.00462,

           0.00102,           0.00004,

          -0.73102,           0.08299,          -0.52957,          -0.35744,
           0.14119,          -0.24903,           0.20843,           0.14143,

           0.00031,          -0.00234,

          -0.42643,          -2.02084,           1.58848,          -1.57963,
           0.68418,           2.07749,

          -0.45888,           0.19859,          -0.30277,          -0.22591,
           0.11607,          -0.09705,

           0.00040,           0.00431,

          -0.02683,           0.03158,          -0.01302,          -0.00541,
           0.01742,          -0.00006,

          -0.02231,          -0.01128,

          -0.00800,           0.02055,

          -0.00346,           0.00151,

           0.56732,          -0.68995,           0.27701,          -0.16748,
           0.01002,           0.00043,

           0.26916,          -0.57751,           0.15547,          -0.15825,
          -0.02074,          -0.07722,

          -8.23483,          -4.02022,           0.69327,          -5.91543,
           1.72440,           1.02090,

           0.00024,          -0.00053,

          20.03959,          14.79136,          76.43531,         -14.42019,
          -7.82608,         -69.96121,         -54.94229,          23.55140,
          26.60767,          14.68275,

           0.05118,          -0.10401,          -0.00075,          -0.01942,

          -3.84266,         -26.23442,          10.20395,         -14.77139,
           3.40853,           2.07297,          -0.53348,           0.40635,

           0.00716,          -0.00189,

           0.12472,          -0.02903,           0.02254,          -0.00183,

          -0.00175,          -0.01522,           0.00003,          -0.00339,

           0.00383,          -0.00168,

           0.01327,          -0.03657,

          -0.08458,          -0.00115,          -0.03991,          -0.02629,
           0.00243,          -0.00505,

           0.33875,          -0.16744,           0.05183,           0.01744,
          -0.24427,           0.15271,

           0.37550,          -0.17378,           0.09198,          -0.27966,
          -0.22160,           0.16426,

           0.00032,          -0.00310,

          -0.00022,          -0.00144,

          -0.06170,          -0.01195,          -0.00918,           0.02538,
           0.03602,           0.03414,

          -0.14998,          -0.44351,           0.45512,          -0.11766,
           0.35638,           0.27539,

           5.93405,          10.55777,          12.42596,          -1.82530,
          -2.36124,          -6.04176,          -0.98609,           1.67652,

          -0.09271,           0.03448,          -0.01951,           0.00108,

           0.33862,           0.21461,           0.02564,           0.06924,

           0.01126,          -0.01168,          -0.00829,          -0.00740,
           0.00106,          -0.00854,

          -0.08404,           0.02508,          -0.02722,          -0.06537,

           0.01662,           0.11454,           0.06747,           0.00742,
          -0.01975,          -0.02597,

          -0.00097,          -0.01154,           0.00164,          -0.00274,

           0.02954,          -0.05161,          -0.02162,          -0.02069,
          -0.06369,           0.03846,

           0.00219,          -0.01634,          -0.04518,           0.06696,

           1.21537,           0.99500,           0.68376,          -0.28709,
          -0.11397,          -0.06468,

           0.00607,          -0.00744,           0.01531,           0.00975,

          -0.03983,           0.02405,           0.07563,           0.00356,

          -0.00018,          -0.00009,

           0.00172,          -0.00331,

           0.01565,          -0.03466,          -0.00230,           0.00142,
          -0.00788,          -0.01019,

           0.01411,          -0.01456,          -0.00672,          -0.00543,

           0.00059,          -0.00011,

          -0.00661,          -0.00496,          -0.01986,           0.01271,

          -0.01323,          -0.00764,           0.00041,           0.01145,

           0.00378,          -0.00137,           0.00652,           0.00412,

           0.01946,          -0.00573,

          -0.00326,          -0.00257,

          -0.00225,           0.00090,

          -0.00292,          -0.00317,          -0.00719,           0.00468,

           0.00245,           0.00189,

           0.00565,          -0.00330,

          -0.00168,          -0.00047,

          -0.00256,           0.00220,

           0.00180,          -0.00162,

          -0.00085,          -0.00003,

          -0.00100,           0.00098,

          -0.00043,           0.00007,

          -0.00003,          -0.00013,

};
static double sattabr[] = {
      -38127.94034,      -48221.08524,      -20986.93487,       -3422.75861,
          -8.97362,          53.34259,        -404.15708,          -0.05434,

           0.46327,           0.16968,

        -387.16771,        -146.07622,         103.77956,          19.11054,
         -40.21762,         996.16803,        -702.22737,         246.36496,
         -63.89626,        -304.82756,          78.23653,          -2.58314,

          -0.11368,          -0.06541,

          -0.34321,           0.33039,

           0.05652,          -0.16493,

          67.44536,         -29.43578,          50.85074,          18.68861,
           0.39742,          13.64587,          -1.61284,           0.11482,

           0.01668,          -0.01182,

          -0.00386,           0.01025,

           0.00234,          -0.01530,

          -0.02569,          -0.00799,

          -0.00429,          -0.00217,

          -0.00672,           0.00650,

           0.01154,           0.00120,          -0.00515,           0.00125,

           0.00236,          -0.00216,

          -0.00098,           0.00009,

          -0.00460,          -0.00518,

           0.00600,           0.00003,

           0.00834,           0.00095,           0.01967,           0.00637,

          -0.00558,          -0.06911,

          -0.01344,          -0.06589,          -0.05425,          -0.00607,

          -0.00247,          -0.00266,

           0.08790,          -0.08537,          -0.00647,           0.04028,

          -0.00325,           0.00488,

           0.00111,          -0.00044,

          -0.00731,           0.00127,

          -0.00417,           0.00303,

           0.05261,           0.01858,

          -0.00807,           0.01195,

           1.26352,          -0.38591,          -0.34825,           1.10733,

          -0.02815,          -0.02148,

          -0.05083,          -0.04377,          -0.01206,          -0.00586,

           0.03158,          -0.01117,           0.00643,           0.00306,

          -0.01186,          -0.05161,           0.01136,          -0.00976,

          -0.00536,           0.01949,

          -1.41680,          -0.81290,          -0.09254,          -0.24347,
          -0.14831,          -0.34381,

          -2.44464,           0.41202,          -0.99240,          -0.33707,
          -0.01930,          -0.08473,

           0.00830,           0.01165,

          -0.01604,          -0.02439,

           0.00227,           0.04493,

         -42.75310,         -22.65155,          -9.93679,         -18.36179,
           2.73773,           3.24126,          -1.20698,           1.07731,

           0.00434,          -0.10360,

          -0.02359,           0.00054,

          -0.02664,          -0.00122,

         -19.79520,          33.11770,         -53.56452,         -35.41902,
          67.95039,         -82.46551,         117.31843,          14.08609,

           0.06447,           0.03289,

           0.40365,          -0.33397,           0.07079,          -0.09504,

         -30.36873,           6.23538,         -14.25988,         -44.91408,
          38.53146,         -16.31919,           6.99584,          22.47169,

          -0.13313,           0.28016,

           6.83715,          -6.01384,           1.68531,          -3.62443,
          -0.22469,          -0.29718,

           0.25169,           0.13780,

          -3.64824,           1.22420,          -2.48963,          -1.12515,
          -0.01510,          -0.56180,

          -0.03306,           0.01848,          -0.00103,          -0.00077,

          -0.01681,          -0.00227,

          -0.00402,          -0.00287,

           0.04965,          -0.16190,          -0.40025,           0.20734,
           0.15819,          -0.25451,

           0.02467,          -0.00495,

           0.00597,           0.00490,

          -0.01085,          -0.00460,

          -0.71564,          -0.26624,           0.03797,          -0.28263,
           0.03510,           0.30014,

           2.79810,           0.07258,

          -0.01618,           0.00337,

           0.00876,           0.04438,

           0.00742,          -0.00455,

          -0.01163,          -0.00683,

           0.00950,           0.01275,

          -0.02124,          -0.67527,          -0.23635,           0.06298,

          -0.03844,           0.01010,           0.73588,          -0.00271,

           0.01742,          -0.00467,

           0.00017,          -0.00505,

          -0.27482,           5.00521,          -1.92099,           1.55295,
          -0.35919,          -0.09314,

          -0.47002,           0.06826,

           0.07924,           0.16838,

          -0.04221,           0.71510,          -0.16482,           0.08809,

          41.76829,        -125.79427,         106.65271,         -71.30642,
          36.18112,          17.36143,          -1.63846,           5.02215,

          -1.08404,           0.00061,

           2.45567,          -2.42818,          -9.88756,           5.36587,

          -0.61253,          -0.35003,

        1523.54790,         602.82184,          68.66902,        1878.26100,
       -1098.78095,        -120.72600,         127.30918,        -383.96064,

          -7.00838,          -6.09942,          -1.54187,           0.34883,

          -9.47561,          -4.35408,

      -21541.63676,      -32542.09807,      -29720.82604,      -28072.21231,
      -15755.56255,       -8084.58657,       -8148.87315,        7434.89857,
       11033.30133,        7827.94658,         610.18256,      -11411.93624,

          -9.87426,           0.94865,          -1.63656,           0.41275,

        1996.57150,         511.48468,         669.78228,        1363.67610,
        -379.72037,         198.84438,         -16.63126,         -79.37624,

          -2.30776,        -246.07820,         -16.85846,        -148.18168,
          -6.89632,         -20.49587,           0.39892,          -0.34627,

         -57.81309,        -136.96971,          15.25671,         -96.61153,
          16.09785,          -8.79091,           0.70515,           1.16197,

           0.05647,           0.04684,

           0.25032,          -0.19951,           0.07282,          -0.00696,

           0.00493,           0.00733,

          -0.01085,           0.00422,

          -0.01309,           0.00262,

           0.37616,          -0.36203,          -0.11154,           0.18213,

           0.15691,           0.29343,           0.00485,           0.06106,

          -0.01492,           0.09954,

           0.28486,           2.27190,           0.33102,           1.50696,
          -0.01926,           0.04901,

           0.01827,           0.00863,

          -0.03315,           0.00178,

          -0.77600,          -0.48576,          -0.21111,          -0.19485,

           1.90295,           6.44856,           1.71638,           2.12980,
          -7.19585,          -0.08043,

           0.07004,          -0.02764,

           0.01604,           0.01158,

           0.00936,          -0.01199,

           0.18396,          -0.29234,           0.10422,          -0.00720,

           0.05196,           0.10753,           0.02859,          -0.03602,

           0.63828,           1.96280,          -0.31919,           0.85859,
          -0.10218,          -0.00673,

           0.01748,          -0.02190,

           0.01266,          -0.02729,

          -4.80220,           8.90557,          -5.94059,           2.28577,
          -0.19687,          -1.28666,           0.32398,           0.14879,

          -0.02619,          -0.02056,

          -0.04872,          -0.07011,          -0.04082,          -0.04740,

           0.60167,          -2.20365,          -0.27919,          -0.45957,
          -1.31664,          -2.22682,         176.89871,          13.03918,

           0.00568,           0.00560,

           0.01093,           0.00486,

          -0.00948,          -0.31272,

         -11.87638,          -3.68471,          -1.74977,          -9.60468,
           2.94988,          -0.57118,

           0.00307,          -0.01636,

           0.02624,           0.03032,

          -0.00464,          -0.01338,

           0.00935,           0.00530,

          -0.11822,           0.03328,          -0.41854,           0.04331,
           0.41340,          -0.21657,

          -0.00865,           0.00849,

          -0.00374,          -0.00899,

           0.01227,          -0.23462,          -0.71894,          -0.04515,

           0.00047,           0.28112,

          -0.12788,           0.11698,          -0.02030,           0.02759,

           0.02967,          -0.00092,

           0.00454,           0.00565,

          -0.00026,           0.00164,

          -0.01405,          -0.00862,

           0.01088,           0.05589,

           0.18248,          -0.06931,          -0.00011,           0.03713,

           0.01932,          -0.00982,

          -0.13861,           0.09853,          -0.03441,          -0.02492,

           2.26163,          -5.94453,           4.14361,          -0.94105,
           0.39561,           0.75414,

          -0.17642,           0.03724,

          -1.32978,          -0.56610,

          -0.03259,          -0.06752,

          39.07495,          80.25429,         -28.15558,          82.69851,
         -37.53894,         -17.88963,           6.98299,         -13.04691,

          -0.48675,          -1.84530,          -0.07985,          -0.33004,

          -3.39292,           2.73153,

      -17268.46134,        1144.22336,      -16658.48585,        5252.94094,
       -3461.47865,        2910.56452,        -433.49442,        -305.74268,
        -383.45023,         545.16136,         313.83376,          27.00533,

         -31.41075,           7.90570,         -12.40592,           3.01833,
          -0.83334,           0.23404,

          59.26487,        -112.74279,         113.29402,         -15.37579,
          14.03282,          32.74482,          -4.73299,           1.30224,

          -0.00866,           0.01232,

          -0.53797,           0.00238,          -0.07979,           0.04443,

          -0.05617,          -0.05396,

           0.10185,          -1.05476,           0.43791,          -0.32302,
           0.06465,           0.03815,

           0.00028,          -0.00446,

           0.09289,          -0.06389,

           0.01701,          -0.01409,

           0.47101,           0.16158,           0.01036,          -0.39836,

           0.00477,           0.01101,

          -2.06535,           0.33197,          -0.82468,          -0.41414,
           0.03209,          -0.09348,

           0.00843,          -0.00030,

          -9.49517,          -3.82206,           0.66899,         -10.28786,
           6.33435,           1.73684,          -0.98164,           2.25164,

          -0.07577,          -0.00277,

           1.02122,           0.75747,           1.79155,          -0.77789,
          -2.56780,          -2.07807,

           0.19528,           0.77118,          -0.28083,           0.32130,
          -0.04350,          -0.07428,

          -0.01161,           0.01387,

           0.02074,           0.19802,          -0.03600,           0.04922,
          -0.19837,           0.02572,

          -0.00682,          -0.04277,

          -0.01805,           0.00299,

           0.03283,          -0.02099,

           3.57307,           1.17468,           0.65769,           1.88181,
          -0.39215,           0.08415,

          -0.53635,          -0.19087,          -0.12456,           0.02176,
           0.01182,          -0.07941,

          -2.43731,           2.44464,           1.03961,          -1.81936,
          30.33140,           0.92645,

           0.00508,          -0.01771,

         -81.06338,          66.43957,          33.16729,         131.44697,
          76.63344,         -34.34324,         -35.33012,         -28.04413,
          -1.47440,          13.09015,

           0.13253,          -0.01629,           0.02187,          -0.00963,

         -21.47470,          -9.44332,          -7.21711,         -12.59472,
           1.76195,          -1.63911,           0.09060,           0.28656,

           0.00635,           0.00536,

           0.03470,          -0.06493,           0.00666,          -0.01084,

           0.01116,          -0.01612,          -0.00102,           0.00208,

          -0.05568,           0.00628,

           0.02665,          -0.01032,

           0.21261,          -1.90651,           0.72728,          -0.57788,
           0.08662,           0.10918,

           3.39133,           3.97302,          -4.63381,           4.26670,
          -2.50873,          -3.76064,

           1.28114,           1.81919,           1.48064,          -0.37578,
          -0.26209,          -0.47187,

           0.00282,          -0.00499,

           0.01749,           0.03222,

           1.60521,          -1.79705,           1.61453,           0.68886,
          -0.29909,           0.55025,

          -0.07894,           0.19880,          -0.15635,           0.46159,
           2.09769,           1.52742,

          -7.60312,          11.34886,           4.35640,           8.61048,
           2.15001,          -2.15303,          -0.61587,          -0.11950,

          -0.03289,          -0.00520,          -0.00501,          -0.00445,

           0.15294,          -0.05277,           0.02455,           0.00408,

           1.19601,           0.43479,           0.20422,           0.57125,
          -0.12790,           0.01318,

          -0.15275,          -0.43856,           6.99144,          -0.08794,

          -1.69865,           0.82589,          -0.20235,           0.97040,
           0.20903,           0.00675,

           0.26943,           0.08281,           0.03686,           0.05311,

           1.28468,           1.21735,          -1.38174,           1.29570,
          -0.75899,          -1.17168,

           0.44696,          -0.32341,          -0.06378,          -0.27573,

          -0.06406,           0.87186,           0.21069,           0.19724,
           0.00119,          -0.04147,

           0.39279,           0.51437,          -0.11035,           0.21450,

          -0.04309,           0.02359,           0.20490,           0.14210,

           0.00007,          -0.00017,

          -0.03529,          -0.02644,

           0.10710,           0.44476,          -0.02632,          -0.01817,
           2.11335,          -0.04432,

           0.18206,           0.27335,           0.08867,           0.00313,

          -0.00692,           0.01595,

          -0.72957,           0.32080,          -0.29291,          -0.44764,

           0.12767,          -0.05778,           0.04797,          -0.00223,

           0.17661,           0.22427,          -0.04914,           0.09114,

           0.12236,           0.00708,

           0.74315,          -0.01346,

           0.02245,          -0.02555,

          -0.30446,           0.13947,          -0.12340,          -0.18498,

          -0.04099,           0.02103,

           0.06337,          -0.01224,

           0.28181,          -0.01019,

          -0.02794,          -0.09412,

           0.03272,          -0.01095,

           0.11247,          -0.00650,

          -0.01319,          -0.04296,

           0.04653,          -0.00423,

           0.06535,           0.00014,

};

static signed char satargs[] = {
  0,  7,
  3,  2,  5, -6,  6,  3,  7,  0,
  2,  2,  5, -5,  6,  5,
  3,  1,  6, -4,  7,  2,  8,  0,
  2,  1,  6, -3,  7,  0,
  3,  1,  6, -2,  7, -2,  8,  0,
  2,  4,  5,-10,  6,  3,
  3,  1,  5, -1,  6, -4,  7,  0,
  3,  2,  5, -4,  6, -3,  7,  0,
  3,  2,  6, -8,  7,  4,  8,  0,
  3,  3,  5,-10,  6,  7,  7,  0,
  2,  6,  5,-15,  6,  0,
  2,  2,  6, -6,  7,  0,
  3,  1,  5, -4,  6,  4,  7,  1,
  3,  1,  5, -2,  6, -1,  7,  0,
  3,  2,  5, -5,  6,  1,  8,  0,
  3,  3,  5, -8,  6,  2,  7,  0,
  3,  1,  5, -3,  6,  2,  8,  0,
  3,  1,  5, -3,  6,  1,  7,  1,
  1,  1,  8,  0,
  3,  1,  5, -3,  6,  2,  7,  1,
  3,  1,  5, -2,  6, -2,  7,  0,
  2,  2,  6, -5,  7,  1,
  3,  2,  6, -6,  7,  2,  8,  0,
  3,  2,  6, -7,  7,  4,  8,  0,
  3,  2,  5, -4,  6, -2,  7,  0,
  3,  1,  5, -1,  6, -5,  7,  0,
  3,  2,  6, -7,  7,  5,  8,  0,
  3,  1,  6, -1,  7, -2,  8,  0,
  2,  1,  6, -2,  7,  1,
  3,  1,  6, -3,  7,  2,  8,  0,
  3,  1,  6, -4,  7,  4,  8,  1,
  3,  2,  5, -5,  6,  2,  8,  1,
  3,  2,  5, -6,  6,  2,  7,  1,
  2,  2,  7, -2,  8,  0,
  1,  1,  7,  2,
  2,  5,  5,-12,  6,  2,
  3,  2,  6, -5,  7,  1,  8,  0,
  3,  1,  5, -1,  6, -3,  7,  0,
  3,  7,  5,-18,  6,  3,  7,  0,
  2,  3,  5, -7,  6,  3,
  3,  1,  6,  1,  7, -5,  8,  0,
  3,  1,  5, -4,  6,  3,  7,  0,
  3,  5,  5,-13,  6,  3,  7,  0,
  2,  1,  5, -2,  6,  3,
  3,  3,  5, -9,  6,  3,  7,  0,
  3,  3,  5, -8,  6,  3,  7,  1,
  2,  1,  5, -3,  6,  3,
  3,  5,  5,-14,  6,  3,  7,  0,
  3,  1,  5, -3,  6,  3,  7,  2,
  2,  3,  6, -7,  7,  0,
  2,  3,  5, -8,  6,  2,
  3,  2,  5, -3,  6, -4,  7,  1,
  3,  2,  5, -8,  6,  7,  7,  0,
  2,  5,  5,-13,  6,  0,
  2,  2,  6, -4,  7,  2,
  3,  2,  6, -5,  7,  2,  8,  0,
  3,  2,  5, -4,  6, -1,  7,  0,
  3,  2,  5, -7,  6,  4,  7,  0,
  2,  1,  6, -2,  8,  2,
  2,  1,  6, -1,  7,  0,
  3,  1,  6, -2,  7,  2,  8,  0,
  3,  2,  5, -5,  6,  2,  7,  0,
  3,  2,  5, -6,  6,  2,  8,  0,
  3,  2,  5, -6,  6,  1,  7,  0,
  2,  3,  7, -2,  8,  0,
  1,  2,  7,  1,
  2,  1,  6, -1,  8,  1,
  3,  1,  5, -2,  6,  1,  7,  0,
  3,  1,  5, -2,  6,  2,  8,  0,
  2,  3,  6, -6,  7,  2,
  2,  6,  5,-14,  6,  0,
  3,  3,  6, -7,  7,  2,  8,  0,
  3,  2,  5, -3,  6, -3,  7,  1,
  2,  4,  5, -9,  6,  3,
  3,  2,  6, -2,  7, -2,  8,  0,
  2,  2,  6, -3,  7,  1,
  3,  2,  6, -4,  7,  2,  8,  0,
  2,  2,  5, -4,  6,  3,
  3,  2,  5, -7,  6,  3,  7,  1,
  3,  1,  6,  1,  7, -2,  8,  0,
  1,  1,  6,  5,
  3,  2,  5, -5,  6,  3,  7,  1,
  2,  2,  5, -6,  6,  3,
  1,  3,  7,  3,
  2,  4,  5,-11,  6,  3,
  2,  1,  5, -4,  7,  0,
  3,  2,  5, -5,  6, -3,  7,  1,
  2,  6,  5,-16,  6,  0,
  3,  3,  5, -7,  6,  2,  7,  0,
  3,  3,  6, -4,  7, -2,  8,  0,
  2,  3,  6, -5,  7,  1,
  3,  3,  6, -6,  7,  2,  8,  1,
  3,  3,  6, -7,  7,  4,  8,  0,
  3,  2,  5, -3,  6, -2,  7,  2,
  3,  2,  5, -8,  6,  5,  7,  0,
  2,  2,  6, -4,  8,  0,
  3,  2,  6, -1,  7, -2,  8,  1,
  2,  2,  6, -2,  7,  2,
  3,  2,  6, -3,  7,  2,  8,  0,
  3,  2,  5, -4,  6,  1,  7,  0,
  3,  2,  5, -4,  6,  2,  8,  0,
  3,  2,  5, -7,  6,  2,  7,  1,
  2,  1,  6,  1,  7,  1,
  2,  5,  5,-11,  6,  2,
  3,  1,  5, -2,  7, -2,  8,  0,
  2,  1,  5, -3,  7,  0,
  2,  3,  5, -6,  6,  3,
  3,  2,  6,  1,  7, -5,  8,  0,
  2,  2,  6, -3,  8,  1,
  2,  1,  5, -1,  6,  3,
  3,  2,  5, -7,  6,  3,  8,  0,
  3,  3,  5, -7,  6,  3,  7,  0,
  3,  2,  5, -1,  6, -7,  7,  0,
  2,  1,  5, -4,  6,  2,
  3,  1,  5, -2,  6,  3,  7,  0,
  2,  4,  6, -7,  7,  0,
  2,  3,  5, -9,  6,  0,
  3,  2,  5, -2,  6, -4,  7,  0,
  2,  3,  6, -4,  7,  2,
  3,  2,  5, -3,  6, -1,  7,  0,
  3,  2,  5, -8,  6,  4,  7,  0,
  2,  2,  6, -2,  8,  1,
  2,  2,  6, -1,  7,  0,
  3,  2,  6, -2,  7,  2,  8,  1,
  3,  2,  5, -4,  6,  2,  7,  0,
  3,  2,  5, -7,  6,  2,  8,  0,
  3,  2,  5, -7,  6,  1,  7,  0,
  2,  1,  6,  2,  7,  0,
  2,  2,  6, -1,  8,  0,
  2,  4,  6, -6,  7,  1,
  2,  6,  5,-13,  6,  0,
  3,  2,  5, -2,  6, -3,  7,  1,
  2,  4,  5, -8,  6,  2,
  3,  3,  6, -2,  7, -2,  8,  0,
  2,  3,  6, -3,  7,  0,
  3,  3,  6, -4,  7,  2,  8,  0,
  2,  2,  5, -3,  6,  3,
  3,  2,  5, -8,  6,  3,  7,  1,
  3,  2,  6,  1,  7, -2,  8,  0,
  1,  2,  6,  5,
  3,  2,  5, -4,  6,  3,  7,  2,
  2,  2,  5, -7,  6,  3,
  3,  1,  6,  4,  7, -2,  8,  0,
  2,  1,  6,  3,  7,  1,
  3,  1,  6,  2,  7,  2,  8,  0,
  2,  4,  5,-12,  6,  2,
  2,  5,  6, -8,  7,  0,
  2,  4,  6, -5,  7,  0,
  3,  2,  5, -2,  6, -2,  7,  0,
  2,  3,  6, -2,  7,  1,
  3,  3,  6, -3,  7,  2,  8,  0,
  2,  5,  5,-10,  6,  2,
  3,  1,  5,  1,  6, -3,  7,  0,
  2,  3,  5, -5,  6,  3,
  2,  3,  6, -3,  8,  0,
  1,  1,  5,  2,
  2,  1,  5, -5,  6,  2,
  2,  5,  6, -7,  7,  0,
  2,  4,  6, -4,  7,  2,
  2,  3,  6, -2,  8,  0,
  2,  3,  6, -1,  7,  0,
  2,  5,  6, -6,  7,  0,
  2,  4,  5, -7,  6,  2,
  2,  4,  6, -3,  7,  2,
  2,  2,  5, -2,  6,  2,
  3,  2,  6, -9,  7,  3,  8,  0,
  1,  3,  6,  4,
  3,  2,  5, -3,  6,  3,  7,  1,
  2,  2,  5, -8,  6,  3,
  3,  2,  6,  4,  7, -2,  8,  0,
  2,  4,  5,-13,  6,  1,
  2,  6,  6, -8,  7,  1,
  2,  5,  6, -5,  7,  0,
  2,  4,  6, -2,  7,  0,
  2,  5,  5, -9,  6,  2,
  2,  3,  5, -4,  6,  2,
  2,  1,  5,  1,  6,  2,
  2,  6,  5,-11,  6,  0,
  3,  6,  6, -7,  7,  2,  8,  0,
  2,  4,  5, -6,  6,  2,
  2,  2,  5, -1,  6,  2,
  1,  4,  6,  3,
  3,  2,  5, -2,  6,  3,  7,  1,
  2,  2,  5, -9,  6,  1,
  2,  5,  5, -8,  6,  2,
  2,  3,  5, -3,  6,  1,
  2,  1,  5,  2,  6,  2,
  2,  6,  5,-10,  6,  1,
  2,  4,  5, -5,  6,  2,
  1,  2,  5,  1,
  1,  5,  6,  2,
  2,  5,  5, -7,  6,  1,
  2,  3,  5, -2,  6,  1,
  3,  1,  5,  2,  6,  3,  7,  0,
  2,  6,  5, -9,  6,  0,
  2,  4,  5, -4,  6,  2,
  2,  2,  5,  1,  6,  1,
  2,  7,  5,-11,  6,  0,
  2,  5,  5, -6,  6,  1,
  2,  3,  5, -1,  6,  1,
  2,  6,  5, -8,  6,  1,
  2,  4,  5, -3,  6,  0,
  2,  5,  5, -5,  6,  0,
  1,  3,  5,  0,
  2,  6,  5, -7,  6,  1,
  2,  7,  5, -9,  6,  0,
  2,  5,  5, -4,  6,  0,
  2,  6,  5, -6,  6,  0,
  2,  7,  5, -8,  6,  0,
  2,  6,  5, -5,  6,  0,
  2,  7,  5, -7,  6,  0,
  2,  8,  5, -9,  6,  0,
  2,  8,  5, -8,  6,  0,
  2,  1,  3, -1,  6,  0,
 -1
};
/* Total terms = 215, small = 211 */
static struct plantbl sat404 = {
  {  0,  0,  1,  0,  8, 18,  9,  5,  0,},
 7,
 satargs,
 sattabl,
 sattabb,
 sattabr,
 9.5575813548599999e+00,
};

/*
First date in file = 625296.50
Number of records = 16731.0
Days per record = 131.0
      Julian Years      Lon    Lat    Rad
 -3000.0 to  -2499.7:   0.35   0.06   0.42 
 -2499.7 to  -1999.7:   0.50   0.06   0.38 
 -1999.7 to  -1499.7:   0.39   0.07   0.34 
 -1499.7 to   -999.8:   0.34   0.06   0.30 
  -999.8 to   -499.8:   0.35   0.05   0.32 
  -499.8 to      0.2:   0.32   0.05   0.27 
     0.2 to    500.2:   0.26   0.04   0.25 
   500.2 to   1000.1:   0.28   0.04   0.25 
  1000.1 to   1500.1:   0.26   0.06   0.31 
  1500.1 to   2000.1:   0.33   0.05   0.24 
  2000.1 to   2500.0:   0.32   0.06   0.26 
  2500.0 to   3000.0:   0.34   0.06   0.32 
  3000.0 to   3000.4:  0.406  0.035  0.172 
*/
static double uratabl[] = {
          21.56000,       -4652.06828,   154246324.90417,     1130486.05080,

         330.11531,       -3020.20235,

          -8.03769,        -122.02019,

         212.45130,         254.23866,          25.39758,          60.08296,

        6949.85053,       51951.42606,       -1834.66531,       44481.91144,
       -3267.45825,       10776.65972,        -628.05388,         532.83011,
         -16.80583,         -30.05544,

        1420.33767,        2007.21040,         592.32842,        1541.61732,
        -163.55984,         121.14134,         114.74969,         -16.04944,

           0.06069,           0.00725,

          -0.16861,           0.28785,

           0.07399,          -0.09680,

           0.19936,          -0.41620,

           0.02922,           0.07398,

           0.17272,           0.05602,

           1.65461,          -0.68278,          -2.18745,          -0.85327,
           0.52467,          -0.30863,

           0.01598,           0.30017,

          -0.04190,          -0.03288,

          -0.02013,           0.02257,

          -0.54883,          -0.22701,          -0.09257,          -0.03921,

           0.02644,           0.04667,

           0.24773,          -0.16562,

       44242.85814,     -223163.54065,      123776.84417,     -206375.74884,
       70472.73820,      -27456.55173,        4065.74401,       13202.39154,
       -3260.72648,         802.50579,        -153.13236,        -503.81026,
          30.17812,         -31.91893,

         -65.14719,          77.78417,         -37.38185,          19.13337,
          -3.14043,          -0.21147,

           0.27143,           0.17424,

           0.04458,           0.10976,

          -0.41841,          -0.21887,          -0.09194,          -0.02303,

           0.02896,           0.10044,

           0.01385,           0.01723,

          -0.01126,          -0.09318,

         -57.95890,          29.69059,         -46.41390,           3.07177,
           0.42494,           2.33678,          -3.09621,           0.05256,

          -0.02134,          -0.35202,

          -0.44475,          -0.83135,

        1318.18265,       25605.86848,       -9168.38371,       18917.31507,
       -5145.74480,        2130.77612,        -485.25920,        -438.44867,
          19.97802,         -33.14800,

      -23383.91826,      -45133.19122,      -18520.80729,      -26549.95198,
       -2276.70124,       -2974.01604,         603.23665,         306.87616,
         -87.73070,         -32.49134,

      549975.14525,      261920.31896,      526261.09735,      362619.26839,
      150616.68873,      164643.90808,        9550.02662,       27381.83042,
       -1065.89047,        1024.20231,         -66.63822,         -44.75169,

         -92.10532,         -20.26930,

     -313205.95341,     1462242.64616,      112982.53079,     1865690.41965,
      308844.30901,      639864.93227,       89716.32843,       10378.80773,
        4395.08428,      -14565.35913,       -3016.07754,      -19348.64612,

        3838.36899,       -9813.42713,        6883.58821,       -6064.92588,
        2740.47455,        -176.29547,         241.91895,         268.44181,
          -6.13397,          17.92503,

          -0.01377,          -0.08742,

         387.51915,         257.03872,         152.81792,         221.56197,
         -22.94836,          29.56640,          -2.27801,           4.72805,
          -6.03420,          -0.36763,

           0.00667,           0.00443,

          -0.01405,           0.04658,

          -0.06533,          -0.01966,

           0.10738,           0.00443,

           0.02889,           0.01056,

           0.00900,          -0.02206,

           0.00013,           0.05281,

           0.03035,           0.34793,

           0.19460,           2.47360,

           0.18189,          -0.83895,           0.24983,          15.32050,

           0.46010,           2.79643,

          -0.45793,           0.96707,          -0.31226,           0.51911,
           0.04071,           0.39399,

           0.00038,           0.03854,

           0.22446,           0.13630,          -0.04357,           0.03635,

           0.00202,          -0.04502,

          -0.00458,          -0.03884,

           1.32597,           3.40849,          -1.67839,          -0.95411,

          -1.00116,          -0.72744,          -0.22484,          -0.27682,

          -0.18069,           0.00405,

          -0.01000,           0.27523,

          -0.07038,          -0.01051,

          -0.09064,           0.08518,

           0.02083,          -0.25406,

           0.17745,          -0.00944,

           0.21326,           0.20454,

          18.84894,          -7.64400,           0.62670,         -11.02728,
           8.91329,          20.67190,

           0.17757,          -0.15471,

          -0.11385,          -0.46057,

           6.23014,         -14.46025,           2.30012,          -2.22677,

           5.16823,          -1.64235,

        -274.58413,         833.33247,        -191.26241,         269.90157,
         -17.25965,           9.11368,

        -261.65136,      -18274.45858,       -2553.83872,      -10039.10490,
        -508.52567,         336.18172,          14.88587,         421.35954,
         162.43462,         544.92580,

          -0.44246,           0.23216,

          -0.29024,          -0.13057,

          -1.58438,           0.34032,          -0.31604,          -0.01166,

          -0.07112,           0.05721,

          -0.10813,           0.01064,

          -0.05413,           0.06705,

          -0.41582,          -0.47725,           0.31031,           0.08605,

           0.00409,           0.02373,

           0.08092,           0.06247,          -0.01026,           0.05863,

          -0.00238,           0.02948,

           0.00117,           0.02714,

           0.01720,           0.18261,

          -0.04067,           0.88639,

          -0.15502,          -0.96383,

          -0.05307,          -0.17319,

          -0.00486,          -0.02373,

          -0.14748,          -0.11884,           0.07798,          -0.00358,

           0.01104,           0.00805,

           0.15099,          -0.03453,           0.01846,           0.03459,

           0.02197,           0.07012,

          -0.43677,          -1.87445,           1.35202,           2.28294,

          -0.03592,           0.07679,

           0.16427,           0.03014,           0.02472,           0.05549,

          -0.04985,           0.05874,

           0.35361,           0.01144,          -0.57400,           1.34898,

           0.00265,           0.01540,

           0.00951,           0.08159,

          -0.00435,           0.34759,

          -0.12413,          -0.49848,

          -0.77075,          -2.73810,

         -31.77702,          12.16042,         -14.87605,          11.98287,
          12.69358,           1.31307,          -8.22911,         -21.47437,

          -0.24051,          -0.38332,

          -0.01162,          -0.03175,

           0.00556,           0.02454,

          -0.02297,          -0.01654,

           0.00707,           0.04828,

          -0.00309,           0.17381,

          -0.00500,          -0.07579,

           0.02008,           0.05356,

           0.00702,           0.01133,

          -0.00237,          -0.00612,

           0.18551,           0.22799,          -0.14194,          -0.08593,

           0.00002,          -0.01049,

          -0.17363,          -0.13986,           0.00078,          -0.06993,

          -0.00430,          -0.07795,

          -0.03232,          -4.13170,

           0.00311,           0.05356,

          -0.17324,          -0.15505,          -0.00590,          -0.06608,

           0.04257,          -0.04571,

           0.00501,           0.02141,

          -0.00037,           0.07845,

          -0.00381,          -0.03417,

           0.01834,           0.03349,

           0.07994,           0.15297,

          -0.82299,           0.24672,           0.51764,           0.96379,

           0.01729,           0.02489,

          -0.08581,           0.13252,

           0.00538,           0.01995,

          -0.00148,          -0.02261,

           0.00534,           0.01565,

          -0.07518,          -0.28114,           0.22386,           0.39023,

          -0.00864,           0.00964,

          -0.01923,          -0.02426,

          -0.00112,           0.00923,

          -0.00685,           0.02450,

           0.26733,          -0.99972,          -0.82005,           0.13725,

           0.01520,          -0.00790,

           0.00358,           0.00751,

          -0.00648,          -0.00605,

          -0.04966,          -0.04633,

           0.06394,          -0.01965,

           0.50185,           0.40553,          -0.25809,           0.28853,
           0.52545,          -3.41675,

          -0.00347,          -0.11848,

           0.02945,          -0.01061,

          -0.04160,          -0.03519,

          -0.03234,          -0.81852,

          -0.02156,          -0.00841,

           0.00029,           0.00020,

          -0.02281,          -0.00364,

           0.04738,          -0.04504,

          -0.19161,           0.37225,           0.05765,           0.11987,

           0.00050,           0.02012,

          -0.03806,           0.39498,

           0.29982,           0.00886,           0.01671,          53.04042,

          -0.04160,          -0.38856,

          -0.00174,          -0.01773,

          -0.47661,          -0.32010,          -0.01088,          -0.16231,

          -0.01584,          -0.00144,

           0.06659,           0.12734,

           0.04884,           0.02236,

           0.00146,           0.06030,

          -0.20660,          -0.03982,           0.15091,           1.24562,

          -0.01303,          -0.22426,

          -0.01518,          -0.03922,

          -0.00043,          -0.00047,

           0.02451,           0.04437,

           0.02380,          -0.00189,

          -0.00640,          -0.07114,

          -0.00320,          -0.02491,

          -0.00829,           0.07284,

           0.02846,          -0.28034,

          -0.00268,           0.00256,

          -0.43420,           0.39645,          -0.31053,           1.25916,

          -0.00371,          -0.00651,

          -0.00096,           0.02762,

          -0.00067,          -0.02503,

          -0.01517,           0.03748,

};
static double uratabb[] = {
           0.00000,         107.91527,          83.39404,        -124.29804,

          -7.73277,          -3.99442,

          -0.08328,          -1.74251,

          -9.05659,         -22.88559,          -2.30655,          -4.40259,

        -470.94604,       -3648.43408,         326.28960,       -2972.91303,
         337.37285,        -650.33570,          57.18479,         -18.29130,
           1.13897,           2.70158,

         -13.64388,         -71.88619,           7.36408,         -43.79994,
           6.57463,          -5.81111,          -0.06451,           0.73379,

           0.00574,          -0.01635,

           0.00074,          -0.01496,

          -0.00418,           0.00647,

          -0.00407,           0.00548,

           0.00002,           0.00187,

          -0.00591,           0.00557,

           0.32568,          -0.01574,           0.19347,          -0.01705,
           0.00173,           0.02384,

          -0.00248,          -0.00103,

           0.00227,           0.00146,

           0.00307,          -0.00040,

           0.03886,           0.01987,           0.00546,           0.00345,

           0.00134,          -0.00609,

          -0.01502,          -0.01569,

      -10080.59325,       10806.67752,      -14013.76861,        9928.38683,
       -6540.83480,        2084.91597,       -1093.05006,        -305.34266,
          -9.04558,        -110.32310,           9.26094,          -3.93195,
           0.25552,           0.50327,

         -13.12170,          -4.19317,          -4.50857,          -3.37626,
          -0.26850,          -0.36028,

          -0.00357,           0.05862,

          -0.00828,           0.00926,

          -0.01515,          -0.03687,          -0.00224,          -0.00802,

          -0.00225,          -0.00158,

          -0.00022,          -0.00044,

          -0.00281,           0.00371,

           2.28259,          -4.29888,           1.74622,          -2.13604,
           0.37023,          -0.37022,           0.00886,           0.07081,

           0.01669,           0.00056,

          -0.02020,           0.01586,

       -4255.31929,        5978.03267,       -7264.48027,        1884.12585,
       -2353.93882,       -1593.23001,          17.57205,        -498.54139,
          33.28704,         -13.79498,

      -38416.64883,      -13774.09664,      -32822.03952,       -3983.42726,
       -7538.09822,        1906.66915,        -221.24439,         512.77046,
          32.26101,          12.46483,

      142710.47871,      -96584.83892,      145395.05981,      -86630.96423,
       48202.96749,      -23596.77676,        5286.16967,       -1626.44031,
         -16.53568,          95.15428,         -15.19472,           5.69207,

          -6.72181,           7.28683,

        9515.16142,     -166495.49381,        5588.84271,     -146260.29445,
        2023.55881,      -30687.22422,         243.64741,         971.58076,
         390.73247,        -236.13754,       -2684.56349,         739.81087,

        -597.39429,         474.89313,        -631.69166,         213.04947,
        -204.89515,         -33.09139,         -17.78004,         -22.21866,
           0.61083,          -1.41177,

          -0.00070,          -0.00501,

         -58.24552,          25.27978,         -36.39386,           0.36376,
          -2.21030,          -6.46685,          -0.58473,          -0.09357,
           0.12829,          -0.94855,

           0.00042,           0.00048,

           0.00411,           0.00101,

           0.00249,          -0.00865,

           0.00223,           0.00293,

           0.00041,          -0.00042,

           0.00104,          -0.00086,

           0.00126,          -0.00380,

           0.00906,          -0.02253,

           0.05998,          -0.10318,

           0.00004,          -0.03225,           0.14303,          -0.05273,

           0.32683,           0.09386,

          -0.17053,           0.60847,          -0.06190,           0.28166,
           0.06411,           0.05289,

           0.01138,           0.00128,

          -0.00930,           0.00272,           0.00037,           0.00215,

           0.00004,           0.00050,

           0.00114,          -0.00217,

           0.05358,          -0.06413,          -0.00124,           0.03842,

           0.01006,           0.22479,           0.00412,           0.04040,

           0.01708,           0.02164,

           0.02484,          -0.02463,

          -0.00103,           0.02633,

          -0.01303,          -0.03214,

           0.03613,           0.02205,

          -0.02677,          -0.02522,

          -0.00293,           0.03130,

          -1.87255,          -2.50308,          -1.53715,           0.36859,
          -0.17829,          -1.12095,

          -0.05652,          -0.00786,

          -0.06992,           0.07279,

          -2.95896,           0.55138,          -0.61498,          -0.11008,

          -0.87790,          -0.50965,

         119.73553,         -35.18217,          44.78683,          -4.22438,
           1.95723,           0.58033,

       -4077.02379,        -353.39110,       -2781.63273,         -75.23318,
        -312.50478,         -23.86495,          24.59887,          32.56837,
         120.09593,         -51.00495,

           0.09737,           0.09111,

           0.04799,          -0.05029,

           0.08351,          -0.33726,           0.03158,          -0.06435,

          -0.00523,          -0.01736,

           0.00751,          -0.01757,

          -0.00406,          -0.01198,

           0.16402,          -0.10986,          -0.02024,           0.07205,

          -0.00440,          -0.00072,

          -0.00465,           0.00310,          -0.00121,          -0.00121,

           0.00083,           0.00020,

           0.00140,          -0.00176,

           0.00381,          -0.00731,

          -0.01618,           0.01570,

          -0.10201,           0.05809,

          -0.03359,           0.01024,

          -0.00535,           0.00018,

           0.00024,           0.00509,          -0.00158,          -0.00466,

           0.00009,          -0.00083,

          -0.00700,          -0.00090,          -0.00011,          -0.00079,

           0.00133,          -0.00126,

           0.01416,           0.05553,           0.04283,          -0.06719,

           0.00119,           0.00291,

          -0.00263,           0.01282,          -0.00040,           0.00188,

          -0.00237,           0.00973,

          -0.39533,           0.18773,          -0.79821,          -0.40168,

           0.00151,          -0.00161,

           0.00123,          -0.00516,

          -0.01432,          -0.00293,

          -0.05477,           0.04130,

          -0.48837,           0.18944,

          -0.12552,           9.37098,           1.02045,           5.11382,
           0.72098,          -3.70049,          -5.80982,           3.30105,

          -0.09682,           0.09696,

          -0.00876,           0.00504,

           0.00318,           0.00245,

           0.00563,          -0.00665,

           0.00108,          -0.00233,

          -0.00117,           0.00177,

          -0.00343,           0.00503,

           0.01044,          -0.00651,

           0.00296,          -0.00162,

           0.00037,           0.00028,

          -0.00020,          -0.00786,           0.00029,           0.00836,

           0.00004,           0.00033,

          -0.00309,          -0.00086,          -0.00157,          -0.00086,

          -0.00058,           0.00105,

          -0.04557,           0.01794,

          -0.00122,          -0.00086,

           0.00420,          -0.00285,           0.00118,          -0.00020,

           0.00743,          -0.01217,

           0.00053,          -0.00084,

          -0.00075,           0.00097,

          -0.00107,           0.00314,

           0.00576,          -0.00505,

           0.03624,          -0.02546,

           0.05379,           0.30081,           0.29870,          -0.22106,

           0.00696,          -0.00801,

          -0.03995,          -0.01808,

          -0.00139,           0.00102,

          -0.00059,           0.00138,

           0.00019,          -0.00037,

           0.00274,           0.00658,           0.00672,          -0.01132,

           0.00023,           0.00051,

           0.00031,           0.00090,

          -0.00017,          -0.00001,

           0.00085,           0.00004,

           0.02221,          -0.01977,           0.07498,           0.03025,

          -0.00082,          -0.00022,

          -0.00073,          -0.00028,

          -0.00253,           0.00259,

          -0.01329,           0.01805,

           0.00096,           0.00833,

          -0.11836,           0.04277,          -0.10820,          -0.03018,
           0.34504,           0.09834,

          -0.00538,          -0.00231,

           0.00036,           0.00042,

          -0.00023,           0.00260,

          -0.01137,           0.00036,

           0.01081,          -0.03271,

          -0.00029,          -0.00028,

           0.00018,          -0.00003,

           0.00009,           0.00012,

           0.00127,           0.00343,           0.00100,          -0.00064,

           0.00014,           0.00004,

           0.00150,           0.00069,

          -0.01484,           0.00135,           0.03930,           0.01405,

           0.00064,           0.00029,

           0.00009,           0.00009,

           0.00054,          -0.00048,           0.00019,           0.00005,

          -0.00009,           0.00018,

           0.00192,          -0.00333,

           0.01824,           0.01071,

           0.00107,          -0.00341,

           0.25530,          -0.18414,          -0.84151,          -0.31475,

          -0.00400,          -0.00010,

          -0.00174,           0.00019,

           0.00006,          -0.00079,

           0.00066,          -0.00070,

           0.00599,           0.00330,

          -0.00160,          -0.00013,

          -0.00067,          -0.00006,

          -0.00176,          -0.00111,

           0.00652,           0.00368,

           0.00004,           0.00001,

          -0.00081,           0.00089,           0.00366,           0.00139,

           0.00002,           0.00001,

          -0.01870,          -0.00998,

          -0.00020,          -0.00007,

           0.00005,           0.00003,

};
static double uratabr[] = {
           0.00000,         -53.23277,         -44.70609,         -62.54432,

         -19.15218,           0.10867,

          -1.91911,           1.47517,

          16.51994,           5.00458,           3.88980,           1.55740,

        3598.17109,        1831.07574,        2633.34851,        1775.69482,
         497.10486,         488.77343,           6.03892,          31.08365,
          -2.06585,          -1.12599,

         230.37762,        -113.95449,         162.40244,         -46.57185,
           6.70207,          17.27241,          -0.66092,         -14.42065,

          -0.01044,          -0.00287,

          -0.03894,          -0.01663,

           0.01629,           0.00496,

           0.08411,           0.02855,

           0.01795,          -0.00695,

           0.02426,          -0.03921,

          -0.24495,          -0.77369,          -0.31404,           0.38668,
          -0.05682,          -0.17197,

           0.06145,          -0.00510,

           0.00606,          -0.00886,

          -0.00370,          -0.00588,

           0.02173,          -0.11909,           0.00302,          -0.01796,

          -0.01067,           0.00990,

           0.05283,           0.06517,

       59710.89716,        -491.12783,       58672.38609,       19564.41947,
       10597.99050,       14313.02561,       -2585.52040,         766.78396,
        -138.39893,        -802.43403,         131.35006,         -31.97561,
           7.95978,           8.16075,

          28.72669,          31.72473,           6.45792,          16.50701,
           0.01066,           1.29718,

           0.11565,          -0.13240,

           0.05110,          -0.01543,

          -0.09994,           0.18864,          -0.01330,           0.04148,

           0.03510,          -0.00366,

           0.00604,          -0.00604,

           0.03752,          -0.00256,

          -7.00488,         -21.63748,           1.43064,         -17.10914,
          -0.62987,           0.48719,           0.00697,          -1.22665,

          -0.14435,          -0.00550,

           0.32008,          -0.19855,

      -13976.73731,       -3559.49432,       -7709.90803,       -9310.80334,
         749.31835,       -3491.50696,         540.94979,         -84.57550,
          16.96663,          35.53930,

       37214.64771,      -36361.15845,       21093.74492,      -31855.33076,
        1500.84653,       -7031.97901,        -453.40865,         -18.36692,
          -2.07726,         -17.92336,

      -56348.30507,      378512.71483,     -111444.43340,      370543.95160,
      -61893.70301,      112131.05507,      -11977.44617,        9156.15245,
        -567.61838,        -495.25760,          16.96202,         -44.06279,

           4.24760,         -48.83674,

     -643705.49516,     -131013.09649,     -838580.02217,       67627.11556,
     -288441.70339,      150227.25291,       -2500.57537,       42676.19888,
        7084.60505,        2043.65642,        9639.56835,       -1502.03390,

       -4126.00409,        -828.73564,       -2801.35204,       -2293.77751,
        -209.23365,       -1045.31476,          95.57334,        -102.74623,
           7.19216,           1.89593,

          -0.05661,           0.02166,

         120.38332,        -141.16507,          98.31386,         -40.23448,
          10.84269,          17.57713,           1.69239,           1.45065,
          -0.19626,           2.76108,

          -0.00270,           0.00360,

          -0.02333,          -0.00710,

          -0.01035,           0.02950,

           0.00737,          -0.06311,

          -0.00613,           0.01407,

           0.01377,           0.00879,

          -0.03287,           0.00012,

          -0.21667,           0.01793,

          -1.54865,           0.10953,

           0.54543,           0.12102,          -9.48047,           0.11477,

          -1.34966,           0.23199,

          -1.50834,           0.26567,          -0.64503,           0.10742,
          -0.21452,           0.04428,

          -0.01920,          -0.00906,

          -0.09378,           0.12773,          -0.02787,          -0.03090,

           0.03111,           0.00140,

           0.03771,          -0.01269,

          -1.94794,           1.22823,           0.64183,          -1.11467,

          -0.19301,          -0.27357,           0.05710,          -0.08115,

          -0.07318,           0.00806,

           0.14286,           0.20297,

           0.14920,          -0.07897,

           0.09682,           0.02379,

          -0.13928,           0.01679,

          -0.00774,           0.10060,

           0.24433,           0.16760,

          -2.88905,          -1.61439,           2.83052,          -3.41031,
          36.37048,           3.37867,

           0.29321,           0.09687,

           0.29324,          -0.14651,

           8.11116,           1.79211,           1.36421,           0.88111,

           1.21683,           2.37950,

        -357.76211,         -87.84636,        -117.55745,         -67.18338,
          -5.26029,          -6.27559,

        7509.94562,           3.68942,        4223.62097,       -1041.13557,
         -74.64464,        -251.41613,        -166.22180,          -1.68190,
        -214.55340,          62.79593,

          -0.08250,          -0.15936,

          -0.03830,           0.10857,

           0.21368,           0.50812,           0.00869,           0.09832,

           0.02158,           0.02045,

           0.01407,           0.03591,

           0.03460,           0.01171,

          -0.16400,           0.09751,           0.03521,          -0.12858,

           0.00700,          -0.00524,

           0.01698,          -0.04796,           0.04006,           0.00565,

          -0.02783,          -0.00205,

          -0.02296,           0.00153,

          -0.16139,           0.01514,

          -0.78136,          -0.01546,

           0.40374,          -0.06014,

           0.06212,          -0.01828,

           0.00831,          -0.00173,

           0.06857,          -0.11677,           0.00028,           0.05765,

          -0.00796,           0.00691,

           0.03764,           0.14902,          -0.02653,           0.02122,

          -0.05503,           0.01549,

           1.56630,          -0.35551,          -1.87960,           1.14303,

          -0.06063,          -0.03425,

           0.03367,          -0.11969,           0.04485,          -0.01651,

           0.04647,          -0.02097,

           0.22841,           0.47362,           0.99226,          -0.60660,

          -0.01249,           0.00134,

          -0.07435,           0.00722,

          -0.31796,          -0.00015,

           0.20533,          -0.04398,

           0.93944,          -0.26710,

          -5.60051,          -9.32918,          -5.13538,          -4.05130,
          -0.56529,           4.34112,           7.18308,          -2.66103,

           0.13241,          -0.07999,

           0.01046,          -0.00535,

          -0.04037,          -0.00455,

          -0.00510,           0.00731,

          -0.04576,           0.00513,

          -0.15846,          -0.00236,

           0.04628,          -0.00463,

          -0.01585,           0.00585,

          -0.00213,           0.00283,

           0.00778,          -0.00198,

          -0.17803,           0.18321,           0.07702,          -0.12325,

           0.01091,           0.00349,

           0.14211,          -0.21830,           0.07289,          -0.00994,

           0.07090,          -0.00079,

           4.18441,          -0.07413,

          -0.06247,          -0.00011,

          -0.15453,           0.14499,          -0.06557,          -0.00098,

           0.00290,           0.02921,

          -0.01923,           0.00457,

          -0.07538,          -0.00120,

           0.02263,          -0.00037,

          -0.01061,           0.00591,

          -0.04725,           0.02364,

          -0.07460,          -0.24108,          -0.28310,           0.14643,

          -0.00700,           0.00427,

           0.22963,           0.03713,

          -0.02062,           0.00478,

           0.01434,           0.00095,

          -0.01425,           0.00376,

           0.29611,          -0.08038,          -0.37811,           0.21703,

          -0.00723,          -0.00924,

          -0.02736,           0.01814,

           0.00934,           0.00731,

           0.00613,           0.00686,

          -0.91503,          -0.32009,          -0.15505,           0.79589,

          -0.00555,          -0.01536,

          -0.00698,           0.00480,

           0.00373,          -0.00046,

           0.00715,          -0.00470,

          -0.01970,          -0.05238,

           0.60649,          -0.32669,           0.17790,           0.33383,
          -2.74922,          -0.25827,

          -0.07862,           0.00406,

          -0.00948,          -0.02117,

           0.03127,          -0.04199,

           0.89670,          -0.02413,

           0.01954,           0.03990,

           0.00063,          -0.00071,

          -0.00226,           0.02009,

          -0.04407,          -0.05069,

           0.38230,           0.16101,           0.11893,          -0.06125,

           0.02051,          -0.00046,

           0.39211,           0.03679,

           0.01666,          -0.31336,          53.28735,          -0.01791,

          -0.39414,           0.04181,

          -0.01885,           0.00165,

           0.31349,          -0.47359,           0.16133,          -0.01023,

           0.00007,           0.01758,

          -0.13351,           0.07249,

           0.00977,           0.05445,

           0.11650,          -0.00191,

          -0.09824,           0.40106,           2.41155,          -0.30655,

           0.24975,          -0.01248,

          -0.03688,           0.01097,

           0.00038,          -0.00051,

          -0.04736,           0.02610,

           0.00968,           0.02634,

           0.07918,          -0.00606,

           0.02735,          -0.00320,

          -0.07544,          -0.00468,

           0.19996,          -0.01964,

           0.00201,           0.00267,

           0.39562,           0.43289,           1.24743,           0.31084,

          -0.00666,           0.00377,

           0.05668,           0.00148,

           0.03220,          -0.00026,

           0.03717,           0.01509,

};

static signed char uraargs[] = {
  0,  3,
  2,  1,  7, -2,  8,  0,
  2,  2,  7, -4,  8,  0,
  2,  3,  7, -6,  8,  1,
  2,  2,  5, -5,  6,  4,
  2,  1,  6, -3,  7,  3,
  3,  1,  6, -1,  7, -4,  8,  0,
  3,  2,  5, -7,  6,  6,  7,  0,
  3,  2,  6, -6,  7,  1,  8,  0,
  3,  2,  6, -7,  7,  3,  8,  0,
  3,  2,  6, -8,  7,  4,  8,  0,
  3,  2,  6, -7,  7,  2,  8,  0,
  2,  2,  6, -6,  7,  2,
  3,  1,  5, -4,  6,  4,  7,  0,
  3,  1,  6, -2,  7, -1,  8,  0,
  3,  1,  6, -3,  7,  1,  8,  0,
  3,  1,  6, -4,  7,  3,  8,  1,
  2,  5,  7, -9,  8,  0,
  2,  4,  7, -7,  8,  0,
  2,  2,  7, -3,  8,  6,
  2,  1,  7, -3,  8,  2,
  2,  2,  7, -5,  8,  0,
  2,  3,  7, -7,  8,  0,
  3,  1,  6, -6,  7,  5,  8,  1,
  3,  1,  6, -5,  7,  3,  8,  0,
  3,  2,  5, -8,  6,  8,  7,  0,
  3,  1,  5, -4,  6,  5,  7,  0,
  2,  2,  6, -5,  7,  3,
  3,  1,  6,  1,  7, -9,  8,  0,
  3,  2,  5, -4,  6, -2,  7,  0,
  2,  1,  6, -4,  8,  4,
  2,  1,  6, -2,  7,  4,
  2,  5,  7, -8,  8,  5,
  2,  3,  7, -4,  8,  0,
  1,  1,  7,  5,
  2,  2,  7, -6,  8,  4,
  3,  1,  6, -6,  7,  4,  8,  0,
  2,  1,  6, -4,  7,  4,
  3,  2,  6, -5,  7,  1,  8,  0,
  3,  2,  6, -6,  7,  3,  8,  0,
  2,  2,  6, -7,  7,  0,
  3,  1,  5, -4,  6,  3,  7,  0,
  3,  1,  6, -1,  7, -1,  8,  0,
  2,  1,  5, -2,  6,  0,
  2,  6,  7, -9,  8,  0,
  2,  5,  7, -7,  8,  0,
  2,  4,  7, -5,  8,  0,
  2,  3,  7, -3,  8,  1,
  2,  2,  7, -1,  8,  0,
  2,  1,  7,  1,  8,  2,
  1,  3,  8,  0,
  2,  3,  6, -7,  7,  1,
  3,  2,  5, -3,  6, -4,  7,  0,
  3,  2,  6, -3,  7, -2,  8,  0,
  2,  2,  6, -4,  7,  1,
  3,  2,  6, -5,  7,  2,  8,  1,
  3,  5,  5, -9,  6, -8,  7,  0,
  3,  2,  5, -4,  6, -1,  7,  0,
  3,  1,  6,  3,  7, -8,  8,  0,
  3,  2,  6, -8,  7,  1,  8,  0,
  3,  2,  5, -7,  6,  4,  7,  0,
  3,  4,  5,-10,  6,  2,  7,  0,
  2,  1,  6, -2,  8,  0,
  2,  1,  6, -1,  7,  2,
  2,  8,  7,-12,  8,  0,
  2,  7,  7,-10,  8,  0,
  2,  6,  7, -8,  8,  1,
  2,  5,  7, -6,  8,  0,
  2,  4,  7, -4,  8,  2,
  1,  2,  7,  4,
  1,  4,  8,  0,
  2,  1,  7, -6,  8,  0,
  2,  2,  7, -8,  8,  1,
  2,  3,  7,-10,  8,  0,
  2,  4,  7,-12,  8,  0,
  3,  1,  6, -6,  7,  2,  8,  0,
  2,  1,  6, -5,  7,  1,
  3,  1,  6, -4,  7, -2,  8,  0,
  3,  1,  5, -4,  6,  2,  7,  1,
  3,  1,  5, -2,  6,  1,  7,  0,
  2,  7,  7, -9,  8,  0,
  2,  6,  7, -7,  8,  0,
  2,  5,  7, -5,  8,  0,
  2,  4,  7, -3,  8,  0,
  2,  3,  7, -1,  8,  0,
  2,  2,  7,  1,  8,  0,
  2,  3,  6, -6,  7,  1,
  3,  3,  6, -7,  7,  2,  8,  0,
  3,  2,  5, -3,  6, -3,  7,  1,
  3,  2,  6, -2,  7, -2,  8,  0,
  2,  2,  6, -3,  7,  1,
  3,  2,  6, -4,  7,  2,  8,  0,
  3,  2,  5, -7,  6,  3,  7,  1,
  3,  1,  6,  1,  7, -2,  8,  0,
  1,  1,  6,  1,
  2,  8,  7,-10,  8,  0,
  2,  7,  7, -8,  8,  0,
  2,  6,  7, -6,  8,  0,
  2,  5,  7, -4,  8,  0,
  2,  4,  7, -2,  8,  0,
  1,  3,  7,  3,
  2,  2,  7,  2,  8,  0,
  2,  1,  7,  4,  8,  0,
  2,  1,  5, -4,  7,  0,
  2,  1,  6, -6,  7,  0,
  2,  8,  7, -9,  8,  0,
  2,  7,  7, -7,  8,  0,
  2,  6,  7, -5,  8,  0,
  2,  5,  7, -3,  8,  0,
  2,  4,  7, -1,  8,  0,
  3,  3,  6, -4,  7, -2,  8,  0,
  2,  3,  6, -5,  7,  1,
  3,  3,  6, -6,  7,  2,  8,  0,
  3,  2,  5, -3,  6, -2,  7,  1,
  3,  2,  6, -1,  7, -2,  8,  0,
  2,  2,  6, -2,  7,  0,
  3,  2,  6, -3,  7,  2,  8,  0,
  3,  2,  5, -7,  6,  2,  7,  1,
  2,  1,  6,  1,  7,  0,
  2,  9,  7,-10,  8,  0,
  2,  8,  7, -8,  8,  0,
  2,  7,  7, -6,  8,  0,
  2,  6,  7, -4,  8,  0,
  2,  5,  7, -2,  8,  0,
  1,  4,  7,  1,
  2,  3,  7,  2,  8,  0,
  2,  1,  5, -3,  7,  0,
  2,  9,  7, -9,  8,  0,
  2,  8,  7, -7,  8,  0,
  3,  3,  6, -3,  7, -2,  8,  0,
  2,  3,  6, -4,  7,  1,
  3,  3,  6, -5,  7,  2,  8,  0,
  3,  2,  5, -3,  6, -1,  7,  0,
  3,  2,  5, -8,  6,  4,  7,  0,
  2,  2,  6, -2,  8,  0,
  2,  2,  6, -1,  7,  1,
  3,  2,  6, -2,  7,  2,  8,  0,
  3,  2,  5, -7,  6,  1,  7,  0,
  2,  6,  7, -2,  8,  0,
  1,  5,  7,  0,
  3,  3,  6, -4,  7,  1,  8,  0,
  2,  1,  5, -2,  7,  2,
  3,  1,  5, -3,  7,  2,  8,  0,
  3,  1,  5, -1,  6,  1,  7,  0,
  2,  4,  6, -6,  7,  0,
  2,  3,  6, -3,  7,  0,
  1,  2,  6,  0,
  3,  2,  5, -4,  6,  3,  7,  0,
  3,  1,  5,  1,  6, -4,  7,  0,
  3,  3,  5, -5,  6, -1,  7,  0,
  1,  6,  7,  1,
  3,  1,  5,  1,  7, -4,  8,  0,
  2,  1,  5, -2,  8,  0,
  2,  1,  5, -1,  7,  1,
  3,  1,  5, -2,  7,  2,  8,  0,
  3,  1,  5, -3,  7,  4,  8,  0,
  3,  1,  5, -5,  6,  1,  7,  1,
  3,  1,  5, -1,  6,  2,  7,  0,
  2,  4,  6, -5,  7,  0,
  2,  3,  6, -2,  7,  0,
  3,  1,  5,  1,  7, -2,  8,  0,
  1,  1,  5,  1,
  2,  4,  6, -4,  7,  0,
  2,  3,  6, -1,  7,  0,
  3,  3,  5, -5,  6,  1,  7,  0,
  2,  5,  6, -6,  7,  0,
  2,  4,  6, -3,  7,  0,
  2,  5,  6, -5,  7,  0,
  2,  6,  6, -6,  7,  0,
  2,  2,  5, -3,  7,  0,
  2,  2,  5, -2,  7,  0,
  2,  2,  5, -2,  8,  0,
  2,  2,  5, -1,  7,  1,
  3,  2,  5, -2,  7,  2,  8,  0,
  1,  2,  5,  0,
  2,  3,  5, -3,  7,  0,
  2,  3,  5, -1,  7,  0,
 -1
};
/* Total terms = 177, small = 171 */
static struct plantbl ura404 = {
  {  0,  0,  0,  0,  5, 10,  9, 12,  0,},
 6,
 uraargs,
 uratabl,
 uratabb,
 uratabr,
 1.9218446061800002e+01,
};

/*
First date in file = 625296.50
Number of records = 16731.0
Days per record = 131.0
      Julian Years      Lon    Lat    Rad
 -3000.0 to  -2499.7:   0.44   0.30   0.50 
 -2499.7 to  -1999.7:   0.39   0.20   0.39 
 -1999.7 to  -1499.7:   0.31   0.15   0.31 
 -1499.7 to   -999.8:   0.32   0.19   0.36 
  -999.8 to   -499.8:   0.29   0.15   0.29 
  -499.8 to      0.2:   0.31   0.14   0.27 
     0.2 to    500.2:   0.28   0.14   0.27 
   500.2 to   1000.1:   0.34   0.15   0.39 
  1000.1 to   1500.1:   0.31   0.16   0.31 
  1500.1 to   2000.1:   0.33   0.16   0.29 
  2000.1 to   2500.0:   0.38   0.21   0.36 
  2500.0 to   3000.0:   0.43   0.25   0.46 
  3000.0 to   3000.4:  0.122  0.071  0.260 
*/
static double neptabl[] = {
       -1376.86480,         730.38970,    78655362.50948,     1095691.38676,

        -196.19023,        2086.77782,

        -122.04650,        -276.81592,

         184.56164,        -148.08924,

           3.39142,         -14.75027,

          -9.22741,           0.87688,

          -0.13903,          -0.44707,

          -0.17668,          -0.36299,

          -0.12682,          -0.26636,

          -0.51426,          -0.24667,

          -0.04965,          -0.03177,

           0.05050,          -0.00249,

          -0.80362,          -0.07363,          -0.15436,          -0.07180,

           2.45034,          -3.50145,           0.86698,           0.09777,

           7.72386,           7.16565,           2.10273,           8.86682,

           2.44705,          77.90155,

           0.28323,         -11.87157,         -13.64083,         252.70556,

          -4.94214,          -6.17988,        -305.60504,          51.23962,
       -2759.81719,        2476.20912,

          12.65762,          13.31543,

           0.36996,          -0.19077,           0.67363,           0.36737,

           0.02312,           0.02216,

           0.09953,           0.04777,

          -0.00572,          -0.02772,

          -0.02478,          -0.21920,

          -0.15289,          -1.50784,

          -0.17822,           0.34638,          -0.70473,          -8.61559,

          -2.65756,           1.25632,

          -0.31453,          -1.40348,          -4.02571,          -1.50467,
         -69.62308,           3.21315,

           0.69973,           0.08832,

          -0.00551,          -0.04964,

          -0.02264,          -0.34881,

           0.00762,          -1.85072,

           0.01407,          -0.30457,

          -0.09851,          -0.02372,

          -0.07729,          -0.11602,          -0.75995,          -0.71884,

          -0.08585,          -0.30406,           0.45818,           0.14921,

          -0.01033,          -0.11776,

           0.00640,          -0.57717,

          -0.01014,          -0.01357,          -0.00544,          -0.02168,

           0.40468,           0.28195,           0.00668,           0.14448,

           0.01245,          -0.08956,

          -0.26283,           0.01864,          -0.00641,          18.55347,

           0.01460,           0.08284,

          -0.04785,           0.11360,

          -0.33861,           0.01327,          -0.06392,          -0.18758,

           0.05449,          -0.05583,

          -0.00435,          -0.09869,

          -0.00286,          -0.04613,

          -0.00395,          -0.14564,

          -0.01385,          -0.01762,

           0.21160,          -0.61631,          -0.52100,          -0.04583,

           0.32812,           0.32138,

           0.04749,          -0.05724,

           0.11239,           0.13216,

          -0.01203,           0.40084,          -0.05207,          34.07903,

          -0.21457,          -0.34938,          -0.04594,           0.11198,

          -0.30662,          -0.20776,          -0.01076,          -0.10959,

           0.10891,          -0.10304,

          -0.28141,           0.25061,          -0.20293,           0.79930,

};
static double neptabb[] = {
        -391.05987,        -243.95958,         -23.83558,          58.13857,

           5.04859,          -3.93183,

         -14.21914,           7.14247,

         -12.09415,          -9.70132,

           1.04307,           0.47323,

          -0.07504,           0.70575,

          -0.05239,           0.00482,

          -0.02916,           0.00877,

          -0.00528,          -0.00286,

           0.00028,          -0.00228,

          -0.00056,          -0.00149,

           0.00049,           0.00047,

          -0.18765,          -0.59571,           0.03742,          -0.14653,

           2.30535,           0.65092,           0.42216,           0.24521,

          -2.86932,           2.37808,          -0.58456,           0.27446,

          -1.12264,          -2.04413,

         -11.71318,          -1.41554,         -23.30671,         -24.70499,

           8.82738,          85.64657,         -90.02223,          22.42604,
       -4749.41359,       -4244.46820,

          25.20811,         -18.51469,

          -1.19892,          -0.61067,           0.67734,          -1.08912,

          -0.01607,           0.00626,

          -0.00008,           0.00126,

          -0.00330,          -0.00078,

          -0.01503,           0.00758,

          -0.13208,          -0.00218,

          -0.04522,           0.20297,          -0.94708,          -0.77897,

          -2.74075,          -3.01122,

          -1.03394,           0.00886,           1.55485,          -4.68416,
          -0.13244,         -57.26983,

           0.05589,          -0.55396,

          -0.00130,           0.00526,

          -0.01028,           0.02086,

           0.01334,           0.00699,

           0.08565,           0.02020,

           0.01001,          -0.08402,

           0.08558,          -0.04488,           0.57268,          -0.59574,

           0.00807,           0.00492,           0.21993,          -0.18949,

          -0.00396,           0.00735,

           0.00487,           0.00230,

           0.00699,          -0.00473,           0.01406,          -0.00139,

           0.00738,           0.00099,           0.00161,           0.00019,

          -0.00067,          -0.00047,

           0.00572,          -0.00486,          -0.00842,           0.00322,

           0.00018,          -0.00109,

          -0.00272,           0.00112,

          -0.00041,           0.00763,           0.00211,           0.00118,

          -0.46842,          -0.17877,

           0.00209,          -0.00179,

           0.00090,          -0.00075,

           0.00618,           0.00610,

           0.00015,           0.00032,

          -0.00123,           0.00026,           0.00332,           0.00135,

           0.39130,          -0.34727,

           0.00015,          -0.00027,

          -0.00026,          -0.00052,

           0.00162,           0.00913,          -0.00697,           0.00308,

          -0.00333,          -0.00258,          -0.00117,           0.00035,

           0.00766,           0.00194,           0.00135,           0.00067,

          -0.41171,           0.24241,

           0.00106,           0.00025,           0.00013,          -0.00019,

};
static double neptabr[] = {
        -767.68936,        -460.59576,         -52.41861,        -273.85897,

          59.52489,           1.85006,

         -39.64750,          23.63348,

         -34.60399,         -23.41681,

           2.74937,           1.55389,

           0.20343,           2.15502,

          -0.12846,           0.07199,

          -0.07555,           0.05582,

          -0.04354,           0.01546,

          -0.03931,           0.07623,

          -0.00491,           0.00661,

           0.00322,           0.01540,

          -0.06741,          -0.35343,           0.00469,          -0.08073,

           1.94975,           0.66376,           0.06137,           0.31426,

          -2.93841,           4.27732,          -4.00342,           1.11157,

         -36.87785,           1.24960,

           4.69573,           2.15164,        -114.24899,          -6.69320,

          12.99919,          -9.47795,         -21.82350,        -156.88624,
       -1237.19769,       -1379.88864,

           6.54369,          -6.20873,

          -0.14163,          -0.32700,           0.17937,          -0.34864,

           0.01393,          -0.01286,

           0.02876,          -0.05767,

           0.02210,          -0.00128,

           0.16495,          -0.01242,

           1.15915,          -0.10365,

          -0.33224,          -0.10045,           6.83719,          -0.27499,

          -0.31284,          -0.94332,

           1.63704,          -0.33318,           1.48134,          -1.32257,
           0.96498,          -8.31047,

          -0.00402,          -0.09441,

           0.04292,          -0.00444,

           0.30325,          -0.02012,

           1.67999,           0.00353,

           0.00467,           0.03556,

           0.01393,          -0.01229,

           0.01188,          -0.01390,           0.04615,          -0.03509,

           0.32423,          -0.12491,           0.13682,           0.15131,

           0.11221,          -0.01201,

           0.57239,           0.00093,

           0.02068,          -0.01162,           0.00647,          -0.00325,

           0.27010,          -0.42993,           0.14314,          -0.01353,

          -0.08757,          -0.00699,

           0.00199,           0.31873,          18.80329,           0.01681,

           0.08009,          -0.00998,

          -0.14421,          -0.15912,

           0.37208,           0.49744,           0.35144,           0.06582,

          -0.11501,          -0.14037,

           0.10352,          -0.00768,

           0.04826,          -0.00423,

           0.19850,           0.00310,

          -0.01780,           0.01350,

          -0.61106,          -0.20525,          -0.04388,           0.52143,

           0.19300,          -0.21446,

          -0.05749,          -0.04776,

           0.12877,          -0.10908,

           0.39821,           0.00627,          34.03956,           0.04392,

          -0.34455,           0.22015,           0.11743,           0.04638,

           0.20723,          -0.30447,           0.10976,          -0.01008,

          -0.20778,          -0.21822,

           0.24939,           0.27976,           0.79790,           0.20200,

};

static signed char nepargs[] = {
  0,  3,
  2,  1,  7, -2,  8,  0,
  3,  3,  5, -8,  6,  3,  8,  0,
  2,  2,  7, -4,  8,  0,
  3,  1,  5, -3,  6,  3,  8,  0,
  2,  3,  7, -6,  8,  0,
  2,  4,  7, -8,  8,  0,
  3,  1,  6, -6,  7,  6,  8,  0,
  3,  1,  6, -5,  7,  4,  8,  0,
  3,  1,  6, -4,  7,  2,  8,  0,
  2,  1,  6, -3,  7,  0,
  3,  1,  6, -2,  7, -1,  8,  0,
  2,  5,  7, -9,  8,  1,
  2,  4,  7, -7,  8,  1,
  2,  3,  7, -5,  8,  1,
  2,  2,  7, -3,  8,  0,
  2,  1,  7, -1,  8,  1,
  1,  1,  8,  2,
  2,  1,  7, -3,  8,  0,
  2,  2,  7, -5,  8,  1,
  3,  1,  6, -6,  7,  5,  8,  0,
  3,  1,  6, -5,  7,  3,  8,  0,
  2,  5,  7, -8,  8,  0,
  2,  4,  7, -6,  8,  0,
  2,  3,  7, -4,  8,  0,
  2,  2,  7, -2,  8,  1,
  1,  1,  7,  0,
  1,  2,  8,  2,
  2,  1,  7, -4,  8,  0,
  2,  5,  7, -7,  8,  0,
  2,  4,  7, -5,  8,  0,
  2,  3,  7, -3,  8,  0,
  2,  2,  7, -1,  8,  0,
  2,  1,  7,  1,  8,  0,
  1,  3,  8,  1,
  2,  1,  6, -2,  8,  1,
  2,  5,  7, -6,  8,  0,
  2,  4,  7, -4,  8,  0,
  1,  4,  8,  1,
  3,  2,  5, -4,  6, -1,  8,  1,
  3,  1,  6,  1,  7, -3,  8,  0,
  2,  1,  6, -1,  8,  1,
  3,  1,  6, -1,  7,  1,  8,  0,
  3,  2,  5, -6,  6,  1,  8,  0,
  2,  5,  7, -5,  8,  1,
  1,  1,  6,  0,
  2,  6,  7, -6,  8,  0,
  2,  7,  7, -7,  8,  0,
  2,  2,  6, -2,  8,  0,
  3,  2,  5, -3,  6, -1,  8,  0,
  2,  2,  6, -1,  8,  1,
  2,  1,  5, -2,  8,  0,
  3,  3,  5, -5,  6, -1,  8,  0,
  2,  4,  7,  5,  8,  0,
  2,  1,  5, -1,  8,  1,
  3,  1,  5, -1,  7,  1,  8,  1,
  3,  1,  5, -5,  6,  1,  8,  1,
  1,  1,  5,  0,
  2,  2,  5, -1,  8,  1,
 -1
};
/* Total terms = 59, small = 58 */
static struct plantbl nep404 = {
  {  0,  0,  0,  0,  3,  8,  7,  9,  0,},
 3,
 nepargs,
 neptabl,
 neptabb,
 neptabr,
 3.0110386869399999e+01,
};

/*
First date in file = 625296.50
Number of records = 16731.0
Days per record = 131.0
      Julian Years      Lon    Lat    Rad
 -3000.0 to  -2499.7:   1.17   0.90   0.83 
 -2499.7 to  -1999.7:   0.57   0.51   0.58 
 -1999.7 to  -1499.7:   0.63   0.39   0.40 
 -1499.7 to   -999.8:   0.40   0.45   0.41 
  -999.8 to   -499.8:   0.42   0.22   0.30 
  -499.8 to      0.2:   0.41   0.24   0.35 
     0.2 to    500.2:   0.58   0.24   0.26 
   500.2 to   1000.1:   0.47   0.35   0.33 
  1000.1 to   1500.1:   0.43   0.31   0.28 
  1500.1 to   2000.1:   0.37   0.40   0.35 
  2000.1 to   2500.0:   0.46   0.35   0.39 
  2500.0 to   3000.0:   1.09   0.70   0.46 
  3000.0 to   3000.4:  0.871  0.395  0.051 
*/
static double plutabl[] = {
    74986469.33577,   100898343.73690,    48199471.54076,     9520076.03177,
      690431.67340,     -427355.12716,    52266623.77862,      860190.70714,

         -21.08511,        -143.39295,

        -126.71124,          48.18528,

         -88.74508,          40.50942,

          51.29367,         -10.24075,

           0.63094,          32.03258,

        -410.00781,         399.90234,        -116.54319,          51.50329,

         116.84565,         687.76781,         -13.38605,         182.70107,

       -1668.12226,       -5162.22648,        -585.68297,       -2247.56041,
         -20.95875,        -193.13703,

         -57.12097,         -10.35058,

       -1778.01442,       -6463.73779,        -657.86093,       -2713.44436,
         -41.32560,        -211.82042,

        -107.16513,         -36.58628,

    97929588.08231,   -33582903.63417,   143382679.31770,   -47411568.92345,
    79428827.73581,   -24658834.87499,    19861233.17488,    -5755585.62084,
     1995060.95931,     -693507.08147,      135176.31467,      109360.38672,
       -8188.00598,       -1680.95072,       71020.19608,      -70785.39049,

         -24.56034,         -20.34919,

        1618.45976,       -2079.48538,         635.62954,        -850.87068,
          44.95257,         -64.04459,

         -18.61475,          -1.77734,

           9.38079,           5.19958,

       17422.08783,       -4872.53852,       10985.76629,       -1137.68569,
        1771.28893,         288.93745,          40.22664,          37.90027,

           6.81361,         -32.65868,

          16.97268,          11.76152,

          29.33024,         -12.92289,

         -55.13187,         -14.73791,

           7.52474,        -102.05060,

         182.53144,         -20.18960,

  -490237997.49400,   486646248.63360,  -781277018.26430,   602300460.57290,
  -463787999.46420,   249529525.96100,  -123964746.86420,    31353019.97807,
   -13353800.92159,    -3463382.63269,      -35469.17654,    -1035343.45385,
       65076.64025,      -38181.61312,      -16473.33813,        3928.44674,

         188.60263,        1000.42530,

     -208376.39376,     -700566.62363,      114839.84613,     -342407.71113,
       39467.04812,      -14553.84849,

      581895.26100,     1012499.16715,      406317.22416,      310804.78515,
       43625.07033,       -4157.26545,

       -5930.13795,       -2070.62413,

        3348.17582,      -10871.23729,

      144609.18550,       60383.63650,       27912.02226,       15254.61228,

      -98561.37758,      -67442.28158,      -15573.63338,      -19931.99773,

       24323.06905,      -37473.32558,        2840.64042,       -8911.23694,

      -19636.31898,       71725.21946,      -12280.54554,       12251.00101,

       88626.52260,        5513.68450,       18506.41546,       -6513.87434,

      -83350.14621,       44300.00743,      -22075.37353,        3731.57531,

      -29167.76020,      -21642.67384,

    56602666.72177,   -22225578.01823,    50576897.80669,   -50319847.79086,
     5689259.25622,   -29585299.79697,    -4249711.27661,    -4490830.29568,
     -727678.08724,      366050.85631,       19183.62792,       55647.98226,

        1897.78091,       -1091.03988,         432.38158,        -138.62556,

         101.38743,          25.67379,

         320.20735,         362.16615,          85.06067,          54.02616,

           2.39460,          18.70004,

          -8.43353,           2.72100,

          -3.11205,          -3.06201,

         136.31503,         -28.33620,          48.68781,         -18.45285,
           1.15302,          -1.52360,

          -0.13706,          -0.37489,

           0.08750,          -0.14579,

          -0.07051,          -0.06518,

           0.30237,          -0.00448,

           4.83172,           6.83684,

     1752447.78043,     -945086.75857,     2340978.12819,    -1963675.42559,
     1254147.25257,    -1274861.91191,      279459.60237,     -263954.01378,
       11835.62290,      -16344.44434,        9119.98960,       -2390.44218,
         -23.67909,          86.73916,        -642.78635,       -1290.12208,

          -0.43345,          -1.85348,

           0.03094,          -0.01655,

           0.12380,           0.31834,

           5.54756,          -1.63109,           1.10598,          -0.17578,

           2.66994,          -2.17573,           0.97360,          -0.92226,

          -0.18533,          -0.39747,

           0.45809,          -0.65286,

           0.26129,           0.91922,

           0.81068,           0.11183,

           6.32182,          14.16786,           0.20872,           3.28489,

          -1.47458,          -2.11724,

           1.70020,          -1.99889,

           3.13003,           1.90638,

    -4483669.52795,     -446454.90158,    -6586256.67478,     -671890.16779,
    -3620444.55554,     -499672.41074,     -855998.32655,     -191073.94266,
      -73186.69110,      -22649.38582,       -2414.81729,       -1294.40542,
         436.80907,         125.48109,         -81.16877,         458.86508,

         -11.57414,         -26.39114,          -4.00801,          -5.01054,

         -18.17569,          20.86879,          -4.80965,           3.10535,

          -4.71122,           1.18169,

          74.75544,         649.21464,         -26.55060,         272.35592,
          -8.06982,          16.86110,

         -26.54868,          26.75711,

         -35.82910,          38.51063,

          22.22814,          19.38336,

          -6.30462,           0.90602,

           0.62856,          -0.34981,

          -0.10232,          -0.00939,

           0.04439,          -0.18875,

           0.16025,           0.11306,

          -0.06803,           0.06004,

      -91305.66728,      262370.61704,     -194633.44577,      304838.17733,
     -124505.90904,       94111.75602,      -22317.18255,        1575.23438,
         748.66316,        -349.78711,         166.64450,         -89.05045,
         120.76207,        -100.26715,

           3.13806,           3.71747,

          -1.44731,          -0.35235,

          -0.51660,          -1.50621,

           2.81310,          -3.93573,           1.20292,          -0.36412,

          -0.03340,          -0.00561,

          -5.29764,          26.02941,           1.91382,           3.30686,
          -3.35265,          -3.20868,

           0.05807,          -0.11885,

          -0.78588,           0.34807,          -0.19038,           0.11295,

          -0.03642,          -0.03794,

           0.00251,           0.03449,

          -0.08426,          -0.00310,

           0.05297,          -0.09278,

           0.10941,           0.00099,

     -228688.56632,      312567.73069,     -331458.31119,      328200.19460,
     -143760.57524,      104182.01134,      -17313.30132,       12591.15513,
        -440.32735,        -105.67674,         104.35854,        -852.84590,
           0.95527,           0.30212,         -54.63983,           4.06948,

           0.07545,          -0.13429,

          16.21005,          29.24658,           9.23410,          50.48867,
          30.55641,          12.76809,           0.11781,           0.70929,
          -0.04100,          13.60859,

           0.04976,          -0.02083,

           0.36279,           0.30130,          -0.02129,           0.09363,

          -0.07812,           0.01570,

          -0.06217,          -0.37181,

      -29348.55031,       43889.87672,      -35765.41577,       33855.90070,
      -10128.69894,        4535.32148,         281.75353,        -218.49194,
          -7.55224,         134.28640,           2.11319,          -2.13109,
          15.71244,          11.07183,

          -0.05406,          -0.23337,

          -1.28949,           1.34281,

           0.04212,          -0.02080,

           0.08109,           0.14820,

       -6010.46564,        3639.41780,       -5973.16000,        1381.66999,
       -1177.36865,        -501.06937,         166.14792,        -103.36431,
          14.92766,           4.12877,          -2.20893,          -6.32033,

          -0.29038,          -0.43172,

          -0.59341,           0.20477,          -0.13143,          -0.03150,

           0.10992,           0.01976,

          -0.00254,           0.02028,

          -0.30044,          -0.44658,          -0.03409,          -0.10758,

           0.08349,           0.06153,

          -0.06055,           0.18249,

          -1.15341,          -8.68699,          -0.11348,          -3.30688,

           1.08604,           1.04018,

          -0.46892,          -0.69765,           0.21504,           0.01968,

          -0.00455,          -0.01678,

           3.95643,          -3.17191,           3.95220,          -2.12670,
           0.99305,          -0.16651,

           0.34839,          -0.49162,

           0.85744,           0.20173,          -0.00975,           0.20225,

          -0.02627,          -0.02281,

          -0.18002,          -0.01803,

          -0.06144,          -0.21510,

           0.15935,          -0.01251,

          -0.21378,           0.44806,          -0.01174,           0.05779,

           0.07646,          -0.19656,          -0.04044,          -0.02521,

           0.02996,           0.06169,

           0.16698,          -0.04710,          -0.06506,          -0.02114,

           0.05500,           0.00276,

           0.08433,           0.03160,

           0.08193,           0.35773,           0.05454,           0.10718,

          -0.02823,          -0.00839,

           0.54078,           0.49347,           0.09609,           0.11825,

          -0.16092,          -0.11897,

           0.09059,           0.08254,

           0.16712,           0.05860,

          -0.09547,          -0.03206,

           0.03876,           0.04719,

          -0.02345,           0.02240,

          -0.00609,          -0.00649,

           0.03859,           0.00077,

           0.47819,           0.26196,           0.09780,           0.08104,

          -0.16919,           0.05042,

          -0.42652,           0.30810,

          -0.03409,          -0.51452,

          -0.23120,          -0.01380,

          -0.01157,          -0.00143,

          -0.00512,          -0.01628,

          -0.00189,           0.00183,

          -0.01427,          -0.02861,

           0.00618,          -0.00015,

           0.13087,           0.13870,

           0.15158,          -0.21056,

          -3.94829,          -1.06028,          -1.36602,           0.77954,

           0.08709,          -0.03118,

         -44.74949,          91.17393,           8.78173,          45.84010,
           1.97560,         -15.02849,          -0.10755,          -0.02884,
           3.38670,           0.30615,

         130.92778,         -24.33209,          43.01636,         -40.81327,
         -19.43900,          22.18162,          -0.12691,           0.33795,
          -6.44790,          -6.23145,

           0.00319,           0.01141,

          -0.03252,           0.03872,

           0.04467,           0.01614,

          -0.00382,          -0.00019,

           0.05955,           0.01533,

          16.11371,          41.37565,          61.44963,           6.90615,
           1.41326,          -0.73920,          -0.03871,          24.81978,

          -0.10229,          -0.32775,          -0.05188,          -0.05628,

          -2.33618,           2.39053,

          -0.00584,           0.00436,

           0.20903,           0.02220,

          -0.01738,          -0.02765,

          -0.00217,           0.00613,

          -0.01772,           0.01903,

           0.07075,          -0.00530,

           0.15234,          -0.37760,          -0.11641,          -0.20102,

          -0.63675,           0.20525,          -0.15783,           0.58945,

          -0.06243,           0.04306,

};
static double plutabb[] = {
   -35042727.30412,   -49049197.81293,   -25374963.60995,    -5761406.03035,
     -467370.57540,       14040.11453,        2329.15763,      -13978.69390,

          45.43441,          29.70305,

          32.33772,         -38.34012,

          26.43575,         -28.76136,

         -18.59040,          12.64837,

           5.56569,         -12.51581,

         248.37350,         -64.44466,          54.02618,           4.39466,

        -269.35114,        -290.63134,         -48.03841,         -52.83576,

        1508.94995,        1682.78967,         554.02336,         715.65819,
          34.37602,          58.44397,

          16.63685,          16.10176,

       -1069.51609,        2300.89166,        -437.16796,         927.89245,
         -33.17679,          68.74495,

          18.72022,          32.97640,

   -34004958.12619,   -17758805.77098,   -48416073.75788,   -24973405.03542,
   -25374996.23732,   -13351084.97340,    -5738294.54942,    -3082092.63350,
     -519989.39256,     -206440.89101,       44186.23548,      -87639.22630,
        2506.47602,        2327.01164,      -53878.47903,      -19670.13471,

           2.66934,          -3.86086,

         106.32427,         576.47944,          46.56388,         218.28339,
           4.35402,          15.04642,

           2.68717,          -2.86835,

           0.81728,          -2.34417,

       -1604.85823,       -1999.24986,        -631.47343,       -1382.19156,
         -15.74075,        -256.97077,           6.99648,          -4.54257,

           2.63478,           1.88838,

           0.17628,          -2.11518,

          -2.46735,          -1.48743,

           1.83456,           4.68487,

          -7.10919,           3.57046,

          -5.36342,          -7.70367,

    28395956.20816,   -37176795.74372,    48969952.83034,   -48145798.96248,
    31155823.23557,   -21163596.14822,     9057634.38260,    -3167688.51696,
     1167488.70078,      219103.97591,      -19017.97335,      107849.61195,
       -3814.43474,        4405.92120,        5800.13959,       12619.88708,

          22.18168,         -89.47801,

       52202.81929,       55119.44083,        5082.58907,       37955.06062,
       -3165.24355,        3316.67588,

     -113906.43970,      -69279.41495,      -57358.07767,      -10176.17329,
       -4179.79867,        2495.99374,

         787.87180,        -154.35591,

       -1148.62509,        1034.58199,

      -22194.95235,        3341.97949,       -4578.53994,         108.30832,

        7444.39789,       16646.40725,         509.75430,        3808.92686,

        -179.85869,        7408.76716,         340.65366,        1504.64227,

       -3783.09873,      -13505.60867,         875.74489,       -3181.27898,

      -16220.93983,        8041.37347,       -2631.07448,        2899.50781,

       18894.92095,      -20072.81471,        5925.05701,       -1947.91902,

       -6731.56601,        8014.52403,

     -987793.49463,     6491762.34471,     -279205.73643,     6117135.96868,
     -140925.91402,     2259422.06929,      114028.61646,      605600.90358,
       91858.00186,       56506.65187,        8949.15777,       -9782.67413,

        -394.66541,        -105.19208,         -76.54752,         -32.59411,

         -19.28741,          10.40013,

        -107.64003,          -7.36229,         -22.25126,           4.05952,

          -3.74402,          -2.79308,

           1.03337,          -2.13968,

           1.53794,          -0.02617,

          35.70756,          12.97733,          14.46213,           6.20518,
           1.79381,           1.65422,

          -0.31216,           0.29053,

          -0.03538,          -0.01584,

          -0.08934,           0.00079,

           0.05539,          -0.21591,

           2.86929,          -2.24724,

      320797.07455,       93342.16556,      -20903.39115,       79523.22083,
     -226588.37473,     -121017.23944,      -48472.25935,      -74195.36778,
       -7962.48081,       -4607.76339,       -4597.33274,       -7983.12541,
         -20.34500,          56.82999,       -1038.19507,         619.69624,

           1.08907,          -0.91278,

          -0.13391,           0.34956,

          -0.19982,          -0.18296,

          -0.97688,           2.36806,          -0.30127,           0.50980,

           0.96103,           1.96432,           0.43338,           0.87317,

           0.36997,          -0.01583,

          -0.44692,          -0.25159,

          -0.53525,           0.01154,

          -0.13231,           0.35562,

           3.88928,          -4.02882,           1.06967,          -0.56305,

          -0.45204,           0.77213,

          -0.82873,          -0.25854,

           0.21136,          -1.06696,

      458529.05491,      616790.47568,      698431.01349,     1124501.41713,
      300226.10339,      766533.33698,       26896.22954,      207880.75720,
        1116.29607,       21793.26153,        -850.64044,        3528.95568,
          29.61278,        -120.13367,         376.95131,          66.45758,

          -3.64868,           2.76062,          -0.85352,           0.95115,

           5.35056,           2.52803,           0.90026,           0.76403,

           0.43191,           0.83605,

         125.81792,         -39.65364,          50.14425,          -5.75891,
           2.78555,           2.05055,

          -4.27266,          -4.92428,

           6.78868,           5.73537,

           3.35229,          -3.70143,

           0.08488,           1.07465,

           0.10227,           0.06074,

           0.00291,           0.01522,

          -0.02274,           0.00297,

           0.01095,          -0.01856,

          -0.02862,           0.00178,

      143640.07486,         707.21331,      177163.08586,       53386.52697,
       56856.89297,       48268.74645,        1764.52814,        7711.76224,
         352.34159,        -968.03169,         -45.16568,         -81.60481,
         -76.35993,         -98.06932,

          -1.42185,           1.81425,

          -0.23427,           0.59023,

           0.57127,          -0.36335,

           1.89975,           0.66890,           0.28797,           0.43592,

          -0.03769,           0.03273,

          -6.06571,          -2.68515,          -0.55315,           0.86977,
           1.53840,          -0.59422,

          -0.05453,           0.02447,

          -0.12658,           0.22814,          -0.01715,           0.08497,

          -0.01288,          -0.00606,

           0.01547,          -0.00692,

           0.01157,           0.02407,

          -0.03883,           0.00835,

          -0.01542,          -0.04761,

      174386.39024,      158048.26273,      159192.81681,      220154.55148,
       33716.11953,       87537.86597,        -116.90381,        7535.83928,
        -962.06994,        -132.28837,        -644.90482,        -110.52332,
           3.42499,           3.74660,          -0.94008,          41.55548,

          -0.03824,          -0.05607,

          28.74787,         -37.31399,          30.87853,         -26.11940,
          10.79742,          -5.97905,           1.01237,          -0.04429,
           0.54402,           0.41905,

          -0.02440,          -0.03991,

          -0.00347,          -0.04362,          -0.00347,          -0.00469,

          -0.02707,           0.02761,

          -0.17773,          -0.11789,

       26475.02580,       35363.04345,       19877.11475,       41430.35940,
        2948.09998,       12983.41406,         281.93744,         570.70054,
         147.83157,          16.00090,          -1.62814,          -8.30846,
           9.29131,         -10.16496,

          -0.15799,           0.03843,

           1.44716,           0.46953,

          -0.02150,          -0.02502,

           0.08861,          -0.06690,

        2237.41551,        3739.08722,         753.74867,        3460.41553,
        -298.69226,         520.47031,         -33.62615,        -138.12767,
           3.61843,          -8.29860,          -4.56656,           0.79553,

           0.20041,          -0.25771,

          -0.35233,          -0.27913,          -0.02799,          -0.08328,

          -0.06889,          -0.16853,

           0.01701,          -0.00964,

          -0.37737,           0.18030,          -0.08525,           0.01906,

           0.05236,          -0.05155,

           0.11320,           0.05991,

          -5.66926,          -0.54402,          -2.08508,          -0.39407,

           0.82155,          -0.55975,

           0.39168,          -0.25551,           0.00623,           0.16162,

          -0.02519,           0.02420,

          -1.23293,          -3.19649,          -0.60519,          -2.79729,
           0.05362,          -0.61569,

          -0.25638,          -0.27033,

          -0.03987,           0.46623,          -0.12070,           0.00643,

           0.00849,          -0.00768,

          -0.03687,           0.10445,

          -0.13544,          -0.00592,

           0.02078,           0.09172,

           0.15824,           0.15815,           0.02020,           0.00747,

           0.10919,           0.09553,           0.01953,          -0.00135,

           0.04266,          -0.00218,

           0.02182,          -0.13742,          -0.01249,           0.01724,

          -0.02200,           0.02975,

          -0.01401,           0.03416,

          -0.28873,           0.04235,          -0.08137,           0.04223,

          -0.00326,           0.02144,

          -0.40423,           0.14281,          -0.08256,           0.02142,

           0.08116,          -0.03680,

          -0.02324,           0.07260,

          -0.06746,           0.11645,

           0.03233,          -0.05997,

          -0.03101,           0.02197,

          -0.00896,          -0.00491,

           0.00574,           0.00855,

           0.00052,           0.01209,

          -0.31828,           0.29955,          -0.08133,           0.04318,

           0.06787,          -0.08865,

          -0.13228,          -0.06507,

           0.34008,           0.06417,

          -0.00177,          -0.15116,

          -0.00553,          -0.01950,

           0.01144,          -0.00309,

          -0.00115,          -0.00153,

           0.02063,          -0.00791,

          -0.00314,           0.00493,

          -0.10614,           0.08338,

           0.08845,           0.20168,

           1.38955,          -2.52285,          -0.30475,          -1.05787,

           0.00580,           0.06623,

         -44.33263,         -47.70073,         -29.80583,          -8.77838,
           7.02948,           2.77221,           0.05248,          -0.13702,
          -0.78176,           1.77489,

         -16.32831,          46.68457,           2.54516,          21.78145,
          -5.09080,          -8.42611,          -0.24419,          -0.03315,
           2.80629,          -1.12755,

          -0.00402,           0.00053,

           0.00024,          -0.00043,

           0.00403,          -0.00210,

           0.00603,           0.00411,

          -0.00260,           0.00416,

           2.29235,           3.05992,           2.36465,          -0.58750,
           0.14030,           0.13523,           0.89998,           0.70156,

          -0.02188,           0.02003,          -0.00533,           0.00447,

           2.96411,           1.30183,

           0.01422,           0.00624,

          -0.10737,          -0.38316,

          -0.05968,           0.04379,

           0.01171,           0.01180,

          -0.00989,          -0.01375,

          -0.00845,           0.03782,

           0.09484,           0.09909,           0.07640,          -0.00898,

          -0.01076,           0.02760,           0.01630,           0.02198,

           0.05985,           0.04130,

};
static double plutabr[] = {
    17990649.12487,    24806479.30874,    12690953.00645,     2892671.69562,
      249947.71316,       -5138.71425,        1142.68629,        6075.25751,

         -34.76785,         -19.72399,

         -15.81516,          30.47718,

         -11.73638,          21.87955,

           9.42107,         -10.40957,

          -5.59670,           6.85778,

        -167.06735,          -2.31999,         -32.42575,         -13.72714,

         130.16635,         117.97555,          31.33915,          39.64331,

       -1378.54934,        -395.83244,        -562.79856,        -167.74359,
         -45.12476,         -17.08986,

          -4.20576,         -16.56724,

        1762.12089,       -1148.86987,         736.55320,        -423.09108,
          56.13621,         -26.26674,

           9.77810,         -38.05151,

     4702224.98754,    27254904.94363,     5306232.25993,    39518429.29982,
     1725110.05669,    21833263.27069,       46010.62605,     5425411.66252,
       17238.09865,      536771.62156,      -61263.36051,       66270.70142,
        2084.66296,       -1936.71208,       35898.49503,       34885.28549,

           1.93276,          10.66292,

        -665.11445,           3.70467,        -265.68478,          16.16272,
         -19.45954,           2.32738,

           3.04237,           3.97339,

          -2.64312,           0.66308,

       -3207.68754,        3418.03720,       -2342.62310,        1729.15030,
        -450.84643,         179.00943,         -13.20367,          -1.86087,

          -4.95659,           7.22347,

          -5.08890,          -1.28891,

          -6.21713,           5.10551,

          13.97276,           0.44529,

           3.25177,          25.02775,

         -45.56672,          11.58470,

   124443355.55450,  -100018293.41775,   190506421.77863,  -118262753.40162,
   108199328.45091,   -45247957.63323,    27272084.41143,    -4125106.01144,
     2583469.66051,     1024678.12935,      -22702.55109,      199269.51481,
      -15783.14789,        5564.52481,        -427.22231,       -6330.86079,

         -97.50757,        -204.32241,

       -9060.54822,      156661.77631,      -47791.83678,       59725.58975,
       -8807.74881,         -92.38886,

      -28886.11572,     -244419.59744,      -53336.36915,      -92232.16479,
       -8724.89354,       -2446.76739,

         889.71335,         936.51108,

         494.80305,        2252.83602,

      -18326.60823,      -25443.13554,       -3130.86382,       -5426.29135,

       23494.08846,          91.28882,        4664.14726,        1552.06143,

       -8090.43357,        2843.48366,       -1445.73506,        1023.11482,

       11664.20863,       -7020.08612,        3100.21504,         -64.16577,

       -9724.97938,      -12261.47155,       -3008.08276,       -1523.06301,

        6788.74046,       10708.27853,         343.09434,        1701.52760,

       14743.99857,       -4781.96586,

   -15922236.41469,     1825172.51825,   -14006084.36972,    10363332.64447,
     -979550.91360,     6542446.18797,     1160614.26915,      570804.88172,
       89912.68112,     -171247.08757,      -13899.52899,       -6182.25841,

        -240.64725,         412.42581,         -66.24510,          71.30726,

         -15.81125,         -15.76899,

         -21.85515,        -102.12717,         -10.18287,         -19.38527,

           1.43749,          -3.87533,

           1.97109,           0.20138,

           0.32012,           1.02928,

         -40.22077,          20.80684,         -15.69766,           9.63663,
          -1.26010,           0.56197,

           0.08592,           0.18540,

          -0.07303,           0.03897,

           0.01438,          -0.08809,

           0.15479,           0.10354,

           0.19052,           2.08790,

      405480.24475,     -607986.83623,      582811.58843,     -915111.10396,
      258696.21023,     -493391.09443,       23403.62628,     -119503.67282,
       -4036.86957,       -9766.17805,        -663.93268,        2544.07799,
          40.36638,          76.26390,         246.67716,         -13.93440,

           0.12403,           0.25378,

           0.14004,          -0.08501,

           0.07904,           0.12731,

           1.02117,          -1.34663,           0.25142,          -0.26903,

           0.18135,          -0.57683,          -0.30092,          -0.36121,

          -0.09623,           0.05873,

          -0.05803,           0.02869,

          -0.01194,           0.04983,

           0.04250,           0.04894,

           1.34245,           0.70137,           0.24217,           0.25912,

          -0.32759,          -0.03575,

           0.06780,          -0.41277,

           0.43865,           0.17857,

     -763933.02226,      465658.17048,    -1082753.91241,      593319.68634,
     -553911.89340,      274748.95145,     -122250.71547,       56608.95768,
       -9914.17300,        2988.43709,         707.94605,        -765.01470,
          52.73260,         -34.22263,         -43.58300,         -38.43647,

          -4.95939,          -1.97173,          -1.04406,          -0.13072,

          -0.34281,           4.75202,          -0.35513,           0.93597,

          -0.54380,           0.70536,

          84.83116,         102.93003,          26.34884,          48.57746,
           0.02853,           2.91676,

          -8.07116,           1.66613,

          -2.07908,          11.62592,

           6.64704,           0.98291,

          -1.19192,           0.93791,

           0.18822,           0.00900,

          -0.03181,          -0.02000,

           0.02755,          -0.01398,

          -0.03971,          -0.03756,

           0.13454,          -0.04193,

      -18672.98484,       28230.75834,      -28371.58823,       26448.45214,
      -13352.09393,        7461.71279,       -2609.33578,         726.50321,
        -309.72942,         -86.71982,          12.48589,          -9.69726,
           1.82185,          14.92220,

          -0.04748,           0.42510,

          -0.20047,           0.00154,

           0.00176,          -0.26262,

           0.78218,          -0.73243,           0.23694,          -0.03132,

          -0.00290,          -0.03678,

          14.03094,           4.25948,           0.79368,          -0.78489,
          -2.30962,           2.31946,

           0.00158,          -0.04125,

          -0.01387,           0.28503,           0.00892,           0.05154,

           0.00184,          -0.01727,

          -0.00889,           0.03526,

          -0.00521,          -0.02093,

           0.00200,           0.04872,

          -0.02163,           0.00578,

       20699.27413,       -2175.57827,       31177.33085,        4572.02063,
       15486.28190,        8747.74091,        2455.51737,        3839.83609,
          51.31433,         507.91086,          15.90082,          44.75942,
          -0.98374,          -2.64477,           2.52336,          -3.09203,

          -0.08897,          -0.00083,

         -15.91892,           0.72597,          14.04523,          -3.16525,
           4.33379,         -30.82980,           0.40462,          -0.75845,
          13.14831,          -0.02721,

          -0.01779,           0.00481,

           0.42365,          -0.09048,           0.08653,           0.04391,

           0.00846,           0.01082,

          -0.04736,           0.02308,

        6282.21778,       -4952.70286,        7886.57505,       -5328.36122,
        3113.76826,       -1696.84590,         330.70011,        -155.51989,
         -18.31559,          -3.90798,          -3.11242,           1.87818,
          -1.05578,           0.11198,

           0.05077,          -0.01571,

           2.41291,           2.40568,

          -0.01136,          -0.00076,

          -0.00392,          -0.02774,

         634.85065,        -352.21937,         674.31665,        -260.73473,
         199.16422,         -28.44198,           6.54187,           6.44960,
          -1.55155,           0.29755,           0.16977,           0.17540,

          -0.02652,           0.03726,

          -0.00623,           0.11777,          -0.00933,           0.02602,

          -0.13943,          -0.24818,

           0.02876,          -0.01463,

          -0.07166,           0.06747,          -0.01578,           0.01628,

           0.00233,          -0.00686,

           0.00431,          -0.00276,

           0.21774,           0.09735,           0.07894,           0.07279,

          -0.01300,          -0.00268,

           0.10824,           0.09435,           0.00720,           0.02111,

          -0.01960,           0.06154,

           0.56867,          -0.07544,           0.18210,           0.06343,
          -0.00906,           0.01942,

          -0.00850,          -0.00351,

          -0.06988,           0.01713,          -0.01110,          -0.00663,

           0.00196,          -0.02064,

          -0.00008,           0.00043,

           0.00375,           0.00084,

          -0.00279,           0.00100,

           0.00271,          -0.02017,          -0.00074,          -0.00357,

           0.03793,          -0.10108,          -0.01083,          -0.03952,

           0.00030,           0.00012,

           0.01576,           0.01142,           0.00351,           0.00277,

           0.01409,          -0.00774,

          -0.00065,           0.01895,

           0.07350,          -0.02519,           0.01528,          -0.01057,

          -0.00099,          -0.00295,

           0.21347,          -0.17458,           0.04940,          -0.02757,

          -0.06243,           0.05203,

           0.01055,          -0.00109,

           0.00003,          -0.04201,

          -0.00263,           0.02387,

           0.00886,          -0.01168,

           0.00479,           0.00204,

          -0.00239,           0.00022,

          -0.00223,          -0.02029,

          -0.14130,          -0.15237,          -0.01827,          -0.04877,

           0.12104,           0.06796,

           0.16379,           0.31892,

          -0.15605,           0.07048,

          -0.00700,           0.07481,

          -0.00370,          -0.00142,

          -0.00446,           0.00329,

          -0.00018,           0.00117,

          -0.00910,           0.00510,

          -0.00055,          -0.00114,

           0.04131,          -0.04013,

          -0.13238,           0.02680,

          -0.10369,           1.38709,           0.35515,           0.41437,

          -0.01327,          -0.02692,

          38.02603,          13.38166,          15.33389,          -7.40145,
          -8.55293,          -0.13185,          -0.03316,           0.13016,
           0.04428,          -1.60953,

         -12.87829,         -76.97922,         -23.96039,         -22.45636,
          14.83309,          14.09854,           0.24252,           0.13850,
          -4.16582,           4.08846,

           0.00751,          -0.00051,

           0.03456,           0.02900,

           0.01625,          -0.04660,

           0.01390,          -0.00530,

           0.01665,          -0.04571,

          40.90768,         -14.11641,           7.46071,         -58.07356,
          -0.27859,          -1.33816,          23.76074,          -0.03124,

          -0.27860,           0.13654,          -0.04800,           0.05375,

           4.38091,           4.39337,

           0.02233,           0.00514,

          -0.25616,          -0.54439,

          -0.05155,           0.11553,

           0.02944,          -0.00818,

           0.00570,           0.00119,

          -0.00733,          -0.02700,

          -0.23759,          -0.08712,          -0.12433,           0.07397,

           0.20629,           0.60251,           0.56512,           0.14790,

           0.07778,           0.11614,

};

static signed char pluargs[] = {
  0,  7,
  2,  3,  7, -9,  9,  0,
  2,  4,  7,-12,  9,  0,
  2,  4,  7, -8,  8,  0,
  3, -4,  7,  5,  8,  4,  9,  0,
  3,  3,  7, -5,  8, -1,  9,  0,
  2,  1,  6, -8,  9,  1,
  2,  3,  8, -5,  9,  1,
  2,  1,  6, -9,  9,  2,
  3,  6,  7, -6,  8, -8,  9,  0,
  3,  4,  7,-10,  8,  4,  9,  2,
  2,  3,  7, -8,  9,  0,
  1,  1,  9,  7,
  2,  3,  7,-10,  9,  0,
  3,  4,  7,-10,  8,  2,  9,  2,
  3,  5,  7,-12,  8,  2,  9,  0,
  2,  1,  6, -7,  9,  0,
  1,  1,  8,  3,
  2,  1,  6,-10,  9,  0,
  3,  6,  7,-12,  8,  2,  9,  0,
  3,  5,  7,-10,  8,  2,  9,  0,
  2,  5,  7,-13,  9,  0,
  2,  4,  7,-10,  9,  0,
  2,  3,  7, -7,  9,  0,
  1,  2,  9,  7,
  2,  3,  7,-11,  9,  0,
  3,  4,  7, -9,  8,  4,  9,  2,
  3,  3,  7, -5,  8,  1,  9,  2,
  2,  1,  6, -6,  9,  0,
  2,  7,  8,-13,  9,  0,
  2,  3,  8, -2,  9,  1,
  3,  1,  7, -5,  8,  2,  9,  1,
  3,  6,  7,-12,  8,  3,  9,  1,
  2,  5,  7,-12,  9,  1,
  2,  4,  7, -9,  9,  1,
  2,  2,  7, -3,  9,  1,
  1,  1,  7,  0,
  1,  3,  9,  5,
  2,  3,  7,-12,  9,  1,
  3,  5,  7, -9,  8,  2,  9,  0,
  3,  4,  7, -7,  8,  2,  9,  1,
  3,  3,  7, -5,  8,  2,  9,  0,
  3,  2,  7, -5,  8,  5,  9,  0,
  2,  1,  6, -5,  9,  0,
  2,  3,  8, -1,  9,  2,
  2,  1,  6,-12,  9,  0,
  3,  2,  7, -7,  8,  1,  9,  0,
  2,  5,  7,-11,  9,  0,
  2,  4,  7, -8,  9,  0,
  2,  2,  7, -2,  9,  0,
  1,  4,  9,  7,
  3,  2,  7, -8,  8,  2,  9,  0,
  3,  5,  7, -9,  8,  3,  9,  0,
  3,  4,  7, -9,  8,  6,  9,  0,
  3,  3,  7, -5,  8,  3,  9,  1,
  2,  2,  7, -1,  8,  1,
  2,  3,  8, -9,  9,  0,
  2,  9,  8, -9,  9,  0,
  2,  1,  6,-13,  9,  0,
  3,  2,  7, -5,  8, -3,  9,  0,
  2,  6,  7,-13,  9,  1,
  2,  5,  7,-10,  9,  0,
  2,  4,  7, -7,  9,  0,
  2,  3,  7, -4,  9,  0,
  1,  5,  9,  7,
  3,  6,  7, -9,  8,  1,  9,  1,
  3,  4,  7, -5,  8,  1,  9,  1,
  3,  3,  7, -3,  8,  1,  9,  0,
  2,  1,  6, -3,  9,  2,
  2,  3,  8,-10,  9,  0,
  2,  1,  8,  4,  9,  0,
  2,  5,  8, -2,  9,  0,
  2, 11,  8,-11,  9,  0,
  3,  1,  7, -9,  8,  5,  9,  0,
  2,  6,  7,-12,  9,  0,
  2,  5,  7, -9,  9,  0,
  2,  4,  7, -6,  9,  0,
  2,  3,  7, -3,  9,  0,
  1,  6,  9,  6,
  2,  2,  7,-12,  9,  0,
  3,  6,  7, -9,  8,  2,  9,  0,
  3,  3,  7,-12,  8,  3,  9,  0,
  3,  4,  7,-10,  8, -3,  9,  1,
  3,  3,  7, -3,  8,  2,  9,  0,
  2,  1,  6, -2,  9,  2,
  2,  1,  8,  5,  9,  0,
  2, 13,  8,-13,  9,  1,
  3,  2,  7, -9,  8,  1,  9,  0,
  2,  6,  7,-11,  9,  0,
  2,  5,  7, -8,  9,  0,
  2,  4,  7, -5,  9,  0,
  2,  3,  7, -2,  9,  0,
  1,  7,  9,  7,
  3,  6,  7, -9,  8,  3,  9,  0,
  2,  1,  6, -1,  9,  4,
  2,  3,  8,  3,  9,  0,
  2,  7,  7,-13,  9,  1,
  2,  3,  7, -1,  9,  0,
  2,  2,  7,  2,  9,  0,
  1,  8,  9,  6,
  3,  7,  7, -9,  8,  1,  9,  0,
  1,  1,  6,  0,
  1,  3,  7,  0,
  2,  2,  7,  3,  9,  0,
  1,  9,  9,  5,
  3,  1,  7,-10,  8,  3,  9,  0,
  3,  2,  7,-12,  8,  3,  9,  1,
  2,  1,  6,  1,  9,  0,
  3,  1,  7, -1,  8,  8,  9,  0,
  2,  3,  7,  1,  9,  1,
  2,  2,  7,  4,  9,  0,
  2,  1,  7,  7,  9,  0,
  2,  4,  8,  4,  9,  1,
  2, 12,  8, -8,  9,  0,
  3,  1,  7,-10,  8,  2,  9,  1,
  2,  1,  6,  2,  9,  0,
  1, 11,  9,  2,
  2, 12,  8, -7,  9,  0,
  3,  1,  7,-10,  8,  1,  9,  1,
  1,  4,  7,  0,
  1, 12,  9,  0,
  2,  6,  8,  3,  9,  0,
  3,  1,  7, -2,  8,-12,  9,  0,
  3,  7,  7, -7,  8,  2,  9,  1,
  2,  2,  6, -4,  9,  1,
  1, 13,  9,  0,
  2, 10,  8, -2,  9,  1,
  2,  4,  7,  2,  9,  0,
  2,  2,  6, -3,  9,  0,
  2,  2,  7,  8,  9,  1,
  2,  8,  8,  2,  9,  0,
  1,  5,  7,  1,
  2,  4,  7,  3,  9,  0,
  2,  3,  7,  6,  9,  0,
  2,  1,  5, -6,  9,  0,
  3,  2,  7,  8,  8, -3,  9,  0,
  3,  1,  7,  6,  8,  3,  9,  0,
  2,  6,  8,  6,  9,  0,
  3,  8,  7, -7,  8,  2,  9,  0,
  2,  9,  7,-11,  9,  0,
  2,  5,  7,  1,  9,  1,
  2,  4,  7,  4,  9,  0,
  2,  2,  6, -1,  9,  0,
  3,  2,  6, -1,  7,  2,  9,  0,
  2,  2,  7, 10,  9,  0,
  2,  1,  7, 13,  9,  0,
  2,  8,  7, -7,  9,  0,
  2,  7,  7, -4,  9,  0,
  2,  6,  7, -1,  9,  0,
  2,  5,  7,  3,  9,  0,
  2,  4,  7,  5,  9,  0,
  1,  2,  6,  0,
  2,  1,  5, -4,  9,  1,
  3,  1,  6,  9,  8, -5,  9,  0,
  2,  1,  5, -3,  9,  4,
  2,  1,  5, -2,  9,  4,
  3,  9,  7, -9,  8,  6,  9,  0,
  2,  8,  7, -4,  9,  0,
  2,  7,  7, -1,  9,  0,
  2,  1,  6,  3,  9,  0,
  2,  2,  6,  3,  9,  0,
  2,  1,  5, -1,  9,  3,
  3,  6,  7, -3,  8,  7,  9,  1,
  1,  1,  5,  0,
  2,  2,  6,  5,  9,  0,
  2,  1,  5,  1,  9,  0,
  2,  1,  5,  2,  9,  0,
  2,  1,  5,  3,  9,  0,
  2,  2,  5, -4,  9,  0,
  2,  2,  5, -3,  9,  0,
  2,  2,  5, -2,  9,  1,
  2,  2,  5, -1,  9,  1,
  1,  2,  5,  0,
 -1
};
/* Total terms = 173, small = 156 */
static struct plantbl plu404 = {
  {  0,  0,  0,  0,  2,  2,  9, 13, 13,},
 7,
 pluargs,
 plutabl,
 plutabb,
 plutabr,
 3.9539999999999999e+01,
};
