// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.

/// <p>Output parameter of the GetRecords API. The existing child shard of the current shard.</p>
#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::fmt::Debug)]
pub struct ChildShard {
    /// <p>The shard ID of the existing child shard of the current shard.</p>
    pub shard_id: ::std::string::String,
    /// <p>The current shard that is the parent of the existing child shard.</p>
    pub parent_shards: ::std::vec::Vec<::std::string::String>,
    /// <p>The range of possible hash key values for the shard, which is a set of ordered contiguous positive integers.</p>
    pub hash_key_range: ::std::option::Option<crate::types::HashKeyRange>,
}
impl ChildShard {
    /// <p>The shard ID of the existing child shard of the current shard.</p>
    pub fn shard_id(&self) -> &str {
        use std::ops::Deref;
        self.shard_id.deref()
    }
    /// <p>The current shard that is the parent of the existing child shard.</p>
    pub fn parent_shards(&self) -> &[::std::string::String] {
        use std::ops::Deref;
        self.parent_shards.deref()
    }
    /// <p>The range of possible hash key values for the shard, which is a set of ordered contiguous positive integers.</p>
    pub fn hash_key_range(&self) -> ::std::option::Option<&crate::types::HashKeyRange> {
        self.hash_key_range.as_ref()
    }
}
impl ChildShard {
    /// Creates a new builder-style object to manufacture [`ChildShard`](crate::types::ChildShard).
    pub fn builder() -> crate::types::builders::ChildShardBuilder {
        crate::types::builders::ChildShardBuilder::default()
    }
}

/// A builder for [`ChildShard`](crate::types::ChildShard).
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::default::Default, ::std::fmt::Debug)]
#[non_exhaustive]
pub struct ChildShardBuilder {
    pub(crate) shard_id: ::std::option::Option<::std::string::String>,
    pub(crate) parent_shards: ::std::option::Option<::std::vec::Vec<::std::string::String>>,
    pub(crate) hash_key_range: ::std::option::Option<crate::types::HashKeyRange>,
}
impl ChildShardBuilder {
    /// <p>The shard ID of the existing child shard of the current shard.</p>
    /// This field is required.
    pub fn shard_id(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.shard_id = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>The shard ID of the existing child shard of the current shard.</p>
    pub fn set_shard_id(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.shard_id = input;
        self
    }
    /// <p>The shard ID of the existing child shard of the current shard.</p>
    pub fn get_shard_id(&self) -> &::std::option::Option<::std::string::String> {
        &self.shard_id
    }
    /// Appends an item to `parent_shards`.
    ///
    /// To override the contents of this collection use [`set_parent_shards`](Self::set_parent_shards).
    ///
    /// <p>The current shard that is the parent of the existing child shard.</p>
    pub fn parent_shards(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        let mut v = self.parent_shards.unwrap_or_default();
        v.push(input.into());
        self.parent_shards = ::std::option::Option::Some(v);
        self
    }
    /// <p>The current shard that is the parent of the existing child shard.</p>
    pub fn set_parent_shards(mut self, input: ::std::option::Option<::std::vec::Vec<::std::string::String>>) -> Self {
        self.parent_shards = input;
        self
    }
    /// <p>The current shard that is the parent of the existing child shard.</p>
    pub fn get_parent_shards(&self) -> &::std::option::Option<::std::vec::Vec<::std::string::String>> {
        &self.parent_shards
    }
    /// <p>The range of possible hash key values for the shard, which is a set of ordered contiguous positive integers.</p>
    /// This field is required.
    pub fn hash_key_range(mut self, input: crate::types::HashKeyRange) -> Self {
        self.hash_key_range = ::std::option::Option::Some(input);
        self
    }
    /// <p>The range of possible hash key values for the shard, which is a set of ordered contiguous positive integers.</p>
    pub fn set_hash_key_range(mut self, input: ::std::option::Option<crate::types::HashKeyRange>) -> Self {
        self.hash_key_range = input;
        self
    }
    /// <p>The range of possible hash key values for the shard, which is a set of ordered contiguous positive integers.</p>
    pub fn get_hash_key_range(&self) -> &::std::option::Option<crate::types::HashKeyRange> {
        &self.hash_key_range
    }
    /// Consumes the builder and constructs a [`ChildShard`](crate::types::ChildShard).
    /// This method will fail if any of the following fields are not set:
    /// - [`shard_id`](crate::types::builders::ChildShardBuilder::shard_id)
    /// - [`parent_shards`](crate::types::builders::ChildShardBuilder::parent_shards)
    pub fn build(self) -> ::std::result::Result<crate::types::ChildShard, ::aws_smithy_types::error::operation::BuildError> {
        ::std::result::Result::Ok(crate::types::ChildShard {
            shard_id: self.shard_id.ok_or_else(|| {
                ::aws_smithy_types::error::operation::BuildError::missing_field(
                    "shard_id",
                    "shard_id was not specified but it is required when building ChildShard",
                )
            })?,
            parent_shards: self.parent_shards.ok_or_else(|| {
                ::aws_smithy_types::error::operation::BuildError::missing_field(
                    "parent_shards",
                    "parent_shards was not specified but it is required when building ChildShard",
                )
            })?,
            hash_key_range: self.hash_key_range,
        })
    }
}
