// Code generated by running "go generate" in github.com/charlievieth/strcase. DO NOT EDIT.

//go:build go1.16 && !go1.21
// +build go1.16,!go1.21

package tables

import "unicode"

// UnicodeVersion is the Unicode version from which the tables in this package are derived.
const UnicodeVersion = "13.0.0"

func init() {
	// This is essentially a compile time assertion that can only fail if a
	// future Go release updates the version of Unicode it supports. This
	// check is elided if the Unicode versions match.
	//
	// TLDR if you see this panic file an issue:
	// https://github.com/charlievieth/strcase/issues
	//
	if UnicodeVersion != unicode.Version {
		panic("strcase.UnicodeVersion \"" + UnicodeVersion +
			"\" != unicode.Version \"" + unicode.Version + "\"")
	}
}

// A foldPair stores Unicode case folding pairs
type foldPair struct {
	From uint32
	To   uint32
}

// TODO: rename to "foldCase"
//
// CaseFold returns the Unicode simple case-fold for r, if one exists, or r
// unmodified, if one does not exist.
func CaseFold(r rune) rune {
	// TODO: check if r is ASCII here?
	u := uint32(r)
	h := (u * _CaseFoldsSeed) >> _CaseFoldsShift
	p := _CaseFolds[h]
	if p.From == u {
		r = rune(p.To)
	}
	return r
}

// TODO: rename
func FoldMap(r rune) *[4]uint16 {
	u := uint32(r)
	h := (u * _FoldMapSeed) >> _FoldMapShift
	p := &_FoldMap[h]
	if uint32(p[0]) == u {
		return p
	}
	return nil
}

func FoldMapExcludingUpperLower(r rune) [2]rune {
	u := uint32(r)
	h := (u * _FoldMapSeed) >> _FoldMapShift
	p := &_FoldMapExcludingUpperLower[h]
	if uint32(p.r) == u {
		return [2]rune{rune(p.a[0]), rune(p.a[1])}
	}
	return [2]rune{}
}

// ToUpperLower combines unicode.ToUpper and unicode.ToLower in one function.
func ToUpperLower(r rune) (upper, lower rune, foundMapping bool) {
	if r <= 0x80 {
		if 'A' <= r && r <= 'Z' {
			return r, r + ('a' - 'A'), true
		}
		if 'a' <= r && r <= 'z' {
			return r - ('a' - 'A'), r, true
		}
		return r, r, false
	}
	// Hash rune r and see if it's in the _UpperLower table.
	u := uint32(r)
	h := (u | u<<24) * _UpperLowerSeed
	p := &_UpperLower[h>>_UpperLowerShift]
	if p[0] == u || p[1] == u {
		return rune(p[0]), rune(p[1]), true
	}
	// Handle Unicode characters that do not equal
	// their upper and lower case forms.
	return toUpperLowerSpecial(r)
}

const _CaseFoldsSeed = 0x24F847
const _CaseFoldsShift = 19

// _CaseFolds stores all Unicode simple case-folds.
var _CaseFolds = [8192]foldPair{
	71:   {0xA640, 0xA641},   // 'Ꙁ' => 'ꙁ'
	80:   {0xA642, 0xA643},   // 'Ꙃ' => 'ꙃ'
	89:   {0xA644, 0xA645},   // 'Ꙅ' => 'ꙅ'
	99:   {0xA646, 0xA647},   // 'Ꙇ' => 'ꙇ'
	108:  {0xA648, 0xA649},   // 'Ꙉ' => 'ꙉ'
	117:  {0xA64A, 0xA64B},   // 'Ꙋ' => 'ꙋ'
	126:  {0xA64C, 0xA64D},   // 'Ꙍ' => 'ꙍ'
	136:  {0xA64E, 0xA64F},   // 'Ꙏ' => 'ꙏ'
	145:  {0xA650, 0xA651},   // 'Ꙑ' => 'ꙑ'
	154:  {0xA652, 0xA653},   // 'Ꙓ' => 'ꙓ'
	163:  {0xA654, 0xA655},   // 'Ꙕ' => 'ꙕ'
	173:  {0xA656, 0xA657},   // 'Ꙗ' => 'ꙗ'
	182:  {0xA658, 0xA659},   // 'Ꙙ' => 'ꙙ'
	191:  {0xA65A, 0xA65B},   // 'Ꙛ' => 'ꙛ'
	200:  {0xA65C, 0xA65D},   // 'Ꙝ' => 'ꙝ'
	210:  {0xA65E, 0xA65F},   // 'Ꙟ' => 'ꙟ'
	219:  {0xA660, 0xA661},   // 'Ꙡ' => 'ꙡ'
	228:  {0xA662, 0xA663},   // 'Ꙣ' => 'ꙣ'
	237:  {0xA664, 0xA665},   // 'Ꙥ' => 'ꙥ'
	247:  {0xA666, 0xA667},   // 'Ꙧ' => 'ꙧ'
	256:  {0xA668, 0xA669},   // 'Ꙩ' => 'ꙩ'
	265:  {0xA66A, 0xA66B},   // 'Ꙫ' => 'ꙫ'
	274:  {0xA66C, 0xA66D},   // 'Ꙭ' => 'ꙭ'
	300:  {0x0041, 0x0061},   // 'A' => 'a'
	305:  {0x0042, 0x0062},   // 'B' => 'b'
	309:  {0x0043, 0x0063},   // 'C' => 'c'
	314:  {0x0044, 0x0064},   // 'D' => 'd'
	318:  {0x0045, 0x0065},   // 'E' => 'e'
	323:  {0x0046, 0x0066},   // 'F' => 'f'
	328:  {0x0047, 0x0067},   // 'G' => 'g'
	332:  {0x0048, 0x0068},   // 'H' => 'h'
	337:  {0x0049, 0x0069},   // 'I' => 'i'
	341:  {0x004A, 0x006A},   // 'J' => 'j'
	346:  {0x004B, 0x006B},   // 'K' => 'k'
	351:  {0x004C, 0x006C},   // 'L' => 'l'
	355:  {0x004D, 0x006D},   // 'M' => 'm'
	360:  {0x004E, 0x006E},   // 'N' => 'n'
	365:  {0x004F, 0x006F},   // 'O' => 'o'
	367:  {0xA680, 0xA681},   // 'Ꚁ' => 'ꚁ'
	369:  {0x0050, 0x0070},   // 'P' => 'p'
	374:  {0x0051, 0x0071},   // 'Q' => 'q'
	376:  {0xA682, 0xA683},   // 'Ꚃ' => 'ꚃ'
	378:  {0x0052, 0x0072},   // 'R' => 'r'
	383:  {0x0053, 0x0073},   // 'S' => 's'
	385:  {0xA684, 0xA685},   // 'Ꚅ' => 'ꚅ'
	388:  {0x0054, 0x0074},   // 'T' => 't'
	392:  {0x0055, 0x0075},   // 'U' => 'u'
	394:  {0xA686, 0xA687},   // 'Ꚇ' => 'ꚇ'
	397:  {0x0056, 0x0076},   // 'V' => 'v'
	402:  {0x0057, 0x0077},   // 'W' => 'w'
	404:  {0xA688, 0xA689},   // 'Ꚉ' => 'ꚉ'
	406:  {0x0058, 0x0078},   // 'X' => 'x'
	411:  {0x0059, 0x0079},   // 'Y' => 'y'
	413:  {0xA68A, 0xA68B},   // 'Ꚋ' => 'ꚋ'
	415:  {0x005A, 0x007A},   // 'Z' => 'z'
	422:  {0xA68C, 0xA68D},   // 'Ꚍ' => 'ꚍ'
	431:  {0xA68E, 0xA68F},   // 'Ꚏ' => 'ꚏ'
	441:  {0xA690, 0xA691},   // 'Ꚑ' => 'ꚑ'
	450:  {0xA692, 0xA693},   // 'Ꚓ' => 'ꚓ'
	459:  {0xA694, 0xA695},   // 'Ꚕ' => 'ꚕ'
	468:  {0xA696, 0xA697},   // 'Ꚗ' => 'ꚗ'
	478:  {0xA698, 0xA699},   // 'Ꚙ' => 'ꚙ'
	487:  {0xA69A, 0xA69B},   // 'Ꚛ' => 'ꚛ'
	836:  {0x00B5, 0x03BC},   // 'µ' => 'μ'
	887:  {0x00C0, 0x00E0},   // 'À' => 'à'
	891:  {0x00C1, 0x00E1},   // 'Á' => 'á'
	896:  {0x00C2, 0x00E2},   // 'Â' => 'â'
	901:  {0x00C3, 0x00E3},   // 'Ã' => 'ã'
	905:  {0x00C4, 0x00E4},   // 'Ä' => 'ä'
	910:  {0x00C5, 0x00E5},   // 'Å' => 'å'
	915:  {0x00C6, 0x00E6},   // 'Æ' => 'æ'
	919:  {0x00C7, 0x00E7},   // 'Ç' => 'ç'
	924:  {0x00C8, 0x00E8},   // 'È' => 'è'
	928:  {0x00C9, 0x00E9},   // 'É' => 'é'
	933:  {0x00CA, 0x00EA},   // 'Ê' => 'ê'
	938:  {0x00CB, 0x00EB},   // 'Ë' => 'ë'
	942:  {0x00CC, 0x00EC},   // 'Ì' => 'ì'
	947:  {0x00CD, 0x00ED},   // 'Í' => 'í'
	948:  {0x1C80, 0x0432},   // 'ᲀ' => 'в'
	951:  {0x00CE, 0x00EE},   // 'Î' => 'î'
	953:  {0x1C81, 0x0434},   // 'ᲁ' => 'д'
	956:  {0x00CF, 0x00EF},   // 'Ï' => 'ï'
	957:  {0x1C82, 0x043E},   // 'ᲂ' => 'о'
	961:  {0x00D0, 0x00F0},   // 'Ð' => 'ð'
	962:  {0x1C83, 0x0441},   // 'ᲃ' => 'с'
	965:  {0x00D1, 0x00F1},   // 'Ñ' => 'ñ'
	966:  {0x1C84, 0x0442},   // 'ᲄ' => 'т'
	970:  {0x00D2, 0x00F2},   // 'Ò' => 'ò'
	971:  {0x1C85, 0x0442},   // 'ᲅ' => 'т'
	975:  {0x00D3, 0x00F3},   // 'Ó' => 'ó'
	976:  {0x1C86, 0x044A},   // 'ᲆ' => 'ъ'
	979:  {0x00D4, 0x00F4},   // 'Ô' => 'ô'
	980:  {0x1C87, 0x0463},   // 'ᲇ' => 'ѣ'
	984:  {0x00D5, 0x00F5},   // 'Õ' => 'õ'
	985:  {0x1C88, 0xA64B},   // 'ᲈ' => 'ꙋ'
	988:  {0x00D6, 0x00F6},   // 'Ö' => 'ö'
	998:  {0x00D8, 0x00F8},   // 'Ø' => 'ø'
	1002: {0x00D9, 0x00F9},   // 'Ù' => 'ù'
	1007: {0x00DA, 0x00FA},   // 'Ú' => 'ú'
	1012: {0x00DB, 0x00FB},   // 'Û' => 'û'
	1016: {0x00DC, 0x00FC},   // 'Ü' => 'ü'
	1021: {0x00DD, 0x00FD},   // 'Ý' => 'ý'
	1022: {0x1C90, 0x10D0},   // 'Ა' => 'ა'
	1025: {0x00DE, 0x00FE},   // 'Þ' => 'þ'
	1027: {0x1C91, 0x10D1},   // 'Ბ' => 'ბ'
	1031: {0x1C92, 0x10D2},   // 'Გ' => 'გ'
	1036: {0x1C93, 0x10D3},   // 'Დ' => 'დ'
	1040: {0x1C94, 0x10D4},   // 'Ე' => 'ე'
	1045: {0x1C95, 0x10D5},   // 'Ვ' => 'ვ'
	1050: {0x1C96, 0x10D6},   // 'Ზ' => 'ზ'
	1054: {0x1C97, 0x10D7},   // 'Თ' => 'თ'
	1059: {0x1C98, 0x10D8},   // 'Ი' => 'ი'
	1064: {0x1C99, 0x10D9},   // 'Კ' => 'კ'
	1068: {0x1C9A, 0x10DA},   // 'Ლ' => 'ლ'
	1073: {0x1C9B, 0x10DB},   // 'Მ' => 'მ'
	1077: {0x1C9C, 0x10DC},   // 'Ნ' => 'ნ'
	1082: {0x1C9D, 0x10DD},   // 'Ო' => 'ო'
	1087: {0x1C9E, 0x10DE},   // 'Პ' => 'პ'
	1091: {0x1C9F, 0x10DF},   // 'Ჟ' => 'ჟ'
	1096: {0x1CA0, 0x10E0},   // 'Რ' => 'რ'
	1100: {0x1CA1, 0x10E1},   // 'Ს' => 'ს'
	1105: {0x1CA2, 0x10E2},   // 'Ტ' => 'ტ'
	1110: {0x1CA3, 0x10E3},   // 'Უ' => 'უ'
	1114: {0x1CA4, 0x10E4},   // 'Ფ' => 'ფ'
	1115: {0xA722, 0xA723},   // 'Ꜣ' => 'ꜣ'
	1119: {0x1CA5, 0x10E5},   // 'Ქ' => 'ქ'
	1124: {0x1CA6, 0x10E6},   // 'Ღ' => 'ღ'
	1125: {0xA724, 0xA725},   // 'Ꜥ' => 'ꜥ'
	1128: {0x1CA7, 0x10E7},   // 'Ყ' => 'ყ'
	1133: {0x1CA8, 0x10E8},   // 'Შ' => 'შ'
	1134: {0xA726, 0xA727},   // 'Ꜧ' => 'ꜧ'
	1137: {0x1CA9, 0x10E9},   // 'Ჩ' => 'ჩ'
	1142: {0x1CAA, 0x10EA},   // 'Ც' => 'ც'
	1143: {0xA728, 0xA729},   // 'Ꜩ' => 'ꜩ'
	1147: {0x1CAB, 0x10EB},   // 'Ძ' => 'ძ'
	1151: {0x1CAC, 0x10EC},   // 'Წ' => 'წ'
	1152: {0xA72A, 0xA72B},   // 'Ꜫ' => 'ꜫ'
	1156: {0x1CAD, 0x10ED},   // 'Ჭ' => 'ჭ'
	1161: {0x1CAE, 0x10EE},   // 'Ხ' => 'ხ'
	1162: {0xA72C, 0xA72D},   // 'Ꜭ' => 'ꜭ'
	1165: {0x1CAF, 0x10EF},   // 'Ჯ' => 'ჯ'
	1170: {0x1CB0, 0x10F0},   // 'Ჰ' => 'ჰ'
	1171: {0xA72E, 0xA72F},   // 'Ꜯ' => 'ꜯ'
	1174: {0x1CB1, 0x10F1},   // 'Ჱ' => 'ჱ'
	1179: {0x1CB2, 0x10F2},   // 'Ჲ' => 'ჲ'
	1183: {0x0100, 0x0101},   // 'Ā' => 'ā'
	1184: {0x1CB3, 0x10F3},   // 'Ჳ' => 'ჳ'
	1188: {0x1CB4, 0x10F4},   // 'Ჴ' => 'ჴ'
	1189: {0xA732, 0xA733},   // 'Ꜳ' => 'ꜳ'
	1192: {0x0102, 0x0103},   // 'Ă' => 'ă'
	1193: {0x1CB5, 0x10F5},   // 'Ჵ' => 'ჵ'
	1198: {0x1CB6, 0x10F6},   // 'Ჶ' => 'ჶ'
	1199: {0xA734, 0xA735},   // 'Ꜵ' => 'ꜵ'
	1201: {0x0104, 0x0105},   // 'Ą' => 'ą'
	1202: {0x1CB7, 0x10F7},   // 'Ჷ' => 'ჷ'
	1207: {0x1CB8, 0x10F8},   // 'Ჸ' => 'ჸ'
	1208: {0xA736, 0xA737},   // 'Ꜷ' => 'ꜷ'
	1210: {0x0106, 0x0107},   // 'Ć' => 'ć'
	1211: {0x1CB9, 0x10F9},   // 'Ჹ' => 'ჹ'
	1216: {0x1CBA, 0x10FA},   // 'Ჺ' => 'ჺ'
	1217: {0xA738, 0xA739},   // 'Ꜹ' => 'ꜹ'
	1220: {0x0108, 0x0109},   // 'Ĉ' => 'ĉ'
	1226: {0xA73A, 0xA73B},   // 'Ꜻ' => 'ꜻ'
	1229: {0x010A, 0x010B},   // 'Ċ' => 'ċ'
	1230: {0x1CBD, 0x10FD},   // 'Ჽ' => 'ჽ'
	1235: {0x1CBE, 0x10FE},   // 'Ჾ' => 'ჾ'
	1236: {0xA73C, 0xA73D},   // 'Ꜽ' => 'ꜽ'
	1238: {0x010C, 0x010D},   // 'Č' => 'č'
	1239: {0x1CBF, 0x10FF},   // 'Ჿ' => 'ჿ'
	1245: {0xA73E, 0xA73F},   // 'Ꜿ' => 'ꜿ'
	1247: {0x010E, 0x010F},   // 'Ď' => 'ď'
	1254: {0xA740, 0xA741},   // 'Ꝁ' => 'ꝁ'
	1256: {0x0110, 0x0111},   // 'Đ' => 'đ'
	1263: {0xA742, 0xA743},   // 'Ꝃ' => 'ꝃ'
	1266: {0x0112, 0x0113},   // 'Ē' => 'ē'
	1273: {0xA744, 0xA745},   // 'Ꝅ' => 'ꝅ'
	1275: {0x0114, 0x0115},   // 'Ĕ' => 'ĕ'
	1282: {0xA746, 0xA747},   // 'Ꝇ' => 'ꝇ'
	1284: {0x0116, 0x0117},   // 'Ė' => 'ė'
	1291: {0xA748, 0xA749},   // 'Ꝉ' => 'ꝉ'
	1293: {0x0118, 0x0119},   // 'Ę' => 'ę'
	1300: {0xA74A, 0xA74B},   // 'Ꝋ' => 'ꝋ'
	1303: {0x011A, 0x011B},   // 'Ě' => 'ě'
	1310: {0xA74C, 0xA74D},   // 'Ꝍ' => 'ꝍ'
	1312: {0x011C, 0x011D},   // 'Ĝ' => 'ĝ'
	1319: {0xA74E, 0xA74F},   // 'Ꝏ' => 'ꝏ'
	1321: {0x011E, 0x011F},   // 'Ğ' => 'ğ'
	1328: {0xA750, 0xA751},   // 'Ꝑ' => 'ꝑ'
	1330: {0x0120, 0x0121},   // 'Ġ' => 'ġ'
	1337: {0xA752, 0xA753},   // 'Ꝓ' => 'ꝓ'
	1340: {0x0122, 0x0123},   // 'Ģ' => 'ģ'
	1346: {0xA754, 0xA755},   // 'Ꝕ' => 'ꝕ'
	1349: {0x0124, 0x0125},   // 'Ĥ' => 'ĥ'
	1356: {0xA756, 0xA757},   // 'Ꝗ' => 'ꝗ'
	1358: {0x0126, 0x0127},   // 'Ħ' => 'ħ'
	1365: {0xA758, 0xA759},   // 'Ꝙ' => 'ꝙ'
	1367: {0x0128, 0x0129},   // 'Ĩ' => 'ĩ'
	1374: {0xA75A, 0xA75B},   // 'Ꝛ' => 'ꝛ'
	1377: {0x012A, 0x012B},   // 'Ī' => 'ī'
	1383: {0xA75C, 0xA75D},   // 'Ꝝ' => 'ꝝ'
	1386: {0x012C, 0x012D},   // 'Ĭ' => 'ĭ'
	1393: {0xA75E, 0xA75F},   // 'Ꝟ' => 'ꝟ'
	1395: {0x012E, 0x012F},   // 'Į' => 'į'
	1402: {0xA760, 0xA761},   // 'Ꝡ' => 'ꝡ'
	1411: {0xA762, 0xA763},   // 'Ꝣ' => 'ꝣ'
	1414: {0x0132, 0x0133},   // 'Ĳ' => 'ĳ'
	1420: {0xA764, 0xA765},   // 'Ꝥ' => 'ꝥ'
	1423: {0x0134, 0x0135},   // 'Ĵ' => 'ĵ'
	1430: {0xA766, 0xA767},   // 'Ꝧ' => 'ꝧ'
	1432: {0x0136, 0x0137},   // 'Ķ' => 'ķ'
	1439: {0xA768, 0xA769},   // 'Ꝩ' => 'ꝩ'
	1446: {0x0139, 0x013A},   // 'Ĺ' => 'ĺ'
	1448: {0xA76A, 0xA76B},   // 'Ꝫ' => 'ꝫ'
	1455: {0x013B, 0x013C},   // 'Ļ' => 'ļ'
	1457: {0xA76C, 0xA76D},   // 'Ꝭ' => 'ꝭ'
	1464: {0x013D, 0x013E},   // 'Ľ' => 'ľ'
	1467: {0xA76E, 0xA76F},   // 'Ꝯ' => 'ꝯ'
	1474: {0x013F, 0x0140},   // 'Ŀ' => 'ŀ'
	1483: {0x0141, 0x0142},   // 'Ł' => 'ł'
	1492: {0x0143, 0x0144},   // 'Ń' => 'ń'
	1501: {0x0145, 0x0146},   // 'Ņ' => 'ņ'
	1511: {0x0147, 0x0148},   // 'Ň' => 'ň'
	1517: {0xA779, 0xA77A},   // 'Ꝺ' => 'ꝺ'
	1525: {0x014A, 0x014B},   // 'Ŋ' => 'ŋ'
	1527: {0xA77B, 0xA77C},   // 'Ꝼ' => 'ꝼ'
	1534: {0x014C, 0x014D},   // 'Ō' => 'ō'
	1536: {0xA77D, 0x1D79},   // 'Ᵹ' => 'ᵹ'
	1541: {0xA77E, 0xA77F},   // 'Ꝿ' => 'ꝿ'
	1543: {0x014E, 0x014F},   // 'Ŏ' => 'ŏ'
	1550: {0xA780, 0xA781},   // 'Ꞁ' => 'ꞁ'
	1552: {0x0150, 0x0151},   // 'Ő' => 'ő'
	1559: {0xA782, 0xA783},   // 'Ꞃ' => 'ꞃ'
	1561: {0x0152, 0x0153},   // 'Œ' => 'œ'
	1568: {0xA784, 0xA785},   // 'Ꞅ' => 'ꞅ'
	1571: {0x0154, 0x0155},   // 'Ŕ' => 'ŕ'
	1578: {0xA786, 0xA787},   // 'Ꞇ' => 'ꞇ'
	1580: {0x0156, 0x0157},   // 'Ŗ' => 'ŗ'
	1589: {0x0158, 0x0159},   // 'Ř' => 'ř'
	1598: {0x015A, 0x015B},   // 'Ś' => 'ś'
	1601: {0xA78B, 0xA78C},   // 'Ꞌ' => 'ꞌ'
	1608: {0x015C, 0x015D},   // 'Ŝ' => 'ŝ'
	1610: {0xA78D, 0x0265},   // 'Ɥ' => 'ɥ'
	1617: {0x015E, 0x015F},   // 'Ş' => 'ş'
	1624: {0xA790, 0xA791},   // 'Ꞑ' => 'ꞑ'
	1626: {0x0160, 0x0161},   // 'Š' => 'š'
	1633: {0xA792, 0xA793},   // 'Ꞓ' => 'ꞓ'
	1635: {0x0162, 0x0163},   // 'Ţ' => 'ţ'
	1645: {0x0164, 0x0165},   // 'Ť' => 'ť'
	1651: {0xA796, 0xA797},   // 'Ꞗ' => 'ꞗ'
	1654: {0x0166, 0x0167},   // 'Ŧ' => 'ŧ'
	1661: {0xA798, 0xA799},   // 'Ꞙ' => 'ꞙ'
	1663: {0x0168, 0x0169},   // 'Ũ' => 'ũ'
	1670: {0xA79A, 0xA79B},   // 'Ꞛ' => 'ꞛ'
	1672: {0x016A, 0x016B},   // 'Ū' => 'ū'
	1679: {0xA79C, 0xA79D},   // 'Ꞝ' => 'ꞝ'
	1682: {0x016C, 0x016D},   // 'Ŭ' => 'ŭ'
	1688: {0xA79E, 0xA79F},   // 'Ꞟ' => 'ꞟ'
	1691: {0x016E, 0x016F},   // 'Ů' => 'ů'
	1698: {0xA7A0, 0xA7A1},   // 'Ꞡ' => 'ꞡ'
	1700: {0x0170, 0x0171},   // 'Ű' => 'ű'
	1707: {0xA7A2, 0xA7A3},   // 'Ꞣ' => 'ꞣ'
	1709: {0x0172, 0x0173},   // 'Ų' => 'ų'
	1716: {0xA7A4, 0xA7A5},   // 'Ꞥ' => 'ꞥ'
	1719: {0x0174, 0x0175},   // 'Ŵ' => 'ŵ'
	1725: {0xA7A6, 0xA7A7},   // 'Ꞧ' => 'ꞧ'
	1728: {0x0176, 0x0177},   // 'Ŷ' => 'ŷ'
	1735: {0xA7A8, 0xA7A9},   // 'Ꞩ' => 'ꞩ'
	1737: {0x0178, 0x00FF},   // 'Ÿ' => 'ÿ'
	1742: {0x0179, 0x017A},   // 'Ź' => 'ź'
	1744: {0xA7AA, 0x0266},   // 'Ɦ' => 'ɦ'
	1749: {0xA7AB, 0x025C},   // 'Ɜ' => 'ɜ'
	1751: {0x017B, 0x017C},   // 'Ż' => 'ż'
	1753: {0xA7AC, 0x0261},   // 'Ɡ' => 'ɡ'
	1758: {0xA7AD, 0x026C},   // 'Ɬ' => 'ɬ'
	1760: {0x017D, 0x017E},   // 'Ž' => 'ž'
	1762: {0xA7AE, 0x026A},   // 'Ɪ' => 'ɪ'
	1769: {0x017F, 0x0073},   // 'ſ' => 's'
	1772: {0xA7B0, 0x029E},   // 'Ʞ' => 'ʞ'
	1776: {0xA7B1, 0x0287},   // 'Ʇ' => 'ʇ'
	1779: {0x0181, 0x0253},   // 'Ɓ' => 'ɓ'
	1781: {0xA7B2, 0x029D},   // 'Ʝ' => 'ʝ'
	1783: {0x0182, 0x0183},   // 'Ƃ' => 'ƃ'
	1785: {0xA7B3, 0xAB53},   // 'Ꭓ' => 'ꭓ'
	1790: {0xA7B4, 0xA7B5},   // 'Ꞵ' => 'ꞵ'
	1793: {0x0184, 0x0185},   // 'Ƅ' => 'ƅ'
	1799: {0xA7B6, 0xA7B7},   // 'Ꞷ' => 'ꞷ'
	1802: {0x0186, 0x0254},   // 'Ɔ' => 'ɔ'
	1806: {0x0187, 0x0188},   // 'Ƈ' => 'ƈ'
	1809: {0xA7B8, 0xA7B9},   // 'Ꞹ' => 'ꞹ'
	1816: {0x0189, 0x0256},   // 'Ɖ' => 'ɖ'
	1818: {0xA7BA, 0xA7BB},   // 'Ꞻ' => 'ꞻ'
	1820: {0x018A, 0x0257},   // 'Ɗ' => 'ɗ'
	1825: {0x018B, 0x018C},   // 'Ƌ' => 'ƌ'
	1827: {0xA7BC, 0xA7BD},   // 'Ꞽ' => 'ꞽ'
	1836: {0xA7BE, 0xA7BF},   // 'Ꞿ' => 'ꞿ'
	1839: {0x018E, 0x01DD},   // 'Ǝ' => 'ǝ'
	1843: {0x018F, 0x0259},   // 'Ə' => 'ə'
	1848: {0x0190, 0x025B},   // 'Ɛ' => 'ɛ'
	1853: {0x0191, 0x0192},   // 'Ƒ' => 'ƒ'
	1855: {0xA7C2, 0xA7C3},   // 'Ꟃ' => 'ꟃ'
	1862: {0x0193, 0x0260},   // 'Ɠ' => 'ɠ'
	1864: {0xA7C4, 0xA794},   // 'Ꞔ' => 'ꞔ'
	1866: {0x0194, 0x0263},   // 'Ɣ' => 'ɣ'
	1869: {0xA7C5, 0x0282},   // 'Ʂ' => 'ʂ'
	1873: {0xA7C6, 0x1D8E},   // 'Ᶎ' => 'ᶎ'
	1876: {0x0196, 0x0269},   // 'Ɩ' => 'ɩ'
	1878: {0xA7C7, 0xA7C8},   // 'Ꟈ' => 'ꟈ'
	1880: {0x0197, 0x0268},   // 'Ɨ' => 'ɨ'
	1885: {0x0198, 0x0199},   // 'Ƙ' => 'ƙ'
	1887: {0xA7C9, 0xA7CA},   // 'Ꟊ' => 'ꟊ'
	1903: {0x019C, 0x026F},   // 'Ɯ' => 'ɯ'
	1908: {0x019D, 0x0272},   // 'Ɲ' => 'ɲ'
	1917: {0x019F, 0x0275},   // 'Ɵ' => 'ɵ'
	1922: {0x01A0, 0x01A1},   // 'Ơ' => 'ơ'
	1931: {0x01A2, 0x01A3},   // 'Ƣ' => 'ƣ'
	1940: {0x01A4, 0x01A5},   // 'Ƥ' => 'ƥ'
	1950: {0x01A6, 0x0280},   // 'Ʀ' => 'ʀ'
	1954: {0x01A7, 0x01A8},   // 'Ƨ' => 'ƨ'
	1964: {0x01A9, 0x0283},   // 'Ʃ' => 'ʃ'
	1977: {0x01AC, 0x01AD},   // 'Ƭ' => 'ƭ'
	1987: {0x01AE, 0x0288},   // 'Ʈ' => 'ʈ'
	1991: {0x01AF, 0x01B0},   // 'Ư' => 'ư'
	2000: {0x01B1, 0x028A},   // 'Ʊ' => 'ʊ'
	2005: {0x01B2, 0x028B},   // 'Ʋ' => 'ʋ'
	2010: {0x01B3, 0x01B4},   // 'Ƴ' => 'ƴ'
	2019: {0x01B5, 0x01B6},   // 'Ƶ' => 'ƶ'
	2028: {0x01B7, 0x0292},   // 'Ʒ' => 'ʒ'
	2033: {0x01B8, 0x01B9},   // 'Ƹ' => 'ƹ'
	2051: {0x01BC, 0x01BD},   // 'Ƽ' => 'ƽ'
	2088: {0x01C4, 0x01C6},   // 'Ǆ' => 'ǆ'
	2090: {0xA7F5, 0xA7F6},   // 'Ꟶ' => 'ꟶ'
	2093: {0x01C5, 0x01C6},   // 'ǅ' => 'ǆ'
	2102: {0x01C7, 0x01C9},   // 'Ǉ' => 'ǉ'
	2107: {0x01C8, 0x01C9},   // 'ǈ' => 'ǉ'
	2116: {0x01CA, 0x01CC},   // 'Ǌ' => 'ǌ'
	2121: {0x01CB, 0x01CC},   // 'ǋ' => 'ǌ'
	2130: {0x01CD, 0x01CE},   // 'Ǎ' => 'ǎ'
	2139: {0x01CF, 0x01D0},   // 'Ǐ' => 'ǐ'
	2148: {0x01D1, 0x01D2},   // 'Ǒ' => 'ǒ'
	2158: {0x01D3, 0x01D4},   // 'Ǔ' => 'ǔ'
	2167: {0x01D5, 0x01D6},   // 'Ǖ' => 'ǖ'
	2176: {0x01D7, 0x01D8},   // 'Ǘ' => 'ǘ'
	2185: {0x01D9, 0x01DA},   // 'Ǚ' => 'ǚ'
	2195: {0x01DB, 0x01DC},   // 'Ǜ' => 'ǜ'
	2208: {0x01DE, 0x01DF},   // 'Ǟ' => 'ǟ'
	2218: {0x01E0, 0x01E1},   // 'Ǡ' => 'ǡ'
	2227: {0x01E2, 0x01E3},   // 'Ǣ' => 'ǣ'
	2236: {0x01E4, 0x01E5},   // 'Ǥ' => 'ǥ'
	2245: {0x01E6, 0x01E7},   // 'Ǧ' => 'ǧ'
	2255: {0x01E8, 0x01E9},   // 'Ǩ' => 'ǩ'
	2264: {0x01EA, 0x01EB},   // 'Ǫ' => 'ǫ'
	2273: {0x01EC, 0x01ED},   // 'Ǭ' => 'ǭ'
	2282: {0x01EE, 0x01EF},   // 'Ǯ' => 'ǯ'
	2296: {0x01F1, 0x01F3},   // 'Ǳ' => 'ǳ'
	2301: {0x01F2, 0x01F3},   // 'ǲ' => 'ǳ'
	2310: {0x01F4, 0x01F5},   // 'Ǵ' => 'ǵ'
	2319: {0x01F6, 0x0195},   // 'Ƕ' => 'ƕ'
	2324: {0x01F7, 0x01BF},   // 'Ƿ' => 'ƿ'
	2329: {0x01F8, 0x01F9},   // 'Ǹ' => 'ǹ'
	2338: {0x01FA, 0x01FB},   // 'Ǻ' => 'ǻ'
	2347: {0x01FC, 0x01FD},   // 'Ǽ' => 'ǽ'
	2356: {0x01FE, 0x01FF},   // 'Ǿ' => 'ǿ'
	2366: {0x0200, 0x0201},   // 'Ȁ' => 'ȁ'
	2375: {0x0202, 0x0203},   // 'Ȃ' => 'ȃ'
	2384: {0x0204, 0x0205},   // 'Ȅ' => 'ȅ'
	2393: {0x0206, 0x0207},   // 'Ȇ' => 'ȇ'
	2403: {0x0208, 0x0209},   // 'Ȉ' => 'ȉ'
	2412: {0x020A, 0x020B},   // 'Ȋ' => 'ȋ'
	2421: {0x020C, 0x020D},   // 'Ȍ' => 'ȍ'
	2430: {0x020E, 0x020F},   // 'Ȏ' => 'ȏ'
	2440: {0x0210, 0x0211},   // 'Ȑ' => 'ȑ'
	2449: {0x0212, 0x0213},   // 'Ȓ' => 'ȓ'
	2458: {0x0214, 0x0215},   // 'Ȕ' => 'ȕ'
	2467: {0x0216, 0x0217},   // 'Ȗ' => 'ȗ'
	2470: {0x24B6, 0x24D0},   // 'Ⓐ' => 'ⓐ'
	2474: {0x24B7, 0x24D1},   // 'Ⓑ' => 'ⓑ'
	2476: {0x0218, 0x0219},   // 'Ș' => 'ș'
	2479: {0x24B8, 0x24D2},   // 'Ⓒ' => 'ⓒ'
	2484: {0x24B9, 0x24D3},   // 'Ⓓ' => 'ⓓ'
	2486: {0x021A, 0x021B},   // 'Ț' => 'ț'
	2488: {0x24BA, 0x24D4},   // 'Ⓔ' => 'ⓔ'
	2493: {0x24BB, 0x24D5},   // 'Ⓕ' => 'ⓕ'
	2495: {0x021C, 0x021D},   // 'Ȝ' => 'ȝ'
	2498: {0x24BC, 0x24D6},   // 'Ⓖ' => 'ⓖ'
	2502: {0x24BD, 0x24D7},   // 'Ⓗ' => 'ⓗ'
	2504: {0x021E, 0x021F},   // 'Ȟ' => 'ȟ'
	2507: {0x24BE, 0x24D8},   // 'Ⓘ' => 'ⓘ'
	2511: {0x24BF, 0x24D9},   // 'Ⓙ' => 'ⓙ'
	2513: {0x0220, 0x019E},   // 'Ƞ' => 'ƞ'
	2516: {0x24C0, 0x24DA},   // 'Ⓚ' => 'ⓚ'
	2521: {0x24C1, 0x24DB},   // 'Ⓛ' => 'ⓛ'
	2523: {0x0222, 0x0223},   // 'Ȣ' => 'ȣ'
	2525: {0x24C2, 0x24DC},   // 'Ⓜ' => 'ⓜ'
	2530: {0x24C3, 0x24DD},   // 'Ⓝ' => 'ⓝ'
	2532: {0x0224, 0x0225},   // 'Ȥ' => 'ȥ'
	2535: {0x24C4, 0x24DE},   // 'Ⓞ' => 'ⓞ'
	2539: {0x24C5, 0x24DF},   // 'Ⓟ' => 'ⓟ'
	2541: {0x0226, 0x0227},   // 'Ȧ' => 'ȧ'
	2544: {0x24C6, 0x24E0},   // 'Ⓠ' => 'ⓠ'
	2548: {0x24C7, 0x24E1},   // 'Ⓡ' => 'ⓡ'
	2550: {0x0228, 0x0229},   // 'Ȩ' => 'ȩ'
	2553: {0x24C8, 0x24E2},   // 'Ⓢ' => 'ⓢ'
	2558: {0x24C9, 0x24E3},   // 'Ⓣ' => 'ⓣ'
	2560: {0x022A, 0x022B},   // 'Ȫ' => 'ȫ'
	2562: {0x24CA, 0x24E4},   // 'Ⓤ' => 'ⓤ'
	2567: {0x24CB, 0x24E5},   // 'Ⓥ' => 'ⓥ'
	2569: {0x022C, 0x022D},   // 'Ȭ' => 'ȭ'
	2571: {0x24CC, 0x24E6},   // 'Ⓦ' => 'ⓦ'
	2576: {0x24CD, 0x24E7},   // 'Ⓧ' => 'ⓧ'
	2578: {0x022E, 0x022F},   // 'Ȯ' => 'ȯ'
	2581: {0x24CE, 0x24E8},   // 'Ⓨ' => 'ⓨ'
	2585: {0x24CF, 0x24E9},   // 'Ⓩ' => 'ⓩ'
	2587: {0x0230, 0x0231},   // 'Ȱ' => 'ȱ'
	2597: {0x0232, 0x0233},   // 'Ȳ' => 'ȳ'
	2634: {0x023A, 0x2C65},   // 'Ⱥ' => 'ⱥ'
	2638: {0x023B, 0x023C},   // 'Ȼ' => 'ȼ'
	2647: {0x023D, 0x019A},   // 'Ƚ' => 'ƚ'
	2652: {0x023E, 0x2C66},   // 'Ⱦ' => 'ⱦ'
	2666: {0x0241, 0x0242},   // 'Ɂ' => 'ɂ'
	2675: {0x0243, 0x0180},   // 'Ƀ' => 'ƀ'
	2680: {0x0244, 0x0289},   // 'Ʉ' => 'ʉ'
	2684: {0x0245, 0x028C},   // 'Ʌ' => 'ʌ'
	2689: {0x0246, 0x0247},   // 'Ɇ' => 'ɇ'
	2698: {0x0248, 0x0249},   // 'Ɉ' => 'ɉ'
	2708: {0x024A, 0x024B},   // 'Ɋ' => 'ɋ'
	2717: {0x024C, 0x024D},   // 'Ɍ' => 'ɍ'
	2723: {0x1E00, 0x1E01},   // 'Ḁ' => 'ḁ'
	2726: {0x024E, 0x024F},   // 'Ɏ' => 'ɏ'
	2732: {0x1E02, 0x1E03},   // 'Ḃ' => 'ḃ'
	2741: {0x1E04, 0x1E05},   // 'Ḅ' => 'ḅ'
	2750: {0x1E06, 0x1E07},   // 'Ḇ' => 'ḇ'
	2760: {0x1E08, 0x1E09},   // 'Ḉ' => 'ḉ'
	2769: {0x1E0A, 0x1E0B},   // 'Ḋ' => 'ḋ'
	2778: {0x1E0C, 0x1E0D},   // 'Ḍ' => 'ḍ'
	2787: {0x1E0E, 0x1E0F},   // 'Ḏ' => 'ḏ'
	2796: {0x1E10, 0x1E11},   // 'Ḑ' => 'ḑ'
	2806: {0x1E12, 0x1E13},   // 'Ḓ' => 'ḓ'
	2815: {0x1E14, 0x1E15},   // 'Ḕ' => 'ḕ'
	2824: {0x1E16, 0x1E17},   // 'Ḗ' => 'ḗ'
	2833: {0x1E18, 0x1E19},   // 'Ḙ' => 'ḙ'
	2843: {0x1E1A, 0x1E1B},   // 'Ḛ' => 'ḛ'
	2852: {0x1E1C, 0x1E1D},   // 'Ḝ' => 'ḝ'
	2861: {0x1E1E, 0x1E1F},   // 'Ḟ' => 'ḟ'
	2870: {0x1E20, 0x1E21},   // 'Ḡ' => 'ḡ'
	2880: {0x1E22, 0x1E23},   // 'Ḣ' => 'ḣ'
	2889: {0x1E24, 0x1E25},   // 'Ḥ' => 'ḥ'
	2898: {0x1E26, 0x1E27},   // 'Ḧ' => 'ḧ'
	2901: {0x2C00, 0x2C30},   // 'Ⰰ' => 'ⰰ'
	2906: {0x2C01, 0x2C31},   // 'Ⰱ' => 'ⰱ'
	2907: {0x1E28, 0x1E29},   // 'Ḩ' => 'ḩ'
	2910: {0x2C02, 0x2C32},   // 'Ⰲ' => 'ⰲ'
	2915: {0x2C03, 0x2C33},   // 'Ⰳ' => 'ⰳ'
	2917: {0x1E2A, 0x1E2B},   // 'Ḫ' => 'ḫ'
	2920: {0x2C04, 0x2C34},   // 'Ⰴ' => 'ⰴ'
	2924: {0x2C05, 0x2C35},   // 'Ⰵ' => 'ⰵ'
	2926: {0x1E2C, 0x1E2D},   // 'Ḭ' => 'ḭ'
	2929: {0x2C06, 0x2C36},   // 'Ⰶ' => 'ⰶ'
	2933: {0x2C07, 0x2C37},   // 'Ⰷ' => 'ⰷ'
	2935: {0x1E2E, 0x1E2F},   // 'Ḯ' => 'ḯ'
	2938: {0x2C08, 0x2C38},   // 'Ⰸ' => 'ⰸ'
	2943: {0x2C09, 0x2C39},   // 'Ⰹ' => 'ⰹ'
	2944: {0x1E30, 0x1E31},   // 'Ḱ' => 'ḱ'
	2947: {0x2C0A, 0x2C3A},   // 'Ⰺ' => 'ⰺ'
	2952: {0x2C0B, 0x2C3B},   // 'Ⰻ' => 'ⰻ'
	2954: {0x1E32, 0x1E33},   // 'Ḳ' => 'ḳ'
	2956: {0x2C0C, 0x2C3C},   // 'Ⰼ' => 'ⰼ'
	2961: {0x2C0D, 0x2C3D},   // 'Ⰽ' => 'ⰽ'
	2963: {0x1E34, 0x1E35},   // 'Ḵ' => 'ḵ'
	2966: {0x2C0E, 0x2C3E},   // 'Ⰾ' => 'ⰾ'
	2970: {0x2C0F, 0x2C3F},   // 'Ⰿ' => 'ⰿ'
	2972: {0x1E36, 0x1E37},   // 'Ḷ' => 'ḷ'
	2975: {0x2C10, 0x2C40},   // 'Ⱀ' => 'ⱀ'
	2980: {0x2C11, 0x2C41},   // 'Ⱁ' => 'ⱁ'
	2981: {0x1E38, 0x1E39},   // 'Ḹ' => 'ḹ'
	2984: {0x2C12, 0x2C42},   // 'Ⱂ' => 'ⱂ'
	2989: {0x2C13, 0x2C43},   // 'Ⱃ' => 'ⱃ'
	2991: {0x1E3A, 0x1E3B},   // 'Ḻ' => 'ḻ'
	2993: {0x2C14, 0x2C44},   // 'Ⱄ' => 'ⱄ'
	2998: {0x2C15, 0x2C45},   // 'Ⱅ' => 'ⱅ'
	3000: {0x1E3C, 0x1E3D},   // 'Ḽ' => 'ḽ'
	3003: {0x2C16, 0x2C46},   // 'Ⱆ' => 'ⱆ'
	3007: {0x2C17, 0x2C47},   // 'Ⱇ' => 'ⱇ'
	3009: {0x1E3E, 0x1E3F},   // 'Ḿ' => 'ḿ'
	3012: {0x2C18, 0x2C48},   // 'Ⱈ' => 'ⱈ'
	3017: {0x2C19, 0x2C49},   // 'Ⱉ' => 'ⱉ'
	3018: {0x1E40, 0x1E41},   // 'Ṁ' => 'ṁ'
	3021: {0x2C1A, 0x2C4A},   // 'Ⱊ' => 'ⱊ'
	3026: {0x2C1B, 0x2C4B},   // 'Ⱋ' => 'ⱋ'
	3028: {0x1E42, 0x1E43},   // 'Ṃ' => 'ṃ'
	3030: {0x2C1C, 0x2C4C},   // 'Ⱌ' => 'ⱌ'
	3035: {0x2C1D, 0x2C4D},   // 'Ⱍ' => 'ⱍ'
	3037: {0x1E44, 0x1E45},   // 'Ṅ' => 'ṅ'
	3040: {0x2C1E, 0x2C4E},   // 'Ⱎ' => 'ⱎ'
	3044: {0x2C1F, 0x2C4F},   // 'Ⱏ' => 'ⱏ'
	3046: {0x1E46, 0x1E47},   // 'Ṇ' => 'ṇ'
	3049: {0x2C20, 0x2C50},   // 'Ⱐ' => 'ⱐ'
	3054: {0x2C21, 0x2C51},   // 'Ⱑ' => 'ⱑ'
	3055: {0x1E48, 0x1E49},   // 'Ṉ' => 'ṉ'
	3058: {0x2C22, 0x2C52},   // 'Ⱒ' => 'ⱒ'
	3063: {0x2C23, 0x2C53},   // 'Ⱓ' => 'ⱓ'
	3065: {0x1E4A, 0x1E4B},   // 'Ṋ' => 'ṋ'
	3067: {0x2C24, 0x2C54},   // 'Ⱔ' => 'ⱔ'
	3072: {0x2C25, 0x2C55},   // 'Ⱕ' => 'ⱕ'
	3074: {0x1E4C, 0x1E4D},   // 'Ṍ' => 'ṍ'
	3077: {0x2C26, 0x2C56},   // 'Ⱖ' => 'ⱖ'
	3081: {0x2C27, 0x2C57},   // 'Ⱗ' => 'ⱗ'
	3083: {0x1E4E, 0x1E4F},   // 'Ṏ' => 'ṏ'
	3086: {0x2C28, 0x2C58},   // 'Ⱘ' => 'ⱘ'
	3090: {0x2C29, 0x2C59},   // 'Ⱙ' => 'ⱙ'
	3092: {0x1E50, 0x1E51},   // 'Ṑ' => 'ṑ'
	3095: {0x2C2A, 0x2C5A},   // 'Ⱚ' => 'ⱚ'
	3100: {0x2C2B, 0x2C5B},   // 'Ⱛ' => 'ⱛ'
	3101: {0x1E52, 0x1E53},   // 'Ṓ' => 'ṓ'
	3104: {0x2C2C, 0x2C5C},   // 'Ⱜ' => 'ⱜ'
	3109: {0x2C2D, 0x2C5D},   // 'Ⱝ' => 'ⱝ'
	3111: {0x1E54, 0x1E55},   // 'Ṕ' => 'ṕ'
	3114: {0x2C2E, 0x2C5E},   // 'Ⱞ' => 'ⱞ'
	3120: {0x1E56, 0x1E57},   // 'Ṗ' => 'ṗ'
	3129: {0x1E58, 0x1E59},   // 'Ṙ' => 'ṙ'
	3138: {0x1E5A, 0x1E5B},   // 'Ṛ' => 'ṛ'
	3148: {0x1E5C, 0x1E5D},   // 'Ṝ' => 'ṝ'
	3157: {0x1E5E, 0x1E5F},   // 'Ṟ' => 'ṟ'
	3166: {0x1E60, 0x1E61},   // 'Ṡ' => 'ṡ'
	3175: {0x1E62, 0x1E63},   // 'Ṣ' => 'ṣ'
	3185: {0x1E64, 0x1E65},   // 'Ṥ' => 'ṥ'
	3194: {0x1E66, 0x1E67},   // 'Ṧ' => 'ṧ'
	3203: {0x1E68, 0x1E69},   // 'Ṩ' => 'ṩ'
	3212: {0x1E6A, 0x1E6B},   // 'Ṫ' => 'ṫ'
	3222: {0x1E6C, 0x1E6D},   // 'Ṭ' => 'ṭ'
	3231: {0x1E6E, 0x1E6F},   // 'Ṯ' => 'ṯ'
	3240: {0x1E70, 0x1E71},   // 'Ṱ' => 'ṱ'
	3249: {0x1E72, 0x1E73},   // 'Ṳ' => 'ṳ'
	3259: {0x1E74, 0x1E75},   // 'Ṵ' => 'ṵ'
	3268: {0x1E76, 0x1E77},   // 'Ṷ' => 'ṷ'
	3277: {0x1E78, 0x1E79},   // 'Ṹ' => 'ṹ'
	3283: {0x10A0, 0x2D00},   // 'Ⴀ' => 'ⴀ'
	3286: {0x1E7A, 0x1E7B},   // 'Ṻ' => 'ṻ'
	3288: {0x10A1, 0x2D01},   // 'Ⴁ' => 'ⴁ'
	3293: {0x10A2, 0x2D02},   // 'Ⴂ' => 'ⴂ'
	3296: {0x1E7C, 0x1E7D},   // 'Ṽ' => 'ṽ'
	3297: {0x10A3, 0x2D03},   // 'Ⴃ' => 'ⴃ'
	3302: {0x10A4, 0x2D04},   // 'Ⴄ' => 'ⴄ'
	3305: {0x1E7E, 0x1E7F},   // 'Ṿ' => 'ṿ'
	3307: {0x10A5, 0x2D05},   // 'Ⴅ' => 'ⴅ'
	3311: {0x10A6, 0x2D06},   // 'Ⴆ' => 'ⴆ'
	3314: {0x1E80, 0x1E81},   // 'Ẁ' => 'ẁ'
	3316: {0x10A7, 0x2D07},   // 'Ⴇ' => 'ⴇ'
	3320: {0x10A8, 0x2D08},   // 'Ⴈ' => 'ⴈ'
	3323: {0x1E82, 0x1E83},   // 'Ẃ' => 'ẃ'
	3325: {0x10A9, 0x2D09},   // 'Ⴉ' => 'ⴉ'
	3330: {0x10AA, 0x2D0A},   // 'Ⴊ' => 'ⴊ'
	3333: {0x1E84, 0x1E85},   // 'Ẅ' => 'ẅ'
	3334: {0x10AB, 0x2D0B},   // 'Ⴋ' => 'ⴋ'
	3339: {0x10AC, 0x2D0C},   // 'Ⴌ' => 'ⴌ'
	3342: {0x1E86, 0x1E87},   // 'Ẇ' => 'ẇ'
	3344: {0x10AD, 0x2D0D},   // 'Ⴍ' => 'ⴍ'
	3345: {0x2C60, 0x2C61},   // 'Ⱡ' => 'ⱡ'
	3348: {0x10AE, 0x2D0E},   // 'Ⴎ' => 'ⴎ'
	3351: {0x1E88, 0x1E89},   // 'Ẉ' => 'ẉ'
	3353: {0x10AF, 0x2D0F},   // 'Ⴏ' => 'ⴏ'
	3354: {0x2C62, 0x026B},   // 'Ɫ' => 'ɫ'
	3357: {0x10B0, 0x2D10},   // 'Ⴐ' => 'ⴐ'
	3359: {0x2C63, 0x1D7D},   // 'Ᵽ' => 'ᵽ'
	3360: {0x1E8A, 0x1E8B},   // 'Ẋ' => 'ẋ'
	3362: {0x10B1, 0x2D11},   // 'Ⴑ' => 'ⴑ'
	3363: {0x2C64, 0x027D},   // 'Ɽ' => 'ɽ'
	3367: {0x10B2, 0x2D12},   // 'Ⴒ' => 'ⴒ'
	3370: {0x1E8C, 0x1E8D},   // 'Ẍ' => 'ẍ'
	3371: {0x10B3, 0x2D13},   // 'Ⴓ' => 'ⴓ'
	3376: {0x10B4, 0x2D14},   // 'Ⴔ' => 'ⴔ'
	3377: {0x2C67, 0x2C68},   // 'Ⱨ' => 'ⱨ'
	3379: {0x1E8E, 0x1E8F},   // 'Ẏ' => 'ẏ'
	3380: {0x10B5, 0x2D15},   // 'Ⴕ' => 'ⴕ'
	3385: {0x10B6, 0x2D16},   // 'Ⴖ' => 'ⴖ'
	3386: {0x2C69, 0x2C6A},   // 'Ⱪ' => 'ⱪ'
	3388: {0x1E90, 0x1E91},   // 'Ẑ' => 'ẑ'
	3390: {0x10B7, 0x2D17},   // 'Ⴗ' => 'ⴗ'
	3394: {0x10B8, 0x2D18},   // 'Ⴘ' => 'ⴘ'
	3395: {0x2C6B, 0x2C6C},   // 'Ⱬ' => 'ⱬ'
	3397: {0x1E92, 0x1E93},   // 'Ẓ' => 'ẓ'
	3399: {0x10B9, 0x2D19},   // 'Ⴙ' => 'ⴙ'
	3404: {0x10BA, 0x2D1A},   // 'Ⴚ' => 'ⴚ'
	3405: {0x2C6D, 0x0251},   // 'Ɑ' => 'ɑ'
	3406: {0x1E94, 0x1E95},   // 'Ẕ' => 'ẕ'
	3408: {0x10BB, 0x2D1B},   // 'Ⴛ' => 'ⴛ'
	3409: {0x2C6E, 0x0271},   // 'Ɱ' => 'ɱ'
	3413: {0x10BC, 0x2D1C},   // 'Ⴜ' => 'ⴜ'
	3414: {0x2C6F, 0x0250},   // 'Ɐ' => 'ɐ'
	3417: {0x10BD, 0x2D1D},   // 'Ⴝ' => 'ⴝ'
	3419: {0x2C70, 0x0252},   // 'Ɒ' => 'ɒ'
	3422: {0x10BE, 0x2D1E},   // 'Ⴞ' => 'ⴞ'
	3427: {0x10BF, 0x2D1F},   // 'Ⴟ' => 'ⴟ'
	3428: {0x2C72, 0x2C73},   // 'Ⱳ' => 'ⱳ'
	3431: {0x10C0, 0x2D20},   // 'Ⴠ' => 'ⴠ'
	3436: {0x10C1, 0x2D21},   // 'Ⴡ' => 'ⴡ'
	3439: {0x1E9B, 0x1E61},   // 'ẛ' => 'ṡ'
	3441: {0x10C2, 0x2D22},   // 'Ⴢ' => 'ⴢ'
	3442: {0x2C75, 0x2C76},   // 'Ⱶ' => 'ⱶ'
	3445: {0x10C3, 0x2D23},   // 'Ⴣ' => 'ⴣ'
	3450: {0x10C4, 0x2D24},   // 'Ⴤ' => 'ⴤ'
	3453: {0x1E9E, 0x00DF},   // 'ẞ' => 'ß'
	3454: {0x10C5, 0x2D25},   // 'Ⴥ' => 'ⴥ'
	3462: {0x1EA0, 0x1EA1},   // 'Ạ' => 'ạ'
	3464: {0x10C7, 0x2D27},   // 'Ⴧ' => 'ⴧ'
	3471: {0x1EA2, 0x1EA3},   // 'Ả' => 'ả'
	3480: {0x1EA4, 0x1EA5},   // 'Ấ' => 'ấ'
	3483: {0x2C7E, 0x023F},   // 'Ȿ' => 'ȿ'
	3488: {0x2C7F, 0x0240},   // 'Ɀ' => 'ɀ'
	3490: {0x1EA6, 0x1EA7},   // 'Ầ' => 'ầ'
	3491: {0x10CD, 0x2D2D},   // 'Ⴭ' => 'ⴭ'
	3493: {0x2C80, 0x2C81},   // 'Ⲁ' => 'ⲁ'
	3499: {0x1EA8, 0x1EA9},   // 'Ẩ' => 'ẩ'
	3502: {0x2C82, 0x2C83},   // 'Ⲃ' => 'ⲃ'
	3508: {0x1EAA, 0x1EAB},   // 'Ẫ' => 'ẫ'
	3511: {0x2C84, 0x2C85},   // 'Ⲅ' => 'ⲅ'
	3517: {0x1EAC, 0x1EAD},   // 'Ậ' => 'ậ'
	3520: {0x2C86, 0x2C87},   // 'Ⲇ' => 'ⲇ'
	3527: {0x1EAE, 0x1EAF},   // 'Ắ' => 'ắ'
	3530: {0x2C88, 0x2C89},   // 'Ⲉ' => 'ⲉ'
	3536: {0x1EB0, 0x1EB1},   // 'Ằ' => 'ằ'
	3539: {0x2C8A, 0x2C8B},   // 'Ⲋ' => 'ⲋ'
	3545: {0x1EB2, 0x1EB3},   // 'Ẳ' => 'ẳ'
	3548: {0x2C8C, 0x2C8D},   // 'Ⲍ' => 'ⲍ'
	3554: {0x1EB4, 0x1EB5},   // 'Ẵ' => 'ẵ'
	3557: {0x2C8E, 0x2C8F},   // 'Ⲏ' => 'ⲏ'
	3564: {0x1EB6, 0x1EB7},   // 'Ặ' => 'ặ'
	3566: {0x2C90, 0x2C91},   // 'Ⲑ' => 'ⲑ'
	3573: {0x1EB8, 0x1EB9},   // 'Ẹ' => 'ẹ'
	3576: {0x2C92, 0x2C93},   // 'Ⲓ' => 'ⲓ'
	3582: {0x1EBA, 0x1EBB},   // 'Ẻ' => 'ẻ'
	3585: {0x2C94, 0x2C95},   // 'Ⲕ' => 'ⲕ'
	3591: {0x1EBC, 0x1EBD},   // 'Ẽ' => 'ẽ'
	3594: {0x2C96, 0x2C97},   // 'Ⲗ' => 'ⲗ'
	3601: {0x1EBE, 0x1EBF},   // 'Ế' => 'ế'
	3603: {0x2C98, 0x2C99},   // 'Ⲙ' => 'ⲙ'
	3610: {0x1EC0, 0x1EC1},   // 'Ề' => 'ề'
	3613: {0x2C9A, 0x2C9B},   // 'Ⲛ' => 'ⲛ'
	3619: {0x1EC2, 0x1EC3},   // 'Ể' => 'ể'
	3622: {0x2C9C, 0x2C9D},   // 'Ⲝ' => 'ⲝ'
	3628: {0x1EC4, 0x1EC5},   // 'Ễ' => 'ễ'
	3631: {0x2C9E, 0x2C9F},   // 'Ⲟ' => 'ⲟ'
	3638: {0x1EC6, 0x1EC7},   // 'Ệ' => 'ệ'
	3640: {0x2CA0, 0x2CA1},   // 'Ⲡ' => 'ⲡ'
	3647: {0x1EC8, 0x1EC9},   // 'Ỉ' => 'ỉ'
	3650: {0x2CA2, 0x2CA3},   // 'Ⲣ' => 'ⲣ'
	3656: {0x1ECA, 0x1ECB},   // 'Ị' => 'ị'
	3659: {0x2CA4, 0x2CA5},   // 'Ⲥ' => 'ⲥ'
	3665: {0x1ECC, 0x1ECD},   // 'Ọ' => 'ọ'
	3668: {0x2CA6, 0x2CA7},   // 'Ⲧ' => 'ⲧ'
	3675: {0x1ECE, 0x1ECF},   // 'Ỏ' => 'ỏ'
	3677: {0x2CA8, 0x2CA9},   // 'Ⲩ' => 'ⲩ'
	3684: {0x1ED0, 0x1ED1},   // 'Ố' => 'ố'
	3687: {0x2CAA, 0x2CAB},   // 'Ⲫ' => 'ⲫ'
	3693: {0x1ED2, 0x1ED3},   // 'Ồ' => 'ồ'
	3696: {0x2CAC, 0x2CAD},   // 'Ⲭ' => 'ⲭ'
	3702: {0x1ED4, 0x1ED5},   // 'Ổ' => 'ổ'
	3705: {0x2CAE, 0x2CAF},   // 'Ⲯ' => 'ⲯ'
	3711: {0x1ED6, 0x1ED7},   // 'Ỗ' => 'ỗ'
	3714: {0x2CB0, 0x2CB1},   // 'Ⲱ' => 'ⲱ'
	3721: {0x1ED8, 0x1ED9},   // 'Ộ' => 'ộ'
	3724: {0x2CB2, 0x2CB3},   // 'Ⲳ' => 'ⲳ'
	3730: {0x1EDA, 0x1EDB},   // 'Ớ' => 'ớ'
	3733: {0x2CB4, 0x2CB5},   // 'Ⲵ' => 'ⲵ'
	3739: {0x1EDC, 0x1EDD},   // 'Ờ' => 'ờ'
	3742: {0x2CB6, 0x2CB7},   // 'Ⲷ' => 'ⲷ'
	3748: {0x1EDE, 0x1EDF},   // 'Ở' => 'ở'
	3751: {0x2CB8, 0x2CB9},   // 'Ⲹ' => 'ⲹ'
	3758: {0x1EE0, 0x1EE1},   // 'Ỡ' => 'ỡ'
	3761: {0x2CBA, 0x2CBB},   // 'Ⲻ' => 'ⲻ'
	3767: {0x1EE2, 0x1EE3},   // 'Ợ' => 'ợ'
	3770: {0x2CBC, 0x2CBD},   // 'Ⲽ' => 'ⲽ'
	3776: {0x1EE4, 0x1EE5},   // 'Ụ' => 'ụ'
	3779: {0x2CBE, 0x2CBF},   // 'Ⲿ' => 'ⲿ'
	3785: {0x1EE6, 0x1EE7},   // 'Ủ' => 'ủ'
	3788: {0x2CC0, 0x2CC1},   // 'Ⳁ' => 'ⳁ'
	3795: {0x1EE8, 0x1EE9},   // 'Ứ' => 'ứ'
	3798: {0x2CC2, 0x2CC3},   // 'Ⳃ' => 'ⳃ'
	3804: {0x1EEA, 0x1EEB},   // 'Ừ' => 'ừ'
	3807: {0x2CC4, 0x2CC5},   // 'Ⳅ' => 'ⳅ'
	3813: {0x1EEC, 0x1EED},   // 'Ử' => 'ử'
	3816: {0x2CC6, 0x2CC7},   // 'Ⳇ' => 'ⳇ'
	3822: {0x1EEE, 0x1EEF},   // 'Ữ' => 'ữ'
	3825: {0x2CC8, 0x2CC9},   // 'Ⳉ' => 'ⳉ'
	3832: {0x1EF0, 0x1EF1},   // 'Ự' => 'ự'
	3835: {0x2CCA, 0x2CCB},   // 'Ⳋ' => 'ⳋ'
	3841: {0x1EF2, 0x1EF3},   // 'Ỳ' => 'ỳ'
	3844: {0x2CCC, 0x2CCD},   // 'Ⳍ' => 'ⳍ'
	3850: {0x1EF4, 0x1EF5},   // 'Ỵ' => 'ỵ'
	3853: {0x2CCE, 0x2CCF},   // 'Ⳏ' => 'ⳏ'
	3859: {0x1EF6, 0x1EF7},   // 'Ỷ' => 'ỷ'
	3862: {0x2CD0, 0x2CD1},   // 'Ⳑ' => 'ⳑ'
	3867: {0x0345, 0x03B9},   // 'ͅ' => 'ι'
	3869: {0x1EF8, 0x1EF9},   // 'Ỹ' => 'ỹ'
	3871: {0x2CD2, 0x2CD3},   // 'Ⳓ' => 'ⳓ'
	3878: {0x1EFA, 0x1EFB},   // 'Ỻ' => 'ỻ'
	3881: {0x2CD4, 0x2CD5},   // 'Ⳕ' => 'ⳕ'
	3887: {0x1EFC, 0x1EFD},   // 'Ỽ' => 'ỽ'
	3890: {0x2CD6, 0x2CD7},   // 'Ⳗ' => 'ⳗ'
	3896: {0x1EFE, 0x1EFF},   // 'Ỿ' => 'ỿ'
	3899: {0x2CD8, 0x2CD9},   // 'Ⳙ' => 'ⳙ'
	3908: {0x2CDA, 0x2CDB},   // 'Ⳛ' => 'ⳛ'
	3918: {0x2CDC, 0x2CDD},   // 'Ⳝ' => 'ⳝ'
	3927: {0x2CDE, 0x2CDF},   // 'Ⳟ' => 'ⳟ'
	3936: {0x2CE0, 0x2CE1},   // 'Ⳡ' => 'ⳡ'
	3943: {0x1F08, 0x1F00},   // 'Ἀ' => 'ἀ'
	3945: {0x2CE2, 0x2CE3},   // 'Ⳣ' => 'ⳣ'
	3947: {0x1F09, 0x1F01},   // 'Ἁ' => 'ἁ'
	3952: {0x1F0A, 0x1F02},   // 'Ἂ' => 'ἂ'
	3956: {0x1F0B, 0x1F03},   // 'Ἃ' => 'ἃ'
	3961: {0x1F0C, 0x1F04},   // 'Ἄ' => 'ἄ'
	3966: {0x1F0D, 0x1F05},   // 'Ἅ' => 'ἅ'
	3970: {0x1F0E, 0x1F06},   // 'Ἆ' => 'ἆ'
	3975: {0x1F0F, 0x1F07},   // 'Ἇ' => 'ἇ'
	3987: {0x2CEB, 0x2CEC},   // 'Ⳬ' => 'ⳬ'
	3996: {0x2CED, 0x2CEE},   // 'Ⳮ' => 'ⳮ'
	4016: {0x1F18, 0x1F10},   // 'Ἐ' => 'ἐ'
	4019: {0x2CF2, 0x2CF3},   // 'Ⳳ' => 'ⳳ'
	4021: {0x1F19, 0x1F11},   // 'Ἑ' => 'ἑ'
	4026: {0x1F1A, 0x1F12},   // 'Ἒ' => 'ἒ'
	4030: {0x1F1B, 0x1F13},   // 'Ἓ' => 'ἓ'
	4035: {0x1F1C, 0x1F14},   // 'Ἔ' => 'ἔ'
	4040: {0x1F1D, 0x1F15},   // 'Ἕ' => 'ἕ'
	4066: {0x0370, 0x0371},   // 'Ͱ' => 'ͱ'
	4075: {0x0372, 0x0373},   // 'Ͳ' => 'ͳ'
	4090: {0x1F28, 0x1F20},   // 'Ἠ' => 'ἠ'
	4094: {0x0376, 0x0377},   // 'Ͷ' => 'ͷ'
	4095: {0x1F29, 0x1F21},   // 'Ἡ' => 'ἡ'
	4100: {0x1F2A, 0x1F22},   // 'Ἢ' => 'ἢ'
	4104: {0x1F2B, 0x1F23},   // 'Ἣ' => 'ἣ'
	4109: {0x1F2C, 0x1F24},   // 'Ἤ' => 'ἤ'
	4114: {0x1F2D, 0x1F25},   // 'Ἥ' => 'ἥ'
	4118: {0x1F2E, 0x1F26},   // 'Ἦ' => 'ἦ'
	4123: {0x1F2F, 0x1F27},   // 'Ἧ' => 'ἧ'
	4136: {0x037F, 0x03F3},   // 'Ϳ' => 'ϳ'
	4164: {0x1F38, 0x1F30},   // 'Ἰ' => 'ἰ'
	4168: {0x0386, 0x03AC},   // 'Ά' => 'ά'
	4169: {0x1F39, 0x1F31},   // 'Ἱ' => 'ἱ'
	4174: {0x1F3A, 0x1F32},   // 'Ἲ' => 'ἲ'
	4177: {0x0388, 0x03AD},   // 'Έ' => 'έ'
	4178: {0x1F3B, 0x1F33},   // 'Ἳ' => 'ἳ'
	4182: {0x0389, 0x03AE},   // 'Ή' => 'ή'
	4183: {0x1F3C, 0x1F34},   // 'Ἴ' => 'ἴ'
	4186: {0x038A, 0x03AF},   // 'Ί' => 'ί'
	4187: {0x1F3D, 0x1F35},   // 'Ἵ' => 'ἵ'
	4192: {0x1F3E, 0x1F36},   // 'Ἶ' => 'ἶ'
	4196: {0x038C, 0x03CC},   // 'Ό' => 'ό'
	4197: {0x1F3F, 0x1F37},   // 'Ἷ' => 'ἷ'
	4205: {0x038E, 0x03CD},   // 'Ύ' => 'ύ'
	4209: {0x038F, 0x03CE},   // 'Ώ' => 'ώ'
	4219: {0x0391, 0x03B1},   // 'Α' => 'α'
	4223: {0x0392, 0x03B2},   // 'Β' => 'β'
	4228: {0x0393, 0x03B3},   // 'Γ' => 'γ'
	4233: {0x0394, 0x03B4},   // 'Δ' => 'δ'
	4237: {0x0395, 0x03B5},   // 'Ε' => 'ε'
	4238: {0x1F48, 0x1F40},   // 'Ὀ' => 'ὀ'
	4242: {0x0396, 0x03B6},   // 'Ζ' => 'ζ'
	4243: {0x1F49, 0x1F41},   // 'Ὁ' => 'ὁ'
	4246: {0x0397, 0x03B7},   // 'Η' => 'η'
	4248: {0x1F4A, 0x1F42},   // 'Ὂ' => 'ὂ'
	4251: {0x0398, 0x03B8},   // 'Θ' => 'θ'
	4252: {0x1F4B, 0x1F43},   // 'Ὃ' => 'ὃ'
	4256: {0x0399, 0x03B9},   // 'Ι' => 'ι'
	4257: {0x1F4C, 0x1F44},   // 'Ὄ' => 'ὄ'
	4260: {0x039A, 0x03BA},   // 'Κ' => 'κ'
	4261: {0x1F4D, 0x1F45},   // 'Ὅ' => 'ὅ'
	4265: {0x039B, 0x03BB},   // 'Λ' => 'λ'
	4270: {0x039C, 0x03BC},   // 'Μ' => 'μ'
	4274: {0x039D, 0x03BD},   // 'Ν' => 'ν'
	4279: {0x039E, 0x03BE},   // 'Ξ' => 'ξ'
	4283: {0x039F, 0x03BF},   // 'Ο' => 'ο'
	4288: {0x03A0, 0x03C0},   // 'Π' => 'π'
	4293: {0x03A1, 0x03C1},   // 'Ρ' => 'ρ'
	4302: {0x03A3, 0x03C3},   // 'Σ' => 'σ'
	4306: {0x03A4, 0x03C4},   // 'Τ' => 'τ'
	4309: {0x118A0, 0x118C0}, // '𑢠' => '𑣀'
	4311: {0x03A5, 0x03C5},   // 'Υ' => 'υ'
	4313: {0x118A1, 0x118C1}, // '𑢡' => '𑣁'
	4316: {0x03A6, 0x03C6},   // 'Φ' => 'φ'
	4317: {0x1F59, 0x1F51},   // 'Ὑ' => 'ὑ'
	4318: {0x118A2, 0x118C2}, // '𑢢' => '𑣂'
	4320: {0x03A7, 0x03C7},   // 'Χ' => 'χ'
	4322: {0x118A3, 0x118C3}, // '𑢣' => '𑣃'
	4325: {0x03A8, 0x03C8},   // 'Ψ' => 'ψ'
	4326: {0x1F5B, 0x1F53},   // 'Ὓ' => 'ὓ'
	4327: {0x118A4, 0x118C4}, // '𑢤' => '𑣄'
	4330: {0x03A9, 0x03C9},   // 'Ω' => 'ω'
	4332: {0x118A5, 0x118C5}, // '𑢥' => '𑣅'
	4334: {0x03AA, 0x03CA},   // 'Ϊ' => 'ϊ'
	4335: {0x1F5D, 0x1F55},   // 'Ὕ' => 'ὕ'
	4336: {0x118A6, 0x118C6}, // '𑢦' => '𑣆'
	4339: {0x03AB, 0x03CB},   // 'Ϋ' => 'ϋ'
	4341: {0x118A7, 0x118C7}, // '𑢧' => '𑣇'
	4345: {0x1F5F, 0x1F57},   // 'Ὗ' => 'ὗ'
	4346: {0x118A8, 0x118C8}, // '𑢨' => '𑣈'
	4350: {0x118A9, 0x118C9}, // '𑢩' => '𑣉'
	4355: {0x118AA, 0x118CA}, // '𑢪' => '𑣊'
	4359: {0x118AB, 0x118CB}, // '𑢫' => '𑣋'
	4364: {0x118AC, 0x118CC}, // '𑢬' => '𑣌'
	4369: {0x118AD, 0x118CD}, // '𑢭' => '𑣍'
	4373: {0x118AE, 0x118CE}, // '𑢮' => '𑣎'
	4378: {0x118AF, 0x118CF}, // '𑢯' => '𑣏'
	4383: {0x118B0, 0x118D0}, // '𑢰' => '𑣐'
	4386: {0x1F68, 0x1F60},   // 'Ὠ' => 'ὠ'
	4387: {0x118B1, 0x118D1}, // '𑢱' => '𑣑'
	4391: {0x1F69, 0x1F61},   // 'Ὡ' => 'ὡ'
	4392: {0x118B2, 0x118D2}, // '𑢲' => '𑣒'
	4395: {0x1F6A, 0x1F62},   // 'Ὢ' => 'ὢ'
	4396: {0x118B3, 0x118D3}, // '𑢳' => '𑣓'
	4400: {0x1F6B, 0x1F63},   // 'Ὣ' => 'ὣ'
	4401: {0x118B4, 0x118D4}, // '𑢴' => '𑣔'
	4405: {0x1F6C, 0x1F64},   // 'Ὤ' => 'ὤ'
	4406: {0x118B5, 0x118D5}, // '𑢵' => '𑣕'
	4409: {0x1F6D, 0x1F65},   // 'Ὥ' => 'ὥ'
	4410: {0x118B6, 0x118D6}, // '𑢶' => '𑣖'
	4414: {0x1F6E, 0x1F66},   // 'Ὦ' => 'ὦ'
	4415: {0x118B7, 0x118D7}, // '𑢷' => '𑣗'
	4419: {0x1F6F, 0x1F67},   // 'Ὧ' => 'ὧ'
	4420: {0x118B8, 0x118D8}, // '𑢸' => '𑣘'
	4424: {0x118B9, 0x118D9}, // '𑢹' => '𑣙'
	4429: {0x118BA, 0x118DA}, // '𑢺' => '𑣚'
	4433: {0x118BB, 0x118DB}, // '𑢻' => '𑣛'
	4438: {0x118BC, 0x118DC}, // '𑢼' => '𑣜'
	4443: {0x118BD, 0x118DD}, // '𑢽' => '𑣝'
	4445: {0x03C2, 0x03C3},   // 'ς' => 'σ'
	4447: {0x118BE, 0x118DE}, // '𑢾' => '𑣞'
	4452: {0x118BF, 0x118DF}, // '𑢿' => '𑣟'
	4485: {0x10400, 0x10428}, // '𐐀' => '𐐨'
	4489: {0x10401, 0x10429}, // '𐐁' => '𐐩'
	4494: {0x10402, 0x1042A}, // '𐐂' => '𐐪'
	4498: {0x10403, 0x1042B}, // '𐐃' => '𐐫'
	4503: {0x10404, 0x1042C}, // '𐐄' => '𐐬'
	4505: {0x03CF, 0x03D7},   // 'Ϗ' => 'ϗ'
	4508: {0x10405, 0x1042D}, // '𐐅' => '𐐭'
	4510: {0x03D0, 0x03B2},   // 'ϐ' => 'β'
	4512: {0x10406, 0x1042E}, // '𐐆' => '𐐮'
	4514: {0x03D1, 0x03B8},   // 'ϑ' => 'θ'
	4517: {0x10407, 0x1042F}, // '𐐇' => '𐐯'
	4521: {0x10408, 0x10430}, // '𐐈' => '𐐰'
	4526: {0x10409, 0x10431}, // '𐐉' => '𐐱'
	4531: {0x1040A, 0x10432}, // '𐐊' => '𐐲'
	4533: {0x03D5, 0x03C6},   // 'ϕ' => 'φ'
	4534: {0x1F88, 0x1F80},   // 'ᾈ' => 'ᾀ'
	4535: {0x1040B, 0x10433}, // '𐐋' => '𐐳'
	4538: {0x03D6, 0x03C0},   // 'ϖ' => 'π'
	4539: {0x1F89, 0x1F81},   // 'ᾉ' => 'ᾁ'
	4540: {0x1040C, 0x10434}, // '𐐌' => '𐐴'
	4543: {0x1F8A, 0x1F82},   // 'ᾊ' => 'ᾂ'
	4545: {0x1040D, 0x10435}, // '𐐍' => '𐐵'
	4547: {0x03D8, 0x03D9},   // 'Ϙ' => 'ϙ'
	4548: {0x1F8B, 0x1F83},   // 'ᾋ' => 'ᾃ'
	4549: {0x1040E, 0x10436}, // '𐐎' => '𐐶'
	4553: {0x1F8C, 0x1F84},   // 'ᾌ' => 'ᾄ'
	4554: {0x1040F, 0x10437}, // '𐐏' => '𐐷'
	4556: {0x03DA, 0x03DB},   // 'Ϛ' => 'ϛ'
	4557: {0x1F8D, 0x1F85},   // 'ᾍ' => 'ᾅ'
	4558: {0x10410, 0x10438}, // '𐐐' => '𐐸'
	4562: {0x1F8E, 0x1F86},   // 'ᾎ' => 'ᾆ'
	4563: {0x10411, 0x10439}, // '𐐑' => '𐐹'
	4565: {0x03DC, 0x03DD},   // 'Ϝ' => 'ϝ'
	4566: {0x1F8F, 0x1F87},   // 'ᾏ' => 'ᾇ'
	4568: {0x10412, 0x1043A}, // '𐐒' => '𐐺'
	4572: {0x10413, 0x1043B}, // '𐐓' => '𐐻'
	4575: {0x03DE, 0x03DF},   // 'Ϟ' => 'ϟ'
	4577: {0x10414, 0x1043C}, // '𐐔' => '𐐼'
	4582: {0x10415, 0x1043D}, // '𐐕' => '𐐽'
	4584: {0x03E0, 0x03E1},   // 'Ϡ' => 'ϡ'
	4586: {0x10416, 0x1043E}, // '𐐖' => '𐐾'
	4591: {0x10417, 0x1043F}, // '𐐗' => '𐐿'
	4593: {0x03E2, 0x03E3},   // 'Ϣ' => 'ϣ'
	4595: {0x10418, 0x10440}, // '𐐘' => '𐑀'
	4600: {0x10419, 0x10441}, // '𐐙' => '𐑁'
	4602: {0x03E4, 0x03E5},   // 'Ϥ' => 'ϥ'
	4605: {0x1041A, 0x10442}, // '𐐚' => '𐑂'
	4608: {0x1F98, 0x1F90},   // 'ᾘ' => 'ᾐ'
	4609: {0x1041B, 0x10443}, // '𐐛' => '𐑃'
	4611: {0x03E6, 0x03E7},   // 'Ϧ' => 'ϧ'
	4613: {0x1F99, 0x1F91},   // 'ᾙ' => 'ᾑ'
	4614: {0x1041C, 0x10444}, // '𐐜' => '𐑄'
	4617: {0x1F9A, 0x1F92},   // 'ᾚ' => 'ᾒ'
	4619: {0x1041D, 0x10445}, // '𐐝' => '𐑅'
	4621: {0x03E8, 0x03E9},   // 'Ϩ' => 'ϩ'
	4622: {0x1F9B, 0x1F93},   // 'ᾛ' => 'ᾓ'
	4623: {0x1041E, 0x10446}, // '𐐞' => '𐑆'
	4626: {0x1F9C, 0x1F94},   // 'ᾜ' => 'ᾔ'
	4628: {0x1041F, 0x10447}, // '𐐟' => '𐑇'
	4630: {0x03EA, 0x03EB},   // 'Ϫ' => 'ϫ'
	4631: {0x1F9D, 0x1F95},   // 'ᾝ' => 'ᾕ'
	4632: {0x10420, 0x10448}, // '𐐠' => '𐑈'
	4636: {0x1F9E, 0x1F96},   // 'ᾞ' => 'ᾖ'
	4637: {0x10421, 0x10449}, // '𐐡' => '𐑉'
	4639: {0x03EC, 0x03ED},   // 'Ϭ' => 'ϭ'
	4640: {0x1F9F, 0x1F97},   // 'ᾟ' => 'ᾗ'
	4642: {0x10422, 0x1044A}, // '𐐢' => '𐑊'
	4646: {0x10423, 0x1044B}, // '𐐣' => '𐑋'
	4648: {0x03EE, 0x03EF},   // 'Ϯ' => 'ϯ'
	4651: {0x10424, 0x1044C}, // '𐐤' => '𐑌'
	4655: {0x10425, 0x1044D}, // '𐐥' => '𐑍'
	4658: {0x03F0, 0x03BA},   // 'ϰ' => 'κ'
	4660: {0x10426, 0x1044E}, // '𐐦' => '𐑎'
	4662: {0x03F1, 0x03C1},   // 'ϱ' => 'ρ'
	4665: {0x10427, 0x1044F}, // '𐐧' => '𐑏'
	4676: {0x03F4, 0x03B8},   // 'ϴ' => 'θ'
	4681: {0x03F5, 0x03B5},   // 'ϵ' => 'ε'
	4682: {0x1FA8, 0x1FA0},   // 'ᾨ' => 'ᾠ'
	4687: {0x1FA9, 0x1FA1},   // 'ᾩ' => 'ᾡ'
	4690: {0x03F7, 0x03F8},   // 'Ϸ' => 'ϸ'
	4691: {0x1FAA, 0x1FA2},   // 'ᾪ' => 'ᾢ'
	4696: {0x1FAB, 0x1FA3},   // 'ᾫ' => 'ᾣ'
	4699: {0x03F9, 0x03F2},   // 'Ϲ' => 'ϲ'
	4700: {0x1FAC, 0x1FA4},   // 'ᾬ' => 'ᾤ'
	4704: {0x03FA, 0x03FB},   // 'Ϻ' => 'ϻ'
	4705: {0x1FAD, 0x1FA5},   // 'ᾭ' => 'ᾥ'
	4710: {0x1FAE, 0x1FA6},   // 'ᾮ' => 'ᾦ'
	4714: {0x1FAF, 0x1FA7},   // 'ᾯ' => 'ᾧ'
	4718: {0x03FD, 0x037B},   // 'Ͻ' => 'ͻ'
	4722: {0x03FE, 0x037C},   // 'Ͼ' => 'ͼ'
	4727: {0x03FF, 0x037D},   // 'Ͽ' => 'ͽ'
	4732: {0x0400, 0x0450},   // 'Ѐ' => 'ѐ'
	4736: {0x0401, 0x0451},   // 'Ё' => 'ё'
	4741: {0x0402, 0x0452},   // 'Ђ' => 'ђ'
	4746: {0x0403, 0x0453},   // 'Ѓ' => 'ѓ'
	4750: {0x0404, 0x0454},   // 'Є' => 'є'
	4755: {0x0405, 0x0455},   // 'Ѕ' => 'ѕ'
	4756: {0x1FB8, 0x1FB0},   // 'Ᾰ' => 'ᾰ'
	4759: {0x0406, 0x0456},   // 'І' => 'і'
	4761: {0x1FB9, 0x1FB1},   // 'Ᾱ' => 'ᾱ'
	4764: {0x0407, 0x0457},   // 'Ї' => 'ї'
	4765: {0x1FBA, 0x1F70},   // 'Ὰ' => 'ὰ'
	4769: {0x0408, 0x0458},   // 'Ј' => 'ј'
	4770: {0x1FBB, 0x1F71},   // 'Ά' => 'ά'
	4773: {0x0409, 0x0459},   // 'Љ' => 'љ'
	4774: {0x1FBC, 0x1FB3},   // 'ᾼ' => 'ᾳ'
	4778: {0x040A, 0x045A},   // 'Њ' => 'њ'
	4782: {0x040B, 0x045B},   // 'Ћ' => 'ћ'
	4784: {0x1FBE, 0x03B9},   // 'ι' => 'ι'
	4787: {0x040C, 0x045C},   // 'Ќ' => 'ќ'
	4792: {0x040D, 0x045D},   // 'Ѝ' => 'ѝ'
	4796: {0x040E, 0x045E},   // 'Ў' => 'ў'
	4801: {0x040F, 0x045F},   // 'Џ' => 'џ'
	4806: {0x0410, 0x0430},   // 'А' => 'а'
	4810: {0x0411, 0x0431},   // 'Б' => 'б'
	4815: {0x0412, 0x0432},   // 'В' => 'в'
	4819: {0x0413, 0x0433},   // 'Г' => 'г'
	4824: {0x0414, 0x0434},   // 'Д' => 'д'
	4829: {0x0415, 0x0435},   // 'Е' => 'е'
	4830: {0x1FC8, 0x1F72},   // 'Ὲ' => 'ὲ'
	4833: {0x0416, 0x0436},   // 'Ж' => 'ж'
	4834: {0x1FC9, 0x1F73},   // 'Έ' => 'έ'
	4838: {0x0417, 0x0437},   // 'З' => 'з'
	4839: {0x1FCA, 0x1F74},   // 'Ὴ' => 'ὴ'
	4843: {0x0418, 0x0438},   // 'И' => 'и'
	4844: {0x1FCB, 0x1F75},   // 'Ή' => 'ή'
	4847: {0x0419, 0x0439},   // 'Й' => 'й'
	4848: {0x1FCC, 0x1FC3},   // 'ῌ' => 'ῃ'
	4852: {0x041A, 0x043A},   // 'К' => 'к'
	4856: {0x041B, 0x043B},   // 'Л' => 'л'
	4861: {0x041C, 0x043C},   // 'М' => 'м'
	4866: {0x041D, 0x043D},   // 'Н' => 'н'
	4870: {0x041E, 0x043E},   // 'О' => 'о'
	4875: {0x041F, 0x043F},   // 'П' => 'п'
	4880: {0x0420, 0x0440},   // 'Р' => 'р'
	4884: {0x0421, 0x0441},   // 'С' => 'с'
	4889: {0x0422, 0x0442},   // 'Т' => 'т'
	4893: {0x0423, 0x0443},   // 'У' => 'у'
	4898: {0x0424, 0x0444},   // 'Ф' => 'ф'
	4903: {0x0425, 0x0445},   // 'Х' => 'х'
	4904: {0x1FD8, 0x1FD0},   // 'Ῐ' => 'ῐ'
	4907: {0x0426, 0x0446},   // 'Ц' => 'ц'
	4908: {0x1FD9, 0x1FD1},   // 'Ῑ' => 'ῑ'
	4912: {0x0427, 0x0447},   // 'Ч' => 'ч'
	4913: {0x1FDA, 0x1F76},   // 'Ὶ' => 'ὶ'
	4916: {0x0428, 0x0448},   // 'Ш' => 'ш'
	4918: {0x1FDB, 0x1F77},   // 'Ί' => 'ί'
	4921: {0x0429, 0x0449},   // 'Щ' => 'щ'
	4926: {0x042A, 0x044A},   // 'Ъ' => 'ъ'
	4930: {0x042B, 0x044B},   // 'Ы' => 'ы'
	4935: {0x042C, 0x044C},   // 'Ь' => 'ь'
	4940: {0x042D, 0x044D},   // 'Э' => 'э'
	4944: {0x042E, 0x044E},   // 'Ю' => 'ю'
	4949: {0x042F, 0x044F},   // 'Я' => 'я'
	4978: {0x1FE8, 0x1FE0},   // 'Ῠ' => 'ῠ'
	4982: {0x1FE9, 0x1FE1},   // 'Ῡ' => 'ῡ'
	4987: {0x1FEA, 0x1F7A},   // 'Ὺ' => 'ὺ'
	4992: {0x1FEB, 0x1F7B},   // 'Ύ' => 'ύ'
	4996: {0x1FEC, 0x1FE5},   // 'Ῥ' => 'ῥ'
	5052: {0x1FF8, 0x1F78},   // 'Ὸ' => 'ὸ'
	5056: {0x1FF9, 0x1F79},   // 'Ό' => 'ό'
	5061: {0x1FFA, 0x1F7C},   // 'Ὼ' => 'ὼ'
	5063: {0x1E900, 0x1E922}, // '𞤀' => '𞤢'
	5066: {0x1FFB, 0x1F7D},   // 'Ώ' => 'ώ'
	5068: {0x1E901, 0x1E923}, // '𞤁' => '𞤣'
	5070: {0x1FFC, 0x1FF3},   // 'ῼ' => 'ῳ'
	5073: {0x1E902, 0x1E924}, // '𞤂' => '𞤤'
	5077: {0x1E903, 0x1E925}, // '𞤃' => '𞤥'
	5082: {0x1E904, 0x1E926}, // '𞤄' => '𞤦'
	5087: {0x1E905, 0x1E927}, // '𞤅' => '𞤧'
	5091: {0x1E906, 0x1E928}, // '𞤆' => '𞤨'
	5096: {0x1E907, 0x1E929}, // '𞤇' => '𞤩'
	5100: {0x1E908, 0x1E92A}, // '𞤈' => '𞤪'
	5105: {0x1E909, 0x1E92B}, // '𞤉' => '𞤫'
	5110: {0x1E90A, 0x1E92C}, // '𞤊' => '𞤬'
	5114: {0x1E90B, 0x1E92D}, // '𞤋' => '𞤭'
	5119: {0x1E90C, 0x1E92E}, // '𞤌' => '𞤮'
	5124: {0x1E90D, 0x1E92F}, // '𞤍' => '𞤯'
	5128: {0x1E90E, 0x1E930}, // '𞤎' => '𞤰'
	5133: {0x1E90F, 0x1E931}, // '𞤏' => '𞤱'
	5137: {0x1E910, 0x1E932}, // '𞤐' => '𞤲'
	5142: {0x1E911, 0x1E933}, // '𞤑' => '𞤳'
	5147: {0x1E912, 0x1E934}, // '𞤒' => '𞤴'
	5151: {0x1E913, 0x1E935}, // '𞤓' => '𞤵'
	5156: {0x1E914, 0x1E936}, // '𞤔' => '𞤶'
	5160: {0x1E915, 0x1E937}, // '𞤕' => '𞤷'
	5165: {0x1E916, 0x1E938}, // '𞤖' => '𞤸'
	5170: {0x1E917, 0x1E939}, // '𞤗' => '𞤹'
	5174: {0x1E918, 0x1E93A}, // '𞤘' => '𞤺'
	5175: {0x0460, 0x0461},   // 'Ѡ' => 'ѡ'
	5179: {0x1E919, 0x1E93B}, // '𞤙' => '𞤻'
	5184: {0x1E91A, 0x1E93C}, // '𞤚' => '𞤼'
	5185: {0x0462, 0x0463},   // 'Ѣ' => 'ѣ'
	5188: {0x1E91B, 0x1E93D}, // '𞤛' => '𞤽'
	5193: {0x1E91C, 0x1E93E}, // '𞤜' => '𞤾'
	5194: {0x0464, 0x0465},   // 'Ѥ' => 'ѥ'
	5197: {0x1E91D, 0x1E93F}, // '𞤝' => '𞤿'
	5202: {0x1E91E, 0x1E940}, // '𞤞' => '𞥀'
	5203: {0x0466, 0x0467},   // 'Ѧ' => 'ѧ'
	5207: {0x1E91F, 0x1E941}, // '𞤟' => '𞥁'
	5211: {0x1E920, 0x1E942}, // '𞤠' => '𞥂'
	5212: {0x0468, 0x0469},   // 'Ѩ' => 'ѩ'
	5216: {0x1E921, 0x1E943}, // '𞤡' => '𞥃'
	5221: {0x046A, 0x046B},   // 'Ѫ' => 'ѫ'
	5231: {0x046C, 0x046D},   // 'Ѭ' => 'ѭ'
	5240: {0x046E, 0x046F},   // 'Ѯ' => 'ѯ'
	5249: {0x0470, 0x0471},   // 'Ѱ' => 'ѱ'
	5258: {0x0472, 0x0473},   // 'Ѳ' => 'ѳ'
	5268: {0x0474, 0x0475},   // 'Ѵ' => 'ѵ'
	5277: {0x0476, 0x0477},   // 'Ѷ' => 'ѷ'
	5286: {0x0478, 0x0479},   // 'Ѹ' => 'ѹ'
	5295: {0x047A, 0x047B},   // 'Ѻ' => 'ѻ'
	5298: {0x104B0, 0x104D8}, // '𐒰' => '𐓘'
	5302: {0x104B1, 0x104D9}, // '𐒱' => '𐓙'
	5305: {0x047C, 0x047D},   // 'Ѽ' => 'ѽ'
	5307: {0x104B2, 0x104DA}, // '𐒲' => '𐓚'
	5312: {0x104B3, 0x104DB}, // '𐒳' => '𐓛'
	5314: {0x047E, 0x047F},   // 'Ѿ' => 'ѿ'
	5316: {0x104B4, 0x104DC}, // '𐒴' => '𐓜'
	5321: {0x104B5, 0x104DD}, // '𐒵' => '𐓝'
	5323: {0x0480, 0x0481},   // 'Ҁ' => 'ҁ'
	5326: {0x104B6, 0x104DE}, // '𐒶' => '𐓞'
	5330: {0x104B7, 0x104DF}, // '𐒷' => '𐓟'
	5335: {0x104B8, 0x104E0}, // '𐒸' => '𐓠'
	5339: {0x104B9, 0x104E1}, // '𐒹' => '𐓡'
	5344: {0x104BA, 0x104E2}, // '𐒺' => '𐓢'
	5349: {0x104BB, 0x104E3}, // '𐒻' => '𐓣'
	5353: {0x104BC, 0x104E4}, // '𐒼' => '𐓤'
	5358: {0x104BD, 0x104E5}, // '𐒽' => '𐓥'
	5363: {0x104BE, 0x104E6}, // '𐒾' => '𐓦'
	5367: {0x104BF, 0x104E7}, // '𐒿' => '𐓧'
	5369: {0x048A, 0x048B},   // 'Ҋ' => 'ҋ'
	5372: {0x104C0, 0x104E8}, // '𐓀' => '𐓨'
	5376: {0x104C1, 0x104E9}, // '𐓁' => '𐓩'
	5379: {0x048C, 0x048D},   // 'Ҍ' => 'ҍ'
	5381: {0x104C2, 0x104EA}, // '𐓂' => '𐓪'
	5386: {0x104C3, 0x104EB}, // '𐓃' => '𐓫'
	5388: {0x048E, 0x048F},   // 'Ҏ' => 'ҏ'
	5390: {0x104C4, 0x104EC}, // '𐓄' => '𐓬'
	5395: {0x104C5, 0x104ED}, // '𐓅' => '𐓭'
	5397: {0x0490, 0x0491},   // 'Ґ' => 'ґ'
	5400: {0x104C6, 0x104EE}, // '𐓆' => '𐓮'
	5404: {0x104C7, 0x104EF}, // '𐓇' => '𐓯'
	5406: {0x0492, 0x0493},   // 'Ғ' => 'ғ'
	5409: {0x104C8, 0x104F0}, // '𐓈' => '𐓰'
	5413: {0x104C9, 0x104F1}, // '𐓉' => '𐓱'
	5416: {0x0494, 0x0495},   // 'Ҕ' => 'ҕ'
	5418: {0x104CA, 0x104F2}, // '𐓊' => '𐓲'
	5423: {0x104CB, 0x104F3}, // '𐓋' => '𐓳'
	5425: {0x0496, 0x0497},   // 'Җ' => 'җ'
	5427: {0x104CC, 0x104F4}, // '𐓌' => '𐓴'
	5432: {0x104CD, 0x104F5}, // '𐓍' => '𐓵'
	5434: {0x0498, 0x0499},   // 'Ҙ' => 'ҙ'
	5436: {0x104CE, 0x104F6}, // '𐓎' => '𐓶'
	5441: {0x104CF, 0x104F7}, // '𐓏' => '𐓷'
	5443: {0x049A, 0x049B},   // 'Қ' => 'қ'
	5446: {0x104D0, 0x104F8}, // '𐓐' => '𐓸'
	5450: {0x104D1, 0x104F9}, // '𐓑' => '𐓹'
	5453: {0x049C, 0x049D},   // 'Ҝ' => 'ҝ'
	5455: {0x104D2, 0x104FA}, // '𐓒' => '𐓺'
	5460: {0x104D3, 0x104FB}, // '𐓓' => '𐓻'
	5462: {0x049E, 0x049F},   // 'Ҟ' => 'ҟ'
	5471: {0x04A0, 0x04A1},   // 'Ҡ' => 'ҡ'
	5480: {0x04A2, 0x04A3},   // 'Ң' => 'ң'
	5490: {0x04A4, 0x04A5},   // 'Ҥ' => 'ҥ'
	5499: {0x04A6, 0x04A7},   // 'Ҧ' => 'ҧ'
	5508: {0x04A8, 0x04A9},   // 'Ҩ' => 'ҩ'
	5517: {0x04AA, 0x04AB},   // 'Ҫ' => 'ҫ'
	5526: {0x04AC, 0x04AD},   // 'Ҭ' => 'ҭ'
	5536: {0x04AE, 0x04AF},   // 'Ү' => 'ү'
	5545: {0x04B0, 0x04B1},   // 'Ұ' => 'ұ'
	5554: {0x04B2, 0x04B3},   // 'Ҳ' => 'ҳ'
	5563: {0x04B4, 0x04B5},   // 'Ҵ' => 'ҵ'
	5573: {0x04B6, 0x04B7},   // 'Ҷ' => 'ҷ'
	5582: {0x04B8, 0x04B9},   // 'Ҹ' => 'ҹ'
	5591: {0x04BA, 0x04BB},   // 'Һ' => 'һ'
	5600: {0x04BC, 0x04BD},   // 'Ҽ' => 'ҽ'
	5610: {0x04BE, 0x04BF},   // 'Ҿ' => 'ҿ'
	5619: {0x04C0, 0x04CF},   // 'Ӏ' => 'ӏ'
	5624: {0x04C1, 0x04C2},   // 'Ӂ' => 'ӂ'
	5633: {0x04C3, 0x04C4},   // 'Ӄ' => 'ӄ'
	5642: {0x04C5, 0x04C6},   // 'Ӆ' => 'ӆ'
	5651: {0x04C7, 0x04C8},   // 'Ӈ' => 'ӈ'
	5661: {0x04C9, 0x04CA},   // 'Ӊ' => 'ӊ'
	5670: {0x04CB, 0x04CC},   // 'Ӌ' => 'ӌ'
	5679: {0x04CD, 0x04CE},   // 'Ӎ' => 'ӎ'
	5693: {0x04D0, 0x04D1},   // 'Ӑ' => 'ӑ'
	5702: {0x04D2, 0x04D3},   // 'Ӓ' => 'ӓ'
	5711: {0x04D4, 0x04D5},   // 'Ӕ' => 'ӕ'
	5721: {0x04D6, 0x04D7},   // 'Ӗ' => 'ӗ'
	5730: {0x04D8, 0x04D9},   // 'Ә' => 'ә'
	5739: {0x04DA, 0x04DB},   // 'Ӛ' => 'ӛ'
	5748: {0x04DC, 0x04DD},   // 'Ӝ' => 'ӝ'
	5758: {0x04DE, 0x04DF},   // 'Ӟ' => 'ӟ'
	5767: {0x04E0, 0x04E1},   // 'Ӡ' => 'ӡ'
	5776: {0x04E2, 0x04E3},   // 'Ӣ' => 'ӣ'
	5785: {0x04E4, 0x04E5},   // 'Ӥ' => 'ӥ'
	5795: {0x04E6, 0x04E7},   // 'Ӧ' => 'ӧ'
	5804: {0x04E8, 0x04E9},   // 'Ө' => 'ө'
	5813: {0x04EA, 0x04EB},   // 'Ӫ' => 'ӫ'
	5822: {0x04EC, 0x04ED},   // 'Ӭ' => 'ӭ'
	5831: {0x04EE, 0x04EF},   // 'Ӯ' => 'ӯ'
	5841: {0x04F0, 0x04F1},   // 'Ӱ' => 'ӱ'
	5850: {0x04F2, 0x04F3},   // 'Ӳ' => 'ӳ'
	5859: {0x04F4, 0x04F5},   // 'Ӵ' => 'ӵ'
	5868: {0x04F6, 0x04F7},   // 'Ӷ' => 'ӷ'
	5878: {0x04F8, 0x04F9},   // 'Ӹ' => 'ӹ'
	5887: {0x04FA, 0x04FB},   // 'Ӻ' => 'ӻ'
	5896: {0x04FC, 0x04FD},   // 'Ӽ' => 'ӽ'
	5905: {0x04FE, 0x04FF},   // 'Ӿ' => 'ӿ'
	5915: {0x0500, 0x0501},   // 'Ԁ' => 'ԁ'
	5924: {0x0502, 0x0503},   // 'Ԃ' => 'ԃ'
	5933: {0x0504, 0x0505},   // 'Ԅ' => 'ԅ'
	5942: {0x0506, 0x0507},   // 'Ԇ' => 'ԇ'
	5952: {0x0508, 0x0509},   // 'Ԉ' => 'ԉ'
	5961: {0x050A, 0x050B},   // 'Ԋ' => 'ԋ'
	5970: {0x050C, 0x050D},   // 'Ԍ' => 'ԍ'
	5979: {0x050E, 0x050F},   // 'Ԏ' => 'ԏ'
	5989: {0x0510, 0x0511},   // 'Ԑ' => 'ԑ'
	5998: {0x0512, 0x0513},   // 'Ԓ' => 'ԓ'
	6007: {0x0514, 0x0515},   // 'Ԕ' => 'ԕ'
	6016: {0x0516, 0x0517},   // 'Ԗ' => 'ԗ'
	6026: {0x0518, 0x0519},   // 'Ԙ' => 'ԙ'
	6035: {0x051A, 0x051B},   // 'Ԛ' => 'ԛ'
	6044: {0x051C, 0x051D},   // 'Ԝ' => 'ԝ'
	6053: {0x051E, 0x051F},   // 'Ԟ' => 'ԟ'
	6063: {0x0520, 0x0521},   // 'Ԡ' => 'ԡ'
	6072: {0x0522, 0x0523},   // 'Ԣ' => 'ԣ'
	6081: {0x0524, 0x0525},   // 'Ԥ' => 'ԥ'
	6090: {0x0526, 0x0527},   // 'Ԧ' => 'ԧ'
	6100: {0x0528, 0x0529},   // 'Ԩ' => 'ԩ'
	6109: {0x052A, 0x052B},   // 'Ԫ' => 'ԫ'
	6118: {0x052C, 0x052D},   // 'Ԭ' => 'ԭ'
	6127: {0x052E, 0x052F},   // 'Ԯ' => 'ԯ'
	6141: {0x0531, 0x0561},   // 'Ա' => 'ա'
	6146: {0x0532, 0x0562},   // 'Բ' => 'բ'
	6150: {0x0533, 0x0563},   // 'Գ' => 'գ'
	6155: {0x0534, 0x0564},   // 'Դ' => 'դ'
	6160: {0x0535, 0x0565},   // 'Ե' => 'ե'
	6164: {0x0536, 0x0566},   // 'Զ' => 'զ'
	6169: {0x0537, 0x0567},   // 'Է' => 'է'
	6173: {0x0538, 0x0568},   // 'Ը' => 'ը'
	6178: {0x0539, 0x0569},   // 'Թ' => 'թ'
	6183: {0x053A, 0x056A},   // 'Ժ' => 'ժ'
	6187: {0x053B, 0x056B},   // 'Ի' => 'ի'
	6192: {0x053C, 0x056C},   // 'Լ' => 'լ'
	6197: {0x053D, 0x056D},   // 'Խ' => 'խ'
	6201: {0x053E, 0x056E},   // 'Ծ' => 'ծ'
	6206: {0x053F, 0x056F},   // 'Կ' => 'կ'
	6208: {0xAB70, 0x13A0},   // 'ꭰ' => 'Ꭰ'
	6210: {0x0540, 0x0570},   // 'Հ' => 'հ'
	6213: {0xAB71, 0x13A1},   // 'ꭱ' => 'Ꭱ'
	6215: {0x0541, 0x0571},   // 'Ձ' => 'ձ'
	6217: {0xAB72, 0x13A2},   // 'ꭲ' => 'Ꭲ'
	6220: {0x0542, 0x0572},   // 'Ղ' => 'ղ'
	6222: {0xAB73, 0x13A3},   // 'ꭳ' => 'Ꭳ'
	6224: {0x0543, 0x0573},   // 'Ճ' => 'ճ'
	6226: {0xAB74, 0x13A4},   // 'ꭴ' => 'Ꭴ'
	6229: {0x0544, 0x0574},   // 'Մ' => 'մ'
	6231: {0xAB75, 0x13A5},   // 'ꭵ' => 'Ꭵ'
	6234: {0x0545, 0x0575},   // 'Յ' => 'յ'
	6236: {0xAB76, 0x13A6},   // 'ꭶ' => 'Ꭶ'
	6238: {0x0546, 0x0576},   // 'Ն' => 'ն'
	6240: {0xAB77, 0x13A7},   // 'ꭷ' => 'Ꭷ'
	6243: {0x0547, 0x0577},   // 'Շ' => 'շ'
	6245: {0xAB78, 0x13A8},   // 'ꭸ' => 'Ꭸ'
	6247: {0x0548, 0x0578},   // 'Ո' => 'ո'
	6250: {0xAB79, 0x13A9},   // 'ꭹ' => 'Ꭹ'
	6252: {0x0549, 0x0579},   // 'Չ' => 'չ'
	6254: {0xAB7A, 0x13AA},   // 'ꭺ' => 'Ꭺ'
	6257: {0x054A, 0x057A},   // 'Պ' => 'պ'
	6259: {0xAB7B, 0x13AB},   // 'ꭻ' => 'Ꭻ'
	6261: {0x054B, 0x057B},   // 'Ջ' => 'ջ'
	6263: {0xAB7C, 0x13AC},   // 'ꭼ' => 'Ꭼ'
	6266: {0x054C, 0x057C},   // 'Ռ' => 'ռ'
	6268: {0xAB7D, 0x13AD},   // 'ꭽ' => 'Ꭽ'
	6271: {0x054D, 0x057D},   // 'Ս' => 'ս'
	6273: {0xAB7E, 0x13AE},   // 'ꭾ' => 'Ꭾ'
	6275: {0x054E, 0x057E},   // 'Վ' => 'վ'
	6277: {0xAB7F, 0x13AF},   // 'ꭿ' => 'Ꭿ'
	6280: {0x054F, 0x057F},   // 'Տ' => 'տ'
	6282: {0xAB80, 0x13B0},   // 'ꮀ' => 'Ꮀ'
	6284: {0x0550, 0x0580},   // 'Ր' => 'ր'
	6287: {0xAB81, 0x13B1},   // 'ꮁ' => 'Ꮁ'
	6289: {0x0551, 0x0581},   // 'Ց' => 'ց'
	6291: {0xAB82, 0x13B2},   // 'ꮂ' => 'Ꮂ'
	6294: {0x0552, 0x0582},   // 'Ւ' => 'ւ'
	6296: {0xAB83, 0x13B3},   // 'ꮃ' => 'Ꮃ'
	6298: {0x0553, 0x0583},   // 'Փ' => 'փ'
	6300: {0xAB84, 0x13B4},   // 'ꮄ' => 'Ꮄ'
	6303: {0x0554, 0x0584},   // 'Ք' => 'ք'
	6305: {0xAB85, 0x13B5},   // 'ꮅ' => 'Ꮅ'
	6307: {0x0555, 0x0585},   // 'Օ' => 'օ'
	6310: {0xAB86, 0x13B6},   // 'ꮆ' => 'Ꮆ'
	6312: {0x0556, 0x0586},   // 'Ֆ' => 'ֆ'
	6314: {0xAB87, 0x13B7},   // 'ꮇ' => 'Ꮇ'
	6319: {0xAB88, 0x13B8},   // 'ꮈ' => 'Ꮈ'
	6324: {0xAB89, 0x13B9},   // 'ꮉ' => 'Ꮉ'
	6328: {0xAB8A, 0x13BA},   // 'ꮊ' => 'Ꮊ'
	6333: {0xAB8B, 0x13BB},   // 'ꮋ' => 'Ꮋ'
	6337: {0xAB8C, 0x13BC},   // 'ꮌ' => 'Ꮌ'
	6342: {0xAB8D, 0x13BD},   // 'ꮍ' => 'Ꮍ'
	6347: {0xAB8E, 0x13BE},   // 'ꮎ' => 'Ꮎ'
	6348: {0x10C80, 0x10CC0}, // '𐲀' => '𐳀'
	6351: {0xAB8F, 0x13BF},   // 'ꮏ' => 'Ꮏ'
	6353: {0x10C81, 0x10CC1}, // '𐲁' => '𐳁'
	6356: {0xAB90, 0x13C0},   // 'ꮐ' => 'Ꮐ'
	6358: {0x10C82, 0x10CC2}, // '𐲂' => '𐳂'
	6361: {0xAB91, 0x13C1},   // 'ꮑ' => 'Ꮑ'
	6362: {0x10C83, 0x10CC3}, // '𐲃' => '𐳃'
	6365: {0xAB92, 0x13C2},   // 'ꮒ' => 'Ꮒ'
	6367: {0x10C84, 0x10CC4}, // '𐲄' => '𐳄'
	6370: {0xAB93, 0x13C3},   // 'ꮓ' => 'Ꮓ'
	6371: {0x10C85, 0x10CC5}, // '𐲅' => '𐳅'
	6374: {0xAB94, 0x13C4},   // 'ꮔ' => 'Ꮔ'
	6376: {0x10C86, 0x10CC6}, // '𐲆' => '𐳆'
	6379: {0xAB95, 0x13C5},   // 'ꮕ' => 'Ꮕ'
	6381: {0x10C87, 0x10CC7}, // '𐲇' => '𐳇'
	6384: {0xAB96, 0x13C6},   // 'ꮖ' => 'Ꮖ'
	6385: {0x10C88, 0x10CC8}, // '𐲈' => '𐳈'
	6388: {0xAB97, 0x13C7},   // 'ꮗ' => 'Ꮗ'
	6390: {0x10C89, 0x10CC9}, // '𐲉' => '𐳉'
	6393: {0xAB98, 0x13C8},   // 'ꮘ' => 'Ꮘ'
	6395: {0x10C8A, 0x10CCA}, // '𐲊' => '𐳊'
	6397: {0xAB99, 0x13C9},   // 'ꮙ' => 'Ꮙ'
	6399: {0x10C8B, 0x10CCB}, // '𐲋' => '𐳋'
	6402: {0xAB9A, 0x13CA},   // 'ꮚ' => 'Ꮚ'
	6404: {0x10C8C, 0x10CCC}, // '𐲌' => '𐳌'
	6407: {0xAB9B, 0x13CB},   // 'ꮛ' => 'Ꮛ'
	6408: {0x10C8D, 0x10CCD}, // '𐲍' => '𐳍'
	6411: {0xAB9C, 0x13CC},   // 'ꮜ' => 'Ꮜ'
	6413: {0x10C8E, 0x10CCE}, // '𐲎' => '𐳎'
	6416: {0xAB9D, 0x13CD},   // 'ꮝ' => 'Ꮝ'
	6418: {0x10C8F, 0x10CCF}, // '𐲏' => '𐳏'
	6421: {0xAB9E, 0x13CE},   // 'ꮞ' => 'Ꮞ'
	6422: {0x10C90, 0x10CD0}, // '𐲐' => '𐳐'
	6425: {0xAB9F, 0x13CF},   // 'ꮟ' => 'Ꮟ'
	6427: {0x10C91, 0x10CD1}, // '𐲑' => '𐳑'
	6430: {0xABA0, 0x13D0},   // 'ꮠ' => 'Ꮠ'
	6431: {0x10C92, 0x10CD2}, // '𐲒' => '𐳒'
	6434: {0xABA1, 0x13D1},   // 'ꮡ' => 'Ꮡ'
	6436: {0x10C93, 0x10CD3}, // '𐲓' => '𐳓'
	6439: {0xABA2, 0x13D2},   // 'ꮢ' => 'Ꮢ'
	6441: {0x10C94, 0x10CD4}, // '𐲔' => '𐳔'
	6444: {0xABA3, 0x13D3},   // 'ꮣ' => 'Ꮣ'
	6445: {0x10C95, 0x10CD5}, // '𐲕' => '𐳕'
	6447: {0x2126, 0x03C9},   // 'Ω' => 'ω'
	6448: {0xABA4, 0x13D4},   // 'ꮤ' => 'Ꮤ'
	6450: {0x10C96, 0x10CD6}, // '𐲖' => '𐳖'
	6453: {0xABA5, 0x13D5},   // 'ꮥ' => 'Ꮥ'
	6455: {0x10C97, 0x10CD7}, // '𐲗' => '𐳗'
	6458: {0xABA6, 0x13D6},   // 'ꮦ' => 'Ꮦ'
	6459: {0x10C98, 0x10CD8}, // '𐲘' => '𐳘'
	6462: {0xABA7, 0x13D7},   // 'ꮧ' => 'Ꮧ'
	6464: {0x10C99, 0x10CD9}, // '𐲙' => '𐳙'
	6466: {0x212A, 0x006B},   // 'K' => 'k'
	6467: {0xABA8, 0x13D8},   // 'ꮨ' => 'Ꮨ'
	6468: {0x10C9A, 0x10CDA}, // '𐲚' => '𐳚'
	6470: {0x212B, 0x00E5},   // 'Å' => 'å'
	6471: {0xABA9, 0x13D9},   // 'ꮩ' => 'Ꮩ'
	6473: {0x10C9B, 0x10CDB}, // '𐲛' => '𐳛'
	6476: {0xABAA, 0x13DA},   // 'ꮪ' => 'Ꮪ'
	6478: {0x10C9C, 0x10CDC}, // '𐲜' => '𐳜'
	6481: {0xABAB, 0x13DB},   // 'ꮫ' => 'Ꮫ'
	6482: {0x10C9D, 0x10CDD}, // '𐲝' => '𐳝'
	6485: {0xABAC, 0x13DC},   // 'ꮬ' => 'Ꮬ'
	6487: {0x10C9E, 0x10CDE}, // '𐲞' => '𐳞'
	6490: {0xABAD, 0x13DD},   // 'ꮭ' => 'Ꮭ'
	6492: {0x10C9F, 0x10CDF}, // '𐲟' => '𐳟'
	6495: {0xABAE, 0x13DE},   // 'ꮮ' => 'Ꮮ'
	6496: {0x10CA0, 0x10CE0}, // '𐲠' => '𐳠'
	6499: {0xABAF, 0x13DF},   // 'ꮯ' => 'Ꮯ'
	6501: {0x10CA1, 0x10CE1}, // '𐲡' => '𐳡'
	6503: {0x2132, 0x214E},   // 'Ⅎ' => 'ⅎ'
	6504: {0xABB0, 0x13E0},   // 'ꮰ' => 'Ꮰ'
	6505: {0x10CA2, 0x10CE2}, // '𐲢' => '𐳢'
	6508: {0xABB1, 0x13E1},   // 'ꮱ' => 'Ꮱ'
	6510: {0x10CA3, 0x10CE3}, // '𐲣' => '𐳣'
	6513: {0xABB2, 0x13E2},   // 'ꮲ' => 'Ꮲ'
	6515: {0x10CA4, 0x10CE4}, // '𐲤' => '𐳤'
	6518: {0xABB3, 0x13E3},   // 'ꮳ' => 'Ꮳ'
	6519: {0x10CA5, 0x10CE5}, // '𐲥' => '𐳥'
	6522: {0xABB4, 0x13E4},   // 'ꮴ' => 'Ꮴ'
	6524: {0x10CA6, 0x10CE6}, // '𐲦' => '𐳦'
	6527: {0xABB5, 0x13E5},   // 'ꮵ' => 'Ꮵ'
	6529: {0x10CA7, 0x10CE7}, // '𐲧' => '𐳧'
	6531: {0xABB6, 0x13E6},   // 'ꮶ' => 'Ꮶ'
	6533: {0x10CA8, 0x10CE8}, // '𐲨' => '𐳨'
	6536: {0xABB7, 0x13E7},   // 'ꮷ' => 'Ꮷ'
	6538: {0x10CA9, 0x10CE9}, // '𐲩' => '𐳩'
	6541: {0xABB8, 0x13E8},   // 'ꮸ' => 'Ꮸ'
	6542: {0x10CAA, 0x10CEA}, // '𐲪' => '𐳪'
	6545: {0xABB9, 0x13E9},   // 'ꮹ' => 'Ꮹ'
	6547: {0x10CAB, 0x10CEB}, // '𐲫' => '𐳫'
	6550: {0xABBA, 0x13EA},   // 'ꮺ' => 'Ꮺ'
	6552: {0x10CAC, 0x10CEC}, // '𐲬' => '𐳬'
	6555: {0xABBB, 0x13EB},   // 'ꮻ' => 'Ꮻ'
	6556: {0x10CAD, 0x10CED}, // '𐲭' => '𐳭'
	6559: {0xABBC, 0x13EC},   // 'ꮼ' => 'Ꮼ'
	6561: {0x10CAE, 0x10CEE}, // '𐲮' => '𐳮'
	6564: {0xABBD, 0x13ED},   // 'ꮽ' => 'Ꮽ'
	6566: {0x10CAF, 0x10CEF}, // '𐲯' => '𐳯'
	6568: {0xABBE, 0x13EE},   // 'ꮾ' => 'Ꮾ'
	6570: {0x10CB0, 0x10CF0}, // '𐲰' => '𐳰'
	6573: {0xABBF, 0x13EF},   // 'ꮿ' => 'Ꮿ'
	6575: {0x10CB1, 0x10CF1}, // '𐲱' => '𐳱'
	6579: {0x10CB2, 0x10CF2}, // '𐲲' => '𐳲'
	6715: {0x2160, 0x2170},   // 'Ⅰ' => 'ⅰ'
	6720: {0x2161, 0x2171},   // 'Ⅱ' => 'ⅱ'
	6725: {0x2162, 0x2172},   // 'Ⅲ' => 'ⅲ'
	6729: {0x2163, 0x2173},   // 'Ⅳ' => 'ⅳ'
	6734: {0x2164, 0x2174},   // 'Ⅴ' => 'ⅴ'
	6738: {0x2165, 0x2175},   // 'Ⅵ' => 'ⅵ'
	6743: {0x2166, 0x2176},   // 'Ⅶ' => 'ⅶ'
	6748: {0x2167, 0x2177},   // 'Ⅷ' => 'ⅷ'
	6752: {0x2168, 0x2178},   // 'Ⅸ' => 'ⅸ'
	6757: {0x2169, 0x2179},   // 'Ⅹ' => 'ⅹ'
	6761: {0x216A, 0x217A},   // 'Ⅺ' => 'ⅺ'
	6766: {0x216B, 0x217B},   // 'Ⅻ' => 'ⅻ'
	6771: {0x216C, 0x217C},   // 'Ⅼ' => 'ⅼ'
	6775: {0x216D, 0x217D},   // 'Ⅽ' => 'ⅽ'
	6780: {0x216E, 0x217E},   // 'Ⅾ' => 'ⅾ'
	6785: {0x216F, 0x217F},   // 'Ⅿ' => 'ⅿ'
	6877: {0x2183, 0x2184},   // 'Ↄ' => 'ↄ'
	6914: {0xFF21, 0xFF41},   // 'Ａ' => 'ａ'
	6918: {0xFF22, 0xFF42},   // 'Ｂ' => 'ｂ'
	6923: {0xFF23, 0xFF43},   // 'Ｃ' => 'ｃ'
	6928: {0xFF24, 0xFF44},   // 'Ｄ' => 'ｄ'
	6932: {0xFF25, 0xFF45},   // 'Ｅ' => 'ｅ'
	6937: {0xFF26, 0xFF46},   // 'Ｆ' => 'ｆ'
	6942: {0xFF27, 0xFF47},   // 'Ｇ' => 'ｇ'
	6946: {0xFF28, 0xFF48},   // 'Ｈ' => 'ｈ'
	6951: {0xFF29, 0xFF49},   // 'Ｉ' => 'ｉ'
	6955: {0xFF2A, 0xFF4A},   // 'Ｊ' => 'ｊ'
	6960: {0xFF2B, 0xFF4B},   // 'Ｋ' => 'ｋ'
	6965: {0xFF2C, 0xFF4C},   // 'Ｌ' => 'ｌ'
	6969: {0xFF2D, 0xFF4D},   // 'Ｍ' => 'ｍ'
	6974: {0xFF2E, 0xFF4E},   // 'Ｎ' => 'ｎ'
	6979: {0xFF2F, 0xFF4F},   // 'Ｏ' => 'ｏ'
	6983: {0xFF30, 0xFF50},   // 'Ｐ' => 'ｐ'
	6988: {0xFF31, 0xFF51},   // 'Ｑ' => 'ｑ'
	6992: {0xFF32, 0xFF52},   // 'Ｒ' => 'ｒ'
	6997: {0xFF33, 0xFF53},   // 'Ｓ' => 'ｓ'
	7002: {0xFF34, 0xFF54},   // 'Ｔ' => 'ｔ'
	7006: {0xFF35, 0xFF55},   // 'Ｕ' => 'ｕ'
	7011: {0xFF36, 0xFF56},   // 'Ｖ' => 'ｖ'
	7016: {0xFF37, 0xFF57},   // 'Ｗ' => 'ｗ'
	7020: {0xFF38, 0xFF58},   // 'Ｘ' => 'ｘ'
	7025: {0xFF39, 0xFF59},   // 'Ｙ' => 'ｙ'
	7029: {0xFF3A, 0xFF5A},   // 'Ｚ' => 'ｚ'
	7239: {0x13F8, 0x13F0},   // 'ᏸ' => 'Ᏸ'
	7244: {0x13F9, 0x13F1},   // 'ᏹ' => 'Ᏹ'
	7248: {0x13FA, 0x13F2},   // 'ᏺ' => 'Ᏺ'
	7253: {0x13FB, 0x13F3},   // 'ᏻ' => 'Ᏻ'
	7258: {0x13FC, 0x13F4},   // 'ᏼ' => 'Ᏼ'
	7262: {0x13FD, 0x13F5},   // 'ᏽ' => 'Ᏽ'
	7302: {0x16E40, 0x16E60}, // '𖹀' => '𖹠'
	7307: {0x16E41, 0x16E61}, // '𖹁' => '𖹡'
	7311: {0x16E42, 0x16E62}, // '𖹂' => '𖹢'
	7316: {0x16E43, 0x16E63}, // '𖹃' => '𖹣'
	7320: {0x16E44, 0x16E64}, // '𖹄' => '𖹤'
	7325: {0x16E45, 0x16E65}, // '𖹅' => '𖹥'
	7330: {0x16E46, 0x16E66}, // '𖹆' => '𖹦'
	7334: {0x16E47, 0x16E67}, // '𖹇' => '𖹧'
	7339: {0x16E48, 0x16E68}, // '𖹈' => '𖹨'
	7344: {0x16E49, 0x16E69}, // '𖹉' => '𖹩'
	7348: {0x16E4A, 0x16E6A}, // '𖹊' => '𖹪'
	7353: {0x16E4B, 0x16E6B}, // '𖹋' => '𖹫'
	7357: {0x16E4C, 0x16E6C}, // '𖹌' => '𖹬'
	7362: {0x16E4D, 0x16E6D}, // '𖹍' => '𖹭'
	7367: {0x16E4E, 0x16E6E}, // '𖹎' => '𖹮'
	7371: {0x16E4F, 0x16E6F}, // '𖹏' => '𖹯'
	7376: {0x16E50, 0x16E70}, // '𖹐' => '𖹰'
	7381: {0x16E51, 0x16E71}, // '𖹑' => '𖹱'
	7385: {0x16E52, 0x16E72}, // '𖹒' => '𖹲'
	7390: {0x16E53, 0x16E73}, // '𖹓' => '𖹳'
	7394: {0x16E54, 0x16E74}, // '𖹔' => '𖹴'
	7399: {0x16E55, 0x16E75}, // '𖹕' => '𖹵'
	7404: {0x16E56, 0x16E76}, // '𖹖' => '𖹶'
	7408: {0x16E57, 0x16E77}, // '𖹗' => '𖹷'
	7413: {0x16E58, 0x16E78}, // '𖹘' => '𖹸'
	7417: {0x16E59, 0x16E79}, // '𖹙' => '𖹹'
	7422: {0x16E5A, 0x16E7A}, // '𖹚' => '𖹺'
	7427: {0x16E5B, 0x16E7B}, // '𖹛' => '𖹻'
	7431: {0x16E5C, 0x16E7C}, // '𖹜' => '𖹼'
	7436: {0x16E5D, 0x16E7D}, // '𖹝' => '𖹽'
	7441: {0x16E5E, 0x16E7E}, // '𖹞' => '𖹾'
	7445: {0x16E5F, 0x16E7F}, // '𖹟' => '𖹿'
}

const _UpperLowerSeed = 0x6AE7FD95
const _UpperLowerShift = 19

// _UpperLower stores upper/lower case pairs of Unicode code points.
// This takes up more space than the stdlib's "unicode" package, but
// is roughly ~4x faster.
var _UpperLower = [8192][2]uint32{
	7648: {0x039C, 0x00B5},   // 'Μ' => 'µ'
	7615: {0x00C0, 0x00E0},   // 'À' => 'à'
	7612: {0x00C1, 0x00E1},   // 'Á' => 'á'
	7609: {0x00C2, 0x00E2},   // 'Â' => 'â'
	7606: {0x00C3, 0x00E3},   // 'Ã' => 'ã'
	7603: {0x00C4, 0x00E4},   // 'Ä' => 'ä'
	7600: {0x00C5, 0x00E5},   // 'Å' => 'å'
	7597: {0x00C6, 0x00E6},   // 'Æ' => 'æ'
	7594: {0x00C7, 0x00E7},   // 'Ç' => 'ç'
	7591: {0x00C8, 0x00E8},   // 'È' => 'è'
	7588: {0x00C9, 0x00E9},   // 'É' => 'é'
	7585: {0x00CA, 0x00EA},   // 'Ê' => 'ê'
	7582: {0x00CB, 0x00EB},   // 'Ë' => 'ë'
	7579: {0x00CC, 0x00EC},   // 'Ì' => 'ì'
	7576: {0x00CD, 0x00ED},   // 'Í' => 'í'
	7573: {0x00CE, 0x00EE},   // 'Î' => 'î'
	7570: {0x00CF, 0x00EF},   // 'Ï' => 'ï'
	7567: {0x00D0, 0x00F0},   // 'Ð' => 'ð'
	7564: {0x00D1, 0x00F1},   // 'Ñ' => 'ñ'
	7561: {0x00D2, 0x00F2},   // 'Ò' => 'ò'
	7558: {0x00D3, 0x00F3},   // 'Ó' => 'ó'
	7555: {0x00D4, 0x00F4},   // 'Ô' => 'ô'
	7552: {0x00D5, 0x00F5},   // 'Õ' => 'õ'
	7549: {0x00D6, 0x00F6},   // 'Ö' => 'ö'
	7543: {0x00D8, 0x00F8},   // 'Ø' => 'ø'
	7540: {0x00D9, 0x00F9},   // 'Ù' => 'ù'
	7537: {0x00DA, 0x00FA},   // 'Ú' => 'ú'
	7534: {0x00DB, 0x00FB},   // 'Û' => 'û'
	7531: {0x00DC, 0x00FC},   // 'Ü' => 'ü'
	7528: {0x00DD, 0x00FD},   // 'Ý' => 'ý'
	7525: {0x00DE, 0x00FE},   // 'Þ' => 'þ'
	7519: {0x00C0, 0x00E0},   // 'À' => 'à'
	7516: {0x00C1, 0x00E1},   // 'Á' => 'á'
	7513: {0x00C2, 0x00E2},   // 'Â' => 'â'
	7510: {0x00C3, 0x00E3},   // 'Ã' => 'ã'
	7507: {0x00C4, 0x00E4},   // 'Ä' => 'ä'
	7504: {0x00C5, 0x00E5},   // 'Å' => 'å'
	7501: {0x00C6, 0x00E6},   // 'Æ' => 'æ'
	7498: {0x00C7, 0x00E7},   // 'Ç' => 'ç'
	7495: {0x00C8, 0x00E8},   // 'È' => 'è'
	7492: {0x00C9, 0x00E9},   // 'É' => 'é'
	7489: {0x00CA, 0x00EA},   // 'Ê' => 'ê'
	7486: {0x00CB, 0x00EB},   // 'Ë' => 'ë'
	7483: {0x00CC, 0x00EC},   // 'Ì' => 'ì'
	7480: {0x00CD, 0x00ED},   // 'Í' => 'í'
	7477: {0x00CE, 0x00EE},   // 'Î' => 'î'
	7474: {0x00CF, 0x00EF},   // 'Ï' => 'ï'
	7471: {0x00D0, 0x00F0},   // 'Ð' => 'ð'
	7468: {0x00D1, 0x00F1},   // 'Ñ' => 'ñ'
	7465: {0x00D2, 0x00F2},   // 'Ò' => 'ò'
	7462: {0x00D3, 0x00F3},   // 'Ó' => 'ó'
	7459: {0x00D4, 0x00F4},   // 'Ô' => 'ô'
	7456: {0x00D5, 0x00F5},   // 'Õ' => 'õ'
	7453: {0x00D6, 0x00F6},   // 'Ö' => 'ö'
	7447: {0x00D8, 0x00F8},   // 'Ø' => 'ø'
	7444: {0x00D9, 0x00F9},   // 'Ù' => 'ù'
	7441: {0x00DA, 0x00FA},   // 'Ú' => 'ú'
	7438: {0x00DB, 0x00FB},   // 'Û' => 'û'
	7435: {0x00DC, 0x00FC},   // 'Ü' => 'ü'
	7432: {0x00DD, 0x00FD},   // 'Ý' => 'ý'
	7429: {0x00DE, 0x00FE},   // 'Þ' => 'þ'
	7426: {0x0178, 0x00FF},   // 'Ÿ' => 'ÿ'
	7423: {0x0100, 0x0101},   // 'Ā' => 'ā'
	7420: {0x0100, 0x0101},   // 'Ā' => 'ā'
	7417: {0x0102, 0x0103},   // 'Ă' => 'ă'
	7414: {0x0102, 0x0103},   // 'Ă' => 'ă'
	7411: {0x0104, 0x0105},   // 'Ą' => 'ą'
	7408: {0x0104, 0x0105},   // 'Ą' => 'ą'
	7405: {0x0106, 0x0107},   // 'Ć' => 'ć'
	7402: {0x0106, 0x0107},   // 'Ć' => 'ć'
	7399: {0x0108, 0x0109},   // 'Ĉ' => 'ĉ'
	7396: {0x0108, 0x0109},   // 'Ĉ' => 'ĉ'
	7393: {0x010A, 0x010B},   // 'Ċ' => 'ċ'
	7390: {0x010A, 0x010B},   // 'Ċ' => 'ċ'
	7387: {0x010C, 0x010D},   // 'Č' => 'č'
	7384: {0x010C, 0x010D},   // 'Č' => 'č'
	7381: {0x010E, 0x010F},   // 'Ď' => 'ď'
	7378: {0x010E, 0x010F},   // 'Ď' => 'ď'
	7375: {0x0110, 0x0111},   // 'Đ' => 'đ'
	7372: {0x0110, 0x0111},   // 'Đ' => 'đ'
	7369: {0x0112, 0x0113},   // 'Ē' => 'ē'
	7366: {0x0112, 0x0113},   // 'Ē' => 'ē'
	7363: {0x0114, 0x0115},   // 'Ĕ' => 'ĕ'
	7360: {0x0114, 0x0115},   // 'Ĕ' => 'ĕ'
	7357: {0x0116, 0x0117},   // 'Ė' => 'ė'
	7354: {0x0116, 0x0117},   // 'Ė' => 'ė'
	7351: {0x0118, 0x0119},   // 'Ę' => 'ę'
	7348: {0x0118, 0x0119},   // 'Ę' => 'ę'
	7345: {0x011A, 0x011B},   // 'Ě' => 'ě'
	7342: {0x011A, 0x011B},   // 'Ě' => 'ě'
	7339: {0x011C, 0x011D},   // 'Ĝ' => 'ĝ'
	7336: {0x011C, 0x011D},   // 'Ĝ' => 'ĝ'
	7333: {0x011E, 0x011F},   // 'Ğ' => 'ğ'
	7330: {0x011E, 0x011F},   // 'Ğ' => 'ğ'
	7327: {0x0120, 0x0121},   // 'Ġ' => 'ġ'
	7324: {0x0120, 0x0121},   // 'Ġ' => 'ġ'
	7321: {0x0122, 0x0123},   // 'Ģ' => 'ģ'
	7318: {0x0122, 0x0123},   // 'Ģ' => 'ģ'
	7315: {0x0124, 0x0125},   // 'Ĥ' => 'ĥ'
	7312: {0x0124, 0x0125},   // 'Ĥ' => 'ĥ'
	7309: {0x0126, 0x0127},   // 'Ħ' => 'ħ'
	7306: {0x0126, 0x0127},   // 'Ħ' => 'ħ'
	7303: {0x0128, 0x0129},   // 'Ĩ' => 'ĩ'
	7300: {0x0128, 0x0129},   // 'Ĩ' => 'ĩ'
	7297: {0x012A, 0x012B},   // 'Ī' => 'ī'
	7294: {0x012A, 0x012B},   // 'Ī' => 'ī'
	7291: {0x012C, 0x012D},   // 'Ĭ' => 'ĭ'
	7288: {0x012C, 0x012D},   // 'Ĭ' => 'ĭ'
	7285: {0x012E, 0x012F},   // 'Į' => 'į'
	7282: {0x012E, 0x012F},   // 'Į' => 'į'
	7279: {0x0130, 0x0069},   // 'İ' => 'i'
	7276: {0x0049, 0x0131},   // 'I' => 'ı'
	7273: {0x0132, 0x0133},   // 'Ĳ' => 'ĳ'
	7270: {0x0132, 0x0133},   // 'Ĳ' => 'ĳ'
	7267: {0x0134, 0x0135},   // 'Ĵ' => 'ĵ'
	7264: {0x0134, 0x0135},   // 'Ĵ' => 'ĵ'
	7261: {0x0136, 0x0137},   // 'Ķ' => 'ķ'
	7258: {0x0136, 0x0137},   // 'Ķ' => 'ķ'
	7252: {0x0139, 0x013A},   // 'Ĺ' => 'ĺ'
	7249: {0x0139, 0x013A},   // 'Ĺ' => 'ĺ'
	7246: {0x013B, 0x013C},   // 'Ļ' => 'ļ'
	7243: {0x013B, 0x013C},   // 'Ļ' => 'ļ'
	7240: {0x013D, 0x013E},   // 'Ľ' => 'ľ'
	7237: {0x013D, 0x013E},   // 'Ľ' => 'ľ'
	7234: {0x013F, 0x0140},   // 'Ŀ' => 'ŀ'
	7231: {0x013F, 0x0140},   // 'Ŀ' => 'ŀ'
	7228: {0x0141, 0x0142},   // 'Ł' => 'ł'
	7225: {0x0141, 0x0142},   // 'Ł' => 'ł'
	7222: {0x0143, 0x0144},   // 'Ń' => 'ń'
	7219: {0x0143, 0x0144},   // 'Ń' => 'ń'
	7216: {0x0145, 0x0146},   // 'Ņ' => 'ņ'
	7213: {0x0145, 0x0146},   // 'Ņ' => 'ņ'
	7210: {0x0147, 0x0148},   // 'Ň' => 'ň'
	7207: {0x0147, 0x0148},   // 'Ň' => 'ň'
	7201: {0x014A, 0x014B},   // 'Ŋ' => 'ŋ'
	7198: {0x014A, 0x014B},   // 'Ŋ' => 'ŋ'
	7195: {0x014C, 0x014D},   // 'Ō' => 'ō'
	7192: {0x014C, 0x014D},   // 'Ō' => 'ō'
	7189: {0x014E, 0x014F},   // 'Ŏ' => 'ŏ'
	7186: {0x014E, 0x014F},   // 'Ŏ' => 'ŏ'
	7183: {0x0150, 0x0151},   // 'Ő' => 'ő'
	7180: {0x0150, 0x0151},   // 'Ő' => 'ő'
	7177: {0x0152, 0x0153},   // 'Œ' => 'œ'
	7174: {0x0152, 0x0153},   // 'Œ' => 'œ'
	7171: {0x0154, 0x0155},   // 'Ŕ' => 'ŕ'
	7168: {0x0154, 0x0155},   // 'Ŕ' => 'ŕ'
	7165: {0x0156, 0x0157},   // 'Ŗ' => 'ŗ'
	7162: {0x0156, 0x0157},   // 'Ŗ' => 'ŗ'
	7159: {0x0158, 0x0159},   // 'Ř' => 'ř'
	7156: {0x0158, 0x0159},   // 'Ř' => 'ř'
	7153: {0x015A, 0x015B},   // 'Ś' => 'ś'
	7150: {0x015A, 0x015B},   // 'Ś' => 'ś'
	7147: {0x015C, 0x015D},   // 'Ŝ' => 'ŝ'
	7144: {0x015C, 0x015D},   // 'Ŝ' => 'ŝ'
	7141: {0x015E, 0x015F},   // 'Ş' => 'ş'
	7138: {0x015E, 0x015F},   // 'Ş' => 'ş'
	7135: {0x0160, 0x0161},   // 'Š' => 'š'
	7132: {0x0160, 0x0161},   // 'Š' => 'š'
	7129: {0x0162, 0x0163},   // 'Ţ' => 'ţ'
	7126: {0x0162, 0x0163},   // 'Ţ' => 'ţ'
	7123: {0x0164, 0x0165},   // 'Ť' => 'ť'
	7120: {0x0164, 0x0165},   // 'Ť' => 'ť'
	7117: {0x0166, 0x0167},   // 'Ŧ' => 'ŧ'
	7114: {0x0166, 0x0167},   // 'Ŧ' => 'ŧ'
	7111: {0x0168, 0x0169},   // 'Ũ' => 'ũ'
	7108: {0x0168, 0x0169},   // 'Ũ' => 'ũ'
	7105: {0x016A, 0x016B},   // 'Ū' => 'ū'
	7102: {0x016A, 0x016B},   // 'Ū' => 'ū'
	7099: {0x016C, 0x016D},   // 'Ŭ' => 'ŭ'
	7096: {0x016C, 0x016D},   // 'Ŭ' => 'ŭ'
	7093: {0x016E, 0x016F},   // 'Ů' => 'ů'
	7090: {0x016E, 0x016F},   // 'Ů' => 'ů'
	7087: {0x0170, 0x0171},   // 'Ű' => 'ű'
	7084: {0x0170, 0x0171},   // 'Ű' => 'ű'
	7081: {0x0172, 0x0173},   // 'Ų' => 'ų'
	7078: {0x0172, 0x0173},   // 'Ų' => 'ų'
	7075: {0x0174, 0x0175},   // 'Ŵ' => 'ŵ'
	7072: {0x0174, 0x0175},   // 'Ŵ' => 'ŵ'
	7069: {0x0176, 0x0177},   // 'Ŷ' => 'ŷ'
	7066: {0x0176, 0x0177},   // 'Ŷ' => 'ŷ'
	7063: {0x0178, 0x00FF},   // 'Ÿ' => 'ÿ'
	7060: {0x0179, 0x017A},   // 'Ź' => 'ź'
	7057: {0x0179, 0x017A},   // 'Ź' => 'ź'
	7054: {0x017B, 0x017C},   // 'Ż' => 'ż'
	7051: {0x017B, 0x017C},   // 'Ż' => 'ż'
	7048: {0x017D, 0x017E},   // 'Ž' => 'ž'
	7045: {0x017D, 0x017E},   // 'Ž' => 'ž'
	7042: {0x0053, 0x017F},   // 'S' => 'ſ'
	7039: {0x0243, 0x0180},   // 'Ƀ' => 'ƀ'
	7036: {0x0181, 0x0253},   // 'Ɓ' => 'ɓ'
	7033: {0x0182, 0x0183},   // 'Ƃ' => 'ƃ'
	7030: {0x0182, 0x0183},   // 'Ƃ' => 'ƃ'
	7027: {0x0184, 0x0185},   // 'Ƅ' => 'ƅ'
	7024: {0x0184, 0x0185},   // 'Ƅ' => 'ƅ'
	7021: {0x0186, 0x0254},   // 'Ɔ' => 'ɔ'
	7018: {0x0187, 0x0188},   // 'Ƈ' => 'ƈ'
	7015: {0x0187, 0x0188},   // 'Ƈ' => 'ƈ'
	7012: {0x0189, 0x0256},   // 'Ɖ' => 'ɖ'
	7009: {0x018A, 0x0257},   // 'Ɗ' => 'ɗ'
	7006: {0x018B, 0x018C},   // 'Ƌ' => 'ƌ'
	7003: {0x018B, 0x018C},   // 'Ƌ' => 'ƌ'
	6997: {0x018E, 0x01DD},   // 'Ǝ' => 'ǝ'
	6994: {0x018F, 0x0259},   // 'Ə' => 'ə'
	6991: {0x0190, 0x025B},   // 'Ɛ' => 'ɛ'
	6988: {0x0191, 0x0192},   // 'Ƒ' => 'ƒ'
	6985: {0x0191, 0x0192},   // 'Ƒ' => 'ƒ'
	6982: {0x0193, 0x0260},   // 'Ɠ' => 'ɠ'
	6979: {0x0194, 0x0263},   // 'Ɣ' => 'ɣ'
	6976: {0x01F6, 0x0195},   // 'Ƕ' => 'ƕ'
	6973: {0x0196, 0x0269},   // 'Ɩ' => 'ɩ'
	6970: {0x0197, 0x0268},   // 'Ɨ' => 'ɨ'
	6967: {0x0198, 0x0199},   // 'Ƙ' => 'ƙ'
	6964: {0x0198, 0x0199},   // 'Ƙ' => 'ƙ'
	6961: {0x023D, 0x019A},   // 'Ƚ' => 'ƚ'
	6955: {0x019C, 0x026F},   // 'Ɯ' => 'ɯ'
	6952: {0x019D, 0x0272},   // 'Ɲ' => 'ɲ'
	6949: {0x0220, 0x019E},   // 'Ƞ' => 'ƞ'
	6946: {0x019F, 0x0275},   // 'Ɵ' => 'ɵ'
	6943: {0x01A0, 0x01A1},   // 'Ơ' => 'ơ'
	6940: {0x01A0, 0x01A1},   // 'Ơ' => 'ơ'
	6937: {0x01A2, 0x01A3},   // 'Ƣ' => 'ƣ'
	6934: {0x01A2, 0x01A3},   // 'Ƣ' => 'ƣ'
	6931: {0x01A4, 0x01A5},   // 'Ƥ' => 'ƥ'
	6928: {0x01A4, 0x01A5},   // 'Ƥ' => 'ƥ'
	6925: {0x01A6, 0x0280},   // 'Ʀ' => 'ʀ'
	6922: {0x01A7, 0x01A8},   // 'Ƨ' => 'ƨ'
	6919: {0x01A7, 0x01A8},   // 'Ƨ' => 'ƨ'
	6916: {0x01A9, 0x0283},   // 'Ʃ' => 'ʃ'
	6907: {0x01AC, 0x01AD},   // 'Ƭ' => 'ƭ'
	6904: {0x01AC, 0x01AD},   // 'Ƭ' => 'ƭ'
	6901: {0x01AE, 0x0288},   // 'Ʈ' => 'ʈ'
	6898: {0x01AF, 0x01B0},   // 'Ư' => 'ư'
	6895: {0x01AF, 0x01B0},   // 'Ư' => 'ư'
	6892: {0x01B1, 0x028A},   // 'Ʊ' => 'ʊ'
	6889: {0x01B2, 0x028B},   // 'Ʋ' => 'ʋ'
	6886: {0x01B3, 0x01B4},   // 'Ƴ' => 'ƴ'
	6883: {0x01B3, 0x01B4},   // 'Ƴ' => 'ƴ'
	6880: {0x01B5, 0x01B6},   // 'Ƶ' => 'ƶ'
	6877: {0x01B5, 0x01B6},   // 'Ƶ' => 'ƶ'
	6874: {0x01B7, 0x0292},   // 'Ʒ' => 'ʒ'
	6871: {0x01B8, 0x01B9},   // 'Ƹ' => 'ƹ'
	6868: {0x01B8, 0x01B9},   // 'Ƹ' => 'ƹ'
	6859: {0x01BC, 0x01BD},   // 'Ƽ' => 'ƽ'
	6856: {0x01BC, 0x01BD},   // 'Ƽ' => 'ƽ'
	6850: {0x01F7, 0x01BF},   // 'Ƿ' => 'ƿ'
	6835: {0x01C4, 0x01C6},   // 'Ǆ' => 'ǆ'
	6829: {0x01C4, 0x01C6},   // 'Ǆ' => 'ǆ'
	6826: {0x01C7, 0x01C9},   // 'Ǉ' => 'ǉ'
	6820: {0x01C7, 0x01C9},   // 'Ǉ' => 'ǉ'
	6817: {0x01CA, 0x01CC},   // 'Ǌ' => 'ǌ'
	6811: {0x01CA, 0x01CC},   // 'Ǌ' => 'ǌ'
	6808: {0x01CD, 0x01CE},   // 'Ǎ' => 'ǎ'
	6805: {0x01CD, 0x01CE},   // 'Ǎ' => 'ǎ'
	6802: {0x01CF, 0x01D0},   // 'Ǐ' => 'ǐ'
	6799: {0x01CF, 0x01D0},   // 'Ǐ' => 'ǐ'
	6796: {0x01D1, 0x01D2},   // 'Ǒ' => 'ǒ'
	6793: {0x01D1, 0x01D2},   // 'Ǒ' => 'ǒ'
	6790: {0x01D3, 0x01D4},   // 'Ǔ' => 'ǔ'
	6787: {0x01D3, 0x01D4},   // 'Ǔ' => 'ǔ'
	6784: {0x01D5, 0x01D6},   // 'Ǖ' => 'ǖ'
	6781: {0x01D5, 0x01D6},   // 'Ǖ' => 'ǖ'
	6778: {0x01D7, 0x01D8},   // 'Ǘ' => 'ǘ'
	6775: {0x01D7, 0x01D8},   // 'Ǘ' => 'ǘ'
	6772: {0x01D9, 0x01DA},   // 'Ǚ' => 'ǚ'
	6769: {0x01D9, 0x01DA},   // 'Ǚ' => 'ǚ'
	6766: {0x01DB, 0x01DC},   // 'Ǜ' => 'ǜ'
	6763: {0x01DB, 0x01DC},   // 'Ǜ' => 'ǜ'
	6760: {0x018E, 0x01DD},   // 'Ǝ' => 'ǝ'
	6757: {0x01DE, 0x01DF},   // 'Ǟ' => 'ǟ'
	6754: {0x01DE, 0x01DF},   // 'Ǟ' => 'ǟ'
	6751: {0x01E0, 0x01E1},   // 'Ǡ' => 'ǡ'
	6748: {0x01E0, 0x01E1},   // 'Ǡ' => 'ǡ'
	6745: {0x01E2, 0x01E3},   // 'Ǣ' => 'ǣ'
	6742: {0x01E2, 0x01E3},   // 'Ǣ' => 'ǣ'
	6739: {0x01E4, 0x01E5},   // 'Ǥ' => 'ǥ'
	6736: {0x01E4, 0x01E5},   // 'Ǥ' => 'ǥ'
	6733: {0x01E6, 0x01E7},   // 'Ǧ' => 'ǧ'
	6730: {0x01E6, 0x01E7},   // 'Ǧ' => 'ǧ'
	6727: {0x01E8, 0x01E9},   // 'Ǩ' => 'ǩ'
	6724: {0x01E8, 0x01E9},   // 'Ǩ' => 'ǩ'
	6721: {0x01EA, 0x01EB},   // 'Ǫ' => 'ǫ'
	6718: {0x01EA, 0x01EB},   // 'Ǫ' => 'ǫ'
	6715: {0x01EC, 0x01ED},   // 'Ǭ' => 'ǭ'
	6712: {0x01EC, 0x01ED},   // 'Ǭ' => 'ǭ'
	6709: {0x01EE, 0x01EF},   // 'Ǯ' => 'ǯ'
	6706: {0x01EE, 0x01EF},   // 'Ǯ' => 'ǯ'
	6700: {0x01F1, 0x01F3},   // 'Ǳ' => 'ǳ'
	6694: {0x01F1, 0x01F3},   // 'Ǳ' => 'ǳ'
	6691: {0x01F4, 0x01F5},   // 'Ǵ' => 'ǵ'
	6688: {0x01F4, 0x01F5},   // 'Ǵ' => 'ǵ'
	6685: {0x01F6, 0x0195},   // 'Ƕ' => 'ƕ'
	6682: {0x01F7, 0x01BF},   // 'Ƿ' => 'ƿ'
	6679: {0x01F8, 0x01F9},   // 'Ǹ' => 'ǹ'
	6676: {0x01F8, 0x01F9},   // 'Ǹ' => 'ǹ'
	6673: {0x01FA, 0x01FB},   // 'Ǻ' => 'ǻ'
	6670: {0x01FA, 0x01FB},   // 'Ǻ' => 'ǻ'
	6667: {0x01FC, 0x01FD},   // 'Ǽ' => 'ǽ'
	6664: {0x01FC, 0x01FD},   // 'Ǽ' => 'ǽ'
	6661: {0x01FE, 0x01FF},   // 'Ǿ' => 'ǿ'
	6658: {0x01FE, 0x01FF},   // 'Ǿ' => 'ǿ'
	6655: {0x0200, 0x0201},   // 'Ȁ' => 'ȁ'
	6652: {0x0200, 0x0201},   // 'Ȁ' => 'ȁ'
	6649: {0x0202, 0x0203},   // 'Ȃ' => 'ȃ'
	6646: {0x0202, 0x0203},   // 'Ȃ' => 'ȃ'
	6643: {0x0204, 0x0205},   // 'Ȅ' => 'ȅ'
	6640: {0x0204, 0x0205},   // 'Ȅ' => 'ȅ'
	6637: {0x0206, 0x0207},   // 'Ȇ' => 'ȇ'
	6634: {0x0206, 0x0207},   // 'Ȇ' => 'ȇ'
	6631: {0x0208, 0x0209},   // 'Ȉ' => 'ȉ'
	6628: {0x0208, 0x0209},   // 'Ȉ' => 'ȉ'
	6625: {0x020A, 0x020B},   // 'Ȋ' => 'ȋ'
	6622: {0x020A, 0x020B},   // 'Ȋ' => 'ȋ'
	6619: {0x020C, 0x020D},   // 'Ȍ' => 'ȍ'
	6616: {0x020C, 0x020D},   // 'Ȍ' => 'ȍ'
	6613: {0x020E, 0x020F},   // 'Ȏ' => 'ȏ'
	6610: {0x020E, 0x020F},   // 'Ȏ' => 'ȏ'
	6607: {0x0210, 0x0211},   // 'Ȑ' => 'ȑ'
	6604: {0x0210, 0x0211},   // 'Ȑ' => 'ȑ'
	6601: {0x0212, 0x0213},   // 'Ȓ' => 'ȓ'
	6598: {0x0212, 0x0213},   // 'Ȓ' => 'ȓ'
	6595: {0x0214, 0x0215},   // 'Ȕ' => 'ȕ'
	6592: {0x0214, 0x0215},   // 'Ȕ' => 'ȕ'
	6589: {0x0216, 0x0217},   // 'Ȗ' => 'ȗ'
	6586: {0x0216, 0x0217},   // 'Ȗ' => 'ȗ'
	6583: {0x0218, 0x0219},   // 'Ș' => 'ș'
	6580: {0x0218, 0x0219},   // 'Ș' => 'ș'
	6577: {0x021A, 0x021B},   // 'Ț' => 'ț'
	6574: {0x021A, 0x021B},   // 'Ț' => 'ț'
	6571: {0x021C, 0x021D},   // 'Ȝ' => 'ȝ'
	6568: {0x021C, 0x021D},   // 'Ȝ' => 'ȝ'
	6565: {0x021E, 0x021F},   // 'Ȟ' => 'ȟ'
	6562: {0x021E, 0x021F},   // 'Ȟ' => 'ȟ'
	6559: {0x0220, 0x019E},   // 'Ƞ' => 'ƞ'
	6553: {0x0222, 0x0223},   // 'Ȣ' => 'ȣ'
	6550: {0x0222, 0x0223},   // 'Ȣ' => 'ȣ'
	6547: {0x0224, 0x0225},   // 'Ȥ' => 'ȥ'
	6544: {0x0224, 0x0225},   // 'Ȥ' => 'ȥ'
	6541: {0x0226, 0x0227},   // 'Ȧ' => 'ȧ'
	6538: {0x0226, 0x0227},   // 'Ȧ' => 'ȧ'
	6535: {0x0228, 0x0229},   // 'Ȩ' => 'ȩ'
	6532: {0x0228, 0x0229},   // 'Ȩ' => 'ȩ'
	6529: {0x022A, 0x022B},   // 'Ȫ' => 'ȫ'
	6526: {0x022A, 0x022B},   // 'Ȫ' => 'ȫ'
	6523: {0x022C, 0x022D},   // 'Ȭ' => 'ȭ'
	6520: {0x022C, 0x022D},   // 'Ȭ' => 'ȭ'
	6517: {0x022E, 0x022F},   // 'Ȯ' => 'ȯ'
	6514: {0x022E, 0x022F},   // 'Ȯ' => 'ȯ'
	6511: {0x0230, 0x0231},   // 'Ȱ' => 'ȱ'
	6508: {0x0230, 0x0231},   // 'Ȱ' => 'ȱ'
	6505: {0x0232, 0x0233},   // 'Ȳ' => 'ȳ'
	6502: {0x0232, 0x0233},   // 'Ȳ' => 'ȳ'
	6481: {0x023A, 0x2C65},   // 'Ⱥ' => 'ⱥ'
	6478: {0x023B, 0x023C},   // 'Ȼ' => 'ȼ'
	6475: {0x023B, 0x023C},   // 'Ȼ' => 'ȼ'
	6472: {0x023D, 0x019A},   // 'Ƚ' => 'ƚ'
	6469: {0x023E, 0x2C66},   // 'Ⱦ' => 'ⱦ'
	6466: {0x2C7E, 0x023F},   // 'Ȿ' => 'ȿ'
	6463: {0x2C7F, 0x0240},   // 'Ɀ' => 'ɀ'
	6460: {0x0241, 0x0242},   // 'Ɂ' => 'ɂ'
	6457: {0x0241, 0x0242},   // 'Ɂ' => 'ɂ'
	6454: {0x0243, 0x0180},   // 'Ƀ' => 'ƀ'
	6451: {0x0244, 0x0289},   // 'Ʉ' => 'ʉ'
	6448: {0x0245, 0x028C},   // 'Ʌ' => 'ʌ'
	6445: {0x0246, 0x0247},   // 'Ɇ' => 'ɇ'
	6442: {0x0246, 0x0247},   // 'Ɇ' => 'ɇ'
	6439: {0x0248, 0x0249},   // 'Ɉ' => 'ɉ'
	6436: {0x0248, 0x0249},   // 'Ɉ' => 'ɉ'
	6433: {0x024A, 0x024B},   // 'Ɋ' => 'ɋ'
	6430: {0x024A, 0x024B},   // 'Ɋ' => 'ɋ'
	6427: {0x024C, 0x024D},   // 'Ɍ' => 'ɍ'
	6424: {0x024C, 0x024D},   // 'Ɍ' => 'ɍ'
	6421: {0x024E, 0x024F},   // 'Ɏ' => 'ɏ'
	6418: {0x024E, 0x024F},   // 'Ɏ' => 'ɏ'
	6415: {0x2C6F, 0x0250},   // 'Ɐ' => 'ɐ'
	6412: {0x2C6D, 0x0251},   // 'Ɑ' => 'ɑ'
	6409: {0x2C70, 0x0252},   // 'Ɒ' => 'ɒ'
	6406: {0x0181, 0x0253},   // 'Ɓ' => 'ɓ'
	6403: {0x0186, 0x0254},   // 'Ɔ' => 'ɔ'
	6397: {0x0189, 0x0256},   // 'Ɖ' => 'ɖ'
	6394: {0x018A, 0x0257},   // 'Ɗ' => 'ɗ'
	6388: {0x018F, 0x0259},   // 'Ə' => 'ə'
	6382: {0x0190, 0x025B},   // 'Ɛ' => 'ɛ'
	6379: {0xA7AB, 0x025C},   // 'Ɜ' => 'ɜ'
	6367: {0x0193, 0x0260},   // 'Ɠ' => 'ɠ'
	6364: {0xA7AC, 0x0261},   // 'Ɡ' => 'ɡ'
	6358: {0x0194, 0x0263},   // 'Ɣ' => 'ɣ'
	6352: {0xA78D, 0x0265},   // 'Ɥ' => 'ɥ'
	6349: {0xA7AA, 0x0266},   // 'Ɦ' => 'ɦ'
	6343: {0x0197, 0x0268},   // 'Ɨ' => 'ɨ'
	6340: {0x0196, 0x0269},   // 'Ɩ' => 'ɩ'
	6337: {0xA7AE, 0x026A},   // 'Ɪ' => 'ɪ'
	6334: {0x2C62, 0x026B},   // 'Ɫ' => 'ɫ'
	6331: {0xA7AD, 0x026C},   // 'Ɬ' => 'ɬ'
	6322: {0x019C, 0x026F},   // 'Ɯ' => 'ɯ'
	6316: {0x2C6E, 0x0271},   // 'Ɱ' => 'ɱ'
	6313: {0x019D, 0x0272},   // 'Ɲ' => 'ɲ'
	6304: {0x019F, 0x0275},   // 'Ɵ' => 'ɵ'
	6280: {0x2C64, 0x027D},   // 'Ɽ' => 'ɽ'
	6271: {0x01A6, 0x0280},   // 'Ʀ' => 'ʀ'
	6265: {0xA7C5, 0x0282},   // 'Ʂ' => 'ʂ'
	6262: {0x01A9, 0x0283},   // 'Ʃ' => 'ʃ'
	6250: {0xA7B1, 0x0287},   // 'Ʇ' => 'ʇ'
	6247: {0x01AE, 0x0288},   // 'Ʈ' => 'ʈ'
	6244: {0x0244, 0x0289},   // 'Ʉ' => 'ʉ'
	6241: {0x01B1, 0x028A},   // 'Ʊ' => 'ʊ'
	6238: {0x01B2, 0x028B},   // 'Ʋ' => 'ʋ'
	6235: {0x0245, 0x028C},   // 'Ʌ' => 'ʌ'
	6217: {0x01B7, 0x0292},   // 'Ʒ' => 'ʒ'
	6184: {0xA7B2, 0x029D},   // 'Ʝ' => 'ʝ'
	6181: {0xA7B0, 0x029E},   // 'Ʞ' => 'ʞ'
	5680: {0x0399, 0x0345},   // 'Ι' => 'ͅ'
	5550: {0x0370, 0x0371},   // 'Ͱ' => 'ͱ'
	5547: {0x0370, 0x0371},   // 'Ͱ' => 'ͱ'
	5544: {0x0372, 0x0373},   // 'Ͳ' => 'ͳ'
	5541: {0x0372, 0x0373},   // 'Ͳ' => 'ͳ'
	5532: {0x0376, 0x0377},   // 'Ͷ' => 'ͷ'
	5529: {0x0376, 0x0377},   // 'Ͷ' => 'ͷ'
	5517: {0x03FD, 0x037B},   // 'Ͻ' => 'ͻ'
	5514: {0x03FE, 0x037C},   // 'Ͼ' => 'ͼ'
	5511: {0x03FF, 0x037D},   // 'Ͽ' => 'ͽ'
	5505: {0x037F, 0x03F3},   // 'Ϳ' => 'ϳ'
	5484: {0x0386, 0x03AC},   // 'Ά' => 'ά'
	5478: {0x0388, 0x03AD},   // 'Έ' => 'έ'
	5475: {0x0389, 0x03AE},   // 'Ή' => 'ή'
	5472: {0x038A, 0x03AF},   // 'Ί' => 'ί'
	5466: {0x038C, 0x03CC},   // 'Ό' => 'ό'
	5460: {0x038E, 0x03CD},   // 'Ύ' => 'ύ'
	5457: {0x038F, 0x03CE},   // 'Ώ' => 'ώ'
	5451: {0x0391, 0x03B1},   // 'Α' => 'α'
	5448: {0x0392, 0x03B2},   // 'Β' => 'β'
	5445: {0x0393, 0x03B3},   // 'Γ' => 'γ'
	5442: {0x0394, 0x03B4},   // 'Δ' => 'δ'
	5439: {0x0395, 0x03B5},   // 'Ε' => 'ε'
	5436: {0x0396, 0x03B6},   // 'Ζ' => 'ζ'
	5433: {0x0397, 0x03B7},   // 'Η' => 'η'
	5430: {0x0398, 0x03B8},   // 'Θ' => 'θ'
	5427: {0x0399, 0x03B9},   // 'Ι' => 'ι'
	5424: {0x039A, 0x03BA},   // 'Κ' => 'κ'
	5421: {0x039B, 0x03BB},   // 'Λ' => 'λ'
	5418: {0x039C, 0x03BC},   // 'Μ' => 'μ'
	5415: {0x039D, 0x03BD},   // 'Ν' => 'ν'
	5412: {0x039E, 0x03BE},   // 'Ξ' => 'ξ'
	5409: {0x039F, 0x03BF},   // 'Ο' => 'ο'
	5406: {0x03A0, 0x03C0},   // 'Π' => 'π'
	5403: {0x03A1, 0x03C1},   // 'Ρ' => 'ρ'
	5397: {0x03A3, 0x03C3},   // 'Σ' => 'σ'
	5394: {0x03A4, 0x03C4},   // 'Τ' => 'τ'
	5391: {0x03A5, 0x03C5},   // 'Υ' => 'υ'
	5388: {0x03A6, 0x03C6},   // 'Φ' => 'φ'
	5385: {0x03A7, 0x03C7},   // 'Χ' => 'χ'
	5382: {0x03A8, 0x03C8},   // 'Ψ' => 'ψ'
	5379: {0x03A9, 0x03C9},   // 'Ω' => 'ω'
	5376: {0x03AA, 0x03CA},   // 'Ϊ' => 'ϊ'
	5373: {0x03AB, 0x03CB},   // 'Ϋ' => 'ϋ'
	5370: {0x0386, 0x03AC},   // 'Ά' => 'ά'
	5367: {0x0388, 0x03AD},   // 'Έ' => 'έ'
	5364: {0x0389, 0x03AE},   // 'Ή' => 'ή'
	5361: {0x038A, 0x03AF},   // 'Ί' => 'ί'
	5355: {0x0391, 0x03B1},   // 'Α' => 'α'
	5352: {0x0392, 0x03B2},   // 'Β' => 'β'
	5349: {0x0393, 0x03B3},   // 'Γ' => 'γ'
	5346: {0x0394, 0x03B4},   // 'Δ' => 'δ'
	5343: {0x0395, 0x03B5},   // 'Ε' => 'ε'
	5340: {0x0396, 0x03B6},   // 'Ζ' => 'ζ'
	5337: {0x0397, 0x03B7},   // 'Η' => 'η'
	5334: {0x0398, 0x03B8},   // 'Θ' => 'θ'
	5331: {0x0399, 0x03B9},   // 'Ι' => 'ι'
	5328: {0x039A, 0x03BA},   // 'Κ' => 'κ'
	5325: {0x039B, 0x03BB},   // 'Λ' => 'λ'
	5322: {0x039C, 0x03BC},   // 'Μ' => 'μ'
	5319: {0x039D, 0x03BD},   // 'Ν' => 'ν'
	5316: {0x039E, 0x03BE},   // 'Ξ' => 'ξ'
	5313: {0x039F, 0x03BF},   // 'Ο' => 'ο'
	5310: {0x03A0, 0x03C0},   // 'Π' => 'π'
	5307: {0x03A1, 0x03C1},   // 'Ρ' => 'ρ'
	5304: {0x03A3, 0x03C2},   // 'Σ' => 'ς'
	5301: {0x03A3, 0x03C3},   // 'Σ' => 'σ'
	5298: {0x03A4, 0x03C4},   // 'Τ' => 'τ'
	5295: {0x03A5, 0x03C5},   // 'Υ' => 'υ'
	5292: {0x03A6, 0x03C6},   // 'Φ' => 'φ'
	5289: {0x03A7, 0x03C7},   // 'Χ' => 'χ'
	5286: {0x03A8, 0x03C8},   // 'Ψ' => 'ψ'
	5283: {0x03A9, 0x03C9},   // 'Ω' => 'ω'
	5280: {0x03AA, 0x03CA},   // 'Ϊ' => 'ϊ'
	5277: {0x03AB, 0x03CB},   // 'Ϋ' => 'ϋ'
	5274: {0x038C, 0x03CC},   // 'Ό' => 'ό'
	5271: {0x038E, 0x03CD},   // 'Ύ' => 'ύ'
	5268: {0x038F, 0x03CE},   // 'Ώ' => 'ώ'
	5265: {0x03CF, 0x03D7},   // 'Ϗ' => 'ϗ'
	5262: {0x0392, 0x03D0},   // 'Β' => 'ϐ'
	5259: {0x0398, 0x03D1},   // 'Θ' => 'ϑ'
	5247: {0x03A6, 0x03D5},   // 'Φ' => 'ϕ'
	5244: {0x03A0, 0x03D6},   // 'Π' => 'ϖ'
	5241: {0x03CF, 0x03D7},   // 'Ϗ' => 'ϗ'
	5238: {0x03D8, 0x03D9},   // 'Ϙ' => 'ϙ'
	5235: {0x03D8, 0x03D9},   // 'Ϙ' => 'ϙ'
	5232: {0x03DA, 0x03DB},   // 'Ϛ' => 'ϛ'
	5229: {0x03DA, 0x03DB},   // 'Ϛ' => 'ϛ'
	5226: {0x03DC, 0x03DD},   // 'Ϝ' => 'ϝ'
	5223: {0x03DC, 0x03DD},   // 'Ϝ' => 'ϝ'
	5220: {0x03DE, 0x03DF},   // 'Ϟ' => 'ϟ'
	5217: {0x03DE, 0x03DF},   // 'Ϟ' => 'ϟ'
	5214: {0x03E0, 0x03E1},   // 'Ϡ' => 'ϡ'
	5211: {0x03E0, 0x03E1},   // 'Ϡ' => 'ϡ'
	5208: {0x03E2, 0x03E3},   // 'Ϣ' => 'ϣ'
	5205: {0x03E2, 0x03E3},   // 'Ϣ' => 'ϣ'
	5202: {0x03E4, 0x03E5},   // 'Ϥ' => 'ϥ'
	5199: {0x03E4, 0x03E5},   // 'Ϥ' => 'ϥ'
	5196: {0x03E6, 0x03E7},   // 'Ϧ' => 'ϧ'
	5193: {0x03E6, 0x03E7},   // 'Ϧ' => 'ϧ'
	5190: {0x03E8, 0x03E9},   // 'Ϩ' => 'ϩ'
	5187: {0x03E8, 0x03E9},   // 'Ϩ' => 'ϩ'
	5184: {0x03EA, 0x03EB},   // 'Ϫ' => 'ϫ'
	5181: {0x03EA, 0x03EB},   // 'Ϫ' => 'ϫ'
	5178: {0x03EC, 0x03ED},   // 'Ϭ' => 'ϭ'
	5175: {0x03EC, 0x03ED},   // 'Ϭ' => 'ϭ'
	5172: {0x03EE, 0x03EF},   // 'Ϯ' => 'ϯ'
	5169: {0x03EE, 0x03EF},   // 'Ϯ' => 'ϯ'
	5166: {0x039A, 0x03F0},   // 'Κ' => 'ϰ'
	5163: {0x03A1, 0x03F1},   // 'Ρ' => 'ϱ'
	5160: {0x03F9, 0x03F2},   // 'Ϲ' => 'ϲ'
	5157: {0x037F, 0x03F3},   // 'Ϳ' => 'ϳ'
	5154: {0x03F4, 0x03B8},   // 'ϴ' => 'θ'
	5151: {0x0395, 0x03F5},   // 'Ε' => 'ϵ'
	5145: {0x03F7, 0x03F8},   // 'Ϸ' => 'ϸ'
	5142: {0x03F7, 0x03F8},   // 'Ϸ' => 'ϸ'
	5139: {0x03F9, 0x03F2},   // 'Ϲ' => 'ϲ'
	5136: {0x03FA, 0x03FB},   // 'Ϻ' => 'ϻ'
	5133: {0x03FA, 0x03FB},   // 'Ϻ' => 'ϻ'
	5127: {0x03FD, 0x037B},   // 'Ͻ' => 'ͻ'
	5124: {0x03FE, 0x037C},   // 'Ͼ' => 'ͼ'
	5121: {0x03FF, 0x037D},   // 'Ͽ' => 'ͽ'
	5118: {0x0400, 0x0450},   // 'Ѐ' => 'ѐ'
	5115: {0x0401, 0x0451},   // 'Ё' => 'ё'
	5112: {0x0402, 0x0452},   // 'Ђ' => 'ђ'
	5109: {0x0403, 0x0453},   // 'Ѓ' => 'ѓ'
	5106: {0x0404, 0x0454},   // 'Є' => 'є'
	5103: {0x0405, 0x0455},   // 'Ѕ' => 'ѕ'
	5100: {0x0406, 0x0456},   // 'І' => 'і'
	5097: {0x0407, 0x0457},   // 'Ї' => 'ї'
	5094: {0x0408, 0x0458},   // 'Ј' => 'ј'
	5091: {0x0409, 0x0459},   // 'Љ' => 'љ'
	5088: {0x040A, 0x045A},   // 'Њ' => 'њ'
	5085: {0x040B, 0x045B},   // 'Ћ' => 'ћ'
	5082: {0x040C, 0x045C},   // 'Ќ' => 'ќ'
	5079: {0x040D, 0x045D},   // 'Ѝ' => 'ѝ'
	5076: {0x040E, 0x045E},   // 'Ў' => 'ў'
	5073: {0x040F, 0x045F},   // 'Џ' => 'џ'
	5070: {0x0410, 0x0430},   // 'А' => 'а'
	5067: {0x0411, 0x0431},   // 'Б' => 'б'
	5064: {0x0412, 0x0432},   // 'В' => 'в'
	5061: {0x0413, 0x0433},   // 'Г' => 'г'
	5058: {0x0414, 0x0434},   // 'Д' => 'д'
	5055: {0x0415, 0x0435},   // 'Е' => 'е'
	5052: {0x0416, 0x0436},   // 'Ж' => 'ж'
	5049: {0x0417, 0x0437},   // 'З' => 'з'
	5046: {0x0418, 0x0438},   // 'И' => 'и'
	5043: {0x0419, 0x0439},   // 'Й' => 'й'
	5040: {0x041A, 0x043A},   // 'К' => 'к'
	5037: {0x041B, 0x043B},   // 'Л' => 'л'
	5034: {0x041C, 0x043C},   // 'М' => 'м'
	5031: {0x041D, 0x043D},   // 'Н' => 'н'
	5028: {0x041E, 0x043E},   // 'О' => 'о'
	5025: {0x041F, 0x043F},   // 'П' => 'п'
	5022: {0x0420, 0x0440},   // 'Р' => 'р'
	5019: {0x0421, 0x0441},   // 'С' => 'с'
	5016: {0x0422, 0x0442},   // 'Т' => 'т'
	5013: {0x0423, 0x0443},   // 'У' => 'у'
	5010: {0x0424, 0x0444},   // 'Ф' => 'ф'
	5007: {0x0425, 0x0445},   // 'Х' => 'х'
	5004: {0x0426, 0x0446},   // 'Ц' => 'ц'
	5001: {0x0427, 0x0447},   // 'Ч' => 'ч'
	4998: {0x0428, 0x0448},   // 'Ш' => 'ш'
	4995: {0x0429, 0x0449},   // 'Щ' => 'щ'
	4992: {0x042A, 0x044A},   // 'Ъ' => 'ъ'
	4989: {0x042B, 0x044B},   // 'Ы' => 'ы'
	4986: {0x042C, 0x044C},   // 'Ь' => 'ь'
	4983: {0x042D, 0x044D},   // 'Э' => 'э'
	4980: {0x042E, 0x044E},   // 'Ю' => 'ю'
	4977: {0x042F, 0x044F},   // 'Я' => 'я'
	4974: {0x0410, 0x0430},   // 'А' => 'а'
	4971: {0x0411, 0x0431},   // 'Б' => 'б'
	4968: {0x0412, 0x0432},   // 'В' => 'в'
	4965: {0x0413, 0x0433},   // 'Г' => 'г'
	4962: {0x0414, 0x0434},   // 'Д' => 'д'
	4959: {0x0415, 0x0435},   // 'Е' => 'е'
	4956: {0x0416, 0x0436},   // 'Ж' => 'ж'
	4953: {0x0417, 0x0437},   // 'З' => 'з'
	4950: {0x0418, 0x0438},   // 'И' => 'и'
	4947: {0x0419, 0x0439},   // 'Й' => 'й'
	4944: {0x041A, 0x043A},   // 'К' => 'к'
	4941: {0x041B, 0x043B},   // 'Л' => 'л'
	4938: {0x041C, 0x043C},   // 'М' => 'м'
	4935: {0x041D, 0x043D},   // 'Н' => 'н'
	4932: {0x041E, 0x043E},   // 'О' => 'о'
	4929: {0x041F, 0x043F},   // 'П' => 'п'
	4926: {0x0420, 0x0440},   // 'Р' => 'р'
	4923: {0x0421, 0x0441},   // 'С' => 'с'
	4920: {0x0422, 0x0442},   // 'Т' => 'т'
	4917: {0x0423, 0x0443},   // 'У' => 'у'
	4914: {0x0424, 0x0444},   // 'Ф' => 'ф'
	4911: {0x0425, 0x0445},   // 'Х' => 'х'
	4908: {0x0426, 0x0446},   // 'Ц' => 'ц'
	4905: {0x0427, 0x0447},   // 'Ч' => 'ч'
	4902: {0x0428, 0x0448},   // 'Ш' => 'ш'
	4899: {0x0429, 0x0449},   // 'Щ' => 'щ'
	4896: {0x042A, 0x044A},   // 'Ъ' => 'ъ'
	4893: {0x042B, 0x044B},   // 'Ы' => 'ы'
	4890: {0x042C, 0x044C},   // 'Ь' => 'ь'
	4887: {0x042D, 0x044D},   // 'Э' => 'э'
	4884: {0x042E, 0x044E},   // 'Ю' => 'ю'
	4881: {0x042F, 0x044F},   // 'Я' => 'я'
	4878: {0x0400, 0x0450},   // 'Ѐ' => 'ѐ'
	4875: {0x0401, 0x0451},   // 'Ё' => 'ё'
	4872: {0x0402, 0x0452},   // 'Ђ' => 'ђ'
	4869: {0x0403, 0x0453},   // 'Ѓ' => 'ѓ'
	4866: {0x0404, 0x0454},   // 'Є' => 'є'
	4863: {0x0405, 0x0455},   // 'Ѕ' => 'ѕ'
	4860: {0x0406, 0x0456},   // 'І' => 'і'
	4857: {0x0407, 0x0457},   // 'Ї' => 'ї'
	4854: {0x0408, 0x0458},   // 'Ј' => 'ј'
	4851: {0x0409, 0x0459},   // 'Љ' => 'љ'
	4848: {0x040A, 0x045A},   // 'Њ' => 'њ'
	4845: {0x040B, 0x045B},   // 'Ћ' => 'ћ'
	4842: {0x040C, 0x045C},   // 'Ќ' => 'ќ'
	4839: {0x040D, 0x045D},   // 'Ѝ' => 'ѝ'
	4836: {0x040E, 0x045E},   // 'Ў' => 'ў'
	4833: {0x040F, 0x045F},   // 'Џ' => 'џ'
	4830: {0x0460, 0x0461},   // 'Ѡ' => 'ѡ'
	4827: {0x0460, 0x0461},   // 'Ѡ' => 'ѡ'
	4824: {0x0462, 0x0463},   // 'Ѣ' => 'ѣ'
	4821: {0x0462, 0x0463},   // 'Ѣ' => 'ѣ'
	4818: {0x0464, 0x0465},   // 'Ѥ' => 'ѥ'
	4815: {0x0464, 0x0465},   // 'Ѥ' => 'ѥ'
	4812: {0x0466, 0x0467},   // 'Ѧ' => 'ѧ'
	4809: {0x0466, 0x0467},   // 'Ѧ' => 'ѧ'
	4806: {0x0468, 0x0469},   // 'Ѩ' => 'ѩ'
	4803: {0x0468, 0x0469},   // 'Ѩ' => 'ѩ'
	4800: {0x046A, 0x046B},   // 'Ѫ' => 'ѫ'
	4797: {0x046A, 0x046B},   // 'Ѫ' => 'ѫ'
	4794: {0x046C, 0x046D},   // 'Ѭ' => 'ѭ'
	4791: {0x046C, 0x046D},   // 'Ѭ' => 'ѭ'
	4788: {0x046E, 0x046F},   // 'Ѯ' => 'ѯ'
	4785: {0x046E, 0x046F},   // 'Ѯ' => 'ѯ'
	4782: {0x0470, 0x0471},   // 'Ѱ' => 'ѱ'
	4779: {0x0470, 0x0471},   // 'Ѱ' => 'ѱ'
	4776: {0x0472, 0x0473},   // 'Ѳ' => 'ѳ'
	4773: {0x0472, 0x0473},   // 'Ѳ' => 'ѳ'
	4770: {0x0474, 0x0475},   // 'Ѵ' => 'ѵ'
	4767: {0x0474, 0x0475},   // 'Ѵ' => 'ѵ'
	4764: {0x0476, 0x0477},   // 'Ѷ' => 'ѷ'
	4761: {0x0476, 0x0477},   // 'Ѷ' => 'ѷ'
	4758: {0x0478, 0x0479},   // 'Ѹ' => 'ѹ'
	4755: {0x0478, 0x0479},   // 'Ѹ' => 'ѹ'
	4752: {0x047A, 0x047B},   // 'Ѻ' => 'ѻ'
	4749: {0x047A, 0x047B},   // 'Ѻ' => 'ѻ'
	4746: {0x047C, 0x047D},   // 'Ѽ' => 'ѽ'
	4743: {0x047C, 0x047D},   // 'Ѽ' => 'ѽ'
	4740: {0x047E, 0x047F},   // 'Ѿ' => 'ѿ'
	4737: {0x047E, 0x047F},   // 'Ѿ' => 'ѿ'
	4734: {0x0480, 0x0481},   // 'Ҁ' => 'ҁ'
	4731: {0x0480, 0x0481},   // 'Ҁ' => 'ҁ'
	4704: {0x048A, 0x048B},   // 'Ҋ' => 'ҋ'
	4701: {0x048A, 0x048B},   // 'Ҋ' => 'ҋ'
	4698: {0x048C, 0x048D},   // 'Ҍ' => 'ҍ'
	4695: {0x048C, 0x048D},   // 'Ҍ' => 'ҍ'
	4692: {0x048E, 0x048F},   // 'Ҏ' => 'ҏ'
	4689: {0x048E, 0x048F},   // 'Ҏ' => 'ҏ'
	4686: {0x0490, 0x0491},   // 'Ґ' => 'ґ'
	4683: {0x0490, 0x0491},   // 'Ґ' => 'ґ'
	4680: {0x0492, 0x0493},   // 'Ғ' => 'ғ'
	4677: {0x0492, 0x0493},   // 'Ғ' => 'ғ'
	4674: {0x0494, 0x0495},   // 'Ҕ' => 'ҕ'
	4671: {0x0494, 0x0495},   // 'Ҕ' => 'ҕ'
	4668: {0x0496, 0x0497},   // 'Җ' => 'җ'
	4665: {0x0496, 0x0497},   // 'Җ' => 'җ'
	4662: {0x0498, 0x0499},   // 'Ҙ' => 'ҙ'
	4659: {0x0498, 0x0499},   // 'Ҙ' => 'ҙ'
	4656: {0x049A, 0x049B},   // 'Қ' => 'қ'
	4653: {0x049A, 0x049B},   // 'Қ' => 'қ'
	4650: {0x049C, 0x049D},   // 'Ҝ' => 'ҝ'
	4647: {0x049C, 0x049D},   // 'Ҝ' => 'ҝ'
	4644: {0x049E, 0x049F},   // 'Ҟ' => 'ҟ'
	4641: {0x049E, 0x049F},   // 'Ҟ' => 'ҟ'
	4638: {0x04A0, 0x04A1},   // 'Ҡ' => 'ҡ'
	4635: {0x04A0, 0x04A1},   // 'Ҡ' => 'ҡ'
	4632: {0x04A2, 0x04A3},   // 'Ң' => 'ң'
	4629: {0x04A2, 0x04A3},   // 'Ң' => 'ң'
	4626: {0x04A4, 0x04A5},   // 'Ҥ' => 'ҥ'
	4623: {0x04A4, 0x04A5},   // 'Ҥ' => 'ҥ'
	4620: {0x04A6, 0x04A7},   // 'Ҧ' => 'ҧ'
	4617: {0x04A6, 0x04A7},   // 'Ҧ' => 'ҧ'
	4614: {0x04A8, 0x04A9},   // 'Ҩ' => 'ҩ'
	4611: {0x04A8, 0x04A9},   // 'Ҩ' => 'ҩ'
	4608: {0x04AA, 0x04AB},   // 'Ҫ' => 'ҫ'
	4605: {0x04AA, 0x04AB},   // 'Ҫ' => 'ҫ'
	4602: {0x04AC, 0x04AD},   // 'Ҭ' => 'ҭ'
	4599: {0x04AC, 0x04AD},   // 'Ҭ' => 'ҭ'
	4596: {0x04AE, 0x04AF},   // 'Ү' => 'ү'
	4593: {0x04AE, 0x04AF},   // 'Ү' => 'ү'
	4590: {0x04B0, 0x04B1},   // 'Ұ' => 'ұ'
	4587: {0x04B0, 0x04B1},   // 'Ұ' => 'ұ'
	4584: {0x04B2, 0x04B3},   // 'Ҳ' => 'ҳ'
	4581: {0x04B2, 0x04B3},   // 'Ҳ' => 'ҳ'
	4578: {0x04B4, 0x04B5},   // 'Ҵ' => 'ҵ'
	4575: {0x04B4, 0x04B5},   // 'Ҵ' => 'ҵ'
	4572: {0x04B6, 0x04B7},   // 'Ҷ' => 'ҷ'
	4569: {0x04B6, 0x04B7},   // 'Ҷ' => 'ҷ'
	4566: {0x04B8, 0x04B9},   // 'Ҹ' => 'ҹ'
	4563: {0x04B8, 0x04B9},   // 'Ҹ' => 'ҹ'
	4560: {0x04BA, 0x04BB},   // 'Һ' => 'һ'
	4557: {0x04BA, 0x04BB},   // 'Һ' => 'һ'
	4554: {0x04BC, 0x04BD},   // 'Ҽ' => 'ҽ'
	4551: {0x04BC, 0x04BD},   // 'Ҽ' => 'ҽ'
	4548: {0x04BE, 0x04BF},   // 'Ҿ' => 'ҿ'
	4545: {0x04BE, 0x04BF},   // 'Ҿ' => 'ҿ'
	4542: {0x04C0, 0x04CF},   // 'Ӏ' => 'ӏ'
	4539: {0x04C1, 0x04C2},   // 'Ӂ' => 'ӂ'
	4536: {0x04C1, 0x04C2},   // 'Ӂ' => 'ӂ'
	4533: {0x04C3, 0x04C4},   // 'Ӄ' => 'ӄ'
	4530: {0x04C3, 0x04C4},   // 'Ӄ' => 'ӄ'
	4527: {0x04C5, 0x04C6},   // 'Ӆ' => 'ӆ'
	4524: {0x04C5, 0x04C6},   // 'Ӆ' => 'ӆ'
	4521: {0x04C7, 0x04C8},   // 'Ӈ' => 'ӈ'
	4518: {0x04C7, 0x04C8},   // 'Ӈ' => 'ӈ'
	4515: {0x04C9, 0x04CA},   // 'Ӊ' => 'ӊ'
	4512: {0x04C9, 0x04CA},   // 'Ӊ' => 'ӊ'
	4509: {0x04CB, 0x04CC},   // 'Ӌ' => 'ӌ'
	4506: {0x04CB, 0x04CC},   // 'Ӌ' => 'ӌ'
	4503: {0x04CD, 0x04CE},   // 'Ӎ' => 'ӎ'
	4500: {0x04CD, 0x04CE},   // 'Ӎ' => 'ӎ'
	4497: {0x04C0, 0x04CF},   // 'Ӏ' => 'ӏ'
	4494: {0x04D0, 0x04D1},   // 'Ӑ' => 'ӑ'
	4491: {0x04D0, 0x04D1},   // 'Ӑ' => 'ӑ'
	4488: {0x04D2, 0x04D3},   // 'Ӓ' => 'ӓ'
	4485: {0x04D2, 0x04D3},   // 'Ӓ' => 'ӓ'
	4482: {0x04D4, 0x04D5},   // 'Ӕ' => 'ӕ'
	4479: {0x04D4, 0x04D5},   // 'Ӕ' => 'ӕ'
	4476: {0x04D6, 0x04D7},   // 'Ӗ' => 'ӗ'
	4473: {0x04D6, 0x04D7},   // 'Ӗ' => 'ӗ'
	4470: {0x04D8, 0x04D9},   // 'Ә' => 'ә'
	4467: {0x04D8, 0x04D9},   // 'Ә' => 'ә'
	4464: {0x04DA, 0x04DB},   // 'Ӛ' => 'ӛ'
	4461: {0x04DA, 0x04DB},   // 'Ӛ' => 'ӛ'
	4458: {0x04DC, 0x04DD},   // 'Ӝ' => 'ӝ'
	4455: {0x04DC, 0x04DD},   // 'Ӝ' => 'ӝ'
	4452: {0x04DE, 0x04DF},   // 'Ӟ' => 'ӟ'
	4449: {0x04DE, 0x04DF},   // 'Ӟ' => 'ӟ'
	4446: {0x04E0, 0x04E1},   // 'Ӡ' => 'ӡ'
	4443: {0x04E0, 0x04E1},   // 'Ӡ' => 'ӡ'
	4440: {0x04E2, 0x04E3},   // 'Ӣ' => 'ӣ'
	4437: {0x04E2, 0x04E3},   // 'Ӣ' => 'ӣ'
	4434: {0x04E4, 0x04E5},   // 'Ӥ' => 'ӥ'
	4431: {0x04E4, 0x04E5},   // 'Ӥ' => 'ӥ'
	4428: {0x04E6, 0x04E7},   // 'Ӧ' => 'ӧ'
	4425: {0x04E6, 0x04E7},   // 'Ӧ' => 'ӧ'
	4422: {0x04E8, 0x04E9},   // 'Ө' => 'ө'
	4419: {0x04E8, 0x04E9},   // 'Ө' => 'ө'
	4416: {0x04EA, 0x04EB},   // 'Ӫ' => 'ӫ'
	4413: {0x04EA, 0x04EB},   // 'Ӫ' => 'ӫ'
	4410: {0x04EC, 0x04ED},   // 'Ӭ' => 'ӭ'
	4407: {0x04EC, 0x04ED},   // 'Ӭ' => 'ӭ'
	4404: {0x04EE, 0x04EF},   // 'Ӯ' => 'ӯ'
	4401: {0x04EE, 0x04EF},   // 'Ӯ' => 'ӯ'
	4398: {0x04F0, 0x04F1},   // 'Ӱ' => 'ӱ'
	4395: {0x04F0, 0x04F1},   // 'Ӱ' => 'ӱ'
	4392: {0x04F2, 0x04F3},   // 'Ӳ' => 'ӳ'
	4389: {0x04F2, 0x04F3},   // 'Ӳ' => 'ӳ'
	4386: {0x04F4, 0x04F5},   // 'Ӵ' => 'ӵ'
	4383: {0x04F4, 0x04F5},   // 'Ӵ' => 'ӵ'
	4380: {0x04F6, 0x04F7},   // 'Ӷ' => 'ӷ'
	4377: {0x04F6, 0x04F7},   // 'Ӷ' => 'ӷ'
	4374: {0x04F8, 0x04F9},   // 'Ӹ' => 'ӹ'
	4371: {0x04F8, 0x04F9},   // 'Ӹ' => 'ӹ'
	4368: {0x04FA, 0x04FB},   // 'Ӻ' => 'ӻ'
	4365: {0x04FA, 0x04FB},   // 'Ӻ' => 'ӻ'
	4362: {0x04FC, 0x04FD},   // 'Ӽ' => 'ӽ'
	4359: {0x04FC, 0x04FD},   // 'Ӽ' => 'ӽ'
	4356: {0x04FE, 0x04FF},   // 'Ӿ' => 'ӿ'
	4353: {0x04FE, 0x04FF},   // 'Ӿ' => 'ӿ'
	4350: {0x0500, 0x0501},   // 'Ԁ' => 'ԁ'
	4347: {0x0500, 0x0501},   // 'Ԁ' => 'ԁ'
	4344: {0x0502, 0x0503},   // 'Ԃ' => 'ԃ'
	4341: {0x0502, 0x0503},   // 'Ԃ' => 'ԃ'
	4338: {0x0504, 0x0505},   // 'Ԅ' => 'ԅ'
	4335: {0x0504, 0x0505},   // 'Ԅ' => 'ԅ'
	4332: {0x0506, 0x0507},   // 'Ԇ' => 'ԇ'
	4329: {0x0506, 0x0507},   // 'Ԇ' => 'ԇ'
	4326: {0x0508, 0x0509},   // 'Ԉ' => 'ԉ'
	4323: {0x0508, 0x0509},   // 'Ԉ' => 'ԉ'
	4320: {0x050A, 0x050B},   // 'Ԋ' => 'ԋ'
	4317: {0x050A, 0x050B},   // 'Ԋ' => 'ԋ'
	4314: {0x050C, 0x050D},   // 'Ԍ' => 'ԍ'
	4311: {0x050C, 0x050D},   // 'Ԍ' => 'ԍ'
	4308: {0x050E, 0x050F},   // 'Ԏ' => 'ԏ'
	4305: {0x050E, 0x050F},   // 'Ԏ' => 'ԏ'
	4302: {0x0510, 0x0511},   // 'Ԑ' => 'ԑ'
	4299: {0x0510, 0x0511},   // 'Ԑ' => 'ԑ'
	4296: {0x0512, 0x0513},   // 'Ԓ' => 'ԓ'
	4293: {0x0512, 0x0513},   // 'Ԓ' => 'ԓ'
	4290: {0x0514, 0x0515},   // 'Ԕ' => 'ԕ'
	4287: {0x0514, 0x0515},   // 'Ԕ' => 'ԕ'
	4284: {0x0516, 0x0517},   // 'Ԗ' => 'ԗ'
	4281: {0x0516, 0x0517},   // 'Ԗ' => 'ԗ'
	4278: {0x0518, 0x0519},   // 'Ԙ' => 'ԙ'
	4275: {0x0518, 0x0519},   // 'Ԙ' => 'ԙ'
	4272: {0x051A, 0x051B},   // 'Ԛ' => 'ԛ'
	4269: {0x051A, 0x051B},   // 'Ԛ' => 'ԛ'
	4266: {0x051C, 0x051D},   // 'Ԝ' => 'ԝ'
	4263: {0x051C, 0x051D},   // 'Ԝ' => 'ԝ'
	4260: {0x051E, 0x051F},   // 'Ԟ' => 'ԟ'
	4257: {0x051E, 0x051F},   // 'Ԟ' => 'ԟ'
	4254: {0x0520, 0x0521},   // 'Ԡ' => 'ԡ'
	4251: {0x0520, 0x0521},   // 'Ԡ' => 'ԡ'
	4248: {0x0522, 0x0523},   // 'Ԣ' => 'ԣ'
	4245: {0x0522, 0x0523},   // 'Ԣ' => 'ԣ'
	4242: {0x0524, 0x0525},   // 'Ԥ' => 'ԥ'
	4239: {0x0524, 0x0525},   // 'Ԥ' => 'ԥ'
	4236: {0x0526, 0x0527},   // 'Ԧ' => 'ԧ'
	4233: {0x0526, 0x0527},   // 'Ԧ' => 'ԧ'
	4230: {0x0528, 0x0529},   // 'Ԩ' => 'ԩ'
	4227: {0x0528, 0x0529},   // 'Ԩ' => 'ԩ'
	4224: {0x052A, 0x052B},   // 'Ԫ' => 'ԫ'
	4221: {0x052A, 0x052B},   // 'Ԫ' => 'ԫ'
	4218: {0x052C, 0x052D},   // 'Ԭ' => 'ԭ'
	4215: {0x052C, 0x052D},   // 'Ԭ' => 'ԭ'
	4212: {0x052E, 0x052F},   // 'Ԯ' => 'ԯ'
	4209: {0x052E, 0x052F},   // 'Ԯ' => 'ԯ'
	4203: {0x0531, 0x0561},   // 'Ա' => 'ա'
	4200: {0x0532, 0x0562},   // 'Բ' => 'բ'
	4197: {0x0533, 0x0563},   // 'Գ' => 'գ'
	4194: {0x0534, 0x0564},   // 'Դ' => 'դ'
	4191: {0x0535, 0x0565},   // 'Ե' => 'ե'
	4188: {0x0536, 0x0566},   // 'Զ' => 'զ'
	4185: {0x0537, 0x0567},   // 'Է' => 'է'
	4182: {0x0538, 0x0568},   // 'Ը' => 'ը'
	4179: {0x0539, 0x0569},   // 'Թ' => 'թ'
	4176: {0x053A, 0x056A},   // 'Ժ' => 'ժ'
	4173: {0x053B, 0x056B},   // 'Ի' => 'ի'
	4170: {0x053C, 0x056C},   // 'Լ' => 'լ'
	4167: {0x053D, 0x056D},   // 'Խ' => 'խ'
	4164: {0x053E, 0x056E},   // 'Ծ' => 'ծ'
	4161: {0x053F, 0x056F},   // 'Կ' => 'կ'
	4158: {0x0540, 0x0570},   // 'Հ' => 'հ'
	4155: {0x0541, 0x0571},   // 'Ձ' => 'ձ'
	4152: {0x0542, 0x0572},   // 'Ղ' => 'ղ'
	4149: {0x0543, 0x0573},   // 'Ճ' => 'ճ'
	4146: {0x0544, 0x0574},   // 'Մ' => 'մ'
	4143: {0x0545, 0x0575},   // 'Յ' => 'յ'
	4140: {0x0546, 0x0576},   // 'Ն' => 'ն'
	4137: {0x0547, 0x0577},   // 'Շ' => 'շ'
	4134: {0x0548, 0x0578},   // 'Ո' => 'ո'
	4131: {0x0549, 0x0579},   // 'Չ' => 'չ'
	4128: {0x054A, 0x057A},   // 'Պ' => 'պ'
	4125: {0x054B, 0x057B},   // 'Ջ' => 'ջ'
	4122: {0x054C, 0x057C},   // 'Ռ' => 'ռ'
	4119: {0x054D, 0x057D},   // 'Ս' => 'ս'
	4116: {0x054E, 0x057E},   // 'Վ' => 'վ'
	4113: {0x054F, 0x057F},   // 'Տ' => 'տ'
	4110: {0x0550, 0x0580},   // 'Ր' => 'ր'
	4107: {0x0551, 0x0581},   // 'Ց' => 'ց'
	4104: {0x0552, 0x0582},   // 'Ւ' => 'ւ'
	4101: {0x0553, 0x0583},   // 'Փ' => 'փ'
	4098: {0x0554, 0x0584},   // 'Ք' => 'ք'
	4095: {0x0555, 0x0585},   // 'Օ' => 'օ'
	4092: {0x0556, 0x0586},   // 'Ֆ' => 'ֆ'
	4059: {0x0531, 0x0561},   // 'Ա' => 'ա'
	4056: {0x0532, 0x0562},   // 'Բ' => 'բ'
	4053: {0x0533, 0x0563},   // 'Գ' => 'գ'
	4050: {0x0534, 0x0564},   // 'Դ' => 'դ'
	4047: {0x0535, 0x0565},   // 'Ե' => 'ե'
	4044: {0x0536, 0x0566},   // 'Զ' => 'զ'
	4041: {0x0537, 0x0567},   // 'Է' => 'է'
	4038: {0x0538, 0x0568},   // 'Ը' => 'ը'
	4035: {0x0539, 0x0569},   // 'Թ' => 'թ'
	4032: {0x053A, 0x056A},   // 'Ժ' => 'ժ'
	4029: {0x053B, 0x056B},   // 'Ի' => 'ի'
	4026: {0x053C, 0x056C},   // 'Լ' => 'լ'
	4023: {0x053D, 0x056D},   // 'Խ' => 'խ'
	4020: {0x053E, 0x056E},   // 'Ծ' => 'ծ'
	4017: {0x053F, 0x056F},   // 'Կ' => 'կ'
	4014: {0x0540, 0x0570},   // 'Հ' => 'հ'
	4011: {0x0541, 0x0571},   // 'Ձ' => 'ձ'
	4008: {0x0542, 0x0572},   // 'Ղ' => 'ղ'
	4005: {0x0543, 0x0573},   // 'Ճ' => 'ճ'
	4002: {0x0544, 0x0574},   // 'Մ' => 'մ'
	3999: {0x0545, 0x0575},   // 'Յ' => 'յ'
	3996: {0x0546, 0x0576},   // 'Ն' => 'ն'
	3993: {0x0547, 0x0577},   // 'Շ' => 'շ'
	3990: {0x0548, 0x0578},   // 'Ո' => 'ո'
	3987: {0x0549, 0x0579},   // 'Չ' => 'չ'
	3984: {0x054A, 0x057A},   // 'Պ' => 'պ'
	3981: {0x054B, 0x057B},   // 'Ջ' => 'ջ'
	3978: {0x054C, 0x057C},   // 'Ռ' => 'ռ'
	3975: {0x054D, 0x057D},   // 'Ս' => 'ս'
	3972: {0x054E, 0x057E},   // 'Վ' => 'վ'
	3969: {0x054F, 0x057F},   // 'Տ' => 'տ'
	3966: {0x0550, 0x0580},   // 'Ր' => 'ր'
	3963: {0x0551, 0x0581},   // 'Ց' => 'ց'
	3960: {0x0552, 0x0582},   // 'Ւ' => 'ւ'
	3957: {0x0553, 0x0583},   // 'Փ' => 'փ'
	3954: {0x0554, 0x0584},   // 'Ք' => 'ք'
	3951: {0x0555, 0x0585},   // 'Օ' => 'օ'
	3948: {0x0556, 0x0586},   // 'Ֆ' => 'ֆ'
	3610: {0x10A0, 0x2D00},   // 'Ⴀ' => 'ⴀ'
	3607: {0x10A1, 0x2D01},   // 'Ⴁ' => 'ⴁ'
	3604: {0x10A2, 0x2D02},   // 'Ⴂ' => 'ⴂ'
	3601: {0x10A3, 0x2D03},   // 'Ⴃ' => 'ⴃ'
	3598: {0x10A4, 0x2D04},   // 'Ⴄ' => 'ⴄ'
	3595: {0x10A5, 0x2D05},   // 'Ⴅ' => 'ⴅ'
	3592: {0x10A6, 0x2D06},   // 'Ⴆ' => 'ⴆ'
	3589: {0x10A7, 0x2D07},   // 'Ⴇ' => 'ⴇ'
	3586: {0x10A8, 0x2D08},   // 'Ⴈ' => 'ⴈ'
	3583: {0x10A9, 0x2D09},   // 'Ⴉ' => 'ⴉ'
	3580: {0x10AA, 0x2D0A},   // 'Ⴊ' => 'ⴊ'
	3577: {0x10AB, 0x2D0B},   // 'Ⴋ' => 'ⴋ'
	3574: {0x10AC, 0x2D0C},   // 'Ⴌ' => 'ⴌ'
	3571: {0x10AD, 0x2D0D},   // 'Ⴍ' => 'ⴍ'
	3568: {0x10AE, 0x2D0E},   // 'Ⴎ' => 'ⴎ'
	3565: {0x10AF, 0x2D0F},   // 'Ⴏ' => 'ⴏ'
	3562: {0x10B0, 0x2D10},   // 'Ⴐ' => 'ⴐ'
	3559: {0x10B1, 0x2D11},   // 'Ⴑ' => 'ⴑ'
	3556: {0x10B2, 0x2D12},   // 'Ⴒ' => 'ⴒ'
	3553: {0x10B3, 0x2D13},   // 'Ⴓ' => 'ⴓ'
	3550: {0x10B4, 0x2D14},   // 'Ⴔ' => 'ⴔ'
	3547: {0x10B5, 0x2D15},   // 'Ⴕ' => 'ⴕ'
	3544: {0x10B6, 0x2D16},   // 'Ⴖ' => 'ⴖ'
	3541: {0x10B7, 0x2D17},   // 'Ⴗ' => 'ⴗ'
	3538: {0x10B8, 0x2D18},   // 'Ⴘ' => 'ⴘ'
	3535: {0x10B9, 0x2D19},   // 'Ⴙ' => 'ⴙ'
	3532: {0x10BA, 0x2D1A},   // 'Ⴚ' => 'ⴚ'
	3529: {0x10BB, 0x2D1B},   // 'Ⴛ' => 'ⴛ'
	3526: {0x10BC, 0x2D1C},   // 'Ⴜ' => 'ⴜ'
	3523: {0x10BD, 0x2D1D},   // 'Ⴝ' => 'ⴝ'
	3520: {0x10BE, 0x2D1E},   // 'Ⴞ' => 'ⴞ'
	3517: {0x10BF, 0x2D1F},   // 'Ⴟ' => 'ⴟ'
	3514: {0x10C0, 0x2D20},   // 'Ⴠ' => 'ⴠ'
	3511: {0x10C1, 0x2D21},   // 'Ⴡ' => 'ⴡ'
	3508: {0x10C2, 0x2D22},   // 'Ⴢ' => 'ⴢ'
	3505: {0x10C3, 0x2D23},   // 'Ⴣ' => 'ⴣ'
	3502: {0x10C4, 0x2D24},   // 'Ⴤ' => 'ⴤ'
	3499: {0x10C5, 0x2D25},   // 'Ⴥ' => 'ⴥ'
	3493: {0x10C7, 0x2D27},   // 'Ⴧ' => 'ⴧ'
	3475: {0x10CD, 0x2D2D},   // 'Ⴭ' => 'ⴭ'
	3466: {0x1C90, 0x10D0},   // 'Ა' => 'ა'
	3463: {0x1C91, 0x10D1},   // 'Ბ' => 'ბ'
	3460: {0x1C92, 0x10D2},   // 'Გ' => 'გ'
	3457: {0x1C93, 0x10D3},   // 'Დ' => 'დ'
	3454: {0x1C94, 0x10D4},   // 'Ე' => 'ე'
	3451: {0x1C95, 0x10D5},   // 'Ვ' => 'ვ'
	3448: {0x1C96, 0x10D6},   // 'Ზ' => 'ზ'
	3445: {0x1C97, 0x10D7},   // 'Თ' => 'თ'
	3442: {0x1C98, 0x10D8},   // 'Ი' => 'ი'
	3439: {0x1C99, 0x10D9},   // 'Კ' => 'კ'
	3436: {0x1C9A, 0x10DA},   // 'Ლ' => 'ლ'
	3433: {0x1C9B, 0x10DB},   // 'Მ' => 'მ'
	3430: {0x1C9C, 0x10DC},   // 'Ნ' => 'ნ'
	3427: {0x1C9D, 0x10DD},   // 'Ო' => 'ო'
	3424: {0x1C9E, 0x10DE},   // 'Პ' => 'პ'
	3421: {0x1C9F, 0x10DF},   // 'Ჟ' => 'ჟ'
	3418: {0x1CA0, 0x10E0},   // 'Რ' => 'რ'
	3415: {0x1CA1, 0x10E1},   // 'Ს' => 'ს'
	3412: {0x1CA2, 0x10E2},   // 'Ტ' => 'ტ'
	3409: {0x1CA3, 0x10E3},   // 'Უ' => 'უ'
	3406: {0x1CA4, 0x10E4},   // 'Ფ' => 'ფ'
	3403: {0x1CA5, 0x10E5},   // 'Ქ' => 'ქ'
	3400: {0x1CA6, 0x10E6},   // 'Ღ' => 'ღ'
	3397: {0x1CA7, 0x10E7},   // 'Ყ' => 'ყ'
	3394: {0x1CA8, 0x10E8},   // 'Შ' => 'შ'
	3391: {0x1CA9, 0x10E9},   // 'Ჩ' => 'ჩ'
	3388: {0x1CAA, 0x10EA},   // 'Ც' => 'ც'
	3385: {0x1CAB, 0x10EB},   // 'Ძ' => 'ძ'
	3382: {0x1CAC, 0x10EC},   // 'Წ' => 'წ'
	3379: {0x1CAD, 0x10ED},   // 'Ჭ' => 'ჭ'
	3376: {0x1CAE, 0x10EE},   // 'Ხ' => 'ხ'
	3373: {0x1CAF, 0x10EF},   // 'Ჯ' => 'ჯ'
	3370: {0x1CB0, 0x10F0},   // 'Ჰ' => 'ჰ'
	3367: {0x1CB1, 0x10F1},   // 'Ჱ' => 'ჱ'
	3364: {0x1CB2, 0x10F2},   // 'Ჲ' => 'ჲ'
	3361: {0x1CB3, 0x10F3},   // 'Ჳ' => 'ჳ'
	3358: {0x1CB4, 0x10F4},   // 'Ჴ' => 'ჴ'
	3355: {0x1CB5, 0x10F5},   // 'Ჵ' => 'ჵ'
	3352: {0x1CB6, 0x10F6},   // 'Ჶ' => 'ჶ'
	3349: {0x1CB7, 0x10F7},   // 'Ჷ' => 'ჷ'
	3346: {0x1CB8, 0x10F8},   // 'Ჸ' => 'ჸ'
	3343: {0x1CB9, 0x10F9},   // 'Ჹ' => 'ჹ'
	3340: {0x1CBA, 0x10FA},   // 'Ჺ' => 'ჺ'
	3331: {0x1CBD, 0x10FD},   // 'Ჽ' => 'ჽ'
	3328: {0x1CBE, 0x10FE},   // 'Ჾ' => 'ჾ'
	3325: {0x1CBF, 0x10FF},   // 'Ჿ' => 'ჿ'
	1306: {0x13A0, 0xAB70},   // 'Ꭰ' => 'ꭰ'
	1303: {0x13A1, 0xAB71},   // 'Ꭱ' => 'ꭱ'
	1300: {0x13A2, 0xAB72},   // 'Ꭲ' => 'ꭲ'
	1297: {0x13A3, 0xAB73},   // 'Ꭳ' => 'ꭳ'
	1294: {0x13A4, 0xAB74},   // 'Ꭴ' => 'ꭴ'
	1291: {0x13A5, 0xAB75},   // 'Ꭵ' => 'ꭵ'
	1288: {0x13A6, 0xAB76},   // 'Ꭶ' => 'ꭶ'
	1285: {0x13A7, 0xAB77},   // 'Ꭷ' => 'ꭷ'
	1282: {0x13A8, 0xAB78},   // 'Ꭸ' => 'ꭸ'
	1279: {0x13A9, 0xAB79},   // 'Ꭹ' => 'ꭹ'
	1276: {0x13AA, 0xAB7A},   // 'Ꭺ' => 'ꭺ'
	1273: {0x13AB, 0xAB7B},   // 'Ꭻ' => 'ꭻ'
	1270: {0x13AC, 0xAB7C},   // 'Ꭼ' => 'ꭼ'
	1267: {0x13AD, 0xAB7D},   // 'Ꭽ' => 'ꭽ'
	1264: {0x13AE, 0xAB7E},   // 'Ꭾ' => 'ꭾ'
	1261: {0x13AF, 0xAB7F},   // 'Ꭿ' => 'ꭿ'
	1258: {0x13B0, 0xAB80},   // 'Ꮀ' => 'ꮀ'
	1255: {0x13B1, 0xAB81},   // 'Ꮁ' => 'ꮁ'
	1252: {0x13B2, 0xAB82},   // 'Ꮂ' => 'ꮂ'
	1249: {0x13B3, 0xAB83},   // 'Ꮃ' => 'ꮃ'
	1246: {0x13B4, 0xAB84},   // 'Ꮄ' => 'ꮄ'
	1243: {0x13B5, 0xAB85},   // 'Ꮅ' => 'ꮅ'
	1240: {0x13B6, 0xAB86},   // 'Ꮆ' => 'ꮆ'
	1237: {0x13B7, 0xAB87},   // 'Ꮇ' => 'ꮇ'
	1234: {0x13B8, 0xAB88},   // 'Ꮈ' => 'ꮈ'
	1231: {0x13B9, 0xAB89},   // 'Ꮉ' => 'ꮉ'
	1228: {0x13BA, 0xAB8A},   // 'Ꮊ' => 'ꮊ'
	1225: {0x13BB, 0xAB8B},   // 'Ꮋ' => 'ꮋ'
	1222: {0x13BC, 0xAB8C},   // 'Ꮌ' => 'ꮌ'
	1219: {0x13BD, 0xAB8D},   // 'Ꮍ' => 'ꮍ'
	1216: {0x13BE, 0xAB8E},   // 'Ꮎ' => 'ꮎ'
	1213: {0x13BF, 0xAB8F},   // 'Ꮏ' => 'ꮏ'
	1210: {0x13C0, 0xAB90},   // 'Ꮐ' => 'ꮐ'
	1207: {0x13C1, 0xAB91},   // 'Ꮑ' => 'ꮑ'
	1204: {0x13C2, 0xAB92},   // 'Ꮒ' => 'ꮒ'
	1201: {0x13C3, 0xAB93},   // 'Ꮓ' => 'ꮓ'
	1198: {0x13C4, 0xAB94},   // 'Ꮔ' => 'ꮔ'
	1195: {0x13C5, 0xAB95},   // 'Ꮕ' => 'ꮕ'
	1192: {0x13C6, 0xAB96},   // 'Ꮖ' => 'ꮖ'
	1189: {0x13C7, 0xAB97},   // 'Ꮗ' => 'ꮗ'
	1186: {0x13C8, 0xAB98},   // 'Ꮘ' => 'ꮘ'
	1183: {0x13C9, 0xAB99},   // 'Ꮙ' => 'ꮙ'
	1180: {0x13CA, 0xAB9A},   // 'Ꮚ' => 'ꮚ'
	1177: {0x13CB, 0xAB9B},   // 'Ꮛ' => 'ꮛ'
	1174: {0x13CC, 0xAB9C},   // 'Ꮜ' => 'ꮜ'
	1171: {0x13CD, 0xAB9D},   // 'Ꮝ' => 'ꮝ'
	1168: {0x13CE, 0xAB9E},   // 'Ꮞ' => 'ꮞ'
	1165: {0x13CF, 0xAB9F},   // 'Ꮟ' => 'ꮟ'
	1162: {0x13D0, 0xABA0},   // 'Ꮠ' => 'ꮠ'
	1159: {0x13D1, 0xABA1},   // 'Ꮡ' => 'ꮡ'
	1156: {0x13D2, 0xABA2},   // 'Ꮢ' => 'ꮢ'
	1153: {0x13D3, 0xABA3},   // 'Ꮣ' => 'ꮣ'
	1150: {0x13D4, 0xABA4},   // 'Ꮤ' => 'ꮤ'
	1147: {0x13D5, 0xABA5},   // 'Ꮥ' => 'ꮥ'
	1144: {0x13D6, 0xABA6},   // 'Ꮦ' => 'ꮦ'
	1141: {0x13D7, 0xABA7},   // 'Ꮧ' => 'ꮧ'
	1138: {0x13D8, 0xABA8},   // 'Ꮨ' => 'ꮨ'
	1135: {0x13D9, 0xABA9},   // 'Ꮩ' => 'ꮩ'
	1131: {0x13DA, 0xABAA},   // 'Ꮪ' => 'ꮪ'
	1128: {0x13DB, 0xABAB},   // 'Ꮫ' => 'ꮫ'
	1125: {0x13DC, 0xABAC},   // 'Ꮬ' => 'ꮬ'
	1122: {0x13DD, 0xABAD},   // 'Ꮭ' => 'ꮭ'
	1119: {0x13DE, 0xABAE},   // 'Ꮮ' => 'ꮮ'
	1116: {0x13DF, 0xABAF},   // 'Ꮯ' => 'ꮯ'
	1113: {0x13E0, 0xABB0},   // 'Ꮰ' => 'ꮰ'
	1110: {0x13E1, 0xABB1},   // 'Ꮱ' => 'ꮱ'
	1107: {0x13E2, 0xABB2},   // 'Ꮲ' => 'ꮲ'
	1104: {0x13E3, 0xABB3},   // 'Ꮳ' => 'ꮳ'
	1101: {0x13E4, 0xABB4},   // 'Ꮴ' => 'ꮴ'
	1098: {0x13E5, 0xABB5},   // 'Ꮵ' => 'ꮵ'
	1095: {0x13E6, 0xABB6},   // 'Ꮶ' => 'ꮶ'
	1092: {0x13E7, 0xABB7},   // 'Ꮷ' => 'ꮷ'
	1089: {0x13E8, 0xABB8},   // 'Ꮸ' => 'ꮸ'
	1086: {0x13E9, 0xABB9},   // 'Ꮹ' => 'ꮹ'
	1083: {0x13EA, 0xABBA},   // 'Ꮺ' => 'ꮺ'
	1080: {0x13EB, 0xABBB},   // 'Ꮻ' => 'ꮻ'
	1077: {0x13EC, 0xABBC},   // 'Ꮼ' => 'ꮼ'
	1074: {0x13ED, 0xABBD},   // 'Ꮽ' => 'ꮽ'
	1071: {0x13EE, 0xABBE},   // 'Ꮾ' => 'ꮾ'
	1068: {0x13EF, 0xABBF},   // 'Ꮿ' => 'ꮿ'
	1065: {0x13F0, 0x13F8},   // 'Ᏸ' => 'ᏸ'
	1062: {0x13F1, 0x13F9},   // 'Ᏹ' => 'ᏹ'
	1059: {0x13F2, 0x13FA},   // 'Ᏺ' => 'ᏺ'
	1056: {0x13F3, 0x13FB},   // 'Ᏻ' => 'ᏻ'
	1053: {0x13F4, 0x13FC},   // 'Ᏼ' => 'ᏼ'
	1050: {0x13F5, 0x13FD},   // 'Ᏽ' => 'ᏽ'
	1041: {0x13F0, 0x13F8},   // 'Ᏸ' => 'ᏸ'
	1038: {0x13F1, 0x13F9},   // 'Ᏹ' => 'ᏹ'
	1035: {0x13F2, 0x13FA},   // 'Ᏺ' => 'ᏺ'
	1032: {0x13F3, 0x13FB},   // 'Ᏻ' => 'ᏻ'
	1029: {0x13F4, 0x13FC},   // 'Ᏼ' => 'ᏼ'
	1026: {0x13F5, 0x13FD},   // 'Ᏽ' => 'ᏽ'
	2679: {0x0412, 0x1C80},   // 'В' => 'ᲀ'
	2676: {0x0414, 0x1C81},   // 'Д' => 'ᲁ'
	2673: {0x041E, 0x1C82},   // 'О' => 'ᲂ'
	2670: {0x0421, 0x1C83},   // 'С' => 'ᲃ'
	2667: {0x0422, 0x1C84},   // 'Т' => 'ᲄ'
	2664: {0x0422, 0x1C85},   // 'Т' => 'ᲅ'
	2661: {0x042A, 0x1C86},   // 'Ъ' => 'ᲆ'
	2658: {0x0462, 0x1C87},   // 'Ѣ' => 'ᲇ'
	2655: {0xA64A, 0x1C88},   // 'Ꙋ' => 'ᲈ'
	2631: {0x1C90, 0x10D0},   // 'Ა' => 'ა'
	2628: {0x1C91, 0x10D1},   // 'Ბ' => 'ბ'
	2625: {0x1C92, 0x10D2},   // 'Გ' => 'გ'
	2622: {0x1C93, 0x10D3},   // 'Დ' => 'დ'
	2619: {0x1C94, 0x10D4},   // 'Ე' => 'ე'
	2616: {0x1C95, 0x10D5},   // 'Ვ' => 'ვ'
	2613: {0x1C96, 0x10D6},   // 'Ზ' => 'ზ'
	2610: {0x1C97, 0x10D7},   // 'Თ' => 'თ'
	2607: {0x1C98, 0x10D8},   // 'Ი' => 'ი'
	2604: {0x1C99, 0x10D9},   // 'Კ' => 'კ'
	2601: {0x1C9A, 0x10DA},   // 'Ლ' => 'ლ'
	2598: {0x1C9B, 0x10DB},   // 'Მ' => 'მ'
	2595: {0x1C9C, 0x10DC},   // 'Ნ' => 'ნ'
	2592: {0x1C9D, 0x10DD},   // 'Ო' => 'ო'
	2589: {0x1C9E, 0x10DE},   // 'Პ' => 'პ'
	2586: {0x1C9F, 0x10DF},   // 'Ჟ' => 'ჟ'
	2583: {0x1CA0, 0x10E0},   // 'Რ' => 'რ'
	2580: {0x1CA1, 0x10E1},   // 'Ს' => 'ს'
	2577: {0x1CA2, 0x10E2},   // 'Ტ' => 'ტ'
	2574: {0x1CA3, 0x10E3},   // 'Უ' => 'უ'
	2571: {0x1CA4, 0x10E4},   // 'Ფ' => 'ფ'
	2568: {0x1CA5, 0x10E5},   // 'Ქ' => 'ქ'
	2565: {0x1CA6, 0x10E6},   // 'Ღ' => 'ღ'
	2562: {0x1CA7, 0x10E7},   // 'Ყ' => 'ყ'
	2559: {0x1CA8, 0x10E8},   // 'Შ' => 'შ'
	2556: {0x1CA9, 0x10E9},   // 'Ჩ' => 'ჩ'
	2553: {0x1CAA, 0x10EA},   // 'Ც' => 'ც'
	2550: {0x1CAB, 0x10EB},   // 'Ძ' => 'ძ'
	2547: {0x1CAC, 0x10EC},   // 'Წ' => 'წ'
	2544: {0x1CAD, 0x10ED},   // 'Ჭ' => 'ჭ'
	2541: {0x1CAE, 0x10EE},   // 'Ხ' => 'ხ'
	2538: {0x1CAF, 0x10EF},   // 'Ჯ' => 'ჯ'
	2535: {0x1CB0, 0x10F0},   // 'Ჰ' => 'ჰ'
	2532: {0x1CB1, 0x10F1},   // 'Ჱ' => 'ჱ'
	2529: {0x1CB2, 0x10F2},   // 'Ჲ' => 'ჲ'
	2526: {0x1CB3, 0x10F3},   // 'Ჳ' => 'ჳ'
	2523: {0x1CB4, 0x10F4},   // 'Ჴ' => 'ჴ'
	2520: {0x1CB5, 0x10F5},   // 'Ჵ' => 'ჵ'
	2517: {0x1CB6, 0x10F6},   // 'Ჶ' => 'ჶ'
	2514: {0x1CB7, 0x10F7},   // 'Ჷ' => 'ჷ'
	2511: {0x1CB8, 0x10F8},   // 'Ჸ' => 'ჸ'
	2508: {0x1CB9, 0x10F9},   // 'Ჹ' => 'ჹ'
	2505: {0x1CBA, 0x10FA},   // 'Ჺ' => 'ჺ'
	2496: {0x1CBD, 0x10FD},   // 'Ჽ' => 'ჽ'
	2493: {0x1CBE, 0x10FE},   // 'Ჾ' => 'ჾ'
	2490: {0x1CBF, 0x10FF},   // 'Ჿ' => 'ჿ'
	1932: {0xA77D, 0x1D79},   // 'Ᵹ' => 'ᵹ'
	1920: {0x2C63, 0x1D7D},   // 'Ᵽ' => 'ᵽ'
	1869: {0xA7C6, 0x1D8E},   // 'Ᶎ' => 'ᶎ'
	1526: {0x1E00, 0x1E01},   // 'Ḁ' => 'ḁ'
	1523: {0x1E00, 0x1E01},   // 'Ḁ' => 'ḁ'
	1520: {0x1E02, 0x1E03},   // 'Ḃ' => 'ḃ'
	1517: {0x1E02, 0x1E03},   // 'Ḃ' => 'ḃ'
	1514: {0x1E04, 0x1E05},   // 'Ḅ' => 'ḅ'
	1511: {0x1E04, 0x1E05},   // 'Ḅ' => 'ḅ'
	1508: {0x1E06, 0x1E07},   // 'Ḇ' => 'ḇ'
	1505: {0x1E06, 0x1E07},   // 'Ḇ' => 'ḇ'
	1502: {0x1E08, 0x1E09},   // 'Ḉ' => 'ḉ'
	1499: {0x1E08, 0x1E09},   // 'Ḉ' => 'ḉ'
	1496: {0x1E0A, 0x1E0B},   // 'Ḋ' => 'ḋ'
	1493: {0x1E0A, 0x1E0B},   // 'Ḋ' => 'ḋ'
	1490: {0x1E0C, 0x1E0D},   // 'Ḍ' => 'ḍ'
	1487: {0x1E0C, 0x1E0D},   // 'Ḍ' => 'ḍ'
	1484: {0x1E0E, 0x1E0F},   // 'Ḏ' => 'ḏ'
	1481: {0x1E0E, 0x1E0F},   // 'Ḏ' => 'ḏ'
	1478: {0x1E10, 0x1E11},   // 'Ḑ' => 'ḑ'
	1475: {0x1E10, 0x1E11},   // 'Ḑ' => 'ḑ'
	1472: {0x1E12, 0x1E13},   // 'Ḓ' => 'ḓ'
	1469: {0x1E12, 0x1E13},   // 'Ḓ' => 'ḓ'
	1466: {0x1E14, 0x1E15},   // 'Ḕ' => 'ḕ'
	1463: {0x1E14, 0x1E15},   // 'Ḕ' => 'ḕ'
	1460: {0x1E16, 0x1E17},   // 'Ḗ' => 'ḗ'
	1457: {0x1E16, 0x1E17},   // 'Ḗ' => 'ḗ'
	1454: {0x1E18, 0x1E19},   // 'Ḙ' => 'ḙ'
	1451: {0x1E18, 0x1E19},   // 'Ḙ' => 'ḙ'
	1448: {0x1E1A, 0x1E1B},   // 'Ḛ' => 'ḛ'
	1445: {0x1E1A, 0x1E1B},   // 'Ḛ' => 'ḛ'
	1442: {0x1E1C, 0x1E1D},   // 'Ḝ' => 'ḝ'
	1439: {0x1E1C, 0x1E1D},   // 'Ḝ' => 'ḝ'
	1436: {0x1E1E, 0x1E1F},   // 'Ḟ' => 'ḟ'
	1433: {0x1E1E, 0x1E1F},   // 'Ḟ' => 'ḟ'
	1430: {0x1E20, 0x1E21},   // 'Ḡ' => 'ḡ'
	1427: {0x1E20, 0x1E21},   // 'Ḡ' => 'ḡ'
	1424: {0x1E22, 0x1E23},   // 'Ḣ' => 'ḣ'
	1421: {0x1E22, 0x1E23},   // 'Ḣ' => 'ḣ'
	1418: {0x1E24, 0x1E25},   // 'Ḥ' => 'ḥ'
	1415: {0x1E24, 0x1E25},   // 'Ḥ' => 'ḥ'
	1412: {0x1E26, 0x1E27},   // 'Ḧ' => 'ḧ'
	1409: {0x1E26, 0x1E27},   // 'Ḧ' => 'ḧ'
	1406: {0x1E28, 0x1E29},   // 'Ḩ' => 'ḩ'
	1403: {0x1E28, 0x1E29},   // 'Ḩ' => 'ḩ'
	1400: {0x1E2A, 0x1E2B},   // 'Ḫ' => 'ḫ'
	1397: {0x1E2A, 0x1E2B},   // 'Ḫ' => 'ḫ'
	1394: {0x1E2C, 0x1E2D},   // 'Ḭ' => 'ḭ'
	1391: {0x1E2C, 0x1E2D},   // 'Ḭ' => 'ḭ'
	1388: {0x1E2E, 0x1E2F},   // 'Ḯ' => 'ḯ'
	1385: {0x1E2E, 0x1E2F},   // 'Ḯ' => 'ḯ'
	1382: {0x1E30, 0x1E31},   // 'Ḱ' => 'ḱ'
	1379: {0x1E30, 0x1E31},   // 'Ḱ' => 'ḱ'
	1376: {0x1E32, 0x1E33},   // 'Ḳ' => 'ḳ'
	1373: {0x1E32, 0x1E33},   // 'Ḳ' => 'ḳ'
	1370: {0x1E34, 0x1E35},   // 'Ḵ' => 'ḵ'
	1367: {0x1E34, 0x1E35},   // 'Ḵ' => 'ḵ'
	1364: {0x1E36, 0x1E37},   // 'Ḷ' => 'ḷ'
	1361: {0x1E36, 0x1E37},   // 'Ḷ' => 'ḷ'
	1358: {0x1E38, 0x1E39},   // 'Ḹ' => 'ḹ'
	1355: {0x1E38, 0x1E39},   // 'Ḹ' => 'ḹ'
	1352: {0x1E3A, 0x1E3B},   // 'Ḻ' => 'ḻ'
	1349: {0x1E3A, 0x1E3B},   // 'Ḻ' => 'ḻ'
	1346: {0x1E3C, 0x1E3D},   // 'Ḽ' => 'ḽ'
	1343: {0x1E3C, 0x1E3D},   // 'Ḽ' => 'ḽ'
	1340: {0x1E3E, 0x1E3F},   // 'Ḿ' => 'ḿ'
	1337: {0x1E3E, 0x1E3F},   // 'Ḿ' => 'ḿ'
	1334: {0x1E40, 0x1E41},   // 'Ṁ' => 'ṁ'
	1331: {0x1E40, 0x1E41},   // 'Ṁ' => 'ṁ'
	1328: {0x1E42, 0x1E43},   // 'Ṃ' => 'ṃ'
	1325: {0x1E42, 0x1E43},   // 'Ṃ' => 'ṃ'
	1322: {0x1E44, 0x1E45},   // 'Ṅ' => 'ṅ'
	1319: {0x1E44, 0x1E45},   // 'Ṅ' => 'ṅ'
	1316: {0x1E46, 0x1E47},   // 'Ṇ' => 'ṇ'
	1313: {0x1E46, 0x1E47},   // 'Ṇ' => 'ṇ'
	1310: {0x1E48, 0x1E49},   // 'Ṉ' => 'ṉ'
	1307: {0x1E48, 0x1E49},   // 'Ṉ' => 'ṉ'
	1304: {0x1E4A, 0x1E4B},   // 'Ṋ' => 'ṋ'
	1301: {0x1E4A, 0x1E4B},   // 'Ṋ' => 'ṋ'
	1298: {0x1E4C, 0x1E4D},   // 'Ṍ' => 'ṍ'
	1295: {0x1E4C, 0x1E4D},   // 'Ṍ' => 'ṍ'
	1292: {0x1E4E, 0x1E4F},   // 'Ṏ' => 'ṏ'
	1289: {0x1E4E, 0x1E4F},   // 'Ṏ' => 'ṏ'
	1286: {0x1E50, 0x1E51},   // 'Ṑ' => 'ṑ'
	1283: {0x1E50, 0x1E51},   // 'Ṑ' => 'ṑ'
	1280: {0x1E52, 0x1E53},   // 'Ṓ' => 'ṓ'
	1277: {0x1E52, 0x1E53},   // 'Ṓ' => 'ṓ'
	1274: {0x1E54, 0x1E55},   // 'Ṕ' => 'ṕ'
	1271: {0x1E54, 0x1E55},   // 'Ṕ' => 'ṕ'
	1268: {0x1E56, 0x1E57},   // 'Ṗ' => 'ṗ'
	1265: {0x1E56, 0x1E57},   // 'Ṗ' => 'ṗ'
	1262: {0x1E58, 0x1E59},   // 'Ṙ' => 'ṙ'
	1259: {0x1E58, 0x1E59},   // 'Ṙ' => 'ṙ'
	1256: {0x1E5A, 0x1E5B},   // 'Ṛ' => 'ṛ'
	1253: {0x1E5A, 0x1E5B},   // 'Ṛ' => 'ṛ'
	1250: {0x1E5C, 0x1E5D},   // 'Ṝ' => 'ṝ'
	1247: {0x1E5C, 0x1E5D},   // 'Ṝ' => 'ṝ'
	1244: {0x1E5E, 0x1E5F},   // 'Ṟ' => 'ṟ'
	1241: {0x1E5E, 0x1E5F},   // 'Ṟ' => 'ṟ'
	1238: {0x1E60, 0x1E61},   // 'Ṡ' => 'ṡ'
	1235: {0x1E60, 0x1E61},   // 'Ṡ' => 'ṡ'
	1232: {0x1E62, 0x1E63},   // 'Ṣ' => 'ṣ'
	1229: {0x1E62, 0x1E63},   // 'Ṣ' => 'ṣ'
	1226: {0x1E64, 0x1E65},   // 'Ṥ' => 'ṥ'
	1223: {0x1E64, 0x1E65},   // 'Ṥ' => 'ṥ'
	1220: {0x1E66, 0x1E67},   // 'Ṧ' => 'ṧ'
	1217: {0x1E66, 0x1E67},   // 'Ṧ' => 'ṧ'
	1214: {0x1E68, 0x1E69},   // 'Ṩ' => 'ṩ'
	1211: {0x1E68, 0x1E69},   // 'Ṩ' => 'ṩ'
	1208: {0x1E6A, 0x1E6B},   // 'Ṫ' => 'ṫ'
	1205: {0x1E6A, 0x1E6B},   // 'Ṫ' => 'ṫ'
	1202: {0x1E6C, 0x1E6D},   // 'Ṭ' => 'ṭ'
	1199: {0x1E6C, 0x1E6D},   // 'Ṭ' => 'ṭ'
	1196: {0x1E6E, 0x1E6F},   // 'Ṯ' => 'ṯ'
	1193: {0x1E6E, 0x1E6F},   // 'Ṯ' => 'ṯ'
	1190: {0x1E70, 0x1E71},   // 'Ṱ' => 'ṱ'
	1187: {0x1E70, 0x1E71},   // 'Ṱ' => 'ṱ'
	1184: {0x1E72, 0x1E73},   // 'Ṳ' => 'ṳ'
	1181: {0x1E72, 0x1E73},   // 'Ṳ' => 'ṳ'
	1178: {0x1E74, 0x1E75},   // 'Ṵ' => 'ṵ'
	1175: {0x1E74, 0x1E75},   // 'Ṵ' => 'ṵ'
	1172: {0x1E76, 0x1E77},   // 'Ṷ' => 'ṷ'
	1169: {0x1E76, 0x1E77},   // 'Ṷ' => 'ṷ'
	1166: {0x1E78, 0x1E79},   // 'Ṹ' => 'ṹ'
	1163: {0x1E78, 0x1E79},   // 'Ṹ' => 'ṹ'
	1160: {0x1E7A, 0x1E7B},   // 'Ṻ' => 'ṻ'
	1157: {0x1E7A, 0x1E7B},   // 'Ṻ' => 'ṻ'
	1154: {0x1E7C, 0x1E7D},   // 'Ṽ' => 'ṽ'
	1151: {0x1E7C, 0x1E7D},   // 'Ṽ' => 'ṽ'
	1148: {0x1E7E, 0x1E7F},   // 'Ṿ' => 'ṿ'
	1145: {0x1E7E, 0x1E7F},   // 'Ṿ' => 'ṿ'
	1142: {0x1E80, 0x1E81},   // 'Ẁ' => 'ẁ'
	1139: {0x1E80, 0x1E81},   // 'Ẁ' => 'ẁ'
	1136: {0x1E82, 0x1E83},   // 'Ẃ' => 'ẃ'
	1133: {0x1E82, 0x1E83},   // 'Ẃ' => 'ẃ'
	1130: {0x1E84, 0x1E85},   // 'Ẅ' => 'ẅ'
	1127: {0x1E84, 0x1E85},   // 'Ẅ' => 'ẅ'
	1124: {0x1E86, 0x1E87},   // 'Ẇ' => 'ẇ'
	1121: {0x1E86, 0x1E87},   // 'Ẇ' => 'ẇ'
	1118: {0x1E88, 0x1E89},   // 'Ẉ' => 'ẉ'
	1115: {0x1E88, 0x1E89},   // 'Ẉ' => 'ẉ'
	1112: {0x1E8A, 0x1E8B},   // 'Ẋ' => 'ẋ'
	1109: {0x1E8A, 0x1E8B},   // 'Ẋ' => 'ẋ'
	1106: {0x1E8C, 0x1E8D},   // 'Ẍ' => 'ẍ'
	1103: {0x1E8C, 0x1E8D},   // 'Ẍ' => 'ẍ'
	1100: {0x1E8E, 0x1E8F},   // 'Ẏ' => 'ẏ'
	1097: {0x1E8E, 0x1E8F},   // 'Ẏ' => 'ẏ'
	1094: {0x1E90, 0x1E91},   // 'Ẑ' => 'ẑ'
	1091: {0x1E90, 0x1E91},   // 'Ẑ' => 'ẑ'
	1088: {0x1E92, 0x1E93},   // 'Ẓ' => 'ẓ'
	1085: {0x1E92, 0x1E93},   // 'Ẓ' => 'ẓ'
	1082: {0x1E94, 0x1E95},   // 'Ẕ' => 'ẕ'
	1079: {0x1E94, 0x1E95},   // 'Ẕ' => 'ẕ'
	1061: {0x1E60, 0x1E9B},   // 'Ṡ' => 'ẛ'
	1052: {0x1E9E, 0x00DF},   // 'ẞ' => 'ß'
	1046: {0x1EA0, 0x1EA1},   // 'Ạ' => 'ạ'
	1043: {0x1EA0, 0x1EA1},   // 'Ạ' => 'ạ'
	1040: {0x1EA2, 0x1EA3},   // 'Ả' => 'ả'
	1037: {0x1EA2, 0x1EA3},   // 'Ả' => 'ả'
	1034: {0x1EA4, 0x1EA5},   // 'Ấ' => 'ấ'
	1031: {0x1EA4, 0x1EA5},   // 'Ấ' => 'ấ'
	1028: {0x1EA6, 0x1EA7},   // 'Ầ' => 'ầ'
	1025: {0x1EA6, 0x1EA7},   // 'Ầ' => 'ầ'
	1022: {0x1EA8, 0x1EA9},   // 'Ẩ' => 'ẩ'
	1019: {0x1EA8, 0x1EA9},   // 'Ẩ' => 'ẩ'
	1016: {0x1EAA, 0x1EAB},   // 'Ẫ' => 'ẫ'
	1013: {0x1EAA, 0x1EAB},   // 'Ẫ' => 'ẫ'
	1010: {0x1EAC, 0x1EAD},   // 'Ậ' => 'ậ'
	1007: {0x1EAC, 0x1EAD},   // 'Ậ' => 'ậ'
	1004: {0x1EAE, 0x1EAF},   // 'Ắ' => 'ắ'
	1001: {0x1EAE, 0x1EAF},   // 'Ắ' => 'ắ'
	998:  {0x1EB0, 0x1EB1},   // 'Ằ' => 'ằ'
	995:  {0x1EB0, 0x1EB1},   // 'Ằ' => 'ằ'
	992:  {0x1EB2, 0x1EB3},   // 'Ẳ' => 'ẳ'
	989:  {0x1EB2, 0x1EB3},   // 'Ẳ' => 'ẳ'
	986:  {0x1EB4, 0x1EB5},   // 'Ẵ' => 'ẵ'
	983:  {0x1EB4, 0x1EB5},   // 'Ẵ' => 'ẵ'
	980:  {0x1EB6, 0x1EB7},   // 'Ặ' => 'ặ'
	977:  {0x1EB6, 0x1EB7},   // 'Ặ' => 'ặ'
	974:  {0x1EB8, 0x1EB9},   // 'Ẹ' => 'ẹ'
	971:  {0x1EB8, 0x1EB9},   // 'Ẹ' => 'ẹ'
	968:  {0x1EBA, 0x1EBB},   // 'Ẻ' => 'ẻ'
	965:  {0x1EBA, 0x1EBB},   // 'Ẻ' => 'ẻ'
	962:  {0x1EBC, 0x1EBD},   // 'Ẽ' => 'ẽ'
	959:  {0x1EBC, 0x1EBD},   // 'Ẽ' => 'ẽ'
	956:  {0x1EBE, 0x1EBF},   // 'Ế' => 'ế'
	953:  {0x1EBE, 0x1EBF},   // 'Ế' => 'ế'
	950:  {0x1EC0, 0x1EC1},   // 'Ề' => 'ề'
	947:  {0x1EC0, 0x1EC1},   // 'Ề' => 'ề'
	944:  {0x1EC2, 0x1EC3},   // 'Ể' => 'ể'
	941:  {0x1EC2, 0x1EC3},   // 'Ể' => 'ể'
	938:  {0x1EC4, 0x1EC5},   // 'Ễ' => 'ễ'
	935:  {0x1EC4, 0x1EC5},   // 'Ễ' => 'ễ'
	932:  {0x1EC6, 0x1EC7},   // 'Ệ' => 'ệ'
	929:  {0x1EC6, 0x1EC7},   // 'Ệ' => 'ệ'
	926:  {0x1EC8, 0x1EC9},   // 'Ỉ' => 'ỉ'
	923:  {0x1EC8, 0x1EC9},   // 'Ỉ' => 'ỉ'
	920:  {0x1ECA, 0x1ECB},   // 'Ị' => 'ị'
	917:  {0x1ECA, 0x1ECB},   // 'Ị' => 'ị'
	914:  {0x1ECC, 0x1ECD},   // 'Ọ' => 'ọ'
	911:  {0x1ECC, 0x1ECD},   // 'Ọ' => 'ọ'
	908:  {0x1ECE, 0x1ECF},   // 'Ỏ' => 'ỏ'
	905:  {0x1ECE, 0x1ECF},   // 'Ỏ' => 'ỏ'
	902:  {0x1ED0, 0x1ED1},   // 'Ố' => 'ố'
	899:  {0x1ED0, 0x1ED1},   // 'Ố' => 'ố'
	896:  {0x1ED2, 0x1ED3},   // 'Ồ' => 'ồ'
	893:  {0x1ED2, 0x1ED3},   // 'Ồ' => 'ồ'
	890:  {0x1ED4, 0x1ED5},   // 'Ổ' => 'ổ'
	887:  {0x1ED4, 0x1ED5},   // 'Ổ' => 'ổ'
	884:  {0x1ED6, 0x1ED7},   // 'Ỗ' => 'ỗ'
	881:  {0x1ED6, 0x1ED7},   // 'Ỗ' => 'ỗ'
	878:  {0x1ED8, 0x1ED9},   // 'Ộ' => 'ộ'
	875:  {0x1ED8, 0x1ED9},   // 'Ộ' => 'ộ'
	872:  {0x1EDA, 0x1EDB},   // 'Ớ' => 'ớ'
	869:  {0x1EDA, 0x1EDB},   // 'Ớ' => 'ớ'
	866:  {0x1EDC, 0x1EDD},   // 'Ờ' => 'ờ'
	863:  {0x1EDC, 0x1EDD},   // 'Ờ' => 'ờ'
	860:  {0x1EDE, 0x1EDF},   // 'Ở' => 'ở'
	857:  {0x1EDE, 0x1EDF},   // 'Ở' => 'ở'
	854:  {0x1EE0, 0x1EE1},   // 'Ỡ' => 'ỡ'
	851:  {0x1EE0, 0x1EE1},   // 'Ỡ' => 'ỡ'
	848:  {0x1EE2, 0x1EE3},   // 'Ợ' => 'ợ'
	845:  {0x1EE2, 0x1EE3},   // 'Ợ' => 'ợ'
	842:  {0x1EE4, 0x1EE5},   // 'Ụ' => 'ụ'
	839:  {0x1EE4, 0x1EE5},   // 'Ụ' => 'ụ'
	836:  {0x1EE6, 0x1EE7},   // 'Ủ' => 'ủ'
	833:  {0x1EE6, 0x1EE7},   // 'Ủ' => 'ủ'
	830:  {0x1EE8, 0x1EE9},   // 'Ứ' => 'ứ'
	827:  {0x1EE8, 0x1EE9},   // 'Ứ' => 'ứ'
	824:  {0x1EEA, 0x1EEB},   // 'Ừ' => 'ừ'
	821:  {0x1EEA, 0x1EEB},   // 'Ừ' => 'ừ'
	818:  {0x1EEC, 0x1EED},   // 'Ử' => 'ử'
	815:  {0x1EEC, 0x1EED},   // 'Ử' => 'ử'
	812:  {0x1EEE, 0x1EEF},   // 'Ữ' => 'ữ'
	809:  {0x1EEE, 0x1EEF},   // 'Ữ' => 'ữ'
	806:  {0x1EF0, 0x1EF1},   // 'Ự' => 'ự'
	803:  {0x1EF0, 0x1EF1},   // 'Ự' => 'ự'
	800:  {0x1EF2, 0x1EF3},   // 'Ỳ' => 'ỳ'
	797:  {0x1EF2, 0x1EF3},   // 'Ỳ' => 'ỳ'
	794:  {0x1EF4, 0x1EF5},   // 'Ỵ' => 'ỵ'
	791:  {0x1EF4, 0x1EF5},   // 'Ỵ' => 'ỵ'
	788:  {0x1EF6, 0x1EF7},   // 'Ỷ' => 'ỷ'
	785:  {0x1EF6, 0x1EF7},   // 'Ỷ' => 'ỷ'
	782:  {0x1EF8, 0x1EF9},   // 'Ỹ' => 'ỹ'
	779:  {0x1EF8, 0x1EF9},   // 'Ỹ' => 'ỹ'
	776:  {0x1EFA, 0x1EFB},   // 'Ỻ' => 'ỻ'
	773:  {0x1EFA, 0x1EFB},   // 'Ỻ' => 'ỻ'
	770:  {0x1EFC, 0x1EFD},   // 'Ỽ' => 'ỽ'
	767:  {0x1EFC, 0x1EFD},   // 'Ỽ' => 'ỽ'
	764:  {0x1EFE, 0x1EFF},   // 'Ỿ' => 'ỿ'
	761:  {0x1EFE, 0x1EFF},   // 'Ỿ' => 'ỿ'
	758:  {0x1F08, 0x1F00},   // 'Ἀ' => 'ἀ'
	755:  {0x1F09, 0x1F01},   // 'Ἁ' => 'ἁ'
	752:  {0x1F0A, 0x1F02},   // 'Ἂ' => 'ἂ'
	749:  {0x1F0B, 0x1F03},   // 'Ἃ' => 'ἃ'
	746:  {0x1F0C, 0x1F04},   // 'Ἄ' => 'ἄ'
	743:  {0x1F0D, 0x1F05},   // 'Ἅ' => 'ἅ'
	740:  {0x1F0E, 0x1F06},   // 'Ἆ' => 'ἆ'
	737:  {0x1F0F, 0x1F07},   // 'Ἇ' => 'ἇ'
	734:  {0x1F08, 0x1F00},   // 'Ἀ' => 'ἀ'
	731:  {0x1F09, 0x1F01},   // 'Ἁ' => 'ἁ'
	728:  {0x1F0A, 0x1F02},   // 'Ἂ' => 'ἂ'
	725:  {0x1F0B, 0x1F03},   // 'Ἃ' => 'ἃ'
	722:  {0x1F0C, 0x1F04},   // 'Ἄ' => 'ἄ'
	719:  {0x1F0D, 0x1F05},   // 'Ἅ' => 'ἅ'
	716:  {0x1F0E, 0x1F06},   // 'Ἆ' => 'ἆ'
	713:  {0x1F0F, 0x1F07},   // 'Ἇ' => 'ἇ'
	710:  {0x1F18, 0x1F10},   // 'Ἐ' => 'ἐ'
	707:  {0x1F19, 0x1F11},   // 'Ἑ' => 'ἑ'
	704:  {0x1F1A, 0x1F12},   // 'Ἒ' => 'ἒ'
	701:  {0x1F1B, 0x1F13},   // 'Ἓ' => 'ἓ'
	698:  {0x1F1C, 0x1F14},   // 'Ἔ' => 'ἔ'
	695:  {0x1F1D, 0x1F15},   // 'Ἕ' => 'ἕ'
	686:  {0x1F18, 0x1F10},   // 'Ἐ' => 'ἐ'
	683:  {0x1F19, 0x1F11},   // 'Ἑ' => 'ἑ'
	680:  {0x1F1A, 0x1F12},   // 'Ἒ' => 'ἒ'
	677:  {0x1F1B, 0x1F13},   // 'Ἓ' => 'ἓ'
	674:  {0x1F1C, 0x1F14},   // 'Ἔ' => 'ἔ'
	671:  {0x1F1D, 0x1F15},   // 'Ἕ' => 'ἕ'
	662:  {0x1F28, 0x1F20},   // 'Ἠ' => 'ἠ'
	659:  {0x1F29, 0x1F21},   // 'Ἡ' => 'ἡ'
	656:  {0x1F2A, 0x1F22},   // 'Ἢ' => 'ἢ'
	653:  {0x1F2B, 0x1F23},   // 'Ἣ' => 'ἣ'
	650:  {0x1F2C, 0x1F24},   // 'Ἤ' => 'ἤ'
	647:  {0x1F2D, 0x1F25},   // 'Ἥ' => 'ἥ'
	644:  {0x1F2E, 0x1F26},   // 'Ἦ' => 'ἦ'
	641:  {0x1F2F, 0x1F27},   // 'Ἧ' => 'ἧ'
	638:  {0x1F28, 0x1F20},   // 'Ἠ' => 'ἠ'
	635:  {0x1F29, 0x1F21},   // 'Ἡ' => 'ἡ'
	632:  {0x1F2A, 0x1F22},   // 'Ἢ' => 'ἢ'
	629:  {0x1F2B, 0x1F23},   // 'Ἣ' => 'ἣ'
	626:  {0x1F2C, 0x1F24},   // 'Ἤ' => 'ἤ'
	623:  {0x1F2D, 0x1F25},   // 'Ἥ' => 'ἥ'
	620:  {0x1F2E, 0x1F26},   // 'Ἦ' => 'ἦ'
	617:  {0x1F2F, 0x1F27},   // 'Ἧ' => 'ἧ'
	614:  {0x1F38, 0x1F30},   // 'Ἰ' => 'ἰ'
	611:  {0x1F39, 0x1F31},   // 'Ἱ' => 'ἱ'
	608:  {0x1F3A, 0x1F32},   // 'Ἲ' => 'ἲ'
	605:  {0x1F3B, 0x1F33},   // 'Ἳ' => 'ἳ'
	602:  {0x1F3C, 0x1F34},   // 'Ἴ' => 'ἴ'
	599:  {0x1F3D, 0x1F35},   // 'Ἵ' => 'ἵ'
	596:  {0x1F3E, 0x1F36},   // 'Ἶ' => 'ἶ'
	593:  {0x1F3F, 0x1F37},   // 'Ἷ' => 'ἷ'
	590:  {0x1F38, 0x1F30},   // 'Ἰ' => 'ἰ'
	587:  {0x1F39, 0x1F31},   // 'Ἱ' => 'ἱ'
	584:  {0x1F3A, 0x1F32},   // 'Ἲ' => 'ἲ'
	581:  {0x1F3B, 0x1F33},   // 'Ἳ' => 'ἳ'
	578:  {0x1F3C, 0x1F34},   // 'Ἴ' => 'ἴ'
	575:  {0x1F3D, 0x1F35},   // 'Ἵ' => 'ἵ'
	572:  {0x1F3E, 0x1F36},   // 'Ἶ' => 'ἶ'
	569:  {0x1F3F, 0x1F37},   // 'Ἷ' => 'ἷ'
	566:  {0x1F48, 0x1F40},   // 'Ὀ' => 'ὀ'
	563:  {0x1F49, 0x1F41},   // 'Ὁ' => 'ὁ'
	560:  {0x1F4A, 0x1F42},   // 'Ὂ' => 'ὂ'
	557:  {0x1F4B, 0x1F43},   // 'Ὃ' => 'ὃ'
	554:  {0x1F4C, 0x1F44},   // 'Ὄ' => 'ὄ'
	551:  {0x1F4D, 0x1F45},   // 'Ὅ' => 'ὅ'
	542:  {0x1F48, 0x1F40},   // 'Ὀ' => 'ὀ'
	539:  {0x1F49, 0x1F41},   // 'Ὁ' => 'ὁ'
	536:  {0x1F4A, 0x1F42},   // 'Ὂ' => 'ὂ'
	533:  {0x1F4B, 0x1F43},   // 'Ὃ' => 'ὃ'
	530:  {0x1F4C, 0x1F44},   // 'Ὄ' => 'ὄ'
	527:  {0x1F4D, 0x1F45},   // 'Ὅ' => 'ὅ'
	515:  {0x1F59, 0x1F51},   // 'Ὑ' => 'ὑ'
	509:  {0x1F5B, 0x1F53},   // 'Ὓ' => 'ὓ'
	503:  {0x1F5D, 0x1F55},   // 'Ὕ' => 'ὕ'
	497:  {0x1F5F, 0x1F57},   // 'Ὗ' => 'ὗ'
	491:  {0x1F59, 0x1F51},   // 'Ὑ' => 'ὑ'
	485:  {0x1F5B, 0x1F53},   // 'Ὓ' => 'ὓ'
	479:  {0x1F5D, 0x1F55},   // 'Ὕ' => 'ὕ'
	473:  {0x1F5F, 0x1F57},   // 'Ὗ' => 'ὗ'
	470:  {0x1F68, 0x1F60},   // 'Ὠ' => 'ὠ'
	467:  {0x1F69, 0x1F61},   // 'Ὡ' => 'ὡ'
	464:  {0x1F6A, 0x1F62},   // 'Ὢ' => 'ὢ'
	461:  {0x1F6B, 0x1F63},   // 'Ὣ' => 'ὣ'
	458:  {0x1F6C, 0x1F64},   // 'Ὤ' => 'ὤ'
	455:  {0x1F6D, 0x1F65},   // 'Ὥ' => 'ὥ'
	452:  {0x1F6E, 0x1F66},   // 'Ὦ' => 'ὦ'
	449:  {0x1F6F, 0x1F67},   // 'Ὧ' => 'ὧ'
	446:  {0x1F68, 0x1F60},   // 'Ὠ' => 'ὠ'
	443:  {0x1F69, 0x1F61},   // 'Ὡ' => 'ὡ'
	440:  {0x1F6A, 0x1F62},   // 'Ὢ' => 'ὢ'
	437:  {0x1F6B, 0x1F63},   // 'Ὣ' => 'ὣ'
	434:  {0x1F6C, 0x1F64},   // 'Ὤ' => 'ὤ'
	431:  {0x1F6D, 0x1F65},   // 'Ὥ' => 'ὥ'
	428:  {0x1F6E, 0x1F66},   // 'Ὦ' => 'ὦ'
	425:  {0x1F6F, 0x1F67},   // 'Ὧ' => 'ὧ'
	422:  {0x1FBA, 0x1F70},   // 'Ὰ' => 'ὰ'
	419:  {0x1FBB, 0x1F71},   // 'Ά' => 'ά'
	416:  {0x1FC8, 0x1F72},   // 'Ὲ' => 'ὲ'
	413:  {0x1FC9, 0x1F73},   // 'Έ' => 'έ'
	410:  {0x1FCA, 0x1F74},   // 'Ὴ' => 'ὴ'
	407:  {0x1FCB, 0x1F75},   // 'Ή' => 'ή'
	404:  {0x1FDA, 0x1F76},   // 'Ὶ' => 'ὶ'
	401:  {0x1FDB, 0x1F77},   // 'Ί' => 'ί'
	398:  {0x1FF8, 0x1F78},   // 'Ὸ' => 'ὸ'
	395:  {0x1FF9, 0x1F79},   // 'Ό' => 'ό'
	392:  {0x1FEA, 0x1F7A},   // 'Ὺ' => 'ὺ'
	389:  {0x1FEB, 0x1F7B},   // 'Ύ' => 'ύ'
	386:  {0x1FFA, 0x1F7C},   // 'Ὼ' => 'ὼ'
	383:  {0x1FFB, 0x1F7D},   // 'Ώ' => 'ώ'
	374:  {0x1F88, 0x1F80},   // 'ᾈ' => 'ᾀ'
	371:  {0x1F89, 0x1F81},   // 'ᾉ' => 'ᾁ'
	368:  {0x1F8A, 0x1F82},   // 'ᾊ' => 'ᾂ'
	365:  {0x1F8B, 0x1F83},   // 'ᾋ' => 'ᾃ'
	362:  {0x1F8C, 0x1F84},   // 'ᾌ' => 'ᾄ'
	359:  {0x1F8D, 0x1F85},   // 'ᾍ' => 'ᾅ'
	356:  {0x1F8E, 0x1F86},   // 'ᾎ' => 'ᾆ'
	353:  {0x1F8F, 0x1F87},   // 'ᾏ' => 'ᾇ'
	350:  {0x1F88, 0x1F80},   // 'ᾈ' => 'ᾀ'
	347:  {0x1F89, 0x1F81},   // 'ᾉ' => 'ᾁ'
	344:  {0x1F8A, 0x1F82},   // 'ᾊ' => 'ᾂ'
	341:  {0x1F8B, 0x1F83},   // 'ᾋ' => 'ᾃ'
	338:  {0x1F8C, 0x1F84},   // 'ᾌ' => 'ᾄ'
	335:  {0x1F8D, 0x1F85},   // 'ᾍ' => 'ᾅ'
	332:  {0x1F8E, 0x1F86},   // 'ᾎ' => 'ᾆ'
	329:  {0x1F8F, 0x1F87},   // 'ᾏ' => 'ᾇ'
	326:  {0x1F98, 0x1F90},   // 'ᾘ' => 'ᾐ'
	323:  {0x1F99, 0x1F91},   // 'ᾙ' => 'ᾑ'
	320:  {0x1F9A, 0x1F92},   // 'ᾚ' => 'ᾒ'
	317:  {0x1F9B, 0x1F93},   // 'ᾛ' => 'ᾓ'
	314:  {0x1F9C, 0x1F94},   // 'ᾜ' => 'ᾔ'
	311:  {0x1F9D, 0x1F95},   // 'ᾝ' => 'ᾕ'
	308:  {0x1F9E, 0x1F96},   // 'ᾞ' => 'ᾖ'
	305:  {0x1F9F, 0x1F97},   // 'ᾟ' => 'ᾗ'
	302:  {0x1F98, 0x1F90},   // 'ᾘ' => 'ᾐ'
	299:  {0x1F99, 0x1F91},   // 'ᾙ' => 'ᾑ'
	296:  {0x1F9A, 0x1F92},   // 'ᾚ' => 'ᾒ'
	293:  {0x1F9B, 0x1F93},   // 'ᾛ' => 'ᾓ'
	290:  {0x1F9C, 0x1F94},   // 'ᾜ' => 'ᾔ'
	287:  {0x1F9D, 0x1F95},   // 'ᾝ' => 'ᾕ'
	284:  {0x1F9E, 0x1F96},   // 'ᾞ' => 'ᾖ'
	281:  {0x1F9F, 0x1F97},   // 'ᾟ' => 'ᾗ'
	278:  {0x1FA8, 0x1FA0},   // 'ᾨ' => 'ᾠ'
	275:  {0x1FA9, 0x1FA1},   // 'ᾩ' => 'ᾡ'
	272:  {0x1FAA, 0x1FA2},   // 'ᾪ' => 'ᾢ'
	269:  {0x1FAB, 0x1FA3},   // 'ᾫ' => 'ᾣ'
	266:  {0x1FAC, 0x1FA4},   // 'ᾬ' => 'ᾤ'
	263:  {0x1FAD, 0x1FA5},   // 'ᾭ' => 'ᾥ'
	260:  {0x1FAE, 0x1FA6},   // 'ᾮ' => 'ᾦ'
	257:  {0x1FAF, 0x1FA7},   // 'ᾯ' => 'ᾧ'
	254:  {0x1FA8, 0x1FA0},   // 'ᾨ' => 'ᾠ'
	251:  {0x1FA9, 0x1FA1},   // 'ᾩ' => 'ᾡ'
	248:  {0x1FAA, 0x1FA2},   // 'ᾪ' => 'ᾢ'
	245:  {0x1FAB, 0x1FA3},   // 'ᾫ' => 'ᾣ'
	242:  {0x1FAC, 0x1FA4},   // 'ᾬ' => 'ᾤ'
	239:  {0x1FAD, 0x1FA5},   // 'ᾭ' => 'ᾥ'
	236:  {0x1FAE, 0x1FA6},   // 'ᾮ' => 'ᾦ'
	233:  {0x1FAF, 0x1FA7},   // 'ᾯ' => 'ᾧ'
	230:  {0x1FB8, 0x1FB0},   // 'Ᾰ' => 'ᾰ'
	227:  {0x1FB9, 0x1FB1},   // 'Ᾱ' => 'ᾱ'
	221:  {0x1FBC, 0x1FB3},   // 'ᾼ' => 'ᾳ'
	206:  {0x1FB8, 0x1FB0},   // 'Ᾰ' => 'ᾰ'
	203:  {0x1FB9, 0x1FB1},   // 'Ᾱ' => 'ᾱ'
	200:  {0x1FBA, 0x1F70},   // 'Ὰ' => 'ὰ'
	197:  {0x1FBB, 0x1F71},   // 'Ά' => 'ά'
	194:  {0x1FBC, 0x1FB3},   // 'ᾼ' => 'ᾳ'
	188:  {0x0399, 0x1FBE},   // 'Ι' => 'ι'
	173:  {0x1FCC, 0x1FC3},   // 'ῌ' => 'ῃ'
	158:  {0x1FC8, 0x1F72},   // 'Ὲ' => 'ὲ'
	155:  {0x1FC9, 0x1F73},   // 'Έ' => 'έ'
	152:  {0x1FCA, 0x1F74},   // 'Ὴ' => 'ὴ'
	149:  {0x1FCB, 0x1F75},   // 'Ή' => 'ή'
	146:  {0x1FCC, 0x1FC3},   // 'ῌ' => 'ῃ'
	134:  {0x1FD8, 0x1FD0},   // 'Ῐ' => 'ῐ'
	131:  {0x1FD9, 0x1FD1},   // 'Ῑ' => 'ῑ'
	110:  {0x1FD8, 0x1FD0},   // 'Ῐ' => 'ῐ'
	107:  {0x1FD9, 0x1FD1},   // 'Ῑ' => 'ῑ'
	104:  {0x1FDA, 0x1F76},   // 'Ὶ' => 'ὶ'
	101:  {0x1FDB, 0x1F77},   // 'Ί' => 'ί'
	86:   {0x1FE8, 0x1FE0},   // 'Ῠ' => 'ῠ'
	83:   {0x1FE9, 0x1FE1},   // 'Ῡ' => 'ῡ'
	71:   {0x1FEC, 0x1FE5},   // 'Ῥ' => 'ῥ'
	62:   {0x1FE8, 0x1FE0},   // 'Ῠ' => 'ῠ'
	59:   {0x1FE9, 0x1FE1},   // 'Ῡ' => 'ῡ'
	56:   {0x1FEA, 0x1F7A},   // 'Ὺ' => 'ὺ'
	53:   {0x1FEB, 0x1F7B},   // 'Ύ' => 'ύ'
	50:   {0x1FEC, 0x1FE5},   // 'Ῥ' => 'ῥ'
	29:   {0x1FFC, 0x1FF3},   // 'ῼ' => 'ῳ'
	14:   {0x1FF8, 0x1F78},   // 'Ὸ' => 'ὸ'
	11:   {0x1FF9, 0x1F79},   // 'Ό' => 'ό'
	8:    {0x1FFA, 0x1F7C},   // 'Ὼ' => 'ὼ'
	5:    {0x1FFB, 0x1F7D},   // 'Ώ' => 'ώ'
	2:    {0x1FFC, 0x1FF3},   // 'ῼ' => 'ῳ'
	7299: {0x2126, 0x03C9},   // 'Ω' => 'ω'
	7287: {0x212A, 0x006B},   // 'K' => 'k'
	7284: {0x212B, 0x00E5},   // 'Å' => 'å'
	7263: {0x2132, 0x214E},   // 'Ⅎ' => 'ⅎ'
	7179: {0x2132, 0x214E},   // 'Ⅎ' => 'ⅎ'
	7125: {0x2160, 0x2170},   // 'Ⅰ' => 'ⅰ'
	7122: {0x2161, 0x2171},   // 'Ⅱ' => 'ⅱ'
	7119: {0x2162, 0x2172},   // 'Ⅲ' => 'ⅲ'
	7116: {0x2163, 0x2173},   // 'Ⅳ' => 'ⅳ'
	7113: {0x2164, 0x2174},   // 'Ⅴ' => 'ⅴ'
	7110: {0x2165, 0x2175},   // 'Ⅵ' => 'ⅵ'
	7107: {0x2166, 0x2176},   // 'Ⅶ' => 'ⅶ'
	7104: {0x2167, 0x2177},   // 'Ⅷ' => 'ⅷ'
	7101: {0x2168, 0x2178},   // 'Ⅸ' => 'ⅸ'
	7098: {0x2169, 0x2179},   // 'Ⅹ' => 'ⅹ'
	7095: {0x216A, 0x217A},   // 'Ⅺ' => 'ⅺ'
	7092: {0x216B, 0x217B},   // 'Ⅻ' => 'ⅻ'
	7089: {0x216C, 0x217C},   // 'Ⅼ' => 'ⅼ'
	7086: {0x216D, 0x217D},   // 'Ⅽ' => 'ⅽ'
	7083: {0x216E, 0x217E},   // 'Ⅾ' => 'ⅾ'
	7080: {0x216F, 0x217F},   // 'Ⅿ' => 'ⅿ'
	7077: {0x2160, 0x2170},   // 'Ⅰ' => 'ⅰ'
	7074: {0x2161, 0x2171},   // 'Ⅱ' => 'ⅱ'
	7071: {0x2162, 0x2172},   // 'Ⅲ' => 'ⅲ'
	7068: {0x2163, 0x2173},   // 'Ⅳ' => 'ⅳ'
	7065: {0x2164, 0x2174},   // 'Ⅴ' => 'ⅴ'
	7062: {0x2165, 0x2175},   // 'Ⅵ' => 'ⅵ'
	7059: {0x2166, 0x2176},   // 'Ⅶ' => 'ⅶ'
	7056: {0x2167, 0x2177},   // 'Ⅷ' => 'ⅷ'
	7053: {0x2168, 0x2178},   // 'Ⅸ' => 'ⅸ'
	7050: {0x2169, 0x2179},   // 'Ⅹ' => 'ⅹ'
	7047: {0x216A, 0x217A},   // 'Ⅺ' => 'ⅺ'
	7044: {0x216B, 0x217B},   // 'Ⅻ' => 'ⅻ'
	7041: {0x216C, 0x217C},   // 'Ⅼ' => 'ⅼ'
	7038: {0x216D, 0x217D},   // 'Ⅽ' => 'ⅽ'
	7035: {0x216E, 0x217E},   // 'Ⅾ' => 'ⅾ'
	7032: {0x216F, 0x217F},   // 'Ⅿ' => 'ⅿ'
	7020: {0x2183, 0x2184},   // 'Ↄ' => 'ↄ'
	7017: {0x2183, 0x2184},   // 'Ↄ' => 'ↄ'
	4562: {0x24B6, 0x24D0},   // 'Ⓐ' => 'ⓐ'
	4559: {0x24B7, 0x24D1},   // 'Ⓑ' => 'ⓑ'
	4556: {0x24B8, 0x24D2},   // 'Ⓒ' => 'ⓒ'
	4553: {0x24B9, 0x24D3},   // 'Ⓓ' => 'ⓓ'
	4550: {0x24BA, 0x24D4},   // 'Ⓔ' => 'ⓔ'
	4547: {0x24BB, 0x24D5},   // 'Ⓕ' => 'ⓕ'
	4544: {0x24BC, 0x24D6},   // 'Ⓖ' => 'ⓖ'
	4541: {0x24BD, 0x24D7},   // 'Ⓗ' => 'ⓗ'
	4538: {0x24BE, 0x24D8},   // 'Ⓘ' => 'ⓘ'
	4535: {0x24BF, 0x24D9},   // 'Ⓙ' => 'ⓙ'
	4532: {0x24C0, 0x24DA},   // 'Ⓚ' => 'ⓚ'
	4529: {0x24C1, 0x24DB},   // 'Ⓛ' => 'ⓛ'
	4526: {0x24C2, 0x24DC},   // 'Ⓜ' => 'ⓜ'
	4523: {0x24C3, 0x24DD},   // 'Ⓝ' => 'ⓝ'
	4520: {0x24C4, 0x24DE},   // 'Ⓞ' => 'ⓞ'
	4517: {0x24C5, 0x24DF},   // 'Ⓟ' => 'ⓟ'
	4514: {0x24C6, 0x24E0},   // 'Ⓠ' => 'ⓠ'
	4511: {0x24C7, 0x24E1},   // 'Ⓡ' => 'ⓡ'
	4508: {0x24C8, 0x24E2},   // 'Ⓢ' => 'ⓢ'
	4505: {0x24C9, 0x24E3},   // 'Ⓣ' => 'ⓣ'
	4502: {0x24CA, 0x24E4},   // 'Ⓤ' => 'ⓤ'
	4499: {0x24CB, 0x24E5},   // 'Ⓥ' => 'ⓥ'
	4496: {0x24CC, 0x24E6},   // 'Ⓦ' => 'ⓦ'
	4493: {0x24CD, 0x24E7},   // 'Ⓧ' => 'ⓧ'
	4490: {0x24CE, 0x24E8},   // 'Ⓨ' => 'ⓨ'
	4487: {0x24CF, 0x24E9},   // 'Ⓩ' => 'ⓩ'
	4484: {0x24B6, 0x24D0},   // 'Ⓐ' => 'ⓐ'
	4481: {0x24B7, 0x24D1},   // 'Ⓑ' => 'ⓑ'
	4478: {0x24B8, 0x24D2},   // 'Ⓒ' => 'ⓒ'
	4475: {0x24B9, 0x24D3},   // 'Ⓓ' => 'ⓓ'
	4472: {0x24BA, 0x24D4},   // 'Ⓔ' => 'ⓔ'
	4469: {0x24BB, 0x24D5},   // 'Ⓕ' => 'ⓕ'
	4466: {0x24BC, 0x24D6},   // 'Ⓖ' => 'ⓖ'
	4463: {0x24BD, 0x24D7},   // 'Ⓗ' => 'ⓗ'
	4460: {0x24BE, 0x24D8},   // 'Ⓘ' => 'ⓘ'
	4457: {0x24BF, 0x24D9},   // 'Ⓙ' => 'ⓙ'
	4454: {0x24C0, 0x24DA},   // 'Ⓚ' => 'ⓚ'
	4451: {0x24C1, 0x24DB},   // 'Ⓛ' => 'ⓛ'
	4448: {0x24C2, 0x24DC},   // 'Ⓜ' => 'ⓜ'
	4445: {0x24C3, 0x24DD},   // 'Ⓝ' => 'ⓝ'
	4442: {0x24C4, 0x24DE},   // 'Ⓞ' => 'ⓞ'
	4439: {0x24C5, 0x24DF},   // 'Ⓟ' => 'ⓟ'
	4436: {0x24C6, 0x24E0},   // 'Ⓠ' => 'ⓠ'
	4433: {0x24C7, 0x24E1},   // 'Ⓡ' => 'ⓡ'
	4430: {0x24C8, 0x24E2},   // 'Ⓢ' => 'ⓢ'
	4427: {0x24C9, 0x24E3},   // 'Ⓣ' => 'ⓣ'
	4424: {0x24CA, 0x24E4},   // 'Ⓤ' => 'ⓤ'
	4421: {0x24CB, 0x24E5},   // 'Ⓥ' => 'ⓥ'
	4418: {0x24CC, 0x24E6},   // 'Ⓦ' => 'ⓦ'
	4415: {0x24CD, 0x24E7},   // 'Ⓧ' => 'ⓧ'
	4412: {0x24CE, 0x24E8},   // 'Ⓨ' => 'ⓨ'
	4409: {0x24CF, 0x24E9},   // 'Ⓩ' => 'ⓩ'
	7154: {0x2C00, 0x2C30},   // 'Ⰰ' => 'ⰰ'
	7151: {0x2C01, 0x2C31},   // 'Ⰱ' => 'ⰱ'
	7148: {0x2C02, 0x2C32},   // 'Ⰲ' => 'ⰲ'
	7145: {0x2C03, 0x2C33},   // 'Ⰳ' => 'ⰳ'
	7142: {0x2C04, 0x2C34},   // 'Ⰴ' => 'ⰴ'
	7139: {0x2C05, 0x2C35},   // 'Ⰵ' => 'ⰵ'
	7136: {0x2C06, 0x2C36},   // 'Ⰶ' => 'ⰶ'
	7133: {0x2C07, 0x2C37},   // 'Ⰷ' => 'ⰷ'
	7130: {0x2C08, 0x2C38},   // 'Ⰸ' => 'ⰸ'
	7127: {0x2C09, 0x2C39},   // 'Ⰹ' => 'ⰹ'
	7124: {0x2C0A, 0x2C3A},   // 'Ⰺ' => 'ⰺ'
	7121: {0x2C0B, 0x2C3B},   // 'Ⰻ' => 'ⰻ'
	7118: {0x2C0C, 0x2C3C},   // 'Ⰼ' => 'ⰼ'
	7115: {0x2C0D, 0x2C3D},   // 'Ⰽ' => 'ⰽ'
	7112: {0x2C0E, 0x2C3E},   // 'Ⰾ' => 'ⰾ'
	7109: {0x2C0F, 0x2C3F},   // 'Ⰿ' => 'ⰿ'
	7106: {0x2C10, 0x2C40},   // 'Ⱀ' => 'ⱀ'
	7103: {0x2C11, 0x2C41},   // 'Ⱁ' => 'ⱁ'
	7100: {0x2C12, 0x2C42},   // 'Ⱂ' => 'ⱂ'
	7097: {0x2C13, 0x2C43},   // 'Ⱃ' => 'ⱃ'
	7094: {0x2C14, 0x2C44},   // 'Ⱄ' => 'ⱄ'
	7091: {0x2C15, 0x2C45},   // 'Ⱅ' => 'ⱅ'
	7088: {0x2C16, 0x2C46},   // 'Ⱆ' => 'ⱆ'
	7085: {0x2C17, 0x2C47},   // 'Ⱇ' => 'ⱇ'
	7082: {0x2C18, 0x2C48},   // 'Ⱈ' => 'ⱈ'
	7079: {0x2C19, 0x2C49},   // 'Ⱉ' => 'ⱉ'
	7076: {0x2C1A, 0x2C4A},   // 'Ⱊ' => 'ⱊ'
	7073: {0x2C1B, 0x2C4B},   // 'Ⱋ' => 'ⱋ'
	7070: {0x2C1C, 0x2C4C},   // 'Ⱌ' => 'ⱌ'
	7067: {0x2C1D, 0x2C4D},   // 'Ⱍ' => 'ⱍ'
	7064: {0x2C1E, 0x2C4E},   // 'Ⱎ' => 'ⱎ'
	7061: {0x2C1F, 0x2C4F},   // 'Ⱏ' => 'ⱏ'
	7058: {0x2C20, 0x2C50},   // 'Ⱐ' => 'ⱐ'
	7055: {0x2C21, 0x2C51},   // 'Ⱑ' => 'ⱑ'
	7052: {0x2C22, 0x2C52},   // 'Ⱒ' => 'ⱒ'
	7049: {0x2C23, 0x2C53},   // 'Ⱓ' => 'ⱓ'
	7046: {0x2C24, 0x2C54},   // 'Ⱔ' => 'ⱔ'
	7043: {0x2C25, 0x2C55},   // 'Ⱕ' => 'ⱕ'
	7040: {0x2C26, 0x2C56},   // 'Ⱖ' => 'ⱖ'
	7037: {0x2C27, 0x2C57},   // 'Ⱗ' => 'ⱗ'
	7034: {0x2C28, 0x2C58},   // 'Ⱘ' => 'ⱘ'
	7031: {0x2C29, 0x2C59},   // 'Ⱙ' => 'ⱙ'
	7028: {0x2C2A, 0x2C5A},   // 'Ⱚ' => 'ⱚ'
	7025: {0x2C2B, 0x2C5B},   // 'Ⱛ' => 'ⱛ'
	7022: {0x2C2C, 0x2C5C},   // 'Ⱜ' => 'ⱜ'
	7019: {0x2C2D, 0x2C5D},   // 'Ⱝ' => 'ⱝ'
	7016: {0x2C2E, 0x2C5E},   // 'Ⱞ' => 'ⱞ'
	7010: {0x2C00, 0x2C30},   // 'Ⰰ' => 'ⰰ'
	7007: {0x2C01, 0x2C31},   // 'Ⰱ' => 'ⰱ'
	7004: {0x2C02, 0x2C32},   // 'Ⰲ' => 'ⰲ'
	7001: {0x2C03, 0x2C33},   // 'Ⰳ' => 'ⰳ'
	6998: {0x2C04, 0x2C34},   // 'Ⰴ' => 'ⰴ'
	6995: {0x2C05, 0x2C35},   // 'Ⰵ' => 'ⰵ'
	6992: {0x2C06, 0x2C36},   // 'Ⰶ' => 'ⰶ'
	6989: {0x2C07, 0x2C37},   // 'Ⰷ' => 'ⰷ'
	6986: {0x2C08, 0x2C38},   // 'Ⰸ' => 'ⰸ'
	6983: {0x2C09, 0x2C39},   // 'Ⰹ' => 'ⰹ'
	6980: {0x2C0A, 0x2C3A},   // 'Ⰺ' => 'ⰺ'
	6977: {0x2C0B, 0x2C3B},   // 'Ⰻ' => 'ⰻ'
	6974: {0x2C0C, 0x2C3C},   // 'Ⰼ' => 'ⰼ'
	6971: {0x2C0D, 0x2C3D},   // 'Ⰽ' => 'ⰽ'
	6968: {0x2C0E, 0x2C3E},   // 'Ⰾ' => 'ⰾ'
	6965: {0x2C0F, 0x2C3F},   // 'Ⰿ' => 'ⰿ'
	6962: {0x2C10, 0x2C40},   // 'Ⱀ' => 'ⱀ'
	6959: {0x2C11, 0x2C41},   // 'Ⱁ' => 'ⱁ'
	6956: {0x2C12, 0x2C42},   // 'Ⱂ' => 'ⱂ'
	6953: {0x2C13, 0x2C43},   // 'Ⱃ' => 'ⱃ'
	6950: {0x2C14, 0x2C44},   // 'Ⱄ' => 'ⱄ'
	6947: {0x2C15, 0x2C45},   // 'Ⱅ' => 'ⱅ'
	6944: {0x2C16, 0x2C46},   // 'Ⱆ' => 'ⱆ'
	6941: {0x2C17, 0x2C47},   // 'Ⱇ' => 'ⱇ'
	6938: {0x2C18, 0x2C48},   // 'Ⱈ' => 'ⱈ'
	6935: {0x2C19, 0x2C49},   // 'Ⱉ' => 'ⱉ'
	6932: {0x2C1A, 0x2C4A},   // 'Ⱊ' => 'ⱊ'
	6929: {0x2C1B, 0x2C4B},   // 'Ⱋ' => 'ⱋ'
	6926: {0x2C1C, 0x2C4C},   // 'Ⱌ' => 'ⱌ'
	6923: {0x2C1D, 0x2C4D},   // 'Ⱍ' => 'ⱍ'
	6920: {0x2C1E, 0x2C4E},   // 'Ⱎ' => 'ⱎ'
	6917: {0x2C1F, 0x2C4F},   // 'Ⱏ' => 'ⱏ'
	6914: {0x2C20, 0x2C50},   // 'Ⱐ' => 'ⱐ'
	6911: {0x2C21, 0x2C51},   // 'Ⱑ' => 'ⱑ'
	6908: {0x2C22, 0x2C52},   // 'Ⱒ' => 'ⱒ'
	6905: {0x2C23, 0x2C53},   // 'Ⱓ' => 'ⱓ'
	6902: {0x2C24, 0x2C54},   // 'Ⱔ' => 'ⱔ'
	6899: {0x2C25, 0x2C55},   // 'Ⱕ' => 'ⱕ'
	6896: {0x2C26, 0x2C56},   // 'Ⱖ' => 'ⱖ'
	6893: {0x2C27, 0x2C57},   // 'Ⱗ' => 'ⱗ'
	6890: {0x2C28, 0x2C58},   // 'Ⱘ' => 'ⱘ'
	6887: {0x2C29, 0x2C59},   // 'Ⱙ' => 'ⱙ'
	6884: {0x2C2A, 0x2C5A},   // 'Ⱚ' => 'ⱚ'
	6881: {0x2C2B, 0x2C5B},   // 'Ⱛ' => 'ⱛ'
	6878: {0x2C2C, 0x2C5C},   // 'Ⱜ' => 'ⱜ'
	6875: {0x2C2D, 0x2C5D},   // 'Ⱝ' => 'ⱝ'
	6872: {0x2C2E, 0x2C5E},   // 'Ⱞ' => 'ⱞ'
	6866: {0x2C60, 0x2C61},   // 'Ⱡ' => 'ⱡ'
	6863: {0x2C60, 0x2C61},   // 'Ⱡ' => 'ⱡ'
	6860: {0x2C62, 0x026B},   // 'Ɫ' => 'ɫ'
	6857: {0x2C63, 0x1D7D},   // 'Ᵽ' => 'ᵽ'
	6854: {0x2C64, 0x027D},   // 'Ɽ' => 'ɽ'
	6851: {0x023A, 0x2C65},   // 'Ⱥ' => 'ⱥ'
	6848: {0x023E, 0x2C66},   // 'Ⱦ' => 'ⱦ'
	6845: {0x2C67, 0x2C68},   // 'Ⱨ' => 'ⱨ'
	6842: {0x2C67, 0x2C68},   // 'Ⱨ' => 'ⱨ'
	6839: {0x2C69, 0x2C6A},   // 'Ⱪ' => 'ⱪ'
	6836: {0x2C69, 0x2C6A},   // 'Ⱪ' => 'ⱪ'
	6833: {0x2C6B, 0x2C6C},   // 'Ⱬ' => 'ⱬ'
	6830: {0x2C6B, 0x2C6C},   // 'Ⱬ' => 'ⱬ'
	6827: {0x2C6D, 0x0251},   // 'Ɑ' => 'ɑ'
	6824: {0x2C6E, 0x0271},   // 'Ɱ' => 'ɱ'
	6821: {0x2C6F, 0x0250},   // 'Ɐ' => 'ɐ'
	6818: {0x2C70, 0x0252},   // 'Ɒ' => 'ɒ'
	6812: {0x2C72, 0x2C73},   // 'Ⱳ' => 'ⱳ'
	6809: {0x2C72, 0x2C73},   // 'Ⱳ' => 'ⱳ'
	6803: {0x2C75, 0x2C76},   // 'Ⱶ' => 'ⱶ'
	6800: {0x2C75, 0x2C76},   // 'Ⱶ' => 'ⱶ'
	6776: {0x2C7E, 0x023F},   // 'Ȿ' => 'ȿ'
	6773: {0x2C7F, 0x0240},   // 'Ɀ' => 'ɀ'
	6770: {0x2C80, 0x2C81},   // 'Ⲁ' => 'ⲁ'
	6767: {0x2C80, 0x2C81},   // 'Ⲁ' => 'ⲁ'
	6764: {0x2C82, 0x2C83},   // 'Ⲃ' => 'ⲃ'
	6761: {0x2C82, 0x2C83},   // 'Ⲃ' => 'ⲃ'
	6758: {0x2C84, 0x2C85},   // 'Ⲅ' => 'ⲅ'
	6755: {0x2C84, 0x2C85},   // 'Ⲅ' => 'ⲅ'
	6752: {0x2C86, 0x2C87},   // 'Ⲇ' => 'ⲇ'
	6749: {0x2C86, 0x2C87},   // 'Ⲇ' => 'ⲇ'
	6746: {0x2C88, 0x2C89},   // 'Ⲉ' => 'ⲉ'
	6743: {0x2C88, 0x2C89},   // 'Ⲉ' => 'ⲉ'
	6740: {0x2C8A, 0x2C8B},   // 'Ⲋ' => 'ⲋ'
	6737: {0x2C8A, 0x2C8B},   // 'Ⲋ' => 'ⲋ'
	6734: {0x2C8C, 0x2C8D},   // 'Ⲍ' => 'ⲍ'
	6731: {0x2C8C, 0x2C8D},   // 'Ⲍ' => 'ⲍ'
	6728: {0x2C8E, 0x2C8F},   // 'Ⲏ' => 'ⲏ'
	6725: {0x2C8E, 0x2C8F},   // 'Ⲏ' => 'ⲏ'
	6722: {0x2C90, 0x2C91},   // 'Ⲑ' => 'ⲑ'
	6719: {0x2C90, 0x2C91},   // 'Ⲑ' => 'ⲑ'
	6716: {0x2C92, 0x2C93},   // 'Ⲓ' => 'ⲓ'
	6713: {0x2C92, 0x2C93},   // 'Ⲓ' => 'ⲓ'
	6710: {0x2C94, 0x2C95},   // 'Ⲕ' => 'ⲕ'
	6707: {0x2C94, 0x2C95},   // 'Ⲕ' => 'ⲕ'
	6704: {0x2C96, 0x2C97},   // 'Ⲗ' => 'ⲗ'
	6701: {0x2C96, 0x2C97},   // 'Ⲗ' => 'ⲗ'
	6698: {0x2C98, 0x2C99},   // 'Ⲙ' => 'ⲙ'
	6695: {0x2C98, 0x2C99},   // 'Ⲙ' => 'ⲙ'
	6692: {0x2C9A, 0x2C9B},   // 'Ⲛ' => 'ⲛ'
	6689: {0x2C9A, 0x2C9B},   // 'Ⲛ' => 'ⲛ'
	6686: {0x2C9C, 0x2C9D},   // 'Ⲝ' => 'ⲝ'
	6683: {0x2C9C, 0x2C9D},   // 'Ⲝ' => 'ⲝ'
	6680: {0x2C9E, 0x2C9F},   // 'Ⲟ' => 'ⲟ'
	6677: {0x2C9E, 0x2C9F},   // 'Ⲟ' => 'ⲟ'
	6674: {0x2CA0, 0x2CA1},   // 'Ⲡ' => 'ⲡ'
	6671: {0x2CA0, 0x2CA1},   // 'Ⲡ' => 'ⲡ'
	6668: {0x2CA2, 0x2CA3},   // 'Ⲣ' => 'ⲣ'
	6665: {0x2CA2, 0x2CA3},   // 'Ⲣ' => 'ⲣ'
	6662: {0x2CA4, 0x2CA5},   // 'Ⲥ' => 'ⲥ'
	6659: {0x2CA4, 0x2CA5},   // 'Ⲥ' => 'ⲥ'
	6656: {0x2CA6, 0x2CA7},   // 'Ⲧ' => 'ⲧ'
	6653: {0x2CA6, 0x2CA7},   // 'Ⲧ' => 'ⲧ'
	6650: {0x2CA8, 0x2CA9},   // 'Ⲩ' => 'ⲩ'
	6647: {0x2CA8, 0x2CA9},   // 'Ⲩ' => 'ⲩ'
	6644: {0x2CAA, 0x2CAB},   // 'Ⲫ' => 'ⲫ'
	6641: {0x2CAA, 0x2CAB},   // 'Ⲫ' => 'ⲫ'
	6638: {0x2CAC, 0x2CAD},   // 'Ⲭ' => 'ⲭ'
	6635: {0x2CAC, 0x2CAD},   // 'Ⲭ' => 'ⲭ'
	6632: {0x2CAE, 0x2CAF},   // 'Ⲯ' => 'ⲯ'
	6629: {0x2CAE, 0x2CAF},   // 'Ⲯ' => 'ⲯ'
	6626: {0x2CB0, 0x2CB1},   // 'Ⲱ' => 'ⲱ'
	6623: {0x2CB0, 0x2CB1},   // 'Ⲱ' => 'ⲱ'
	6620: {0x2CB2, 0x2CB3},   // 'Ⲳ' => 'ⲳ'
	6617: {0x2CB2, 0x2CB3},   // 'Ⲳ' => 'ⲳ'
	6614: {0x2CB4, 0x2CB5},   // 'Ⲵ' => 'ⲵ'
	6611: {0x2CB4, 0x2CB5},   // 'Ⲵ' => 'ⲵ'
	6608: {0x2CB6, 0x2CB7},   // 'Ⲷ' => 'ⲷ'
	6605: {0x2CB6, 0x2CB7},   // 'Ⲷ' => 'ⲷ'
	6602: {0x2CB8, 0x2CB9},   // 'Ⲹ' => 'ⲹ'
	6599: {0x2CB8, 0x2CB9},   // 'Ⲹ' => 'ⲹ'
	6596: {0x2CBA, 0x2CBB},   // 'Ⲻ' => 'ⲻ'
	6593: {0x2CBA, 0x2CBB},   // 'Ⲻ' => 'ⲻ'
	6590: {0x2CBC, 0x2CBD},   // 'Ⲽ' => 'ⲽ'
	6587: {0x2CBC, 0x2CBD},   // 'Ⲽ' => 'ⲽ'
	6584: {0x2CBE, 0x2CBF},   // 'Ⲿ' => 'ⲿ'
	6581: {0x2CBE, 0x2CBF},   // 'Ⲿ' => 'ⲿ'
	6578: {0x2CC0, 0x2CC1},   // 'Ⳁ' => 'ⳁ'
	6575: {0x2CC0, 0x2CC1},   // 'Ⳁ' => 'ⳁ'
	6572: {0x2CC2, 0x2CC3},   // 'Ⳃ' => 'ⳃ'
	6569: {0x2CC2, 0x2CC3},   // 'Ⳃ' => 'ⳃ'
	6566: {0x2CC4, 0x2CC5},   // 'Ⳅ' => 'ⳅ'
	6563: {0x2CC4, 0x2CC5},   // 'Ⳅ' => 'ⳅ'
	6560: {0x2CC6, 0x2CC7},   // 'Ⳇ' => 'ⳇ'
	6557: {0x2CC6, 0x2CC7},   // 'Ⳇ' => 'ⳇ'
	6554: {0x2CC8, 0x2CC9},   // 'Ⳉ' => 'ⳉ'
	6551: {0x2CC8, 0x2CC9},   // 'Ⳉ' => 'ⳉ'
	6548: {0x2CCA, 0x2CCB},   // 'Ⳋ' => 'ⳋ'
	6545: {0x2CCA, 0x2CCB},   // 'Ⳋ' => 'ⳋ'
	6542: {0x2CCC, 0x2CCD},   // 'Ⳍ' => 'ⳍ'
	6539: {0x2CCC, 0x2CCD},   // 'Ⳍ' => 'ⳍ'
	6536: {0x2CCE, 0x2CCF},   // 'Ⳏ' => 'ⳏ'
	6533: {0x2CCE, 0x2CCF},   // 'Ⳏ' => 'ⳏ'
	6530: {0x2CD0, 0x2CD1},   // 'Ⳑ' => 'ⳑ'
	6527: {0x2CD0, 0x2CD1},   // 'Ⳑ' => 'ⳑ'
	6524: {0x2CD2, 0x2CD3},   // 'Ⳓ' => 'ⳓ'
	6521: {0x2CD2, 0x2CD3},   // 'Ⳓ' => 'ⳓ'
	6518: {0x2CD4, 0x2CD5},   // 'Ⳕ' => 'ⳕ'
	6515: {0x2CD4, 0x2CD5},   // 'Ⳕ' => 'ⳕ'
	6512: {0x2CD6, 0x2CD7},   // 'Ⳗ' => 'ⳗ'
	6509: {0x2CD6, 0x2CD7},   // 'Ⳗ' => 'ⳗ'
	6506: {0x2CD8, 0x2CD9},   // 'Ⳙ' => 'ⳙ'
	6503: {0x2CD8, 0x2CD9},   // 'Ⳙ' => 'ⳙ'
	6500: {0x2CDA, 0x2CDB},   // 'Ⳛ' => 'ⳛ'
	6497: {0x2CDA, 0x2CDB},   // 'Ⳛ' => 'ⳛ'
	6494: {0x2CDC, 0x2CDD},   // 'Ⳝ' => 'ⳝ'
	6491: {0x2CDC, 0x2CDD},   // 'Ⳝ' => 'ⳝ'
	6488: {0x2CDE, 0x2CDF},   // 'Ⳟ' => 'ⳟ'
	6485: {0x2CDE, 0x2CDF},   // 'Ⳟ' => 'ⳟ'
	6482: {0x2CE0, 0x2CE1},   // 'Ⳡ' => 'ⳡ'
	6479: {0x2CE0, 0x2CE1},   // 'Ⳡ' => 'ⳡ'
	6476: {0x2CE2, 0x2CE3},   // 'Ⳣ' => 'ⳣ'
	6473: {0x2CE2, 0x2CE3},   // 'Ⳣ' => 'ⳣ'
	6449: {0x2CEB, 0x2CEC},   // 'Ⳬ' => 'ⳬ'
	6446: {0x2CEB, 0x2CEC},   // 'Ⳬ' => 'ⳬ'
	6443: {0x2CED, 0x2CEE},   // 'Ⳮ' => 'ⳮ'
	6440: {0x2CED, 0x2CEE},   // 'Ⳮ' => 'ⳮ'
	6428: {0x2CF2, 0x2CF3},   // 'Ⳳ' => 'ⳳ'
	6425: {0x2CF2, 0x2CF3},   // 'Ⳳ' => 'ⳳ'
	6386: {0x10A0, 0x2D00},   // 'Ⴀ' => 'ⴀ'
	6383: {0x10A1, 0x2D01},   // 'Ⴁ' => 'ⴁ'
	6380: {0x10A2, 0x2D02},   // 'Ⴂ' => 'ⴂ'
	6377: {0x10A3, 0x2D03},   // 'Ⴃ' => 'ⴃ'
	6374: {0x10A4, 0x2D04},   // 'Ⴄ' => 'ⴄ'
	6371: {0x10A5, 0x2D05},   // 'Ⴅ' => 'ⴅ'
	6368: {0x10A6, 0x2D06},   // 'Ⴆ' => 'ⴆ'
	6365: {0x10A7, 0x2D07},   // 'Ⴇ' => 'ⴇ'
	6362: {0x10A8, 0x2D08},   // 'Ⴈ' => 'ⴈ'
	6359: {0x10A9, 0x2D09},   // 'Ⴉ' => 'ⴉ'
	6356: {0x10AA, 0x2D0A},   // 'Ⴊ' => 'ⴊ'
	6353: {0x10AB, 0x2D0B},   // 'Ⴋ' => 'ⴋ'
	6350: {0x10AC, 0x2D0C},   // 'Ⴌ' => 'ⴌ'
	6347: {0x10AD, 0x2D0D},   // 'Ⴍ' => 'ⴍ'
	6344: {0x10AE, 0x2D0E},   // 'Ⴎ' => 'ⴎ'
	6341: {0x10AF, 0x2D0F},   // 'Ⴏ' => 'ⴏ'
	6338: {0x10B0, 0x2D10},   // 'Ⴐ' => 'ⴐ'
	6335: {0x10B1, 0x2D11},   // 'Ⴑ' => 'ⴑ'
	6332: {0x10B2, 0x2D12},   // 'Ⴒ' => 'ⴒ'
	6329: {0x10B3, 0x2D13},   // 'Ⴓ' => 'ⴓ'
	6326: {0x10B4, 0x2D14},   // 'Ⴔ' => 'ⴔ'
	6323: {0x10B5, 0x2D15},   // 'Ⴕ' => 'ⴕ'
	6320: {0x10B6, 0x2D16},   // 'Ⴖ' => 'ⴖ'
	6317: {0x10B7, 0x2D17},   // 'Ⴗ' => 'ⴗ'
	6314: {0x10B8, 0x2D18},   // 'Ⴘ' => 'ⴘ'
	6311: {0x10B9, 0x2D19},   // 'Ⴙ' => 'ⴙ'
	6308: {0x10BA, 0x2D1A},   // 'Ⴚ' => 'ⴚ'
	6305: {0x10BB, 0x2D1B},   // 'Ⴛ' => 'ⴛ'
	6302: {0x10BC, 0x2D1C},   // 'Ⴜ' => 'ⴜ'
	6299: {0x10BD, 0x2D1D},   // 'Ⴝ' => 'ⴝ'
	6296: {0x10BE, 0x2D1E},   // 'Ⴞ' => 'ⴞ'
	6293: {0x10BF, 0x2D1F},   // 'Ⴟ' => 'ⴟ'
	6290: {0x10C0, 0x2D20},   // 'Ⴠ' => 'ⴠ'
	6287: {0x10C1, 0x2D21},   // 'Ⴡ' => 'ⴡ'
	6284: {0x10C2, 0x2D22},   // 'Ⴢ' => 'ⴢ'
	6281: {0x10C3, 0x2D23},   // 'Ⴣ' => 'ⴣ'
	6278: {0x10C4, 0x2D24},   // 'Ⴤ' => 'ⴤ'
	6275: {0x10C5, 0x2D25},   // 'Ⴥ' => 'ⴥ'
	6269: {0x10C7, 0x2D27},   // 'Ⴧ' => 'ⴧ'
	6251: {0x10CD, 0x2D2D},   // 'Ⴭ' => 'ⴭ'
	3341: {0xA640, 0xA641},   // 'Ꙁ' => 'ꙁ'
	3338: {0xA640, 0xA641},   // 'Ꙁ' => 'ꙁ'
	3335: {0xA642, 0xA643},   // 'Ꙃ' => 'ꙃ'
	3332: {0xA642, 0xA643},   // 'Ꙃ' => 'ꙃ'
	3329: {0xA644, 0xA645},   // 'Ꙅ' => 'ꙅ'
	3326: {0xA644, 0xA645},   // 'Ꙅ' => 'ꙅ'
	3323: {0xA646, 0xA647},   // 'Ꙇ' => 'ꙇ'
	3320: {0xA646, 0xA647},   // 'Ꙇ' => 'ꙇ'
	3317: {0xA648, 0xA649},   // 'Ꙉ' => 'ꙉ'
	3314: {0xA648, 0xA649},   // 'Ꙉ' => 'ꙉ'
	3311: {0xA64A, 0xA64B},   // 'Ꙋ' => 'ꙋ'
	3308: {0xA64A, 0xA64B},   // 'Ꙋ' => 'ꙋ'
	3305: {0xA64C, 0xA64D},   // 'Ꙍ' => 'ꙍ'
	3302: {0xA64C, 0xA64D},   // 'Ꙍ' => 'ꙍ'
	3299: {0xA64E, 0xA64F},   // 'Ꙏ' => 'ꙏ'
	3296: {0xA64E, 0xA64F},   // 'Ꙏ' => 'ꙏ'
	3293: {0xA650, 0xA651},   // 'Ꙑ' => 'ꙑ'
	3290: {0xA650, 0xA651},   // 'Ꙑ' => 'ꙑ'
	3287: {0xA652, 0xA653},   // 'Ꙓ' => 'ꙓ'
	3284: {0xA652, 0xA653},   // 'Ꙓ' => 'ꙓ'
	3281: {0xA654, 0xA655},   // 'Ꙕ' => 'ꙕ'
	3278: {0xA654, 0xA655},   // 'Ꙕ' => 'ꙕ'
	3275: {0xA656, 0xA657},   // 'Ꙗ' => 'ꙗ'
	3272: {0xA656, 0xA657},   // 'Ꙗ' => 'ꙗ'
	3269: {0xA658, 0xA659},   // 'Ꙙ' => 'ꙙ'
	3266: {0xA658, 0xA659},   // 'Ꙙ' => 'ꙙ'
	3263: {0xA65A, 0xA65B},   // 'Ꙛ' => 'ꙛ'
	3260: {0xA65A, 0xA65B},   // 'Ꙛ' => 'ꙛ'
	3257: {0xA65C, 0xA65D},   // 'Ꙝ' => 'ꙝ'
	3254: {0xA65C, 0xA65D},   // 'Ꙝ' => 'ꙝ'
	3251: {0xA65E, 0xA65F},   // 'Ꙟ' => 'ꙟ'
	3248: {0xA65E, 0xA65F},   // 'Ꙟ' => 'ꙟ'
	3245: {0xA660, 0xA661},   // 'Ꙡ' => 'ꙡ'
	3242: {0xA660, 0xA661},   // 'Ꙡ' => 'ꙡ'
	3239: {0xA662, 0xA663},   // 'Ꙣ' => 'ꙣ'
	3236: {0xA662, 0xA663},   // 'Ꙣ' => 'ꙣ'
	3233: {0xA664, 0xA665},   // 'Ꙥ' => 'ꙥ'
	3230: {0xA664, 0xA665},   // 'Ꙥ' => 'ꙥ'
	3227: {0xA666, 0xA667},   // 'Ꙧ' => 'ꙧ'
	3224: {0xA666, 0xA667},   // 'Ꙧ' => 'ꙧ'
	3221: {0xA668, 0xA669},   // 'Ꙩ' => 'ꙩ'
	3218: {0xA668, 0xA669},   // 'Ꙩ' => 'ꙩ'
	3215: {0xA66A, 0xA66B},   // 'Ꙫ' => 'ꙫ'
	3212: {0xA66A, 0xA66B},   // 'Ꙫ' => 'ꙫ'
	3209: {0xA66C, 0xA66D},   // 'Ꙭ' => 'ꙭ'
	3206: {0xA66C, 0xA66D},   // 'Ꙭ' => 'ꙭ'
	3149: {0xA680, 0xA681},   // 'Ꚁ' => 'ꚁ'
	3146: {0xA680, 0xA681},   // 'Ꚁ' => 'ꚁ'
	3143: {0xA682, 0xA683},   // 'Ꚃ' => 'ꚃ'
	3140: {0xA682, 0xA683},   // 'Ꚃ' => 'ꚃ'
	3137: {0xA684, 0xA685},   // 'Ꚅ' => 'ꚅ'
	3134: {0xA684, 0xA685},   // 'Ꚅ' => 'ꚅ'
	3131: {0xA686, 0xA687},   // 'Ꚇ' => 'ꚇ'
	3128: {0xA686, 0xA687},   // 'Ꚇ' => 'ꚇ'
	3125: {0xA688, 0xA689},   // 'Ꚉ' => 'ꚉ'
	3122: {0xA688, 0xA689},   // 'Ꚉ' => 'ꚉ'
	3119: {0xA68A, 0xA68B},   // 'Ꚋ' => 'ꚋ'
	3116: {0xA68A, 0xA68B},   // 'Ꚋ' => 'ꚋ'
	3113: {0xA68C, 0xA68D},   // 'Ꚍ' => 'ꚍ'
	3110: {0xA68C, 0xA68D},   // 'Ꚍ' => 'ꚍ'
	3107: {0xA68E, 0xA68F},   // 'Ꚏ' => 'ꚏ'
	3104: {0xA68E, 0xA68F},   // 'Ꚏ' => 'ꚏ'
	3101: {0xA690, 0xA691},   // 'Ꚑ' => 'ꚑ'
	3098: {0xA690, 0xA691},   // 'Ꚑ' => 'ꚑ'
	3095: {0xA692, 0xA693},   // 'Ꚓ' => 'ꚓ'
	3092: {0xA692, 0xA693},   // 'Ꚓ' => 'ꚓ'
	3089: {0xA694, 0xA695},   // 'Ꚕ' => 'ꚕ'
	3086: {0xA694, 0xA695},   // 'Ꚕ' => 'ꚕ'
	3083: {0xA696, 0xA697},   // 'Ꚗ' => 'ꚗ'
	3080: {0xA696, 0xA697},   // 'Ꚗ' => 'ꚗ'
	3077: {0xA698, 0xA699},   // 'Ꚙ' => 'ꚙ'
	3074: {0xA698, 0xA699},   // 'Ꚙ' => 'ꚙ'
	3071: {0xA69A, 0xA69B},   // 'Ꚛ' => 'ꚛ'
	3068: {0xA69A, 0xA69B},   // 'Ꚛ' => 'ꚛ'
	2663: {0xA722, 0xA723},   // 'Ꜣ' => 'ꜣ'
	2660: {0xA722, 0xA723},   // 'Ꜣ' => 'ꜣ'
	2657: {0xA724, 0xA725},   // 'Ꜥ' => 'ꜥ'
	2654: {0xA724, 0xA725},   // 'Ꜥ' => 'ꜥ'
	2651: {0xA726, 0xA727},   // 'Ꜧ' => 'ꜧ'
	2648: {0xA726, 0xA727},   // 'Ꜧ' => 'ꜧ'
	2645: {0xA728, 0xA729},   // 'Ꜩ' => 'ꜩ'
	2642: {0xA728, 0xA729},   // 'Ꜩ' => 'ꜩ'
	2639: {0xA72A, 0xA72B},   // 'Ꜫ' => 'ꜫ'
	2636: {0xA72A, 0xA72B},   // 'Ꜫ' => 'ꜫ'
	2633: {0xA72C, 0xA72D},   // 'Ꜭ' => 'ꜭ'
	2630: {0xA72C, 0xA72D},   // 'Ꜭ' => 'ꜭ'
	2627: {0xA72E, 0xA72F},   // 'Ꜯ' => 'ꜯ'
	2624: {0xA72E, 0xA72F},   // 'Ꜯ' => 'ꜯ'
	2615: {0xA732, 0xA733},   // 'Ꜳ' => 'ꜳ'
	2612: {0xA732, 0xA733},   // 'Ꜳ' => 'ꜳ'
	2609: {0xA734, 0xA735},   // 'Ꜵ' => 'ꜵ'
	2606: {0xA734, 0xA735},   // 'Ꜵ' => 'ꜵ'
	2603: {0xA736, 0xA737},   // 'Ꜷ' => 'ꜷ'
	2600: {0xA736, 0xA737},   // 'Ꜷ' => 'ꜷ'
	2597: {0xA738, 0xA739},   // 'Ꜹ' => 'ꜹ'
	2594: {0xA738, 0xA739},   // 'Ꜹ' => 'ꜹ'
	2591: {0xA73A, 0xA73B},   // 'Ꜻ' => 'ꜻ'
	2588: {0xA73A, 0xA73B},   // 'Ꜻ' => 'ꜻ'
	2585: {0xA73C, 0xA73D},   // 'Ꜽ' => 'ꜽ'
	2582: {0xA73C, 0xA73D},   // 'Ꜽ' => 'ꜽ'
	2579: {0xA73E, 0xA73F},   // 'Ꜿ' => 'ꜿ'
	2576: {0xA73E, 0xA73F},   // 'Ꜿ' => 'ꜿ'
	2573: {0xA740, 0xA741},   // 'Ꝁ' => 'ꝁ'
	2570: {0xA740, 0xA741},   // 'Ꝁ' => 'ꝁ'
	2567: {0xA742, 0xA743},   // 'Ꝃ' => 'ꝃ'
	2564: {0xA742, 0xA743},   // 'Ꝃ' => 'ꝃ'
	2561: {0xA744, 0xA745},   // 'Ꝅ' => 'ꝅ'
	2558: {0xA744, 0xA745},   // 'Ꝅ' => 'ꝅ'
	2555: {0xA746, 0xA747},   // 'Ꝇ' => 'ꝇ'
	2552: {0xA746, 0xA747},   // 'Ꝇ' => 'ꝇ'
	2549: {0xA748, 0xA749},   // 'Ꝉ' => 'ꝉ'
	2546: {0xA748, 0xA749},   // 'Ꝉ' => 'ꝉ'
	2543: {0xA74A, 0xA74B},   // 'Ꝋ' => 'ꝋ'
	2540: {0xA74A, 0xA74B},   // 'Ꝋ' => 'ꝋ'
	2537: {0xA74C, 0xA74D},   // 'Ꝍ' => 'ꝍ'
	2534: {0xA74C, 0xA74D},   // 'Ꝍ' => 'ꝍ'
	2531: {0xA74E, 0xA74F},   // 'Ꝏ' => 'ꝏ'
	2528: {0xA74E, 0xA74F},   // 'Ꝏ' => 'ꝏ'
	2525: {0xA750, 0xA751},   // 'Ꝑ' => 'ꝑ'
	2522: {0xA750, 0xA751},   // 'Ꝑ' => 'ꝑ'
	2519: {0xA752, 0xA753},   // 'Ꝓ' => 'ꝓ'
	2516: {0xA752, 0xA753},   // 'Ꝓ' => 'ꝓ'
	2513: {0xA754, 0xA755},   // 'Ꝕ' => 'ꝕ'
	2510: {0xA754, 0xA755},   // 'Ꝕ' => 'ꝕ'
	2507: {0xA756, 0xA757},   // 'Ꝗ' => 'ꝗ'
	2504: {0xA756, 0xA757},   // 'Ꝗ' => 'ꝗ'
	2501: {0xA758, 0xA759},   // 'Ꝙ' => 'ꝙ'
	2498: {0xA758, 0xA759},   // 'Ꝙ' => 'ꝙ'
	2495: {0xA75A, 0xA75B},   // 'Ꝛ' => 'ꝛ'
	2492: {0xA75A, 0xA75B},   // 'Ꝛ' => 'ꝛ'
	2489: {0xA75C, 0xA75D},   // 'Ꝝ' => 'ꝝ'
	2486: {0xA75C, 0xA75D},   // 'Ꝝ' => 'ꝝ'
	2483: {0xA75E, 0xA75F},   // 'Ꝟ' => 'ꝟ'
	2480: {0xA75E, 0xA75F},   // 'Ꝟ' => 'ꝟ'
	2477: {0xA760, 0xA761},   // 'Ꝡ' => 'ꝡ'
	2474: {0xA760, 0xA761},   // 'Ꝡ' => 'ꝡ'
	2471: {0xA762, 0xA763},   // 'Ꝣ' => 'ꝣ'
	2468: {0xA762, 0xA763},   // 'Ꝣ' => 'ꝣ'
	2465: {0xA764, 0xA765},   // 'Ꝥ' => 'ꝥ'
	2462: {0xA764, 0xA765},   // 'Ꝥ' => 'ꝥ'
	2459: {0xA766, 0xA767},   // 'Ꝧ' => 'ꝧ'
	2456: {0xA766, 0xA767},   // 'Ꝧ' => 'ꝧ'
	2453: {0xA768, 0xA769},   // 'Ꝩ' => 'ꝩ'
	2450: {0xA768, 0xA769},   // 'Ꝩ' => 'ꝩ'
	2447: {0xA76A, 0xA76B},   // 'Ꝫ' => 'ꝫ'
	2444: {0xA76A, 0xA76B},   // 'Ꝫ' => 'ꝫ'
	2441: {0xA76C, 0xA76D},   // 'Ꝭ' => 'ꝭ'
	2438: {0xA76C, 0xA76D},   // 'Ꝭ' => 'ꝭ'
	2435: {0xA76E, 0xA76F},   // 'Ꝯ' => 'ꝯ'
	2432: {0xA76E, 0xA76F},   // 'Ꝯ' => 'ꝯ'
	2402: {0xA779, 0xA77A},   // 'Ꝺ' => 'ꝺ'
	2399: {0xA779, 0xA77A},   // 'Ꝺ' => 'ꝺ'
	2396: {0xA77B, 0xA77C},   // 'Ꝼ' => 'ꝼ'
	2393: {0xA77B, 0xA77C},   // 'Ꝼ' => 'ꝼ'
	2390: {0xA77D, 0x1D79},   // 'Ᵹ' => 'ᵹ'
	2387: {0xA77E, 0xA77F},   // 'Ꝿ' => 'ꝿ'
	2384: {0xA77E, 0xA77F},   // 'Ꝿ' => 'ꝿ'
	2381: {0xA780, 0xA781},   // 'Ꞁ' => 'ꞁ'
	2378: {0xA780, 0xA781},   // 'Ꞁ' => 'ꞁ'
	2375: {0xA782, 0xA783},   // 'Ꞃ' => 'ꞃ'
	2372: {0xA782, 0xA783},   // 'Ꞃ' => 'ꞃ'
	2369: {0xA784, 0xA785},   // 'Ꞅ' => 'ꞅ'
	2366: {0xA784, 0xA785},   // 'Ꞅ' => 'ꞅ'
	2363: {0xA786, 0xA787},   // 'Ꞇ' => 'ꞇ'
	2360: {0xA786, 0xA787},   // 'Ꞇ' => 'ꞇ'
	2348: {0xA78B, 0xA78C},   // 'Ꞌ' => 'ꞌ'
	2345: {0xA78B, 0xA78C},   // 'Ꞌ' => 'ꞌ'
	2342: {0xA78D, 0x0265},   // 'Ɥ' => 'ɥ'
	2333: {0xA790, 0xA791},   // 'Ꞑ' => 'ꞑ'
	2330: {0xA790, 0xA791},   // 'Ꞑ' => 'ꞑ'
	2327: {0xA792, 0xA793},   // 'Ꞓ' => 'ꞓ'
	2324: {0xA792, 0xA793},   // 'Ꞓ' => 'ꞓ'
	2321: {0xA7C4, 0xA794},   // 'Ꞔ' => 'ꞔ'
	2315: {0xA796, 0xA797},   // 'Ꞗ' => 'ꞗ'
	2312: {0xA796, 0xA797},   // 'Ꞗ' => 'ꞗ'
	2309: {0xA798, 0xA799},   // 'Ꞙ' => 'ꞙ'
	2306: {0xA798, 0xA799},   // 'Ꞙ' => 'ꞙ'
	2303: {0xA79A, 0xA79B},   // 'Ꞛ' => 'ꞛ'
	2300: {0xA79A, 0xA79B},   // 'Ꞛ' => 'ꞛ'
	2297: {0xA79C, 0xA79D},   // 'Ꞝ' => 'ꞝ'
	2294: {0xA79C, 0xA79D},   // 'Ꞝ' => 'ꞝ'
	2291: {0xA79E, 0xA79F},   // 'Ꞟ' => 'ꞟ'
	2288: {0xA79E, 0xA79F},   // 'Ꞟ' => 'ꞟ'
	2285: {0xA7A0, 0xA7A1},   // 'Ꞡ' => 'ꞡ'
	2282: {0xA7A0, 0xA7A1},   // 'Ꞡ' => 'ꞡ'
	2279: {0xA7A2, 0xA7A3},   // 'Ꞣ' => 'ꞣ'
	2276: {0xA7A2, 0xA7A3},   // 'Ꞣ' => 'ꞣ'
	2273: {0xA7A4, 0xA7A5},   // 'Ꞥ' => 'ꞥ'
	2270: {0xA7A4, 0xA7A5},   // 'Ꞥ' => 'ꞥ'
	2267: {0xA7A6, 0xA7A7},   // 'Ꞧ' => 'ꞧ'
	2264: {0xA7A6, 0xA7A7},   // 'Ꞧ' => 'ꞧ'
	2261: {0xA7A8, 0xA7A9},   // 'Ꞩ' => 'ꞩ'
	2258: {0xA7A8, 0xA7A9},   // 'Ꞩ' => 'ꞩ'
	2255: {0xA7AA, 0x0266},   // 'Ɦ' => 'ɦ'
	2252: {0xA7AB, 0x025C},   // 'Ɜ' => 'ɜ'
	2249: {0xA7AC, 0x0261},   // 'Ɡ' => 'ɡ'
	2246: {0xA7AD, 0x026C},   // 'Ɬ' => 'ɬ'
	2243: {0xA7AE, 0x026A},   // 'Ɪ' => 'ɪ'
	2237: {0xA7B0, 0x029E},   // 'Ʞ' => 'ʞ'
	2234: {0xA7B1, 0x0287},   // 'Ʇ' => 'ʇ'
	2231: {0xA7B2, 0x029D},   // 'Ʝ' => 'ʝ'
	2228: {0xA7B3, 0xAB53},   // 'Ꭓ' => 'ꭓ'
	2225: {0xA7B4, 0xA7B5},   // 'Ꞵ' => 'ꞵ'
	2222: {0xA7B4, 0xA7B5},   // 'Ꞵ' => 'ꞵ'
	2219: {0xA7B6, 0xA7B7},   // 'Ꞷ' => 'ꞷ'
	2216: {0xA7B6, 0xA7B7},   // 'Ꞷ' => 'ꞷ'
	2213: {0xA7B8, 0xA7B9},   // 'Ꞹ' => 'ꞹ'
	2210: {0xA7B8, 0xA7B9},   // 'Ꞹ' => 'ꞹ'
	2207: {0xA7BA, 0xA7BB},   // 'Ꞻ' => 'ꞻ'
	2204: {0xA7BA, 0xA7BB},   // 'Ꞻ' => 'ꞻ'
	2201: {0xA7BC, 0xA7BD},   // 'Ꞽ' => 'ꞽ'
	2198: {0xA7BC, 0xA7BD},   // 'Ꞽ' => 'ꞽ'
	2195: {0xA7BE, 0xA7BF},   // 'Ꞿ' => 'ꞿ'
	2192: {0xA7BE, 0xA7BF},   // 'Ꞿ' => 'ꞿ'
	2183: {0xA7C2, 0xA7C3},   // 'Ꟃ' => 'ꟃ'
	2180: {0xA7C2, 0xA7C3},   // 'Ꟃ' => 'ꟃ'
	2177: {0xA7C4, 0xA794},   // 'Ꞔ' => 'ꞔ'
	2174: {0xA7C5, 0x0282},   // 'Ʂ' => 'ʂ'
	2171: {0xA7C6, 0x1D8E},   // 'Ᶎ' => 'ᶎ'
	2168: {0xA7C7, 0xA7C8},   // 'Ꟈ' => 'ꟈ'
	2165: {0xA7C7, 0xA7C8},   // 'Ꟈ' => 'ꟈ'
	2162: {0xA7C9, 0xA7CA},   // 'Ꟊ' => 'ꟊ'
	2159: {0xA7C9, 0xA7CA},   // 'Ꟊ' => 'ꟊ'
	2030: {0xA7F5, 0xA7F6},   // 'Ꟶ' => 'ꟶ'
	2027: {0xA7F5, 0xA7F6},   // 'Ꟶ' => 'ꟶ'
	7635: {0xA7B3, 0xAB53},   // 'Ꭓ' => 'ꭓ'
	7548: {0x13A0, 0xAB70},   // 'Ꭰ' => 'ꭰ'
	7545: {0x13A1, 0xAB71},   // 'Ꭱ' => 'ꭱ'
	7542: {0x13A2, 0xAB72},   // 'Ꭲ' => 'ꭲ'
	7539: {0x13A3, 0xAB73},   // 'Ꭳ' => 'ꭳ'
	7536: {0x13A4, 0xAB74},   // 'Ꭴ' => 'ꭴ'
	7533: {0x13A5, 0xAB75},   // 'Ꭵ' => 'ꭵ'
	7530: {0x13A6, 0xAB76},   // 'Ꭶ' => 'ꭶ'
	7527: {0x13A7, 0xAB77},   // 'Ꭷ' => 'ꭷ'
	7524: {0x13A8, 0xAB78},   // 'Ꭸ' => 'ꭸ'
	7521: {0x13A9, 0xAB79},   // 'Ꭹ' => 'ꭹ'
	7518: {0x13AA, 0xAB7A},   // 'Ꭺ' => 'ꭺ'
	7515: {0x13AB, 0xAB7B},   // 'Ꭻ' => 'ꭻ'
	7512: {0x13AC, 0xAB7C},   // 'Ꭼ' => 'ꭼ'
	7509: {0x13AD, 0xAB7D},   // 'Ꭽ' => 'ꭽ'
	7506: {0x13AE, 0xAB7E},   // 'Ꭾ' => 'ꭾ'
	7503: {0x13AF, 0xAB7F},   // 'Ꭿ' => 'ꭿ'
	7500: {0x13B0, 0xAB80},   // 'Ꮀ' => 'ꮀ'
	7497: {0x13B1, 0xAB81},   // 'Ꮁ' => 'ꮁ'
	7494: {0x13B2, 0xAB82},   // 'Ꮂ' => 'ꮂ'
	7491: {0x13B3, 0xAB83},   // 'Ꮃ' => 'ꮃ'
	7488: {0x13B4, 0xAB84},   // 'Ꮄ' => 'ꮄ'
	7485: {0x13B5, 0xAB85},   // 'Ꮅ' => 'ꮅ'
	7482: {0x13B6, 0xAB86},   // 'Ꮆ' => 'ꮆ'
	7479: {0x13B7, 0xAB87},   // 'Ꮇ' => 'ꮇ'
	7476: {0x13B8, 0xAB88},   // 'Ꮈ' => 'ꮈ'
	7473: {0x13B9, 0xAB89},   // 'Ꮉ' => 'ꮉ'
	7470: {0x13BA, 0xAB8A},   // 'Ꮊ' => 'ꮊ'
	7467: {0x13BB, 0xAB8B},   // 'Ꮋ' => 'ꮋ'
	7464: {0x13BC, 0xAB8C},   // 'Ꮌ' => 'ꮌ'
	7461: {0x13BD, 0xAB8D},   // 'Ꮍ' => 'ꮍ'
	7458: {0x13BE, 0xAB8E},   // 'Ꮎ' => 'ꮎ'
	7455: {0x13BF, 0xAB8F},   // 'Ꮏ' => 'ꮏ'
	7452: {0x13C0, 0xAB90},   // 'Ꮐ' => 'ꮐ'
	7449: {0x13C1, 0xAB91},   // 'Ꮑ' => 'ꮑ'
	7446: {0x13C2, 0xAB92},   // 'Ꮒ' => 'ꮒ'
	7443: {0x13C3, 0xAB93},   // 'Ꮓ' => 'ꮓ'
	7440: {0x13C4, 0xAB94},   // 'Ꮔ' => 'ꮔ'
	7437: {0x13C5, 0xAB95},   // 'Ꮕ' => 'ꮕ'
	7434: {0x13C6, 0xAB96},   // 'Ꮖ' => 'ꮖ'
	7431: {0x13C7, 0xAB97},   // 'Ꮗ' => 'ꮗ'
	7428: {0x13C8, 0xAB98},   // 'Ꮘ' => 'ꮘ'
	7425: {0x13C9, 0xAB99},   // 'Ꮙ' => 'ꮙ'
	7422: {0x13CA, 0xAB9A},   // 'Ꮚ' => 'ꮚ'
	7419: {0x13CB, 0xAB9B},   // 'Ꮛ' => 'ꮛ'
	7416: {0x13CC, 0xAB9C},   // 'Ꮜ' => 'ꮜ'
	7413: {0x13CD, 0xAB9D},   // 'Ꮝ' => 'ꮝ'
	7410: {0x13CE, 0xAB9E},   // 'Ꮞ' => 'ꮞ'
	7407: {0x13CF, 0xAB9F},   // 'Ꮟ' => 'ꮟ'
	7404: {0x13D0, 0xABA0},   // 'Ꮠ' => 'ꮠ'
	7401: {0x13D1, 0xABA1},   // 'Ꮡ' => 'ꮡ'
	7398: {0x13D2, 0xABA2},   // 'Ꮢ' => 'ꮢ'
	7395: {0x13D3, 0xABA3},   // 'Ꮣ' => 'ꮣ'
	7392: {0x13D4, 0xABA4},   // 'Ꮤ' => 'ꮤ'
	7389: {0x13D5, 0xABA5},   // 'Ꮥ' => 'ꮥ'
	7386: {0x13D6, 0xABA6},   // 'Ꮦ' => 'ꮦ'
	7383: {0x13D7, 0xABA7},   // 'Ꮧ' => 'ꮧ'
	7380: {0x13D8, 0xABA8},   // 'Ꮨ' => 'ꮨ'
	7377: {0x13D9, 0xABA9},   // 'Ꮩ' => 'ꮩ'
	7374: {0x13DA, 0xABAA},   // 'Ꮪ' => 'ꮪ'
	7371: {0x13DB, 0xABAB},   // 'Ꮫ' => 'ꮫ'
	7368: {0x13DC, 0xABAC},   // 'Ꮬ' => 'ꮬ'
	7365: {0x13DD, 0xABAD},   // 'Ꮭ' => 'ꮭ'
	7362: {0x13DE, 0xABAE},   // 'Ꮮ' => 'ꮮ'
	7359: {0x13DF, 0xABAF},   // 'Ꮯ' => 'ꮯ'
	7356: {0x13E0, 0xABB0},   // 'Ꮰ' => 'ꮰ'
	7353: {0x13E1, 0xABB1},   // 'Ꮱ' => 'ꮱ'
	7350: {0x13E2, 0xABB2},   // 'Ꮲ' => 'ꮲ'
	7347: {0x13E3, 0xABB3},   // 'Ꮳ' => 'ꮳ'
	7344: {0x13E4, 0xABB4},   // 'Ꮴ' => 'ꮴ'
	7341: {0x13E5, 0xABB5},   // 'Ꮵ' => 'ꮵ'
	7338: {0x13E6, 0xABB6},   // 'Ꮶ' => 'ꮶ'
	7335: {0x13E7, 0xABB7},   // 'Ꮷ' => 'ꮷ'
	7332: {0x13E8, 0xABB8},   // 'Ꮸ' => 'ꮸ'
	7329: {0x13E9, 0xABB9},   // 'Ꮹ' => 'ꮹ'
	7326: {0x13EA, 0xABBA},   // 'Ꮺ' => 'ꮺ'
	7323: {0x13EB, 0xABBB},   // 'Ꮻ' => 'ꮻ'
	7320: {0x13EC, 0xABBC},   // 'Ꮼ' => 'ꮼ'
	7317: {0x13ED, 0xABBD},   // 'Ꮽ' => 'ꮽ'
	7314: {0x13EE, 0xABBE},   // 'Ꮾ' => 'ꮾ'
	7311: {0x13EF, 0xABBF},   // 'Ꮿ' => 'ꮿ'
	591:  {0xFF21, 0xFF41},   // 'Ａ' => 'ａ'
	588:  {0xFF22, 0xFF42},   // 'Ｂ' => 'ｂ'
	585:  {0xFF23, 0xFF43},   // 'Ｃ' => 'ｃ'
	582:  {0xFF24, 0xFF44},   // 'Ｄ' => 'ｄ'
	579:  {0xFF25, 0xFF45},   // 'Ｅ' => 'ｅ'
	576:  {0xFF26, 0xFF46},   // 'Ｆ' => 'ｆ'
	573:  {0xFF27, 0xFF47},   // 'Ｇ' => 'ｇ'
	570:  {0xFF28, 0xFF48},   // 'Ｈ' => 'ｈ'
	567:  {0xFF29, 0xFF49},   // 'Ｉ' => 'ｉ'
	564:  {0xFF2A, 0xFF4A},   // 'Ｊ' => 'ｊ'
	561:  {0xFF2B, 0xFF4B},   // 'Ｋ' => 'ｋ'
	558:  {0xFF2C, 0xFF4C},   // 'Ｌ' => 'ｌ'
	555:  {0xFF2D, 0xFF4D},   // 'Ｍ' => 'ｍ'
	552:  {0xFF2E, 0xFF4E},   // 'Ｎ' => 'ｎ'
	549:  {0xFF2F, 0xFF4F},   // 'Ｏ' => 'ｏ'
	546:  {0xFF30, 0xFF50},   // 'Ｐ' => 'ｐ'
	543:  {0xFF31, 0xFF51},   // 'Ｑ' => 'ｑ'
	540:  {0xFF32, 0xFF52},   // 'Ｒ' => 'ｒ'
	537:  {0xFF33, 0xFF53},   // 'Ｓ' => 'ｓ'
	534:  {0xFF34, 0xFF54},   // 'Ｔ' => 'ｔ'
	531:  {0xFF35, 0xFF55},   // 'Ｕ' => 'ｕ'
	528:  {0xFF36, 0xFF56},   // 'Ｖ' => 'ｖ'
	525:  {0xFF37, 0xFF57},   // 'Ｗ' => 'ｗ'
	522:  {0xFF38, 0xFF58},   // 'Ｘ' => 'ｘ'
	519:  {0xFF39, 0xFF59},   // 'Ｙ' => 'ｙ'
	516:  {0xFF3A, 0xFF5A},   // 'Ｚ' => 'ｚ'
	495:  {0xFF21, 0xFF41},   // 'Ａ' => 'ａ'
	492:  {0xFF22, 0xFF42},   // 'Ｂ' => 'ｂ'
	489:  {0xFF23, 0xFF43},   // 'Ｃ' => 'ｃ'
	486:  {0xFF24, 0xFF44},   // 'Ｄ' => 'ｄ'
	483:  {0xFF25, 0xFF45},   // 'Ｅ' => 'ｅ'
	480:  {0xFF26, 0xFF46},   // 'Ｆ' => 'ｆ'
	477:  {0xFF27, 0xFF47},   // 'Ｇ' => 'ｇ'
	474:  {0xFF28, 0xFF48},   // 'Ｈ' => 'ｈ'
	471:  {0xFF29, 0xFF49},   // 'Ｉ' => 'ｉ'
	468:  {0xFF2A, 0xFF4A},   // 'Ｊ' => 'ｊ'
	465:  {0xFF2B, 0xFF4B},   // 'Ｋ' => 'ｋ'
	462:  {0xFF2C, 0xFF4C},   // 'Ｌ' => 'ｌ'
	459:  {0xFF2D, 0xFF4D},   // 'Ｍ' => 'ｍ'
	456:  {0xFF2E, 0xFF4E},   // 'Ｎ' => 'ｎ'
	453:  {0xFF2F, 0xFF4F},   // 'Ｏ' => 'ｏ'
	450:  {0xFF30, 0xFF50},   // 'Ｐ' => 'ｐ'
	447:  {0xFF31, 0xFF51},   // 'Ｑ' => 'ｑ'
	444:  {0xFF32, 0xFF52},   // 'Ｒ' => 'ｒ'
	441:  {0xFF33, 0xFF53},   // 'Ｓ' => 'ｓ'
	438:  {0xFF34, 0xFF54},   // 'Ｔ' => 'ｔ'
	435:  {0xFF35, 0xFF55},   // 'Ｕ' => 'ｕ'
	432:  {0xFF36, 0xFF56},   // 'Ｖ' => 'ｖ'
	429:  {0xFF37, 0xFF57},   // 'Ｗ' => 'ｗ'
	426:  {0xFF38, 0xFF58},   // 'Ｘ' => 'ｘ'
	423:  {0xFF39, 0xFF59},   // 'Ｙ' => 'ｙ'
	420:  {0xFF3A, 0xFF5A},   // 'Ｚ' => 'ｚ'
	5041: {0x10400, 0x10428}, // '𐐀' => '𐐨'
	5038: {0x10401, 0x10429}, // '𐐁' => '𐐩'
	5035: {0x10402, 0x1042A}, // '𐐂' => '𐐪'
	5032: {0x10403, 0x1042B}, // '𐐃' => '𐐫'
	5029: {0x10404, 0x1042C}, // '𐐄' => '𐐬'
	5026: {0x10405, 0x1042D}, // '𐐅' => '𐐭'
	5023: {0x10406, 0x1042E}, // '𐐆' => '𐐮'
	5020: {0x10407, 0x1042F}, // '𐐇' => '𐐯'
	5017: {0x10408, 0x10430}, // '𐐈' => '𐐰'
	5014: {0x10409, 0x10431}, // '𐐉' => '𐐱'
	5011: {0x1040A, 0x10432}, // '𐐊' => '𐐲'
	5008: {0x1040B, 0x10433}, // '𐐋' => '𐐳'
	5005: {0x1040C, 0x10434}, // '𐐌' => '𐐴'
	5002: {0x1040D, 0x10435}, // '𐐍' => '𐐵'
	4999: {0x1040E, 0x10436}, // '𐐎' => '𐐶'
	4996: {0x1040F, 0x10437}, // '𐐏' => '𐐷'
	4993: {0x10410, 0x10438}, // '𐐐' => '𐐸'
	4990: {0x10411, 0x10439}, // '𐐑' => '𐐹'
	4987: {0x10412, 0x1043A}, // '𐐒' => '𐐺'
	4984: {0x10413, 0x1043B}, // '𐐓' => '𐐻'
	4981: {0x10414, 0x1043C}, // '𐐔' => '𐐼'
	4978: {0x10415, 0x1043D}, // '𐐕' => '𐐽'
	4975: {0x10416, 0x1043E}, // '𐐖' => '𐐾'
	4972: {0x10417, 0x1043F}, // '𐐗' => '𐐿'
	4969: {0x10418, 0x10440}, // '𐐘' => '𐑀'
	4966: {0x10419, 0x10441}, // '𐐙' => '𐑁'
	4963: {0x1041A, 0x10442}, // '𐐚' => '𐑂'
	4960: {0x1041B, 0x10443}, // '𐐛' => '𐑃'
	4957: {0x1041C, 0x10444}, // '𐐜' => '𐑄'
	4954: {0x1041D, 0x10445}, // '𐐝' => '𐑅'
	4951: {0x1041E, 0x10446}, // '𐐞' => '𐑆'
	4948: {0x1041F, 0x10447}, // '𐐟' => '𐑇'
	4945: {0x10420, 0x10448}, // '𐐠' => '𐑈'
	4942: {0x10421, 0x10449}, // '𐐡' => '𐑉'
	4939: {0x10422, 0x1044A}, // '𐐢' => '𐑊'
	4936: {0x10423, 0x1044B}, // '𐐣' => '𐑋'
	4933: {0x10424, 0x1044C}, // '𐐤' => '𐑌'
	4930: {0x10425, 0x1044D}, // '𐐥' => '𐑍'
	4927: {0x10426, 0x1044E}, // '𐐦' => '𐑎'
	4924: {0x10427, 0x1044F}, // '𐐧' => '𐑏'
	4921: {0x10400, 0x10428}, // '𐐀' => '𐐨'
	4918: {0x10401, 0x10429}, // '𐐁' => '𐐩'
	4915: {0x10402, 0x1042A}, // '𐐂' => '𐐪'
	4912: {0x10403, 0x1042B}, // '𐐃' => '𐐫'
	4909: {0x10404, 0x1042C}, // '𐐄' => '𐐬'
	4906: {0x10405, 0x1042D}, // '𐐅' => '𐐭'
	4903: {0x10406, 0x1042E}, // '𐐆' => '𐐮'
	4900: {0x10407, 0x1042F}, // '𐐇' => '𐐯'
	4897: {0x10408, 0x10430}, // '𐐈' => '𐐰'
	4894: {0x10409, 0x10431}, // '𐐉' => '𐐱'
	4891: {0x1040A, 0x10432}, // '𐐊' => '𐐲'
	4888: {0x1040B, 0x10433}, // '𐐋' => '𐐳'
	4885: {0x1040C, 0x10434}, // '𐐌' => '𐐴'
	4882: {0x1040D, 0x10435}, // '𐐍' => '𐐵'
	4879: {0x1040E, 0x10436}, // '𐐎' => '𐐶'
	4876: {0x1040F, 0x10437}, // '𐐏' => '𐐷'
	4873: {0x10410, 0x10438}, // '𐐐' => '𐐸'
	4870: {0x10411, 0x10439}, // '𐐑' => '𐐹'
	4867: {0x10412, 0x1043A}, // '𐐒' => '𐐺'
	4864: {0x10413, 0x1043B}, // '𐐓' => '𐐻'
	4861: {0x10414, 0x1043C}, // '𐐔' => '𐐼'
	4858: {0x10415, 0x1043D}, // '𐐕' => '𐐽'
	4855: {0x10416, 0x1043E}, // '𐐖' => '𐐾'
	4852: {0x10417, 0x1043F}, // '𐐗' => '𐐿'
	4849: {0x10418, 0x10440}, // '𐐘' => '𐑀'
	4846: {0x10419, 0x10441}, // '𐐙' => '𐑁'
	4843: {0x1041A, 0x10442}, // '𐐚' => '𐑂'
	4840: {0x1041B, 0x10443}, // '𐐛' => '𐑃'
	4837: {0x1041C, 0x10444}, // '𐐜' => '𐑄'
	4834: {0x1041D, 0x10445}, // '𐐝' => '𐑅'
	4831: {0x1041E, 0x10446}, // '𐐞' => '𐑆'
	4828: {0x1041F, 0x10447}, // '𐐟' => '𐑇'
	4825: {0x10420, 0x10448}, // '𐐠' => '𐑈'
	4822: {0x10421, 0x10449}, // '𐐡' => '𐑉'
	4819: {0x10422, 0x1044A}, // '𐐢' => '𐑊'
	4816: {0x10423, 0x1044B}, // '𐐣' => '𐑋'
	4813: {0x10424, 0x1044C}, // '𐐤' => '𐑌'
	4810: {0x10425, 0x1044D}, // '𐐥' => '𐑍'
	4807: {0x10426, 0x1044E}, // '𐐦' => '𐑎'
	4804: {0x10427, 0x1044F}, // '𐐧' => '𐑏'
	4513: {0x104B0, 0x104D8}, // '𐒰' => '𐓘'
	4510: {0x104B1, 0x104D9}, // '𐒱' => '𐓙'
	4507: {0x104B2, 0x104DA}, // '𐒲' => '𐓚'
	4504: {0x104B3, 0x104DB}, // '𐒳' => '𐓛'
	4501: {0x104B4, 0x104DC}, // '𐒴' => '𐓜'
	4498: {0x104B5, 0x104DD}, // '𐒵' => '𐓝'
	4495: {0x104B6, 0x104DE}, // '𐒶' => '𐓞'
	4492: {0x104B7, 0x104DF}, // '𐒷' => '𐓟'
	4489: {0x104B8, 0x104E0}, // '𐒸' => '𐓠'
	4486: {0x104B9, 0x104E1}, // '𐒹' => '𐓡'
	4483: {0x104BA, 0x104E2}, // '𐒺' => '𐓢'
	4480: {0x104BB, 0x104E3}, // '𐒻' => '𐓣'
	4477: {0x104BC, 0x104E4}, // '𐒼' => '𐓤'
	4474: {0x104BD, 0x104E5}, // '𐒽' => '𐓥'
	4471: {0x104BE, 0x104E6}, // '𐒾' => '𐓦'
	4468: {0x104BF, 0x104E7}, // '𐒿' => '𐓧'
	4465: {0x104C0, 0x104E8}, // '𐓀' => '𐓨'
	4462: {0x104C1, 0x104E9}, // '𐓁' => '𐓩'
	4459: {0x104C2, 0x104EA}, // '𐓂' => '𐓪'
	4456: {0x104C3, 0x104EB}, // '𐓃' => '𐓫'
	4453: {0x104C4, 0x104EC}, // '𐓄' => '𐓬'
	4450: {0x104C5, 0x104ED}, // '𐓅' => '𐓭'
	4447: {0x104C6, 0x104EE}, // '𐓆' => '𐓮'
	4444: {0x104C7, 0x104EF}, // '𐓇' => '𐓯'
	4441: {0x104C8, 0x104F0}, // '𐓈' => '𐓰'
	4438: {0x104C9, 0x104F1}, // '𐓉' => '𐓱'
	4435: {0x104CA, 0x104F2}, // '𐓊' => '𐓲'
	4432: {0x104CB, 0x104F3}, // '𐓋' => '𐓳'
	4429: {0x104CC, 0x104F4}, // '𐓌' => '𐓴'
	4426: {0x104CD, 0x104F5}, // '𐓍' => '𐓵'
	4423: {0x104CE, 0x104F6}, // '𐓎' => '𐓶'
	4420: {0x104CF, 0x104F7}, // '𐓏' => '𐓷'
	4417: {0x104D0, 0x104F8}, // '𐓐' => '𐓸'
	4414: {0x104D1, 0x104F9}, // '𐓑' => '𐓹'
	4411: {0x104D2, 0x104FA}, // '𐓒' => '𐓺'
	4408: {0x104D3, 0x104FB}, // '𐓓' => '𐓻'
	4393: {0x104B0, 0x104D8}, // '𐒰' => '𐓘'
	4390: {0x104B1, 0x104D9}, // '𐒱' => '𐓙'
	4387: {0x104B2, 0x104DA}, // '𐒲' => '𐓚'
	4384: {0x104B3, 0x104DB}, // '𐒳' => '𐓛'
	4381: {0x104B4, 0x104DC}, // '𐒴' => '𐓜'
	4378: {0x104B5, 0x104DD}, // '𐒵' => '𐓝'
	4375: {0x104B6, 0x104DE}, // '𐒶' => '𐓞'
	4372: {0x104B7, 0x104DF}, // '𐒷' => '𐓟'
	4369: {0x104B8, 0x104E0}, // '𐒸' => '𐓠'
	4366: {0x104B9, 0x104E1}, // '𐒹' => '𐓡'
	4363: {0x104BA, 0x104E2}, // '𐒺' => '𐓢'
	4360: {0x104BB, 0x104E3}, // '𐒻' => '𐓣'
	4357: {0x104BC, 0x104E4}, // '𐒼' => '𐓤'
	4354: {0x104BD, 0x104E5}, // '𐒽' => '𐓥'
	4351: {0x104BE, 0x104E6}, // '𐒾' => '𐓦'
	4348: {0x104BF, 0x104E7}, // '𐒿' => '𐓧'
	4345: {0x104C0, 0x104E8}, // '𐓀' => '𐓨'
	4342: {0x104C1, 0x104E9}, // '𐓁' => '𐓩'
	4339: {0x104C2, 0x104EA}, // '𐓂' => '𐓪'
	4336: {0x104C3, 0x104EB}, // '𐓃' => '𐓫'
	4333: {0x104C4, 0x104EC}, // '𐓄' => '𐓬'
	4330: {0x104C5, 0x104ED}, // '𐓅' => '𐓭'
	4327: {0x104C6, 0x104EE}, // '𐓆' => '𐓮'
	4324: {0x104C7, 0x104EF}, // '𐓇' => '𐓯'
	4321: {0x104C8, 0x104F0}, // '𐓈' => '𐓰'
	4318: {0x104C9, 0x104F1}, // '𐓉' => '𐓱'
	4315: {0x104CA, 0x104F2}, // '𐓊' => '𐓲'
	4312: {0x104CB, 0x104F3}, // '𐓋' => '𐓳'
	4309: {0x104CC, 0x104F4}, // '𐓌' => '𐓴'
	4306: {0x104CD, 0x104F5}, // '𐓍' => '𐓵'
	4303: {0x104CE, 0x104F6}, // '𐓎' => '𐓶'
	4300: {0x104CF, 0x104F7}, // '𐓏' => '𐓷'
	4297: {0x104D0, 0x104F8}, // '𐓐' => '𐓸'
	4294: {0x104D1, 0x104F9}, // '𐓑' => '𐓹'
	4291: {0x104D2, 0x104FA}, // '𐓒' => '𐓺'
	4288: {0x104D3, 0x104FB}, // '𐓓' => '𐓻'
	6702: {0x10C80, 0x10CC0}, // '𐲀' => '𐳀'
	6699: {0x10C81, 0x10CC1}, // '𐲁' => '𐳁'
	6696: {0x10C82, 0x10CC2}, // '𐲂' => '𐳂'
	6693: {0x10C83, 0x10CC3}, // '𐲃' => '𐳃'
	6690: {0x10C84, 0x10CC4}, // '𐲄' => '𐳄'
	6687: {0x10C85, 0x10CC5}, // '𐲅' => '𐳅'
	6684: {0x10C86, 0x10CC6}, // '𐲆' => '𐳆'
	6681: {0x10C87, 0x10CC7}, // '𐲇' => '𐳇'
	6678: {0x10C88, 0x10CC8}, // '𐲈' => '𐳈'
	6675: {0x10C89, 0x10CC9}, // '𐲉' => '𐳉'
	6672: {0x10C8A, 0x10CCA}, // '𐲊' => '𐳊'
	6669: {0x10C8B, 0x10CCB}, // '𐲋' => '𐳋'
	6666: {0x10C8C, 0x10CCC}, // '𐲌' => '𐳌'
	6663: {0x10C8D, 0x10CCD}, // '𐲍' => '𐳍'
	6660: {0x10C8E, 0x10CCE}, // '𐲎' => '𐳎'
	6657: {0x10C8F, 0x10CCF}, // '𐲏' => '𐳏'
	6654: {0x10C90, 0x10CD0}, // '𐲐' => '𐳐'
	6651: {0x10C91, 0x10CD1}, // '𐲑' => '𐳑'
	6648: {0x10C92, 0x10CD2}, // '𐲒' => '𐳒'
	6645: {0x10C93, 0x10CD3}, // '𐲓' => '𐳓'
	6642: {0x10C94, 0x10CD4}, // '𐲔' => '𐳔'
	6639: {0x10C95, 0x10CD5}, // '𐲕' => '𐳕'
	6636: {0x10C96, 0x10CD6}, // '𐲖' => '𐳖'
	6633: {0x10C97, 0x10CD7}, // '𐲗' => '𐳗'
	6630: {0x10C98, 0x10CD8}, // '𐲘' => '𐳘'
	6627: {0x10C99, 0x10CD9}, // '𐲙' => '𐳙'
	6624: {0x10C9A, 0x10CDA}, // '𐲚' => '𐳚'
	6621: {0x10C9B, 0x10CDB}, // '𐲛' => '𐳛'
	6618: {0x10C9C, 0x10CDC}, // '𐲜' => '𐳜'
	6615: {0x10C9D, 0x10CDD}, // '𐲝' => '𐳝'
	6612: {0x10C9E, 0x10CDE}, // '𐲞' => '𐳞'
	6609: {0x10C9F, 0x10CDF}, // '𐲟' => '𐳟'
	6606: {0x10CA0, 0x10CE0}, // '𐲠' => '𐳠'
	6603: {0x10CA1, 0x10CE1}, // '𐲡' => '𐳡'
	6600: {0x10CA2, 0x10CE2}, // '𐲢' => '𐳢'
	6597: {0x10CA3, 0x10CE3}, // '𐲣' => '𐳣'
	6594: {0x10CA4, 0x10CE4}, // '𐲤' => '𐳤'
	6591: {0x10CA5, 0x10CE5}, // '𐲥' => '𐳥'
	6588: {0x10CA6, 0x10CE6}, // '𐲦' => '𐳦'
	6585: {0x10CA7, 0x10CE7}, // '𐲧' => '𐳧'
	6582: {0x10CA8, 0x10CE8}, // '𐲨' => '𐳨'
	6579: {0x10CA9, 0x10CE9}, // '𐲩' => '𐳩'
	6576: {0x10CAA, 0x10CEA}, // '𐲪' => '𐳪'
	6573: {0x10CAB, 0x10CEB}, // '𐲫' => '𐳫'
	6570: {0x10CAC, 0x10CEC}, // '𐲬' => '𐳬'
	6567: {0x10CAD, 0x10CED}, // '𐲭' => '𐳭'
	6564: {0x10CAE, 0x10CEE}, // '𐲮' => '𐳮'
	6561: {0x10CAF, 0x10CEF}, // '𐲯' => '𐳯'
	6558: {0x10CB0, 0x10CF0}, // '𐲰' => '𐳰'
	6555: {0x10CB1, 0x10CF1}, // '𐲱' => '𐳱'
	6552: {0x10CB2, 0x10CF2}, // '𐲲' => '𐳲'
	6510: {0x10C80, 0x10CC0}, // '𐲀' => '𐳀'
	6507: {0x10C81, 0x10CC1}, // '𐲁' => '𐳁'
	6504: {0x10C82, 0x10CC2}, // '𐲂' => '𐳂'
	6501: {0x10C83, 0x10CC3}, // '𐲃' => '𐳃'
	6498: {0x10C84, 0x10CC4}, // '𐲄' => '𐳄'
	6495: {0x10C85, 0x10CC5}, // '𐲅' => '𐳅'
	6492: {0x10C86, 0x10CC6}, // '𐲆' => '𐳆'
	6489: {0x10C87, 0x10CC7}, // '𐲇' => '𐳇'
	6486: {0x10C88, 0x10CC8}, // '𐲈' => '𐳈'
	6483: {0x10C89, 0x10CC9}, // '𐲉' => '𐳉'
	6480: {0x10C8A, 0x10CCA}, // '𐲊' => '𐳊'
	6477: {0x10C8B, 0x10CCB}, // '𐲋' => '𐳋'
	6474: {0x10C8C, 0x10CCC}, // '𐲌' => '𐳌'
	6471: {0x10C8D, 0x10CCD}, // '𐲍' => '𐳍'
	6468: {0x10C8E, 0x10CCE}, // '𐲎' => '𐳎'
	6465: {0x10C8F, 0x10CCF}, // '𐲏' => '𐳏'
	6462: {0x10C90, 0x10CD0}, // '𐲐' => '𐳐'
	6459: {0x10C91, 0x10CD1}, // '𐲑' => '𐳑'
	6456: {0x10C92, 0x10CD2}, // '𐲒' => '𐳒'
	6453: {0x10C93, 0x10CD3}, // '𐲓' => '𐳓'
	6450: {0x10C94, 0x10CD4}, // '𐲔' => '𐳔'
	6447: {0x10C95, 0x10CD5}, // '𐲕' => '𐳕'
	6444: {0x10C96, 0x10CD6}, // '𐲖' => '𐳖'
	6441: {0x10C97, 0x10CD7}, // '𐲗' => '𐳗'
	6438: {0x10C98, 0x10CD8}, // '𐲘' => '𐳘'
	6435: {0x10C99, 0x10CD9}, // '𐲙' => '𐳙'
	6432: {0x10C9A, 0x10CDA}, // '𐲚' => '𐳚'
	6429: {0x10C9B, 0x10CDB}, // '𐲛' => '𐳛'
	6426: {0x10C9C, 0x10CDC}, // '𐲜' => '𐳜'
	6423: {0x10C9D, 0x10CDD}, // '𐲝' => '𐳝'
	6420: {0x10C9E, 0x10CDE}, // '𐲞' => '𐳞'
	6417: {0x10C9F, 0x10CDF}, // '𐲟' => '𐳟'
	6414: {0x10CA0, 0x10CE0}, // '𐲠' => '𐳠'
	6411: {0x10CA1, 0x10CE1}, // '𐲡' => '𐳡'
	6408: {0x10CA2, 0x10CE2}, // '𐲢' => '𐳢'
	6405: {0x10CA3, 0x10CE3}, // '𐲣' => '𐳣'
	6402: {0x10CA4, 0x10CE4}, // '𐲤' => '𐳤'
	6399: {0x10CA5, 0x10CE5}, // '𐲥' => '𐳥'
	6396: {0x10CA6, 0x10CE6}, // '𐲦' => '𐳦'
	6393: {0x10CA7, 0x10CE7}, // '𐲧' => '𐳧'
	6390: {0x10CA8, 0x10CE8}, // '𐲨' => '𐳨'
	6387: {0x10CA9, 0x10CE9}, // '𐲩' => '𐳩'
	6384: {0x10CAA, 0x10CEA}, // '𐲪' => '𐳪'
	6381: {0x10CAB, 0x10CEB}, // '𐲫' => '𐳫'
	6378: {0x10CAC, 0x10CEC}, // '𐲬' => '𐳬'
	6375: {0x10CAD, 0x10CED}, // '𐲭' => '𐳭'
	6372: {0x10CAE, 0x10CEE}, // '𐲮' => '𐳮'
	6369: {0x10CAF, 0x10CEF}, // '𐲯' => '𐳯'
	6366: {0x10CB0, 0x10CF0}, // '𐲰' => '𐳰'
	6363: {0x10CB1, 0x10CF1}, // '𐲱' => '𐳱'
	6360: {0x10CB2, 0x10CF2}, // '𐲲' => '𐳲'
	5579: {0x118A0, 0x118C0}, // '𑢠' => '𑣀'
	5576: {0x118A1, 0x118C1}, // '𑢡' => '𑣁'
	5573: {0x118A2, 0x118C2}, // '𑢢' => '𑣂'
	5570: {0x118A3, 0x118C3}, // '𑢣' => '𑣃'
	5567: {0x118A4, 0x118C4}, // '𑢤' => '𑣄'
	5564: {0x118A5, 0x118C5}, // '𑢥' => '𑣅'
	5561: {0x118A6, 0x118C6}, // '𑢦' => '𑣆'
	5558: {0x118A7, 0x118C7}, // '𑢧' => '𑣇'
	5555: {0x118A8, 0x118C8}, // '𑢨' => '𑣈'
	5552: {0x118A9, 0x118C9}, // '𑢩' => '𑣉'
	5549: {0x118AA, 0x118CA}, // '𑢪' => '𑣊'
	5546: {0x118AB, 0x118CB}, // '𑢫' => '𑣋'
	5543: {0x118AC, 0x118CC}, // '𑢬' => '𑣌'
	5540: {0x118AD, 0x118CD}, // '𑢭' => '𑣍'
	5537: {0x118AE, 0x118CE}, // '𑢮' => '𑣎'
	5534: {0x118AF, 0x118CF}, // '𑢯' => '𑣏'
	5531: {0x118B0, 0x118D0}, // '𑢰' => '𑣐'
	5528: {0x118B1, 0x118D1}, // '𑢱' => '𑣑'
	5525: {0x118B2, 0x118D2}, // '𑢲' => '𑣒'
	5522: {0x118B3, 0x118D3}, // '𑢳' => '𑣓'
	5519: {0x118B4, 0x118D4}, // '𑢴' => '𑣔'
	5516: {0x118B5, 0x118D5}, // '𑢵' => '𑣕'
	5513: {0x118B6, 0x118D6}, // '𑢶' => '𑣖'
	5510: {0x118B7, 0x118D7}, // '𑢷' => '𑣗'
	5507: {0x118B8, 0x118D8}, // '𑢸' => '𑣘'
	5504: {0x118B9, 0x118D9}, // '𑢹' => '𑣙'
	5501: {0x118BA, 0x118DA}, // '𑢺' => '𑣚'
	5498: {0x118BB, 0x118DB}, // '𑢻' => '𑣛'
	5495: {0x118BC, 0x118DC}, // '𑢼' => '𑣜'
	5492: {0x118BD, 0x118DD}, // '𑢽' => '𑣝'
	5489: {0x118BE, 0x118DE}, // '𑢾' => '𑣞'
	5486: {0x118BF, 0x118DF}, // '𑢿' => '𑣟'
	5483: {0x118A0, 0x118C0}, // '𑢠' => '𑣀'
	5480: {0x118A1, 0x118C1}, // '𑢡' => '𑣁'
	5477: {0x118A2, 0x118C2}, // '𑢢' => '𑣂'
	5474: {0x118A3, 0x118C3}, // '𑢣' => '𑣃'
	5471: {0x118A4, 0x118C4}, // '𑢤' => '𑣄'
	5468: {0x118A5, 0x118C5}, // '𑢥' => '𑣅'
	5465: {0x118A6, 0x118C6}, // '𑢦' => '𑣆'
	5462: {0x118A7, 0x118C7}, // '𑢧' => '𑣇'
	5459: {0x118A8, 0x118C8}, // '𑢨' => '𑣈'
	5456: {0x118A9, 0x118C9}, // '𑢩' => '𑣉'
	5453: {0x118AA, 0x118CA}, // '𑢪' => '𑣊'
	5450: {0x118AB, 0x118CB}, // '𑢫' => '𑣋'
	5447: {0x118AC, 0x118CC}, // '𑢬' => '𑣌'
	5444: {0x118AD, 0x118CD}, // '𑢭' => '𑣍'
	5441: {0x118AE, 0x118CE}, // '𑢮' => '𑣎'
	5438: {0x118AF, 0x118CF}, // '𑢯' => '𑣏'
	5435: {0x118B0, 0x118D0}, // '𑢰' => '𑣐'
	5432: {0x118B1, 0x118D1}, // '𑢱' => '𑣑'
	5429: {0x118B2, 0x118D2}, // '𑢲' => '𑣒'
	5426: {0x118B3, 0x118D3}, // '𑢳' => '𑣓'
	5423: {0x118B4, 0x118D4}, // '𑢴' => '𑣔'
	5420: {0x118B5, 0x118D5}, // '𑢵' => '𑣕'
	5417: {0x118B6, 0x118D6}, // '𑢶' => '𑣖'
	5414: {0x118B7, 0x118D7}, // '𑢷' => '𑣗'
	5411: {0x118B8, 0x118D8}, // '𑢸' => '𑣘'
	5408: {0x118B9, 0x118D9}, // '𑢹' => '𑣙'
	5405: {0x118BA, 0x118DA}, // '𑢺' => '𑣚'
	5402: {0x118BB, 0x118DB}, // '𑢻' => '𑣛'
	5399: {0x118BC, 0x118DC}, // '𑢼' => '𑣜'
	5396: {0x118BD, 0x118DD}, // '𑢽' => '𑣝'
	5393: {0x118BE, 0x118DE}, // '𑢾' => '𑣞'
	5390: {0x118BF, 0x118DF}, // '𑢿' => '𑣟'
	5329: {0x16E40, 0x16E60}, // '𖹀' => '𖹠'
	5326: {0x16E41, 0x16E61}, // '𖹁' => '𖹡'
	5323: {0x16E42, 0x16E62}, // '𖹂' => '𖹢'
	5320: {0x16E43, 0x16E63}, // '𖹃' => '𖹣'
	5317: {0x16E44, 0x16E64}, // '𖹄' => '𖹤'
	5314: {0x16E45, 0x16E65}, // '𖹅' => '𖹥'
	5311: {0x16E46, 0x16E66}, // '𖹆' => '𖹦'
	5308: {0x16E47, 0x16E67}, // '𖹇' => '𖹧'
	5305: {0x16E48, 0x16E68}, // '𖹈' => '𖹨'
	5302: {0x16E49, 0x16E69}, // '𖹉' => '𖹩'
	5299: {0x16E4A, 0x16E6A}, // '𖹊' => '𖹪'
	5296: {0x16E4B, 0x16E6B}, // '𖹋' => '𖹫'
	5293: {0x16E4C, 0x16E6C}, // '𖹌' => '𖹬'
	5290: {0x16E4D, 0x16E6D}, // '𖹍' => '𖹭'
	5287: {0x16E4E, 0x16E6E}, // '𖹎' => '𖹮'
	5284: {0x16E4F, 0x16E6F}, // '𖹏' => '𖹯'
	5281: {0x16E50, 0x16E70}, // '𖹐' => '𖹰'
	5278: {0x16E51, 0x16E71}, // '𖹑' => '𖹱'
	5275: {0x16E52, 0x16E72}, // '𖹒' => '𖹲'
	5272: {0x16E53, 0x16E73}, // '𖹓' => '𖹳'
	5269: {0x16E54, 0x16E74}, // '𖹔' => '𖹴'
	5266: {0x16E55, 0x16E75}, // '𖹕' => '𖹵'
	5263: {0x16E56, 0x16E76}, // '𖹖' => '𖹶'
	5260: {0x16E57, 0x16E77}, // '𖹗' => '𖹷'
	5257: {0x16E58, 0x16E78}, // '𖹘' => '𖹸'
	5254: {0x16E59, 0x16E79}, // '𖹙' => '𖹹'
	5251: {0x16E5A, 0x16E7A}, // '𖹚' => '𖹺'
	5248: {0x16E5B, 0x16E7B}, // '𖹛' => '𖹻'
	5245: {0x16E5C, 0x16E7C}, // '𖹜' => '𖹼'
	5242: {0x16E5D, 0x16E7D}, // '𖹝' => '𖹽'
	5239: {0x16E5E, 0x16E7E}, // '𖹞' => '𖹾'
	5236: {0x16E5F, 0x16E7F}, // '𖹟' => '𖹿'
	5233: {0x16E40, 0x16E60}, // '𖹀' => '𖹠'
	5230: {0x16E41, 0x16E61}, // '𖹁' => '𖹡'
	5227: {0x16E42, 0x16E62}, // '𖹂' => '𖹢'
	5224: {0x16E43, 0x16E63}, // '𖹃' => '𖹣'
	5221: {0x16E44, 0x16E64}, // '𖹄' => '𖹤'
	5218: {0x16E45, 0x16E65}, // '𖹅' => '𖹥'
	5215: {0x16E46, 0x16E66}, // '𖹆' => '𖹦'
	5212: {0x16E47, 0x16E67}, // '𖹇' => '𖹧'
	5209: {0x16E48, 0x16E68}, // '𖹈' => '𖹨'
	5206: {0x16E49, 0x16E69}, // '𖹉' => '𖹩'
	5203: {0x16E4A, 0x16E6A}, // '𖹊' => '𖹪'
	5200: {0x16E4B, 0x16E6B}, // '𖹋' => '𖹫'
	5197: {0x16E4C, 0x16E6C}, // '𖹌' => '𖹬'
	5194: {0x16E4D, 0x16E6D}, // '𖹍' => '𖹭'
	5191: {0x16E4E, 0x16E6E}, // '𖹎' => '𖹮'
	5188: {0x16E4F, 0x16E6F}, // '𖹏' => '𖹯'
	5185: {0x16E50, 0x16E70}, // '𖹐' => '𖹰'
	5182: {0x16E51, 0x16E71}, // '𖹑' => '𖹱'
	5179: {0x16E52, 0x16E72}, // '𖹒' => '𖹲'
	5176: {0x16E53, 0x16E73}, // '𖹓' => '𖹳'
	5173: {0x16E54, 0x16E74}, // '𖹔' => '𖹴'
	5170: {0x16E55, 0x16E75}, // '𖹕' => '𖹵'
	5167: {0x16E56, 0x16E76}, // '𖹖' => '𖹶'
	5164: {0x16E57, 0x16E77}, // '𖹗' => '𖹷'
	5161: {0x16E58, 0x16E78}, // '𖹘' => '𖹸'
	5158: {0x16E59, 0x16E79}, // '𖹙' => '𖹹'
	5155: {0x16E5A, 0x16E7A}, // '𖹚' => '𖹺'
	5152: {0x16E5B, 0x16E7B}, // '𖹛' => '𖹻'
	5149: {0x16E5C, 0x16E7C}, // '𖹜' => '𖹼'
	5146: {0x16E5D, 0x16E7D}, // '𖹝' => '𖹽'
	5143: {0x16E5E, 0x16E7E}, // '𖹞' => '𖹾'
	5140: {0x16E5F, 0x16E7F}, // '𖹟' => '𖹿'
	1132: {0x1E900, 0x1E922}, // '𞤀' => '𞤢'
	1129: {0x1E901, 0x1E923}, // '𞤁' => '𞤣'
	1126: {0x1E902, 0x1E924}, // '𞤂' => '𞤤'
	1123: {0x1E903, 0x1E925}, // '𞤃' => '𞤥'
	1120: {0x1E904, 0x1E926}, // '𞤄' => '𞤦'
	1117: {0x1E905, 0x1E927}, // '𞤅' => '𞤧'
	1114: {0x1E906, 0x1E928}, // '𞤆' => '𞤨'
	1111: {0x1E907, 0x1E929}, // '𞤇' => '𞤩'
	1108: {0x1E908, 0x1E92A}, // '𞤈' => '𞤪'
	1105: {0x1E909, 0x1E92B}, // '𞤉' => '𞤫'
	1102: {0x1E90A, 0x1E92C}, // '𞤊' => '𞤬'
	1099: {0x1E90B, 0x1E92D}, // '𞤋' => '𞤭'
	1096: {0x1E90C, 0x1E92E}, // '𞤌' => '𞤮'
	1093: {0x1E90D, 0x1E92F}, // '𞤍' => '𞤯'
	1090: {0x1E90E, 0x1E930}, // '𞤎' => '𞤰'
	1087: {0x1E90F, 0x1E931}, // '𞤏' => '𞤱'
	1084: {0x1E910, 0x1E932}, // '𞤐' => '𞤲'
	1081: {0x1E911, 0x1E933}, // '𞤑' => '𞤳'
	1078: {0x1E912, 0x1E934}, // '𞤒' => '𞤴'
	1075: {0x1E913, 0x1E935}, // '𞤓' => '𞤵'
	1072: {0x1E914, 0x1E936}, // '𞤔' => '𞤶'
	1069: {0x1E915, 0x1E937}, // '𞤕' => '𞤷'
	1066: {0x1E916, 0x1E938}, // '𞤖' => '𞤸'
	1063: {0x1E917, 0x1E939}, // '𞤗' => '𞤹'
	1060: {0x1E918, 0x1E93A}, // '𞤘' => '𞤺'
	1057: {0x1E919, 0x1E93B}, // '𞤙' => '𞤻'
	1054: {0x1E91A, 0x1E93C}, // '𞤚' => '𞤼'
	1051: {0x1E91B, 0x1E93D}, // '𞤛' => '𞤽'
	1048: {0x1E91C, 0x1E93E}, // '𞤜' => '𞤾'
	1045: {0x1E91D, 0x1E93F}, // '𞤝' => '𞤿'
	1042: {0x1E91E, 0x1E940}, // '𞤞' => '𞥀'
	1039: {0x1E91F, 0x1E941}, // '𞤟' => '𞥁'
	1036: {0x1E920, 0x1E942}, // '𞤠' => '𞥂'
	1033: {0x1E921, 0x1E943}, // '𞤡' => '𞥃'
	1030: {0x1E900, 0x1E922}, // '𞤀' => '𞤢'
	1027: {0x1E901, 0x1E923}, // '𞤁' => '𞤣'
	1024: {0x1E902, 0x1E924}, // '𞤂' => '𞤤'
	1021: {0x1E903, 0x1E925}, // '𞤃' => '𞤥'
	1018: {0x1E904, 0x1E926}, // '𞤄' => '𞤦'
	1015: {0x1E905, 0x1E927}, // '𞤅' => '𞤧'
	1012: {0x1E906, 0x1E928}, // '𞤆' => '𞤨'
	1009: {0x1E907, 0x1E929}, // '𞤇' => '𞤩'
	1006: {0x1E908, 0x1E92A}, // '𞤈' => '𞤪'
	1003: {0x1E909, 0x1E92B}, // '𞤉' => '𞤫'
	1000: {0x1E90A, 0x1E92C}, // '𞤊' => '𞤬'
	997:  {0x1E90B, 0x1E92D}, // '𞤋' => '𞤭'
	994:  {0x1E90C, 0x1E92E}, // '𞤌' => '𞤮'
	991:  {0x1E90D, 0x1E92F}, // '𞤍' => '𞤯'
	988:  {0x1E90E, 0x1E930}, // '𞤎' => '𞤰'
	985:  {0x1E90F, 0x1E931}, // '𞤏' => '𞤱'
	982:  {0x1E910, 0x1E932}, // '𞤐' => '𞤲'
	979:  {0x1E911, 0x1E933}, // '𞤑' => '𞤳'
	976:  {0x1E912, 0x1E934}, // '𞤒' => '𞤴'
	973:  {0x1E913, 0x1E935}, // '𞤓' => '𞤵'
	970:  {0x1E914, 0x1E936}, // '𞤔' => '𞤶'
	967:  {0x1E915, 0x1E937}, // '𞤕' => '𞤷'
	964:  {0x1E916, 0x1E938}, // '𞤖' => '𞤸'
	961:  {0x1E917, 0x1E939}, // '𞤗' => '𞤹'
	958:  {0x1E918, 0x1E93A}, // '𞤘' => '𞤺'
	955:  {0x1E919, 0x1E93B}, // '𞤙' => '𞤻'
	952:  {0x1E91A, 0x1E93C}, // '𞤚' => '𞤼'
	949:  {0x1E91B, 0x1E93D}, // '𞤛' => '𞤽'
	946:  {0x1E91C, 0x1E93E}, // '𞤜' => '𞤾'
	943:  {0x1E91D, 0x1E93F}, // '𞤝' => '𞤿'
	940:  {0x1E91E, 0x1E940}, // '𞤞' => '𞥀'
	937:  {0x1E91F, 0x1E941}, // '𞤟' => '𞥁'
	934:  {0x1E920, 0x1E942}, // '𞤠' => '𞥂'
	931:  {0x1E921, 0x1E943}, // '𞤡' => '𞥃'
}

// toUpperLowerSpecial returns the uppercase and lowercase form of r,
// which is a character that is not equal to either its uppercase or
// lowercase form and thus cannot be mapped into the _UpperLower table.
func toUpperLowerSpecial(r rune) (rune, rune, bool) {
	switch r {
	case 'ǅ':
		return 'Ǆ', 'ǆ', true
	case 'ǈ':
		return 'Ǉ', 'ǉ', true
	case 'ǋ':
		return 'Ǌ', 'ǌ', true
	case 'ǲ':
		return 'Ǳ', 'ǳ', true
	}
	return r, r, false
}

const _FoldMapSeed = 0x96480001
const _FoldMapShift = 24

// FoldMap stores the Unicode case-folds for characters that have two or more folds.
var _FoldMap = [256][4]uint16{
	7:   {0x004B, 0x006B, 0x212A},         // ['K' 'k' 'K']
	185: {0x0053, 0x0073, 0x017F},         // ['S' 's' 'ſ']
	208: {0x006B, 0x004B, 0x212A},         // ['k' 'K' 'K']
	130: {0x0073, 0x0053, 0x017F},         // ['s' 'S' 'ſ']
	64:  {0x00B5, 0x039C, 0x03BC},         // ['µ' 'Μ' 'μ']
	165: {0x00C5, 0x00E5, 0x212B},         // ['Å' 'å' 'Å']
	232: {0x00DF, 0x1E9E},                 // ['ß' 'ẞ']
	110: {0x00E5, 0x00C5, 0x212B},         // ['å' 'Å' 'Å']
	117: {0x0130},                         // ['İ']
	11:  {0x0131},                         // ['ı']
	213: {0x017F, 0x0053, 0x0073},         // ['ſ' 'S' 's']
	87:  {0x01C4, 0x01C5, 0x01C6},         // ['Ǆ' 'ǅ' 'ǆ']
	237: {0x01C5, 0x01C4, 0x01C6},         // ['ǅ' 'Ǆ' 'ǆ']
	131: {0x01C6, 0x01C4, 0x01C5},         // ['ǆ' 'Ǆ' 'ǅ']
	25:  {0x01C7, 0x01C8, 0x01C9},         // ['Ǉ' 'ǈ' 'ǉ']
	176: {0x01C8, 0x01C7, 0x01C9},         // ['ǈ' 'Ǉ' 'ǉ']
	70:  {0x01C9, 0x01C7, 0x01C8},         // ['ǉ' 'Ǉ' 'ǈ']
	220: {0x01CA, 0x01CB, 0x01CC},         // ['Ǌ' 'ǋ' 'ǌ']
	115: {0x01CB, 0x01CA, 0x01CC},         // ['ǋ' 'Ǌ' 'ǌ']
	9:   {0x01CC, 0x01CA, 0x01CB},         // ['ǌ' 'Ǌ' 'ǋ']
	193: {0x01F1, 0x01F2, 0x01F3},         // ['Ǳ' 'ǲ' 'ǳ']
	88:  {0x01F2, 0x01F1, 0x01F3},         // ['ǲ' 'Ǳ' 'ǳ']
	238: {0x01F3, 0x01F1, 0x01F2},         // ['ǳ' 'Ǳ' 'ǲ']
	89:  {0x0345, 0x0399, 0x03B9, 0x1FBE}, // ['ͅ' 'Ι' 'ι' 'ι']
	141: {0x0392, 0x03B2, 0x03D0},         // ['Β' 'β' 'ϐ']
	79:  {0x0395, 0x03B5, 0x03F5},         // ['Ε' 'ε' 'ϵ']
	18:  {0x0398, 0x03B8, 0x03D1, 0x03F4}, // ['Θ' 'θ' 'ϑ' 'ϴ']
	169: {0x0399, 0x0345, 0x03B9, 0x1FBE}, // ['Ι' 'ͅ' 'ι' 'ι']
	63:  {0x039A, 0x03BA, 0x03F0},         // ['Κ' 'κ' 'ϰ']
	107: {0x039C, 0x00B5, 0x03BC},         // ['Μ' 'µ' 'μ']
	197: {0x03A0, 0x03C0, 0x03D6},         // ['Π' 'π' 'ϖ']
	91:  {0x03A1, 0x03C1, 0x03F1},         // ['Ρ' 'ρ' 'ϱ']
	135: {0x03A3, 0x03C2, 0x03C3},         // ['Σ' 'ς' 'σ']
	74:  {0x03A6, 0x03C6, 0x03D5},         // ['Φ' 'φ' 'ϕ']
	13:  {0x03A9, 0x03C9, 0x2126},         // ['Ω' 'ω' 'Ω']
	86:  {0x03B2, 0x0392, 0x03D0},         // ['β' 'Β' 'ϐ']
	24:  {0x03B5, 0x0395, 0x03F5},         // ['ε' 'Ε' 'ϵ']
	219: {0x03B8, 0x0398, 0x03D1, 0x03F4}, // ['θ' 'Θ' 'ϑ' 'ϴ']
	114: {0x03B9, 0x0345, 0x0399, 0x1FBE}, // ['ι' 'ͅ' 'Ι' 'ι']
	8:   {0x03BA, 0x039A, 0x03F0},         // ['κ' 'Κ' 'ϰ']
	52:  {0x03BC, 0x00B5, 0x039C},         // ['μ' 'µ' 'Μ']
	142: {0x03C0, 0x03A0, 0x03D6},         // ['π' 'Π' 'ϖ']
	36:  {0x03C1, 0x03A1, 0x03F1},         // ['ρ' 'Ρ' 'ϱ']
	186: {0x03C2, 0x03A3, 0x03C3},         // ['ς' 'Σ' 'σ']
	80:  {0x03C3, 0x03A3, 0x03C2},         // ['σ' 'Σ' 'ς']
	19:  {0x03C6, 0x03A6, 0x03D5},         // ['φ' 'Φ' 'ϕ']
	214: {0x03C9, 0x03A9, 0x2126},         // ['ω' 'Ω' 'Ω']
	242: {0x03D0, 0x0392, 0x03B2},         // ['ϐ' 'Β' 'β']
	136: {0x03D1, 0x0398, 0x03B8, 0x03F4}, // ['ϑ' 'Θ' 'θ' 'ϴ']
	225: {0x03D5, 0x03A6, 0x03C6},         // ['ϕ' 'Φ' 'φ']
	120: {0x03D6, 0x03A0, 0x03C0},         // ['ϖ' 'Π' 'π']
	187: {0x03F0, 0x039A, 0x03BA},         // ['ϰ' 'Κ' 'κ']
	81:  {0x03F1, 0x03A1, 0x03C1},         // ['ϱ' 'Ρ' 'ρ']
	20:  {0x03F4, 0x0398, 0x03B8, 0x03D1}, // ['ϴ' 'Θ' 'θ' 'ϑ']
	170: {0x03F5, 0x0395, 0x03B5},         // ['ϵ' 'Ε' 'ε']
	177: {0x0412, 0x0432, 0x1C80},         // ['В' 'в' 'ᲀ']
	221: {0x0414, 0x0434, 0x1C81},         // ['Д' 'д' 'ᲁ']
	188: {0x041E, 0x043E, 0x1C82},         // ['О' 'о' 'ᲂ']
	127: {0x0421, 0x0441, 0x1C83},         // ['С' 'с' 'ᲃ']
	21:  {0x0422, 0x0442, 0x1C84, 0x1C85}, // ['Т' 'т' 'ᲄ' 'ᲅ']
	199: {0x042A, 0x044A, 0x1C86},         // ['Ъ' 'ъ' 'ᲆ']
	122: {0x0432, 0x0412, 0x1C80},         // ['в' 'В' 'ᲀ']
	166: {0x0434, 0x0414, 0x1C81},         // ['д' 'Д' 'ᲁ']
	133: {0x043E, 0x041E, 0x1C82},         // ['о' 'О' 'ᲂ']
	72:  {0x0441, 0x0421, 0x1C83},         // ['с' 'С' 'ᲃ']
	222: {0x0442, 0x0422, 0x1C84, 0x1C85}, // ['т' 'Т' 'ᲄ' 'ᲅ']
	144: {0x044A, 0x042A, 0x1C86},         // ['ъ' 'Ъ' 'ᲆ']
	167: {0x0462, 0x0463, 0x1C87},         // ['Ѣ' 'ѣ' 'ᲇ']
	61:  {0x0463, 0x0462, 0x1C87},         // ['ѣ' 'Ѣ' 'ᲇ']
	4:   {0x1C80, 0x0412, 0x0432},         // ['ᲀ' 'В' 'в']
	154: {0x1C81, 0x0414, 0x0434},         // ['ᲁ' 'Д' 'д']
	48:  {0x1C82, 0x041E, 0x043E},         // ['ᲂ' 'О' 'о']
	198: {0x1C83, 0x0421, 0x0441},         // ['ᲃ' 'С' 'с']
	93:  {0x1C84, 0x0422, 0x0442, 0x1C85}, // ['ᲄ' 'Т' 'т' 'ᲅ']
	243: {0x1C85, 0x0422, 0x0442, 0x1C84}, // ['ᲅ' 'Т' 'т' 'ᲄ']
	137: {0x1C86, 0x042A, 0x044A},         // ['ᲆ' 'Ъ' 'ъ']
	31:  {0x1C87, 0x0462, 0x0463},         // ['ᲇ' 'Ѣ' 'ѣ']
	182: {0x1C88, 0xA64A, 0xA64B},         // ['ᲈ' 'Ꙋ' 'ꙋ']
	203: {0x1E60, 0x1E61, 0x1E9B},         // ['Ṡ' 'ṡ' 'ẛ']
	97:  {0x1E61, 0x1E60, 0x1E9B},         // ['ṡ' 'Ṡ' 'ẛ']
	109: {0x1E9B, 0x1E60, 0x1E61},         // ['ẛ' 'Ṡ' 'ṡ']
	65:  {0x1FBE, 0x0345, 0x0399, 0x03B9}, // ['ι' 'ͅ' 'Ι' 'ι']
	150: {0x2126, 0x03A9, 0x03C9},         // ['Ω' 'Ω' 'ω']
	239: {0x212A, 0x004B, 0x006B},         // ['K' 'K' 'k']
	134: {0x212B, 0x00C5, 0x00E5},         // ['Å' 'Å' 'å']
	32:  {0xA64A, 0x1C88, 0xA64B},         // ['Ꙋ' 'ᲈ' 'ꙋ']
	183: {0xA64B, 0x1C88, 0xA64A},         // ['ꙋ' 'ᲈ' 'Ꙋ']
}

const _FoldMapExcludingUpperLowerSeed = 0x96480001
const _FoldMapExcludingUpperLowerShift = 24

// _FoldMapExcludingUpperLower stores the Unicode case-folds for charactecrs that
// have two or more folds, but excludes the uppercase and lowercase forms of the
// character.
var _FoldMapExcludingUpperLower = [256]struct {
	r uint16
	a [2]uint16
}{
	7:   {0x004B, [2]uint16{0x212A, 0x212A}}, // 'K': ['K', 'K']
	185: {0x0053, [2]uint16{0x017F, 0x017F}}, // 'S': ['ſ', 'ſ']
	208: {0x006B, [2]uint16{0x212A, 0x212A}}, // 'k': ['K', 'K']
	130: {0x0073, [2]uint16{0x017F, 0x017F}}, // 's': ['ſ', 'ſ']
	64:  {0x00B5, [2]uint16{0x03BC, 0x03BC}}, // 'µ': ['μ', 'μ']
	165: {0x00C5, [2]uint16{0x212B, 0x212B}}, // 'Å': ['Å', 'Å']
	232: {0x00DF, [2]uint16{0x1E9E, 0x1E9E}}, // 'ß': ['ẞ', 'ẞ']
	110: {0x00E5, [2]uint16{0x212B, 0x212B}}, // 'å': ['Å', 'Å']
	117: {0x0130, [2]uint16{0x0130, 0x0130}}, // 'İ': ['İ', 'İ']
	11:  {0x0131, [2]uint16{0x0131, 0x0131}}, // 'ı': ['ı', 'ı']
	213: {0x017F, [2]uint16{0x0073, 0x0073}}, // 'ſ': ['s', 's']
	87:  {0x01C4, [2]uint16{0x01C5, 0x01C5}}, // 'Ǆ': ['ǅ', 'ǅ']
	237: {0x01C5, [2]uint16{0x01C5, 0x01C5}}, // 'ǅ': ['ǅ', 'ǅ']
	131: {0x01C6, [2]uint16{0x01C5, 0x01C5}}, // 'ǆ': ['ǅ', 'ǅ']
	25:  {0x01C7, [2]uint16{0x01C8, 0x01C8}}, // 'Ǉ': ['ǈ', 'ǈ']
	176: {0x01C8, [2]uint16{0x01C8, 0x01C8}}, // 'ǈ': ['ǈ', 'ǈ']
	70:  {0x01C9, [2]uint16{0x01C8, 0x01C8}}, // 'ǉ': ['ǈ', 'ǈ']
	220: {0x01CA, [2]uint16{0x01CB, 0x01CB}}, // 'Ǌ': ['ǋ', 'ǋ']
	115: {0x01CB, [2]uint16{0x01CB, 0x01CB}}, // 'ǋ': ['ǋ', 'ǋ']
	9:   {0x01CC, [2]uint16{0x01CB, 0x01CB}}, // 'ǌ': ['ǋ', 'ǋ']
	193: {0x01F1, [2]uint16{0x01F2, 0x01F2}}, // 'Ǳ': ['ǲ', 'ǲ']
	88:  {0x01F2, [2]uint16{0x01F2, 0x01F2}}, // 'ǲ': ['ǲ', 'ǲ']
	238: {0x01F3, [2]uint16{0x01F2, 0x01F2}}, // 'ǳ': ['ǲ', 'ǲ']
	89:  {0x0345, [2]uint16{0x03B9, 0x1FBE}}, // 'ͅ': ['ι', 'ι']
	141: {0x0392, [2]uint16{0x03D0, 0x03D0}}, // 'Β': ['ϐ', 'ϐ']
	79:  {0x0395, [2]uint16{0x03F5, 0x03F5}}, // 'Ε': ['ϵ', 'ϵ']
	18:  {0x0398, [2]uint16{0x03D1, 0x03F4}}, // 'Θ': ['ϑ', 'ϴ']
	169: {0x0399, [2]uint16{0x0345, 0x1FBE}}, // 'Ι': ['ͅ', 'ι']
	63:  {0x039A, [2]uint16{0x03F0, 0x03F0}}, // 'Κ': ['ϰ', 'ϰ']
	107: {0x039C, [2]uint16{0x00B5, 0x00B5}}, // 'Μ': ['µ', 'µ']
	197: {0x03A0, [2]uint16{0x03D6, 0x03D6}}, // 'Π': ['ϖ', 'ϖ']
	91:  {0x03A1, [2]uint16{0x03F1, 0x03F1}}, // 'Ρ': ['ϱ', 'ϱ']
	135: {0x03A3, [2]uint16{0x03C2, 0x03C2}}, // 'Σ': ['ς', 'ς']
	74:  {0x03A6, [2]uint16{0x03D5, 0x03D5}}, // 'Φ': ['ϕ', 'ϕ']
	13:  {0x03A9, [2]uint16{0x2126, 0x2126}}, // 'Ω': ['Ω', 'Ω']
	86:  {0x03B2, [2]uint16{0x03D0, 0x03D0}}, // 'β': ['ϐ', 'ϐ']
	24:  {0x03B5, [2]uint16{0x03F5, 0x03F5}}, // 'ε': ['ϵ', 'ϵ']
	219: {0x03B8, [2]uint16{0x03D1, 0x03F4}}, // 'θ': ['ϑ', 'ϴ']
	114: {0x03B9, [2]uint16{0x0345, 0x1FBE}}, // 'ι': ['ͅ', 'ι']
	8:   {0x03BA, [2]uint16{0x03F0, 0x03F0}}, // 'κ': ['ϰ', 'ϰ']
	52:  {0x03BC, [2]uint16{0x00B5, 0x00B5}}, // 'μ': ['µ', 'µ']
	142: {0x03C0, [2]uint16{0x03D6, 0x03D6}}, // 'π': ['ϖ', 'ϖ']
	36:  {0x03C1, [2]uint16{0x03F1, 0x03F1}}, // 'ρ': ['ϱ', 'ϱ']
	186: {0x03C2, [2]uint16{0x03C3, 0x03C3}}, // 'ς': ['σ', 'σ']
	80:  {0x03C3, [2]uint16{0x03C2, 0x03C2}}, // 'σ': ['ς', 'ς']
	19:  {0x03C6, [2]uint16{0x03D5, 0x03D5}}, // 'φ': ['ϕ', 'ϕ']
	214: {0x03C9, [2]uint16{0x2126, 0x2126}}, // 'ω': ['Ω', 'Ω']
	242: {0x03D0, [2]uint16{0x03B2, 0x03B2}}, // 'ϐ': ['β', 'β']
	136: {0x03D1, [2]uint16{0x03B8, 0x03F4}}, // 'ϑ': ['θ', 'ϴ']
	225: {0x03D5, [2]uint16{0x03C6, 0x03C6}}, // 'ϕ': ['φ', 'φ']
	120: {0x03D6, [2]uint16{0x03C0, 0x03C0}}, // 'ϖ': ['π', 'π']
	187: {0x03F0, [2]uint16{0x03BA, 0x03BA}}, // 'ϰ': ['κ', 'κ']
	81:  {0x03F1, [2]uint16{0x03C1, 0x03C1}}, // 'ϱ': ['ρ', 'ρ']
	20:  {0x03F4, [2]uint16{0x0398, 0x03D1}}, // 'ϴ': ['Θ', 'ϑ']
	170: {0x03F5, [2]uint16{0x03B5, 0x03B5}}, // 'ϵ': ['ε', 'ε']
	177: {0x0412, [2]uint16{0x1C80, 0x1C80}}, // 'В': ['ᲀ', 'ᲀ']
	221: {0x0414, [2]uint16{0x1C81, 0x1C81}}, // 'Д': ['ᲁ', 'ᲁ']
	188: {0x041E, [2]uint16{0x1C82, 0x1C82}}, // 'О': ['ᲂ', 'ᲂ']
	127: {0x0421, [2]uint16{0x1C83, 0x1C83}}, // 'С': ['ᲃ', 'ᲃ']
	21:  {0x0422, [2]uint16{0x1C84, 0x1C85}}, // 'Т': ['ᲄ', 'ᲅ']
	199: {0x042A, [2]uint16{0x1C86, 0x1C86}}, // 'Ъ': ['ᲆ', 'ᲆ']
	122: {0x0432, [2]uint16{0x1C80, 0x1C80}}, // 'в': ['ᲀ', 'ᲀ']
	166: {0x0434, [2]uint16{0x1C81, 0x1C81}}, // 'д': ['ᲁ', 'ᲁ']
	133: {0x043E, [2]uint16{0x1C82, 0x1C82}}, // 'о': ['ᲂ', 'ᲂ']
	72:  {0x0441, [2]uint16{0x1C83, 0x1C83}}, // 'с': ['ᲃ', 'ᲃ']
	222: {0x0442, [2]uint16{0x1C84, 0x1C85}}, // 'т': ['ᲄ', 'ᲅ']
	144: {0x044A, [2]uint16{0x1C86, 0x1C86}}, // 'ъ': ['ᲆ', 'ᲆ']
	167: {0x0462, [2]uint16{0x1C87, 0x1C87}}, // 'Ѣ': ['ᲇ', 'ᲇ']
	61:  {0x0463, [2]uint16{0x1C87, 0x1C87}}, // 'ѣ': ['ᲇ', 'ᲇ']
	4:   {0x1C80, [2]uint16{0x0432, 0x0432}}, // 'ᲀ': ['в', 'в']
	154: {0x1C81, [2]uint16{0x0434, 0x0434}}, // 'ᲁ': ['д', 'д']
	48:  {0x1C82, [2]uint16{0x043E, 0x043E}}, // 'ᲂ': ['о', 'о']
	198: {0x1C83, [2]uint16{0x0441, 0x0441}}, // 'ᲃ': ['с', 'с']
	93:  {0x1C84, [2]uint16{0x0442, 0x1C85}}, // 'ᲄ': ['т', 'ᲅ']
	243: {0x1C85, [2]uint16{0x0442, 0x1C84}}, // 'ᲅ': ['т', 'ᲄ']
	137: {0x1C86, [2]uint16{0x044A, 0x044A}}, // 'ᲆ': ['ъ', 'ъ']
	31:  {0x1C87, [2]uint16{0x0463, 0x0463}}, // 'ᲇ': ['ѣ', 'ѣ']
	182: {0x1C88, [2]uint16{0xA64B, 0xA64B}}, // 'ᲈ': ['ꙋ', 'ꙋ']
	203: {0x1E60, [2]uint16{0x1E9B, 0x1E9B}}, // 'Ṡ': ['ẛ', 'ẛ']
	97:  {0x1E61, [2]uint16{0x1E9B, 0x1E9B}}, // 'ṡ': ['ẛ', 'ẛ']
	109: {0x1E9B, [2]uint16{0x1E61, 0x1E61}}, // 'ẛ': ['ṡ', 'ṡ']
	65:  {0x1FBE, [2]uint16{0x0345, 0x03B9}}, // 'ι': ['ͅ', 'ι']
	150: {0x2126, [2]uint16{0x03A9, 0x03A9}}, // 'Ω': ['Ω', 'Ω']
	239: {0x212A, [2]uint16{0x004B, 0x004B}}, // 'K': ['K', 'K']
	134: {0x212B, [2]uint16{0x00C5, 0x00C5}}, // 'Å': ['Å', 'Å']
	32:  {0xA64A, [2]uint16{0x1C88, 0x1C88}}, // 'Ꙋ': ['ᲈ', 'ᲈ']
	183: {0xA64B, [2]uint16{0x1C88, 0x1C88}}, // 'ꙋ': ['ᲈ', 'ᲈ']
}
