<!-- THIS PART OF THIS FILE IS AUTOGENERATED. DO NOT MODIFY IT. See scripts/generate_docs.sh -->




# attachp

## Description


Attaches to a given pid, process name, process found with partial argv match or to a device file.

This command wraps the original GDB `attach` command to add the ability
to debug a process with a given name or partial name match. In such cases,
the process identifier is fetched via the `pidof <name>` command first. If no
matches are found, then it uses the `ps -eo pid,args` command to search for
partial name matches.

Original GDB attach command help:
    Attach to a process or file outside of GDB.
    This command attaches to another target, of the same type as your last
    "target" command ("info files" will show your target stack).
    The command may take as argument a process id or a device file.
    For a process id, you must have permission to send the process a signal,
    and it must have the same effective uid as the debugger.
    When using "attach" with a process id, the debugger finds the
    program running in the process, looking first in the current working
    directory, or (if not found there) using the source file search path
    (see the "directory" command).  You can also use the "file" command
    to specify the program, and to load its symbol table.
## Usage:


```bash
usage: attachp [-h] [--no-truncate] [--retry] [--user USER] [-e] [-a] [target]

```
## Positional Arguments

|Positional Argument|Help|
| :--- | :--- |
|`target`|pid, process name, part of cmdline to be matched or device file to attach to (uses current loaded file name if not provided)|

## Optional Arguments

|Short|Long|Default|Help|
| :--- | :--- | :--- | :--- |
|`-h`|`--help`||show this help message and exit|
||`--no-truncate`||dont truncate command args (default: %(default)s)|
||`--retry`||retry until a target is found (default: %(default)s)|
||`--user`|`None`|username or uid to filter by|
|`-e`|`--exact`||get the pid only for an exact command name match (default: %(default)s)|
|`-a`|`--all`||get pids also for partial cmdline matches etc (default: %(default)s)|

<!-- END OF AUTOGENERATED PART. Do not modify this line or the line below, they mark the end of the auto-generated part of the file. If you want to extend the documentation in a way which cannot easily be done by adding to the command help description, write below the following line. -->
<!-- ------------\>8---- ----\>8---- ----\>8------------ -->
