package codeup

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateMergeRequestSetting invokes the codeup.UpdateMergeRequestSetting API synchronously
func (client *Client) UpdateMergeRequestSetting(request *UpdateMergeRequestSettingRequest) (response *UpdateMergeRequestSettingResponse, err error) {
	response = CreateUpdateMergeRequestSettingResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateMergeRequestSettingWithChan invokes the codeup.UpdateMergeRequestSetting API asynchronously
func (client *Client) UpdateMergeRequestSettingWithChan(request *UpdateMergeRequestSettingRequest) (<-chan *UpdateMergeRequestSettingResponse, <-chan error) {
	responseChan := make(chan *UpdateMergeRequestSettingResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateMergeRequestSetting(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateMergeRequestSettingWithCallback invokes the codeup.UpdateMergeRequestSetting API asynchronously
func (client *Client) UpdateMergeRequestSettingWithCallback(request *UpdateMergeRequestSettingRequest, callback func(response *UpdateMergeRequestSettingResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateMergeRequestSettingResponse
		var err error
		defer close(result)
		response, err = client.UpdateMergeRequestSetting(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateMergeRequestSettingRequest is the request struct for api UpdateMergeRequestSetting
type UpdateMergeRequestSettingRequest struct {
	*requests.RoaRequest
	OrganizationId string           `position:"Query" name:"OrganizationId"`
	AccessToken    string           `position:"Query" name:"AccessToken"`
	ProjectId      requests.Integer `position:"Path" name:"ProjectId"`
}

// UpdateMergeRequestSettingResponse is the response struct for api UpdateMergeRequestSetting
type UpdateMergeRequestSettingResponse struct {
	*responses.BaseResponse
	ErrorCode    string `json:"ErrorCode" xml:"ErrorCode"`
	ErrorMessage string `json:"ErrorMessage" xml:"ErrorMessage"`
	RequestId    string `json:"RequestId" xml:"RequestId"`
	Success      bool   `json:"Success" xml:"Success"`
	Result       Result `json:"Result" xml:"Result"`
}

// CreateUpdateMergeRequestSettingRequest creates a request to invoke UpdateMergeRequestSetting API
func CreateUpdateMergeRequestSettingRequest() (request *UpdateMergeRequestSettingRequest) {
	request = &UpdateMergeRequestSettingRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("codeup", "2020-04-14", "UpdateMergeRequestSetting", "/api/v4/projects/[ProjectId]/settings/merge_requests", "", "")
	request.Method = requests.PUT
	return
}

// CreateUpdateMergeRequestSettingResponse creates a response to parse from UpdateMergeRequestSetting response
func CreateUpdateMergeRequestSettingResponse() (response *UpdateMergeRequestSettingResponse) {
	response = &UpdateMergeRequestSettingResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
