package rtc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeChannelUsers invokes the rtc.DescribeChannelUsers API synchronously
func (client *Client) DescribeChannelUsers(request *DescribeChannelUsersRequest) (response *DescribeChannelUsersResponse, err error) {
	response = CreateDescribeChannelUsersResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeChannelUsersWithChan invokes the rtc.DescribeChannelUsers API asynchronously
func (client *Client) DescribeChannelUsersWithChan(request *DescribeChannelUsersRequest) (<-chan *DescribeChannelUsersResponse, <-chan error) {
	responseChan := make(chan *DescribeChannelUsersResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeChannelUsers(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeChannelUsersWithCallback invokes the rtc.DescribeChannelUsers API asynchronously
func (client *Client) DescribeChannelUsersWithCallback(request *DescribeChannelUsersRequest, callback func(response *DescribeChannelUsersResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeChannelUsersResponse
		var err error
		defer close(result)
		response, err = client.DescribeChannelUsers(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeChannelUsersRequest is the request struct for api DescribeChannelUsers
type DescribeChannelUsersRequest struct {
	*requests.RpcRequest
	ShowLog   string           `position:"Query" name:"ShowLog"`
	OwnerId   requests.Integer `position:"Query" name:"OwnerId"`
	AppId     string           `position:"Query" name:"AppId"`
	ChannelId string           `position:"Query" name:"ChannelId"`
}

// DescribeChannelUsersResponse is the response struct for api DescribeChannelUsers
type DescribeChannelUsersResponse struct {
	*responses.BaseResponse
	CommTotalNum        int      `json:"CommTotalNum" xml:"CommTotalNum"`
	RequestId           string   `json:"RequestId" xml:"RequestId"`
	IsChannelExist      bool     `json:"IsChannelExist" xml:"IsChannelExist"`
	LiveUserNum         int      `json:"LiveUserNum" xml:"LiveUserNum"`
	Timestamp           int      `json:"Timestamp" xml:"Timestamp"`
	ChannelProfile      int      `json:"ChannelProfile" xml:"ChannelProfile"`
	InteractiveUserNum  int      `json:"InteractiveUserNum" xml:"InteractiveUserNum"`
	UserList            []string `json:"UserList" xml:"UserList"`
	InteractiveUserList []string `json:"InteractiveUserList" xml:"InteractiveUserList"`
	LiveUserList        []string `json:"LiveUserList" xml:"LiveUserList"`
}

// CreateDescribeChannelUsersRequest creates a request to invoke DescribeChannelUsers API
func CreateDescribeChannelUsersRequest() (request *DescribeChannelUsersRequest) {
	request = &DescribeChannelUsersRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("rtc", "2018-01-11", "DescribeChannelUsers", "", "")
	request.Method = requests.POST
	return
}

// CreateDescribeChannelUsersResponse creates a response to parse from DescribeChannelUsers response
func CreateDescribeChannelUsersResponse() (response *DescribeChannelUsersResponse) {
	response = &DescribeChannelUsersResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
