/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.floats;

import it.unimi.dsi.fastutil.floats.FloatArrays;
import it.unimi.dsi.fastutil.floats.FloatCollection;
import it.unimi.dsi.fastutil.floats.FloatConsumer;
import it.unimi.dsi.fastutil.floats.FloatImmutableList;
import it.unimi.dsi.fastutil.floats.FloatIterator;
import it.unimi.dsi.fastutil.floats.FloatIterators;
import it.unimi.dsi.fastutil.floats.FloatList;
import it.unimi.dsi.fastutil.floats.FloatListIterator;
import it.unimi.dsi.fastutil.floats.FloatLists;
import it.unimi.dsi.fastutil.floats.FloatSpliterator;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.RandomAccess;

public class FloatImmutableList
extends FloatLists.ImmutableListBase
implements FloatList,
RandomAccess,
Cloneable,
Serializable {
    private static final long serialVersionUID = 0L;
    static final FloatImmutableList EMPTY = new FloatImmutableList(FloatArrays.EMPTY_ARRAY);
    private final float[] a;

    public FloatImmutableList(float[] a) {
        this.a = a;
    }

    public FloatImmutableList(Collection<? extends Float> c) {
        this(c.isEmpty() ? FloatArrays.EMPTY_ARRAY : FloatIterators.unwrap(FloatIterators.asFloatIterator(c.iterator())));
    }

    public FloatImmutableList(FloatCollection c) {
        this(c.isEmpty() ? FloatArrays.EMPTY_ARRAY : FloatIterators.unwrap(c.iterator()));
    }

    public FloatImmutableList(FloatList l) {
        this(l.isEmpty() ? FloatArrays.EMPTY_ARRAY : new float[l.size()]);
        l.getElements(0, this.a, 0, l.size());
    }

    public FloatImmutableList(float[] a, int offset, int length) {
        this(length == 0 ? FloatArrays.EMPTY_ARRAY : new float[length]);
        System.arraycopy(a, offset, this.a, 0, length);
    }

    public FloatImmutableList(FloatIterator i) {
        this(i.hasNext() ? FloatIterators.unwrap(i) : FloatArrays.EMPTY_ARRAY);
    }

    public static FloatImmutableList of() {
        return EMPTY;
    }

    public static FloatImmutableList of(float ... init) {
        return init.length == 0 ? FloatImmutableList.of() : new FloatImmutableList(init);
    }

    @Override
    public float getFloat(int index) {
        if (index >= this.a.length) {
            throw new IndexOutOfBoundsException("Index (" + index + ") is greater than or equal to list size (" + this.a.length + ")");
        }
        return this.a[index];
    }

    @Override
    public int indexOf(float k) {
        float[] a = this.a;
        int size = a.length;
        for (int i = 0; i < size; ++i) {
            if (Float.floatToIntBits(k) != Float.floatToIntBits(a[i])) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int lastIndexOf(float k) {
        float[] a = this.a;
        int i = a.length;
        while (i-- != 0) {
            if (Float.floatToIntBits(k) != Float.floatToIntBits(a[i])) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int size() {
        return this.a.length;
    }

    @Override
    public boolean isEmpty() {
        return this.a.length == 0;
    }

    @Override
    public void getElements(int from, float[] a, int offset, int length) {
        FloatArrays.ensureOffsetLength(a, offset, length);
        System.arraycopy(this.a, from, a, offset, length);
    }

    @Override
    public void forEach(FloatConsumer action) {
        float[] a = this.a;
        for (int i = 0; i < a.length; ++i) {
            action.accept(a[i]);
        }
    }

    @Override
    public float[] toFloatArray() {
        if (this.a.length == 0) {
            return FloatArrays.EMPTY_ARRAY;
        }
        return (float[])this.a.clone();
    }

    @Override
    public float[] toArray(float[] a) {
        if (a == null || a.length < this.size()) {
            a = new float[this.a.length];
        }
        System.arraycopy(this.a, 0, a, 0, a.length);
        return a;
    }

    @Override
    public FloatListIterator listIterator(int index) {
        this.ensureIndex(index);
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    @Override
    public FloatSpliterator spliterator() {
        return new Spliterator(this);
    }

    @Override
    public FloatList subList(int from, int to) {
        if (from == 0 && to == this.size()) {
            return this;
        }
        this.ensureIndex(from);
        this.ensureIndex(to);
        if (from == to) {
            return EMPTY;
        }
        if (from > to) {
            throw new IllegalArgumentException("Start index (" + from + ") is greater than end index (" + to + ")");
        }
        return new ImmutableSubList(this, from, to);
    }

    public FloatImmutableList clone() {
        return this;
    }

    public boolean equals(FloatImmutableList l) {
        if (l == this) {
            return true;
        }
        if (this.a == l.a) {
            return true;
        }
        int s = this.size();
        if (s != l.size()) {
            return false;
        }
        float[] a1 = this.a;
        float[] a2 = l.a;
        return Arrays.equals(a1, a2);
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (!(o instanceof List)) {
            return false;
        }
        if (o instanceof FloatImmutableList) {
            return this.equals((FloatImmutableList)o);
        }
        if (o instanceof ImmutableSubList) {
            return ((ImmutableSubList)o).equals((Object)this);
        }
        return super.equals(o);
    }

    @Override
    public int compareTo(FloatImmutableList l) {
        int i;
        if (this.a == l.a) {
            return 0;
        }
        int s1 = this.size();
        int s2 = l.size();
        float[] a1 = this.a;
        float[] a2 = l.a;
        for (i = 0; i < s1 && i < s2; ++i) {
            float e1 = a1[i];
            float e2 = a2[i];
            int r = Float.compare(e1, e2);
            if (r == 0) continue;
            return r;
        }
        return i < s2 ? -1 : (i < s1 ? 1 : 0);
    }

    @Override
    public int compareTo(List<? extends Float> l) {
        if (l instanceof FloatImmutableList) {
            return this.compareTo((FloatImmutableList)l);
        }
        if (l instanceof ImmutableSubList) {
            ImmutableSubList other = (ImmutableSubList)l;
            return -other.compareTo((List)this);
        }
        return super.compareTo(l);
    }

    static /* synthetic */ float[] access$000(FloatImmutableList x0) {
        return x0.a;
    }
}

