// Copyright 2024 The Go Authors. All rights reserved.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// This proto verifies that we keep the name mangling algorithm (which is
// position dependent) intact in the protoc_gen_go generator. The field names
// and the getter names have to be kept intact over time, both in the OPEN and
// in the HYBRID API. How fields are "mangled" is described in a comment per
// field.

// The order of "evaluation" of fields is important. Fields are evaluated in
// order of appearance, except the oneof union names, that are evaluated after
// their first member. For each field, check if there is a previous field name
// or getter name that clashes with this field or it's getter. In case there is
// a clash, add an _ to the field name and repeat. In the case of oneof's, the
// union will be renamed if it clashes with it's first member, but not if it
// clashes with it's second.

// This scheme is here for backwards compatibility.
// The type of clashes that can be are the following:
// 1 - My field name clashes with their getter name
// 2 - My getter name clashes with their field name

// Code generated by protoc-gen-go. DO NOT EDIT.
// source: cmd/protoc-gen-go/testdata/nameclash/test_name_clash_open.proto

package test_name_clash_open

import (
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	_ "google.golang.org/protobuf/types/gofeaturespb"
	reflect "reflect"
	sync "sync"
	unsafe "unsafe"
)

type M1 struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// initial name in Go     | Clashes with field | type | final name
	// Foo                    | -                  | -    | Foo
	// GetFoo                 | foo                | 1    | GetFoo_
	// GetGetFoo              | -                  | -    | GetGetFoo
	Foo           *int32 `protobuf:"varint,1,opt,name=foo" json:"foo,omitempty"`
	GetFoo_       *int32 `protobuf:"varint,2,opt,name=get_foo,json=getFoo" json:"get_foo,omitempty"`
	GetGetFoo     *int32 `protobuf:"varint,3,opt,name=get_get_foo,json=getGetFoo" json:"get_get_foo,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *M1) Reset() {
	*x = M1{}
	mi := &file_cmd_protoc_gen_go_testdata_nameclash_test_name_clash_open_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *M1) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*M1) ProtoMessage() {}

func (x *M1) ProtoReflect() protoreflect.Message {
	mi := &file_cmd_protoc_gen_go_testdata_nameclash_test_name_clash_open_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use M1.ProtoReflect.Descriptor instead.
func (*M1) Descriptor() ([]byte, []int) {
	return file_cmd_protoc_gen_go_testdata_nameclash_test_name_clash_open_proto_rawDescGZIP(), []int{0}
}

func (x *M1) GetFoo() int32 {
	if x != nil && x.Foo != nil {
		return *x.Foo
	}
	return 0
}

func (x *M1) GetGetFoo_() int32 {
	if x != nil && x.GetFoo_ != nil {
		return *x.GetFoo_
	}
	return 0
}

func (x *M1) GetGetGetFoo() int32 {
	if x != nil && x.GetGetFoo != nil {
		return *x.GetGetFoo
	}
	return 0
}

type M2 struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// initial name in Go     | Clashes with field | type | final name
	// GetGetFoo              | -                  | -    | GetGetFoo
	// GetFoo                 | get_get_foo        | 2    | GetFoo_
	// Foo                    | -                  | -    | Foo
	GetGetFoo     *int32 `protobuf:"varint,3,opt,name=get_get_foo,json=getGetFoo" json:"get_get_foo,omitempty"`
	GetFoo_       *int32 `protobuf:"varint,2,opt,name=get_foo,json=getFoo" json:"get_foo,omitempty"`
	Foo           *int32 `protobuf:"varint,1,opt,name=foo" json:"foo,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *M2) Reset() {
	*x = M2{}
	mi := &file_cmd_protoc_gen_go_testdata_nameclash_test_name_clash_open_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *M2) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*M2) ProtoMessage() {}

func (x *M2) ProtoReflect() protoreflect.Message {
	mi := &file_cmd_protoc_gen_go_testdata_nameclash_test_name_clash_open_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use M2.ProtoReflect.Descriptor instead.
func (*M2) Descriptor() ([]byte, []int) {
	return file_cmd_protoc_gen_go_testdata_nameclash_test_name_clash_open_proto_rawDescGZIP(), []int{1}
}

func (x *M2) GetGetGetFoo() int32 {
	if x != nil && x.GetGetFoo != nil {
		return *x.GetGetFoo
	}
	return 0
}

func (x *M2) GetGetFoo_() int32 {
	if x != nil && x.GetFoo_ != nil {
		return *x.GetFoo_
	}
	return 0
}

func (x *M2) GetFoo() int32 {
	if x != nil && x.Foo != nil {
		return *x.Foo
	}
	return 0
}

type M3 struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// initial name in Go     | Clashes with field | type | final name
	// GetFoo                 | -                  | -    | GetFoo
	// GetGetFoo              | get_foo            | 1    | GetGetFoo_
	// Foo                    | get_foo            | 2    | Foo_
	GetFoo        *int32 `protobuf:"varint,2,opt,name=get_foo,json=getFoo" json:"get_foo,omitempty"`
	GetGetFoo_    *int32 `protobuf:"varint,3,opt,name=get_get_foo,json=getGetFoo" json:"get_get_foo,omitempty"`
	Foo_          *int32 `protobuf:"varint,1,opt,name=foo" json:"foo,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *M3) Reset() {
	*x = M3{}
	mi := &file_cmd_protoc_gen_go_testdata_nameclash_test_name_clash_open_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *M3) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*M3) ProtoMessage() {}

func (x *M3) ProtoReflect() protoreflect.Message {
	mi := &file_cmd_protoc_gen_go_testdata_nameclash_test_name_clash_open_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use M3.ProtoReflect.Descriptor instead.
func (*M3) Descriptor() ([]byte, []int) {
	return file_cmd_protoc_gen_go_testdata_nameclash_test_name_clash_open_proto_rawDescGZIP(), []int{2}
}

func (x *M3) GetGetFoo() int32 {
	if x != nil && x.GetFoo != nil {
		return *x.GetFoo
	}
	return 0
}

func (x *M3) GetGetGetFoo_() int32 {
	if x != nil && x.GetGetFoo_ != nil {
		return *x.GetGetFoo_
	}
	return 0
}

func (x *M3) GetFoo_() int32 {
	if x != nil && x.Foo_ != nil {
		return *x.Foo_
	}
	return 0
}

type M4 struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// initial name in Go     | Clashes with field | type | final name
	// GetFoo                 | -                  | -    | GetFoo
	// GetGetFoo              | get_foo            | 1    | GetGetFoo_
	//
	//	GetGetGetFoo          | -                  | -    | GetGetGetFoo
	//	                      |                    |      |
	//
	// Foo                    | get_foo            | 2    | Foo_
	GetFoo *int32 `protobuf:"varint,2,opt,name=get_foo,json=getFoo" json:"get_foo,omitempty"`
	// Types that are valid to be assigned to GetGetFoo_:
	//
	//	*M4_GetGetGetFoo
	GetGetFoo_    isM4_GetGetFoo_ `protobuf_oneof:"get_get_foo"`
	Foo_          *int32          `protobuf:"varint,1,opt,name=foo" json:"foo,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *M4) Reset() {
	*x = M4{}
	mi := &file_cmd_protoc_gen_go_testdata_nameclash_test_name_clash_open_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *M4) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*M4) ProtoMessage() {}

func (x *M4) ProtoReflect() protoreflect.Message {
	mi := &file_cmd_protoc_gen_go_testdata_nameclash_test_name_clash_open_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use M4.ProtoReflect.Descriptor instead.
func (*M4) Descriptor() ([]byte, []int) {
	return file_cmd_protoc_gen_go_testdata_nameclash_test_name_clash_open_proto_rawDescGZIP(), []int{3}
}

func (x *M4) GetGetFoo() int32 {
	if x != nil && x.GetFoo != nil {
		return *x.GetFoo
	}
	return 0
}

func (x *M4) GetGetGetFoo_() isM4_GetGetFoo_ {
	if x != nil {
		return x.GetGetFoo_
	}
	return nil
}

func (x *M4) GetGetGetGetFoo() int32 {
	if x != nil {
		if x, ok := x.GetGetFoo_.(*M4_GetGetGetFoo); ok {
			return x.GetGetGetFoo
		}
	}
	return 0
}

func (x *M4) GetFoo_() int32 {
	if x != nil && x.Foo_ != nil {
		return *x.Foo_
	}
	return 0
}

type isM4_GetGetFoo_ interface {
	isM4_GetGetFoo_()
}

type M4_GetGetGetFoo struct {
	GetGetGetFoo int32 `protobuf:"varint,3,opt,name=get_get_get_foo,json=getGetGetFoo,oneof"`
}

func (*M4_GetGetGetFoo) isM4_GetGetFoo_() {}

type M5 struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Note evaluation order - get_get_foo before get_get_get_foo
	// initial name in Go     | Clashes with field | type | final name
	// GetFoo                 | -                  | -    | GetFoo
	// GetGetGetFoo           | -                  | -    | GetGetGetFoo
	//
	//	GetGetFoo             | get_foo            | 1    | GetGetFoo_
	//	                      |                    |      |
	//
	// Foo                    | get_foo            | 2    | Foo_
	GetFoo *int32 `protobuf:"varint,2,opt,name=get_foo,json=getFoo" json:"get_foo,omitempty"`
	// Types that are valid to be assigned to GetGetGetFoo:
	//
	//	*M5_GetGetFoo_
	GetGetGetFoo  isM5_GetGetGetFoo `protobuf_oneof:"get_get_get_foo"`
	Foo_          *int32            `protobuf:"varint,1,opt,name=foo" json:"foo,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *M5) Reset() {
	*x = M5{}
	mi := &file_cmd_protoc_gen_go_testdata_nameclash_test_name_clash_open_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *M5) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*M5) ProtoMessage() {}

func (x *M5) ProtoReflect() protoreflect.Message {
	mi := &file_cmd_protoc_gen_go_testdata_nameclash_test_name_clash_open_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use M5.ProtoReflect.Descriptor instead.
func (*M5) Descriptor() ([]byte, []int) {
	return file_cmd_protoc_gen_go_testdata_nameclash_test_name_clash_open_proto_rawDescGZIP(), []int{4}
}

func (x *M5) GetGetFoo() int32 {
	if x != nil && x.GetFoo != nil {
		return *x.GetFoo
	}
	return 0
}

func (x *M5) GetGetGetGetFoo() isM5_GetGetGetFoo {
	if x != nil {
		return x.GetGetGetFoo
	}
	return nil
}

func (x *M5) GetGetGetFoo_() int32 {
	if x != nil {
		if x, ok := x.GetGetGetFoo.(*M5_GetGetFoo_); ok {
			return x.GetGetFoo_
		}
	}
	return 0
}

func (x *M5) GetFoo_() int32 {
	if x != nil && x.Foo_ != nil {
		return *x.Foo_
	}
	return 0
}

type isM5_GetGetGetFoo interface {
	isM5_GetGetGetFoo()
}

type M5_GetGetFoo_ struct {
	GetGetFoo_ int32 `protobuf:"varint,3,opt,name=get_get_foo,json=getGetFoo,oneof"`
}

func (*M5_GetGetFoo_) isM5_GetGetGetFoo() {}

type M6 struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Note evaluation order - get_get_get_foo before get_get_foo
	// initial name in Go     | Clashes with field | type | final name
	// GetGetFoo              | -                  | -    | GetGetFoo
	//
	//	GetGetGetFoo          | -                  | -    | GetGetGetFoo
	//	                      |                    |      |
	//
	// GetFoo                 | get_get_foo        | 2    | GetFoo_
	// Foo                    | -                  | -    | Foo
	//
	// Types that are valid to be assigned to GetGetFoo:
	//
	//	*M6_GetGetGetFoo
	GetGetFoo     isM6_GetGetFoo `protobuf_oneof:"get_get_foo"`
	GetFoo_       *int32         `protobuf:"varint,2,opt,name=get_foo,json=getFoo" json:"get_foo,omitempty"`
	Foo           *int32         `protobuf:"varint,1,opt,name=foo" json:"foo,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *M6) Reset() {
	*x = M6{}
	mi := &file_cmd_protoc_gen_go_testdata_nameclash_test_name_clash_open_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *M6) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*M6) ProtoMessage() {}

func (x *M6) ProtoReflect() protoreflect.Message {
	mi := &file_cmd_protoc_gen_go_testdata_nameclash_test_name_clash_open_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use M6.ProtoReflect.Descriptor instead.
func (*M6) Descriptor() ([]byte, []int) {
	return file_cmd_protoc_gen_go_testdata_nameclash_test_name_clash_open_proto_rawDescGZIP(), []int{5}
}

func (x *M6) GetGetGetFoo() isM6_GetGetFoo {
	if x != nil {
		return x.GetGetFoo
	}
	return nil
}

func (x *M6) GetGetGetGetFoo() int32 {
	if x != nil {
		if x, ok := x.GetGetFoo.(*M6_GetGetGetFoo); ok {
			return x.GetGetGetFoo
		}
	}
	return 0
}

func (x *M6) GetGetFoo_() int32 {
	if x != nil && x.GetFoo_ != nil {
		return *x.GetFoo_
	}
	return 0
}

func (x *M6) GetFoo() int32 {
	if x != nil && x.Foo != nil {
		return *x.Foo
	}
	return 0
}

type isM6_GetGetFoo interface {
	isM6_GetGetFoo()
}

type M6_GetGetGetFoo struct {
	GetGetGetFoo int32 `protobuf:"varint,3,opt,name=get_get_get_foo,json=getGetGetFoo,oneof"`
}

func (*M6_GetGetGetFoo) isM6_GetGetFoo() {}

type M7 struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Note evaluation order - bar before get_get_foo, then get_get_get_foo
	// initial name in Go     | Clashes with field | type | final name
	// GetGetFoo              | -                  | -    | GetGetFoo
	//
	//	Bar                   | -                  | -    | Bar
	//	GetFoo                | foo                | 1    | GetFoo_
	//	                      |                    |      |
	//
	// Foo                    | -                  | -    | Foo
	//
	// Types that are valid to be assigned to GetGetFoo:
	//
	//	*M7_Bar
	//	*M7_GetFoo_
	GetGetFoo     isM7_GetGetFoo `protobuf_oneof:"get_get_foo"`
	Foo           *int32         `protobuf:"varint,1,opt,name=foo" json:"foo,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *M7) Reset() {
	*x = M7{}
	mi := &file_cmd_protoc_gen_go_testdata_nameclash_test_name_clash_open_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *M7) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*M7) ProtoMessage() {}

func (x *M7) ProtoReflect() protoreflect.Message {
	mi := &file_cmd_protoc_gen_go_testdata_nameclash_test_name_clash_open_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use M7.ProtoReflect.Descriptor instead.
func (*M7) Descriptor() ([]byte, []int) {
	return file_cmd_protoc_gen_go_testdata_nameclash_test_name_clash_open_proto_rawDescGZIP(), []int{6}
}

func (x *M7) GetGetGetFoo() isM7_GetGetFoo {
	if x != nil {
		return x.GetGetFoo
	}
	return nil
}

func (x *M7) GetBar() bool {
	if x != nil {
		if x, ok := x.GetGetFoo.(*M7_Bar); ok {
			return x.Bar
		}
	}
	return false
}

func (x *M7) GetGetFoo_() int32 {
	if x != nil {
		if x, ok := x.GetGetFoo.(*M7_GetFoo_); ok {
			return x.GetFoo_
		}
	}
	return 0
}

func (x *M7) GetFoo() int32 {
	if x != nil && x.Foo != nil {
		return *x.Foo
	}
	return 0
}

type isM7_GetGetFoo interface {
	isM7_GetGetFoo()
}

type M7_Bar struct {
	Bar bool `protobuf:"varint,4,opt,name=bar,oneof"`
}

type M7_GetFoo_ struct {
	GetFoo_ int32 `protobuf:"varint,3,opt,name=get_foo,json=getFoo,oneof"`
}

func (*M7_Bar) isM7_GetGetFoo() {}

func (*M7_GetFoo_) isM7_GetGetFoo() {}

type M8 struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Note evaluation order - get_get_foo before get_get_get_foo
	// initial name in Go     | Clashes with field | type | final name
	// GetGetGetFoo           | get_get_foo        | 1    | GetGetGetFoo_
	//
	//	GetGetFoo             | -                  | -    | GetGetFoo
	//	                      |                    |      |
	//
	// GetFoo                 | get_get_foo        | 2    | GetFoo_
	// Foo                    | -                  | -    | Foo
	//
	// Types that are valid to be assigned to GetGetGetFoo_:
	//
	//	*M8_GetGetFoo
	GetGetGetFoo_ isM8_GetGetGetFoo_ `protobuf_oneof:"get_get_get_foo"`
	GetFoo_       *int32             `protobuf:"varint,2,opt,name=get_foo,json=getFoo" json:"get_foo,omitempty"`
	Foo           *int32             `protobuf:"varint,1,opt,name=foo" json:"foo,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *M8) Reset() {
	*x = M8{}
	mi := &file_cmd_protoc_gen_go_testdata_nameclash_test_name_clash_open_proto_msgTypes[7]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *M8) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*M8) ProtoMessage() {}

func (x *M8) ProtoReflect() protoreflect.Message {
	mi := &file_cmd_protoc_gen_go_testdata_nameclash_test_name_clash_open_proto_msgTypes[7]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use M8.ProtoReflect.Descriptor instead.
func (*M8) Descriptor() ([]byte, []int) {
	return file_cmd_protoc_gen_go_testdata_nameclash_test_name_clash_open_proto_rawDescGZIP(), []int{7}
}

func (x *M8) GetGetGetGetFoo_() isM8_GetGetGetFoo_ {
	if x != nil {
		return x.GetGetGetFoo_
	}
	return nil
}

func (x *M8) GetGetGetFoo() int32 {
	if x != nil {
		if x, ok := x.GetGetGetFoo_.(*M8_GetGetFoo); ok {
			return x.GetGetFoo
		}
	}
	return 0
}

func (x *M8) GetGetFoo_() int32 {
	if x != nil && x.GetFoo_ != nil {
		return *x.GetFoo_
	}
	return 0
}

func (x *M8) GetFoo() int32 {
	if x != nil && x.Foo != nil {
		return *x.Foo
	}
	return 0
}

type isM8_GetGetGetFoo_ interface {
	isM8_GetGetGetFoo_()
}

type M8_GetGetFoo struct {
	GetGetFoo int32 `protobuf:"varint,3,opt,name=get_get_foo,json=getGetFoo,oneof"`
}

func (*M8_GetGetFoo) isM8_GetGetGetFoo_() {}

type M9 struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Note evaluation order - get_get_foo before get_get_get_foo, then get_foo
	// initial name in Go     | Clashes with field | type | final name
	// GetGetGetFoo           | get_get_foo        | 1    | GetGetGetFoo_
	//
	//	GetGetFoo             | -                  | -    | GetGetFoo
	//	GetFoo                | get_get_foo        | 2    | GetFoo_
	//	                      |                    |      |
	//
	// Foo                    | -                  | -    | Foo
	//
	// Types that are valid to be assigned to GetGetGetFoo_:
	//
	//	*M9_GetGetFoo
	//	*M9_GetFoo_
	GetGetGetFoo_ isM9_GetGetGetFoo_ `protobuf_oneof:"get_get_get_foo"`
	Foo           *int32             `protobuf:"varint,1,opt,name=foo" json:"foo,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *M9) Reset() {
	*x = M9{}
	mi := &file_cmd_protoc_gen_go_testdata_nameclash_test_name_clash_open_proto_msgTypes[8]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *M9) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*M9) ProtoMessage() {}

func (x *M9) ProtoReflect() protoreflect.Message {
	mi := &file_cmd_protoc_gen_go_testdata_nameclash_test_name_clash_open_proto_msgTypes[8]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use M9.ProtoReflect.Descriptor instead.
func (*M9) Descriptor() ([]byte, []int) {
	return file_cmd_protoc_gen_go_testdata_nameclash_test_name_clash_open_proto_rawDescGZIP(), []int{8}
}

func (x *M9) GetGetGetGetFoo_() isM9_GetGetGetFoo_ {
	if x != nil {
		return x.GetGetGetFoo_
	}
	return nil
}

func (x *M9) GetGetGetFoo() int32 {
	if x != nil {
		if x, ok := x.GetGetGetFoo_.(*M9_GetGetFoo); ok {
			return x.GetGetFoo
		}
	}
	return 0
}

func (x *M9) GetGetFoo_() int32 {
	if x != nil {
		if x, ok := x.GetGetGetFoo_.(*M9_GetFoo_); ok {
			return x.GetFoo_
		}
	}
	return 0
}

func (x *M9) GetFoo() int32 {
	if x != nil && x.Foo != nil {
		return *x.Foo
	}
	return 0
}

type isM9_GetGetGetFoo_ interface {
	isM9_GetGetGetFoo_()
}

type M9_GetGetFoo struct {
	GetGetFoo int32 `protobuf:"varint,3,opt,name=get_get_foo,json=getGetFoo,oneof"`
}

type M9_GetFoo_ struct {
	GetFoo_ int32 `protobuf:"varint,2,opt,name=get_foo,json=getFoo,oneof"`
}

func (*M9_GetGetFoo) isM9_GetGetGetFoo_() {}

func (*M9_GetFoo_) isM9_GetGetGetFoo_() {}

var File_cmd_protoc_gen_go_testdata_nameclash_test_name_clash_open_proto protoreflect.FileDescriptor

var file_cmd_protoc_gen_go_testdata_nameclash_test_name_clash_open_proto_rawDesc = string([]byte{
	0x0a, 0x3f, 0x63, 0x6d, 0x64, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x2d, 0x67, 0x65, 0x6e,
	0x2d, 0x67, 0x6f, 0x2f, 0x74, 0x65, 0x73, 0x74, 0x64, 0x61, 0x74, 0x61, 0x2f, 0x6e, 0x61, 0x6d,
	0x65, 0x63, 0x6c, 0x61, 0x73, 0x68, 0x2f, 0x74, 0x65, 0x73, 0x74, 0x5f, 0x6e, 0x61, 0x6d, 0x65,
	0x5f, 0x63, 0x6c, 0x61, 0x73, 0x68, 0x5f, 0x6f, 0x70, 0x65, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x12, 0x24, 0x6e, 0x65, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x32, 0x2e, 0x67, 0x6f,
	0x2e, 0x74, 0x65, 0x73, 0x74, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x63, 0x6c,
	0x61, 0x73, 0x68, 0x6f, 0x70, 0x65, 0x6e, 0x1a, 0x21, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x67, 0x6f, 0x5f, 0x66, 0x65, 0x61, 0x74,
	0x75, 0x72, 0x65, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x4f, 0x0a, 0x02, 0x4d, 0x31,
	0x12, 0x10, 0x0a, 0x03, 0x66, 0x6f, 0x6f, 0x18, 0x01, 0x20, 0x01, 0x28, 0x05, 0x52, 0x03, 0x66,
	0x6f, 0x6f, 0x12, 0x17, 0x0a, 0x07, 0x67, 0x65, 0x74, 0x5f, 0x66, 0x6f, 0x6f, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x05, 0x52, 0x06, 0x67, 0x65, 0x74, 0x46, 0x6f, 0x6f, 0x12, 0x1e, 0x0a, 0x0b, 0x67,
	0x65, 0x74, 0x5f, 0x67, 0x65, 0x74, 0x5f, 0x66, 0x6f, 0x6f, 0x18, 0x03, 0x20, 0x01, 0x28, 0x05,
	0x52, 0x09, 0x67, 0x65, 0x74, 0x47, 0x65, 0x74, 0x46, 0x6f, 0x6f, 0x22, 0x4f, 0x0a, 0x02, 0x4d,
	0x32, 0x12, 0x1e, 0x0a, 0x0b, 0x67, 0x65, 0x74, 0x5f, 0x67, 0x65, 0x74, 0x5f, 0x66, 0x6f, 0x6f,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x05, 0x52, 0x09, 0x67, 0x65, 0x74, 0x47, 0x65, 0x74, 0x46, 0x6f,
	0x6f, 0x12, 0x17, 0x0a, 0x07, 0x67, 0x65, 0x74, 0x5f, 0x66, 0x6f, 0x6f, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x05, 0x52, 0x06, 0x67, 0x65, 0x74, 0x46, 0x6f, 0x6f, 0x12, 0x10, 0x0a, 0x03, 0x66, 0x6f,
	0x6f, 0x18, 0x01, 0x20, 0x01, 0x28, 0x05, 0x52, 0x03, 0x66, 0x6f, 0x6f, 0x22, 0x4f, 0x0a, 0x02,
	0x4d, 0x33, 0x12, 0x17, 0x0a, 0x07, 0x67, 0x65, 0x74, 0x5f, 0x66, 0x6f, 0x6f, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x05, 0x52, 0x06, 0x67, 0x65, 0x74, 0x46, 0x6f, 0x6f, 0x12, 0x1e, 0x0a, 0x0b, 0x67,
	0x65, 0x74, 0x5f, 0x67, 0x65, 0x74, 0x5f, 0x66, 0x6f, 0x6f, 0x18, 0x03, 0x20, 0x01, 0x28, 0x05,
	0x52, 0x09, 0x67, 0x65, 0x74, 0x47, 0x65, 0x74, 0x46, 0x6f, 0x6f, 0x12, 0x10, 0x0a, 0x03, 0x66,
	0x6f, 0x6f, 0x18, 0x01, 0x20, 0x01, 0x28, 0x05, 0x52, 0x03, 0x66, 0x6f, 0x6f, 0x22, 0x67, 0x0a,
	0x02, 0x4d, 0x34, 0x12, 0x17, 0x0a, 0x07, 0x67, 0x65, 0x74, 0x5f, 0x66, 0x6f, 0x6f, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x05, 0x52, 0x06, 0x67, 0x65, 0x74, 0x46, 0x6f, 0x6f, 0x12, 0x27, 0x0a, 0x0f,
	0x67, 0x65, 0x74, 0x5f, 0x67, 0x65, 0x74, 0x5f, 0x67, 0x65, 0x74, 0x5f, 0x66, 0x6f, 0x6f, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x05, 0x48, 0x00, 0x52, 0x0c, 0x67, 0x65, 0x74, 0x47, 0x65, 0x74, 0x47,
	0x65, 0x74, 0x46, 0x6f, 0x6f, 0x12, 0x10, 0x0a, 0x03, 0x66, 0x6f, 0x6f, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x05, 0x52, 0x03, 0x66, 0x6f, 0x6f, 0x42, 0x0d, 0x0a, 0x0b, 0x67, 0x65, 0x74, 0x5f, 0x67,
	0x65, 0x74, 0x5f, 0x66, 0x6f, 0x6f, 0x22, 0x64, 0x0a, 0x02, 0x4d, 0x35, 0x12, 0x17, 0x0a, 0x07,
	0x67, 0x65, 0x74, 0x5f, 0x66, 0x6f, 0x6f, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x06, 0x67,
	0x65, 0x74, 0x46, 0x6f, 0x6f, 0x12, 0x20, 0x0a, 0x0b, 0x67, 0x65, 0x74, 0x5f, 0x67, 0x65, 0x74,
	0x5f, 0x66, 0x6f, 0x6f, 0x18, 0x03, 0x20, 0x01, 0x28, 0x05, 0x48, 0x00, 0x52, 0x09, 0x67, 0x65,
	0x74, 0x47, 0x65, 0x74, 0x46, 0x6f, 0x6f, 0x12, 0x10, 0x0a, 0x03, 0x66, 0x6f, 0x6f, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x05, 0x52, 0x03, 0x66, 0x6f, 0x6f, 0x42, 0x11, 0x0a, 0x0f, 0x67, 0x65, 0x74,
	0x5f, 0x67, 0x65, 0x74, 0x5f, 0x67, 0x65, 0x74, 0x5f, 0x66, 0x6f, 0x6f, 0x22, 0x67, 0x0a, 0x02,
	0x4d, 0x36, 0x12, 0x27, 0x0a, 0x0f, 0x67, 0x65, 0x74, 0x5f, 0x67, 0x65, 0x74, 0x5f, 0x67, 0x65,
	0x74, 0x5f, 0x66, 0x6f, 0x6f, 0x18, 0x03, 0x20, 0x01, 0x28, 0x05, 0x48, 0x00, 0x52, 0x0c, 0x67,
	0x65, 0x74, 0x47, 0x65, 0x74, 0x47, 0x65, 0x74, 0x46, 0x6f, 0x6f, 0x12, 0x17, 0x0a, 0x07, 0x67,
	0x65, 0x74, 0x5f, 0x66, 0x6f, 0x6f, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x06, 0x67, 0x65,
	0x74, 0x46, 0x6f, 0x6f, 0x12, 0x10, 0x0a, 0x03, 0x66, 0x6f, 0x6f, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x05, 0x52, 0x03, 0x66, 0x6f, 0x6f, 0x42, 0x0d, 0x0a, 0x0b, 0x67, 0x65, 0x74, 0x5f, 0x67, 0x65,
	0x74, 0x5f, 0x66, 0x6f, 0x6f, 0x22, 0x54, 0x0a, 0x02, 0x4d, 0x37, 0x12, 0x12, 0x0a, 0x03, 0x62,
	0x61, 0x72, 0x18, 0x04, 0x20, 0x01, 0x28, 0x08, 0x48, 0x00, 0x52, 0x03, 0x62, 0x61, 0x72, 0x12,
	0x19, 0x0a, 0x07, 0x67, 0x65, 0x74, 0x5f, 0x66, 0x6f, 0x6f, 0x18, 0x03, 0x20, 0x01, 0x28, 0x05,
	0x48, 0x00, 0x52, 0x06, 0x67, 0x65, 0x74, 0x46, 0x6f, 0x6f, 0x12, 0x10, 0x0a, 0x03, 0x66, 0x6f,
	0x6f, 0x18, 0x01, 0x20, 0x01, 0x28, 0x05, 0x52, 0x03, 0x66, 0x6f, 0x6f, 0x42, 0x0d, 0x0a, 0x0b,
	0x67, 0x65, 0x74, 0x5f, 0x67, 0x65, 0x74, 0x5f, 0x66, 0x6f, 0x6f, 0x22, 0x64, 0x0a, 0x02, 0x4d,
	0x38, 0x12, 0x20, 0x0a, 0x0b, 0x67, 0x65, 0x74, 0x5f, 0x67, 0x65, 0x74, 0x5f, 0x66, 0x6f, 0x6f,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x05, 0x48, 0x00, 0x52, 0x09, 0x67, 0x65, 0x74, 0x47, 0x65, 0x74,
	0x46, 0x6f, 0x6f, 0x12, 0x17, 0x0a, 0x07, 0x67, 0x65, 0x74, 0x5f, 0x66, 0x6f, 0x6f, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x05, 0x52, 0x06, 0x67, 0x65, 0x74, 0x46, 0x6f, 0x6f, 0x12, 0x10, 0x0a, 0x03,
	0x66, 0x6f, 0x6f, 0x18, 0x01, 0x20, 0x01, 0x28, 0x05, 0x52, 0x03, 0x66, 0x6f, 0x6f, 0x42, 0x11,
	0x0a, 0x0f, 0x67, 0x65, 0x74, 0x5f, 0x67, 0x65, 0x74, 0x5f, 0x67, 0x65, 0x74, 0x5f, 0x66, 0x6f,
	0x6f, 0x22, 0x66, 0x0a, 0x02, 0x4d, 0x39, 0x12, 0x20, 0x0a, 0x0b, 0x67, 0x65, 0x74, 0x5f, 0x67,
	0x65, 0x74, 0x5f, 0x66, 0x6f, 0x6f, 0x18, 0x03, 0x20, 0x01, 0x28, 0x05, 0x48, 0x00, 0x52, 0x09,
	0x67, 0x65, 0x74, 0x47, 0x65, 0x74, 0x46, 0x6f, 0x6f, 0x12, 0x19, 0x0a, 0x07, 0x67, 0x65, 0x74,
	0x5f, 0x66, 0x6f, 0x6f, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x48, 0x00, 0x52, 0x06, 0x67, 0x65,
	0x74, 0x46, 0x6f, 0x6f, 0x12, 0x10, 0x0a, 0x03, 0x66, 0x6f, 0x6f, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x05, 0x52, 0x03, 0x66, 0x6f, 0x6f, 0x42, 0x11, 0x0a, 0x0f, 0x67, 0x65, 0x74, 0x5f, 0x67, 0x65,
	0x74, 0x5f, 0x67, 0x65, 0x74, 0x5f, 0x66, 0x6f, 0x6f, 0x42, 0x5e, 0x5a, 0x54, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x67, 0x6f, 0x6c, 0x61, 0x6e, 0x67, 0x2e, 0x6f, 0x72, 0x67, 0x2f, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x63, 0x6d, 0x64, 0x2f, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x63, 0x2d, 0x67, 0x65, 0x6e, 0x2d, 0x67, 0x6f, 0x2f, 0x74, 0x65, 0x73, 0x74, 0x64, 0x61,
	0x74, 0x61, 0x2f, 0x6e, 0x61, 0x6d, 0x65, 0x63, 0x6c, 0x61, 0x73, 0x68, 0x2f, 0x74, 0x65, 0x73,
	0x74, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x5f, 0x63, 0x6c, 0x61, 0x73, 0x68, 0x5f, 0x6f, 0x70, 0x65,
	0x6e, 0x92, 0x03, 0x05, 0xd2, 0x3e, 0x02, 0x10, 0x01, 0x62, 0x08, 0x65, 0x64, 0x69, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x70, 0xe8, 0x07,
})

var (
	file_cmd_protoc_gen_go_testdata_nameclash_test_name_clash_open_proto_rawDescOnce sync.Once
	file_cmd_protoc_gen_go_testdata_nameclash_test_name_clash_open_proto_rawDescData []byte
)

func file_cmd_protoc_gen_go_testdata_nameclash_test_name_clash_open_proto_rawDescGZIP() []byte {
	file_cmd_protoc_gen_go_testdata_nameclash_test_name_clash_open_proto_rawDescOnce.Do(func() {
		file_cmd_protoc_gen_go_testdata_nameclash_test_name_clash_open_proto_rawDescData = protoimpl.X.CompressGZIP(unsafe.Slice(unsafe.StringData(file_cmd_protoc_gen_go_testdata_nameclash_test_name_clash_open_proto_rawDesc), len(file_cmd_protoc_gen_go_testdata_nameclash_test_name_clash_open_proto_rawDesc)))
	})
	return file_cmd_protoc_gen_go_testdata_nameclash_test_name_clash_open_proto_rawDescData
}

var file_cmd_protoc_gen_go_testdata_nameclash_test_name_clash_open_proto_msgTypes = make([]protoimpl.MessageInfo, 9)
var file_cmd_protoc_gen_go_testdata_nameclash_test_name_clash_open_proto_goTypes = []any{
	(*M1)(nil), // 0: net.proto2.go.testdata.nameclashopen.M1
	(*M2)(nil), // 1: net.proto2.go.testdata.nameclashopen.M2
	(*M3)(nil), // 2: net.proto2.go.testdata.nameclashopen.M3
	(*M4)(nil), // 3: net.proto2.go.testdata.nameclashopen.M4
	(*M5)(nil), // 4: net.proto2.go.testdata.nameclashopen.M5
	(*M6)(nil), // 5: net.proto2.go.testdata.nameclashopen.M6
	(*M7)(nil), // 6: net.proto2.go.testdata.nameclashopen.M7
	(*M8)(nil), // 7: net.proto2.go.testdata.nameclashopen.M8
	(*M9)(nil), // 8: net.proto2.go.testdata.nameclashopen.M9
}
var file_cmd_protoc_gen_go_testdata_nameclash_test_name_clash_open_proto_depIdxs = []int32{
	0, // [0:0] is the sub-list for method output_type
	0, // [0:0] is the sub-list for method input_type
	0, // [0:0] is the sub-list for extension type_name
	0, // [0:0] is the sub-list for extension extendee
	0, // [0:0] is the sub-list for field type_name
}

func init() { file_cmd_protoc_gen_go_testdata_nameclash_test_name_clash_open_proto_init() }
func file_cmd_protoc_gen_go_testdata_nameclash_test_name_clash_open_proto_init() {
	if File_cmd_protoc_gen_go_testdata_nameclash_test_name_clash_open_proto != nil {
		return
	}
	file_cmd_protoc_gen_go_testdata_nameclash_test_name_clash_open_proto_msgTypes[3].OneofWrappers = []any{
		(*M4_GetGetGetFoo)(nil),
	}
	file_cmd_protoc_gen_go_testdata_nameclash_test_name_clash_open_proto_msgTypes[4].OneofWrappers = []any{
		(*M5_GetGetFoo_)(nil),
	}
	file_cmd_protoc_gen_go_testdata_nameclash_test_name_clash_open_proto_msgTypes[5].OneofWrappers = []any{
		(*M6_GetGetGetFoo)(nil),
	}
	file_cmd_protoc_gen_go_testdata_nameclash_test_name_clash_open_proto_msgTypes[6].OneofWrappers = []any{
		(*M7_Bar)(nil),
		(*M7_GetFoo_)(nil),
	}
	file_cmd_protoc_gen_go_testdata_nameclash_test_name_clash_open_proto_msgTypes[7].OneofWrappers = []any{
		(*M8_GetGetFoo)(nil),
	}
	file_cmd_protoc_gen_go_testdata_nameclash_test_name_clash_open_proto_msgTypes[8].OneofWrappers = []any{
		(*M9_GetGetFoo)(nil),
		(*M9_GetFoo_)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: unsafe.Slice(unsafe.StringData(file_cmd_protoc_gen_go_testdata_nameclash_test_name_clash_open_proto_rawDesc), len(file_cmd_protoc_gen_go_testdata_nameclash_test_name_clash_open_proto_rawDesc)),
			NumEnums:      0,
			NumMessages:   9,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_cmd_protoc_gen_go_testdata_nameclash_test_name_clash_open_proto_goTypes,
		DependencyIndexes: file_cmd_protoc_gen_go_testdata_nameclash_test_name_clash_open_proto_depIdxs,
		MessageInfos:      file_cmd_protoc_gen_go_testdata_nameclash_test_name_clash_open_proto_msgTypes,
	}.Build()
	File_cmd_protoc_gen_go_testdata_nameclash_test_name_clash_open_proto = out.File
	file_cmd_protoc_gen_go_testdata_nameclash_test_name_clash_open_proto_goTypes = nil
	file_cmd_protoc_gen_go_testdata_nameclash_test_name_clash_open_proto_depIdxs = nil
}
