/*
 * Decompiled with CFR 0.152.
 */
package org.dita.dost.project;

import com.thaiopensource.relaxng.jaxp.CompactSyntaxSchemaFactory;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Validator;
import org.dita.dost.project.IgnoringXmlFilter;
import org.dita.dost.project.ProjectBuilder;
import org.dita.dost.util.XMLUtils;
import org.slf4j.Logger;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;

public class XmlReader {
    public static final String NS = "https://www.dita-ot.org/project";
    public static final String ATTR_HREF = "href";
    public static final String ATTR_PATH = "path";
    public static final String ATTR_ID = "id";
    public static final String ATTR_IDREF = "idref";
    public static final String ATTR_NAME = "name";
    public static final String ATTR_TRANSTYPE = "transtype";
    public static final String ATTR_VALUE = "value";
    public static final String ELEM_CONTEXT = "context";
    public static final String ELEM_DELIVERABLE = "deliverable";
    public static final String ELEM_DITAVAL = "ditaval";
    public static final String ELEM_INCLUDE = "include";
    public static final String ELEM_INPUT = "input";
    public static final String ELEM_OUTPUT = "output";
    public static final String ELEM_PARAM = "param";
    public static final String ELEM_PROFILE = "profile";
    public static final String ELEM_PROJECT = "project";
    public static final String ELEM_PUBLICATION = "publication";
    private final Validator validator;
    private final DocumentBuilder documentBuilder;
    private final XMLReader xmlReader;
    private final SAXTransformerFactory saxTransformerFactory;
    private Logger logger;
    private boolean lax;

    public XmlReader() {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            this.documentBuilder = factory.newDocumentBuilder();
            SAXParserFactory saxParserFactory = SAXParserFactory.newInstance();
            saxParserFactory.setNamespaceAware(true);
            this.xmlReader = saxParserFactory.newSAXParser().getXMLReader();
        }
        catch (ParserConfigurationException | SAXException e) {
            throw new RuntimeException(e);
        }
        this.saxTransformerFactory = (SAXTransformerFactory)TransformerFactory.newInstance();
        CompactSyntaxSchemaFactory f = new CompactSyntaxSchemaFactory();
        try (InputStream in = this.getClass().getClassLoader().getResourceAsStream("project.rnc");){
            this.validator = f.newSchema(new StreamSource(in)).newValidator();
        }
        catch (IOException | SAXException e) {
            throw new RuntimeException("Failed to read project schema: " + e.getMessage(), e);
        }
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    public void setLax(boolean lax) {
        this.lax = lax;
    }

    public ProjectBuilder read(URI file) throws IOException, SAXParseException {
        try (InputStream in = file.toURL().openStream();){
            ProjectBuilder projectBuilder = this.read(in, file);
            return projectBuilder;
        }
    }

    public ProjectBuilder read(InputStream in, URI file) throws IOException, SAXParseException {
        Document document = this.readDocument(in, file);
        List projects = XMLUtils.toList(document.getElementsByTagNameNS(NS, ELEM_PROJECT));
        if (projects.isEmpty()) {
            return null;
        }
        if (projects.size() > 1) {
            this.logger.warn("Found {} project elements, using first", (Object)projects.size());
        }
        Element project = (Element)projects.get(0);
        return new ProjectBuilder(this.getChildren(project, ELEM_DELIVERABLE).map(this::readDeliverable).collect(Collectors.toList()), this.getChildren(project, ELEM_INCLUDE).map(this::getHref).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList()), this.getChildren(project, ELEM_PUBLICATION).map(this::readPublication).collect(Collectors.toList()), this.getChildren(project, ELEM_CONTEXT).map(this::readContext).collect(Collectors.toList()));
    }

    private Document readDocument(InputStream in, URI file) throws SAXParseException, IOException {
        TransformerHandler domSerializer;
        XMLReader reader = this.lax ? new IgnoringXmlFilter(this.xmlReader) : this.xmlReader;
        InputSource inputSource = new InputSource(in);
        if (file != null) {
            inputSource.setSystemId(file.toString());
        }
        SAXSource source = new SAXSource(reader, inputSource);
        try {
            domSerializer = this.saxTransformerFactory.newTransformerHandler();
        }
        catch (TransformerConfigurationException e) {
            throw new RuntimeException(e);
        }
        Document document = this.documentBuilder.newDocument();
        if (file != null) {
            document.setDocumentURI(file.toString());
        }
        domSerializer.setResult(new DOMResult(document));
        SAXResult result = new SAXResult(domSerializer);
        try {
            this.validator.validate(source, result);
        }
        catch (SAXException e) {
            if (e instanceof SAXParseException) {
                throw (SAXParseException)e;
            }
            throw new SAXParseException(e.getMessage(), null);
        }
        if (document.getDocumentElement() == null) {
            throw new SAXParseException("No project file elements found", null, file.toString(), -1, -1);
        }
        return document;
    }

    private ProjectBuilder.Deliverable readDeliverable(Element deliverable) {
        return new ProjectBuilder.Deliverable(XMLUtils.getValue(deliverable, ATTR_NAME), XMLUtils.getValue(deliverable, ATTR_ID), this.getChild(deliverable, ELEM_CONTEXT).map(this::readContext).orElse(null), this.getChild(deliverable, ELEM_OUTPUT).flatMap(this::getHref).orElse(null), this.getChild(deliverable, ELEM_PUBLICATION).map(this::readPublication).orElse(null));
    }

    private ProjectBuilder.Publication readPublication(Element publication) {
        return new ProjectBuilder.Publication(XMLUtils.getValue(publication, ATTR_NAME), XMLUtils.getValue(publication, ATTR_ID), XMLUtils.getValue(publication, ATTR_IDREF), XMLUtils.getValue(publication, ATTR_TRANSTYPE), this.getChildren(publication, ELEM_PARAM).map(param -> new ProjectBuilder.Publication.Param(XMLUtils.getValue(param, ATTR_NAME), param.getAttributeNode(ATTR_VALUE) != null ? param.getAttribute(ATTR_VALUE) : null, this.getHref((Element)param).orElse(null), this.getFile((Element)param).orElse(null))).collect(Collectors.toList()), this.getChild(publication, ELEM_PROFILE).map(inputs -> this.getChildren((Element)inputs, ELEM_DITAVAL).map(this::getHref).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList())).map(ProjectBuilder.Deliverable.Profile::new).orElse(null));
    }

    private ProjectBuilder.Context readContext(Element context) {
        return new ProjectBuilder.Context(XMLUtils.getValue(context, ATTR_NAME), XMLUtils.getValue(context, ATTR_ID), XMLUtils.getValue(context, ATTR_IDREF), this.getChildren(context, ELEM_INPUT).map(this::getHref).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList()), this.getChild(context, ELEM_PROFILE).map(inputs -> this.getChildren((Element)inputs, ELEM_DITAVAL).map(this::getHref).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList())).map(ProjectBuilder.Deliverable.Profile::new).orElse(null));
    }

    private Optional<Element> getChild(Element project, String localName) {
        return XMLUtils.getChildElement(project, NS, localName);
    }

    private Stream<Element> getChildren(Element project, String localName) {
        return XMLUtils.getChildElements(project, NS, localName).stream();
    }

    private Optional<URI> getHref(Element elem) {
        return this.getAttribute(elem, ATTR_HREF).map(this::toUri);
    }

    private Optional<URI> getFile(Element elem) {
        return this.getAttribute(elem, ATTR_PATH).map(this::toUri);
    }

    private Optional<String> getAttribute(Element elem, String attrName) {
        Attr attr = elem.getAttributeNode(attrName);
        if (attr != null && !attr.getValue().isEmpty()) {
            return Optional.of(attr.getValue());
        }
        return Optional.empty();
    }

    private URI toUri(String uri) {
        try {
            return new URI(uri);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }
}

