/*
 * Decompiled with CFR 0.152.
 */
package org.asamk.signal.logging;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class Scrubber {
    private static final Pattern E164_PATTERN = Pattern.compile("(\\+|%2B|_)(\\d{5,13})(\\d{2})");
    private static final String E164_CENSOR = "*************";
    private static final Pattern GROUP_V1_ID_PATTERN = Pattern.compile("(/org/asamk/Signal/.*Groups/[a-zA-Z0-9/_+-]{2}|[a-zA-Z0-9/_+-]{2})([a-zA-Z0-9/_+-]{18})([a-zA-Z0-9/_+-]{2})(==|__)");
    private static final String GROUP_V1_ID_CENSOR = "*".repeat(18);
    private static final Pattern GROUP_V2_ID_PATTERN = Pattern.compile("(/org/asamk/Signal/.*Groups/[a-zA-Z0-9/_+-]{2}|[a-zA-Z0-9/_+-]{2})([a-zA-Z0-9/_+-]{39})([a-zA-Z0-9/_+-]{2})([=_])");
    private static final String GROUP_V2_ID_CENSOR = "*".repeat(39);
    private static final Pattern CRUDE_EMAIL_PATTERN = Pattern.compile("\\b([^\\s/])([^\\s/]*@[^\\s]+)");
    private static final String EMAIL_CENSOR = "...@...";
    private static final Pattern UUID_PATTERN = Pattern.compile("(JOB::)?([0-9a-f]{8}[-_][0-9a-f]{4}[-_][0-9a-f]{4}[-_][0-9a-f]{4}[-_][0-9a-f]{10})([0-9a-f]{2})", 2);
    private static final String UUID_CENSOR = "********-****-****-****-**********";
    private static final Pattern IPV4_PATTERN = Pattern.compile("\\b(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\b");
    private static final String IPV4_CENSOR = "...ipv4...";
    private static final Pattern DOMAIN_PATTERN = Pattern.compile("([a-z0-9]+\\.)+([a-z0-9\\-]*[a-z\\-][a-z0-9\\-]*)", 2);
    private static final String DOMAIN_CENSOR = "***.";
    private static final Set<String> TOP_100_TLDS = new HashSet<String>(Arrays.asList("com", "net", "org", "jp", "de", "uk", "fr", "br", "it", "ru", "es", "me", "gov", "pl", "ca", "au", "cn", "co", "in", "nl", "edu", "info", "eu", "ch", "id", "at", "kr", "cz", "mx", "be", "tv", "se", "tr", "tw", "al", "ua", "ir", "vn", "cl", "sk", "ly", "cc", "to", "no", "fi", "us", "pt", "dk", "ar", "hu", "tk", "gr", "il", "news", "ro", "my", "biz", "ie", "za", "nz", "sg", "ee", "th", "io", "xyz", "pe", "bg", "hk", "lt", "link", "ph", "club", "si", "site", "mobi", "by", "cat", "wiki", "la", "ga", "xxx", "cf", "hr", "ng", "jobs", "online", "kz", "ug", "gq", "ae", "is", "lv", "pro", "fm", "tips", "ms", "sa", "app"));

    private Scrubber() {
    }

    public static CharSequence scrub(CharSequence in) {
        in = Scrubber.scrubUuids(in);
        in = Scrubber.scrubE164(in);
        in = Scrubber.scrubEmail(in);
        in = Scrubber.scrubGroupV2Ids(in);
        in = Scrubber.scrubGroupV1Ids(in);
        in = Scrubber.scrubDomains(in);
        in = Scrubber.scrubIpv4(in);
        return in;
    }

    private static CharSequence scrubE164(CharSequence in) {
        return Scrubber.scrub(in, E164_PATTERN, (matcher, output) -> output.append(matcher.group(1)).append(E164_CENSOR, 0, matcher.group(2).length()).append(matcher.group(3)));
    }

    private static CharSequence scrubGroupV1Ids(CharSequence in) {
        return Scrubber.scrub(in, GROUP_V1_ID_PATTERN, (matcher, output) -> output.append(matcher.group(1)).append(GROUP_V1_ID_CENSOR, 0, matcher.group(2).length()).append(matcher.group(3)));
    }

    private static CharSequence scrubGroupV2Ids(CharSequence in) {
        return Scrubber.scrub(in, GROUP_V2_ID_PATTERN, (matcher, output) -> output.append(matcher.group(1)).append(GROUP_V2_ID_CENSOR, 0, matcher.group(2).length()).append(matcher.group(3)));
    }

    private static CharSequence scrubEmail(CharSequence in) {
        return Scrubber.scrub(in, CRUDE_EMAIL_PATTERN, (matcher, output) -> output.append(matcher.group(1)).append(EMAIL_CENSOR));
    }

    private static CharSequence scrubUuids(CharSequence in) {
        return Scrubber.scrub(in, UUID_PATTERN, (matcher, output) -> {
            if (matcher.group(1) != null && !matcher.group(1).isEmpty()) {
                output.append(matcher.group(1)).append(matcher.group(2)).append(matcher.group(3));
            } else {
                output.append(UUID_CENSOR).append(matcher.group(3));
            }
        });
    }

    private static CharSequence scrubDomains(CharSequence in) {
        return Scrubber.scrub(in, DOMAIN_PATTERN, (matcher, output) -> {
            String match = matcher.group(0);
            if (matcher.groupCount() == 2 && TOP_100_TLDS.contains(matcher.group(2).toLowerCase(Locale.US)) && !match.endsWith("whispersystems.org") && !match.endsWith("signal.org")) {
                output.append(DOMAIN_CENSOR).append(matcher.group(2));
            } else {
                output.append(match);
            }
        });
    }

    private static CharSequence scrubIpv4(CharSequence in) {
        return Scrubber.scrub(in, IPV4_PATTERN, (matcher, output) -> output.append(IPV4_CENSOR));
    }

    private static CharSequence scrub(CharSequence in, Pattern pattern, ProcessMatch processMatch) {
        StringBuilder output = new StringBuilder(in.length());
        Matcher matcher = pattern.matcher(in);
        int lastEndingPos = 0;
        while (matcher.find()) {
            output.append(in, lastEndingPos, matcher.start());
            processMatch.scrubMatch(matcher, output);
            lastEndingPos = matcher.end();
        }
        if (lastEndingPos == 0) {
            return in;
        }
        output.append(in, lastEndingPos, in.length());
        return output;
    }

    private static interface ProcessMatch {
        public void scrubMatch(Matcher var1, StringBuilder var2);
    }
}

