/*
 * Decompiled with CFR 0.152.
 */
package org.whispersystems.signalservice.internal.push;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.IOException;
import org.signal.core.util.Base64;

public class SenderCertificate {
    @JsonProperty
    @JsonDeserialize(using=ByteArrayDesieralizer.class)
    @JsonSerialize(using=ByteArraySerializer.class)
    public byte[] certificate;

    public byte[] getCertificate() {
        return this.certificate;
    }

    public static class ByteArrayDesieralizer
    extends JsonDeserializer<byte[]> {
        public byte[] deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            return Base64.decode((String)p.getValueAsString());
        }
    }

    public static class ByteArraySerializer
    extends JsonSerializer<byte[]> {
        public void serialize(byte[] value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            gen.writeString(Base64.encodeWithPadding((byte[])value));
        }
    }
}

