/*
 * Decompiled with CFR 0.152.
 */
package org.asamk.signal.manager.api;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.asamk.signal.manager.api.StickerPackId;
import org.asamk.signal.manager.util.Utils;
import org.whispersystems.signalservice.internal.util.Hex;
import org.whispersystems.signalservice.internal.util.Util;

public record StickerPackUrl(StickerPackId packId, byte[] packKey) {
    public static StickerPackUrl fromUri(URI uri) throws InvalidStickerPackLinkException {
        byte[] packKey;
        StickerPackId packId;
        String rawQuery = uri.getRawFragment();
        if (Util.isEmpty((String)rawQuery)) {
            throw new InvalidStickerPackLinkException("Invalid sticker pack uri");
        }
        Map<String, String> query = Utils.getQueryMap(rawQuery);
        String packIdString = query.get("pack_id");
        String packKeyString = query.get("pack_key");
        if (Util.isEmpty((String)packIdString) || Util.isEmpty((String)packKeyString)) {
            throw new InvalidStickerPackLinkException("Incomplete sticker pack uri");
        }
        try {
            packId = StickerPackId.deserialize(Hex.fromStringCondensed((String)packIdString));
        }
        catch (IOException e) {
            throw new InvalidStickerPackLinkException("Invalid sticker pack", e);
        }
        try {
            packKey = Hex.fromStringCondensed((String)packKeyString);
        }
        catch (IOException e) {
            throw new InvalidStickerPackLinkException("Invalid sticker pack uri", e);
        }
        return new StickerPackUrl(packId, packKey);
    }

    public URI getUrl() {
        try {
            return new URI("https", "signal.art", "/addstickers/", "pack_id=" + URLEncoder.encode(Hex.toStringCondensed((byte[])this.packId.serialize()), StandardCharsets.UTF_8) + "&pack_key=" + URLEncoder.encode(Hex.toStringCondensed((byte[])this.packKey), StandardCharsets.UTF_8));
        }
        catch (URISyntaxException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static final class InvalidStickerPackLinkException
    extends Exception {
        public InvalidStickerPackLinkException(String message) {
            super(message);
        }

        public InvalidStickerPackLinkException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

