with Ada.Strings.Fixed;
with Ada.Text_IO;

with GNAT.OS_Lib;
with GNATCOLL.Utils;
with GPR2.Utils;

package body Test_Helper is

   -----------
   -- Image --
   -----------

   function Image (Command : Argument_List) return String
   is
      Result : Unbounded_String;
      Quote  : constant Character := '"';
   begin
      for Arg of Command loop
         if Length (Result) > 0 then
            Append (Result, " ");
         end if;

         if Ada.Strings.Fixed.Index (Arg, " ") > 0 then
            Append (Result, Quote);
            Append (Result, Arg);
            Append (Result, Quote);
         else
            Append (Result, Arg);
         end if;
      end loop;

      return To_String (Result);
   end Image;

   --------------
   -- Image_RF --
   --------------

   function Image_RF (Path    : Path_Name.Object;
                      Command : Unbounded_String) return String
   is
      Result    : Unbounded_String;
      Local_Cmd : Unbounded_String;
   begin
      if not Path.Is_Defined then
         return "";
      end if;

      Append (Result, "Response file @");
      Append (Result, String (Path.Simple_Name));
      Append (Result, " : {");

      declare
         function Replace (Item : String) return Boolean;
         function Replace (Item : String) return Boolean is
         begin
            if GNATCOLL.Utils.Starts_With (Item, "<at>") then
               Append (Local_Cmd, "<at>path_to_file:primary<LF>");
            else
               Append (Local_Cmd, Item & "<LF>");
            end if;

            return True;
         end Replace;
      begin
         GNATCOLL.Utils.Split
           (Str      => To_String (Command),
            On       => "<LF>",
            For_Each => Replace'Access);
      end;

      Append (Result, Local_Cmd);
      Append (Result, "}");

      return To_String (Result);
   end Image_RF;

   -------------------
   -- New_Test_Case --
   -------------------

   procedure New_Test_Case (Message : String := "") is
   begin
      Ada.Text_IO.Put ("[ Test case" & Test_Cases'Img & " ]");
      if Message /= "" then
         Ada.Text_IO.Put (" - [ " & Message & " ]");
      end if;
      Ada.Text_IO.New_Line;
      Test_Cases := Test_Cases + 1;
   end New_Test_Case;

end Test_Helper;
