/*
 * Decompiled with CFR 0.152.
 */
package de.focus_shift.jollyday.core.parser.functions;

import de.focus_shift.jollyday.core.parser.predicates.ValidMovingCondition;
import de.focus_shift.jollyday.core.spi.Movable;
import java.time.LocalDate;
import java.time.temporal.TemporalAdjusters;
import java.util.Optional;
import java.util.function.Function;

public class MoveDateRelative
implements Function<Movable, Optional<LocalDate>> {
    private final LocalDate date;

    public MoveDateRelative(LocalDate date) {
        this.date = date;
    }

    @Override
    public Optional<LocalDate> apply(Movable movable) {
        return movable.conditions().stream().filter(new ValidMovingCondition(this.date)).map(condition -> this.date.with(condition.with() == Movable.MovingCondition.With.NEXT ? TemporalAdjusters.nextOrSame(condition.weekday()) : TemporalAdjusters.previousOrSame(condition.weekday()))).findFirst();
    }
}

