import _extends from "@babel/runtime/helpers/extends";
import React, { forwardRef } from 'react';
import { useAnalyticsEvents } from '../hooks/useAnalyticsEvents';
import { usePatchedProps } from '../hooks/usePatchedProps';
const withAnalyticsEvents = (createEventMap = {}) => WrappedComponent => {
  const WithAnalyticsEvents = /*#__PURE__*/forwardRef((props, ref) => {
    const {
      patchedEventProps
    } = usePatchedProps(createEventMap, props);
    const {
      createAnalyticsEvent
    } = useAnalyticsEvents();
    return /*#__PURE__*/React.createElement(WrappedComponent, _extends({}, props, patchedEventProps, {
      createAnalyticsEvent: createAnalyticsEvent,
      ref: ref
    }));
  });
  WithAnalyticsEvents.displayName = `WithAnalyticsEvents(${WrappedComponent.displayName || WrappedComponent.name})`;
  return WithAnalyticsEvents;
};
export default withAnalyticsEvents;