"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
var _typeof = require("@babel/runtime/helpers/typeof");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UNSAFE_useColorModeForMigration = UNSAFE_useColorModeForMigration;
exports.default = void 0;
exports.useColorMode = useColorMode;
exports.useSetColorMode = useSetColorMode;
exports.useSetTheme = useSetTheme;
exports.useTheme = useTheme;
var _regenerator = _interopRequireDefault(require("@babel/runtime/regenerator"));
var _asyncToGenerator2 = _interopRequireDefault(require("@babel/runtime/helpers/asyncToGenerator"));
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _slicedToArray2 = _interopRequireDefault(require("@babel/runtime/helpers/slicedToArray"));
var _react = _interopRequireWildcard(require("react"));
var _bindEventListener = require("bind-event-listener");
var _platformFeatureFlags = require("@atlaskit/platform-feature-flags");
var _tokens = require("@atlaskit/tokens");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { (0, _defineProperty2.default)(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
var defaultThemeSettings = function defaultThemeSettings() {
  return {
    dark: 'dark',
    light: 'light',
    spacing: 'spacing',
    typography: (0, _platformFeatureFlags.fg)('platform-default-typography-modernized') ? 'typography-modernized' : undefined
  };
};
var ColorModeContext = /*#__PURE__*/(0, _react.createContext)(undefined);
var SetColorModeContext = /*#__PURE__*/(0, _react.createContext)(undefined);
var ThemeContext = /*#__PURE__*/(0, _react.createContext)(undefined);
var SetThemeContext = /*#__PURE__*/(0, _react.createContext)(undefined);

/**
 * __UNSAFE_useColorModeForMigration()__
 *
 * Returns the current color mode when inside the app provider.
 * Unlike useColorMode, this utility returns undefined, instead of throwing an error, when the app provider is missing.
 * This allows it to be used by components that need to operate with and without an app provider.
 */
function UNSAFE_useColorModeForMigration() {
  var value = (0, _react.useContext)(ColorModeContext);
  return value;
}

/**
 * __useColorMode()__
 *
 * Returns the current color mode when inside the app provider.
 */
function useColorMode() {
  var value = (0, _react.useContext)(ColorModeContext);
  if (!value) {
    throw new Error('useColorMode must be used within AppProvider.');
  }
  return value;
}

/**
 * __useSetColorMode()__
 *
 * Returns the color mode setter when inside the app provider.
 */
function useSetColorMode() {
  var value = (0, _react.useContext)(SetColorModeContext);
  if (!value) {
    throw new Error('useSetColorMode must be used within AppProvider.');
  }
  return value;
}

/**
 * __useTheme()__
 *
 * Returns the current theme settings when inside the app provider.
 */
function useTheme() {
  var theme = (0, _react.useContext)(ThemeContext);
  var _useState = (0, _react.useState)(theme || (0, _tokens.getGlobalTheme)()),
    _useState2 = (0, _slicedToArray2.default)(_useState, 2),
    resolvedTheme = _useState2[0],
    setResolvedTheme = _useState2[1];
  (0, _react.useEffect)(function () {
    // We are using theme from context so no need to reference the DOM
    if (theme) {
      return;
    }
    var observer = new _tokens.ThemeMutationObserver(setResolvedTheme);
    observer.observe();
    return function () {
      return observer.disconnect();
    };
  }, [theme]);
  return resolvedTheme;
}

/**
 * __useSetTheme()__
 *
 * Returns the theme setter when inside the app provider.
 */
function useSetTheme() {
  var value = (0, _react.useContext)(SetThemeContext);
  if (!value) {
    throw new Error('useSetTheme must be used within AppProvider.');
  }
  return value;
}
var isMatchMediaAvailable = typeof window !== 'undefined' && 'matchMedia' in window;
var prefersDarkModeMql = isMatchMediaAvailable ? window.matchMedia('(prefers-color-scheme: dark)') : undefined;

// TODO: currently 'auto' color mode will always return 'light' in SSR.
// Additional work required: https://product-fabric.atlassian.net/browse/DSP-9781
function getReconciledColorMode(colorMode) {
  if (colorMode === 'auto') {
    return prefersDarkModeMql !== null && prefersDarkModeMql !== void 0 && prefersDarkModeMql.matches ? 'dark' : 'light';
  }
  return colorMode;
}
/**
 * __Theme provider__
 *
 * Provides global theming configuration.
 *
 * @internal
 */
function ThemeProvider(_ref) {
  var children = _ref.children,
    defaultColorMode = _ref.defaultColorMode,
    defaultTheme = _ref.defaultTheme;
  var _useState3 = (0, _react.useState)(defaultColorMode),
    _useState4 = (0, _slicedToArray2.default)(_useState3, 2),
    chosenColorMode = _useState4[0],
    setChosenColorMode = _useState4[1];
  var _useState5 = (0, _react.useState)(getReconciledColorMode(defaultColorMode)),
    _useState6 = (0, _slicedToArray2.default)(_useState5, 2),
    reconciledColorMode = _useState6[0],
    setReconciledColorMode = _useState6[1];
  var _useState7 = (0, _react.useState)(function () {
      return _objectSpread(_objectSpread({}, defaultThemeSettings()), defaultTheme);
    }),
    _useState8 = (0, _slicedToArray2.default)(_useState7, 2),
    theme = _useState8[0],
    setTheme = _useState8[1];
  var setColorMode = (0, _react.useCallback)(function (colorMode) {
    setChosenColorMode(colorMode);
    setReconciledColorMode(getReconciledColorMode(colorMode));
  }, []);
  var setPartialTheme = (0, _react.useCallback)(function (nextTheme) {
    setTheme(function (theme) {
      return _objectSpread(_objectSpread({}, theme), nextTheme);
    });
  }, []);
  var lastSetGlobalThemePromiseRef = (0, _react.useRef)(null);
  (0, _react.useEffect)(function () {
    /**
     * We need to wait for any previous `setGlobalTheme` calls to finish before calling it again.
     * This is to prevent race conditions as `setGlobalTheme` is async and mutates the DOM (e.g. sets the
     * `data-color-mode` attribute on the root element).
     *
     * Since we can't safely abort the `setGlobalTheme` execution, we need to wait for it to properly finish before
     * applying the new theme.
     *
     * Without this, we can end up in the following scenario:
     * 1. app loads with the default 'light' theme, kicking off `setGlobalTheme`
     * 2. app switches to 'dark' theme after retrieving value persisted in local storage, calling `setGlobalTheme` again
     * 3. `setGlobalTheme` function execution for `dark` finishes before the initial `light` execution
     * 4. `setGlobalTheme` function execution for `light` then finishes, resulting in the 'light' theme being applied.
     */
    var cleanupLastFnCall = /*#__PURE__*/function () {
      var _ref2 = (0, _asyncToGenerator2.default)( /*#__PURE__*/_regenerator.default.mark(function _callee() {
        var unbindFn;
        return _regenerator.default.wrap(function _callee$(_context) {
          while (1) switch (_context.prev = _context.next) {
            case 0:
              if (!lastSetGlobalThemePromiseRef.current) {
                _context.next = 6;
                break;
              }
              _context.next = 3;
              return lastSetGlobalThemePromiseRef.current;
            case 3:
              unbindFn = _context.sent;
              unbindFn();
              lastSetGlobalThemePromiseRef.current = null;
            case 6:
            case "end":
              return _context.stop();
          }
        }, _callee);
      }));
      return function cleanupLastFnCall() {
        return _ref2.apply(this, arguments);
      };
    }();
    var safelySetGlobalTheme = /*#__PURE__*/function () {
      var _ref3 = (0, _asyncToGenerator2.default)( /*#__PURE__*/_regenerator.default.mark(function _callee2() {
        var promise;
        return _regenerator.default.wrap(function _callee2$(_context2) {
          while (1) switch (_context2.prev = _context2.next) {
            case 0:
              _context2.next = 2;
              return cleanupLastFnCall();
            case 2:
              promise = (0, _tokens.setGlobalTheme)(_objectSpread(_objectSpread({}, theme), {}, {
                colorMode: reconciledColorMode
              }));
              lastSetGlobalThemePromiseRef.current = promise;
            case 4:
            case "end":
              return _context2.stop();
          }
        }, _callee2);
      }));
      return function safelySetGlobalTheme() {
        return _ref3.apply(this, arguments);
      };
    }();
    safelySetGlobalTheme();
    return function cleanup() {
      cleanupLastFnCall();
    };
  }, [theme, reconciledColorMode]);
  (0, _react.useEffect)(function () {
    if (!prefersDarkModeMql) {
      return;
    }
    var unbindListener = (0, _bindEventListener.bind)(prefersDarkModeMql, {
      type: 'change',
      listener: function listener(event) {
        if (chosenColorMode === 'auto') {
          setReconciledColorMode(event.matches ? 'dark' : 'light');
        }
      }
    });
    return unbindListener;
  }, [chosenColorMode]);
  return /*#__PURE__*/_react.default.createElement(ColorModeContext.Provider, {
    value: reconciledColorMode
  }, /*#__PURE__*/_react.default.createElement(SetColorModeContext.Provider, {
    value: setColorMode
  }, /*#__PURE__*/_react.default.createElement(ThemeContext.Provider, {
    value: theme
  }, /*#__PURE__*/_react.default.createElement(SetThemeContext.Provider, {
    value: setPartialTheme
  }, children))));
}
var _default = exports.default = ThemeProvider;