"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.findElement = findElement;
exports.findElementAll = findElementAll;
exports.getElement = getElement;
var _rbdInvariant = require("../drag-drop-context/rbd-invariant");
/**
 * Each fragment consists of an attribute name, with an optional value.
 */

/**
 * Joins selector fragments into a single selector.
 *
 * @example
 * getSelector(
 *   // If we care about the value of the attribute
 *   { attribute: 'my-attribute', value: 'my-value' },
 *   // If we only care about existence of the attribute
 *   { attribute: 'another-attribute' },
 * ) === '[my-attribute="my-value"][another-attribute]'
 */
function getSelector() {
  for (var _len = arguments.length, fragments = new Array(_len), _key = 0; _key < _len; _key++) {
    fragments[_key] = arguments[_key];
  }
  var parts = fragments.map(function (_ref) {
    var attribute = _ref.attribute,
      value = _ref.value;
    if (value) {
      // `CSS.escape` is widely supported, the lint rule is wrong.
      // It avoids problems caused by some values which are not valid in
      // selectors.
      return "[".concat(attribute, "=\"").concat(CSS.escape(value), "\"]");
    }
    return "[".concat(attribute, "]");
  });
  return parts.join('');
}

/**
 * Queries an element based on the provided selector fragments.
 */
function findElement() {
  var selector = getSelector.apply(void 0, arguments);
  return document.querySelector(selector);
}
function findElementAll() {
  var selector = getSelector.apply(void 0, arguments);
  return Array.from(document.querySelectorAll(selector));
}

/**
 * Queries an element, ensuring it exists.
 */
function getElement() {
  var result = findElement.apply(void 0, arguments);
  (0, _rbdInvariant.rbdInvariant)(result, 'There is a matching HTMLElement for selector ' + getSelector.apply(void 0, arguments));
  return result;
}