/**
 * @jsxRuntime classic
 * @jsx jsx
 */
import React from 'react';

// eslint-disable-next-line @atlaskit/ui-styling-standard/use-compiled -- Ignored via go/DSP-18766
import { css, jsx } from '@emotion/react';
import { parseXcss } from '../xcss/xcss';
var baseStyles = css({
  boxSizing: 'border-box'
});
var blockBleedMap = {
  'space.025': css({
    marginBlock: "var(--ds-space-negative-025, -0.125rem)"
  }),
  'space.050': css({
    marginBlock: "var(--ds-space-negative-050, -0.25rem)"
  }),
  'space.100': css({
    marginBlock: "var(--ds-space-negative-100, -0.5rem)"
  }),
  'space.150': css({
    marginBlock: "var(--ds-space-negative-150, -0.75rem)"
  }),
  'space.200': css({
    marginBlock: "var(--ds-space-negative-200, -1rem)"
  })
};
var inlineBleedMap = {
  'space.025': css({
    marginInline: "var(--ds-space-negative-025, -0.125rem)"
  }),
  'space.050': css({
    marginInline: "var(--ds-space-negative-050, -0.25rem)"
  }),
  'space.100': css({
    marginInline: "var(--ds-space-negative-100, -0.5rem)"
  }),
  'space.150': css({
    marginInline: "var(--ds-space-negative-150, -0.75rem)"
  }),
  'space.200': css({
    marginInline: "var(--ds-space-negative-200, -1rem)"
  })
};

/**
 * __Bleed__
 *
 * `Bleed` is a primitive layout component that controls negative whitespace.
 *
 * - [Examples](https://atlassian.design/components/primitives/bleed/examples)
 * - [Code](https://atlassian.design/components/primitives/bleed/code)
 */
var Bleed = /*#__PURE__*/React.memo(function (_ref) {
  var children = _ref.children,
    testId = _ref.testId,
    inline = _ref.inline,
    block = _ref.block,
    all = _ref.all,
    xcss = _ref.xcss;
  var resolvedStyles = parseXcss(xcss);
  return jsx("div", {
    // eslint-disable-next-line @atlaskit/ui-styling-standard/no-classname-prop -- Ignored via go/DSP-18766
    className: resolvedStyles.static,
    css: [baseStyles, (inline || all) && inlineBleedMap[inline || all], (block || all) && blockBleedMap[block || all], resolvedStyles.emotion],
    "data-testid": testId
  }, children);
});
Bleed.displayName = 'Bleed';
export default Bleed;