function _define_property(obj,key,value){if(key in obj){Object.defineProperty(obj,key,{value:value,enumerable:true,configurable:true,writable:true})}else{obj[key]=value}return obj}import{DateTime as LuxonDateTime}from"luxon";export class DateTime{get isDateTime(){return true}get isValid(){return this.dateTime.isValid}get year(){return this.dateTime.year}get month(){return this.dateTime.month}get day(){return this.dateTime.day}get hour(){return this.dateTime.hour}get minute(){return this.dateTime.minute}get second(){return this.dateTime.second}static fromMillis(milliseconds){return new DateTime(LuxonDateTime.fromMillis(milliseconds*1e3))}static local(year,month,day,hour,minute,second,millisecond){return new DateTime(LuxonDateTime.local(year,month,day,hour,minute,second,millisecond))}static utc(year,month,day,hour,minute,second,millisecond){return new DateTime(LuxonDateTime.utc(year,month,day,hour,minute,second,millisecond))}static fromIsoString(isoString,opts){return new DateTime(LuxonDateTime.fromISO(isoString,opts))}toJsDate(){return this.dateTime.toJSDate()}valueOf(){return this.dateTime.toMillis()}equals(other){return this.dateTime.equals(other.dateTime)}diff(other){return this.dateTime.diff(other.dateTime)}toTimeString(){return this.toFormat("HH:mm")}toIsoString(){return this.toFormat("yyyy-MM-dd'T'HH:mmZZZ")}toLocalIsoString(){return this.dateTime.toISO({includeOffset:true,includePrefix:false})}toFormat(formatString){return this.dateTime.toFormat(formatString)}add(object){return new DateTime(this.dateTime.plus(object))}unsignedSubtractDays(other){let result=this.dateTime.diff(other.dateTime,"days").days;result=Math.max(0,result);return Math.ceil(result)}unsignedSubstractMinutes(other){let result=this.dateTime.diff(other.dateTime,"minutes").minutes;result=Math.max(0,result);return Math.ceil(result)}stripTime(){if(!this.isValid){throw new Error("Date is invalid")}const dateTime=this.dateTime;return DateTime.utc(dateTime.year,dateTime.month,dateTime.day)}toString(){this.dateTime.toString()}toIntlFormat(){return new Intl.DateTimeFormat("en-GB",{dateStyle:"short",timeStyle:"short"}).format(this.toJsDate())}constructor(dateTime){_define_property(this,"dateTime",void 0);this.dateTime=dateTime?dateTime:dateTime.utc()}}
//# sourceMappingURL=DateTime.js.map